/* geary-revokable.c generated by valac 0.56.3, the Vala compiler
 * generated from geary-revokable.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <glib.h>
#include <gio/gio.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

enum  {
	GEARY_REVOKABLE_0_PROPERTY,
	GEARY_REVOKABLE_VALID_PROPERTY,
	GEARY_REVOKABLE_IN_PROCESS_PROPERTY,
	GEARY_REVOKABLE_NUM_PROPERTIES
};
static GParamSpec* geary_revokable_properties[GEARY_REVOKABLE_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _GearyRevokableRevokeAsyncData GearyRevokableRevokeAsyncData;
typedef struct _GearyRevokableCommitAsyncData GearyRevokableCommitAsyncData;
enum  {
	GEARY_REVOKABLE_REVOKED_SIGNAL,
	GEARY_REVOKABLE_COMMITTED_SIGNAL,
	GEARY_REVOKABLE_NUM_SIGNALS
};
static guint geary_revokable_signals[GEARY_REVOKABLE_NUM_SIGNALS] = {0};

struct _GearyRevokablePrivate {
	gboolean _valid;
	gboolean _in_process;
	guint commit_timeout_id;
};

struct _GearyRevokableRevokeAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyRevokable* self;
	GCancellable* cancellable;
	gboolean _tmp0_;
	GError* _tmp1_;
	gboolean _tmp2_;
	GError* _tmp3_;
	GError* _inner_error1_;
	GError* _inner_error0_;
};

struct _GearyRevokableCommitAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyRevokable* self;
	GCancellable* cancellable;
	gboolean _tmp0_;
	GError* _tmp1_;
	gboolean _tmp2_;
	GError* _tmp3_;
	GError* _inner_error1_;
	GError* _inner_error0_;
};

static gint GearyRevokable_private_offset;
static gpointer geary_revokable_parent_class = NULL;

static void geary_revokable_cancel_timed_commit (GearyRevokable* self);
static void geary_revokable_set_valid (GearyRevokable* self,
                                gboolean value);
static gboolean geary_revokable_on_timed_commit (GearyRevokable* self);
static gboolean _geary_revokable_on_timed_commit_gsource_func (gpointer self);
static void _geary_revokable_cancel_timed_commit_geary_revokable_revoked (GearyRevokable* _sender,
                                                                   gpointer self);
static void _geary_revokable_cancel_timed_commit_geary_revokable_committed (GearyRevokable* _sender,
                                                                     GearyRevokable* commit_revokable,
                                                                     gpointer self);
static void __lambda103_ (GearyRevokable* self);
static void ___lambda103__g_object_notify (GObject* _sender,
                                    GParamSpec* pspec,
                                    gpointer self);
static void geary_revokable_real_notify_revoked (GearyRevokable* self);
static void geary_revokable_real_notify_committed (GearyRevokable* self,
                                            GearyRevokable* commit_revokable);
static void geary_revokable_real_revoke_async_data_free (gpointer _data);
static void geary_revokable_real_revoke_async (GearyRevokable* self,
                                        GCancellable* cancellable,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
static gboolean geary_revokable_real_revoke_async_co (GearyRevokableRevokeAsyncData* _data_);
static void geary_revokable_revoke_async_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_);
static void geary_revokable_real_commit_async_data_free (gpointer _data);
static void geary_revokable_real_commit_async (GearyRevokable* self,
                                        GCancellable* cancellable,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
static gboolean geary_revokable_real_commit_async_co (GearyRevokableCommitAsyncData* _data_);
static void geary_revokable_commit_async_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_);
static void geary_revokable_finalize (GObject * obj);
static GType geary_revokable_get_type_once (void);
static void _vala_geary_revokable_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec);
static void _vala_geary_revokable_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec);

static inline gpointer
geary_revokable_get_instance_private (GearyRevokable* self)
{
	return G_STRUCT_MEMBER_P (self, GearyRevokable_private_offset);
}

gboolean
geary_revokable_get_valid (GearyRevokable* self)
{
	gboolean result;
	g_return_val_if_fail (GEARY_IS_REVOKABLE (self), FALSE);
	result = self->priv->_valid;
	return result;
}

static void
geary_revokable_set_valid (GearyRevokable* self,
                           gboolean value)
{
	gboolean old_value;
	g_return_if_fail (GEARY_IS_REVOKABLE (self));
	old_value = geary_revokable_get_valid (self);
	if (old_value != value) {
		self->priv->_valid = value;
		g_object_notify_by_pspec ((GObject *) self, geary_revokable_properties[GEARY_REVOKABLE_VALID_PROPERTY]);
	}
}

gboolean
geary_revokable_get_in_process (GearyRevokable* self)
{
	gboolean result;
	g_return_val_if_fail (GEARY_IS_REVOKABLE (self), FALSE);
	result = self->priv->_in_process;
	return result;
}

void
geary_revokable_set_in_process (GearyRevokable* self,
                                gboolean value)
{
	gboolean old_value;
	g_return_if_fail (GEARY_IS_REVOKABLE (self));
	old_value = geary_revokable_get_in_process (self);
	if (old_value != value) {
		self->priv->_in_process = value;
		g_object_notify_by_pspec ((GObject *) self, geary_revokable_properties[GEARY_REVOKABLE_IN_PROCESS_PROPERTY]);
	}
}

/**
     * Create a {@link Revokable} with optional parameters.
     *
     * If commit_timeout_sec is nonzero, Revokable will automatically call {@link commit_async}
     * after the timeout expires if it is still {@link valid}.
     */
static gboolean
_geary_revokable_on_timed_commit_gsource_func (gpointer self)
{
	gboolean result;
	result = geary_revokable_on_timed_commit ((GearyRevokable*) self);
	return result;
}

static void
_geary_revokable_cancel_timed_commit_geary_revokable_revoked (GearyRevokable* _sender,
                                                              gpointer self)
{
	geary_revokable_cancel_timed_commit ((GearyRevokable*) self);
}

static void
_geary_revokable_cancel_timed_commit_geary_revokable_committed (GearyRevokable* _sender,
                                                                GearyRevokable* commit_revokable,
                                                                gpointer self)
{
	geary_revokable_cancel_timed_commit ((GearyRevokable*) self);
}

static void
__lambda103_ (GearyRevokable* self)
{
	gboolean _tmp0_;
	_tmp0_ = self->priv->_valid;
	if (!_tmp0_) {
		geary_revokable_cancel_timed_commit (self);
	}
}

static void
___lambda103__g_object_notify (GObject* _sender,
                               GParamSpec* pspec,
                               gpointer self)
{
	__lambda103_ ((GearyRevokable*) self);
}

GearyRevokable*
geary_revokable_construct (GType object_type,
                           gint commit_timeout_sec)
{
	GearyRevokable * self = NULL;
	gchar* _tmp0_;
	self = (GearyRevokable*) geary_base_object_construct (object_type);
	if (commit_timeout_sec == 0) {
		return self;
	}
	self->priv->commit_timeout_id = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) commit_timeout_sec, _geary_revokable_on_timed_commit_gsource_func, g_object_ref (self), g_object_unref);
	g_signal_connect_object (self, "revoked", (GCallback) _geary_revokable_cancel_timed_commit_geary_revokable_revoked, self, 0);
	g_signal_connect_object (self, "committed", (GCallback) _geary_revokable_cancel_timed_commit_geary_revokable_committed, self, 0);
	_tmp0_ = g_strconcat ("notify::", GEARY_REVOKABLE_PROP_VALID, NULL);
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject), _tmp0_, (GCallback) ___lambda103__g_object_notify, self, 0);
	_g_free0 (_tmp0_);
	return self;
}

static void
geary_revokable_real_notify_revoked (GearyRevokable* self)
{
	g_signal_emit (self, geary_revokable_signals[GEARY_REVOKABLE_REVOKED_SIGNAL], 0);
}

void
geary_revokable_notify_revoked (GearyRevokable* self)
{
	GearyRevokableClass* _klass_;
	g_return_if_fail (GEARY_IS_REVOKABLE (self));
	_klass_ = GEARY_REVOKABLE_GET_CLASS (self);
	if (_klass_->notify_revoked) {
		_klass_->notify_revoked (self);
	}
}

static void
geary_revokable_real_notify_committed (GearyRevokable* self,
                                       GearyRevokable* commit_revokable)
{
	g_return_if_fail ((commit_revokable == NULL) || GEARY_IS_REVOKABLE (commit_revokable));
	g_signal_emit (self, geary_revokable_signals[GEARY_REVOKABLE_COMMITTED_SIGNAL], 0, commit_revokable);
}

void
geary_revokable_notify_committed (GearyRevokable* self,
                                  GearyRevokable* commit_revokable)
{
	GearyRevokableClass* _klass_;
	g_return_if_fail (GEARY_IS_REVOKABLE (self));
	_klass_ = GEARY_REVOKABLE_GET_CLASS (self);
	if (_klass_->notify_committed) {
		_klass_->notify_committed (self, commit_revokable);
	}
}

/**
     * Mark the {@link Revokable} as invalid.
     *
     * Once invalid, a Revokable may never transit back to a valid state.
     *
     * @see valid
     */
void
geary_revokable_set_invalid (GearyRevokable* self)
{
	g_return_if_fail (GEARY_IS_REVOKABLE (self));
	geary_revokable_set_valid (self, FALSE);
}

static void
geary_revokable_real_revoke_async_data_free (gpointer _data)
{
	GearyRevokableRevokeAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyRevokableRevokeAsyncData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
geary_revokable_real_revoke_async (GearyRevokable* self,
                                   GCancellable* cancellable,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_)
{
	GearyRevokableRevokeAsyncData* _data_;
	GearyRevokable* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearyRevokableRevokeAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_revokable_real_revoke_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	geary_revokable_real_revoke_async_co (_data_);
}

static void
geary_revokable_real_revoke_finish (GearyRevokable* self,
                                    GAsyncResult* _res_,
                                    GError** error)
{
	GearyRevokableRevokeAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
     * Revoke (undo) the operation.
     *
     * If the call throws an Error that does not necessarily mean the {@link Revokable} is
     * invalid.  Check {@link valid}.
     *
     * @throws EngineError.ALREADY_OPEN if {@link in_process} is true.  EngineError.ALREADY_CLOSED
     * if {@link valid} is false.
     */
static void
geary_revokable_revoke_async_ready (GObject* source_object,
                                    GAsyncResult* _res_,
                                    gpointer _user_data_)
{
	GearyRevokableRevokeAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_revokable_real_revoke_async_co (_data_);
}

static gboolean
geary_revokable_real_revoke_async_co (GearyRevokableRevokeAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_in_process;
	if (_data_->_tmp0_) {
		_data_->_tmp1_ = g_error_new_literal (GEARY_ENGINE_ERROR, GEARY_ENGINE_ERROR_ALREADY_OPEN, "Already revoking or committing operation");
		_data_->_inner_error0_ = _data_->_tmp1_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = _data_->self->priv->_valid;
	if (!_data_->_tmp2_) {
		_data_->_tmp3_ = g_error_new_literal (GEARY_ENGINE_ERROR, GEARY_ENGINE_ERROR_ALREADY_CLOSED, "Revokable not valid");
		_data_->_inner_error0_ = _data_->_tmp3_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	geary_revokable_set_in_process (_data_->self, TRUE);
	{
		_data_->_state_ = 1;
		geary_revokable_internal_revoke_async (_data_->self, _data_->cancellable, geary_revokable_revoke_async_ready, _data_);
		return FALSE;
		_state_1:
		geary_revokable_internal_revoke_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __finally0;
		}
	}
	__finally0:
	{
		geary_revokable_set_in_process (_data_->self, FALSE);
	}
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
geary_revokable_revoke_async (GearyRevokable* self,
                              GCancellable* cancellable,
                              GAsyncReadyCallback _callback_,
                              gpointer _user_data_)
{
	GearyRevokableClass* _klass_;
	_klass_ = GEARY_REVOKABLE_GET_CLASS (self);
	if (_klass_->revoke_async) {
		_klass_->revoke_async (self, cancellable, _callback_, _user_data_);
	}
}

void
geary_revokable_revoke_finish (GearyRevokable* self,
                               GAsyncResult* _res_,
                               GError** error)
{
	GearyRevokableClass* _klass_;
	_klass_ = GEARY_REVOKABLE_GET_CLASS (self);
	if (_klass_->revoke_finish) {
		_klass_->revoke_finish (self, _res_, error);
	}
}

void
geary_revokable_internal_revoke_async (GearyRevokable* self,
                                       GCancellable* cancellable,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_)
{
	GearyRevokableClass* _klass_;
	_klass_ = GEARY_REVOKABLE_GET_CLASS (self);
	if (_klass_->internal_revoke_async) {
		_klass_->internal_revoke_async (self, cancellable, _callback_, _user_data_);
	}
}

void
geary_revokable_internal_revoke_finish (GearyRevokable* self,
                                        GAsyncResult* _res_,
                                        GError** error)
{
	GearyRevokableClass* _klass_;
	_klass_ = GEARY_REVOKABLE_GET_CLASS (self);
	if (_klass_->internal_revoke_finish) {
		_klass_->internal_revoke_finish (self, _res_, error);
	}
}

static void
geary_revokable_real_commit_async_data_free (gpointer _data)
{
	GearyRevokableCommitAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyRevokableCommitAsyncData, _data_);
}

static void
geary_revokable_real_commit_async (GearyRevokable* self,
                                   GCancellable* cancellable,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_)
{
	GearyRevokableCommitAsyncData* _data_;
	GearyRevokable* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearyRevokableCommitAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_revokable_real_commit_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	geary_revokable_real_commit_async_co (_data_);
}

static void
geary_revokable_real_commit_finish (GearyRevokable* self,
                                    GAsyncResult* _res_,
                                    GError** error)
{
	GearyRevokableCommitAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
     * Commits (completes) the operation immediately.
     *
     * Some {@link Revokable} operations work by delaying the operation until time has passed or
     * some situation occurs which requires the operation to complete.  This call forces the
     * operation to complete immediately rather than delay it for later.
     *
     * Even if the operation "actually" commits and is not delayed, calling commit_async() will
     * make this Revokable invalid.
     *
     * @throws EngineError.ALREADY_OPEN if {@link in_process} is true.  EngineError.ALREADY_CLOSED
     * if {@link valid} is false.
     */
static void
geary_revokable_commit_async_ready (GObject* source_object,
                                    GAsyncResult* _res_,
                                    gpointer _user_data_)
{
	GearyRevokableCommitAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_revokable_real_commit_async_co (_data_);
}

static gboolean
geary_revokable_real_commit_async_co (GearyRevokableCommitAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_in_process;
	if (_data_->_tmp0_) {
		_data_->_tmp1_ = g_error_new_literal (GEARY_ENGINE_ERROR, GEARY_ENGINE_ERROR_ALREADY_OPEN, "Already revoking or committing operation");
		_data_->_inner_error0_ = _data_->_tmp1_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = _data_->self->priv->_valid;
	if (!_data_->_tmp2_) {
		_data_->_tmp3_ = g_error_new_literal (GEARY_ENGINE_ERROR, GEARY_ENGINE_ERROR_ALREADY_CLOSED, "Revokable not valid");
		_data_->_inner_error0_ = _data_->_tmp3_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	geary_revokable_set_in_process (_data_->self, TRUE);
	{
		_data_->_state_ = 1;
		geary_revokable_internal_commit_async (_data_->self, _data_->cancellable, geary_revokable_commit_async_ready, _data_);
		return FALSE;
		_state_1:
		geary_revokable_internal_commit_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __finally0;
		}
	}
	__finally0:
	{
		geary_revokable_set_in_process (_data_->self, FALSE);
	}
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
geary_revokable_commit_async (GearyRevokable* self,
                              GCancellable* cancellable,
                              GAsyncReadyCallback _callback_,
                              gpointer _user_data_)
{
	GearyRevokableClass* _klass_;
	_klass_ = GEARY_REVOKABLE_GET_CLASS (self);
	if (_klass_->commit_async) {
		_klass_->commit_async (self, cancellable, _callback_, _user_data_);
	}
}

void
geary_revokable_commit_finish (GearyRevokable* self,
                               GAsyncResult* _res_,
                               GError** error)
{
	GearyRevokableClass* _klass_;
	_klass_ = GEARY_REVOKABLE_GET_CLASS (self);
	if (_klass_->commit_finish) {
		_klass_->commit_finish (self, _res_, error);
	}
}

void
geary_revokable_internal_commit_async (GearyRevokable* self,
                                       GCancellable* cancellable,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_)
{
	GearyRevokableClass* _klass_;
	_klass_ = GEARY_REVOKABLE_GET_CLASS (self);
	if (_klass_->internal_commit_async) {
		_klass_->internal_commit_async (self, cancellable, _callback_, _user_data_);
	}
}

void
geary_revokable_internal_commit_finish (GearyRevokable* self,
                                        GAsyncResult* _res_,
                                        GError** error)
{
	GearyRevokableClass* _klass_;
	_klass_ = GEARY_REVOKABLE_GET_CLASS (self);
	if (_klass_->internal_commit_finish) {
		_klass_->internal_commit_finish (self, _res_, error);
	}
}

static gboolean
geary_revokable_on_timed_commit (GearyRevokable* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean result;
	g_return_val_if_fail (GEARY_IS_REVOKABLE (self), FALSE);
	self->priv->commit_timeout_id = (guint) 0;
	_tmp1_ = self->priv->_valid;
	if (_tmp1_) {
		gboolean _tmp2_;
		_tmp2_ = self->priv->_in_process;
		_tmp0_ = !_tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		geary_revokable_commit_async (self, NULL, NULL, NULL);
	}
	result = FALSE;
	return result;
}

static void
geary_revokable_cancel_timed_commit (GearyRevokable* self)
{
	g_return_if_fail (GEARY_IS_REVOKABLE (self));
	if (self->priv->commit_timeout_id == ((guint) 0)) {
		return;
	}
	g_source_remove (self->priv->commit_timeout_id);
	self->priv->commit_timeout_id = (guint) 0;
}

static void
geary_revokable_class_init (GearyRevokableClass * klass,
                            gpointer klass_data)
{
	geary_revokable_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyRevokable_private_offset);
	((GearyRevokableClass *) klass)->notify_revoked = (void (*) (GearyRevokable*)) geary_revokable_real_notify_revoked;
	((GearyRevokableClass *) klass)->notify_committed = (void (*) (GearyRevokable*, GearyRevokable*)) geary_revokable_real_notify_committed;
	((GearyRevokableClass *) klass)->revoke_async = (void (*) (GearyRevokable*, GCancellable*, GAsyncReadyCallback, gpointer)) geary_revokable_real_revoke_async;
	((GearyRevokableClass *) klass)->revoke_finish = (void (*) (GearyRevokable*, GAsyncResult*, GError**)) geary_revokable_real_revoke_finish;
	((GearyRevokableClass *) klass)->commit_async = (void (*) (GearyRevokable*, GCancellable*, GAsyncReadyCallback, gpointer)) geary_revokable_real_commit_async;
	((GearyRevokableClass *) klass)->commit_finish = (void (*) (GearyRevokable*, GAsyncResult*, GError**)) geary_revokable_real_commit_finish;
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_revokable_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_geary_revokable_set_property;
	G_OBJECT_CLASS (klass)->finalize = geary_revokable_finalize;
	/**
	     * Indicates if {@link revoke_async} or {@link commit_async} are valid operations for this
	     * {@link Revokable}.
	     *
	     * Due to later operations or notifications, it's possible for the Revokable to go invalid
	     * after being issued to the caller.
	     *
	     * @see set_invalid
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_REVOKABLE_VALID_PROPERTY, geary_revokable_properties[GEARY_REVOKABLE_VALID_PROPERTY] = g_param_spec_boolean ("valid", "valid", "valid", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * Indicates a {@link revoke_async} or {@link commit_async} operation is underway.
	     *
	     * Only one operation can occur at a time, and when complete the {@link Revokable} will be
	     * invalid.
	     *
	     * @see valid
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_REVOKABLE_IN_PROCESS_PROPERTY, geary_revokable_properties[GEARY_REVOKABLE_IN_PROCESS_PROPERTY] = g_param_spec_boolean ("in-process", "in-process", "in-process", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * Fired when the {@link Revokable} has been revoked.
	     *
	     * {@link valid} will still be true when this is fired.
	     */
	geary_revokable_signals[GEARY_REVOKABLE_REVOKED_SIGNAL] = g_signal_new ("revoked", GEARY_TYPE_REVOKABLE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	/**
	     * Fired when the {@link Revokable} has been committed.
	     *
	     * Some Revokables will offer a new Revokable to allow revoking the committed state.
	     *
	     * {@link valid} will still be true when this is fired.
	     */
	geary_revokable_signals[GEARY_REVOKABLE_COMMITTED_SIGNAL] = g_signal_new ("committed", GEARY_TYPE_REVOKABLE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEARY_TYPE_REVOKABLE);
}

static void
geary_revokable_instance_init (GearyRevokable * self,
                               gpointer klass)
{
	self->priv = geary_revokable_get_instance_private (self);
	self->priv->_valid = TRUE;
	self->priv->_in_process = FALSE;
	self->priv->commit_timeout_id = (guint) 0;
}

static void
geary_revokable_finalize (GObject * obj)
{
	GearyRevokable * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_TYPE_REVOKABLE, GearyRevokable);
	geary_revokable_cancel_timed_commit (self);
	G_OBJECT_CLASS (geary_revokable_parent_class)->finalize (obj);
}

/**
 * A representation of an operation with the Geary Engine that may be revoked (undone) at a later
 * time.
 *
 * The Revokable will do everything it can to commit the operation (if necessary) when its final
 * ref is dropped.  However, since the final ref can be dropped at an indeterminate time, it's
 * advised that callers force the matter by scheduling it with {@link commit_async}.
 */
 G_GNUC_NO_INLINE static GType
geary_revokable_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyRevokableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_revokable_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyRevokable), 0, (GInstanceInitFunc) geary_revokable_instance_init, NULL };
	GType geary_revokable_type_id;
	geary_revokable_type_id = g_type_register_static (GEARY_TYPE_BASE_OBJECT, "GearyRevokable", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	GearyRevokable_private_offset = g_type_add_instance_private (geary_revokable_type_id, sizeof (GearyRevokablePrivate));
	return geary_revokable_type_id;
}

GType
geary_revokable_get_type (void)
{
	static gsize geary_revokable_type_id__once = 0;
	if (g_once_init_enter (&geary_revokable_type_id__once)) {
		GType geary_revokable_type_id;
		geary_revokable_type_id = geary_revokable_get_type_once ();
		g_once_init_leave (&geary_revokable_type_id__once, geary_revokable_type_id);
	}
	return geary_revokable_type_id__once;
}

static void
_vala_geary_revokable_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec)
{
	GearyRevokable * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_TYPE_REVOKABLE, GearyRevokable);
	switch (property_id) {
		case GEARY_REVOKABLE_VALID_PROPERTY:
		g_value_set_boolean (value, geary_revokable_get_valid (self));
		break;
		case GEARY_REVOKABLE_IN_PROCESS_PROPERTY:
		g_value_set_boolean (value, geary_revokable_get_in_process (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_geary_revokable_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec)
{
	GearyRevokable * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_TYPE_REVOKABLE, GearyRevokable);
	switch (property_id) {
		case GEARY_REVOKABLE_VALID_PROPERTY:
		geary_revokable_set_valid (self, g_value_get_boolean (value));
		break;
		case GEARY_REVOKABLE_IN_PROCESS_PROPERTY:
		geary_revokable_set_in_process (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

