/* geary-search-query.c generated by valac 0.56.3, the Vala compiler
 * generated from geary-search-query.vala, do not modify */

/*
 * Copyright © 2016 Software Freedom Conservancy Inc.
 * Copyright © 2019-2020 Michael Gratton <mike@vee.met>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later). See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>

enum  {
	GEARY_SEARCH_QUERY_0_PROPERTY,
	GEARY_SEARCH_QUERY_EXPRESSION_PROPERTY,
	GEARY_SEARCH_QUERY_RAW_PROPERTY,
	GEARY_SEARCH_QUERY_NUM_PROPERTIES
};
static GParamSpec* geary_search_query_properties[GEARY_SEARCH_QUERY_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
enum  {
	GEARY_SEARCH_QUERY_TERM_0_PROPERTY,
	GEARY_SEARCH_QUERY_TERM_IS_NEGATED_PROPERTY,
	GEARY_SEARCH_QUERY_TERM_NUM_PROPERTIES
};
static GParamSpec* geary_search_query_term_properties[GEARY_SEARCH_QUERY_TERM_NUM_PROPERTIES];
enum  {
	GEARY_SEARCH_QUERY_EMAIL_TEXT_TERM_0_PROPERTY,
	GEARY_SEARCH_QUERY_EMAIL_TEXT_TERM_TARGET_PROPERTY,
	GEARY_SEARCH_QUERY_EMAIL_TEXT_TERM_MATCHING_STRATEGY_PROPERTY,
	GEARY_SEARCH_QUERY_EMAIL_TEXT_TERM_TERMS_PROPERTY,
	GEARY_SEARCH_QUERY_EMAIL_TEXT_TERM_NUM_PROPERTIES
};
static GParamSpec* geary_search_query_email_text_term_properties[GEARY_SEARCH_QUERY_EMAIL_TEXT_TERM_NUM_PROPERTIES];
enum  {
	GEARY_SEARCH_QUERY_EMAIL_FLAG_TERM_0_PROPERTY,
	GEARY_SEARCH_QUERY_EMAIL_FLAG_TERM_VALUE_PROPERTY,
	GEARY_SEARCH_QUERY_EMAIL_FLAG_TERM_NUM_PROPERTIES
};
static GParamSpec* geary_search_query_email_flag_term_properties[GEARY_SEARCH_QUERY_EMAIL_FLAG_TERM_NUM_PROPERTIES];

struct _GearySearchQueryPrivate {
	GeeList* _expression;
	GeeList* _rw_expression;
	gchar* _raw;
};

struct _GearySearchQueryTermPrivate {
	gboolean _is_negated;
};

struct _GearySearchQueryEmailTextTermPrivate {
	GearySearchQueryEmailTextTermProperty _target;
	GearySearchQueryStrategy _matching_strategy;
	GeeList* _terms;
};

struct _GearySearchQueryEmailFlagTermPrivate {
	GearyNamedFlag* _value;
};

static gint GearySearchQuery_private_offset;
static gpointer geary_search_query_parent_class = NULL;
static gint GearySearchQueryTerm_private_offset;
static gpointer geary_search_query_term_parent_class = NULL;
static gint GearySearchQueryEmailTextTerm_private_offset;
static gpointer geary_search_query_email_text_term_parent_class = NULL;
static gint GearySearchQueryEmailFlagTerm_private_offset;
static gpointer geary_search_query_email_flag_term_parent_class = NULL;

VALA_EXTERN gboolean geary_search_query_strategy_is_stemming_enabled (GearySearchQueryStrategy self);
VALA_EXTERN gint geary_search_query_strategy_get_min_term_length_for_stemming (GearySearchQueryStrategy self);
VALA_EXTERN gint geary_search_query_strategy_get_max_difference_term_stem_lengths (GearySearchQueryStrategy self);
static void geary_search_query_set_expression (GearySearchQuery* self,
                                        GeeList* value);
static void geary_search_query_set_raw (GearySearchQuery* self,
                                 const gchar* value);
static gboolean geary_search_query_term_real_equal_to (GearySearchQueryTerm* self,
                                                GearySearchQueryTerm* other);
static gchar* geary_search_query_term_real_to_string (GearySearchQueryTerm* self);
static void geary_search_query_term_finalize (GObject * obj);
static GType geary_search_query_term_get_type_once (void);
static void _vala_geary_search_query_term_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec);
static void _vala_geary_search_query_term_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec);
static void geary_search_query_email_text_term_set_target (GearySearchQueryEmailTextTerm* self,
                                                    GearySearchQueryEmailTextTermProperty value);
static void geary_search_query_email_text_term_set_matching_strategy (GearySearchQueryEmailTextTerm* self,
                                                               GearySearchQueryStrategy value);
static void geary_search_query_email_text_term_set_terms (GearySearchQueryEmailTextTerm* self,
                                                   GeeList* value);
static gboolean geary_search_query_email_text_term_real_equal_to (GearySearchQueryTerm* base,
                                                           GearySearchQueryTerm* other);
static gchar* geary_search_query_email_text_term_real_to_string (GearySearchQueryTerm* base);
static void geary_search_query_email_text_term_finalize (GObject * obj);
static GType geary_search_query_email_text_term_get_type_once (void);
static void _vala_geary_search_query_email_text_term_get_property (GObject * object,
                                                            guint property_id,
                                                            GValue * value,
                                                            GParamSpec * pspec);
static void _vala_geary_search_query_email_text_term_set_property (GObject * object,
                                                            guint property_id,
                                                            const GValue * value,
                                                            GParamSpec * pspec);
static void geary_search_query_email_flag_term_set_value (GearySearchQueryEmailFlagTerm* self,
                                                   GearyNamedFlag* value);
static gboolean geary_search_query_email_flag_term_real_equal_to (GearySearchQueryTerm* base,
                                                           GearySearchQueryTerm* other);
static gchar* geary_search_query_email_flag_term_real_to_string (GearySearchQueryTerm* base);
static void geary_search_query_email_flag_term_finalize (GObject * obj);
static GType geary_search_query_email_flag_term_get_type_once (void);
static void _vala_geary_search_query_email_flag_term_get_property (GObject * object,
                                                            guint property_id,
                                                            GValue * value,
                                                            GParamSpec * pspec);
static void _vala_geary_search_query_email_flag_term_set_property (GObject * object,
                                                            guint property_id,
                                                            const GValue * value,
                                                            GParamSpec * pspec);
static void geary_search_query_finalize (GObject * obj);
static GType geary_search_query_get_type_once (void);
static void _vala_geary_search_query_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);
static void _vala_geary_search_query_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec);

static inline gpointer
geary_search_query_get_instance_private (GearySearchQuery* self)
{
	return G_STRUCT_MEMBER_P (self, GearySearchQuery_private_offset);
}

/**
     * An advisory parameter regarding search quality, scope, and breadth.
     *
     * The Engine can perform searches based on (unspecified, uncontracted) textual variations of
     * a query's search terms.  Some of those variations may produce undesirable results due to
     * "greedy" matching of terms.  The Strategy parameter allows for an advisory to the Engine
     * about how to use those textual variants, if any at all.
     *
     * This may be respected or ignored by the Engine.  In particular, there's no guarantee it will
     * have any effect on server search.
     */
/** Determines if stemming may be used for an operator. */
gboolean
geary_search_query_strategy_is_stemming_enabled (GearySearchQueryStrategy self)
{
	gboolean result;
	result = self != GEARY_SEARCH_QUERY_STRATEGY_EXACT;
	return result;
}

/**
         * The minimum term length before stemming is allowed.
         *
         * This prevents short words that might be stemmed from being stemmed.
         */
gint
geary_search_query_strategy_get_min_term_length_for_stemming (GearySearchQueryStrategy self)
{
	gint min = 0;
	gint result;
	min = 0;
	switch (self) {
		case GEARY_SEARCH_QUERY_STRATEGY_EXACT:
		{
			min = G_MAXINT;
			break;
		}
		case GEARY_SEARCH_QUERY_STRATEGY_CONSERVATIVE:
		{
			min = 6;
			break;
		}
		case GEARY_SEARCH_QUERY_STRATEGY_AGGRESSIVE:
		{
			min = 4;
			break;
		}
		case GEARY_SEARCH_QUERY_STRATEGY_HORIZON:
		{
			min = 0;
			break;
		}
		default:
		break;
	}
	result = min;
	return result;
}

/**
         * Maximum difference in lengths between term and stemmed variant.
         *
         * This prevents long words from being stemmed to much shorter
         * words (which creates opportunities for greedy matching).
         */
gint
geary_search_query_strategy_get_max_difference_term_stem_lengths (GearySearchQueryStrategy self)
{
	gint max = 0;
	gint result;
	max = 0;
	switch (self) {
		case GEARY_SEARCH_QUERY_STRATEGY_EXACT:
		{
			max = 0;
			break;
		}
		case GEARY_SEARCH_QUERY_STRATEGY_CONSERVATIVE:
		{
			max = 2;
			break;
		}
		case GEARY_SEARCH_QUERY_STRATEGY_AGGRESSIVE:
		{
			max = 4;
			break;
		}
		case GEARY_SEARCH_QUERY_STRATEGY_HORIZON:
		{
			max = G_MAXINT;
			break;
		}
		default:
		break;
	}
	result = max;
	return result;
}

 G_GNUC_NO_INLINE static GType
geary_search_query_strategy_get_type_once (void)
{
	static const GEnumValue values[] = {{GEARY_SEARCH_QUERY_STRATEGY_EXACT, "GEARY_SEARCH_QUERY_STRATEGY_EXACT", "exact"}, {GEARY_SEARCH_QUERY_STRATEGY_CONSERVATIVE, "GEARY_SEARCH_QUERY_STRATEGY_CONSERVATIVE", "conservative"}, {GEARY_SEARCH_QUERY_STRATEGY_AGGRESSIVE, "GEARY_SEARCH_QUERY_STRATEGY_AGGRESSIVE", "aggressive"}, {GEARY_SEARCH_QUERY_STRATEGY_HORIZON, "GEARY_SEARCH_QUERY_STRATEGY_HORIZON", "horizon"}, {0, NULL, NULL}};
	GType geary_search_query_strategy_type_id;
	geary_search_query_strategy_type_id = g_enum_register_static ("GearySearchQueryStrategy", values);
	return geary_search_query_strategy_type_id;
}

GType
geary_search_query_strategy_get_type (void)
{
	static gsize geary_search_query_strategy_type_id__once = 0;
	if (g_once_init_enter (&geary_search_query_strategy_type_id__once)) {
		GType geary_search_query_strategy_type_id;
		geary_search_query_strategy_type_id = geary_search_query_strategy_get_type_once ();
		g_once_init_leave (&geary_search_query_strategy_type_id__once, geary_search_query_strategy_type_id);
	}
	return geary_search_query_strategy_type_id__once;
}

GeeList*
geary_search_query_get_expression (GearySearchQuery* self)
{
	GeeList* result;
	GeeList* _tmp0_;
	g_return_val_if_fail (GEARY_IS_SEARCH_QUERY (self), NULL);
	_tmp0_ = self->priv->_expression;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
geary_search_query_set_expression (GearySearchQuery* self,
                                   GeeList* value)
{
	GeeList* old_value;
	g_return_if_fail (GEARY_IS_SEARCH_QUERY (self));
	old_value = geary_search_query_get_expression (self);
	if (old_value != value) {
		GeeList* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_expression);
		self->priv->_expression = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_search_query_properties[GEARY_SEARCH_QUERY_EXPRESSION_PROPERTY]);
	}
}

const gchar*
geary_search_query_get_raw (GearySearchQuery* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (GEARY_IS_SEARCH_QUERY (self), NULL);
	_tmp0_ = self->priv->_raw;
	result = _tmp0_;
	return result;
}

static void
geary_search_query_set_raw (GearySearchQuery* self,
                            const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (GEARY_IS_SEARCH_QUERY (self));
	old_value = geary_search_query_get_raw (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_raw);
		self->priv->_raw = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_search_query_properties[GEARY_SEARCH_QUERY_RAW_PROPERTY]);
	}
}

GearySearchQuery*
geary_search_query_construct (GType object_type,
                              GeeCollection* expression,
                              const gchar* raw)
{
	GearySearchQuery * self = NULL;
	GeeList* _tmp0_;
	GeeList* _tmp1_;
	GeeList* _tmp2_;
	GeeList* _tmp3_;
	GeeList* _tmp4_;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (expression, GEE_TYPE_COLLECTION), NULL);
	g_return_val_if_fail (raw != NULL, NULL);
	self = (GearySearchQuery*) geary_base_object_construct (object_type);
	_tmp0_ = self->priv->_rw_expression;
	gee_collection_add_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection), expression);
	_tmp1_ = self->priv->_rw_expression;
	_tmp2_ = gee_list_get_read_only_view (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	geary_search_query_set_expression (self, _tmp4_);
	_g_object_unref0 (_tmp4_);
	geary_search_query_set_raw (self, raw);
	return self;
}

/** Determines if this query's expression is equal to another's. */
gboolean
geary_search_query_equal_to (GearySearchQuery* self,
                             GearySearchQuery* other)
{
	GeeList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GeeList* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gboolean result;
	g_return_val_if_fail (GEARY_IS_SEARCH_QUERY (self), FALSE);
	g_return_val_if_fail (GEARY_IS_SEARCH_QUERY (other), FALSE);
	if (self == other) {
		result = TRUE;
		return result;
	}
	_tmp0_ = self->priv->_expression;
	_tmp1_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp2_ = _tmp1_;
	_tmp3_ = other->priv->_expression;
	_tmp4_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp5_ = _tmp4_;
	if (_tmp2_ != _tmp5_) {
		result = FALSE;
		return result;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				GeeList* _tmp8_;
				gint _tmp9_;
				gint _tmp10_;
				GeeList* _tmp11_;
				gpointer _tmp12_;
				GearySearchQueryTerm* _tmp13_;
				GeeList* _tmp14_;
				gpointer _tmp15_;
				GearySearchQueryTerm* _tmp16_;
				gboolean _tmp17_;
				if (!_tmp6_) {
					gint _tmp7_;
					_tmp7_ = i;
					i = _tmp7_ + 1;
				}
				_tmp6_ = FALSE;
				_tmp8_ = self->priv->_expression;
				_tmp9_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_COLLECTION, GeeCollection));
				_tmp10_ = _tmp9_;
				if (!(i < _tmp10_)) {
					break;
				}
				_tmp11_ = self->priv->_expression;
				_tmp12_ = gee_list_get (_tmp11_, i);
				_tmp13_ = (GearySearchQueryTerm*) _tmp12_;
				_tmp14_ = other->priv->_expression;
				_tmp15_ = gee_list_get (_tmp14_, i);
				_tmp16_ = (GearySearchQueryTerm*) _tmp15_;
				_tmp17_ = !geary_search_query_term_equal_to (_tmp13_, _tmp16_);
				_g_object_unref0 (_tmp16_);
				_g_object_unref0 (_tmp13_);
				if (_tmp17_) {
					result = FALSE;
					return result;
				}
			}
		}
	}
	result = TRUE;
	return result;
}

/** Returns a string representation of this query, for debugging. */
gchar*
geary_search_query_to_string (GearySearchQuery* self)
{
	GString* builder = NULL;
	GString* _tmp0_;
	GString* _tmp1_;
	const gchar* _tmp2_;
	GeeIterator* iter = NULL;
	GeeList* _tmp3_;
	GeeIterator* _tmp4_;
	GeeIterator* _tmp5_;
	GString* _tmp20_;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* result;
	g_return_val_if_fail (GEARY_IS_SEARCH_QUERY (self), NULL);
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	_tmp1_ = builder;
	_tmp2_ = self->priv->_raw;
	g_string_append_printf (_tmp1_, "\"%s\": ", _tmp2_);
	_tmp3_ = self->priv->_expression;
	_tmp4_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ITERABLE, GeeIterable));
	iter = _tmp4_;
	_tmp5_ = iter;
	if (gee_iterator_next (_tmp5_)) {
		GString* _tmp6_;
		GeeIterator* _tmp7_;
		gpointer _tmp8_;
		GearySearchQueryTerm* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp6_ = builder;
		_tmp7_ = iter;
		_tmp8_ = gee_iterator_get (_tmp7_);
		_tmp9_ = (GearySearchQueryTerm*) _tmp8_;
		_tmp10_ = geary_search_query_term_to_string (_tmp9_);
		_tmp11_ = _tmp10_;
		g_string_append (_tmp6_, _tmp11_);
		_g_free0 (_tmp11_);
		_g_object_unref0 (_tmp9_);
	}
	while (TRUE) {
		GeeIterator* _tmp12_;
		GString* _tmp13_;
		GString* _tmp14_;
		GeeIterator* _tmp15_;
		gpointer _tmp16_;
		GearySearchQueryTerm* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		_tmp12_ = iter;
		if (!gee_iterator_next (_tmp12_)) {
			break;
		}
		_tmp13_ = builder;
		g_string_append_c (_tmp13_, ',');
		_tmp14_ = builder;
		_tmp15_ = iter;
		_tmp16_ = gee_iterator_get (_tmp15_);
		_tmp17_ = (GearySearchQueryTerm*) _tmp16_;
		_tmp18_ = geary_search_query_term_to_string (_tmp17_);
		_tmp19_ = _tmp18_;
		g_string_append (_tmp14_, _tmp19_);
		_g_free0 (_tmp19_);
		_g_object_unref0 (_tmp17_);
	}
	_tmp20_ = builder;
	_tmp21_ = _tmp20_->str;
	_tmp22_ = g_strdup (_tmp21_);
	result = _tmp22_;
	_g_object_unref0 (iter);
	_g_string_free0 (builder);
	return result;
}

static inline gpointer
geary_search_query_term_get_instance_private (GearySearchQueryTerm* self)
{
	return G_STRUCT_MEMBER_P (self, GearySearchQueryTerm_private_offset);
}

gboolean
geary_search_query_term_get_is_negated (GearySearchQueryTerm* self)
{
	gboolean result;
	g_return_val_if_fail (GEARY_SEARCH_QUERY_IS_TERM (self), FALSE);
	result = self->priv->_is_negated;
	return result;
}

void
geary_search_query_term_set_is_negated (GearySearchQueryTerm* self,
                                        gboolean value)
{
	gboolean old_value;
	g_return_if_fail (GEARY_SEARCH_QUERY_IS_TERM (self));
	old_value = geary_search_query_term_get_is_negated (self);
	if (old_value != value) {
		self->priv->_is_negated = value;
		g_object_notify_by_pspec ((GObject *) self, geary_search_query_term_properties[GEARY_SEARCH_QUERY_TERM_IS_NEGATED_PROPERTY]);
	}
}

/** Determines if this term is equal to another. */
static gboolean
geary_search_query_term_real_equal_to (GearySearchQueryTerm* self,
                                       GearySearchQueryTerm* other)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (GEARY_SEARCH_QUERY_IS_TERM (other), FALSE);
	_tmp1_ = self->priv->_is_negated;
	_tmp2_ = other->priv->_is_negated;
	if (_tmp1_ == _tmp2_) {
		_tmp0_ = G_TYPE_FROM_INSTANCE (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject)) == G_TYPE_FROM_INSTANCE (G_TYPE_CHECK_INSTANCE_CAST (other, G_TYPE_OBJECT, GObject));
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

gboolean
geary_search_query_term_equal_to (GearySearchQueryTerm* self,
                                  GearySearchQueryTerm* other)
{
	GearySearchQueryTermClass* _klass_;
	g_return_val_if_fail (GEARY_SEARCH_QUERY_IS_TERM (self), FALSE);
	_klass_ = GEARY_SEARCH_QUERY_TERM_GET_CLASS (self);
	if (_klass_->equal_to) {
		return _klass_->equal_to (self, other);
	}
	return FALSE;
}

/** Returns a string representation, for debugging. */
static gchar*
geary_search_query_term_real_to_string (GearySearchQueryTerm* self)
{
	g_critical ("Type `%s' does not implement abstract method `geary_search_query_term_to_string'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

gchar*
geary_search_query_term_to_string (GearySearchQueryTerm* self)
{
	GearySearchQueryTermClass* _klass_;
	g_return_val_if_fail (GEARY_SEARCH_QUERY_IS_TERM (self), NULL);
	_klass_ = GEARY_SEARCH_QUERY_TERM_GET_CLASS (self);
	if (_klass_->to_string) {
		return _klass_->to_string (self);
	}
	return NULL;
}

GearySearchQueryTerm*
geary_search_query_term_construct (GType object_type)
{
	GearySearchQueryTerm * self = NULL;
	self = (GearySearchQueryTerm*) geary_base_object_construct (object_type);
	return self;
}

static void
geary_search_query_term_class_init (GearySearchQueryTermClass * klass,
                                    gpointer klass_data)
{
	geary_search_query_term_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearySearchQueryTerm_private_offset);
	((GearySearchQueryTermClass *) klass)->equal_to = (gboolean (*) (GearySearchQueryTerm*, GearySearchQueryTerm*)) geary_search_query_term_real_equal_to;
	((GearySearchQueryTermClass *) klass)->to_string = (gchar* (*) (GearySearchQueryTerm*)) geary_search_query_term_real_to_string;
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_search_query_term_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_geary_search_query_term_set_property;
	G_OBJECT_CLASS (klass)->finalize = geary_search_query_term_finalize;
	/** Determines opposite of the term is matched. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_SEARCH_QUERY_TERM_IS_NEGATED_PROPERTY, geary_search_query_term_properties[GEARY_SEARCH_QUERY_TERM_IS_NEGATED_PROPERTY] = g_param_spec_boolean ("is-negated", "is-negated", "is-negated", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
geary_search_query_term_instance_init (GearySearchQueryTerm * self,
                                       gpointer klass)
{
	self->priv = geary_search_query_term_get_instance_private (self);
	self->priv->_is_negated = FALSE;
}

static void
geary_search_query_term_finalize (GObject * obj)
{
	GearySearchQueryTerm * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_SEARCH_QUERY_TYPE_TERM, GearySearchQueryTerm);
	G_OBJECT_CLASS (geary_search_query_term_parent_class)->finalize (obj);
}

/**
     * Parent class for terms that make up a search query's expression.
     *
     * @see SearchQuery.expression
     */
 G_GNUC_NO_INLINE static GType
geary_search_query_term_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearySearchQueryTermClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_search_query_term_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearySearchQueryTerm), 0, (GInstanceInitFunc) geary_search_query_term_instance_init, NULL };
	GType geary_search_query_term_type_id;
	geary_search_query_term_type_id = g_type_register_static (GEARY_TYPE_BASE_OBJECT, "GearySearchQueryTerm", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	GearySearchQueryTerm_private_offset = g_type_add_instance_private (geary_search_query_term_type_id, sizeof (GearySearchQueryTermPrivate));
	return geary_search_query_term_type_id;
}

GType
geary_search_query_term_get_type (void)
{
	static gsize geary_search_query_term_type_id__once = 0;
	if (g_once_init_enter (&geary_search_query_term_type_id__once)) {
		GType geary_search_query_term_type_id;
		geary_search_query_term_type_id = geary_search_query_term_get_type_once ();
		g_once_init_leave (&geary_search_query_term_type_id__once, geary_search_query_term_type_id);
	}
	return geary_search_query_term_type_id__once;
}

static void
_vala_geary_search_query_term_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec)
{
	GearySearchQueryTerm * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_SEARCH_QUERY_TYPE_TERM, GearySearchQueryTerm);
	switch (property_id) {
		case GEARY_SEARCH_QUERY_TERM_IS_NEGATED_PROPERTY:
		g_value_set_boolean (value, geary_search_query_term_get_is_negated (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_geary_search_query_term_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec)
{
	GearySearchQueryTerm * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_SEARCH_QUERY_TYPE_TERM, GearySearchQueryTerm);
	switch (property_id) {
		case GEARY_SEARCH_QUERY_TERM_IS_NEGATED_PROPERTY:
		geary_search_query_term_set_is_negated (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
geary_search_query_email_text_term_get_instance_private (GearySearchQueryEmailTextTerm* self)
{
	return G_STRUCT_MEMBER_P (self, GearySearchQueryEmailTextTerm_private_offset);
}

/**
         * Supported text email properties that can be queried.
         *
         * @see EmailTextTerm
         */
 G_GNUC_NO_INLINE static GType
geary_search_query_email_text_term_property_get_type_once (void)
{
	static const GEnumValue values[] = {{GEARY_SEARCH_QUERY_EMAIL_TEXT_TERM_PROPERTY_ALL, "GEARY_SEARCH_QUERY_EMAIL_TEXT_TERM_PROPERTY_ALL", "all"}, {GEARY_SEARCH_QUERY_EMAIL_TEXT_TERM_PROPERTY_TO, "GEARY_SEARCH_QUERY_EMAIL_TEXT_TERM_PROPERTY_TO", "to"}, {GEARY_SEARCH_QUERY_EMAIL_TEXT_TERM_PROPERTY_CC, "GEARY_SEARCH_QUERY_EMAIL_TEXT_TERM_PROPERTY_CC", "cc"}, {GEARY_SEARCH_QUERY_EMAIL_TEXT_TERM_PROPERTY_BCC, "GEARY_SEARCH_QUERY_EMAIL_TEXT_TERM_PROPERTY_BCC", "bcc"}, {GEARY_SEARCH_QUERY_EMAIL_TEXT_TERM_PROPERTY_FROM, "GEARY_SEARCH_QUERY_EMAIL_TEXT_TERM_PROPERTY_FROM", "from"}, {GEARY_SEARCH_QUERY_EMAIL_TEXT_TERM_PROPERTY_SUBJECT, "GEARY_SEARCH_QUERY_EMAIL_TEXT_TERM_PROPERTY_SUBJECT", "subject"}, {GEARY_SEARCH_QUERY_EMAIL_TEXT_TERM_PROPERTY_BODY, "GEARY_SEARCH_QUERY_EMAIL_TEXT_TERM_PROPERTY_BODY", "body"}, {GEARY_SEARCH_QUERY_EMAIL_TEXT_TERM_PROPERTY_ATTACHMENT_NAME, "GEARY_SEARCH_QUERY_EMAIL_TEXT_TERM_PROPERTY_ATTACHMENT_NAME", "attachment-name"}, {0, NULL, NULL}};
	GType geary_search_query_email_text_term_property_type_id;
	geary_search_query_email_text_term_property_type_id = g_enum_register_static ("GearySearchQueryEmailTextTermProperty", values);
	return geary_search_query_email_text_term_property_type_id;
}

GType
geary_search_query_email_text_term_property_get_type (void)
{
	static gsize geary_search_query_email_text_term_property_type_id__once = 0;
	if (g_once_init_enter (&geary_search_query_email_text_term_property_type_id__once)) {
		GType geary_search_query_email_text_term_property_type_id;
		geary_search_query_email_text_term_property_type_id = geary_search_query_email_text_term_property_get_type_once ();
		g_once_init_leave (&geary_search_query_email_text_term_property_type_id__once, geary_search_query_email_text_term_property_type_id);
	}
	return geary_search_query_email_text_term_property_type_id__once;
}

GearySearchQueryEmailTextTermProperty
geary_search_query_email_text_term_get_target (GearySearchQueryEmailTextTerm* self)
{
	GearySearchQueryEmailTextTermProperty result;
	g_return_val_if_fail (GEARY_SEARCH_QUERY_IS_EMAIL_TEXT_TERM (self), 0);
	result = self->priv->_target;
	return result;
}

static void
geary_search_query_email_text_term_set_target (GearySearchQueryEmailTextTerm* self,
                                               GearySearchQueryEmailTextTermProperty value)
{
	GearySearchQueryEmailTextTermProperty old_value;
	g_return_if_fail (GEARY_SEARCH_QUERY_IS_EMAIL_TEXT_TERM (self));
	old_value = geary_search_query_email_text_term_get_target (self);
	if (old_value != value) {
		self->priv->_target = value;
		g_object_notify_by_pspec ((GObject *) self, geary_search_query_email_text_term_properties[GEARY_SEARCH_QUERY_EMAIL_TEXT_TERM_TARGET_PROPERTY]);
	}
}

GearySearchQueryStrategy
geary_search_query_email_text_term_get_matching_strategy (GearySearchQueryEmailTextTerm* self)
{
	GearySearchQueryStrategy result;
	g_return_val_if_fail (GEARY_SEARCH_QUERY_IS_EMAIL_TEXT_TERM (self), 0);
	result = self->priv->_matching_strategy;
	return result;
}

static void
geary_search_query_email_text_term_set_matching_strategy (GearySearchQueryEmailTextTerm* self,
                                                          GearySearchQueryStrategy value)
{
	GearySearchQueryStrategy old_value;
	g_return_if_fail (GEARY_SEARCH_QUERY_IS_EMAIL_TEXT_TERM (self));
	old_value = geary_search_query_email_text_term_get_matching_strategy (self);
	if (old_value != value) {
		self->priv->_matching_strategy = value;
		g_object_notify_by_pspec ((GObject *) self, geary_search_query_email_text_term_properties[GEARY_SEARCH_QUERY_EMAIL_TEXT_TERM_MATCHING_STRATEGY_PROPERTY]);
	}
}

GeeList*
geary_search_query_email_text_term_get_terms (GearySearchQueryEmailTextTerm* self)
{
	GeeList* result;
	GeeList* _tmp0_;
	g_return_val_if_fail (GEARY_SEARCH_QUERY_IS_EMAIL_TEXT_TERM (self), NULL);
	_tmp0_ = self->priv->_terms;
	result = _tmp0_;
	return result;
}

static void
geary_search_query_email_text_term_set_terms (GearySearchQueryEmailTextTerm* self,
                                              GeeList* value)
{
	GeeList* old_value;
	g_return_if_fail (GEARY_SEARCH_QUERY_IS_EMAIL_TEXT_TERM (self));
	old_value = geary_search_query_email_text_term_get_terms (self);
	if (old_value != value) {
		GeeList* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_terms);
		self->priv->_terms = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_search_query_email_text_term_properties[GEARY_SEARCH_QUERY_EMAIL_TEXT_TERM_TERMS_PROPERTY]);
	}
}

GearySearchQueryEmailTextTerm*
geary_search_query_email_text_term_construct (GType object_type,
                                              GearySearchQueryEmailTextTermProperty target,
                                              GearySearchQueryStrategy matching_strategy,
                                              const gchar* term)
{
	GearySearchQueryEmailTextTerm * self = NULL;
	GeeList* _tmp0_;
	g_return_val_if_fail (term != NULL, NULL);
	self = (GearySearchQueryEmailTextTerm*) geary_search_query_term_construct (object_type);
	geary_search_query_email_text_term_set_target (self, target);
	geary_search_query_email_text_term_set_matching_strategy (self, matching_strategy);
	_tmp0_ = self->priv->_terms;
	gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection), term);
	return self;
}

GearySearchQueryEmailTextTerm*
geary_search_query_email_text_term_new (GearySearchQueryEmailTextTermProperty target,
                                        GearySearchQueryStrategy matching_strategy,
                                        const gchar* term)
{
	return geary_search_query_email_text_term_construct (GEARY_SEARCH_QUERY_TYPE_EMAIL_TEXT_TERM, target, matching_strategy, term);
}

GearySearchQueryEmailTextTerm*
geary_search_query_email_text_term_construct_disjunction (GType object_type,
                                                          GearySearchQueryEmailTextTermProperty target,
                                                          GearySearchQueryStrategy matching_strategy,
                                                          GeeList* terms)
{
	GearySearchQueryEmailTextTerm * self = NULL;
	GeeList* _tmp0_;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (terms, GEE_TYPE_LIST), NULL);
	self = (GearySearchQueryEmailTextTerm*) geary_search_query_term_construct (object_type);
	geary_search_query_email_text_term_set_target (self, target);
	geary_search_query_email_text_term_set_matching_strategy (self, matching_strategy);
	_tmp0_ = self->priv->_terms;
	gee_collection_add_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (terms, GEE_TYPE_COLLECTION, GeeCollection));
	return self;
}

GearySearchQueryEmailTextTerm*
geary_search_query_email_text_term_new_disjunction (GearySearchQueryEmailTextTermProperty target,
                                                    GearySearchQueryStrategy matching_strategy,
                                                    GeeList* terms)
{
	return geary_search_query_email_text_term_construct_disjunction (GEARY_SEARCH_QUERY_TYPE_EMAIL_TEXT_TERM, target, matching_strategy, terms);
}

static gboolean
geary_search_query_email_text_term_real_equal_to (GearySearchQueryTerm* base,
                                                  GearySearchQueryTerm* other)
{
	GearySearchQueryEmailTextTerm * self;
	GearySearchQueryEmailTextTerm* text = NULL;
	GearySearchQueryEmailTextTerm* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GearySearchQueryEmailTextTermProperty _tmp3_;
	GearySearchQueryEmailTextTerm* _tmp4_;
	GearySearchQueryEmailTextTermProperty _tmp5_;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_SEARCH_QUERY_TYPE_EMAIL_TEXT_TERM, GearySearchQueryEmailTextTerm);
	g_return_val_if_fail (GEARY_SEARCH_QUERY_IS_TERM (other), FALSE);
	if (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_SEARCH_QUERY_TYPE_TERM, GearySearchQueryTerm) == other) {
		result = TRUE;
		return result;
	}
	if (!GEARY_SEARCH_QUERY_TERM_CLASS (geary_search_query_email_text_term_parent_class)->equal_to (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_SEARCH_QUERY_TYPE_TERM, GearySearchQueryTerm), other)) {
		result = FALSE;
		return result;
	}
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (other, GEARY_SEARCH_QUERY_TYPE_EMAIL_TEXT_TERM, GearySearchQueryEmailTextTerm));
	text = _tmp0_;
	_tmp3_ = self->priv->_target;
	_tmp4_ = text;
	_tmp5_ = _tmp4_->priv->_target;
	if (_tmp3_ != _tmp5_) {
		_tmp2_ = TRUE;
	} else {
		GearySearchQueryStrategy _tmp6_;
		GearySearchQueryEmailTextTerm* _tmp7_;
		GearySearchQueryStrategy _tmp8_;
		_tmp6_ = self->priv->_matching_strategy;
		_tmp7_ = text;
		_tmp8_ = _tmp7_->priv->_matching_strategy;
		_tmp2_ = _tmp6_ != _tmp8_;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		GeeList* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		GearySearchQueryEmailTextTerm* _tmp12_;
		GeeList* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		_tmp9_ = self->priv->_terms;
		_tmp10_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp11_ = _tmp10_;
		_tmp12_ = text;
		_tmp13_ = _tmp12_->priv->_terms;
		_tmp14_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp15_ = _tmp14_;
		_tmp1_ = _tmp11_ != _tmp15_;
	}
	if (_tmp1_) {
		result = FALSE;
		_g_object_unref0 (text);
		return result;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp16_ = FALSE;
			_tmp16_ = TRUE;
			while (TRUE) {
				GeeList* _tmp18_;
				gint _tmp19_;
				gint _tmp20_;
				GeeList* _tmp21_;
				gpointer _tmp22_;
				gchar* _tmp23_;
				GearySearchQueryEmailTextTerm* _tmp24_;
				GeeList* _tmp25_;
				gpointer _tmp26_;
				gchar* _tmp27_;
				gboolean _tmp28_;
				if (!_tmp16_) {
					gint _tmp17_;
					_tmp17_ = i;
					i = _tmp17_ + 1;
				}
				_tmp16_ = FALSE;
				_tmp18_ = self->priv->_terms;
				_tmp19_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, GEE_TYPE_COLLECTION, GeeCollection));
				_tmp20_ = _tmp19_;
				if (!(i < _tmp20_)) {
					break;
				}
				_tmp21_ = self->priv->_terms;
				_tmp22_ = gee_list_get (_tmp21_, i);
				_tmp23_ = (gchar*) _tmp22_;
				_tmp24_ = text;
				_tmp25_ = _tmp24_->priv->_terms;
				_tmp26_ = gee_list_get (_tmp25_, i);
				_tmp27_ = (gchar*) _tmp26_;
				_tmp28_ = g_strcmp0 (_tmp23_, _tmp27_) != 0;
				_g_free0 (_tmp27_);
				_g_free0 (_tmp23_);
				if (_tmp28_) {
					result = FALSE;
					_g_object_unref0 (text);
					return result;
				}
			}
		}
	}
	result = TRUE;
	_g_object_unref0 (text);
	return result;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static gchar*
geary_search_query_email_text_term_real_to_string (GearySearchQueryTerm* base)
{
	GearySearchQueryEmailTextTerm * self;
	GString* builder = NULL;
	GString* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GString* _tmp4_;
	GearySearchQueryEmailTextTermProperty _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	GString* _tmp10_;
	GString* _tmp11_;
	GearySearchQueryStrategy _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	GString* _tmp17_;
	GeeIterator* iter = NULL;
	GeeList* _tmp18_;
	GeeIterator* _tmp19_;
	GeeIterator* _tmp20_;
	GString* _tmp33_;
	GString* _tmp34_;
	const gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_SEARCH_QUERY_TYPE_EMAIL_TEXT_TERM, GearySearchQueryEmailTextTerm);
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	_tmp1_ = geary_search_query_term_get_is_negated (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_SEARCH_QUERY_TYPE_TERM, GearySearchQueryTerm));
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GString* _tmp3_;
		_tmp3_ = builder;
		g_string_append_c (_tmp3_, '!');
	}
	_tmp4_ = builder;
	_tmp5_ = self->priv->_target;
	_tmp6_ = geary_object_utils_to_enum_nick (GEARY_SEARCH_QUERY_EMAIL_TEXT_TERM_TYPE_PROPERTY, NULL, NULL, GEARY_SEARCH_QUERY_EMAIL_TEXT_TERM_TYPE_PROPERTY, (gpointer) ((gintptr) _tmp5_));
	_tmp7_ = _tmp6_;
	_tmp8_ = g_utf8_strup (_tmp7_, (gssize) -1);
	_tmp9_ = _tmp8_;
	g_string_append (_tmp4_, _tmp9_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp7_);
	_tmp10_ = builder;
	g_string_append_c (_tmp10_, ':');
	_tmp11_ = builder;
	_tmp12_ = self->priv->_matching_strategy;
	_tmp13_ = geary_object_utils_to_enum_nick (GEARY_SEARCH_QUERY_TYPE_STRATEGY, NULL, NULL, GEARY_SEARCH_QUERY_TYPE_STRATEGY, (gpointer) ((gintptr) _tmp12_));
	_tmp14_ = _tmp13_;
	_tmp15_ = g_utf8_strup (_tmp14_, (gssize) -1);
	_tmp16_ = _tmp15_;
	g_string_append (_tmp11_, _tmp16_);
	_g_free0 (_tmp16_);
	_g_free0 (_tmp14_);
	_tmp17_ = builder;
	g_string_append_c (_tmp17_, '(');
	_tmp18_ = self->priv->_terms;
	_tmp19_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, GEE_TYPE_ITERABLE, GeeIterable));
	iter = _tmp19_;
	_tmp20_ = iter;
	if (gee_iterator_next (_tmp20_)) {
		GString* _tmp21_;
		GeeIterator* _tmp22_;
		gpointer _tmp23_;
		gchar* _tmp24_;
		const gchar* _tmp25_;
		_tmp21_ = builder;
		_tmp22_ = iter;
		_tmp23_ = gee_iterator_get (_tmp22_);
		_tmp24_ = (gchar*) _tmp23_;
		_tmp25_ = string_to_string (_tmp24_);
		g_string_append (_tmp21_, _tmp25_);
		_g_free0 (_tmp24_);
	}
	while (TRUE) {
		GeeIterator* _tmp26_;
		GString* _tmp27_;
		GString* _tmp28_;
		GeeIterator* _tmp29_;
		gpointer _tmp30_;
		gchar* _tmp31_;
		const gchar* _tmp32_;
		_tmp26_ = iter;
		if (!gee_iterator_next (_tmp26_)) {
			break;
		}
		_tmp27_ = builder;
		g_string_append_c (_tmp27_, ',');
		_tmp28_ = builder;
		_tmp29_ = iter;
		_tmp30_ = gee_iterator_get (_tmp29_);
		_tmp31_ = (gchar*) _tmp30_;
		_tmp32_ = string_to_string (_tmp31_);
		g_string_append (_tmp28_, _tmp32_);
		_g_free0 (_tmp31_);
	}
	_tmp33_ = builder;
	g_string_append_c (_tmp33_, ')');
	_tmp34_ = builder;
	_tmp35_ = _tmp34_->str;
	_tmp36_ = g_strdup (_tmp35_);
	result = _tmp36_;
	_g_object_unref0 (iter);
	_g_string_free0 (builder);
	return result;
}

static void
geary_search_query_email_text_term_class_init (GearySearchQueryEmailTextTermClass * klass,
                                               gpointer klass_data)
{
	geary_search_query_email_text_term_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearySearchQueryEmailTextTerm_private_offset);
	((GearySearchQueryTermClass *) klass)->equal_to = (gboolean (*) (GearySearchQueryTerm*, GearySearchQueryTerm*)) geary_search_query_email_text_term_real_equal_to;
	((GearySearchQueryTermClass *) klass)->to_string = (gchar* (*) (GearySearchQueryTerm*)) geary_search_query_email_text_term_real_to_string;
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_search_query_email_text_term_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_geary_search_query_email_text_term_set_property;
	G_OBJECT_CLASS (klass)->finalize = geary_search_query_email_text_term_finalize;
	/** The email property this term applies to. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_SEARCH_QUERY_EMAIL_TEXT_TERM_TARGET_PROPERTY, geary_search_query_email_text_term_properties[GEARY_SEARCH_QUERY_EMAIL_TEXT_TERM_TARGET_PROPERTY] = g_param_spec_enum ("target", "target", "target", GEARY_SEARCH_QUERY_EMAIL_TEXT_TERM_TYPE_PROPERTY, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** The strategy used for matching the given terms. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_SEARCH_QUERY_EMAIL_TEXT_TERM_MATCHING_STRATEGY_PROPERTY, geary_search_query_email_text_term_properties[GEARY_SEARCH_QUERY_EMAIL_TEXT_TERM_MATCHING_STRATEGY_PROPERTY] = g_param_spec_enum ("matching-strategy", "matching-strategy", "matching-strategy", GEARY_SEARCH_QUERY_TYPE_STRATEGY, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	         * The strings to match against the given target.
	         *
	         * If more than one term is given, they are treated as the
	         * disjunction of all, that is they are combined using the
	         * Boolean OR function.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_SEARCH_QUERY_EMAIL_TEXT_TERM_TERMS_PROPERTY, geary_search_query_email_text_term_properties[GEARY_SEARCH_QUERY_EMAIL_TEXT_TERM_TERMS_PROPERTY] = g_param_spec_object ("terms", "terms", "terms", GEE_TYPE_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
geary_search_query_email_text_term_instance_init (GearySearchQueryEmailTextTerm * self,
                                                  gpointer klass)
{
	GeeArrayList* _tmp0_;
	self->priv = geary_search_query_email_text_term_get_instance_private (self);
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	self->priv->_terms = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_LIST, GeeList);
}

static void
geary_search_query_email_text_term_finalize (GObject * obj)
{
	GearySearchQueryEmailTextTerm * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_SEARCH_QUERY_TYPE_EMAIL_TEXT_TERM, GearySearchQueryEmailTextTerm);
	_g_object_unref0 (self->priv->_terms);
	G_OBJECT_CLASS (geary_search_query_email_text_term_parent_class)->finalize (obj);
}

/**
     * A term that matches text properties of an email.
     */
 G_GNUC_NO_INLINE static GType
geary_search_query_email_text_term_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearySearchQueryEmailTextTermClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_search_query_email_text_term_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearySearchQueryEmailTextTerm), 0, (GInstanceInitFunc) geary_search_query_email_text_term_instance_init, NULL };
	GType geary_search_query_email_text_term_type_id;
	geary_search_query_email_text_term_type_id = g_type_register_static (GEARY_SEARCH_QUERY_TYPE_TERM, "GearySearchQueryEmailTextTerm", &g_define_type_info, 0);
	GearySearchQueryEmailTextTerm_private_offset = g_type_add_instance_private (geary_search_query_email_text_term_type_id, sizeof (GearySearchQueryEmailTextTermPrivate));
	return geary_search_query_email_text_term_type_id;
}

GType
geary_search_query_email_text_term_get_type (void)
{
	static gsize geary_search_query_email_text_term_type_id__once = 0;
	if (g_once_init_enter (&geary_search_query_email_text_term_type_id__once)) {
		GType geary_search_query_email_text_term_type_id;
		geary_search_query_email_text_term_type_id = geary_search_query_email_text_term_get_type_once ();
		g_once_init_leave (&geary_search_query_email_text_term_type_id__once, geary_search_query_email_text_term_type_id);
	}
	return geary_search_query_email_text_term_type_id__once;
}

static void
_vala_geary_search_query_email_text_term_get_property (GObject * object,
                                                       guint property_id,
                                                       GValue * value,
                                                       GParamSpec * pspec)
{
	GearySearchQueryEmailTextTerm * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_SEARCH_QUERY_TYPE_EMAIL_TEXT_TERM, GearySearchQueryEmailTextTerm);
	switch (property_id) {
		case GEARY_SEARCH_QUERY_EMAIL_TEXT_TERM_TARGET_PROPERTY:
		g_value_set_enum (value, geary_search_query_email_text_term_get_target (self));
		break;
		case GEARY_SEARCH_QUERY_EMAIL_TEXT_TERM_MATCHING_STRATEGY_PROPERTY:
		g_value_set_enum (value, geary_search_query_email_text_term_get_matching_strategy (self));
		break;
		case GEARY_SEARCH_QUERY_EMAIL_TEXT_TERM_TERMS_PROPERTY:
		g_value_set_object (value, geary_search_query_email_text_term_get_terms (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_geary_search_query_email_text_term_set_property (GObject * object,
                                                       guint property_id,
                                                       const GValue * value,
                                                       GParamSpec * pspec)
{
	GearySearchQueryEmailTextTerm * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_SEARCH_QUERY_TYPE_EMAIL_TEXT_TERM, GearySearchQueryEmailTextTerm);
	switch (property_id) {
		case GEARY_SEARCH_QUERY_EMAIL_TEXT_TERM_TARGET_PROPERTY:
		geary_search_query_email_text_term_set_target (self, g_value_get_enum (value));
		break;
		case GEARY_SEARCH_QUERY_EMAIL_TEXT_TERM_MATCHING_STRATEGY_PROPERTY:
		geary_search_query_email_text_term_set_matching_strategy (self, g_value_get_enum (value));
		break;
		case GEARY_SEARCH_QUERY_EMAIL_TEXT_TERM_TERMS_PROPERTY:
		geary_search_query_email_text_term_set_terms (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
geary_search_query_email_flag_term_get_instance_private (GearySearchQueryEmailFlagTerm* self)
{
	return G_STRUCT_MEMBER_P (self, GearySearchQueryEmailFlagTerm_private_offset);
}

GearyNamedFlag*
geary_search_query_email_flag_term_get_value (GearySearchQueryEmailFlagTerm* self)
{
	GearyNamedFlag* result;
	GearyNamedFlag* _tmp0_;
	g_return_val_if_fail (GEARY_SEARCH_QUERY_IS_EMAIL_FLAG_TERM (self), NULL);
	_tmp0_ = self->priv->_value;
	result = _tmp0_;
	return result;
}

static void
geary_search_query_email_flag_term_set_value (GearySearchQueryEmailFlagTerm* self,
                                              GearyNamedFlag* value)
{
	GearyNamedFlag* old_value;
	g_return_if_fail (GEARY_SEARCH_QUERY_IS_EMAIL_FLAG_TERM (self));
	old_value = geary_search_query_email_flag_term_get_value (self);
	if (old_value != value) {
		GearyNamedFlag* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_value);
		self->priv->_value = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_search_query_email_flag_term_properties[GEARY_SEARCH_QUERY_EMAIL_FLAG_TERM_VALUE_PROPERTY]);
	}
}

GearySearchQueryEmailFlagTerm*
geary_search_query_email_flag_term_construct (GType object_type,
                                              GearyNamedFlag* value)
{
	GearySearchQueryEmailFlagTerm * self = NULL;
	g_return_val_if_fail (GEARY_IS_NAMED_FLAG (value), NULL);
	self = (GearySearchQueryEmailFlagTerm*) geary_search_query_term_construct (object_type);
	geary_search_query_email_flag_term_set_value (self, value);
	return self;
}

GearySearchQueryEmailFlagTerm*
geary_search_query_email_flag_term_new (GearyNamedFlag* value)
{
	return geary_search_query_email_flag_term_construct (GEARY_SEARCH_QUERY_TYPE_EMAIL_FLAG_TERM, value);
}

static gboolean
geary_search_query_email_flag_term_real_equal_to (GearySearchQueryTerm* base,
                                                  GearySearchQueryTerm* other)
{
	GearySearchQueryEmailFlagTerm * self;
	GearyNamedFlag* _tmp0_;
	GearyNamedFlag* _tmp1_;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_SEARCH_QUERY_TYPE_EMAIL_FLAG_TERM, GearySearchQueryEmailFlagTerm);
	g_return_val_if_fail (GEARY_SEARCH_QUERY_IS_TERM (other), FALSE);
	if (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_SEARCH_QUERY_TYPE_TERM, GearySearchQueryTerm) == other) {
		result = TRUE;
		return result;
	}
	if (!GEARY_SEARCH_QUERY_TERM_CLASS (geary_search_query_email_flag_term_parent_class)->equal_to (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_SEARCH_QUERY_TYPE_TERM, GearySearchQueryTerm), other)) {
		result = FALSE;
		return result;
	}
	_tmp0_ = self->priv->_value;
	_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST (other, GEARY_SEARCH_QUERY_TYPE_EMAIL_FLAG_TERM, GearySearchQueryEmailFlagTerm)->priv->_value;
	result = gee_hashable_equal_to (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_HASHABLE, GeeHashable), _tmp1_);
	return result;
}

static gchar*
geary_search_query_email_flag_term_real_to_string (GearySearchQueryTerm* base)
{
	GearySearchQueryEmailFlagTerm * self;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GearyNamedFlag* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_SEARCH_QUERY_TYPE_EMAIL_FLAG_TERM, GearySearchQueryEmailFlagTerm);
	_tmp1_ = geary_search_query_term_get_is_negated (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_SEARCH_QUERY_TYPE_TERM, GearySearchQueryTerm));
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		_tmp0_ = "!";
	} else {
		_tmp0_ = "";
	}
	_tmp3_ = self->priv->_value;
	_tmp4_ = geary_named_flag_to_string (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strdup_printf ("%s(%s)", _tmp0_, _tmp5_);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	result = _tmp7_;
	return result;
}

static void
geary_search_query_email_flag_term_class_init (GearySearchQueryEmailFlagTermClass * klass,
                                               gpointer klass_data)
{
	geary_search_query_email_flag_term_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearySearchQueryEmailFlagTerm_private_offset);
	((GearySearchQueryTermClass *) klass)->equal_to = (gboolean (*) (GearySearchQueryTerm*, GearySearchQueryTerm*)) geary_search_query_email_flag_term_real_equal_to;
	((GearySearchQueryTermClass *) klass)->to_string = (gchar* (*) (GearySearchQueryTerm*)) geary_search_query_email_flag_term_real_to_string;
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_search_query_email_flag_term_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_geary_search_query_email_flag_term_set_property;
	G_OBJECT_CLASS (klass)->finalize = geary_search_query_email_flag_term_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_SEARCH_QUERY_EMAIL_FLAG_TERM_VALUE_PROPERTY, geary_search_query_email_flag_term_properties[GEARY_SEARCH_QUERY_EMAIL_FLAG_TERM_VALUE_PROPERTY] = g_param_spec_object ("value", "value", "value", GEARY_TYPE_NAMED_FLAG, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
geary_search_query_email_flag_term_instance_init (GearySearchQueryEmailFlagTerm * self,
                                                  gpointer klass)
{
	self->priv = geary_search_query_email_flag_term_get_instance_private (self);
}

static void
geary_search_query_email_flag_term_finalize (GObject * obj)
{
	GearySearchQueryEmailFlagTerm * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_SEARCH_QUERY_TYPE_EMAIL_FLAG_TERM, GearySearchQueryEmailFlagTerm);
	_g_object_unref0 (self->priv->_value);
	G_OBJECT_CLASS (geary_search_query_email_flag_term_parent_class)->finalize (obj);
}

/**
     * A term that matches a given flag in an email.
     */
 G_GNUC_NO_INLINE static GType
geary_search_query_email_flag_term_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearySearchQueryEmailFlagTermClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_search_query_email_flag_term_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearySearchQueryEmailFlagTerm), 0, (GInstanceInitFunc) geary_search_query_email_flag_term_instance_init, NULL };
	GType geary_search_query_email_flag_term_type_id;
	geary_search_query_email_flag_term_type_id = g_type_register_static (GEARY_SEARCH_QUERY_TYPE_TERM, "GearySearchQueryEmailFlagTerm", &g_define_type_info, 0);
	GearySearchQueryEmailFlagTerm_private_offset = g_type_add_instance_private (geary_search_query_email_flag_term_type_id, sizeof (GearySearchQueryEmailFlagTermPrivate));
	return geary_search_query_email_flag_term_type_id;
}

GType
geary_search_query_email_flag_term_get_type (void)
{
	static gsize geary_search_query_email_flag_term_type_id__once = 0;
	if (g_once_init_enter (&geary_search_query_email_flag_term_type_id__once)) {
		GType geary_search_query_email_flag_term_type_id;
		geary_search_query_email_flag_term_type_id = geary_search_query_email_flag_term_get_type_once ();
		g_once_init_leave (&geary_search_query_email_flag_term_type_id__once, geary_search_query_email_flag_term_type_id);
	}
	return geary_search_query_email_flag_term_type_id__once;
}

static void
_vala_geary_search_query_email_flag_term_get_property (GObject * object,
                                                       guint property_id,
                                                       GValue * value,
                                                       GParamSpec * pspec)
{
	GearySearchQueryEmailFlagTerm * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_SEARCH_QUERY_TYPE_EMAIL_FLAG_TERM, GearySearchQueryEmailFlagTerm);
	switch (property_id) {
		case GEARY_SEARCH_QUERY_EMAIL_FLAG_TERM_VALUE_PROPERTY:
		g_value_set_object (value, geary_search_query_email_flag_term_get_value (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_geary_search_query_email_flag_term_set_property (GObject * object,
                                                       guint property_id,
                                                       const GValue * value,
                                                       GParamSpec * pspec)
{
	GearySearchQueryEmailFlagTerm * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_SEARCH_QUERY_TYPE_EMAIL_FLAG_TERM, GearySearchQueryEmailFlagTerm);
	switch (property_id) {
		case GEARY_SEARCH_QUERY_EMAIL_FLAG_TERM_VALUE_PROPERTY:
		geary_search_query_email_flag_term_set_value (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
geary_search_query_class_init (GearySearchQueryClass * klass,
                               gpointer klass_data)
{
	geary_search_query_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearySearchQuery_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_search_query_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_geary_search_query_set_property;
	G_OBJECT_CLASS (klass)->finalize = geary_search_query_finalize;
	/**
	     * A read-only list of search terms to be evaluated.
	     *
	     * Each given term is used in a conjunction, that is combined
	     * using a Boolean `AND` operator.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_SEARCH_QUERY_EXPRESSION_PROPERTY, geary_search_query_properties[GEARY_SEARCH_QUERY_EXPRESSION_PROPERTY] = g_param_spec_object ("expression", "expression", "expression", GEE_TYPE_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * The original search text, if any.
	     *
	     * This is used mostly for debugging.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_SEARCH_QUERY_RAW_PROPERTY, geary_search_query_properties[GEARY_SEARCH_QUERY_RAW_PROPERTY] = g_param_spec_string ("raw", "raw", "raw", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
geary_search_query_instance_init (GearySearchQuery * self,
                                  gpointer klass)
{
	GeeArrayList* _tmp0_;
	self->priv = geary_search_query_get_instance_private (self);
	_tmp0_ = gee_array_list_new (GEARY_SEARCH_QUERY_TYPE_TERM, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->priv->_rw_expression = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_LIST, GeeList);
}

static void
geary_search_query_finalize (GObject * obj)
{
	GearySearchQuery * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_TYPE_SEARCH_QUERY, GearySearchQuery);
	_g_object_unref0 (self->priv->_expression);
	_g_object_unref0 (self->priv->_rw_expression);
	_g_free0 (self->priv->_raw);
	G_OBJECT_CLASS (geary_search_query_parent_class)->finalize (obj);
}

/**
 * Specifies an expression for searching email in a search folder.
 *
 * New instances can be constructed via {@link
 * Account.new_search_query} and then passed to search methods on
 * {@link Account} or {@link App.SearchFolder}.
 *
 * Actual search queries are specified by the given {@link
 * expression}, which is a list of {@link Term}. The expression
 * denotes the conjunction of all given terms, that is, each term is
 * combined by a Boolean AND function. While the order of the terms is
 * not important, the expression should attempt to reflect the
 * free-text search query it was built from (if any). A more
 * expressive language is not supported since it is designed to work
 * with both the Engine's built-in full text search system as well as
 * other server-based systems, including IMAP.
 *
 * @see Account.new_search_query
 * @see Account.local_search_async
 * @see Account.get_search_matches_async
 * @see App.SearchFolder.update_query
 */
 G_GNUC_NO_INLINE static GType
geary_search_query_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearySearchQueryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_search_query_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearySearchQuery), 0, (GInstanceInitFunc) geary_search_query_instance_init, NULL };
	GType geary_search_query_type_id;
	geary_search_query_type_id = g_type_register_static (GEARY_TYPE_BASE_OBJECT, "GearySearchQuery", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	GearySearchQuery_private_offset = g_type_add_instance_private (geary_search_query_type_id, sizeof (GearySearchQueryPrivate));
	return geary_search_query_type_id;
}

GType
geary_search_query_get_type (void)
{
	static gsize geary_search_query_type_id__once = 0;
	if (g_once_init_enter (&geary_search_query_type_id__once)) {
		GType geary_search_query_type_id;
		geary_search_query_type_id = geary_search_query_get_type_once ();
		g_once_init_leave (&geary_search_query_type_id__once, geary_search_query_type_id);
	}
	return geary_search_query_type_id__once;
}

static void
_vala_geary_search_query_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	GearySearchQuery * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_TYPE_SEARCH_QUERY, GearySearchQuery);
	switch (property_id) {
		case GEARY_SEARCH_QUERY_EXPRESSION_PROPERTY:
		g_value_set_object (value, geary_search_query_get_expression (self));
		break;
		case GEARY_SEARCH_QUERY_RAW_PROPERTY:
		g_value_set_string (value, geary_search_query_get_raw (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_geary_search_query_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec)
{
	GearySearchQuery * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_TYPE_SEARCH_QUERY, GearySearchQuery);
	switch (property_id) {
		case GEARY_SEARCH_QUERY_EXPRESSION_PROPERTY:
		geary_search_query_set_expression (self, g_value_get_object (value));
		break;
		case GEARY_SEARCH_QUERY_RAW_PROPERTY:
		geary_search_query_set_raw (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

