/* imap-db-database.c generated by valac 0.56.3, the Vala compiler
 * generated from imap-db-database.vala, do not modify */

/*
 * Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <sqlite3.h>
#include "geary-engine.h"
#include <glib-object.h>
#include <gio/gio.h>
#include <gee.h>

#define GEARY_IMAP_DB_DATABASE_UTF8_CASE_INSENSITIVE_FN "UTF8FOLD"
#define GEARY_IMAP_DB_DATABASE_UTF8_COLLATE "UTF8COLL"
#define GEARY_IMAP_DB_DATABASE_OPEN_PUMP_EVENT_LOOP_MSEC 100

#define GEARY_IMAP_DB_TYPE_DATABASE (geary_imap_db_database_get_type ())
#define GEARY_IMAP_DB_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_IMAP_DB_TYPE_DATABASE, GearyImapDBDatabase))
#define GEARY_IMAP_DB_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_IMAP_DB_TYPE_DATABASE, GearyImapDBDatabaseClass))
#define GEARY_IMAP_DB_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_IMAP_DB_TYPE_DATABASE))
#define GEARY_IMAP_DB_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_IMAP_DB_TYPE_DATABASE))
#define GEARY_IMAP_DB_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_IMAP_DB_TYPE_DATABASE, GearyImapDBDatabaseClass))

typedef struct _GearyImapDBDatabase GearyImapDBDatabase;
typedef struct _GearyImapDBDatabaseClass GearyImapDBDatabaseClass;
typedef struct _GearyImapDBDatabasePrivate GearyImapDBDatabasePrivate;

#define GEARY_IMAP_DB_TYPE_GC (geary_imap_db_gc_get_type ())
#define GEARY_IMAP_DB_GC(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_IMAP_DB_TYPE_GC, GearyImapDBGC))
#define GEARY_IMAP_DB_GC_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_IMAP_DB_TYPE_GC, GearyImapDBGCClass))
#define GEARY_IMAP_DB_IS_GC(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_IMAP_DB_TYPE_GC))
#define GEARY_IMAP_DB_IS_GC_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_IMAP_DB_TYPE_GC))
#define GEARY_IMAP_DB_GC_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_IMAP_DB_TYPE_GC, GearyImapDBGCClass))

typedef struct _GearyImapDBGC GearyImapDBGC;
typedef struct _GearyImapDBGCClass GearyImapDBGCClass;
enum  {
	GEARY_IMAP_DB_DATABASE_0_PROPERTY,
	GEARY_IMAP_DB_DATABASE_WANT_BACKGROUND_VACUUM_PROPERTY,
	GEARY_IMAP_DB_DATABASE_NUM_PROPERTIES
};
static GParamSpec* geary_imap_db_database_properties[GEARY_IMAP_DB_DATABASE_NUM_PROPERTIES];
typedef enum  {
	GEARY_IMAP_DB_DATABASE_GARBAGE_COLLECTION_OPTIONS_NONE = 1 << 0,
	GEARY_IMAP_DB_DATABASE_GARBAGE_COLLECTION_OPTIONS_FORCE_REAP = 1 << 1,
	GEARY_IMAP_DB_DATABASE_GARBAGE_COLLECTION_OPTIONS_ALLOW_VACUUM = 1 << 2
} GearyImapDBDatabaseGarbageCollectionOptions;

#define GEARY_IMAP_DB_DATABASE_TYPE_GARBAGE_COLLECTION_OPTIONS (geary_imap_db_database_garbage_collection_options_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _geary_imap_db_gc_unref0(var) ((var == NULL) ? NULL : (var = (geary_imap_db_gc_unref (var), NULL)))
typedef struct _GearyImapDbDatabaseOpenData GearyImapDbDatabaseOpenData;
typedef enum  {
	GEARY_IMAP_DB_GC_RECOMMENDED_OPERATION_NONE = 0,
	GEARY_IMAP_DB_GC_RECOMMENDED_OPERATION_REAP = 1 << 0,
	GEARY_IMAP_DB_GC_RECOMMENDED_OPERATION_VACUUM = 1 << 1
} GearyImapDBGCRecommendedOperation;

#define GEARY_IMAP_DB_GC_TYPE_RECOMMENDED_OPERATION (geary_imap_db_gc_recommended_operation_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _GearyImapDbDatabaseRunGcData GearyImapDbDatabaseRunGcData;
typedef struct _GearyImapDbDatabasePostUpgradeData GearyImapDbDatabasePostUpgradeData;
typedef struct _Block49Data Block49Data;
typedef struct _GearyImapDbDatabasePostUpgradeEncodeFolderNamesData GearyImapDbDatabasePostUpgradeEncodeFolderNamesData;
typedef struct _GearyImapDbDatabasePostUpgradePopulateInternalDateTimeTData GearyImapDbDatabasePostUpgradePopulateInternalDateTimeTData;

#define GEARY_IMAP_DB_TYPE_ATTACHMENT (geary_imap_db_attachment_get_type ())
#define GEARY_IMAP_DB_ATTACHMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_IMAP_DB_TYPE_ATTACHMENT, GearyImapDBAttachment))
#define GEARY_IMAP_DB_ATTACHMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_IMAP_DB_TYPE_ATTACHMENT, GearyImapDBAttachmentClass))
#define GEARY_IMAP_DB_IS_ATTACHMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_IMAP_DB_TYPE_ATTACHMENT))
#define GEARY_IMAP_DB_IS_ATTACHMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_IMAP_DB_TYPE_ATTACHMENT))
#define GEARY_IMAP_DB_ATTACHMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_IMAP_DB_TYPE_ATTACHMENT, GearyImapDBAttachmentClass))

typedef struct _GearyImapDBAttachment GearyImapDBAttachment;
typedef struct _GearyImapDBAttachmentClass GearyImapDBAttachmentClass;
typedef struct _GearyImapDbDatabasePostUpgradePopulateAdditionalAttachmentsData GearyImapDbDatabasePostUpgradePopulateAdditionalAttachmentsData;
typedef struct _Block50Data Block50Data;
typedef struct _GearyImapDbDatabasePostUpgradeExpandPageSizeData GearyImapDbDatabasePostUpgradeExpandPageSizeData;
typedef struct _GearyImapDbDatabasePostUpgradeFixLocalizedInternaldatesData GearyImapDbDatabasePostUpgradeFixLocalizedInternaldatesData;
typedef struct _GearyImapDbDatabasePostUpgradeValidateContactsData GearyImapDbDatabasePostUpgradeValidateContactsData;
typedef struct _GearyImapDbDatabasePostUpgradeRebuildAttachmentsData GearyImapDbDatabasePostUpgradeRebuildAttachmentsData;

struct _GearyImapDBDatabase {
	GearyDbVersionedDatabase parent_instance;
	GFile* attachments_path;
	GearyImapDBDatabasePrivate * priv;
};

struct _GearyImapDBDatabaseClass {
	GearyDbVersionedDatabaseClass parent_class;
};

struct _GearyImapDBDatabasePrivate {
	gboolean _want_background_vacuum;
	GearyProgressMonitor* upgrade_monitor;
	GearyProgressMonitor* vacuum_monitor;
	gboolean new_db;
	gboolean is_open_in_progress;
	GearyImapDBGC* gc;
	GCancellable* gc_cancellable;
};

struct _GearyImapDbDatabaseOpenData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyImapDBDatabase* self;
	GearyDbDatabaseFlags flags;
	GCancellable* cancellable;
	GError* _inner_error0_;
};

struct _GearyImapDbDatabaseRunGcData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyImapDBDatabase* self;
	GearyImapDBDatabaseGarbageCollectionOptions options;
	GeeCollection* to_pause;
	GCancellable* cancellable;
	GearyImapDBGC* _tmp0_;
	GearyImapDBGC* _tmp1_;
	GearyImapDBGCRecommendedOperation recommended;
	GearyImapDBGC* _tmp2_;
	GCancellable* _tmp3_;
	GeeIterator* _service_it;
	GeeIterator* _tmp4_;
	GeeIterator* _tmp5_;
	GearyClientService* service;
	GeeIterator* _tmp6_;
	gpointer _tmp7_;
	GearyClientService* _tmp8_;
	GCancellable* _tmp9_;
	GearyProgressMonitor* _tmp10_;
	gboolean _tmp11_;
	gboolean _tmp12_;
	GearyProgressMonitor* _tmp13_;
	GearyImapDBGC* _tmp14_;
	GCancellable* _tmp15_;
	GError* err;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	GError* _tmp18_;
	const gchar* _tmp19_;
	GError* _tmp20_;
	GError* _tmp21_;
	GError* _inner_error1_;
	GearyProgressMonitor* _tmp22_;
	gboolean _tmp23_;
	gboolean _tmp24_;
	GearyProgressMonitor* _tmp25_;
	GeeIterator* _vala1__service_it;
	GeeIterator* _tmp26_;
	GeeIterator* _tmp27_;
	GearyClientService* _vala1_service;
	GeeIterator* _tmp28_;
	gpointer _tmp29_;
	GearyClientService* _tmp30_;
	GCancellable* _tmp31_;
	gboolean _tmp32_;
	guint _tmp33_;
	gboolean _tmp34_;
	GearyImapDBGC* _tmp35_;
	GCancellable* _tmp36_;
	guint _tmp37_;
	GError* _inner_error0_;
};

struct _GearyImapDbDatabasePostUpgradeData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyImapDBDatabase* self;
	gint version;
	GCancellable* cancellable;
	GError* _inner_error0_;
};

struct _Block49Data {
	int _ref_count_;
	GearyImapDBDatabase* self;
	GCancellable* cancellable;
	gpointer _async_data_;
};

struct _GearyImapDbDatabasePostUpgradeEncodeFolderNamesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyImapDBDatabase* self;
	GCancellable* cancellable;
	Block49Data* _data49_;
	GError* _inner_error0_;
};

struct _GearyImapDbDatabasePostUpgradePopulateInternalDateTimeTData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyImapDBDatabase* self;
	GCancellable* cancellable;
	GError* _inner_error0_;
};

struct _GearyImapDbDatabasePostUpgradePopulateAdditionalAttachmentsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyImapDBDatabase* self;
	GCancellable* cancellable;
	GError* _inner_error0_;
};

struct _Block50Data {
	int _ref_count_;
	GearyImapDBDatabase* self;
	GearyDbConnection* cx;
	gpointer _async_data_;
};

struct _GearyImapDbDatabasePostUpgradeExpandPageSizeData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyImapDBDatabase* self;
	GCancellable* cancellable;
	Block50Data* _data50_;
	GearyDbDatabaseConnection* _tmp0_;
	GearyNonblockingConcurrent* _tmp1_;
	GearyNonblockingConcurrent* _tmp2_;
	GError* _inner_error0_;
};

struct _GearyImapDbDatabasePostUpgradeFixLocalizedInternaldatesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyImapDBDatabase* self;
	GCancellable* cancellable;
	GError* _inner_error0_;
};

struct _GearyImapDbDatabasePostUpgradeValidateContactsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyImapDBDatabase* self;
	GCancellable* cancellable;
	GError* _inner_error0_;
};

struct _GearyImapDbDatabasePostUpgradeRebuildAttachmentsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyImapDBDatabase* self;
	GCancellable* cancellable;
	GError* _inner_error0_;
};

static gint GearyImapDBDatabase_private_offset;
static gpointer geary_imap_db_database_parent_class = NULL;

gchar* g_utf8_collate_key (const gchar* data,
                           gssize len);
gint sqlite3_register_fts5_tokeniser (sqlite3* db);
gint sqlite3_register_fts5_matches (sqlite3* db);
gint sqlite3_register_legacy_tokenizer (sqlite3* db);
VALA_EXTERN GType geary_imap_db_database_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gpointer geary_imap_db_gc_ref (gpointer instance);
VALA_EXTERN void geary_imap_db_gc_unref (gpointer instance);
VALA_EXTERN GParamSpec* geary_imap_db_param_spec_gc (const gchar* name,
                                         const gchar* nick,
                                         const gchar* blurb,
                                         GType object_type,
                                         GParamFlags flags);
VALA_EXTERN void geary_imap_db_value_set_gc (GValue* value,
                                 gpointer v_object);
VALA_EXTERN void geary_imap_db_value_take_gc (GValue* value,
                                  gpointer v_object);
VALA_EXTERN gpointer geary_imap_db_value_get_gc (const GValue* value);
VALA_EXTERN GType geary_imap_db_gc_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType geary_imap_db_database_garbage_collection_options_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gboolean geary_imap_db_database_get_want_background_vacuum (GearyImapDBDatabase* self);
VALA_EXTERN void geary_imap_db_database_set_want_background_vacuum (GearyImapDBDatabase* self,
                                                        gboolean value);
static void geary_imap_db_database_utf8_transliterate_fold (sqlite3_context* context,
                                                     sqlite3_value** values,
                                                     gint values_length1);
static gint geary_imap_db_database_utf8_collate (gint a_len,
                                          void* a_bytes,
                                          gint b_len,
                                          void* b_bytes);
VALA_EXTERN GearyImapDBDatabase* geary_imap_db_database_new (GFile* db_file,
                                                 GFile* schema_dir,
                                                 GFile* attachments_path,
                                                 GearyProgressMonitor* upgrade_monitor,
                                                 GearyProgressMonitor* vacuum_monitor);
VALA_EXTERN GearyImapDBDatabase* geary_imap_db_database_construct (GType object_type,
                                                       GFile* db_file,
                                                       GFile* schema_dir,
                                                       GFile* attachments_path,
                                                       GearyProgressMonitor* upgrade_monitor,
                                                       GearyProgressMonitor* vacuum_monitor);
static void geary_imap_db_database_open_data_free (gpointer _data);
VALA_EXTERN void geary_imap_db_database_open (GearyImapDBDatabase* self,
                                  GearyDbDatabaseFlags flags,
                                  GCancellable* cancellable,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_);
VALA_EXTERN void geary_imap_db_database_open_finish (GearyImapDBDatabase* self,
                                         GAsyncResult* _res_,
                                         GError** error);
static gboolean geary_imap_db_database_open_co (GearyImapDbDatabaseOpenData* _data_);
static void geary_imap_db_database_open_ready (GObject* source_object,
                                        GAsyncResult* _res_,
                                        gpointer _user_data_);
VALA_EXTERN void geary_imap_db_database_run_gc (GearyImapDBDatabase* self,
                                    GearyImapDBDatabaseGarbageCollectionOptions options,
                                    GeeCollection* to_pause,
                                    GCancellable* cancellable,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_);
VALA_EXTERN void geary_imap_db_database_run_gc_finish (GearyImapDBDatabase* self,
                                           GAsyncResult* _res_,
                                           GError** error);
static void geary_imap_db_database_run_gc_data_free (gpointer _data);
static gboolean geary_imap_db_database_run_gc_co (GearyImapDbDatabaseRunGcData* _data_);
static void geary_imap_db_database_cancel_gc (GearyImapDBDatabase* self);
static void _geary_imap_db_database_cancel_gc_g_cancellable_cancelled (GCancellable* _sender,
                                                                gpointer self);
VALA_EXTERN GearyImapDBGC* geary_imap_db_gc_new (GearyImapDBDatabase* db,
                                     gint priority);
VALA_EXTERN GearyImapDBGC* geary_imap_db_gc_construct (GType object_type,
                                           GearyImapDBDatabase* db,
                                           gint priority);
VALA_EXTERN GType geary_imap_db_gc_recommended_operation_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void geary_imap_db_gc_should_run_async (GearyImapDBGC* self,
                                        GCancellable* cancellable,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
VALA_EXTERN GearyImapDBGCRecommendedOperation geary_imap_db_gc_should_run_finish (GearyImapDBGC* self,
                                                                      GAsyncResult* _res_,
                                                                      GError** error);
static void geary_imap_db_database_run_gc_ready (GObject* source_object,
                                          GAsyncResult* _res_,
                                          gpointer _user_data_);
VALA_EXTERN void geary_imap_db_gc_vacuum_async (GearyImapDBGC* self,
                                    GCancellable* cancellable,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_);
VALA_EXTERN void geary_imap_db_gc_vacuum_finish (GearyImapDBGC* self,
                                     GAsyncResult* _res_,
                                     GError** error);
VALA_EXTERN void geary_imap_db_gc_reap_async (GearyImapDBGC* self,
                                  GCancellable* cancellable,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_);
VALA_EXTERN void geary_imap_db_gc_reap_finish (GearyImapDBGC* self,
                                   GAsyncResult* _res_,
                                   GError** error);
static void geary_imap_db_database_on_reap_async_completed (GearyImapDBDatabase* self,
                                                     GObject* object,
                                                     GAsyncResult* _result_);
static void _geary_imap_db_database_on_reap_async_completed_gasync_ready_callback (GObject* source_object,
                                                                            GAsyncResult* res,
                                                                            gpointer self);
static void __lambda33_ (GearyImapDBDatabase* self,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda33__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void geary_imap_db_database_real_close (GearyDbDatabase* base,
                                        GCancellable* cancellable,
                                        GError** error);
VALA_EXTERN gboolean geary_imap_db_gc_get_is_running (GearyImapDBGC* self);
static void geary_imap_db_database_real_starting_upgrade (GearyDbVersionedDatabase* base,
                                                   gint current_version,
                                                   gboolean new_db);
static void geary_imap_db_database_real_completed_upgrade (GearyDbVersionedDatabase* base,
                                                    gint final_version);
static void geary_imap_db_database_real_post_upgrade_data_free (gpointer _data);
static void geary_imap_db_database_real_post_upgrade (GearyDbVersionedDatabase* base,
                                               gint version,
                                               GCancellable* cancellable,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_);
static gboolean geary_imap_db_database_real_post_upgrade_co (GearyImapDbDatabasePostUpgradeData* _data_);
static void geary_imap_db_database_post_upgrade_encode_folder_names (GearyImapDBDatabase* self,
                                                              GCancellable* cancellable,
                                                              GAsyncReadyCallback _callback_,
                                                              gpointer _user_data_);
static void geary_imap_db_database_post_upgrade_encode_folder_names_finish (GearyImapDBDatabase* self,
                                                                     GAsyncResult* _res_,
                                                                     GError** error);
static void geary_imap_db_database_post_upgrade_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_);
static void geary_imap_db_database_post_upgrade_populate_internal_date_time_t (GearyImapDBDatabase* self,
                                                                        GCancellable* cancellable,
                                                                        GAsyncReadyCallback _callback_,
                                                                        gpointer _user_data_);
static void geary_imap_db_database_post_upgrade_populate_internal_date_time_t_finish (GearyImapDBDatabase* self,
                                                                               GAsyncResult* _res_,
                                                                               GError** error);
static void geary_imap_db_database_post_upgrade_populate_additional_attachments (GearyImapDBDatabase* self,
                                                                          GCancellable* cancellable,
                                                                          GAsyncReadyCallback _callback_,
                                                                          gpointer _user_data_);
static void geary_imap_db_database_post_upgrade_populate_additional_attachments_finish (GearyImapDBDatabase* self,
                                                                                 GAsyncResult* _res_,
                                                                                 GError** error);
static void geary_imap_db_database_post_upgrade_expand_page_size (GearyImapDBDatabase* self,
                                                           GCancellable* cancellable,
                                                           GAsyncReadyCallback _callback_,
                                                           gpointer _user_data_);
static void geary_imap_db_database_post_upgrade_expand_page_size_finish (GearyImapDBDatabase* self,
                                                                  GAsyncResult* _res_,
                                                                  GError** error);
static void geary_imap_db_database_post_upgrade_fix_localized_internaldates (GearyImapDBDatabase* self,
                                                                      GCancellable* cancellable,
                                                                      GAsyncReadyCallback _callback_,
                                                                      gpointer _user_data_);
static void geary_imap_db_database_post_upgrade_fix_localized_internaldates_finish (GearyImapDBDatabase* self,
                                                                             GAsyncResult* _res_,
                                                                             GError** error);
static void geary_imap_db_database_post_upgrade_validate_contacts (GearyImapDBDatabase* self,
                                                            GCancellable* cancellable,
                                                            GAsyncReadyCallback _callback_,
                                                            gpointer _user_data_);
static void geary_imap_db_database_post_upgrade_validate_contacts_finish (GearyImapDBDatabase* self,
                                                                   GAsyncResult* _res_,
                                                                   GError** error);
static void geary_imap_db_database_post_upgrade_rebuild_attachments (GearyImapDBDatabase* self,
                                                              GCancellable* cancellable,
                                                              GAsyncReadyCallback _callback_,
                                                              gpointer _user_data_);
static void geary_imap_db_database_post_upgrade_rebuild_attachments_finish (GearyImapDBDatabase* self,
                                                                     GAsyncResult* _res_,
                                                                     GError** error);
static void geary_imap_db_database_post_upgrade_encode_folder_names_data_free (gpointer _data);
static gboolean geary_imap_db_database_post_upgrade_encode_folder_names_co (GearyImapDbDatabasePostUpgradeEncodeFolderNamesData* _data_);
static Block49Data* block49_data_ref (Block49Data* _data49_);
static void block49_data_unref (void * _userdata_);
static GearyDbTransactionOutcome __lambda34_ (Block49Data* _data49_,
                                       GearyDbConnection* cx,
                                       GError** error);
static GearyDbTransactionOutcome ___lambda34__geary_db_transaction_method (GearyDbConnection* cx,
                                                                    GCancellable* cancellable,
                                                                    gpointer self,
                                                                    GError** error);
static void geary_imap_db_database_post_upgrade_encode_folder_names_ready (GObject* source_object,
                                                                    GAsyncResult* _res_,
                                                                    gpointer _user_data_);
static void geary_imap_db_database_post_upgrade_populate_internal_date_time_t_data_free (gpointer _data);
static gboolean geary_imap_db_database_post_upgrade_populate_internal_date_time_t_co (GearyImapDbDatabasePostUpgradePopulateInternalDateTimeTData* _data_);
static GearyDbTransactionOutcome __lambda35_ (GearyImapDBDatabase* self,
                                       GearyDbConnection* cx,
                                       GError** error);
static GearyDbTransactionOutcome ___lambda35__geary_db_transaction_method (GearyDbConnection* cx,
                                                                    GCancellable* cancellable,
                                                                    gpointer self,
                                                                    GError** error);
static void geary_imap_db_database_post_upgrade_populate_internal_date_time_t_ready (GObject* source_object,
                                                                              GAsyncResult* _res_,
                                                                              gpointer _user_data_);
static void geary_imap_db_database_post_upgrade_populate_additional_attachments_data_free (gpointer _data);
static gboolean geary_imap_db_database_post_upgrade_populate_additional_attachments_co (GearyImapDbDatabasePostUpgradePopulateAdditionalAttachmentsData* _data_);
static GearyDbTransactionOutcome __lambda36_ (GearyImapDBDatabase* self,
                                       GearyDbConnection* cx,
                                       GError** error);
VALA_EXTERN GeeList* geary_rf_c822_message_get_attachments (GearyRFC822Message* self,
                                                GearyMimeDispositionType disposition,
                                                GError** error);
VALA_EXTERN GType geary_imap_db_attachment_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GeeList* geary_imap_db_attachment_save_attachments (GearyDbConnection* cx,
                                                    GFile* attachments_path,
                                                    gint64 message_id,
                                                    GeeList* attachments,
                                                    GCancellable* cancellable,
                                                    GError** error);
static GearyDbTransactionOutcome ___lambda36__geary_db_transaction_method (GearyDbConnection* cx,
                                                                    GCancellable* cancellable,
                                                                    gpointer self,
                                                                    GError** error);
static void geary_imap_db_database_post_upgrade_populate_additional_attachments_ready (GObject* source_object,
                                                                                GAsyncResult* _res_,
                                                                                gpointer _user_data_);
static void geary_imap_db_database_post_upgrade_expand_page_size_data_free (gpointer _data);
static gboolean geary_imap_db_database_post_upgrade_expand_page_size_co (GearyImapDbDatabasePostUpgradeExpandPageSizeData* _data_);
static Block50Data* block50_data_ref (Block50Data* _data50_);
static void block50_data_unref (void * _userdata_);
static void geary_imap_db_database_post_upgrade_expand_page_size_ready (GObject* source_object,
                                                                 GAsyncResult* _res_,
                                                                 gpointer _user_data_);
static void __lambda37_ (Block50Data* _data50_,
                  GError** error);
static void ___lambda37__geary_nonblocking_concurrent_concurrent_callback (GCancellable* cancellable,
                                                                    gpointer self,
                                                                    GError** error);
static void geary_imap_db_database_post_upgrade_fix_localized_internaldates_data_free (gpointer _data);
static gboolean geary_imap_db_database_post_upgrade_fix_localized_internaldates_co (GearyImapDbDatabasePostUpgradeFixLocalizedInternaldatesData* _data_);
static GearyDbTransactionOutcome __lambda38_ (GearyImapDBDatabase* self,
                                       GearyDbConnection* cx,
                                       GError** error);
static gint64* _int64_dup (gint64* self);
static GearyDbTransactionOutcome ___lambda38__geary_db_transaction_method (GearyDbConnection* cx,
                                                                    GCancellable* cancellable,
                                                                    gpointer self,
                                                                    GError** error);
static void geary_imap_db_database_post_upgrade_fix_localized_internaldates_ready (GObject* source_object,
                                                                            GAsyncResult* _res_,
                                                                            gpointer _user_data_);
static void geary_imap_db_database_post_upgrade_validate_contacts_data_free (gpointer _data);
static gboolean geary_imap_db_database_post_upgrade_validate_contacts_co (GearyImapDbDatabasePostUpgradeValidateContactsData* _data_);
static GearyDbTransactionOutcome __lambda39_ (GearyImapDBDatabase* self,
                                       GearyDbConnection* cx,
                                       GError** error);
static GearyDbTransactionOutcome ___lambda39__geary_db_transaction_method (GearyDbConnection* cx,
                                                                    GCancellable* cancellable,
                                                                    gpointer self,
                                                                    GError** error);
static void geary_imap_db_database_post_upgrade_validate_contacts_ready (GObject* source_object,
                                                                  GAsyncResult* _res_,
                                                                  gpointer _user_data_);
static void geary_imap_db_database_post_upgrade_rebuild_attachments_data_free (gpointer _data);
static gboolean geary_imap_db_database_post_upgrade_rebuild_attachments_co (GearyImapDbDatabasePostUpgradeRebuildAttachmentsData* _data_);
static GearyDbTransactionOutcome __lambda40_ (GearyImapDBDatabase* self,
                                       GearyDbConnection* cx,
                                       GError** error);
VALA_EXTERN void geary_imap_db_attachment_delete_attachments (GearyDbConnection* cx,
                                                  GFile* attachments_path,
                                                  gint64 message_id,
                                                  GCancellable* cancellable,
                                                  GError** error);
static GearyDbTransactionOutcome ___lambda40__geary_db_transaction_method (GearyDbConnection* cx,
                                                                    GCancellable* cancellable,
                                                                    gpointer self,
                                                                    GError** error);
static void geary_imap_db_database_post_upgrade_rebuild_attachments_ready (GObject* source_object,
                                                                    GAsyncResult* _res_,
                                                                    gpointer _user_data_);
VALA_EXTERN gboolean geary_imap_db_database_fts_integrity_check (GearyImapDBDatabase* self,
                                                     GError** error);
VALA_EXTERN void geary_imap_db_database_fts_rebuild (GearyImapDBDatabase* self,
                                         GError** error);
VALA_EXTERN void geary_imap_db_database_fts_optimize (GearyImapDBDatabase* self,
                                          GError** error);
static void geary_imap_db_database_real_prepare_connection (GearyDbDatabase* base,
                                                     GearyDbDatabaseConnection* cx,
                                                     GError** error);
VALA_EXTERN sqlite3* geary_db_connection_get_db (GearyDbConnection* self);
static void _geary_imap_db_database_utf8_transliterate_fold_sqlite_user_func_callback (sqlite3_context* context,
                                                                                gint values_length1,
                                                                                sqlite3_value** values);
static gint _geary_imap_db_database_utf8_collate_sqlite_compare_callback (gpointer self,
                                                                   gint alen,
                                                                   void* a,
                                                                   gint blen,
                                                                   void* b);
static void geary_imap_db_database_finalize (GObject * obj);
static GType geary_imap_db_database_get_type_once (void);
static void _vala_geary_imap_db_database_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_geary_imap_db_database_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);

static inline gpointer
geary_imap_db_database_get_instance_private (GearyImapDBDatabase* self)
{
	return G_STRUCT_MEMBER_P (self, GearyImapDBDatabase_private_offset);
}

/** Options to use when running garbage collection. */
 G_GNUC_NO_INLINE static GType
geary_imap_db_database_garbage_collection_options_get_type_once (void)
{
	static const GFlagsValue values[] = {{GEARY_IMAP_DB_DATABASE_GARBAGE_COLLECTION_OPTIONS_NONE, "GEARY_IMAP_DB_DATABASE_GARBAGE_COLLECTION_OPTIONS_NONE", "none"}, {GEARY_IMAP_DB_DATABASE_GARBAGE_COLLECTION_OPTIONS_FORCE_REAP, "GEARY_IMAP_DB_DATABASE_GARBAGE_COLLECTION_OPTIONS_FORCE_REAP", "force-reap"}, {GEARY_IMAP_DB_DATABASE_GARBAGE_COLLECTION_OPTIONS_ALLOW_VACUUM, "GEARY_IMAP_DB_DATABASE_GARBAGE_COLLECTION_OPTIONS_ALLOW_VACUUM", "allow-vacuum"}, {0, NULL, NULL}};
	GType geary_imap_db_database_garbage_collection_options_type_id;
	geary_imap_db_database_garbage_collection_options_type_id = g_flags_register_static ("GearyImapDBDatabaseGarbageCollectionOptions", values);
	return geary_imap_db_database_garbage_collection_options_type_id;
}

GType
geary_imap_db_database_garbage_collection_options_get_type (void)
{
	static gsize geary_imap_db_database_garbage_collection_options_type_id__once = 0;
	if (g_once_init_enter (&geary_imap_db_database_garbage_collection_options_type_id__once)) {
		GType geary_imap_db_database_garbage_collection_options_type_id;
		geary_imap_db_database_garbage_collection_options_type_id = geary_imap_db_database_garbage_collection_options_get_type_once ();
		g_once_init_leave (&geary_imap_db_database_garbage_collection_options_type_id__once, geary_imap_db_database_garbage_collection_options_type_id);
	}
	return geary_imap_db_database_garbage_collection_options_type_id__once;
}

gboolean
geary_imap_db_database_get_want_background_vacuum (GearyImapDBDatabase* self)
{
	gboolean result;
	g_return_val_if_fail (GEARY_IMAP_DB_IS_DATABASE (self), FALSE);
	result = self->priv->_want_background_vacuum;
	return result;
}

void
geary_imap_db_database_set_want_background_vacuum (GearyImapDBDatabase* self,
                                                   gboolean value)
{
	gboolean old_value;
	g_return_if_fail (GEARY_IMAP_DB_IS_DATABASE (self));
	old_value = geary_imap_db_database_get_want_background_vacuum (self);
	if (old_value != value) {
		self->priv->_want_background_vacuum = value;
		g_object_notify_by_pspec ((GObject *) self, geary_imap_db_database_properties[GEARY_IMAP_DB_DATABASE_WANT_BACKGROUND_VACUUM_PROPERTY]);
	}
}

static void
geary_imap_db_database_utf8_transliterate_fold (sqlite3_context* context,
                                                sqlite3_value** values,
                                                gint values_length1)
{
	gchar* text = NULL;
	sqlite3_value* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	g_return_if_fail (context != NULL);
	_tmp0_ = values[0];
	_tmp1_ = (const gchar*) sqlite3_value_text (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	text = _tmp2_;
	_tmp3_ = text;
	if (_tmp3_ != NULL) {
		const gchar* _tmp4_;
		gchar* _tmp5_;
		GDestroyNotify _tmp6_;
		_tmp4_ = text;
		_tmp5_ = geary_db_normalise_case_insensitive_query (_tmp4_);
		_tmp6_ = g_free;
		sqlite3_result_text (context, _tmp5_, -1, _tmp6_);
	} else {
		sqlite3_value* _tmp7_;
		_tmp7_ = values[0];
		sqlite3_result_value (context, _tmp7_);
	}
	_g_free0 (text);
}

static gint
geary_imap_db_database_utf8_collate (gint a_len,
                                     void* a_bytes,
                                     gint b_len,
                                     void* b_bytes)
{
	gchar* a_str = NULL;
	gchar* b_str = NULL;
	GCompareFunc _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gint result;
	a_str = NULL;
	if (a_bytes != NULL) {
		gchar* _tmp0_;
		_tmp0_ = g_utf8_collate_key ((const gchar*) a_bytes, (gssize) a_len);
		_g_free0 (a_str);
		a_str = _tmp0_;
	}
	b_str = NULL;
	if (b_bytes != NULL) {
		gchar* _tmp1_;
		_tmp1_ = g_utf8_collate_key ((const gchar*) b_bytes, (gssize) b_len);
		_g_free0 (b_str);
		b_str = _tmp1_;
	}
	_tmp2_ = ((GCompareFunc) g_strcmp0);
	_tmp3_ = a_str;
	_tmp4_ = b_str;
	result = _tmp2_ (_tmp3_, _tmp4_);
	_g_free0 (b_str);
	_g_free0 (a_str);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GearyImapDBDatabase*
geary_imap_db_database_construct (GType object_type,
                                  GFile* db_file,
                                  GFile* schema_dir,
                                  GFile* attachments_path,
                                  GearyProgressMonitor* upgrade_monitor,
                                  GearyProgressMonitor* vacuum_monitor)
{
	GearyImapDBDatabase * self = NULL;
	GFile* _tmp0_;
	GearyProgressMonitor* _tmp1_;
	GearyProgressMonitor* _tmp2_;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (db_file, g_file_get_type ()), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (schema_dir, g_file_get_type ()), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (attachments_path, g_file_get_type ()), NULL);
	g_return_val_if_fail (GEARY_IS_PROGRESS_MONITOR (upgrade_monitor), NULL);
	g_return_val_if_fail (GEARY_IS_PROGRESS_MONITOR (vacuum_monitor), NULL);
	self = (GearyImapDBDatabase*) geary_db_versioned_database_construct_persistent (object_type, db_file, schema_dir);
	_tmp0_ = _g_object_ref0 (attachments_path);
	_g_object_unref0 (self->attachments_path);
	self->attachments_path = _tmp0_;
	_tmp1_ = _g_object_ref0 (upgrade_monitor);
	_g_object_unref0 (self->priv->upgrade_monitor);
	self->priv->upgrade_monitor = _tmp1_;
	_tmp2_ = _g_object_ref0 (vacuum_monitor);
	_g_object_unref0 (self->priv->vacuum_monitor);
	self->priv->vacuum_monitor = _tmp2_;
	return self;
}

GearyImapDBDatabase*
geary_imap_db_database_new (GFile* db_file,
                            GFile* schema_dir,
                            GFile* attachments_path,
                            GearyProgressMonitor* upgrade_monitor,
                            GearyProgressMonitor* vacuum_monitor)
{
	return geary_imap_db_database_construct (GEARY_IMAP_DB_TYPE_DATABASE, db_file, schema_dir, attachments_path, upgrade_monitor, vacuum_monitor);
}

static void
geary_imap_db_database_open_data_free (gpointer _data)
{
	GearyImapDbDatabaseOpenData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyImapDbDatabaseOpenData, _data_);
}

void
geary_imap_db_database_open (GearyImapDBDatabase* self,
                             GearyDbDatabaseFlags flags,
                             GCancellable* cancellable,
                             GAsyncReadyCallback _callback_,
                             gpointer _user_data_)
{
	GearyImapDbDatabaseOpenData* _data_;
	GearyImapDBDatabase* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (GEARY_IMAP_DB_IS_DATABASE (self));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearyImapDbDatabaseOpenData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_imap_db_database_open_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->flags = flags;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	geary_imap_db_database_open_co (_data_);
}

void
geary_imap_db_database_open_finish (GearyImapDBDatabase* self,
                                    GAsyncResult* _res_,
                                    GError** error)
{
	GearyImapDbDatabaseOpenData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
     * Prepares the ImapDB database for use.
     */
static void
geary_imap_db_database_open_ready (GObject* source_object,
                                   GAsyncResult* _res_,
                                   gpointer _user_data_)
{
	GearyImapDbDatabaseOpenData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_imap_db_database_open_co (_data_);
}

static gboolean
geary_imap_db_database_open_co (GearyImapDbDatabaseOpenData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->self->priv->is_open_in_progress = TRUE;
	_data_->_state_ = 1;
	GEARY_DB_DATABASE_CLASS (geary_imap_db_database_parent_class)->open (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_DB_TYPE_VERSIONED_DATABASE, GearyDbVersionedDatabase), GEARY_DB_TYPE_DATABASE, GearyDbDatabase), _data_->flags, _data_->cancellable, geary_imap_db_database_open_ready, _data_);
	return FALSE;
	_state_1:
	GEARY_DB_DATABASE_CLASS (geary_imap_db_database_parent_class)->open_finish (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_DB_TYPE_VERSIONED_DATABASE, GearyDbVersionedDatabase), GEARY_DB_TYPE_DATABASE, GearyDbDatabase), _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->self->priv->is_open_in_progress = FALSE;
	_data_->_state_ = 2;
	geary_imap_db_database_run_gc (_data_->self, GEARY_IMAP_DB_DATABASE_GARBAGE_COLLECTION_OPTIONS_NONE, NULL, _data_->cancellable, geary_imap_db_database_open_ready, _data_);
	return FALSE;
	_state_2:
	geary_imap_db_database_run_gc_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_imap_db_database_run_gc_data_free (gpointer _data)
{
	GearyImapDbDatabaseRunGcData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->to_pause);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyImapDbDatabaseRunGcData, _data_);
}

void
geary_imap_db_database_run_gc (GearyImapDBDatabase* self,
                               GearyImapDBDatabaseGarbageCollectionOptions options,
                               GeeCollection* to_pause,
                               GCancellable* cancellable,
                               GAsyncReadyCallback _callback_,
                               gpointer _user_data_)
{
	GearyImapDbDatabaseRunGcData* _data_;
	GearyImapDBDatabase* _tmp0_;
	GeeCollection* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (GEARY_IMAP_DB_IS_DATABASE (self));
	g_return_if_fail ((to_pause == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (to_pause, GEE_TYPE_COLLECTION));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearyImapDbDatabaseRunGcData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_imap_db_database_run_gc_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->options = options;
	_tmp1_ = _g_object_ref0 (to_pause);
	_g_object_unref0 (_data_->to_pause);
	_data_->to_pause = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	geary_imap_db_database_run_gc_co (_data_);
}

void
geary_imap_db_database_run_gc_finish (GearyImapDBDatabase* self,
                                      GAsyncResult* _res_,
                                      GError** error)
{
	GearyImapDbDatabaseRunGcData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
     * Run garbage collection
     *
     * Reap should only be forced when there is known cleanup to perform and
     * the interval based recommendation should be bypassed.
     */
static void
_geary_imap_db_database_cancel_gc_g_cancellable_cancelled (GCancellable* _sender,
                                                           gpointer self)
{
	geary_imap_db_database_cancel_gc ((GearyImapDBDatabase*) self);
}

static void
geary_imap_db_database_run_gc_ready (GObject* source_object,
                                     GAsyncResult* _res_,
                                     gpointer _user_data_)
{
	GearyImapDbDatabaseRunGcData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_imap_db_database_run_gc_co (_data_);
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

static void
_geary_imap_db_database_on_reap_async_completed_gasync_ready_callback (GObject* source_object,
                                                                       GAsyncResult* res,
                                                                       gpointer self)
{
	geary_imap_db_database_on_reap_async_completed ((GearyImapDBDatabase*) self, source_object, res);
	g_object_unref (self);
}

static gboolean
geary_imap_db_database_run_gc_co (GearyImapDbDatabaseRunGcData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->gc;
	if (_data_->_tmp0_ != NULL) {
		geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "GC abandoned, possibly already running");
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if (_data_->cancellable != NULL) {
		g_signal_connect_object (_data_->cancellable, "cancelled", (GCallback) _geary_imap_db_database_cancel_gc_g_cancellable_cancelled, _data_->self, 0);
	}
	_data_->_tmp1_ = geary_imap_db_gc_new (_data_->self, G_PRIORITY_LOW);
	_geary_imap_db_gc_unref0 (_data_->self->priv->gc);
	_data_->self->priv->gc = _data_->_tmp1_;
	_data_->_tmp2_ = _data_->self->priv->gc;
	_data_->_tmp3_ = _data_->self->priv->gc_cancellable;
	_data_->_state_ = 1;
	geary_imap_db_gc_should_run_async (_data_->_tmp2_, _data_->_tmp3_, geary_imap_db_database_run_gc_ready, _data_);
	return FALSE;
	_state_1:
	_data_->recommended = geary_imap_db_gc_should_run_finish (_data_->_tmp2_, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if ((_data_->recommended & GEARY_IMAP_DB_GC_RECOMMENDED_OPERATION_VACUUM) != 0) {
		if ((_data_->options & GEARY_IMAP_DB_DATABASE_GARBAGE_COLLECTION_OPTIONS_ALLOW_VACUUM) == GEARY_IMAP_DB_DATABASE_GARBAGE_COLLECTION_OPTIONS_ALLOW_VACUUM) {
			geary_imap_db_database_set_want_background_vacuum (_data_->self, FALSE);
			if (_data_->to_pause != NULL) {
				{
					_data_->_tmp4_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_data_->to_pause, GEE_TYPE_ITERABLE, GeeIterable));
					_data_->_service_it = _data_->_tmp4_;
					while (TRUE) {
						_data_->_tmp5_ = _data_->_service_it;
						if (!gee_iterator_next (_data_->_tmp5_)) {
							break;
						}
						_data_->_tmp6_ = _data_->_service_it;
						_data_->_tmp7_ = gee_iterator_get (_data_->_tmp6_);
						_data_->service = (GearyClientService*) _data_->_tmp7_;
						_data_->_tmp8_ = _data_->service;
						_data_->_tmp9_ = _data_->self->priv->gc_cancellable;
						_data_->_state_ = 2;
						geary_client_service_stop (_data_->_tmp8_, _data_->_tmp9_, geary_imap_db_database_run_gc_ready, _data_);
						return FALSE;
						_state_2:
						geary_client_service_stop_finish (_data_->_tmp8_, _data_->_res_, &_data_->_inner_error0_);
						if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
							g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
							_g_object_unref0 (_data_->service);
							_g_object_unref0 (_data_->_service_it);
							g_object_unref (_data_->_async_result);
							return FALSE;
						}
						_g_object_unref0 (_data_->service);
					}
					_g_object_unref0 (_data_->_service_it);
				}
			}
			_data_->_tmp10_ = _data_->self->priv->vacuum_monitor;
			_data_->_tmp11_ = geary_progress_monitor_get_is_in_progress (_data_->_tmp10_);
			_data_->_tmp12_ = _data_->_tmp11_;
			if (!_data_->_tmp12_) {
				_data_->_tmp13_ = _data_->self->priv->vacuum_monitor;
				geary_progress_monitor_notify_start (_data_->_tmp13_);
			}
			{
				_data_->_tmp14_ = _data_->self->priv->gc;
				_data_->_tmp15_ = _data_->self->priv->gc_cancellable;
				_data_->_state_ = 3;
				geary_imap_db_gc_vacuum_async (_data_->_tmp14_, _data_->_tmp15_, geary_imap_db_database_run_gc_ready, _data_);
				return FALSE;
				_state_3:
				geary_imap_db_gc_vacuum_finish (_data_->_tmp14_, _data_->_res_, &_data_->_inner_error0_);
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
			}
			goto __finally0;
			__catch0_g_error:
			{
				_data_->err = _data_->_inner_error0_;
				_data_->_inner_error0_ = NULL;
				_data_->_tmp16_ = geary_db_database_get_path (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_DB_TYPE_DATABASE, GearyDbDatabase));
				_data_->_tmp17_ = _data_->_tmp16_;
				_data_->_tmp18_ = _data_->err;
				_data_->_tmp19_ = _data_->_tmp18_->message;
				geary_logging_source_message (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Vacuum of IMAP database %s failed: %s", _data_->_tmp17_, _data_->_tmp19_);
				_data_->_tmp20_ = _data_->err;
				_data_->_tmp21_ = _g_error_copy0 (_data_->_tmp20_);
				_data_->_inner_error0_ = _data_->_tmp21_;
				_g_error_free0 (_data_->err);
				goto __finally0;
			}
			__finally0:
			{
				_data_->_tmp22_ = _data_->self->priv->vacuum_monitor;
				_data_->_tmp23_ = geary_progress_monitor_get_is_in_progress (_data_->_tmp22_);
				_data_->_tmp24_ = _data_->_tmp23_;
				if (_data_->_tmp24_) {
					_data_->_tmp25_ = _data_->self->priv->vacuum_monitor;
					geary_progress_monitor_notify_finish (_data_->_tmp25_);
				}
			}
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			if (_data_->to_pause != NULL) {
				{
					_data_->_tmp26_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_data_->to_pause, GEE_TYPE_ITERABLE, GeeIterable));
					_data_->_vala1__service_it = _data_->_tmp26_;
					while (TRUE) {
						_data_->_tmp27_ = _data_->_vala1__service_it;
						if (!gee_iterator_next (_data_->_tmp27_)) {
							break;
						}
						_data_->_tmp28_ = _data_->_vala1__service_it;
						_data_->_tmp29_ = gee_iterator_get (_data_->_tmp28_);
						_data_->_vala1_service = (GearyClientService*) _data_->_tmp29_;
						_data_->_tmp30_ = _data_->_vala1_service;
						_data_->_tmp31_ = _data_->self->priv->gc_cancellable;
						_data_->_state_ = 4;
						geary_client_service_start (_data_->_tmp30_, _data_->_tmp31_, geary_imap_db_database_run_gc_ready, _data_);
						return FALSE;
						_state_4:
						geary_client_service_start_finish (_data_->_tmp30_, _data_->_res_, &_data_->_inner_error0_);
						if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
							g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
							_g_object_unref0 (_data_->_vala1_service);
							_g_object_unref0 (_data_->_vala1__service_it);
							g_object_unref (_data_->_async_result);
							return FALSE;
						}
						_g_object_unref0 (_data_->_vala1_service);
					}
					_g_object_unref0 (_data_->_vala1__service_it);
				}
			}
		} else {
			geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Flagging desire to GC vacuum");
			geary_imap_db_database_set_want_background_vacuum (_data_->self, TRUE);
		}
	}
	if (_data_->cancellable != NULL) {
		_data_->_tmp32_ = g_cancellable_is_cancelled (_data_->cancellable);
	} else {
		_data_->_tmp32_ = FALSE;
	}
	if (_data_->_tmp32_) {
		g_signal_parse_name ("cancelled", g_cancellable_get_type (), &_data_->_tmp33_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_data_->cancellable, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _data_->_tmp33_, 0, NULL, (GCallback) _geary_imap_db_database_cancel_gc_g_cancellable_cancelled, _data_->self);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if ((_data_->options & GEARY_IMAP_DB_DATABASE_GARBAGE_COLLECTION_OPTIONS_FORCE_REAP) == GEARY_IMAP_DB_DATABASE_GARBAGE_COLLECTION_OPTIONS_FORCE_REAP) {
		_data_->_tmp34_ = TRUE;
	} else {
		_data_->_tmp34_ = (_data_->recommended & GEARY_IMAP_DB_GC_RECOMMENDED_OPERATION_REAP) != 0;
	}
	if (_data_->_tmp34_) {
		_data_->_tmp35_ = _data_->self->priv->gc;
		_data_->_tmp36_ = _data_->self->priv->gc_cancellable;
		geary_imap_db_gc_reap_async (_data_->_tmp35_, _data_->_tmp36_, _geary_imap_db_database_on_reap_async_completed_gasync_ready_callback, g_object_ref (_data_->self));
	} else {
		_geary_imap_db_gc_unref0 (_data_->self->priv->gc);
		_data_->self->priv->gc = NULL;
	}
	if (_data_->cancellable != NULL) {
		g_signal_parse_name ("cancelled", g_cancellable_get_type (), &_data_->_tmp37_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_data_->cancellable, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _data_->_tmp37_, 0, NULL, (GCallback) _geary_imap_db_database_cancel_gc_g_cancellable_cancelled, _data_->self);
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
__lambda33_ (GearyImapDBDatabase* self,
             GObject* obj,
             GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail ((obj == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (obj, G_TYPE_OBJECT));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (res, g_async_result_get_type ()));
	{
		GearyImapDBGCRecommendedOperation recommended = 0U;
		GearyImapDBGC* _tmp0_;
		_tmp0_ = self->priv->gc;
		recommended = geary_imap_db_gc_should_run_finish (_tmp0_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		if ((recommended & GEARY_IMAP_DB_GC_RECOMMENDED_OPERATION_VACUUM) != 0) {
			geary_imap_db_database_set_want_background_vacuum (self, TRUE);
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		GError* _tmp3_;
		const gchar* _tmp4_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = geary_db_database_get_path (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_DB_TYPE_DATABASE, GearyDbDatabase));
		_tmp2_ = _tmp1_;
		_tmp3_ = err;
		_tmp4_ = _tmp3_->message;
		geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Failed to run GC check on %s after REAP: %s", _tmp2_, _tmp4_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda33__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda33_ ((GearyImapDBDatabase*) self, source_object, res);
	g_object_unref (self);
}

static void
geary_imap_db_database_on_reap_async_completed (GearyImapDBDatabase* self,
                                                GObject* object,
                                                GAsyncResult* _result_)
{
	GearyImapDBGC* _tmp5_;
	GCancellable* _tmp6_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (GEARY_IMAP_DB_IS_DATABASE (self));
	g_return_if_fail ((object == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (object, G_TYPE_OBJECT));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (_result_, g_async_result_get_type ()));
	{
		GearyImapDBGC* _tmp0_;
		_tmp0_ = self->priv->gc;
		geary_imap_db_gc_reap_finish (_tmp0_, _result_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		GError* _tmp3_;
		const gchar* _tmp4_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = geary_db_database_get_path (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_DB_TYPE_DATABASE, GearyDbDatabase));
		_tmp2_ = _tmp1_;
		_tmp3_ = err;
		_tmp4_ = _tmp3_->message;
		geary_logging_source_message (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Garbage collection of IMAP database %s failed: %s", _tmp2_, _tmp4_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp5_ = self->priv->gc;
	_tmp6_ = self->priv->gc_cancellable;
	geary_imap_db_gc_should_run_async (_tmp5_, _tmp6_, ___lambda33__gasync_ready_callback, g_object_ref (self));
	_geary_imap_db_gc_unref0 (self->priv->gc);
	self->priv->gc = NULL;
}

static void
geary_imap_db_database_cancel_gc (GearyImapDBDatabase* self)
{
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (GEARY_IMAP_DB_IS_DATABASE (self));
	_tmp0_ = self->priv->gc_cancellable;
	g_cancellable_cancel (_tmp0_);
	_tmp1_ = g_cancellable_new ();
	_g_object_unref0 (self->priv->gc_cancellable);
	self->priv->gc_cancellable = _tmp1_;
}

static void
geary_imap_db_database_real_close (GearyDbDatabase* base,
                                   GCancellable* cancellable,
                                   GError** error)
{
	GearyImapDBDatabase * self;
	GError* _inner_error0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_DB_TYPE_DATABASE, GearyImapDBDatabase);
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	geary_imap_db_database_cancel_gc (self);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		GearyImapDBGC* _tmp1_;
		GMainContext* _tmp5_;
		_tmp1_ = self->priv->gc;
		if (_tmp1_ != NULL) {
			GearyImapDBGC* _tmp2_;
			gboolean _tmp3_;
			gboolean _tmp4_;
			_tmp2_ = self->priv->gc;
			_tmp3_ = geary_imap_db_gc_get_is_running (_tmp2_);
			_tmp4_ = _tmp3_;
			_tmp0_ = _tmp4_;
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		_tmp5_ = g_main_context_default ();
		g_main_context_iteration (_tmp5_, FALSE);
	}
	GEARY_DB_DATABASE_CLASS (geary_imap_db_database_parent_class)->close (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_DB_TYPE_VERSIONED_DATABASE, GearyDbVersionedDatabase), GEARY_DB_TYPE_DATABASE, GearyDbDatabase), cancellable, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

static void
geary_imap_db_database_real_starting_upgrade (GearyDbVersionedDatabase* base,
                                              gint current_version,
                                              gboolean new_db)
{
	GearyImapDBDatabase * self;
	gboolean _tmp0_ = FALSE;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_DB_TYPE_DATABASE, GearyImapDBDatabase);
	self->priv->new_db = new_db;
	if (!new_db) {
		GearyProgressMonitor* _tmp1_;
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp1_ = self->priv->upgrade_monitor;
		_tmp2_ = geary_progress_monitor_get_is_in_progress (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp0_ = !_tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GearyProgressMonitor* _tmp4_;
		_tmp4_ = self->priv->upgrade_monitor;
		geary_progress_monitor_notify_start (_tmp4_);
	}
}

static void
geary_imap_db_database_real_completed_upgrade (GearyDbVersionedDatabase* base,
                                               gint final_version)
{
	GearyImapDBDatabase * self;
	gboolean _tmp0_ = FALSE;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_DB_TYPE_DATABASE, GearyImapDBDatabase);
	if (!self->priv->new_db) {
		GearyProgressMonitor* _tmp1_;
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp1_ = self->priv->upgrade_monitor;
		_tmp2_ = geary_progress_monitor_get_is_in_progress (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GearyProgressMonitor* _tmp4_;
		_tmp4_ = self->priv->upgrade_monitor;
		geary_progress_monitor_notify_finish (_tmp4_);
	}
}

static void
geary_imap_db_database_real_post_upgrade_data_free (gpointer _data)
{
	GearyImapDbDatabasePostUpgradeData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyImapDbDatabasePostUpgradeData, _data_);
}

static void
geary_imap_db_database_real_post_upgrade (GearyDbVersionedDatabase* base,
                                          gint version,
                                          GCancellable* cancellable,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_)
{
	GearyImapDBDatabase * self;
	GearyImapDbDatabasePostUpgradeData* _data_;
	GearyImapDBDatabase* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_DB_TYPE_DATABASE, GearyImapDBDatabase);
	_data_ = g_slice_new0 (GearyImapDbDatabasePostUpgradeData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_imap_db_database_real_post_upgrade_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->version = version;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	geary_imap_db_database_real_post_upgrade_co (_data_);
}

static void
geary_imap_db_database_post_upgrade_finish (GearyDbVersionedDatabase* base,
                                            GAsyncResult* _res_,
                                            GError** error)
{
	GearyImapDbDatabasePostUpgradeData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
geary_imap_db_database_post_upgrade_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_)
{
	GearyImapDbDatabasePostUpgradeData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_imap_db_database_real_post_upgrade_co (_data_);
}

static gboolean
geary_imap_db_database_real_post_upgrade_co (GearyImapDbDatabasePostUpgradeData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		case 5:
		goto _state_5;
		case 6:
		goto _state_6;
		case 7:
		goto _state_7;
		case 8:
		goto _state_8;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	switch (_data_->version) {
		case 6:
		{
			_data_->_state_ = 1;
			geary_imap_db_database_post_upgrade_encode_folder_names (_data_->self, _data_->cancellable, geary_imap_db_database_post_upgrade_ready, _data_);
			return FALSE;
			_state_1:
			geary_imap_db_database_post_upgrade_encode_folder_names_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			break;
		}
		case 12:
		{
			_data_->_state_ = 2;
			geary_imap_db_database_post_upgrade_populate_internal_date_time_t (_data_->self, _data_->cancellable, geary_imap_db_database_post_upgrade_ready, _data_);
			return FALSE;
			_state_2:
			geary_imap_db_database_post_upgrade_populate_internal_date_time_t_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			break;
		}
		case 13:
		{
			_data_->_state_ = 3;
			geary_imap_db_database_post_upgrade_populate_additional_attachments (_data_->self, _data_->cancellable, geary_imap_db_database_post_upgrade_ready, _data_);
			return FALSE;
			_state_3:
			geary_imap_db_database_post_upgrade_populate_additional_attachments_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			break;
		}
		case 14:
		{
			_data_->_state_ = 4;
			geary_imap_db_database_post_upgrade_expand_page_size (_data_->self, _data_->cancellable, geary_imap_db_database_post_upgrade_ready, _data_);
			return FALSE;
			_state_4:
			geary_imap_db_database_post_upgrade_expand_page_size_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			break;
		}
		case 15:
		{
			_data_->_state_ = 5;
			geary_imap_db_database_post_upgrade_fix_localized_internaldates (_data_->self, _data_->cancellable, geary_imap_db_database_post_upgrade_ready, _data_);
			return FALSE;
			_state_5:
			geary_imap_db_database_post_upgrade_fix_localized_internaldates_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			break;
		}
		case 18:
		{
			_data_->_state_ = 6;
			geary_imap_db_database_post_upgrade_populate_internal_date_time_t (_data_->self, _data_->cancellable, geary_imap_db_database_post_upgrade_ready, _data_);
			return FALSE;
			_state_6:
			geary_imap_db_database_post_upgrade_populate_internal_date_time_t_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			break;
		}
		case 19:
		{
			_data_->_state_ = 7;
			geary_imap_db_database_post_upgrade_validate_contacts (_data_->self, _data_->cancellable, geary_imap_db_database_post_upgrade_ready, _data_);
			return FALSE;
			_state_7:
			geary_imap_db_database_post_upgrade_validate_contacts_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			break;
		}
		case 22:
		{
			_data_->_state_ = 8;
			geary_imap_db_database_post_upgrade_rebuild_attachments (_data_->self, _data_->cancellable, geary_imap_db_database_post_upgrade_ready, _data_);
			return FALSE;
			_state_8:
			geary_imap_db_database_post_upgrade_rebuild_attachments_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			break;
		}
		default:
		break;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_imap_db_database_post_upgrade_encode_folder_names_data_free (gpointer _data)
{
	GearyImapDbDatabasePostUpgradeEncodeFolderNamesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyImapDbDatabasePostUpgradeEncodeFolderNamesData, _data_);
}

static void
geary_imap_db_database_post_upgrade_encode_folder_names (GearyImapDBDatabase* self,
                                                         GCancellable* cancellable,
                                                         GAsyncReadyCallback _callback_,
                                                         gpointer _user_data_)
{
	GearyImapDbDatabasePostUpgradeEncodeFolderNamesData* _data_;
	GearyImapDBDatabase* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (GEARY_IMAP_DB_IS_DATABASE (self));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearyImapDbDatabasePostUpgradeEncodeFolderNamesData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_imap_db_database_post_upgrade_encode_folder_names_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	geary_imap_db_database_post_upgrade_encode_folder_names_co (_data_);
}

static void
geary_imap_db_database_post_upgrade_encode_folder_names_finish (GearyImapDBDatabase* self,
                                                                GAsyncResult* _res_,
                                                                GError** error)
{
	GearyImapDbDatabasePostUpgradeEncodeFolderNamesData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static Block49Data*
block49_data_ref (Block49Data* _data49_)
{
	g_atomic_int_inc (&_data49_->_ref_count_);
	return _data49_;
}

static void
block49_data_unref (void * _userdata_)
{
	Block49Data* _data49_;
	_data49_ = (Block49Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data49_->_ref_count_)) {
		GearyImapDBDatabase* self;
		self = _data49_->self;
		_g_object_unref0 (_data49_->cancellable);
		_g_object_unref0 (self);
		g_slice_free (Block49Data, _data49_);
	}
}

static GearyDbTransactionOutcome
__lambda34_ (Block49Data* _data49_,
             GearyDbConnection* cx,
             GError** error)
{
	GearyImapDBDatabase* self;
	GearyDbResult* select = NULL;
	GearyDbResult* _tmp0_;
	GError* _inner_error0_ = NULL;
	GearyDbTransactionOutcome result;
	self = _data49_->self;
	g_return_val_if_fail (GEARY_DB_IS_CONNECTION (cx), 0);
	_tmp0_ = geary_db_connection_query (cx, "SELECT id, name FROM FolderTable", NULL, &_inner_error0_);
	select = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return 0;
	}
	while (TRUE) {
		gboolean _tmp1_ = FALSE;
		GearyDbResult* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		gint64 id = 0LL;
		GearyDbResult* _tmp5_;
		gchar* encoded_name = NULL;
		GearyDbResult* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		GearyDbResult* _tmp25_;
		_tmp2_ = select;
		_tmp3_ = geary_db_result_get_finished (_tmp2_);
		_tmp4_ = _tmp3_;
		if (!_tmp4_) {
			_tmp1_ = !g_cancellable_is_cancelled (_data49_->cancellable);
		} else {
			_tmp1_ = FALSE;
		}
		if (!_tmp1_) {
			break;
		}
		_tmp5_ = select;
		id = geary_db_result_int64_at (_tmp5_, 0, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (select);
			return 0;
		}
		_tmp6_ = select;
		_tmp7_ = geary_db_result_nonnull_string_at (_tmp6_, 1, &_inner_error0_);
		_tmp8_ = g_strdup (_tmp7_);
		encoded_name = _tmp8_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (select);
			return 0;
		}
		{
			gchar* canonical_name = NULL;
			const gchar* _tmp9_;
			gchar* _tmp10_;
			GearyDbStatement* update = NULL;
			GearyDbStatement* _tmp11_;
			GearyDbStatement* _tmp12_;
			const gchar* _tmp13_;
			GearyDbStatement* _tmp14_;
			GearyDbStatement* _tmp15_;
			GearyDbStatement* _tmp16_;
			GearyDbStatement* _tmp17_;
			GearyDbStatement* _tmp18_;
			GearyDbStatement* _tmp19_;
			GearyDbResult* _tmp20_;
			GearyDbResult* _tmp21_;
			_tmp9_ = encoded_name;
			_tmp10_ = geary_imap_utf7_imap_utf7_to_utf8 (_tmp9_, &_inner_error0_);
			canonical_name = _tmp10_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp11_ = geary_db_connection_prepare (cx, "UPDATE FolderTable SET name=? WHERE id=?", &_inner_error0_);
			update = _tmp11_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (canonical_name);
				goto __catch0_g_error;
			}
			_tmp12_ = update;
			_tmp13_ = canonical_name;
			_tmp14_ = geary_db_statement_bind_string (_tmp12_, 0, _tmp13_, &_inner_error0_);
			_tmp15_ = _tmp14_;
			_g_object_unref0 (_tmp15_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (update);
				_g_free0 (canonical_name);
				goto __catch0_g_error;
			}
			_tmp16_ = update;
			_tmp17_ = geary_db_statement_bind_int64 (_tmp16_, 1, id, &_inner_error0_);
			_tmp18_ = _tmp17_;
			_g_object_unref0 (_tmp18_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (update);
				_g_free0 (canonical_name);
				goto __catch0_g_error;
			}
			_tmp19_ = update;
			_tmp20_ = geary_db_statement_exec (_tmp19_, NULL, &_inner_error0_);
			_tmp21_ = _tmp20_;
			_g_object_unref0 (_tmp21_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (update);
				_g_free0 (canonical_name);
				goto __catch0_g_error;
			}
			_g_object_unref0 (update);
			_g_free0 (canonical_name);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			const gchar* _tmp22_;
			GError* _tmp23_;
			const gchar* _tmp24_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp22_ = encoded_name;
			_tmp23_ = e;
			_tmp24_ = _tmp23_->message;
			geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Error renaming folder %s to its canonical representation: %s", _tmp22_, _tmp24_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (encoded_name);
			_g_object_unref0 (select);
			return 0;
		}
		_tmp25_ = select;
		geary_db_result_next (_tmp25_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (encoded_name);
			_g_object_unref0 (select);
			return 0;
		}
		_g_free0 (encoded_name);
	}
	result = GEARY_DB_TRANSACTION_OUTCOME_COMMIT;
	_g_object_unref0 (select);
	return result;
}

static GearyDbTransactionOutcome
___lambda34__geary_db_transaction_method (GearyDbConnection* cx,
                                          GCancellable* cancellable,
                                          gpointer self,
                                          GError** error)
{
	GearyDbTransactionOutcome result;
	result = __lambda34_ (self, cx, error);
	return result;
}

static void
geary_imap_db_database_post_upgrade_encode_folder_names_ready (GObject* source_object,
                                                               GAsyncResult* _res_,
                                                               gpointer _user_data_)
{
	GearyImapDbDatabasePostUpgradeEncodeFolderNamesData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_imap_db_database_post_upgrade_encode_folder_names_co (_data_);
}

static gboolean
geary_imap_db_database_post_upgrade_encode_folder_names_co (GearyImapDbDatabasePostUpgradeEncodeFolderNamesData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data49_ = g_slice_new0 (Block49Data);
	_data_->_data49_->_ref_count_ = 1;
	_data_->_data49_->self = g_object_ref (_data_->self);
	_g_object_unref0 (_data_->_data49_->cancellable);
	_data_->_data49_->cancellable = _data_->cancellable;
	_data_->_data49_->_async_data_ = _data_;
	_data_->_state_ = 1;
	geary_db_database_exec_transaction_async (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_DB_TYPE_DATABASE, GearyDbDatabase), GEARY_DB_TRANSACTION_TYPE_RW, ___lambda34__geary_db_transaction_method, _data_->_data49_, _data_->_data49_->cancellable, geary_imap_db_database_post_upgrade_encode_folder_names_ready, _data_);
	return FALSE;
	_state_1:
	geary_db_database_exec_transaction_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_DB_TYPE_DATABASE, GearyDbDatabase), _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		block49_data_unref (_data_->_data49_);
		_data_->_data49_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	block49_data_unref (_data_->_data49_);
	_data_->_data49_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_imap_db_database_post_upgrade_populate_internal_date_time_t_data_free (gpointer _data)
{
	GearyImapDbDatabasePostUpgradePopulateInternalDateTimeTData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyImapDbDatabasePostUpgradePopulateInternalDateTimeTData, _data_);
}

static void
geary_imap_db_database_post_upgrade_populate_internal_date_time_t (GearyImapDBDatabase* self,
                                                                   GCancellable* cancellable,
                                                                   GAsyncReadyCallback _callback_,
                                                                   gpointer _user_data_)
{
	GearyImapDbDatabasePostUpgradePopulateInternalDateTimeTData* _data_;
	GearyImapDBDatabase* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (GEARY_IMAP_DB_IS_DATABASE (self));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearyImapDbDatabasePostUpgradePopulateInternalDateTimeTData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_imap_db_database_post_upgrade_populate_internal_date_time_t_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	geary_imap_db_database_post_upgrade_populate_internal_date_time_t_co (_data_);
}

static void
geary_imap_db_database_post_upgrade_populate_internal_date_time_t_finish (GearyImapDBDatabase* self,
                                                                          GAsyncResult* _res_,
                                                                          GError** error)
{
	GearyImapDbDatabasePostUpgradePopulateInternalDateTimeTData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static GearyDbTransactionOutcome
__lambda35_ (GearyImapDBDatabase* self,
             GearyDbConnection* cx,
             GError** error)
{
	GearyDbResult* select = NULL;
	GearyDbResult* _tmp0_;
	GError* _inner_error0_ = NULL;
	GearyDbTransactionOutcome result;
	g_return_val_if_fail (GEARY_DB_IS_CONNECTION (cx), 0);
	_tmp0_ = geary_db_connection_query (cx, "SELECT id, internaldate FROM MessageTable", NULL, &_inner_error0_);
	select = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return 0;
	}
	while (TRUE) {
		GearyDbResult* _tmp1_;
		gboolean _tmp2_;
		gboolean _tmp3_;
		gint64 id = 0LL;
		GearyDbResult* _tmp4_;
		gchar* internaldate = NULL;
		GearyDbResult* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		GearyDbResult* _tmp28_;
		_tmp1_ = select;
		_tmp2_ = geary_db_result_get_finished (_tmp1_);
		_tmp3_ = _tmp2_;
		if (!(!_tmp3_)) {
			break;
		}
		_tmp4_ = select;
		id = geary_db_result_rowid_at (_tmp4_, 0, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (select);
			return 0;
		}
		_tmp5_ = select;
		_tmp6_ = geary_db_result_string_at (_tmp5_, 1, &_inner_error0_);
		_tmp7_ = g_strdup (_tmp6_);
		internaldate = _tmp7_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (select);
			return 0;
		}
		{
			gint64 _tmp8_ = 0LL;
			const gchar* _tmp9_;
			gint64 as_time_t = 0LL;
			GearyDbStatement* update = NULL;
			GearyDbStatement* _tmp15_;
			GearyDbStatement* _tmp16_;
			GearyDbStatement* _tmp17_;
			GearyDbStatement* _tmp18_;
			GearyDbStatement* _tmp19_;
			GearyDbStatement* _tmp20_;
			GearyDbStatement* _tmp21_;
			GearyDbStatement* _tmp22_;
			GearyDbResult* _tmp23_;
			GearyDbResult* _tmp24_;
			_tmp9_ = internaldate;
			if (_tmp9_ != NULL) {
				GearyImapInternalDate* _tmp10_ = NULL;
				const gchar* _tmp11_;
				GearyImapInternalDate* _tmp12_;
				GDateTime* _tmp13_;
				GDateTime* _tmp14_;
				_tmp11_ = internaldate;
				_tmp12_ = geary_imap_internal_date_decode (_tmp11_, &_inner_error0_);
				_tmp10_ = _tmp12_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				_tmp13_ = geary_imap_internal_date_get_value (_tmp10_);
				_tmp14_ = _tmp13_;
				_tmp8_ = g_date_time_to_unix (_tmp14_);
				_g_object_unref0 (_tmp10_);
			} else {
				_tmp8_ = (gint64) -1;
			}
			as_time_t = _tmp8_;
			_tmp15_ = geary_db_connection_prepare (cx, "UPDATE MessageTable SET internaldate_time_t=? WHERE id=?", &_inner_error0_);
			update = _tmp15_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp16_ = update;
			_tmp17_ = geary_db_statement_bind_int64 (_tmp16_, 0, as_time_t, &_inner_error0_);
			_tmp18_ = _tmp17_;
			_g_object_unref0 (_tmp18_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (update);
				goto __catch0_g_error;
			}
			_tmp19_ = update;
			_tmp20_ = geary_db_statement_bind_rowid (_tmp19_, 1, id, &_inner_error0_);
			_tmp21_ = _tmp20_;
			_g_object_unref0 (_tmp21_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (update);
				goto __catch0_g_error;
			}
			_tmp22_ = update;
			_tmp23_ = geary_db_statement_exec (_tmp22_, NULL, &_inner_error0_);
			_tmp24_ = _tmp23_;
			_g_object_unref0 (_tmp24_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (update);
				goto __catch0_g_error;
			}
			_g_object_unref0 (update);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			const gchar* _tmp25_;
			GError* _tmp26_;
			const gchar* _tmp27_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp25_ = internaldate;
			_tmp26_ = e;
			_tmp27_ = _tmp26_->message;
			geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Error converting internaldate '%s' to time_t: %s", _tmp25_, _tmp27_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (internaldate);
			_g_object_unref0 (select);
			return 0;
		}
		_tmp28_ = select;
		geary_db_result_next (_tmp28_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (internaldate);
			_g_object_unref0 (select);
			return 0;
		}
		_g_free0 (internaldate);
	}
	result = GEARY_DB_TRANSACTION_OUTCOME_COMMIT;
	_g_object_unref0 (select);
	return result;
}

static GearyDbTransactionOutcome
___lambda35__geary_db_transaction_method (GearyDbConnection* cx,
                                          GCancellable* cancellable,
                                          gpointer self,
                                          GError** error)
{
	GearyDbTransactionOutcome result;
	result = __lambda35_ ((GearyImapDBDatabase*) self, cx, error);
	return result;
}

static void
geary_imap_db_database_post_upgrade_populate_internal_date_time_t_ready (GObject* source_object,
                                                                         GAsyncResult* _res_,
                                                                         gpointer _user_data_)
{
	GearyImapDbDatabasePostUpgradePopulateInternalDateTimeTData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_imap_db_database_post_upgrade_populate_internal_date_time_t_co (_data_);
}

static gboolean
geary_imap_db_database_post_upgrade_populate_internal_date_time_t_co (GearyImapDbDatabasePostUpgradePopulateInternalDateTimeTData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	geary_db_database_exec_transaction_async (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_DB_TYPE_DATABASE, GearyDbDatabase), GEARY_DB_TRANSACTION_TYPE_RW, ___lambda35__geary_db_transaction_method, _data_->self, _data_->cancellable, geary_imap_db_database_post_upgrade_populate_internal_date_time_t_ready, _data_);
	return FALSE;
	_state_1:
	geary_db_database_exec_transaction_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_DB_TYPE_DATABASE, GearyDbDatabase), _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_imap_db_database_post_upgrade_populate_additional_attachments_data_free (gpointer _data)
{
	GearyImapDbDatabasePostUpgradePopulateAdditionalAttachmentsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyImapDbDatabasePostUpgradePopulateAdditionalAttachmentsData, _data_);
}

static void
geary_imap_db_database_post_upgrade_populate_additional_attachments (GearyImapDBDatabase* self,
                                                                     GCancellable* cancellable,
                                                                     GAsyncReadyCallback _callback_,
                                                                     gpointer _user_data_)
{
	GearyImapDbDatabasePostUpgradePopulateAdditionalAttachmentsData* _data_;
	GearyImapDBDatabase* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (GEARY_IMAP_DB_IS_DATABASE (self));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearyImapDbDatabasePostUpgradePopulateAdditionalAttachmentsData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_imap_db_database_post_upgrade_populate_additional_attachments_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	geary_imap_db_database_post_upgrade_populate_additional_attachments_co (_data_);
}

static void
geary_imap_db_database_post_upgrade_populate_additional_attachments_finish (GearyImapDBDatabase* self,
                                                                            GAsyncResult* _res_,
                                                                            GError** error)
{
	GearyImapDbDatabasePostUpgradePopulateAdditionalAttachmentsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static GearyDbTransactionOutcome
__lambda36_ (GearyImapDBDatabase* self,
             GearyDbConnection* cx,
             GError** error)
{
	GearyDbStatement* stmt = NULL;
	GearyDbStatement* _tmp0_;
	GearyDbStatement* _tmp1_;
	GearyDbStatement* _tmp2_;
	GearyDbStatement* _tmp3_;
	GearyDbStatement* _tmp4_;
	GearyDbStatement* _tmp5_;
	GearyDbStatement* _tmp6_;
	GearyDbResult* select = NULL;
	GearyDbStatement* _tmp7_;
	GearyDbResult* _tmp8_;
	GError* _inner_error0_ = NULL;
	GearyDbTransactionOutcome result;
	g_return_val_if_fail (GEARY_DB_IS_CONNECTION (cx), 0);
	_tmp0_ = geary_db_connection_prepare (cx, "\n" \
"                    SELECT id, header, body\n" \
"                    FROM MessageTable\n" \
"                    WHERE (fields & ?) = ?\n" \
"                    ", &_inner_error0_);
	stmt = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return 0;
	}
	_tmp1_ = stmt;
	_tmp2_ = geary_db_statement_bind_int (_tmp1_, 0, (gint) GEARY_EMAIL_REQUIRED_FOR_MESSAGE, &_inner_error0_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp3_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (stmt);
		return 0;
	}
	_tmp4_ = stmt;
	_tmp5_ = geary_db_statement_bind_int (_tmp4_, 1, (gint) GEARY_EMAIL_REQUIRED_FOR_MESSAGE, &_inner_error0_);
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp6_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (stmt);
		return 0;
	}
	_tmp7_ = stmt;
	_tmp8_ = geary_db_statement_exec (_tmp7_, NULL, &_inner_error0_);
	select = _tmp8_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (stmt);
		return 0;
	}
	while (TRUE) {
		GearyDbResult* _tmp9_;
		gboolean _tmp10_;
		gboolean _tmp11_;
		gint64 id = 0LL;
		GearyDbResult* _tmp12_;
		GearyMemoryBuffer* header = NULL;
		GearyDbResult* _tmp13_;
		GearyMemoryBuffer* _tmp14_;
		GearyMemoryBuffer* body = NULL;
		GearyDbResult* _tmp15_;
		GearyMemoryBuffer* _tmp16_;
		GearyDbResult* _tmp38_;
		_tmp9_ = select;
		_tmp10_ = geary_db_result_get_finished (_tmp9_);
		_tmp11_ = _tmp10_;
		if (!(!_tmp11_)) {
			break;
		}
		_tmp12_ = select;
		id = geary_db_result_rowid_at (_tmp12_, 0, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (select);
			_g_object_unref0 (stmt);
			return 0;
		}
		_tmp13_ = select;
		_tmp14_ = geary_db_result_string_buffer_at (_tmp13_, 1, &_inner_error0_);
		header = _tmp14_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (select);
			_g_object_unref0 (stmt);
			return 0;
		}
		_tmp15_ = select;
		_tmp16_ = geary_db_result_string_buffer_at (_tmp15_, 2, &_inner_error0_);
		body = _tmp16_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (header);
			_g_object_unref0 (select);
			_g_object_unref0 (stmt);
			return 0;
		}
		{
			GearyRFC822Header* _tmp17_ = NULL;
			GearyMemoryBuffer* _tmp18_;
			GearyRFC822Header* _tmp19_;
			GearyRFC822Message* message = NULL;
			GearyMemoryBuffer* _tmp20_;
			GearyRFC822Text* _tmp21_;
			GearyRFC822Text* _tmp22_;
			GearyRFC822Message* _tmp23_;
			GearyRFC822Message* _tmp24_;
			GearyMimeDispositionType target_disposition = 0;
			GeeList* _tmp25_ = NULL;
			GearyRFC822Message* _tmp26_;
			GeeList* _tmp27_;
			gboolean _tmp28_;
			gboolean _tmp29_;
			GeeList* _tmp30_ = NULL;
			GearyRFC822Message* _tmp31_;
			GeeList* _tmp32_;
			GFile* _tmp33_;
			GeeList* _tmp34_;
			GeeList* _tmp35_;
			_tmp18_ = header;
			_tmp19_ = geary_rf_c822_header_new (_tmp18_, &_inner_error0_);
			_tmp17_ = _tmp19_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp20_ = body;
			_tmp21_ = geary_rf_c822_text_new (_tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = geary_rf_c822_message_new_from_parts (_tmp17_, _tmp22_, &_inner_error0_);
			_tmp24_ = _tmp23_;
			_g_object_unref0 (_tmp22_);
			message = _tmp24_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (_tmp17_);
				goto __catch0_g_error;
			}
			target_disposition = GEARY_MIME_DISPOSITION_TYPE_UNSPECIFIED;
			_tmp26_ = message;
			_tmp27_ = geary_rf_c822_message_get_sub_messages (_tmp26_, &_inner_error0_);
			_tmp25_ = _tmp27_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (message);
				_g_object_unref0 (_tmp17_);
				goto __catch0_g_error;
			}
			_tmp28_ = gee_collection_get_is_empty (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, GEE_TYPE_COLLECTION, GeeCollection));
			_tmp29_ = _tmp28_;
			if (_tmp29_) {
				target_disposition = GEARY_MIME_DISPOSITION_TYPE_INLINE;
			}
			_tmp31_ = message;
			_tmp32_ = geary_rf_c822_message_get_attachments (_tmp31_, target_disposition, &_inner_error0_);
			_tmp30_ = _tmp32_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (_tmp25_);
				_g_object_unref0 (message);
				_g_object_unref0 (_tmp17_);
				goto __catch0_g_error;
			}
			_tmp33_ = self->attachments_path;
			_tmp34_ = geary_imap_db_attachment_save_attachments (cx, _tmp33_, id, _tmp30_, NULL, &_inner_error0_);
			_tmp35_ = _tmp34_;
			_g_object_unref0 (_tmp35_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (_tmp30_);
				_g_object_unref0 (_tmp25_);
				_g_object_unref0 (message);
				_g_object_unref0 (_tmp17_);
				goto __catch0_g_error;
			}
			_g_object_unref0 (_tmp30_);
			_g_object_unref0 (_tmp25_);
			_g_object_unref0 (message);
			_g_object_unref0 (_tmp17_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp36_;
			const gchar* _tmp37_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp36_ = e;
			_tmp37_ = _tmp36_->message;
			geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Error fetching inline Mime parts: %s", _tmp37_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (body);
			_g_object_unref0 (header);
			_g_object_unref0 (select);
			_g_object_unref0 (stmt);
			return 0;
		}
		_tmp38_ = select;
		geary_db_result_next (_tmp38_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (body);
			_g_object_unref0 (header);
			_g_object_unref0 (select);
			_g_object_unref0 (stmt);
			return 0;
		}
		_g_object_unref0 (body);
		_g_object_unref0 (header);
	}
	geary_db_connection_exec (cx, "DELETE FROM MessageSearchTable", NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (select);
		_g_object_unref0 (stmt);
		return 0;
	}
	result = GEARY_DB_TRANSACTION_OUTCOME_COMMIT;
	_g_object_unref0 (select);
	_g_object_unref0 (stmt);
	return result;
}

static GearyDbTransactionOutcome
___lambda36__geary_db_transaction_method (GearyDbConnection* cx,
                                          GCancellable* cancellable,
                                          gpointer self,
                                          GError** error)
{
	GearyDbTransactionOutcome result;
	result = __lambda36_ ((GearyImapDBDatabase*) self, cx, error);
	return result;
}

static void
geary_imap_db_database_post_upgrade_populate_additional_attachments_ready (GObject* source_object,
                                                                           GAsyncResult* _res_,
                                                                           gpointer _user_data_)
{
	GearyImapDbDatabasePostUpgradePopulateAdditionalAttachmentsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_imap_db_database_post_upgrade_populate_additional_attachments_co (_data_);
}

static gboolean
geary_imap_db_database_post_upgrade_populate_additional_attachments_co (GearyImapDbDatabasePostUpgradePopulateAdditionalAttachmentsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	geary_db_database_exec_transaction_async (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_DB_TYPE_DATABASE, GearyDbDatabase), GEARY_DB_TRANSACTION_TYPE_RW, ___lambda36__geary_db_transaction_method, _data_->self, _data_->cancellable, geary_imap_db_database_post_upgrade_populate_additional_attachments_ready, _data_);
	return FALSE;
	_state_1:
	geary_db_database_exec_transaction_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_DB_TYPE_DATABASE, GearyDbDatabase), _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_imap_db_database_post_upgrade_expand_page_size_data_free (gpointer _data)
{
	GearyImapDbDatabasePostUpgradeExpandPageSizeData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyImapDbDatabasePostUpgradeExpandPageSizeData, _data_);
}

static void
geary_imap_db_database_post_upgrade_expand_page_size (GearyImapDBDatabase* self,
                                                      GCancellable* cancellable,
                                                      GAsyncReadyCallback _callback_,
                                                      gpointer _user_data_)
{
	GearyImapDbDatabasePostUpgradeExpandPageSizeData* _data_;
	GearyImapDBDatabase* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (GEARY_IMAP_DB_IS_DATABASE (self));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearyImapDbDatabasePostUpgradeExpandPageSizeData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_imap_db_database_post_upgrade_expand_page_size_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	geary_imap_db_database_post_upgrade_expand_page_size_co (_data_);
}

static void
geary_imap_db_database_post_upgrade_expand_page_size_finish (GearyImapDBDatabase* self,
                                                             GAsyncResult* _res_,
                                                             GError** error)
{
	GearyImapDbDatabasePostUpgradeExpandPageSizeData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static Block50Data*
block50_data_ref (Block50Data* _data50_)
{
	g_atomic_int_inc (&_data50_->_ref_count_);
	return _data50_;
}

static void
block50_data_unref (void * _userdata_)
{
	Block50Data* _data50_;
	_data50_ = (Block50Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data50_->_ref_count_)) {
		GearyImapDBDatabase* self;
		self = _data50_->self;
		_g_object_unref0 (_data50_->cx);
		_g_object_unref0 (self);
		g_slice_free (Block50Data, _data50_);
	}
}

static void
geary_imap_db_database_post_upgrade_expand_page_size_ready (GObject* source_object,
                                                            GAsyncResult* _res_,
                                                            gpointer _user_data_)
{
	GearyImapDbDatabasePostUpgradeExpandPageSizeData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_imap_db_database_post_upgrade_expand_page_size_co (_data_);
}

static void
__lambda37_ (Block50Data* _data50_,
             GError** error)
{
	GearyImapDBDatabase* self;
	GearyDbConnection* _tmp0_;
	GError* _inner_error0_ = NULL;
	self = _data50_->self;
	_tmp0_ = _data50_->cx;
	geary_db_connection_exec (_tmp0_, "\n" \
"                    PRAGMA page_size = 4096;\n" \
"                    VACUUM;\n" \
"                ", NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

static void
___lambda37__geary_nonblocking_concurrent_concurrent_callback (GCancellable* cancellable,
                                                               gpointer self,
                                                               GError** error)
{
	__lambda37_ (self, error);
}

static gboolean
geary_imap_db_database_post_upgrade_expand_page_size_co (GearyImapDbDatabasePostUpgradeExpandPageSizeData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data50_ = g_slice_new0 (Block50Data);
	_data_->_data50_->_ref_count_ = 1;
	_data_->_data50_->self = g_object_ref (_data_->self);
	_data_->_data50_->_async_data_ = _data_;
	_data_->_state_ = 1;
	geary_db_database_open_connection (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_DB_TYPE_DATABASE, GearyDbDatabase), NULL, geary_imap_db_database_post_upgrade_expand_page_size_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp0_ = geary_db_database_open_connection_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_DB_TYPE_DATABASE, GearyDbDatabase), _data_->_res_, &_data_->_inner_error0_);
	_data_->_data50_->cx = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp0_, GEARY_DB_TYPE_CONNECTION, GearyDbConnection);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		block50_data_unref (_data_->_data50_);
		_data_->_data50_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = geary_nonblocking_concurrent_get_global ();
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_state_ = 2;
	geary_nonblocking_concurrent_schedule_async (_data_->_tmp2_, ___lambda37__geary_nonblocking_concurrent_concurrent_callback, _data_->_data50_, _data_->cancellable, geary_imap_db_database_post_upgrade_expand_page_size_ready, _data_);
	return FALSE;
	_state_2:
	geary_nonblocking_concurrent_schedule_finish (_data_->_tmp2_, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		block50_data_unref (_data_->_data50_);
		_data_->_data50_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	block50_data_unref (_data_->_data50_);
	_data_->_data50_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_imap_db_database_post_upgrade_fix_localized_internaldates_data_free (gpointer _data)
{
	GearyImapDbDatabasePostUpgradeFixLocalizedInternaldatesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyImapDbDatabasePostUpgradeFixLocalizedInternaldatesData, _data_);
}

static void
geary_imap_db_database_post_upgrade_fix_localized_internaldates (GearyImapDBDatabase* self,
                                                                 GCancellable* cancellable,
                                                                 GAsyncReadyCallback _callback_,
                                                                 gpointer _user_data_)
{
	GearyImapDbDatabasePostUpgradeFixLocalizedInternaldatesData* _data_;
	GearyImapDBDatabase* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (GEARY_IMAP_DB_IS_DATABASE (self));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearyImapDbDatabasePostUpgradeFixLocalizedInternaldatesData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_imap_db_database_post_upgrade_fix_localized_internaldates_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	geary_imap_db_database_post_upgrade_fix_localized_internaldates_co (_data_);
}

static void
geary_imap_db_database_post_upgrade_fix_localized_internaldates_finish (GearyImapDBDatabase* self,
                                                                        GAsyncResult* _res_,
                                                                        GError** error)
{
	GearyImapDbDatabasePostUpgradeFixLocalizedInternaldatesData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static gint64*
_int64_dup (gint64* self)
{
	gint64* dup;
	dup = g_new0 (gint64, 1);
	memcpy (dup, self, sizeof (gint64));
	return dup;
}

static GearyDbTransactionOutcome
__lambda38_ (GearyImapDBDatabase* self,
             GearyDbConnection* cx,
             GError** error)
{
	GearyDbStatement* stmt = NULL;
	GearyDbStatement* _tmp0_;
	GeeHashMap* invalid_ids = NULL;
	GeeHashMap* _tmp1_;
	GearyDbResult* results = NULL;
	GearyDbStatement* _tmp2_;
	GearyDbResult* _tmp3_;
	GearyDbStatement* _tmp28_ = NULL;
	GearyDbStatement* _tmp29_;
	GearyDbStatement* _tmp30_;
	GearyDbStatement* _tmp31_;
	GearyDbStatement* _tmp32_;
	GearyDbStatement* _tmp33_;
	GearyDbStatement* _tmp34_;
	GearyDbStatement* _tmp35_;
	GearyDbStatement* _tmp36_;
	GearyDbStatement* _tmp37_;
	GearyDbStatement* _tmp38_;
	GearyDbStatement* _tmp39_;
	GError* _inner_error0_ = NULL;
	GearyDbTransactionOutcome result;
	g_return_val_if_fail (GEARY_DB_IS_CONNECTION (cx), 0);
	_tmp0_ = geary_db_connection_prepare (cx, "\n" \
"                    SELECT id, internaldate, fields\n" \
"                    FROM MessageTable\n" \
"                ", &_inner_error0_);
	stmt = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return 0;
	}
	_tmp1_ = gee_hash_map_new (G_TYPE_INT64, (GBoxedCopyFunc) _int64_dup, (GDestroyNotify) g_free, GEARY_EMAIL_TYPE_FIELD, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	invalid_ids = _tmp1_;
	_tmp2_ = stmt;
	_tmp3_ = geary_db_statement_exec (_tmp2_, NULL, &_inner_error0_);
	results = _tmp3_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (invalid_ids);
		_g_object_unref0 (stmt);
		return 0;
	}
	while (TRUE) {
		GearyDbResult* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		gchar* internaldate = NULL;
		GearyDbResult* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		GearyDbResult* _tmp27_;
		_tmp4_ = results;
		_tmp5_ = geary_db_result_get_finished (_tmp4_);
		_tmp6_ = _tmp5_;
		if (!(!_tmp6_)) {
			break;
		}
		_tmp7_ = results;
		_tmp8_ = geary_db_result_string_at (_tmp7_, 1, &_inner_error0_);
		_tmp9_ = g_strdup (_tmp8_);
		internaldate = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (results);
			_g_object_unref0 (invalid_ids);
			_g_object_unref0 (stmt);
			return 0;
		}
		{
			const gchar* _tmp10_;
			_tmp10_ = internaldate;
			if (!geary_string_is_empty (_tmp10_)) {
				const gchar* _tmp11_;
				GearyImapInternalDate* _tmp12_;
				GearyImapInternalDate* _tmp13_;
				_tmp11_ = internaldate;
				_tmp12_ = geary_imap_internal_date_decode (_tmp11_, &_inner_error0_);
				_tmp13_ = _tmp12_;
				_g_object_unref0 (_tmp13_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* err = NULL;
			gint64 invalid_id = 0LL;
			GearyDbResult* _tmp14_;
			const gchar* _tmp15_ = NULL;
			const gchar* _tmp16_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			const gchar* _tmp20_;
			const gchar* _tmp21_;
			GError* _tmp22_;
			const gchar* _tmp23_;
			gint _tmp24_ = 0;
			GearyDbResult* _tmp25_;
			GeeHashMap* _tmp26_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp14_ = results;
			invalid_id = geary_db_result_rowid_at (_tmp14_, 0, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_error_free0 (err);
				goto __finally0;
			}
			_tmp16_ = internaldate;
			if (_tmp16_ != NULL) {
				const gchar* _tmp17_;
				_tmp17_ = internaldate;
				_tmp15_ = _tmp17_;
			} else {
				_tmp15_ = "(null)";
			}
			_tmp18_ = g_strdup_printf ("%" G_GINT64_FORMAT, invalid_id);
			_tmp19_ = _tmp18_;
			_tmp20_ = geary_db_database_get_path (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_DB_TYPE_DATABASE, GearyDbDatabase));
			_tmp21_ = _tmp20_;
			_tmp22_ = err;
			_tmp23_ = _tmp22_->message;
			geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Invalid INTERNALDATE \"%s\" found at row %s in %s: %s", _tmp15_, _tmp19_, _tmp21_, _tmp23_);
			_g_free0 (_tmp19_);
			_tmp25_ = results;
			_tmp24_ = geary_db_result_int_at (_tmp25_, 2, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_error_free0 (err);
				goto __finally0;
			}
			_tmp26_ = invalid_ids;
			gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), &invalid_id, (gpointer) ((gintptr) _tmp24_));
			_g_error_free0 (err);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (internaldate);
			_g_object_unref0 (results);
			_g_object_unref0 (invalid_ids);
			_g_object_unref0 (stmt);
			return 0;
		}
		_tmp27_ = results;
		geary_db_result_next (_tmp27_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (internaldate);
			_g_object_unref0 (results);
			_g_object_unref0 (invalid_ids);
			_g_object_unref0 (stmt);
			return 0;
		}
		_g_free0 (internaldate);
	}
	_tmp29_ = geary_db_connection_prepare (cx, "\n" \
"                    UPDATE MessageTable\n" \
"                    SET fields=?, internaldate=?, internaldate_time_t=" \
"?, rfc822_size=?\n" \
"                    WHERE id=?\n" \
"                ", &_inner_error0_);
	_tmp28_ = _tmp29_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (results);
		_g_object_unref0 (invalid_ids);
		_g_object_unref0 (stmt);
		return 0;
	}
	_tmp30_ = _tmp28_;
	_tmp28_ = NULL;
	_g_object_unref0 (stmt);
	stmt = _tmp30_;
	_tmp31_ = stmt;
	_tmp32_ = geary_db_statement_bind_null (_tmp31_, 1, &_inner_error0_);
	_tmp33_ = _tmp32_;
	_g_object_unref0 (_tmp33_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (_tmp28_);
		_g_object_unref0 (results);
		_g_object_unref0 (invalid_ids);
		_g_object_unref0 (stmt);
		return 0;
	}
	_tmp34_ = stmt;
	_tmp35_ = geary_db_statement_bind_null (_tmp34_, 2, &_inner_error0_);
	_tmp36_ = _tmp35_;
	_g_object_unref0 (_tmp36_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (_tmp28_);
		_g_object_unref0 (results);
		_g_object_unref0 (invalid_ids);
		_g_object_unref0 (stmt);
		return 0;
	}
	_tmp37_ = stmt;
	_tmp38_ = geary_db_statement_bind_null (_tmp37_, 3, &_inner_error0_);
	_tmp39_ = _tmp38_;
	_g_object_unref0 (_tmp39_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (_tmp28_);
		_g_object_unref0 (results);
		_g_object_unref0 (invalid_ids);
		_g_object_unref0 (stmt);
		return 0;
	}
	{
		GeeIterator* _invalid_id_it = NULL;
		GeeHashMap* _tmp40_;
		GeeSet* _tmp41_;
		GeeSet* _tmp42_;
		GeeSet* _tmp43_;
		GeeIterator* _tmp44_;
		GeeIterator* _tmp45_;
		_tmp40_ = invalid_ids;
		_tmp41_ = gee_abstract_map_get_keys (G_TYPE_CHECK_INSTANCE_CAST (_tmp40_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
		_tmp42_ = _tmp41_;
		_tmp43_ = _tmp42_;
		_tmp44_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp43_, GEE_TYPE_ITERABLE, GeeIterable));
		_tmp45_ = _tmp44_;
		_g_object_unref0 (_tmp43_);
		_invalid_id_it = _tmp45_;
		while (TRUE) {
			GeeIterator* _tmp46_;
			gint64 invalid_id = 0LL;
			GeeIterator* _tmp47_;
			gpointer _tmp48_;
			gint64* _tmp49_;
			gint64 _tmp50_;
			GearyDbStatement* _tmp51_;
			GeeHashMap* _tmp52_;
			gpointer _tmp53_;
			GearyDbStatement* _tmp54_;
			GearyDbStatement* _tmp55_;
			GearyDbStatement* _tmp56_;
			GearyDbStatement* _tmp57_;
			GearyDbStatement* _tmp58_;
			GearyDbStatement* _tmp59_;
			GearyDbResult* _tmp60_;
			GearyDbResult* _tmp61_;
			GearyDbStatement* _tmp62_;
			GearyDbStatement* _tmp63_;
			GearyDbStatement* _tmp64_;
			_tmp46_ = _invalid_id_it;
			if (!gee_iterator_next (_tmp46_)) {
				break;
			}
			_tmp47_ = _invalid_id_it;
			_tmp48_ = gee_iterator_get (_tmp47_);
			_tmp49_ = (gint64*) _tmp48_;
			_tmp50_ = *_tmp49_;
			_g_free0 (_tmp49_);
			invalid_id = _tmp50_;
			_tmp51_ = stmt;
			_tmp52_ = invalid_ids;
			_tmp53_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp52_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), &invalid_id);
			_tmp54_ = geary_db_statement_bind_int (_tmp51_, 0, (gint) geary_email_field_clear ((GearyEmailField) ((gintptr) _tmp53_), GEARY_EMAIL_FIELD_PROPERTIES), &_inner_error0_);
			_tmp55_ = _tmp54_;
			_g_object_unref0 (_tmp55_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (_invalid_id_it);
				_g_object_unref0 (_tmp28_);
				_g_object_unref0 (results);
				_g_object_unref0 (invalid_ids);
				_g_object_unref0 (stmt);
				return 0;
			}
			_tmp56_ = stmt;
			_tmp57_ = geary_db_statement_bind_rowid (_tmp56_, 4, invalid_id, &_inner_error0_);
			_tmp58_ = _tmp57_;
			_g_object_unref0 (_tmp58_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (_invalid_id_it);
				_g_object_unref0 (_tmp28_);
				_g_object_unref0 (results);
				_g_object_unref0 (invalid_ids);
				_g_object_unref0 (stmt);
				return 0;
			}
			_tmp59_ = stmt;
			_tmp60_ = geary_db_statement_exec (_tmp59_, NULL, &_inner_error0_);
			_tmp61_ = _tmp60_;
			_g_object_unref0 (_tmp61_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (_invalid_id_it);
				_g_object_unref0 (_tmp28_);
				_g_object_unref0 (results);
				_g_object_unref0 (invalid_ids);
				_g_object_unref0 (stmt);
				return 0;
			}
			_tmp62_ = stmt;
			_tmp63_ = geary_db_statement_reset (_tmp62_, GEARY_DB_RESET_SCOPE_SAVE_BINDINGS, &_inner_error0_);
			_tmp64_ = _tmp63_;
			_g_object_unref0 (_tmp64_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (_invalid_id_it);
				_g_object_unref0 (_tmp28_);
				_g_object_unref0 (results);
				_g_object_unref0 (invalid_ids);
				_g_object_unref0 (stmt);
				return 0;
			}
		}
		_g_object_unref0 (_invalid_id_it);
	}
	result = GEARY_DB_TRANSACTION_OUTCOME_COMMIT;
	_g_object_unref0 (_tmp28_);
	_g_object_unref0 (results);
	_g_object_unref0 (invalid_ids);
	_g_object_unref0 (stmt);
	return result;
}

static GearyDbTransactionOutcome
___lambda38__geary_db_transaction_method (GearyDbConnection* cx,
                                          GCancellable* cancellable,
                                          gpointer self,
                                          GError** error)
{
	GearyDbTransactionOutcome result;
	result = __lambda38_ ((GearyImapDBDatabase*) self, cx, error);
	return result;
}

static void
geary_imap_db_database_post_upgrade_fix_localized_internaldates_ready (GObject* source_object,
                                                                       GAsyncResult* _res_,
                                                                       gpointer _user_data_)
{
	GearyImapDbDatabasePostUpgradeFixLocalizedInternaldatesData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_imap_db_database_post_upgrade_fix_localized_internaldates_co (_data_);
}

static gboolean
geary_imap_db_database_post_upgrade_fix_localized_internaldates_co (GearyImapDbDatabasePostUpgradeFixLocalizedInternaldatesData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	geary_db_database_exec_transaction_async (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_DB_TYPE_DATABASE, GearyDbDatabase), GEARY_DB_TRANSACTION_TYPE_RW, ___lambda38__geary_db_transaction_method, _data_->self, _data_->cancellable, geary_imap_db_database_post_upgrade_fix_localized_internaldates_ready, _data_);
	return FALSE;
	_state_1:
	geary_db_database_exec_transaction_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_DB_TYPE_DATABASE, GearyDbDatabase), _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_imap_db_database_post_upgrade_validate_contacts_data_free (gpointer _data)
{
	GearyImapDbDatabasePostUpgradeValidateContactsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyImapDbDatabasePostUpgradeValidateContactsData, _data_);
}

static void
geary_imap_db_database_post_upgrade_validate_contacts (GearyImapDBDatabase* self,
                                                       GCancellable* cancellable,
                                                       GAsyncReadyCallback _callback_,
                                                       gpointer _user_data_)
{
	GearyImapDbDatabasePostUpgradeValidateContactsData* _data_;
	GearyImapDBDatabase* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (GEARY_IMAP_DB_IS_DATABASE (self));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearyImapDbDatabasePostUpgradeValidateContactsData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_imap_db_database_post_upgrade_validate_contacts_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	geary_imap_db_database_post_upgrade_validate_contacts_co (_data_);
}

static void
geary_imap_db_database_post_upgrade_validate_contacts_finish (GearyImapDBDatabase* self,
                                                              GAsyncResult* _res_,
                                                              GError** error)
{
	GearyImapDbDatabasePostUpgradeValidateContactsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static GearyDbTransactionOutcome
__lambda39_ (GearyImapDBDatabase* self,
             GearyDbConnection* cx,
             GError** error)
{
	GearyDbResult* _result_ = NULL;
	GearyDbResult* _tmp0_;
	GError* _inner_error0_ = NULL;
	GearyDbTransactionOutcome result;
	g_return_val_if_fail (GEARY_DB_IS_CONNECTION (cx), 0);
	_tmp0_ = geary_db_connection_query (cx, "SELECT id, email FROM ContactTable", NULL, &_inner_error0_);
	_result_ = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return 0;
	}
	while (TRUE) {
		GearyDbResult* _tmp1_;
		gboolean _tmp2_;
		gboolean _tmp3_;
		gchar* email = NULL;
		GearyDbResult* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		const gchar* _tmp7_;
		GearyDbResult* _tmp16_;
		_tmp1_ = _result_;
		_tmp2_ = geary_db_result_get_finished (_tmp1_);
		_tmp3_ = _tmp2_;
		if (!(!_tmp3_)) {
			break;
		}
		_tmp4_ = _result_;
		_tmp5_ = geary_db_result_string_at (_tmp4_, 1, &_inner_error0_);
		_tmp6_ = g_strdup (_tmp5_);
		email = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (_result_);
			return 0;
		}
		_tmp7_ = email;
		if (!geary_rf_c822_mailbox_address_is_valid_address (_tmp7_)) {
			gint64 id = 0LL;
			GearyDbResult* _tmp8_;
			GearyDbStatement* stmt = NULL;
			GearyDbStatement* _tmp9_;
			GearyDbStatement* _tmp10_;
			GearyDbStatement* _tmp11_;
			GearyDbStatement* _tmp12_;
			GearyDbStatement* _tmp13_;
			GearyDbResult* _tmp14_;
			GearyDbResult* _tmp15_;
			_tmp8_ = _result_;
			id = geary_db_result_rowid_at (_tmp8_, 0, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (email);
				_g_object_unref0 (_result_);
				return 0;
			}
			_tmp9_ = geary_db_connection_prepare (cx, "DELETE FROM ContactTable WHERE id = ?", &_inner_error0_);
			stmt = _tmp9_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (email);
				_g_object_unref0 (_result_);
				return 0;
			}
			_tmp10_ = stmt;
			_tmp11_ = geary_db_statement_bind_rowid (_tmp10_, 0, id, &_inner_error0_);
			_tmp12_ = _tmp11_;
			_g_object_unref0 (_tmp12_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (stmt);
				_g_free0 (email);
				_g_object_unref0 (_result_);
				return 0;
			}
			_tmp13_ = stmt;
			_tmp14_ = geary_db_statement_exec (_tmp13_, NULL, &_inner_error0_);
			_tmp15_ = _tmp14_;
			_g_object_unref0 (_tmp15_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (stmt);
				_g_free0 (email);
				_g_object_unref0 (_result_);
				return 0;
			}
			_g_object_unref0 (stmt);
		}
		_tmp16_ = _result_;
		geary_db_result_next (_tmp16_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (email);
			_g_object_unref0 (_result_);
			return 0;
		}
		_g_free0 (email);
	}
	result = GEARY_DB_TRANSACTION_OUTCOME_COMMIT;
	_g_object_unref0 (_result_);
	return result;
}

static GearyDbTransactionOutcome
___lambda39__geary_db_transaction_method (GearyDbConnection* cx,
                                          GCancellable* cancellable,
                                          gpointer self,
                                          GError** error)
{
	GearyDbTransactionOutcome result;
	result = __lambda39_ ((GearyImapDBDatabase*) self, cx, error);
	return result;
}

static void
geary_imap_db_database_post_upgrade_validate_contacts_ready (GObject* source_object,
                                                             GAsyncResult* _res_,
                                                             gpointer _user_data_)
{
	GearyImapDbDatabasePostUpgradeValidateContactsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_imap_db_database_post_upgrade_validate_contacts_co (_data_);
}

static gboolean
geary_imap_db_database_post_upgrade_validate_contacts_co (GearyImapDbDatabasePostUpgradeValidateContactsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	geary_db_database_exec_transaction_async (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_DB_TYPE_DATABASE, GearyDbDatabase), GEARY_DB_TRANSACTION_TYPE_RW, ___lambda39__geary_db_transaction_method, _data_->self, _data_->cancellable, geary_imap_db_database_post_upgrade_validate_contacts_ready, _data_);
	return FALSE;
	_state_1:
	geary_db_database_exec_transaction_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_DB_TYPE_DATABASE, GearyDbDatabase), _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_imap_db_database_post_upgrade_rebuild_attachments_data_free (gpointer _data)
{
	GearyImapDbDatabasePostUpgradeRebuildAttachmentsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyImapDbDatabasePostUpgradeRebuildAttachmentsData, _data_);
}

static void
geary_imap_db_database_post_upgrade_rebuild_attachments (GearyImapDBDatabase* self,
                                                         GCancellable* cancellable,
                                                         GAsyncReadyCallback _callback_,
                                                         gpointer _user_data_)
{
	GearyImapDbDatabasePostUpgradeRebuildAttachmentsData* _data_;
	GearyImapDBDatabase* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (GEARY_IMAP_DB_IS_DATABASE (self));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearyImapDbDatabasePostUpgradeRebuildAttachmentsData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_imap_db_database_post_upgrade_rebuild_attachments_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	geary_imap_db_database_post_upgrade_rebuild_attachments_co (_data_);
}

static void
geary_imap_db_database_post_upgrade_rebuild_attachments_finish (GearyImapDBDatabase* self,
                                                                GAsyncResult* _res_,
                                                                GError** error)
{
	GearyImapDbDatabasePostUpgradeRebuildAttachmentsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static GearyDbTransactionOutcome
__lambda40_ (GearyImapDBDatabase* self,
             GearyDbConnection* cx,
             GError** error)
{
	GearyDbStatement* stmt = NULL;
	GearyDbStatement* _tmp0_;
	GearyDbStatement* _tmp1_;
	GearyDbStatement* _tmp2_;
	GearyDbStatement* _tmp3_;
	GearyDbStatement* _tmp4_;
	GearyDbStatement* _tmp5_;
	GearyDbStatement* _tmp6_;
	GearyDbResult* results = NULL;
	GearyDbStatement* _tmp7_;
	GearyDbResult* _tmp8_;
	GearyDbResult* _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	GError* _inner_error0_ = NULL;
	GearyDbTransactionOutcome result;
	g_return_val_if_fail (GEARY_DB_IS_CONNECTION (cx), 0);
	_tmp0_ = geary_db_connection_prepare (cx, "\n" \
"                    SELECT id, header, body\n" \
"                    FROM MessageTable\n" \
"                    WHERE (fields & ?) = ?\n" \
"                    ", &_inner_error0_);
	stmt = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return 0;
	}
	_tmp1_ = stmt;
	_tmp2_ = geary_db_statement_bind_int (_tmp1_, 0, (gint) GEARY_EMAIL_REQUIRED_FOR_MESSAGE, &_inner_error0_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp3_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (stmt);
		return 0;
	}
	_tmp4_ = stmt;
	_tmp5_ = geary_db_statement_bind_int (_tmp4_, 1, (gint) GEARY_EMAIL_REQUIRED_FOR_MESSAGE, &_inner_error0_);
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp6_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (stmt);
		return 0;
	}
	_tmp7_ = stmt;
	_tmp8_ = geary_db_statement_exec (_tmp7_, NULL, &_inner_error0_);
	results = _tmp8_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (stmt);
		return 0;
	}
	_tmp9_ = results;
	_tmp10_ = geary_db_result_get_finished (_tmp9_);
	_tmp11_ = _tmp10_;
	if (_tmp11_) {
		result = GEARY_DB_TRANSACTION_OUTCOME_ROLLBACK;
		_g_object_unref0 (results);
		_g_object_unref0 (stmt);
		return result;
	}
	{
		gboolean _tmp12_ = FALSE;
		_tmp12_ = TRUE;
		while (TRUE) {
			gint64 message_id = 0LL;
			GearyDbResult* _tmp15_;
			GearyMemoryBuffer* header = NULL;
			GearyDbResult* _tmp16_;
			GearyMemoryBuffer* _tmp17_;
			GearyMemoryBuffer* body = NULL;
			GearyDbResult* _tmp18_;
			GearyMemoryBuffer* _tmp19_;
			GearyRFC822Message* message = NULL;
			GeeList* msg_attachments = NULL;
			GearyRFC822Message* _tmp32_;
			GeeList* _tmp33_;
			if (!_tmp12_) {
				gboolean _tmp13_ = FALSE;
				GearyDbResult* _tmp14_;
				_tmp14_ = results;
				_tmp13_ = geary_db_result_next (_tmp14_, NULL, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (results);
					_g_object_unref0 (stmt);
					return 0;
				}
				if (!_tmp13_) {
					break;
				}
			}
			_tmp12_ = FALSE;
			_tmp15_ = results;
			message_id = geary_db_result_rowid_at (_tmp15_, 0, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (results);
				_g_object_unref0 (stmt);
				return 0;
			}
			_tmp16_ = results;
			_tmp17_ = geary_db_result_string_buffer_at (_tmp16_, 1, &_inner_error0_);
			header = _tmp17_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (results);
				_g_object_unref0 (stmt);
				return 0;
			}
			_tmp18_ = results;
			_tmp19_ = geary_db_result_string_buffer_at (_tmp18_, 2, &_inner_error0_);
			body = _tmp19_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (header);
				_g_object_unref0 (results);
				_g_object_unref0 (stmt);
				return 0;
			}
			{
				GearyRFC822Header* _tmp20_ = NULL;
				GearyMemoryBuffer* _tmp21_;
				GearyRFC822Header* _tmp22_;
				GearyRFC822Message* _tmp23_ = NULL;
				GearyMemoryBuffer* _tmp24_;
				GearyRFC822Text* _tmp25_;
				GearyRFC822Text* _tmp26_;
				GearyRFC822Message* _tmp27_;
				GearyRFC822Message* _tmp28_;
				GearyRFC822Message* _tmp29_;
				_tmp21_ = header;
				_tmp22_ = geary_rf_c822_header_new (_tmp21_, &_inner_error0_);
				_tmp20_ = _tmp22_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				_tmp24_ = body;
				_tmp25_ = geary_rf_c822_text_new (_tmp24_);
				_tmp26_ = _tmp25_;
				_tmp27_ = geary_rf_c822_message_new_from_parts (_tmp20_, _tmp26_, &_inner_error0_);
				_tmp28_ = _tmp27_;
				_g_object_unref0 (_tmp26_);
				_tmp23_ = _tmp28_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (_tmp20_);
					goto __catch0_g_error;
				}
				_tmp29_ = _tmp23_;
				_tmp23_ = NULL;
				_g_object_unref0 (message);
				message = _tmp29_;
				_g_object_unref0 (_tmp23_);
				_g_object_unref0 (_tmp20_);
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* err = NULL;
				GError* _tmp30_;
				const gchar* _tmp31_;
				err = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp30_ = err;
				_tmp31_ = _tmp30_->message;
				geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Error decoding message: %s", _tmp31_);
				_g_error_free0 (err);
				_g_object_unref0 (message);
				_g_object_unref0 (body);
				_g_object_unref0 (header);
				continue;
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (message);
				_g_object_unref0 (body);
				_g_object_unref0 (header);
				_g_object_unref0 (results);
				_g_object_unref0 (stmt);
				return 0;
			}
			_tmp32_ = message;
			_tmp33_ = geary_rf_c822_message_get_attachments (_tmp32_, GEARY_MIME_DISPOSITION_TYPE_UNSPECIFIED, &_inner_error0_);
			msg_attachments = _tmp33_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (message);
				_g_object_unref0 (body);
				_g_object_unref0 (header);
				_g_object_unref0 (results);
				_g_object_unref0 (stmt);
				return 0;
			}
			{
				GFile* _tmp34_;
				_tmp34_ = self->attachments_path;
				geary_imap_db_attachment_delete_attachments (cx, _tmp34_, message_id, NULL, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch1_g_error;
				}
			}
			goto __finally1;
			__catch1_g_error:
			{
				GError* err = NULL;
				GError* _tmp35_;
				const gchar* _tmp36_;
				err = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp35_ = err;
				_tmp36_ = _tmp35_->message;
				geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Error deleting existing attachments: %s", _tmp36_);
				_g_error_free0 (err);
				_g_object_unref0 (msg_attachments);
				_g_object_unref0 (message);
				_g_object_unref0 (body);
				_g_object_unref0 (header);
				continue;
			}
			__finally1:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (msg_attachments);
				_g_object_unref0 (message);
				_g_object_unref0 (body);
				_g_object_unref0 (header);
				_g_object_unref0 (results);
				_g_object_unref0 (stmt);
				return 0;
			}
			{
				GFile* _tmp37_;
				GeeList* _tmp38_;
				GeeList* _tmp39_;
				GeeList* _tmp40_;
				_tmp37_ = self->attachments_path;
				_tmp38_ = msg_attachments;
				_tmp39_ = geary_imap_db_attachment_save_attachments (cx, _tmp37_, message_id, _tmp38_, NULL, &_inner_error0_);
				_tmp40_ = _tmp39_;
				_g_object_unref0 (_tmp40_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch2_g_error;
				}
			}
			goto __finally2;
			__catch2_g_error:
			{
				GError* err = NULL;
				GError* _tmp41_;
				const gchar* _tmp42_;
				err = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp41_ = err;
				_tmp42_ = _tmp41_->message;
				geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Error saving attachments: %s", _tmp42_);
				_g_error_free0 (err);
			}
			__finally2:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (msg_attachments);
				_g_object_unref0 (message);
				_g_object_unref0 (body);
				_g_object_unref0 (header);
				_g_object_unref0 (results);
				_g_object_unref0 (stmt);
				return 0;
			}
			_g_object_unref0 (msg_attachments);
			_g_object_unref0 (message);
			_g_object_unref0 (body);
			_g_object_unref0 (header);
		}
	}
	geary_db_connection_exec (cx, "DELETE FROM MessageSearchTable", NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (results);
		_g_object_unref0 (stmt);
		return 0;
	}
	result = GEARY_DB_TRANSACTION_OUTCOME_COMMIT;
	_g_object_unref0 (results);
	_g_object_unref0 (stmt);
	return result;
}

static GearyDbTransactionOutcome
___lambda40__geary_db_transaction_method (GearyDbConnection* cx,
                                          GCancellable* cancellable,
                                          gpointer self,
                                          GError** error)
{
	GearyDbTransactionOutcome result;
	result = __lambda40_ ((GearyImapDBDatabase*) self, cx, error);
	return result;
}

static void
geary_imap_db_database_post_upgrade_rebuild_attachments_ready (GObject* source_object,
                                                               GAsyncResult* _res_,
                                                               gpointer _user_data_)
{
	GearyImapDbDatabasePostUpgradeRebuildAttachmentsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_imap_db_database_post_upgrade_rebuild_attachments_co (_data_);
}

static gboolean
geary_imap_db_database_post_upgrade_rebuild_attachments_co (GearyImapDbDatabasePostUpgradeRebuildAttachmentsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	geary_db_database_exec_transaction_async (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_DB_TYPE_DATABASE, GearyDbDatabase), GEARY_DB_TRANSACTION_TYPE_RW, ___lambda40__geary_db_transaction_method, _data_->self, _data_->cancellable, geary_imap_db_database_post_upgrade_rebuild_attachments_ready, _data_);
	return FALSE;
	_state_1:
	geary_db_database_exec_transaction_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_DB_TYPE_DATABASE, GearyDbDatabase), _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

/**
     * Determines if the database's FTS table indexes are valid.
     */
gboolean
geary_imap_db_database_fts_integrity_check (GearyImapDBDatabase* self,
                                            GError** error)
{
	GearyDbStatement* stmt = NULL;
	GearyDbStatement* _tmp0_;
	gboolean passed = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (GEARY_IMAP_DB_IS_DATABASE (self), FALSE);
	_tmp0_ = geary_db_database_prepare (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_DB_TYPE_DATABASE, GearyDbDatabase), "\n" \
"            INSERT INTO MessageSearchTable(MessageSearchTable)\n" \
"                VALUES('integrity-check')\n" \
"        ", &_inner_error0_);
	stmt = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp1_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		return _tmp1_;
	}
	passed = TRUE;
	{
		GearyDbStatement* _tmp2_;
		GearyDbResult* _tmp3_;
		GearyDbResult* _tmp4_;
		_tmp2_ = stmt;
		_tmp3_ = geary_db_statement_exec (_tmp2_, NULL, &_inner_error0_);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp4_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (g_error_matches (_inner_error0_, GEARY_DATABASE_ERROR, GEARY_DATABASE_ERROR_CORRUPT)) {
				goto __catch0_geary_database_error_corrupt;
			}
			goto __finally0;
		}
	}
	goto __finally0;
	__catch0_geary_database_error_corrupt:
	{
		g_clear_error (&_inner_error0_);
		passed = FALSE;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp5_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (stmt);
		return _tmp5_;
	}
	result = passed;
	_g_object_unref0 (stmt);
	return result;
}

/**
     * Rebuilds the database's FTS table index.
     *
     * This can be used to recover from corrupt indexes, as indicated
     * by fts_integrity_check() returning false.
     */
void
geary_imap_db_database_fts_rebuild (GearyImapDBDatabase* self,
                                    GError** error)
{
	GearyDbStatement* stmt = NULL;
	GearyDbStatement* _tmp0_;
	GearyDbStatement* _tmp1_;
	GearyDbResult* _tmp2_;
	GearyDbResult* _tmp3_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (GEARY_IMAP_DB_IS_DATABASE (self));
	_tmp0_ = geary_db_database_prepare (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_DB_TYPE_DATABASE, GearyDbDatabase), "\n" \
"            INSERT INTO MessageSearchTable(MessageSearchTable)\n" \
"                VALUES('rebuild')\n" \
"        ", &_inner_error0_);
	stmt = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp1_ = stmt;
	_tmp2_ = geary_db_statement_exec (_tmp1_, NULL, &_inner_error0_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp3_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (stmt);
		return;
	}
	_g_object_unref0 (stmt);
}

/**
     * Optimises the database's FTS table index.
     *
     * This is an expensive call, as much as performing a VACUUM.
     */
void
geary_imap_db_database_fts_optimize (GearyImapDBDatabase* self,
                                     GError** error)
{
	GearyDbStatement* stmt = NULL;
	GearyDbStatement* _tmp0_;
	GearyDbStatement* _tmp1_;
	GearyDbResult* _tmp2_;
	GearyDbResult* _tmp3_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (GEARY_IMAP_DB_IS_DATABASE (self));
	_tmp0_ = geary_db_database_prepare (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_DB_TYPE_DATABASE, GearyDbDatabase), "\n" \
"            INSERT INTO MessageSearchTable(MessageSearchTable)\n" \
"                VALUES('optimize')\n" \
"        ", &_inner_error0_);
	stmt = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp1_ = stmt;
	_tmp2_ = geary_db_statement_exec (_tmp1_, NULL, &_inner_error0_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp3_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (stmt);
		return;
	}
	_g_object_unref0 (stmt);
}

static void
_geary_imap_db_database_utf8_transliterate_fold_sqlite_user_func_callback (sqlite3_context* context,
                                                                           gint values_length1,
                                                                           sqlite3_value** values)
{
	geary_imap_db_database_utf8_transliterate_fold (context, values, values_length1);
}

static gint
_geary_imap_db_database_utf8_collate_sqlite_compare_callback (gpointer self,
                                                              gint alen,
                                                              void* a,
                                                              gint blen,
                                                              void* b)
{
	gint result;
	result = geary_imap_db_database_utf8_collate (alen, a, blen, b);
	return result;
}

static void
geary_imap_db_database_real_prepare_connection (GearyDbDatabase* base,
                                                GearyDbDatabaseConnection* cx,
                                                GError** error)
{
	GearyImapDBDatabase * self;
	sqlite3* _tmp2_;
	sqlite3* _tmp3_;
	sqlite3* _tmp4_;
	sqlite3* _tmp5_;
	sqlite3* _tmp6_;
	sqlite3* _tmp7_;
	sqlite3* _tmp9_;
	sqlite3* _tmp10_;
	GError* _inner_error0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_DB_TYPE_DATABASE, GearyImapDBDatabase);
	g_return_if_fail (GEARY_DB_IS_DATABASE_CONNECTION (cx));
	geary_db_database_connection_set_busy_timeout_msec (cx, GEARY_DB_DATABASE_CONNECTION_RECOMMENDED_BUSY_TIMEOUT_MSEC, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	geary_db_connection_set_foreign_keys (G_TYPE_CHECK_INSTANCE_CAST (cx, GEARY_DB_TYPE_CONNECTION, GearyDbConnection), TRUE, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	geary_db_connection_set_recursive_triggers (G_TYPE_CHECK_INSTANCE_CAST (cx, GEARY_DB_TYPE_CONNECTION, GearyDbConnection), TRUE, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	geary_db_connection_set_synchronous (G_TYPE_CHECK_INSTANCE_CAST (cx, GEARY_DB_TYPE_CONNECTION, GearyDbConnection), GEARY_DB_SYNCHRONOUS_MODE_NORMAL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	if (self->priv->is_open_in_progress) {
		sqlite3* _tmp0_;
		sqlite3* _tmp1_;
		_tmp0_ = geary_db_connection_get_db (G_TYPE_CHECK_INSTANCE_CAST (cx, GEARY_DB_TYPE_CONNECTION, GearyDbConnection));
		_tmp1_ = _tmp0_;
		sqlite3_register_legacy_tokenizer (_tmp1_);
	}
	_tmp2_ = geary_db_connection_get_db (G_TYPE_CHECK_INSTANCE_CAST (cx, GEARY_DB_TYPE_CONNECTION, GearyDbConnection));
	_tmp3_ = _tmp2_;
	sqlite3_register_fts5_tokeniser (_tmp3_);
	_tmp4_ = geary_db_connection_get_db (G_TYPE_CHECK_INSTANCE_CAST (cx, GEARY_DB_TYPE_CONNECTION, GearyDbConnection));
	_tmp5_ = _tmp4_;
	sqlite3_register_fts5_matches (_tmp5_);
	_tmp6_ = geary_db_connection_get_db (G_TYPE_CHECK_INSTANCE_CAST (cx, GEARY_DB_TYPE_CONNECTION, GearyDbConnection));
	_tmp7_ = _tmp6_;
	if (sqlite3_create_function (_tmp7_, GEARY_IMAP_DB_DATABASE_UTF8_CASE_INSENSITIVE_FN, 1, SQLITE_UTF8, NULL, _geary_imap_db_database_utf8_transliterate_fold_sqlite_user_func_callback, NULL, NULL) != SQLITE_OK) {
		GError* _tmp8_;
		_tmp8_ = g_error_new (GEARY_DATABASE_ERROR, GEARY_DATABASE_ERROR_GENERAL, "Failed to register function %s", GEARY_IMAP_DB_DATABASE_UTF8_CASE_INSENSITIVE_FN);
		_inner_error0_ = _tmp8_;
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp9_ = geary_db_connection_get_db (G_TYPE_CHECK_INSTANCE_CAST (cx, GEARY_DB_TYPE_CONNECTION, GearyDbConnection));
	_tmp10_ = _tmp9_;
	if (sqlite3_create_collation (_tmp10_, GEARY_IMAP_DB_DATABASE_UTF8_COLLATE, SQLITE_UTF8, NULL, (int (*)(void *, int,  const void *, int,  const void *)) _geary_imap_db_database_utf8_collate_sqlite_compare_callback) != SQLITE_OK) {
		GError* _tmp11_;
		_tmp11_ = g_error_new (GEARY_DATABASE_ERROR, GEARY_DATABASE_ERROR_GENERAL, "Failed to register collation %s", GEARY_IMAP_DB_DATABASE_UTF8_COLLATE);
		_inner_error0_ = _tmp11_;
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

static void
geary_imap_db_database_class_init (GearyImapDBDatabaseClass * klass,
                                   gpointer klass_data)
{
	geary_imap_db_database_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyImapDBDatabase_private_offset);
	((GearyDbDatabaseClass *) klass)->close = (void (*) (GearyDbDatabase*, GCancellable*, GError**)) geary_imap_db_database_real_close;
	((GearyDbVersionedDatabaseClass *) klass)->starting_upgrade = (void (*) (GearyDbVersionedDatabase*, gint, gboolean)) geary_imap_db_database_real_starting_upgrade;
	((GearyDbVersionedDatabaseClass *) klass)->completed_upgrade = (void (*) (GearyDbVersionedDatabase*, gint)) geary_imap_db_database_real_completed_upgrade;
	((GearyDbVersionedDatabaseClass *) klass)->post_upgrade = (void (*) (GearyDbVersionedDatabase*, gint, GCancellable*, GAsyncReadyCallback, gpointer)) geary_imap_db_database_real_post_upgrade;
	((GearyDbVersionedDatabaseClass *) klass)->post_upgrade_finish = (void (*) (GearyDbVersionedDatabase*, GAsyncResult*, GError**)) geary_imap_db_database_post_upgrade_finish;
	((GearyDbDatabaseClass *) klass)->prepare_connection = (void (*) (GearyDbDatabase*, GearyDbDatabaseConnection*, GError**)) geary_imap_db_database_real_prepare_connection;
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_imap_db_database_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_geary_imap_db_database_set_property;
	G_OBJECT_CLASS (klass)->finalize = geary_imap_db_database_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_IMAP_DB_DATABASE_WANT_BACKGROUND_VACUUM_PROPERTY, geary_imap_db_database_properties[GEARY_IMAP_DB_DATABASE_WANT_BACKGROUND_VACUUM_PROPERTY] = g_param_spec_boolean ("want-background-vacuum", "want-background-vacuum", "want-background-vacuum", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
geary_imap_db_database_instance_init (GearyImapDBDatabase * self,
                                      gpointer klass)
{
	GCancellable* _tmp0_;
	self->priv = geary_imap_db_database_get_instance_private (self);
	self->priv->_want_background_vacuum = FALSE;
	self->priv->new_db = FALSE;
	self->priv->is_open_in_progress = FALSE;
	self->priv->gc = NULL;
	_tmp0_ = g_cancellable_new ();
	self->priv->gc_cancellable = _tmp0_;
}

static void
geary_imap_db_database_finalize (GObject * obj)
{
	GearyImapDBDatabase * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_IMAP_DB_TYPE_DATABASE, GearyImapDBDatabase);
	_g_object_unref0 (self->attachments_path);
	_g_object_unref0 (self->priv->upgrade_monitor);
	_g_object_unref0 (self->priv->vacuum_monitor);
	_geary_imap_db_gc_unref0 (self->priv->gc);
	_g_object_unref0 (self->priv->gc_cancellable);
	G_OBJECT_CLASS (geary_imap_db_database_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
geary_imap_db_database_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyImapDBDatabaseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_imap_db_database_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyImapDBDatabase), 0, (GInstanceInitFunc) geary_imap_db_database_instance_init, NULL };
	GType geary_imap_db_database_type_id;
	geary_imap_db_database_type_id = g_type_register_static (GEARY_DB_TYPE_VERSIONED_DATABASE, "GearyImapDBDatabase", &g_define_type_info, 0);
	GearyImapDBDatabase_private_offset = g_type_add_instance_private (geary_imap_db_database_type_id, sizeof (GearyImapDBDatabasePrivate));
	return geary_imap_db_database_type_id;
}

GType
geary_imap_db_database_get_type (void)
{
	static gsize geary_imap_db_database_type_id__once = 0;
	if (g_once_init_enter (&geary_imap_db_database_type_id__once)) {
		GType geary_imap_db_database_type_id;
		geary_imap_db_database_type_id = geary_imap_db_database_get_type_once ();
		g_once_init_leave (&geary_imap_db_database_type_id__once, geary_imap_db_database_type_id);
	}
	return geary_imap_db_database_type_id__once;
}

static void
_vala_geary_imap_db_database_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	GearyImapDBDatabase * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_IMAP_DB_TYPE_DATABASE, GearyImapDBDatabase);
	switch (property_id) {
		case GEARY_IMAP_DB_DATABASE_WANT_BACKGROUND_VACUUM_PROPERTY:
		g_value_set_boolean (value, geary_imap_db_database_get_want_background_vacuum (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_geary_imap_db_database_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	GearyImapDBDatabase * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_IMAP_DB_TYPE_DATABASE, GearyImapDBDatabase);
	switch (property_id) {
		case GEARY_IMAP_DB_DATABASE_WANT_BACKGROUND_VACUUM_PROPERTY:
		geary_imap_db_database_set_want_background_vacuum (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

