/* imap-literal-parameter.c generated by valac 0.56.3, the Vala compiler
 * generated from imap-literal-parameter.vala, do not modify */

/*
 * Copyright 2016 Software Freedom Conservancy Inc.
 * Copyright 2019 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later). See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>

enum  {
	GEARY_IMAP_LITERAL_PARAMETER_0_PROPERTY,
	GEARY_IMAP_LITERAL_PARAMETER_VALUE_PROPERTY,
	GEARY_IMAP_LITERAL_PARAMETER_NUM_PROPERTIES
};
static GParamSpec* geary_imap_literal_parameter_properties[GEARY_IMAP_LITERAL_PARAMETER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _GearyImapLiteralParameterPrivate {
	GearyMemoryBuffer* _value;
};

static gint GearyImapLiteralParameter_private_offset;
static gpointer geary_imap_literal_parameter_parent_class = NULL;

static void geary_imap_literal_parameter_set_value (GearyImapLiteralParameter* self,
                                             GearyMemoryBuffer* value);
static gchar* geary_imap_literal_parameter_real_to_string (GearyImapParameter* base);
static void geary_imap_literal_parameter_real_serialize (GearyImapParameter* base,
                                                  GearyImapSerializer* ser,
                                                  GCancellable* cancellable,
                                                  GError** error);
static void geary_imap_literal_parameter_finalize (GObject * obj);
static GType geary_imap_literal_parameter_get_type_once (void);
static void _vala_geary_imap_literal_parameter_get_property (GObject * object,
                                                      guint property_id,
                                                      GValue * value,
                                                      GParamSpec * pspec);
static void _vala_geary_imap_literal_parameter_set_property (GObject * object,
                                                      guint property_id,
                                                      const GValue * value,
                                                      GParamSpec * pspec);

static inline gpointer
geary_imap_literal_parameter_get_instance_private (GearyImapLiteralParameter* self)
{
	return G_STRUCT_MEMBER_P (self, GearyImapLiteralParameter_private_offset);
}

GearyMemoryBuffer*
geary_imap_literal_parameter_get_value (GearyImapLiteralParameter* self)
{
	GearyMemoryBuffer* result;
	GearyMemoryBuffer* _tmp0_;
	g_return_val_if_fail (GEARY_IMAP_IS_LITERAL_PARAMETER (self), NULL);
	_tmp0_ = self->priv->_value;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
geary_imap_literal_parameter_set_value (GearyImapLiteralParameter* self,
                                        GearyMemoryBuffer* value)
{
	GearyMemoryBuffer* old_value;
	g_return_if_fail (GEARY_IMAP_IS_LITERAL_PARAMETER (self));
	old_value = geary_imap_literal_parameter_get_value (self);
	if (old_value != value) {
		GearyMemoryBuffer* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_value);
		self->priv->_value = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_imap_literal_parameter_properties[GEARY_IMAP_LITERAL_PARAMETER_VALUE_PROPERTY]);
	}
}

GearyImapLiteralParameter*
geary_imap_literal_parameter_construct (GType object_type,
                                        GearyMemoryBuffer* value)
{
	GearyImapLiteralParameter * self = NULL;
	g_return_val_if_fail (GEARY_MEMORY_IS_BUFFER (value), NULL);
	self = (GearyImapLiteralParameter*) geary_imap_parameter_construct (object_type);
	geary_imap_literal_parameter_set_value (self, value);
	return self;
}

GearyImapLiteralParameter*
geary_imap_literal_parameter_new (GearyMemoryBuffer* value)
{
	return geary_imap_literal_parameter_construct (GEARY_IMAP_TYPE_LITERAL_PARAMETER, value);
}

/**
     * Returns the {@link LiteralParameter} as though it had been a {@link StringParameter} on the
     * wire.
     *
     * Note that this does not deal with quoting issues or NIL (which should never be
     * literalized to begin with).  It merely converts the literal data to a UTF-8 string and
     * returns it as a StringParameter.  Hence, the data is being coerced and may be unsuitable
     * for transmitting on the wire.
     */
GearyImapStringParameter*
geary_imap_literal_parameter_coerce_to_string_parameter (GearyImapLiteralParameter* self)
{
	GearyMemoryBuffer* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GearyImapUnquotedStringParameter* _tmp3_;
	GearyImapStringParameter* _tmp4_;
	GearyImapStringParameter* result;
	g_return_val_if_fail (GEARY_IMAP_IS_LITERAL_PARAMETER (self), NULL);
	_tmp0_ = self->priv->_value;
	_tmp1_ = geary_memory_buffer_get_valid_utf8 (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = geary_imap_unquoted_string_parameter_new (_tmp2_);
	_tmp4_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEARY_IMAP_TYPE_STRING_PARAMETER, GearyImapStringParameter);
	_g_free0 (_tmp2_);
	result = _tmp4_;
	return result;
}

/**
     * {@inheritDoc}
     */
static gchar*
geary_imap_literal_parameter_real_to_string (GearyImapParameter* base)
{
	GearyImapLiteralParameter * self;
	GearyMemoryBuffer* _tmp0_;
	gsize _tmp1_;
	gsize _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_TYPE_LITERAL_PARAMETER, GearyImapLiteralParameter);
	_tmp0_ = self->priv->_value;
	_tmp1_ = geary_memory_buffer_get_size (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup_printf ("{literal/%lub}", (gulong) _tmp2_);
	result = _tmp3_;
	return result;
}

/**
     * {@inheritDoc}
     */
static void
geary_imap_literal_parameter_real_serialize (GearyImapParameter* base,
                                             GearyImapSerializer* ser,
                                             GCancellable* cancellable,
                                             GError** error)
{
	GearyImapLiteralParameter * self;
	GearyMemoryBuffer* _tmp0_;
	gsize _tmp1_;
	gsize _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GError* _inner_error0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_TYPE_LITERAL_PARAMETER, GearyImapLiteralParameter);
	g_return_if_fail (GEARY_IMAP_IS_SERIALIZER (ser));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_tmp0_ = self->priv->_value;
	_tmp1_ = geary_memory_buffer_get_size (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup_printf ("{%lu}", (gulong) _tmp2_);
	_tmp4_ = _tmp3_;
	geary_imap_serializer_push_unquoted_string (ser, _tmp4_, cancellable, &_inner_error0_);
	_g_free0 (_tmp4_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	geary_imap_serializer_push_eol (ser, cancellable, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

static void
geary_imap_literal_parameter_class_init (GearyImapLiteralParameterClass * klass,
                                         gpointer klass_data)
{
	geary_imap_literal_parameter_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyImapLiteralParameter_private_offset);
	((GearyImapParameterClass *) klass)->to_string = (gchar* (*) (GearyImapParameter*)) geary_imap_literal_parameter_real_to_string;
	((GearyImapParameterClass *) klass)->serialize = (void (*) (GearyImapParameter*, GearyImapSerializer*, GCancellable*, GError**)) geary_imap_literal_parameter_real_serialize;
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_imap_literal_parameter_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_geary_imap_literal_parameter_set_property;
	G_OBJECT_CLASS (klass)->finalize = geary_imap_literal_parameter_finalize;
	/** The value of the literal parameter. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_IMAP_LITERAL_PARAMETER_VALUE_PROPERTY, geary_imap_literal_parameter_properties[GEARY_IMAP_LITERAL_PARAMETER_VALUE_PROPERTY] = g_param_spec_object ("value", "value", "value", GEARY_MEMORY_TYPE_BUFFER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
geary_imap_literal_parameter_instance_init (GearyImapLiteralParameter * self,
                                            gpointer klass)
{
	self->priv = geary_imap_literal_parameter_get_instance_private (self);
}

static void
geary_imap_literal_parameter_finalize (GObject * obj)
{
	GearyImapLiteralParameter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_IMAP_TYPE_LITERAL_PARAMETER, GearyImapLiteralParameter);
	_g_object_unref0 (self->priv->_value);
	G_OBJECT_CLASS (geary_imap_literal_parameter_parent_class)->finalize (obj);
}

/**
 * A representation of an IMAP literal parameter.
 *
 * Because a literal parameter can hold 8-bit data, this is not a
 * descendent of {@link StringParameter}, although some times literal
 * data is used to store 8-bit text (for example, UTF-8).
 *
 * See [[http://tools.ietf.org/html/rfc3501#section-4.3]]
 */
 G_GNUC_NO_INLINE static GType
geary_imap_literal_parameter_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyImapLiteralParameterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_imap_literal_parameter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyImapLiteralParameter), 0, (GInstanceInitFunc) geary_imap_literal_parameter_instance_init, NULL };
	GType geary_imap_literal_parameter_type_id;
	geary_imap_literal_parameter_type_id = g_type_register_static (GEARY_IMAP_TYPE_PARAMETER, "GearyImapLiteralParameter", &g_define_type_info, 0);
	GearyImapLiteralParameter_private_offset = g_type_add_instance_private (geary_imap_literal_parameter_type_id, sizeof (GearyImapLiteralParameterPrivate));
	return geary_imap_literal_parameter_type_id;
}

GType
geary_imap_literal_parameter_get_type (void)
{
	static gsize geary_imap_literal_parameter_type_id__once = 0;
	if (g_once_init_enter (&geary_imap_literal_parameter_type_id__once)) {
		GType geary_imap_literal_parameter_type_id;
		geary_imap_literal_parameter_type_id = geary_imap_literal_parameter_get_type_once ();
		g_once_init_leave (&geary_imap_literal_parameter_type_id__once, geary_imap_literal_parameter_type_id);
	}
	return geary_imap_literal_parameter_type_id__once;
}

static void
_vala_geary_imap_literal_parameter_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec)
{
	GearyImapLiteralParameter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_IMAP_TYPE_LITERAL_PARAMETER, GearyImapLiteralParameter);
	switch (property_id) {
		case GEARY_IMAP_LITERAL_PARAMETER_VALUE_PROPERTY:
		g_value_set_object (value, geary_imap_literal_parameter_get_value (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_geary_imap_literal_parameter_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec)
{
	GearyImapLiteralParameter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_IMAP_TYPE_LITERAL_PARAMETER, GearyImapLiteralParameter);
	switch (property_id) {
		case GEARY_IMAP_LITERAL_PARAMETER_VALUE_PROPERTY:
		geary_imap_literal_parameter_set_value (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

