/* rfc822-message-data.c generated by valac 0.56.3, the Vala compiler
 * generated from rfc822-message-data.vala, do not modify */

/*
 * Copyright © 2016 Software Freedom Conservancy Inc.
 * Copyright © 2020-2021 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <gmime/gmime.h>

enum  {
	GEARY_RF_C822_MESSAGE_ID_0_PROPERTY,
	GEARY_RF_C822_MESSAGE_ID_NUM_PROPERTIES
};
static GParamSpec* geary_rf_c822_message_id_properties[GEARY_RF_C822_MESSAGE_ID_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	GEARY_RF_C822_MESSAGE_ID_LIST_0_PROPERTY,
	GEARY_RF_C822_MESSAGE_ID_LIST_SIZE_PROPERTY,
	GEARY_RF_C822_MESSAGE_ID_LIST_IS_EMPTY_PROPERTY,
	GEARY_RF_C822_MESSAGE_ID_LIST_NUM_PROPERTIES
};
static GParamSpec* geary_rf_c822_message_id_list_properties[GEARY_RF_C822_MESSAGE_ID_LIST_NUM_PROPERTIES];
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
enum  {
	GEARY_RF_C822_DATE_0_PROPERTY,
	GEARY_RF_C822_DATE_VALUE_PROPERTY,
	GEARY_RF_C822_DATE_NUM_PROPERTIES
};
static GParamSpec* geary_rf_c822_date_properties[GEARY_RF_C822_DATE_NUM_PROPERTIES];
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
enum  {
	GEARY_RF_C822_SUBJECT_0_PROPERTY,
	GEARY_RF_C822_SUBJECT_NUM_PROPERTIES
};
static GParamSpec* geary_rf_c822_subject_properties[GEARY_RF_C822_SUBJECT_NUM_PROPERTIES];
#define __vala_GMimeFormatOptions_free0(var) ((var == NULL) ? NULL : (var = (_vala_GMimeFormatOptions_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	GEARY_RF_C822_HEADER_0_PROPERTY,
	GEARY_RF_C822_HEADER_NUM_PROPERTIES
};
static GParamSpec* geary_rf_c822_header_properties[GEARY_RF_C822_HEADER_NUM_PROPERTIES];
enum  {
	GEARY_RF_C822_TEXT_0_PROPERTY,
	GEARY_RF_C822_TEXT_NUM_PROPERTIES
};
static GParamSpec* geary_rf_c822_text_properties[GEARY_RF_C822_TEXT_NUM_PROPERTIES];

#define GEARY_RF_C822_TEXT_TYPE_GMIME_BUFFER (geary_rf_c822_text_gmime_buffer_get_type ())
#define GEARY_RF_C822_TEXT_GMIME_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_RF_C822_TEXT_TYPE_GMIME_BUFFER, GearyRFC822TextGMimeBuffer))
#define GEARY_RF_C822_TEXT_GMIME_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_RF_C822_TEXT_TYPE_GMIME_BUFFER, GearyRFC822TextGMimeBufferClass))
#define GEARY_RF_C822_TEXT_IS_GMIME_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_RF_C822_TEXT_TYPE_GMIME_BUFFER))
#define GEARY_RF_C822_TEXT_IS_GMIME_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_RF_C822_TEXT_TYPE_GMIME_BUFFER))
#define GEARY_RF_C822_TEXT_GMIME_BUFFER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_RF_C822_TEXT_TYPE_GMIME_BUFFER, GearyRFC822TextGMimeBufferClass))

typedef struct _GearyRFC822TextGMimeBuffer GearyRFC822TextGMimeBuffer;
typedef struct _GearyRFC822TextGMimeBufferClass GearyRFC822TextGMimeBufferClass;
typedef struct _GearyRFC822TextGMimeBufferPrivate GearyRFC822TextGMimeBufferPrivate;
enum  {
	GEARY_RF_C822_TEXT_GMIME_BUFFER_0_PROPERTY,
	GEARY_RF_C822_TEXT_GMIME_BUFFER_ALLOCATED_SIZE_PROPERTY,
	GEARY_RF_C822_TEXT_GMIME_BUFFER_SIZE_PROPERTY,
	GEARY_RF_C822_TEXT_GMIME_BUFFER_NUM_PROPERTIES
};
static GParamSpec* geary_rf_c822_text_gmime_buffer_properties[GEARY_RF_C822_TEXT_GMIME_BUFFER_NUM_PROPERTIES];
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))
enum  {
	GEARY_RF_C822_FULL_0_PROPERTY,
	GEARY_RF_C822_FULL_NUM_PROPERTIES
};
static GParamSpec* geary_rf_c822_full_properties[GEARY_RF_C822_FULL_NUM_PROPERTIES];
enum  {
	GEARY_RF_C822_PREVIEW_TEXT_0_PROPERTY,
	GEARY_RF_C822_PREVIEW_TEXT_NUM_PROPERTIES
};
static GParamSpec* geary_rf_c822_preview_text_properties[GEARY_RF_C822_PREVIEW_TEXT_NUM_PROPERTIES];
#define __vala_GMimeParserOptions_free0(var) ((var == NULL) ? NULL : (var = (_vala_GMimeParserOptions_free (var), NULL)))
enum  {
	GEARY_RF_C822_AUTHENTICATION_RESULTS_0_PROPERTY,
	GEARY_RF_C822_AUTHENTICATION_RESULTS_NUM_PROPERTIES
};
static GParamSpec* geary_rf_c822_authentication_results_properties[GEARY_RF_C822_AUTHENTICATION_RESULTS_NUM_PROPERTIES];

struct _GearyRFC822MessageIDListPrivate {
	GeeList* list;
};

struct _GearyRFC822DatePrivate {
	GDateTime* _value;
	gchar* rfc822;
};

struct _GearyRFC822SubjectPrivate {
	gchar* rfc822;
};

struct _GearyRFC822HeaderPrivate {
	GMimeHeaderList* headers;
	gchar** names;
	gint names_length1;
	gint _names_size_;
};

struct _GearyRFC822TextGMimeBuffer {
	GearyMemoryBuffer parent_instance;
	GearyRFC822TextGMimeBufferPrivate * priv;
};

struct _GearyRFC822TextGMimeBufferClass {
	GearyMemoryBufferClass parent_class;
};

struct _GearyRFC822TextGMimeBufferPrivate {
	GMimeStream* stream;
	GBytes* buf;
};

static gpointer geary_rf_c822_message_id_parent_class = NULL;
static GearyRFC822DecodedMessageDataIface * geary_rf_c822_message_id_geary_rf_c822_decoded_message_data_parent_iface = NULL;
static gint GearyRFC822MessageIDList_private_offset;
static gpointer geary_rf_c822_message_id_list_parent_class = NULL;
static GearyRFC822DecodedMessageDataIface * geary_rf_c822_message_id_list_geary_rf_c822_decoded_message_data_parent_iface = NULL;
static gint GearyRFC822Date_private_offset;
static gpointer geary_rf_c822_date_parent_class = NULL;
static GeeHashableIface * geary_rf_c822_date_gee_hashable_parent_iface = NULL;
static GearyRFC822DecodedMessageDataIface * geary_rf_c822_date_geary_rf_c822_decoded_message_data_parent_iface = NULL;
static gint GearyRFC822Subject_private_offset;
static gpointer geary_rf_c822_subject_parent_class = NULL;
static GearyMessageDataSearchableMessageDataIface * geary_rf_c822_subject_geary_message_data_searchable_message_data_parent_iface = NULL;
static GearyRFC822DecodedMessageDataIface * geary_rf_c822_subject_geary_rf_c822_decoded_message_data_parent_iface = NULL;
static gint GearyRFC822Header_private_offset;
static gpointer geary_rf_c822_header_parent_class = NULL;
static GearyRFC822EncodedMessageDataIface * geary_rf_c822_header_geary_rf_c822_encoded_message_data_parent_iface = NULL;
static gpointer geary_rf_c822_text_parent_class = NULL;
static gint GearyRFC822TextGMimeBuffer_private_offset;
static gpointer geary_rf_c822_text_gmime_buffer_parent_class = NULL;
static GearyMemoryUnownedBytesBufferIface * geary_rf_c822_text_gmime_buffer_geary_memory_unowned_bytes_buffer_parent_iface = NULL;
static GearyRFC822EncodedMessageDataIface * geary_rf_c822_text_geary_rf_c822_encoded_message_data_parent_iface = NULL;
static gpointer geary_rf_c822_full_parent_class = NULL;
static GearyRFC822EncodedMessageDataIface * geary_rf_c822_full_geary_rf_c822_encoded_message_data_parent_iface = NULL;
static gpointer geary_rf_c822_preview_text_parent_class = NULL;
static gpointer geary_rf_c822_authentication_results_parent_class = NULL;

static GType geary_rf_c822_decoded_message_data_get_type_once (void);
static GType geary_rf_c822_encoded_message_data_get_type_once (void);
static gchar* geary_rf_c822_message_id_real_to_rfc822_string (GearyRFC822DecodedMessageData* base);
static GType geary_rf_c822_message_id_get_type_once (void);
static gchar* geary_rf_c822_message_id_list_real_to_string (GearyMessageDataAbstractMessageData* base);
static gchar* geary_rf_c822_message_id_list_real_to_rfc822_string (GearyRFC822DecodedMessageData* base);
static void geary_rf_c822_message_id_list_finalize (GObject * obj);
static GType geary_rf_c822_message_id_list_get_type_once (void);
static void _vala_geary_rf_c822_message_id_list_get_property (GObject * object,
                                                       guint property_id,
                                                       GValue * value,
                                                       GParamSpec * pspec);
static void geary_rf_c822_date_set_value (GearyRFC822Date* self,
                                   GDateTime* value);
static gchar* geary_rf_c822_date_real_to_rfc822_string (GearyRFC822DecodedMessageData* base);
static gboolean geary_rf_c822_date_real_equal_to (GearyRFC822Date* self,
                                           GearyRFC822Date* other);
static guint geary_rf_c822_date_real_hash (GearyRFC822Date* self);
static gchar* geary_rf_c822_date_real_to_string (GearyMessageDataAbstractMessageData* base);
static void geary_rf_c822_date_finalize (GObject * obj);
static GType geary_rf_c822_date_get_type_once (void);
static void _vala_geary_rf_c822_date_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);
static void _vala_geary_rf_c822_date_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec);
VALA_EXTERN gchar* geary_rf_c822_utils_decode_rfc822_text_header_value (const gchar* rfc822);
static gchar* geary_rf_c822_subject_real_to_rfc822_string (GearyRFC822DecodedMessageData* base);
static void _vala_GMimeFormatOptions_free (GMimeFormatOptions* self);
static gchar* geary_rf_c822_subject_real_to_searchable_string (GearyMessageDataSearchableMessageData* base);
static void geary_rf_c822_subject_finalize (GObject * obj);
static GType geary_rf_c822_subject_get_type_once (void);
VALA_EXTERN GMimeStreamMem* geary_rf_c822_utils_create_stream_mem (GearyMemoryBuffer* buffer);
static gchar** _vala_array_dup13 (gchar** self,
                           gssize length);
static gchar** _vala_array_dup14 (gchar** self,
                           gssize length);
static void geary_rf_c822_header_finalize (GObject * obj);
static GType geary_rf_c822_header_get_type_once (void);
static GearyRFC822TextGMimeBuffer* geary_rf_c822_text_gmime_buffer_new (GMimeStream* stream);
static GearyRFC822TextGMimeBuffer* geary_rf_c822_text_gmime_buffer_construct (GType object_type,
                                                                       GMimeStream* stream);
static GType geary_rf_c822_text_gmime_buffer_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static GBytes* geary_rf_c822_text_gmime_buffer_real_get_bytes (GearyMemoryBuffer* base);
static guint8* _vala_array_dup15 (guint8* self,
                           gssize length);
static guint8* geary_rf_c822_text_gmime_buffer_real_to_unowned_uint8_array (GearyMemoryUnownedBytesBuffer* base,
                                                                     gint* result_length1);
static void geary_rf_c822_text_gmime_buffer_finalize (GObject * obj);
static GType geary_rf_c822_text_gmime_buffer_get_type_once (void);
static void _vala_geary_rf_c822_text_gmime_buffer_get_property (GObject * object,
                                                         guint property_id,
                                                         GValue * value,
                                                         GParamSpec * pspec);
static GType geary_rf_c822_text_get_type_once (void);
static GType geary_rf_c822_full_get_type_once (void);
static void _vala_GMimeParserOptions_free (GMimeParserOptions* self);
VALA_EXTERN GearyRFC822Part* geary_rf_c822_part_new (GMimeObject* source);
VALA_EXTERN GearyRFC822Part* geary_rf_c822_part_construct (GType object_type,
                                               GMimeObject* source);
static GType geary_rf_c822_preview_text_get_type_once (void);
static GType geary_rf_c822_authentication_results_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static GRegex* _tmp_regex_0 = NULL;
static GRegex* _tmp_regex_1 = NULL;

/** Returns an RFC822-safe string representation of the data. */
gchar*
geary_rf_c822_decoded_message_data_to_rfc822_string (GearyRFC822DecodedMessageData* self)
{
	GearyRFC822DecodedMessageDataIface* _iface_;
	g_return_val_if_fail (GEARY_RF_C822_IS_DECODED_MESSAGE_DATA (self), NULL);
	_iface_ = GEARY_RF_C822_DECODED_MESSAGE_DATA_GET_INTERFACE (self);
	if (_iface_->to_rfc822_string) {
		return _iface_->to_rfc822_string (self);
	}
	return NULL;
}

static void
geary_rf_c822_decoded_message_data_default_init (GearyRFC822DecodedMessageDataIface * iface,
                                                 gpointer iface_data)
{
}

/**
 * A base interface for objects that represent decoded RFC822 headers.
 *
 * The value of these objects is the decoded form of the header
 * data. Encoded forms can be obtained via {@link to_rfc822_string}.
 */
 G_GNUC_NO_INLINE static GType
geary_rf_c822_decoded_message_data_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyRFC822DecodedMessageDataIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_rf_c822_decoded_message_data_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType geary_rf_c822_decoded_message_data_type_id;
	geary_rf_c822_decoded_message_data_type_id = g_type_register_static (G_TYPE_INTERFACE, "GearyRFC822DecodedMessageData", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (geary_rf_c822_decoded_message_data_type_id, GEARY_MESSAGE_DATA_TYPE_ABSTRACT_MESSAGE_DATA);
	return geary_rf_c822_decoded_message_data_type_id;
}

GType
geary_rf_c822_decoded_message_data_get_type (void)
{
	static gsize geary_rf_c822_decoded_message_data_type_id__once = 0;
	if (g_once_init_enter (&geary_rf_c822_decoded_message_data_type_id__once)) {
		GType geary_rf_c822_decoded_message_data_type_id;
		geary_rf_c822_decoded_message_data_type_id = geary_rf_c822_decoded_message_data_get_type_once ();
		g_once_init_leave (&geary_rf_c822_decoded_message_data_type_id__once, geary_rf_c822_decoded_message_data_type_id);
	}
	return geary_rf_c822_decoded_message_data_type_id__once;
}

static void
geary_rf_c822_encoded_message_data_default_init (GearyRFC822EncodedMessageDataIface * iface,
                                                 gpointer iface_data)
{
}

/**
 * A base interface for objects that represent encoded RFC822 header data.
 *
 * The value of these objects is the RFC822 encoded form of the header
 * data. Decoded forms can be obtained via means specific to
 * implementations of this interface.
 */
 G_GNUC_NO_INLINE static GType
geary_rf_c822_encoded_message_data_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyRFC822EncodedMessageDataIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_rf_c822_encoded_message_data_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType geary_rf_c822_encoded_message_data_type_id;
	geary_rf_c822_encoded_message_data_type_id = g_type_register_static (G_TYPE_INTERFACE, "GearyRFC822EncodedMessageData", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (geary_rf_c822_encoded_message_data_type_id, GEARY_MESSAGE_DATA_TYPE_BLOCK_MESSAGE_DATA);
	return geary_rf_c822_encoded_message_data_type_id;
}

GType
geary_rf_c822_encoded_message_data_get_type (void)
{
	static gsize geary_rf_c822_encoded_message_data_type_id__once = 0;
	if (g_once_init_enter (&geary_rf_c822_encoded_message_data_type_id__once)) {
		GType geary_rf_c822_encoded_message_data_type_id;
		geary_rf_c822_encoded_message_data_type_id = geary_rf_c822_encoded_message_data_get_type_once ();
		g_once_init_leave (&geary_rf_c822_encoded_message_data_type_id__once, geary_rf_c822_encoded_message_data_type_id);
	}
	return geary_rf_c822_encoded_message_data_type_id__once;
}

GearyRFC822MessageID*
geary_rf_c822_message_id_construct (GType object_type,
                                    const gchar* value)
{
	GearyRFC822MessageID * self = NULL;
	g_return_val_if_fail (value != NULL, NULL);
	self = (GearyRFC822MessageID*) geary_message_data_string_message_data_construct (object_type, value);
	return self;
}

GearyRFC822MessageID*
geary_rf_c822_message_id_new (const gchar* value)
{
	return geary_rf_c822_message_id_construct (GEARY_RF_C822_TYPE_MESSAGE_ID, value);
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

GearyRFC822MessageID*
geary_rf_c822_message_id_construct_from_rfc822_string (GType object_type,
                                                       const gchar* rfc822,
                                                       GError** error)
{
	GearyRFC822MessageID * self = NULL;
	gint len = 0;
	gint _tmp0_;
	gint _tmp1_;
	gint start = 0;
	gchar end_delim = '\0';
	gboolean break_on_space = FALSE;
	gint end = 0;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (rfc822 != NULL, NULL);
	_tmp0_ = strlen (rfc822);
	_tmp1_ = _tmp0_;
	len = _tmp1_;
	start = 0;
	while (TRUE) {
		gboolean _tmp2_ = FALSE;
		if (start < len) {
			_tmp2_ = g_ascii_isspace (string_get (rfc822, (glong) start));
		} else {
			_tmp2_ = FALSE;
		}
		if (!_tmp2_) {
			break;
		}
		start += 1;
	}
	end_delim = (gchar) 0;
	break_on_space = FALSE;
	if (start < len) {
		switch (string_get (rfc822, (glong) start)) {
			case '<':
			{
				start += 1;
				end_delim = '>';
				break;
			}
			case '(':
			{
				start += 1;
				end_delim = ')';
				break;
			}
			default:
			{
				break_on_space = TRUE;
				break;
			}
		}
	}
	end = start + 1;
	while (TRUE) {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		if (end < len) {
			_tmp4_ = string_get (rfc822, (glong) end) != end_delim;
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			gboolean _tmp5_ = FALSE;
			if (!break_on_space) {
				_tmp5_ = TRUE;
			} else {
				_tmp5_ = !g_ascii_isspace (string_get (rfc822, (glong) end));
			}
			_tmp3_ = _tmp5_;
		} else {
			_tmp3_ = FALSE;
		}
		if (!_tmp3_) {
			break;
		}
		end += 1;
	}
	if ((start + 1) >= end) {
		GError* _tmp6_;
		_tmp6_ = g_error_new_literal (GEARY_RF_C822_ERROR, GEARY_RF_C822_ERROR_INVALID, "Empty RFC822 message id");
		_inner_error0_ = _tmp6_;
		if (_inner_error0_->domain == GEARY_RF_C822_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp7_ = string_slice (rfc822, (glong) start, (glong) end);
	_tmp8_ = _tmp7_;
	self = (GearyRFC822MessageID*) geary_message_data_string_message_data_construct (object_type, _tmp8_);
	_g_free0 (_tmp8_);
	return self;
}

GearyRFC822MessageID*
geary_rf_c822_message_id_new_from_rfc822_string (const gchar* rfc822,
                                                 GError** error)
{
	return geary_rf_c822_message_id_construct_from_rfc822_string (GEARY_RF_C822_TYPE_MESSAGE_ID, rfc822, error);
}

/**
     * Returns the {@link Date} in RFC 822 format.
     */
static gchar*
geary_rf_c822_message_id_real_to_rfc822_string (GearyRFC822DecodedMessageData* base)
{
	GearyRFC822MessageID * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_RF_C822_TYPE_MESSAGE_ID, GearyRFC822MessageID);
	_tmp0_ = geary_message_data_string_message_data_get_value (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_MESSAGE_DATA_TYPE_STRING_MESSAGE_DATA, GearyMessageDataStringMessageData));
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("<%s>", _tmp1_);
	result = _tmp2_;
	return result;
}

static void
geary_rf_c822_message_id_class_init (GearyRFC822MessageIDClass * klass,
                                     gpointer klass_data)
{
	geary_rf_c822_message_id_parent_class = g_type_class_peek_parent (klass);
}

static void
geary_rf_c822_message_id_geary_rf_c822_decoded_message_data_interface_init (GearyRFC822DecodedMessageDataIface * iface,
                                                                            gpointer iface_data)
{
	geary_rf_c822_message_id_geary_rf_c822_decoded_message_data_parent_iface = g_type_interface_peek_parent (iface);
	iface->to_rfc822_string = (gchar* (*) (GearyRFC822DecodedMessageData*)) geary_rf_c822_message_id_real_to_rfc822_string;
}

static void
geary_rf_c822_message_id_instance_init (GearyRFC822MessageID * self,
                                        gpointer klass)
{
}

/**
 * A RFC822 Message-ID.
 *
 * The decoded form of the id is the `addr-spec` portion, that is,
 * without the leading `<` and tailing `>`.
 */
 G_GNUC_NO_INLINE static GType
geary_rf_c822_message_id_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyRFC822MessageIDClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_rf_c822_message_id_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyRFC822MessageID), 0, (GInstanceInitFunc) geary_rf_c822_message_id_instance_init, NULL };
	static const GInterfaceInfo geary_rf_c822_decoded_message_data_info = { (GInterfaceInitFunc) geary_rf_c822_message_id_geary_rf_c822_decoded_message_data_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType geary_rf_c822_message_id_type_id;
	geary_rf_c822_message_id_type_id = g_type_register_static (GEARY_MESSAGE_DATA_TYPE_STRING_MESSAGE_DATA, "GearyRFC822MessageID", &g_define_type_info, 0);
	g_type_add_interface_static (geary_rf_c822_message_id_type_id, GEARY_RF_C822_TYPE_DECODED_MESSAGE_DATA, &geary_rf_c822_decoded_message_data_info);
	return geary_rf_c822_message_id_type_id;
}

GType
geary_rf_c822_message_id_get_type (void)
{
	static gsize geary_rf_c822_message_id_type_id__once = 0;
	if (g_once_init_enter (&geary_rf_c822_message_id_type_id__once)) {
		GType geary_rf_c822_message_id_type_id;
		geary_rf_c822_message_id_type_id = geary_rf_c822_message_id_get_type_once ();
		g_once_init_leave (&geary_rf_c822_message_id_type_id__once, geary_rf_c822_message_id_type_id);
	}
	return geary_rf_c822_message_id_type_id__once;
}

static inline gpointer
geary_rf_c822_message_id_list_get_instance_private (GearyRFC822MessageIDList* self)
{
	return G_STRUCT_MEMBER_P (self, GearyRFC822MessageIDList_private_offset);
}

gint
geary_rf_c822_message_id_list_get_size (GearyRFC822MessageIDList* self)
{
	gint result;
	GeeList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (GEARY_RF_C822_IS_MESSAGE_ID_LIST (self), 0);
	_tmp0_ = self->priv->list;
	_tmp1_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

gboolean
geary_rf_c822_message_id_list_get_is_empty (GearyRFC822MessageIDList* self)
{
	gboolean result;
	GeeList* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (GEARY_RF_C822_IS_MESSAGE_ID_LIST (self), FALSE);
	_tmp0_ = self->priv->list;
	_tmp1_ = gee_collection_get_is_empty (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

/**
     * Constructs a new Message-Id list.
     *
     * If the optional collection of ids is not given, the list
     * is created empty. Otherwise the collection's ids are
     * added to the list by iterating over it in natural order.
     */
GearyRFC822MessageIDList*
geary_rf_c822_message_id_list_construct (GType object_type,
                                         GeeCollection* collection)
{
	GearyRFC822MessageIDList * self = NULL;
	g_return_val_if_fail ((collection == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (collection, GEE_TYPE_COLLECTION), NULL);
	self = (GearyRFC822MessageIDList*) geary_message_data_abstract_message_data_construct (object_type);
	if (collection != NULL) {
		GeeList* _tmp0_;
		_tmp0_ = self->priv->list;
		gee_collection_add_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection), collection);
	}
	return self;
}

GearyRFC822MessageIDList*
geary_rf_c822_message_id_list_new (GeeCollection* collection)
{
	return geary_rf_c822_message_id_list_construct (GEARY_RF_C822_TYPE_MESSAGE_ID_LIST, collection);
}

/** Constructs a new Message-Id list containing a single id. */
GearyRFC822MessageIDList*
geary_rf_c822_message_id_list_construct_single (GType object_type,
                                                GearyRFC822MessageID* msg_id)
{
	GearyRFC822MessageIDList * self = NULL;
	GeeList* _tmp0_;
	g_return_val_if_fail (GEARY_RF_C822_IS_MESSAGE_ID (msg_id), NULL);
	self = (GearyRFC822MessageIDList*) geary_rf_c822_message_id_list_construct (object_type, NULL);
	_tmp0_ = self->priv->list;
	gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection), msg_id);
	return self;
}

GearyRFC822MessageIDList*
geary_rf_c822_message_id_list_new_single (GearyRFC822MessageID* msg_id)
{
	return geary_rf_c822_message_id_list_construct_single (GEARY_RF_C822_TYPE_MESSAGE_ID_LIST, msg_id);
}

/** Constructs a new Message-Id list by parsing a RFC822 string. */
GearyRFC822MessageIDList*
geary_rf_c822_message_id_list_construct_from_rfc822_string (GType object_type,
                                                            const gchar* rfc822,
                                                            GError** error)
{
	GearyRFC822MessageIDList * self = NULL;
	GString* canonicalized = NULL;
	GString* _tmp0_;
	gint index = 0;
	gchar ch = '\0';
	gboolean in_message_id = FALSE;
	gboolean bracketed = FALSE;
	GString* _tmp15_;
	const gchar* _tmp16_;
	GeeList* _tmp22_;
	gboolean _tmp23_;
	gboolean _tmp24_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (rfc822 != NULL, NULL);
	self = (GearyRFC822MessageIDList*) geary_rf_c822_message_id_list_construct (object_type, NULL);
	_tmp0_ = g_string_new ("");
	canonicalized = _tmp0_;
	index = 0;
	in_message_id = FALSE;
	bracketed = FALSE;
	while (TRUE) {
		gchar _tmp1_ = '\0';
		gboolean _tmp2_;
		gboolean add_char = FALSE;
		gboolean _tmp6_ = FALSE;
		_tmp2_ = geary_ascii_get_next_char (rfc822, &index, &_tmp1_);
		ch = _tmp1_;
		if (!_tmp2_) {
			break;
		}
		add_char = FALSE;
		switch (ch) {
			case '<':
			{
				in_message_id = TRUE;
				bracketed = TRUE;
				break;
			}
			case '(':
			{
				if (!in_message_id) {
					in_message_id = TRUE;
					bracketed = TRUE;
				} else {
					add_char = TRUE;
				}
				break;
			}
			case '>':
			{
				in_message_id = FALSE;
				break;
			}
			case ')':
			{
				if (in_message_id) {
					in_message_id = FALSE;
				} else {
					add_char = TRUE;
				}
				break;
			}
			default:
			{
				if (!bracketed) {
					gboolean _tmp3_ = FALSE;
					if (!in_message_id) {
						_tmp3_ = !g_ascii_isspace (ch);
					} else {
						_tmp3_ = FALSE;
					}
					if (_tmp3_) {
						in_message_id = TRUE;
					} else {
						gboolean _tmp4_ = FALSE;
						if (in_message_id) {
							_tmp4_ = g_ascii_isspace (ch);
						} else {
							_tmp4_ = FALSE;
						}
						if (_tmp4_) {
							in_message_id = FALSE;
						}
					}
				}
				add_char = in_message_id;
				break;
			}
		}
		if (add_char) {
			GString* _tmp5_;
			_tmp5_ = canonicalized;
			g_string_append_c (_tmp5_, ch);
		}
		if (!in_message_id) {
			GString* _tmp7_;
			const gchar* _tmp8_;
			_tmp7_ = canonicalized;
			_tmp8_ = _tmp7_->str;
			_tmp6_ = !geary_string_is_empty (_tmp8_);
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			GeeList* _tmp9_;
			GString* _tmp10_;
			const gchar* _tmp11_;
			GearyRFC822MessageID* _tmp12_;
			GearyRFC822MessageID* _tmp13_;
			GString* _tmp14_;
			_tmp9_ = self->priv->list;
			_tmp10_ = canonicalized;
			_tmp11_ = _tmp10_->str;
			_tmp12_ = geary_rf_c822_message_id_new (_tmp11_);
			_tmp13_ = _tmp12_;
			gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_COLLECTION, GeeCollection), _tmp13_);
			_g_object_unref0 (_tmp13_);
			_tmp14_ = g_string_new ("");
			_g_string_free0 (canonicalized);
			canonicalized = _tmp14_;
		}
	}
	_tmp15_ = canonicalized;
	_tmp16_ = _tmp15_->str;
	if (!geary_string_is_empty (_tmp16_)) {
		GeeList* _tmp17_;
		GString* _tmp18_;
		const gchar* _tmp19_;
		GearyRFC822MessageID* _tmp20_;
		GearyRFC822MessageID* _tmp21_;
		_tmp17_ = self->priv->list;
		_tmp18_ = canonicalized;
		_tmp19_ = _tmp18_->str;
		_tmp20_ = geary_rf_c822_message_id_new (_tmp19_);
		_tmp21_ = _tmp20_;
		gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, GEE_TYPE_COLLECTION, GeeCollection), _tmp21_);
		_g_object_unref0 (_tmp21_);
	}
	_tmp22_ = self->priv->list;
	_tmp23_ = gee_collection_get_is_empty (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp24_ = _tmp23_;
	if (_tmp24_) {
		GError* _tmp25_;
		_tmp25_ = g_error_new (GEARY_RF_C822_ERROR, GEARY_RF_C822_ERROR_INVALID, "Empty RFC822 message id list: %s", rfc822);
		_inner_error0_ = _tmp25_;
		if (_inner_error0_->domain == GEARY_RF_C822_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_string_free0 (canonicalized);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_string_free0 (canonicalized);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_g_string_free0 (canonicalized);
	return self;
}

GearyRFC822MessageIDList*
geary_rf_c822_message_id_list_new_from_rfc822_string (const gchar* rfc822,
                                                      GError** error)
{
	return geary_rf_c822_message_id_list_construct_from_rfc822_string (GEARY_RF_C822_TYPE_MESSAGE_ID_LIST, rfc822, error);
}

/** Returns the id at the given index, if it exists. */
GearyRFC822MessageID*
geary_rf_c822_message_id_list_get (GearyRFC822MessageIDList* self,
                                   gint index)
{
	GeeList* _tmp0_;
	gpointer _tmp1_;
	GearyRFC822MessageID* result;
	g_return_val_if_fail (GEARY_RF_C822_IS_MESSAGE_ID_LIST (self), NULL);
	_tmp0_ = self->priv->list;
	_tmp1_ = gee_list_get (_tmp0_, index);
	result = (GearyRFC822MessageID*) _tmp1_;
	return result;
}

/** Returns a read-only iterator of the ids in this list. */
GeeIterator*
geary_rf_c822_message_id_list_iterator (GearyRFC822MessageIDList* self)
{
	GeeList* _tmp0_;
	GeeList* _tmp1_;
	GeeList* _tmp2_;
	GeeList* _tmp3_;
	GeeIterator* _tmp4_;
	GeeIterator* _tmp5_;
	GeeIterator* result;
	g_return_val_if_fail (GEARY_RF_C822_IS_MESSAGE_ID_LIST (self), NULL);
	_tmp0_ = self->priv->list;
	_tmp1_ = gee_list_get_read_only_view (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ITERABLE, GeeIterable));
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp3_);
	result = _tmp5_;
	return result;
}

/** Returns a read-only collection of the ids in this list. */
GeeList*
geary_rf_c822_message_id_list_get_all (GearyRFC822MessageIDList* self)
{
	GeeList* _tmp0_;
	GeeList* _tmp1_;
	GeeList* _tmp2_;
	GeeList* result;
	g_return_val_if_fail (GEARY_RF_C822_IS_MESSAGE_ID_LIST (self), NULL);
	_tmp0_ = self->priv->list;
	_tmp1_ = gee_list_get_read_only_view (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

/**
     * Returns a list with the given id appended if not already present.
     *
     * This list is returned if the given id is already present,
     * otherwise the result of a call to {@link concatenate_id} is
     * returned.
     */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GearyRFC822MessageIDList*
geary_rf_c822_message_id_list_merge_id (GearyRFC822MessageIDList* self,
                                        GearyRFC822MessageID* other)
{
	GearyRFC822MessageIDList* _tmp0_ = NULL;
	GeeList* _tmp1_;
	GearyRFC822MessageIDList* result;
	g_return_val_if_fail (GEARY_RF_C822_IS_MESSAGE_ID_LIST (self), NULL);
	g_return_val_if_fail (GEARY_RF_C822_IS_MESSAGE_ID (other), NULL);
	_tmp1_ = self->priv->list;
	if (gee_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_COLLECTION, GeeCollection), other)) {
		GearyRFC822MessageIDList* _tmp2_;
		_tmp2_ = _g_object_ref0 (self);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp2_;
	} else {
		GearyRFC822MessageIDList* _tmp3_;
		_tmp3_ = geary_rf_c822_message_id_list_concatenate_id (self, other);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp3_;
	}
	result = _tmp0_;
	return result;
}

/**
     * Returns a list with the given ids appended if not already present.
     *
     * This list is returned if all given ids are already present,
     * otherwise the result of a call to {@link concatenate_id} for
     * each not present is returned.
     */
GearyRFC822MessageIDList*
geary_rf_c822_message_id_list_merge_list (GearyRFC822MessageIDList* self,
                                          GearyRFC822MessageIDList* other)
{
	GearyRFC822MessageIDList* list = NULL;
	GearyRFC822MessageIDList* _tmp0_;
	GearyRFC822MessageIDList* result;
	g_return_val_if_fail (GEARY_RF_C822_IS_MESSAGE_ID_LIST (self), NULL);
	g_return_val_if_fail (GEARY_RF_C822_IS_MESSAGE_ID_LIST (other), NULL);
	_tmp0_ = _g_object_ref0 (self);
	list = _tmp0_;
	{
		GearyRFC822MessageIDList* _id_list = NULL;
		gint _id_size = 0;
		GearyRFC822MessageIDList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _id_index = 0;
		_id_list = other;
		_tmp1_ = _id_list;
		_tmp2_ = geary_rf_c822_message_id_list_get_size (_tmp1_);
		_tmp3_ = _tmp2_;
		_id_size = _tmp3_;
		_id_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			GearyRFC822MessageID* id = NULL;
			GearyRFC822MessageIDList* _tmp6_;
			GearyRFC822MessageID* _tmp7_;
			GeeList* _tmp8_;
			GearyRFC822MessageID* _tmp9_;
			_id_index = _id_index + 1;
			_tmp4_ = _id_index;
			_tmp5_ = _id_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _id_list;
			_tmp7_ = geary_rf_c822_message_id_list_get (_tmp6_, _id_index);
			id = _tmp7_;
			_tmp8_ = self->priv->list;
			_tmp9_ = id;
			if (!gee_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_COLLECTION, GeeCollection), _tmp9_)) {
				GearyRFC822MessageIDList* _tmp10_;
				GearyRFC822MessageID* _tmp11_;
				GearyRFC822MessageIDList* _tmp12_;
				_tmp10_ = list;
				_tmp11_ = id;
				_tmp12_ = geary_rf_c822_message_id_list_concatenate_id (_tmp10_, _tmp11_);
				_g_object_unref0 (list);
				list = _tmp12_;
			}
			_g_object_unref0 (id);
		}
	}
	result = list;
	return result;
}

/**
     * Returns a new list with the given list appended to this.
     */
GearyRFC822MessageIDList*
geary_rf_c822_message_id_list_concatenate_id (GearyRFC822MessageIDList* self,
                                              GearyRFC822MessageID* other)
{
	GearyRFC822MessageIDList* new_ids = NULL;
	GeeList* _tmp0_;
	GearyRFC822MessageIDList* _tmp1_;
	GeeList* _tmp2_;
	GearyRFC822MessageIDList* result;
	g_return_val_if_fail (GEARY_RF_C822_IS_MESSAGE_ID_LIST (self), NULL);
	g_return_val_if_fail (GEARY_RF_C822_IS_MESSAGE_ID (other), NULL);
	_tmp0_ = self->priv->list;
	_tmp1_ = geary_rf_c822_message_id_list_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection));
	new_ids = _tmp1_;
	_tmp2_ = new_ids->priv->list;
	gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_COLLECTION, GeeCollection), other);
	result = new_ids;
	return result;
}

/**
     * Returns a new list with the given list appended to this.
     */
GearyRFC822MessageIDList*
geary_rf_c822_message_id_list_concatenate_list (GearyRFC822MessageIDList* self,
                                                GearyRFC822MessageIDList* others)
{
	GearyRFC822MessageIDList* new_ids = NULL;
	GeeList* _tmp0_;
	GearyRFC822MessageIDList* _tmp1_;
	GeeList* _tmp2_;
	GeeList* _tmp3_;
	GearyRFC822MessageIDList* result;
	g_return_val_if_fail (GEARY_RF_C822_IS_MESSAGE_ID_LIST (self), NULL);
	g_return_val_if_fail (GEARY_RF_C822_IS_MESSAGE_ID_LIST (others), NULL);
	_tmp0_ = self->priv->list;
	_tmp1_ = geary_rf_c822_message_id_list_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection));
	new_ids = _tmp1_;
	_tmp2_ = new_ids->priv->list;
	_tmp3_ = others->priv->list;
	gee_collection_add_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_COLLECTION, GeeCollection));
	result = new_ids;
	return result;
}

static gchar*
geary_rf_c822_message_id_list_real_to_string (GearyMessageDataAbstractMessageData* base)
{
	GearyRFC822MessageIDList * self;
	GeeList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_RF_C822_TYPE_MESSAGE_ID_LIST, GearyRFC822MessageIDList);
	_tmp0_ = self->priv->list;
	_tmp1_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup_printf ("MessageIDList (%d)", _tmp2_);
	result = _tmp3_;
	return result;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

static gchar*
geary_rf_c822_message_id_list_real_to_rfc822_string (GearyRFC822DecodedMessageData* base)
{
	GearyRFC822MessageIDList * self;
	gchar** strings = NULL;
	GeeList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gchar** _tmp3_;
	gint strings_length1;
	gint _strings_size_;
	gchar** _tmp14_;
	gint _tmp14__length1;
	gchar* _tmp15_;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_RF_C822_TYPE_MESSAGE_ID_LIST, GearyRFC822MessageIDList);
	_tmp0_ = self->priv->list;
	_tmp1_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp2_ = _tmp1_;
	_tmp3_ = g_new0 (gchar*, _tmp2_ + 1);
	strings = _tmp3_;
	strings_length1 = _tmp2_;
	_strings_size_ = strings_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				GeeList* _tmp6_;
				gint _tmp7_;
				gint _tmp8_;
				gchar** _tmp9_;
				gint _tmp9__length1;
				GeeList* _tmp10_;
				gpointer _tmp11_;
				GearyRFC822MessageID* _tmp12_;
				gchar* _tmp13_;
				if (!_tmp4_) {
					gint _tmp5_;
					i = i + 1;
					_tmp5_ = i;
				}
				_tmp4_ = FALSE;
				_tmp6_ = self->priv->list;
				_tmp7_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_COLLECTION, GeeCollection));
				_tmp8_ = _tmp7_;
				if (!(i < _tmp8_)) {
					break;
				}
				_tmp9_ = strings;
				_tmp9__length1 = strings_length1;
				_tmp10_ = self->priv->list;
				_tmp11_ = gee_list_get (_tmp10_, i);
				_tmp12_ = (GearyRFC822MessageID*) _tmp11_;
				_tmp13_ = geary_rf_c822_decoded_message_data_to_rfc822_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GEARY_RF_C822_TYPE_DECODED_MESSAGE_DATA, GearyRFC822DecodedMessageData));
				_g_free0 (_tmp9_[i]);
				_tmp9_[i] = _tmp13_;
				_g_object_unref0 (_tmp12_);
			}
		}
	}
	_tmp14_ = strings;
	_tmp14__length1 = strings_length1;
	_tmp15_ = _vala_g_strjoinv (" ", _tmp14_, (gint) _tmp14__length1);
	result = _tmp15_;
	strings = (_vala_array_free (strings, strings_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static void
geary_rf_c822_message_id_list_class_init (GearyRFC822MessageIDListClass * klass,
                                          gpointer klass_data)
{
	geary_rf_c822_message_id_list_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyRFC822MessageIDList_private_offset);
	((GearyMessageDataAbstractMessageDataClass *) klass)->to_string = (gchar* (*) (GearyMessageDataAbstractMessageData*)) geary_rf_c822_message_id_list_real_to_string;
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_rf_c822_message_id_list_get_property;
	G_OBJECT_CLASS (klass)->finalize = geary_rf_c822_message_id_list_finalize;
	/** Returns the number of ids in this list. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_RF_C822_MESSAGE_ID_LIST_SIZE_PROPERTY, geary_rf_c822_message_id_list_properties[GEARY_RF_C822_MESSAGE_ID_LIST_SIZE_PROPERTY] = g_param_spec_int ("size", "size", "size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** Determines if there are no ids in the list. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_RF_C822_MESSAGE_ID_LIST_IS_EMPTY_PROPERTY, geary_rf_c822_message_id_list_properties[GEARY_RF_C822_MESSAGE_ID_LIST_IS_EMPTY_PROPERTY] = g_param_spec_boolean ("is-empty", "is-empty", "is-empty", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
geary_rf_c822_message_id_list_geary_rf_c822_decoded_message_data_interface_init (GearyRFC822DecodedMessageDataIface * iface,
                                                                                 gpointer iface_data)
{
	geary_rf_c822_message_id_list_geary_rf_c822_decoded_message_data_parent_iface = g_type_interface_peek_parent (iface);
	iface->to_rfc822_string = (gchar* (*) (GearyRFC822DecodedMessageData*)) geary_rf_c822_message_id_list_real_to_rfc822_string;
}

static void
geary_rf_c822_message_id_list_instance_init (GearyRFC822MessageIDList * self,
                                             gpointer klass)
{
	GeeArrayList* _tmp0_;
	self->priv = geary_rf_c822_message_id_list_get_instance_private (self);
	_tmp0_ = gee_array_list_new (GEARY_RF_C822_TYPE_MESSAGE_ID, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->priv->list = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_LIST, GeeList);
}

static void
geary_rf_c822_message_id_list_finalize (GObject * obj)
{
	GearyRFC822MessageIDList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_RF_C822_TYPE_MESSAGE_ID_LIST, GearyRFC822MessageIDList);
	_g_object_unref0 (self->priv->list);
	G_OBJECT_CLASS (geary_rf_c822_message_id_list_parent_class)->finalize (obj);
}

/**
 * A immutable list of RFC822 Message-ID values.
 */
 G_GNUC_NO_INLINE static GType
geary_rf_c822_message_id_list_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyRFC822MessageIDListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_rf_c822_message_id_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyRFC822MessageIDList), 0, (GInstanceInitFunc) geary_rf_c822_message_id_list_instance_init, NULL };
	static const GInterfaceInfo geary_rf_c822_decoded_message_data_info = { (GInterfaceInitFunc) geary_rf_c822_message_id_list_geary_rf_c822_decoded_message_data_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType geary_rf_c822_message_id_list_type_id;
	geary_rf_c822_message_id_list_type_id = g_type_register_static (GEARY_MESSAGE_DATA_TYPE_ABSTRACT_MESSAGE_DATA, "GearyRFC822MessageIDList", &g_define_type_info, 0);
	g_type_add_interface_static (geary_rf_c822_message_id_list_type_id, GEARY_RF_C822_TYPE_DECODED_MESSAGE_DATA, &geary_rf_c822_decoded_message_data_info);
	GearyRFC822MessageIDList_private_offset = g_type_add_instance_private (geary_rf_c822_message_id_list_type_id, sizeof (GearyRFC822MessageIDListPrivate));
	return geary_rf_c822_message_id_list_type_id;
}

GType
geary_rf_c822_message_id_list_get_type (void)
{
	static gsize geary_rf_c822_message_id_list_type_id__once = 0;
	if (g_once_init_enter (&geary_rf_c822_message_id_list_type_id__once)) {
		GType geary_rf_c822_message_id_list_type_id;
		geary_rf_c822_message_id_list_type_id = geary_rf_c822_message_id_list_get_type_once ();
		g_once_init_leave (&geary_rf_c822_message_id_list_type_id__once, geary_rf_c822_message_id_list_type_id);
	}
	return geary_rf_c822_message_id_list_type_id__once;
}

static void
_vala_geary_rf_c822_message_id_list_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec)
{
	GearyRFC822MessageIDList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_RF_C822_TYPE_MESSAGE_ID_LIST, GearyRFC822MessageIDList);
	switch (property_id) {
		case GEARY_RF_C822_MESSAGE_ID_LIST_SIZE_PROPERTY:
		g_value_set_int (value, geary_rf_c822_message_id_list_get_size (self));
		break;
		case GEARY_RF_C822_MESSAGE_ID_LIST_IS_EMPTY_PROPERTY:
		g_value_set_boolean (value, geary_rf_c822_message_id_list_get_is_empty (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
geary_rf_c822_date_get_instance_private (GearyRFC822Date* self)
{
	return G_STRUCT_MEMBER_P (self, GearyRFC822Date_private_offset);
}

GDateTime*
geary_rf_c822_date_get_value (GearyRFC822Date* self)
{
	GDateTime* result;
	GDateTime* _tmp0_;
	g_return_val_if_fail (GEARY_RF_C822_IS_DATE (self), NULL);
	_tmp0_ = self->priv->_value;
	result = _tmp0_;
	return result;
}

static gpointer
_g_date_time_ref0 (gpointer self)
{
	return self ? g_date_time_ref (self) : NULL;
}

static void
geary_rf_c822_date_set_value (GearyRFC822Date* self,
                              GDateTime* value)
{
	GDateTime* old_value;
	g_return_if_fail (GEARY_RF_C822_IS_DATE (self));
	old_value = geary_rf_c822_date_get_value (self);
	if (old_value != value) {
		GDateTime* _tmp0_;
		_tmp0_ = _g_date_time_ref0 (value);
		_g_date_time_unref0 (self->priv->_value);
		self->priv->_value = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_rf_c822_date_properties[GEARY_RF_C822_DATE_VALUE_PROPERTY]);
	}
}

GearyRFC822Date*
geary_rf_c822_date_construct (GType object_type,
                              GDateTime* datetime)
{
	GearyRFC822Date * self = NULL;
	g_return_val_if_fail (datetime != NULL, NULL);
	self = (GearyRFC822Date*) geary_message_data_abstract_message_data_construct (object_type);
	geary_rf_c822_date_set_value (self, datetime);
	_g_free0 (self->priv->rfc822);
	self->priv->rfc822 = NULL;
	return self;
}

GearyRFC822Date*
geary_rf_c822_date_new (GDateTime* datetime)
{
	return geary_rf_c822_date_construct (GEARY_RF_C822_TYPE_DATE, datetime);
}

GearyRFC822Date*
geary_rf_c822_date_construct_from_rfc822_string (GType object_type,
                                                 const gchar* rfc822,
                                                 GError** error)
{
	GearyRFC822Date * self = NULL;
	GDateTime* date = NULL;
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	gchar* _tmp3_;
	GDateTime* _tmp4_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (rfc822 != NULL, NULL);
	self = (GearyRFC822Date*) geary_message_data_abstract_message_data_construct (object_type);
	_tmp0_ = g_mime_utils_header_decode_date (rfc822);
	date = _tmp0_;
	_tmp1_ = date;
	if (_tmp1_ == NULL) {
		GError* _tmp2_;
		_tmp2_ = g_error_new (GEARY_RF_C822_ERROR, GEARY_RF_C822_ERROR_INVALID, "Not ISO-8601 date: %s", rfc822);
		_inner_error0_ = _tmp2_;
		if (_inner_error0_->domain == GEARY_RF_C822_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_date_time_unref0 (date);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_date_time_unref0 (date);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp3_ = g_strdup (rfc822);
	_g_free0 (self->priv->rfc822);
	self->priv->rfc822 = _tmp3_;
	_tmp4_ = date;
	geary_rf_c822_date_set_value (self, _tmp4_);
	_g_date_time_unref0 (date);
	return self;
}

GearyRFC822Date*
geary_rf_c822_date_new_from_rfc822_string (const gchar* rfc822,
                                           GError** error)
{
	return geary_rf_c822_date_construct_from_rfc822_string (GEARY_RF_C822_TYPE_DATE, rfc822, error);
}

/**
     * Returns the {@link Date} in RFC 822 format.
     */
static gchar*
geary_rf_c822_date_real_to_rfc822_string (GearyRFC822DecodedMessageData* base)
{
	GearyRFC822Date * self;
	const gchar* _tmp0_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_RF_C822_TYPE_DATE, GearyRFC822Date);
	_tmp0_ = self->priv->rfc822;
	if (_tmp0_ == NULL) {
		GDateTime* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = self->priv->_value;
		_tmp2_ = g_mime_utils_header_format_date (_tmp1_);
		_g_free0 (self->priv->rfc822);
		self->priv->rfc822 = _tmp2_;
	}
	_tmp3_ = self->priv->rfc822;
	_tmp4_ = g_strdup (_tmp3_);
	result = _tmp4_;
	return result;
}

static gboolean
geary_rf_c822_date_real_equal_to (GearyRFC822Date* self,
                                  GearyRFC822Date* other)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (GEARY_RF_C822_IS_DATE (other), FALSE);
	if (self == other) {
		_tmp0_ = TRUE;
	} else {
		GDateTime* _tmp1_;
		GDateTime* _tmp2_;
		_tmp1_ = self->priv->_value;
		_tmp2_ = other->priv->_value;
		_tmp0_ = g_date_time_equal (_tmp1_, _tmp2_);
	}
	result = _tmp0_;
	return result;
}

gboolean
geary_rf_c822_date_equal_to (GearyRFC822Date* self,
                             GearyRFC822Date* other)
{
	GearyRFC822DateClass* _klass_;
	g_return_val_if_fail (GEARY_RF_C822_IS_DATE (self), FALSE);
	_klass_ = GEARY_RF_C822_DATE_GET_CLASS (self);
	if (_klass_->equal_to) {
		return _klass_->equal_to (self, other);
	}
	return FALSE;
}

static guint
geary_rf_c822_date_real_hash (GearyRFC822Date* self)
{
	GDateTime* _tmp0_;
	guint result;
	_tmp0_ = self->priv->_value;
	result = g_date_time_hash (_tmp0_);
	return result;
}

guint
geary_rf_c822_date_hash (GearyRFC822Date* self)
{
	GearyRFC822DateClass* _klass_;
	g_return_val_if_fail (GEARY_RF_C822_IS_DATE (self), 0U);
	_klass_ = GEARY_RF_C822_DATE_GET_CLASS (self);
	if (_klass_->hash) {
		return _klass_->hash (self);
	}
	return 0U;
}

static gchar*
g_date_time_to_string (GDateTime* self)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_date_time_format (self, "%FT%H:%M:%S%z");
	result = _tmp0_;
	return result;
}

static gchar*
geary_rf_c822_date_real_to_string (GearyMessageDataAbstractMessageData* base)
{
	GearyRFC822Date * self;
	GDateTime* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_RF_C822_TYPE_DATE, GearyRFC822Date);
	_tmp0_ = self->priv->_value;
	_tmp1_ = g_date_time_to_string (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
geary_rf_c822_date_class_init (GearyRFC822DateClass * klass,
                               gpointer klass_data)
{
	geary_rf_c822_date_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyRFC822Date_private_offset);
	((GearyRFC822DateClass *) klass)->equal_to = (gboolean (*) (GearyRFC822Date*, GearyRFC822Date*)) geary_rf_c822_date_real_equal_to;
	((GearyRFC822DateClass *) klass)->hash = (guint (*) (GearyRFC822Date*)) geary_rf_c822_date_real_hash;
	((GearyMessageDataAbstractMessageDataClass *) klass)->to_string = (gchar* (*) (GearyMessageDataAbstractMessageData*)) geary_rf_c822_date_real_to_string;
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_rf_c822_date_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_geary_rf_c822_date_set_property;
	G_OBJECT_CLASS (klass)->finalize = geary_rf_c822_date_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_RF_C822_DATE_VALUE_PROPERTY, geary_rf_c822_date_properties[GEARY_RF_C822_DATE_VALUE_PROPERTY] = g_param_spec_boxed ("value", "value", "value", G_TYPE_DATE_TIME, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
geary_rf_c822_date_gee_hashable_interface_init (GeeHashableIface * iface,
                                                gpointer iface_data)
{
	geary_rf_c822_date_gee_hashable_parent_iface = g_type_interface_peek_parent (iface);
	iface->equal_to = (gboolean (*) (GeeHashable*, gconstpointer)) geary_rf_c822_date_equal_to;
	iface->hash = (guint (*) (GeeHashable*)) geary_rf_c822_date_hash;
}

static void
geary_rf_c822_date_geary_rf_c822_decoded_message_data_interface_init (GearyRFC822DecodedMessageDataIface * iface,
                                                                      gpointer iface_data)
{
	geary_rf_c822_date_geary_rf_c822_decoded_message_data_parent_iface = g_type_interface_peek_parent (iface);
	iface->to_rfc822_string = (gchar* (*) (GearyRFC822DecodedMessageData*)) geary_rf_c822_date_real_to_rfc822_string;
}

static void
geary_rf_c822_date_instance_init (GearyRFC822Date * self,
                                  gpointer klass)
{
	self->priv = geary_rf_c822_date_get_instance_private (self);
}

static void
geary_rf_c822_date_finalize (GObject * obj)
{
	GearyRFC822Date * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_RF_C822_TYPE_DATE, GearyRFC822Date);
	_g_date_time_unref0 (self->priv->_value);
	_g_free0 (self->priv->rfc822);
	G_OBJECT_CLASS (geary_rf_c822_date_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
geary_rf_c822_date_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyRFC822DateClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_rf_c822_date_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyRFC822Date), 0, (GInstanceInitFunc) geary_rf_c822_date_instance_init, NULL };
	static const GInterfaceInfo gee_hashable_info = { (GInterfaceInitFunc) geary_rf_c822_date_gee_hashable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo geary_rf_c822_decoded_message_data_info = { (GInterfaceInitFunc) geary_rf_c822_date_geary_rf_c822_decoded_message_data_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType geary_rf_c822_date_type_id;
	geary_rf_c822_date_type_id = g_type_register_static (GEARY_MESSAGE_DATA_TYPE_ABSTRACT_MESSAGE_DATA, "GearyRFC822Date", &g_define_type_info, 0);
	g_type_add_interface_static (geary_rf_c822_date_type_id, GEE_TYPE_HASHABLE, &gee_hashable_info);
	g_type_add_interface_static (geary_rf_c822_date_type_id, GEARY_RF_C822_TYPE_DECODED_MESSAGE_DATA, &geary_rf_c822_decoded_message_data_info);
	GearyRFC822Date_private_offset = g_type_add_instance_private (geary_rf_c822_date_type_id, sizeof (GearyRFC822DatePrivate));
	return geary_rf_c822_date_type_id;
}

GType
geary_rf_c822_date_get_type (void)
{
	static gsize geary_rf_c822_date_type_id__once = 0;
	if (g_once_init_enter (&geary_rf_c822_date_type_id__once)) {
		GType geary_rf_c822_date_type_id;
		geary_rf_c822_date_type_id = geary_rf_c822_date_get_type_once ();
		g_once_init_leave (&geary_rf_c822_date_type_id__once, geary_rf_c822_date_type_id);
	}
	return geary_rf_c822_date_type_id__once;
}

static void
_vala_geary_rf_c822_date_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	GearyRFC822Date * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_RF_C822_TYPE_DATE, GearyRFC822Date);
	switch (property_id) {
		case GEARY_RF_C822_DATE_VALUE_PROPERTY:
		g_value_set_boxed (value, geary_rf_c822_date_get_value (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_geary_rf_c822_date_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec)
{
	GearyRFC822Date * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_RF_C822_TYPE_DATE, GearyRFC822Date);
	switch (property_id) {
		case GEARY_RF_C822_DATE_VALUE_PROPERTY:
		geary_rf_c822_date_set_value (self, g_value_get_boxed (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
geary_rf_c822_subject_get_instance_private (GearyRFC822Subject* self)
{
	return G_STRUCT_MEMBER_P (self, GearyRFC822Subject_private_offset);
}

GearyRFC822Subject*
geary_rf_c822_subject_construct (GType object_type,
                                 const gchar* value)
{
	GearyRFC822Subject * self = NULL;
	g_return_val_if_fail (value != NULL, NULL);
	self = (GearyRFC822Subject*) geary_message_data_string_message_data_construct (object_type, value);
	_g_free0 (self->priv->rfc822);
	self->priv->rfc822 = NULL;
	return self;
}

GearyRFC822Subject*
geary_rf_c822_subject_new (const gchar* value)
{
	return geary_rf_c822_subject_construct (GEARY_RF_C822_TYPE_SUBJECT, value);
}

GearyRFC822Subject*
geary_rf_c822_subject_construct_from_rfc822_string (GType object_type,
                                                    const gchar* rfc822)
{
	GearyRFC822Subject * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_val_if_fail (rfc822 != NULL, NULL);
	_tmp0_ = geary_rf_c822_utils_decode_rfc822_text_header_value (rfc822);
	_tmp1_ = _tmp0_;
	self = (GearyRFC822Subject*) geary_message_data_string_message_data_construct (object_type, _tmp1_);
	_g_free0 (_tmp1_);
	_tmp2_ = g_strdup (rfc822);
	_g_free0 (self->priv->rfc822);
	self->priv->rfc822 = _tmp2_;
	return self;
}

GearyRFC822Subject*
geary_rf_c822_subject_new_from_rfc822_string (const gchar* rfc822)
{
	return geary_rf_c822_subject_construct_from_rfc822_string (GEARY_RF_C822_TYPE_SUBJECT, rfc822);
}

/**
     * Returns the subject line encoded for an RFC 822 message.
     */
static void
_vala_GMimeFormatOptions_free (GMimeFormatOptions* self)
{
	g_boxed_free (g_mime_format_options_get_type (), self);
}

static gchar*
geary_rf_c822_subject_real_to_rfc822_string (GearyRFC822DecodedMessageData* base)
{
	GearyRFC822Subject * self;
	const gchar* _tmp0_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_RF_C822_TYPE_SUBJECT, GearyRFC822Subject);
	_tmp0_ = self->priv->rfc822;
	if (_tmp0_ == NULL) {
		GMimeFormatOptions* _tmp1_;
		GMimeFormatOptions* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp1_ = geary_rf_c822_get_format_options ();
		_tmp2_ = _tmp1_;
		_tmp3_ = geary_message_data_string_message_data_get_value (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_MESSAGE_DATA_TYPE_STRING_MESSAGE_DATA, GearyMessageDataStringMessageData));
		_tmp4_ = _tmp3_;
		_tmp5_ = g_mime_utils_header_encode_text (_tmp2_, _tmp4_, NULL);
		_g_free0 (self->priv->rfc822);
		self->priv->rfc822 = _tmp5_;
		__vala_GMimeFormatOptions_free0 (_tmp2_);
	}
	_tmp6_ = self->priv->rfc822;
	_tmp7_ = g_strdup (_tmp6_);
	result = _tmp7_;
	return result;
}

gboolean
geary_rf_c822_subject_is_reply (GearyRFC822Subject* self)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean _tmp6_;
	gboolean result;
	g_return_val_if_fail (GEARY_RF_C822_IS_SUBJECT (self), FALSE);
	_tmp0_ = geary_message_data_string_message_data_get_value (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_MESSAGE_DATA_TYPE_STRING_MESSAGE_DATA, GearyMessageDataStringMessageData));
	_tmp1_ = _tmp0_;
	_tmp2_ = g_utf8_strdown (_tmp1_, (gssize) -1);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_utf8_strdown (GEARY_RF_C822_SUBJECT_REPLY_PREFACE, (gssize) -1);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_str_has_prefix (_tmp3_, _tmp5_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	result = _tmp6_;
	return result;
}

GearyRFC822Subject*
geary_rf_c822_subject_create_reply (GearyRFC822Subject* self)
{
	GearyRFC822Subject* _tmp0_ = NULL;
	GearyRFC822Subject* result;
	g_return_val_if_fail (GEARY_RF_C822_IS_SUBJECT (self), NULL);
	if (geary_rf_c822_subject_is_reply (self)) {
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		GearyRFC822Subject* _tmp3_;
		_tmp1_ = geary_message_data_string_message_data_get_value (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_MESSAGE_DATA_TYPE_STRING_MESSAGE_DATA, GearyMessageDataStringMessageData));
		_tmp2_ = _tmp1_;
		_tmp3_ = geary_rf_c822_subject_new (_tmp2_);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp3_;
	} else {
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		GearyRFC822Subject* _tmp8_;
		_tmp4_ = geary_message_data_string_message_data_get_value (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_MESSAGE_DATA_TYPE_STRING_MESSAGE_DATA, GearyMessageDataStringMessageData));
		_tmp5_ = _tmp4_;
		_tmp6_ = g_strdup_printf ("%s %s", GEARY_RF_C822_SUBJECT_REPLY_PREFACE, _tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = geary_rf_c822_subject_new (_tmp7_);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp8_;
		_g_free0 (_tmp7_);
	}
	result = _tmp0_;
	return result;
}

gboolean
geary_rf_c822_subject_is_forward (GearyRFC822Subject* self)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean _tmp6_;
	gboolean result;
	g_return_val_if_fail (GEARY_RF_C822_IS_SUBJECT (self), FALSE);
	_tmp0_ = geary_message_data_string_message_data_get_value (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_MESSAGE_DATA_TYPE_STRING_MESSAGE_DATA, GearyMessageDataStringMessageData));
	_tmp1_ = _tmp0_;
	_tmp2_ = g_utf8_strdown (_tmp1_, (gssize) -1);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_utf8_strdown (GEARY_RF_C822_SUBJECT_FORWARD_PREFACE, (gssize) -1);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_str_has_prefix (_tmp3_, _tmp5_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	result = _tmp6_;
	return result;
}

GearyRFC822Subject*
geary_rf_c822_subject_create_forward (GearyRFC822Subject* self)
{
	GearyRFC822Subject* _tmp0_ = NULL;
	GearyRFC822Subject* result;
	g_return_val_if_fail (GEARY_RF_C822_IS_SUBJECT (self), NULL);
	if (geary_rf_c822_subject_is_forward (self)) {
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		GearyRFC822Subject* _tmp3_;
		_tmp1_ = geary_message_data_string_message_data_get_value (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_MESSAGE_DATA_TYPE_STRING_MESSAGE_DATA, GearyMessageDataStringMessageData));
		_tmp2_ = _tmp1_;
		_tmp3_ = geary_rf_c822_subject_new (_tmp2_);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp3_;
	} else {
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		GearyRFC822Subject* _tmp8_;
		_tmp4_ = geary_message_data_string_message_data_get_value (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_MESSAGE_DATA_TYPE_STRING_MESSAGE_DATA, GearyMessageDataStringMessageData));
		_tmp5_ = _tmp4_;
		_tmp6_ = g_strdup_printf ("%s %s", GEARY_RF_C822_SUBJECT_FORWARD_PREFACE, _tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = geary_rf_c822_subject_new (_tmp7_);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp8_;
		_g_free0 (_tmp7_);
	}
	result = _tmp0_;
	return result;
}

/**
     * Returns the Subject: line stripped of reply and forwarding prefixes.
     *
     * Strips ''all'' prefixes, meaning "Re: Fwd: Soup's on!" will return "Soup's on!"
     *
     * Returns an empty string if the Subject: line is empty (or is empty after stripping prefixes).
     */
gchar*
geary_rf_c822_subject_strip_prefixes (GearyRFC822Subject* self)
{
	gchar* subject_base = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean changed = FALSE;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (GEARY_RF_C822_IS_SUBJECT (self), NULL);
	_tmp0_ = geary_message_data_string_message_data_get_value (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_MESSAGE_DATA_TYPE_STRING_MESSAGE_DATA, GearyMessageDataStringMessageData));
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup (_tmp1_);
	subject_base = _tmp2_;
	changed = FALSE;
	{
		gboolean _tmp3_ = FALSE;
		_tmp3_ = TRUE;
		while (TRUE) {
			gchar* stripped = NULL;
			const gchar* _tmp20_;
			const gchar* _tmp21_;
			if (!_tmp3_) {
				if (!changed) {
					break;
				}
			}
			_tmp3_ = FALSE;
			{
				GRegex* re_regex = NULL;
				GRegex* _tmp4_;
				gchar* _tmp5_ = NULL;
				GRegex* _tmp6_;
				const gchar* _tmp7_;
				gchar* _tmp8_;
				gchar* _tmp9_;
				GRegex* fwd_regex = NULL;
				GRegex* _tmp10_;
				gchar* _tmp11_ = NULL;
				GRegex* _tmp12_;
				const gchar* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				_tmp4_ = g_regex_new ("^(?i:Re:\\s*)+", 0, 0, &_inner_error0_);
				re_regex = _tmp4_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == G_REGEX_ERROR) {
						goto __catch0_g_regex_error;
					}
					_g_free0 (stripped);
					_g_free0 (subject_base);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
				_tmp6_ = re_regex;
				_tmp7_ = subject_base;
				_tmp8_ = g_regex_replace (_tmp6_, _tmp7_, (gssize) -1, 0, "", 0, &_inner_error0_);
				_tmp5_ = _tmp8_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_regex_unref0 (re_regex);
					if (_inner_error0_->domain == G_REGEX_ERROR) {
						goto __catch0_g_regex_error;
					}
					_g_free0 (stripped);
					_g_free0 (subject_base);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
				_tmp9_ = _tmp5_;
				_tmp5_ = NULL;
				_g_free0 (stripped);
				stripped = _tmp9_;
				_tmp10_ = g_regex_new ("^(?i:Fwd:\\s*)+", 0, 0, &_inner_error0_);
				fwd_regex = _tmp10_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_free0 (_tmp5_);
					_g_regex_unref0 (re_regex);
					if (_inner_error0_->domain == G_REGEX_ERROR) {
						goto __catch0_g_regex_error;
					}
					_g_free0 (stripped);
					_g_free0 (subject_base);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
				_tmp12_ = fwd_regex;
				_tmp13_ = stripped;
				_tmp14_ = g_regex_replace (_tmp12_, _tmp13_, (gssize) -1, 0, "", 0, &_inner_error0_);
				_tmp11_ = _tmp14_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_regex_unref0 (fwd_regex);
					_g_free0 (_tmp5_);
					_g_regex_unref0 (re_regex);
					if (_inner_error0_->domain == G_REGEX_ERROR) {
						goto __catch0_g_regex_error;
					}
					_g_free0 (stripped);
					_g_free0 (subject_base);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
				_tmp15_ = _tmp11_;
				_tmp11_ = NULL;
				_g_free0 (stripped);
				stripped = _tmp15_;
				_g_free0 (_tmp11_);
				_g_regex_unref0 (fwd_regex);
				_g_free0 (_tmp5_);
				_g_regex_unref0 (re_regex);
			}
			goto __finally0;
			__catch0_g_regex_error:
			{
				GError* e = NULL;
				const gchar* _tmp16_;
				const gchar* _tmp17_;
				GError* _tmp18_;
				const gchar* _tmp19_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp16_ = geary_message_data_string_message_data_get_value (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_MESSAGE_DATA_TYPE_STRING_MESSAGE_DATA, GearyMessageDataStringMessageData));
				_tmp17_ = _tmp16_;
				_tmp18_ = e;
				_tmp19_ = _tmp18_->message;
				g_debug ("rfc822-message-data.vala:423: Failed to clean up subject line \"%s\": " \
"%s", _tmp17_, _tmp19_);
				_g_error_free0 (e);
				_g_free0 (stripped);
				break;
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (stripped);
				_g_free0 (subject_base);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
			_tmp20_ = stripped;
			_tmp21_ = subject_base;
			changed = g_strcmp0 (_tmp20_, _tmp21_) != 0;
			if (changed) {
				const gchar* _tmp22_;
				gchar* _tmp23_;
				_tmp22_ = stripped;
				_tmp23_ = g_strdup (_tmp22_);
				_g_free0 (subject_base);
				subject_base = _tmp23_;
			}
			_g_free0 (stripped);
		}
	}
	_tmp24_ = subject_base;
	_tmp25_ = geary_string_reduce_whitespace (_tmp24_);
	result = _tmp25_;
	_g_free0 (subject_base);
	return result;
}

/**
     * See Geary.MessageData.SearchableMessageData.
     */
static gchar*
geary_rf_c822_subject_real_to_searchable_string (GearyMessageDataSearchableMessageData* base)
{
	GearyRFC822Subject * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_RF_C822_TYPE_SUBJECT, GearyRFC822Subject);
	_tmp0_ = geary_message_data_string_message_data_get_value (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_MESSAGE_DATA_TYPE_STRING_MESSAGE_DATA, GearyMessageDataStringMessageData));
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup (_tmp1_);
	result = _tmp2_;
	return result;
}

static void
geary_rf_c822_subject_class_init (GearyRFC822SubjectClass * klass,
                                  gpointer klass_data)
{
	geary_rf_c822_subject_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyRFC822Subject_private_offset);
	G_OBJECT_CLASS (klass)->finalize = geary_rf_c822_subject_finalize;
}

static void
geary_rf_c822_subject_geary_message_data_searchable_message_data_interface_init (GearyMessageDataSearchableMessageDataIface * iface,
                                                                                 gpointer iface_data)
{
	geary_rf_c822_subject_geary_message_data_searchable_message_data_parent_iface = g_type_interface_peek_parent (iface);
	iface->to_searchable_string = (gchar* (*) (GearyMessageDataSearchableMessageData*)) geary_rf_c822_subject_real_to_searchable_string;
}

static void
geary_rf_c822_subject_geary_rf_c822_decoded_message_data_interface_init (GearyRFC822DecodedMessageDataIface * iface,
                                                                         gpointer iface_data)
{
	geary_rf_c822_subject_geary_rf_c822_decoded_message_data_parent_iface = g_type_interface_peek_parent (iface);
	iface->to_rfc822_string = (gchar* (*) (GearyRFC822DecodedMessageData*)) geary_rf_c822_subject_real_to_rfc822_string;
}

static void
geary_rf_c822_subject_instance_init (GearyRFC822Subject * self,
                                     gpointer klass)
{
	self->priv = geary_rf_c822_subject_get_instance_private (self);
}

static void
geary_rf_c822_subject_finalize (GObject * obj)
{
	GearyRFC822Subject * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_RF_C822_TYPE_SUBJECT, GearyRFC822Subject);
	_g_free0 (self->priv->rfc822);
	G_OBJECT_CLASS (geary_rf_c822_subject_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
geary_rf_c822_subject_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyRFC822SubjectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_rf_c822_subject_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyRFC822Subject), 0, (GInstanceInitFunc) geary_rf_c822_subject_instance_init, NULL };
	static const GInterfaceInfo geary_message_data_searchable_message_data_info = { (GInterfaceInitFunc) geary_rf_c822_subject_geary_message_data_searchable_message_data_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo geary_rf_c822_decoded_message_data_info = { (GInterfaceInitFunc) geary_rf_c822_subject_geary_rf_c822_decoded_message_data_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType geary_rf_c822_subject_type_id;
	geary_rf_c822_subject_type_id = g_type_register_static (GEARY_MESSAGE_DATA_TYPE_STRING_MESSAGE_DATA, "GearyRFC822Subject", &g_define_type_info, 0);
	g_type_add_interface_static (geary_rf_c822_subject_type_id, GEARY_MESSAGE_DATA_TYPE_SEARCHABLE_MESSAGE_DATA, &geary_message_data_searchable_message_data_info);
	g_type_add_interface_static (geary_rf_c822_subject_type_id, GEARY_RF_C822_TYPE_DECODED_MESSAGE_DATA, &geary_rf_c822_decoded_message_data_info);
	GearyRFC822Subject_private_offset = g_type_add_instance_private (geary_rf_c822_subject_type_id, sizeof (GearyRFC822SubjectPrivate));
	return geary_rf_c822_subject_type_id;
}

GType
geary_rf_c822_subject_get_type (void)
{
	static gsize geary_rf_c822_subject_type_id__once = 0;
	if (g_once_init_enter (&geary_rf_c822_subject_type_id__once)) {
		GType geary_rf_c822_subject_type_id;
		geary_rf_c822_subject_type_id = geary_rf_c822_subject_get_type_once ();
		g_once_init_leave (&geary_rf_c822_subject_type_id__once, geary_rf_c822_subject_type_id);
	}
	return geary_rf_c822_subject_type_id__once;
}

static inline gpointer
geary_rf_c822_header_get_instance_private (GearyRFC822Header* self)
{
	return G_STRUCT_MEMBER_P (self, GearyRFC822Header_private_offset);
}

GearyRFC822Header*
geary_rf_c822_header_construct (GType object_type,
                                GearyMemoryBuffer* buffer,
                                GError** error)
{
	GearyRFC822Header * self = NULL;
	GMimeParser* parser = NULL;
	GMimeStreamMem* _tmp0_;
	GMimeStreamMem* _tmp1_;
	GMimeParser* _tmp2_;
	GMimeParser* _tmp3_;
	GMimeParser* _tmp4_;
	GMimeParser* _tmp5_;
	GMimeMessage* message = NULL;
	GMimeParser* _tmp6_;
	GMimeMessage* _tmp7_;
	GMimeMessage* _tmp8_;
	GMimeMessage* _tmp10_;
	GMimeHeaderList* _tmp11_;
	GMimeHeaderList* _tmp12_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (GEARY_MEMORY_IS_BUFFER (buffer), NULL);
	self = (GearyRFC822Header*) geary_message_data_block_message_data_construct (object_type, "RFC822.Header", buffer);
	_tmp0_ = geary_rf_c822_utils_create_stream_mem (buffer);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_mime_parser_new_with_stream (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, g_mime_stream_get_type (), GMimeStream));
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	parser = _tmp3_;
	_tmp4_ = parser;
	g_mime_parser_set_respect_content_length (_tmp4_, FALSE);
	_tmp5_ = parser;
	g_mime_parser_set_format (_tmp5_, GMIME_FORMAT_MESSAGE);
	_tmp6_ = parser;
	_tmp7_ = g_mime_parser_construct_message (_tmp6_, NULL);
	message = _tmp7_;
	_tmp8_ = message;
	if (_tmp8_ == NULL) {
		GError* _tmp9_;
		_tmp9_ = g_error_new_literal (GEARY_RF_C822_ERROR, GEARY_RF_C822_ERROR_INVALID, "Unable to parse RFC 822 headers");
		_inner_error0_ = _tmp9_;
		if (_inner_error0_->domain == GEARY_RF_C822_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (message);
			_g_object_unref0 (parser);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_object_unref0 (message);
			_g_object_unref0 (parser);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp10_ = message;
	_tmp11_ = g_mime_object_get_header_list (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, g_mime_object_get_type (), GMimeObject));
	_tmp12_ = _g_object_ref0 (_tmp11_);
	_g_object_unref0 (self->priv->headers);
	self->priv->headers = _tmp12_;
	_g_object_unref0 (message);
	_g_object_unref0 (parser);
	return self;
}

GearyRFC822Header*
geary_rf_c822_header_new (GearyMemoryBuffer* buffer,
                          GError** error)
{
	return geary_rf_c822_header_construct (GEARY_RF_C822_TYPE_HEADER, buffer, error);
}

GearyRFC822Header*
geary_rf_c822_header_construct_from_gmime (GType object_type,
                                           GMimeObject* gmime)
{
	GearyRFC822Header * self = NULL;
	GMimeFormatOptions* _tmp0_;
	GMimeFormatOptions* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GearyMemoryStringBuffer* _tmp4_;
	GearyMemoryStringBuffer* _tmp5_;
	GMimeHeaderList* _tmp6_;
	GMimeHeaderList* _tmp7_;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (gmime, g_mime_object_get_type ()), NULL);
	_tmp0_ = geary_rf_c822_get_format_options ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_mime_object_get_headers (gmime, _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = geary_memory_string_buffer_new (_tmp3_);
	_tmp5_ = _tmp4_;
	self = (GearyRFC822Header*) geary_message_data_block_message_data_construct (object_type, "RFC822.Header", G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEARY_MEMORY_TYPE_BUFFER, GearyMemoryBuffer));
	_g_object_unref0 (_tmp5_);
	_g_free0 (_tmp3_);
	__vala_GMimeFormatOptions_free0 (_tmp1_);
	_tmp6_ = g_mime_object_get_header_list (gmime);
	_tmp7_ = _g_object_ref0 (_tmp6_);
	_g_object_unref0 (self->priv->headers);
	self->priv->headers = _tmp7_;
	return self;
}

GearyRFC822Header*
geary_rf_c822_header_new_from_gmime (GMimeObject* gmime)
{
	return geary_rf_c822_header_construct_from_gmime (GEARY_RF_C822_TYPE_HEADER, gmime);
}

gchar*
geary_rf_c822_header_get_header (GearyRFC822Header* self,
                                 const gchar* name)
{
	gchar* value = NULL;
	GMimeHeader* header = NULL;
	GMimeHeaderList* _tmp0_;
	GMimeHeader* _tmp1_;
	GMimeHeader* _tmp2_;
	GMimeHeader* _tmp3_;
	gchar* result;
	g_return_val_if_fail (GEARY_RF_C822_IS_HEADER (self), NULL);
	g_return_val_if_fail (name != NULL, NULL);
	value = NULL;
	_tmp0_ = self->priv->headers;
	_tmp1_ = g_mime_header_list_get_header (_tmp0_, name);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	header = _tmp2_;
	_tmp3_ = header;
	if (_tmp3_ != NULL) {
		GMimeHeader* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp4_ = header;
		_tmp5_ = g_mime_header_get_value (_tmp4_);
		_tmp6_ = g_strdup (_tmp5_);
		_g_free0 (value);
		value = _tmp6_;
	}
	result = value;
	_g_object_unref0 (header);
	return result;
}

gchar*
geary_rf_c822_header_get_raw_header (GearyRFC822Header* self,
                                     const gchar* name)
{
	gchar* value = NULL;
	GMimeHeader* header = NULL;
	GMimeHeaderList* _tmp0_;
	GMimeHeader* _tmp1_;
	GMimeHeader* _tmp2_;
	GMimeHeader* _tmp3_;
	gchar* result;
	g_return_val_if_fail (GEARY_RF_C822_IS_HEADER (self), NULL);
	g_return_val_if_fail (name != NULL, NULL);
	value = NULL;
	_tmp0_ = self->priv->headers;
	_tmp1_ = g_mime_header_list_get_header (_tmp0_, name);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	header = _tmp2_;
	_tmp3_ = header;
	if (_tmp3_ != NULL) {
		GMimeHeader* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp4_ = header;
		_tmp5_ = g_mime_header_get_raw_value (_tmp4_);
		_tmp6_ = g_strdup (_tmp5_);
		_g_free0 (value);
		value = _tmp6_;
	}
	result = value;
	_g_object_unref0 (header);
	return result;
}

static gchar**
_vala_array_dup13 (gchar** self,
                   gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
_vala_array_dup14 (gchar** self,
                   gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

gchar**
geary_rf_c822_header_get_header_names (GearyRFC822Header* self,
                                       gint* result_length1)
{
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp13_;
	gint _tmp13__length1;
	gchar** _tmp14_;
	gint _tmp14__length1;
	gchar** _tmp15_;
	gint _tmp15__length1;
	gchar** result;
	g_return_val_if_fail (GEARY_RF_C822_IS_HEADER (self), NULL);
	_tmp0_ = self->priv->names;
	_tmp0__length1 = self->priv->names_length1;
	if (_tmp0_ == NULL) {
		gchar** names = NULL;
		GMimeHeaderList* _tmp1_;
		gchar** _tmp2_;
		gint names_length1;
		gint _names_size_;
		gchar** _tmp11_;
		gint _tmp11__length1;
		gchar** _tmp12_;
		gint _tmp12__length1;
		_tmp1_ = self->priv->headers;
		_tmp2_ = g_new0 (gchar*, g_mime_header_list_get_count (_tmp1_) + 1);
		names = _tmp2_;
		names_length1 = g_mime_header_list_get_count (_tmp1_);
		_names_size_ = names_length1;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp3_ = FALSE;
				_tmp3_ = TRUE;
				while (TRUE) {
					gchar** _tmp5_;
					gint _tmp5__length1;
					gchar** _tmp6_;
					gint _tmp6__length1;
					GMimeHeaderList* _tmp7_;
					GMimeHeader* _tmp8_;
					const gchar* _tmp9_;
					gchar* _tmp10_;
					if (!_tmp3_) {
						gint _tmp4_;
						_tmp4_ = i;
						i = _tmp4_ + 1;
					}
					_tmp3_ = FALSE;
					_tmp5_ = names;
					_tmp5__length1 = names_length1;
					if (!(i < _tmp5__length1)) {
						break;
					}
					_tmp6_ = names;
					_tmp6__length1 = names_length1;
					_tmp7_ = self->priv->headers;
					_tmp8_ = g_mime_header_list_get_header_at (_tmp7_, i);
					_tmp9_ = g_mime_header_get_name (_tmp8_);
					_tmp10_ = g_strdup (_tmp9_);
					_g_free0 (_tmp6_[i]);
					_tmp6_[i] = _tmp10_;
				}
			}
		}
		_tmp11_ = names;
		_tmp11__length1 = names_length1;
		_tmp12_ = (_tmp11_ != NULL) ? _vala_array_dup13 (_tmp11_, _tmp11__length1) : _tmp11_;
		_tmp12__length1 = _tmp11__length1;
		self->priv->names = (_vala_array_free (self->priv->names, self->priv->names_length1, (GDestroyNotify) g_free), NULL);
		self->priv->names = _tmp12_;
		self->priv->names_length1 = _tmp12__length1;
		self->priv->_names_size_ = self->priv->names_length1;
		names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp13_ = self->priv->names;
	_tmp13__length1 = self->priv->names_length1;
	_tmp14_ = (_tmp13_ != NULL) ? _vala_array_dup14 (_tmp13_, _tmp13__length1) : _tmp13_;
	_tmp14__length1 = _tmp13__length1;
	_tmp15_ = _tmp14_;
	_tmp15__length1 = _tmp14__length1;
	if (result_length1) {
		*result_length1 = _tmp15__length1;
	}
	result = _tmp15_;
	return result;
}

static void
geary_rf_c822_header_class_init (GearyRFC822HeaderClass * klass,
                                 gpointer klass_data)
{
	geary_rf_c822_header_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyRFC822Header_private_offset);
	G_OBJECT_CLASS (klass)->finalize = geary_rf_c822_header_finalize;
}

static void
geary_rf_c822_header_geary_rf_c822_encoded_message_data_interface_init (GearyRFC822EncodedMessageDataIface * iface,
                                                                        gpointer iface_data)
{
	geary_rf_c822_header_geary_rf_c822_encoded_message_data_parent_iface = g_type_interface_peek_parent (iface);
}

static void
geary_rf_c822_header_instance_init (GearyRFC822Header * self,
                                    gpointer klass)
{
	self->priv = geary_rf_c822_header_get_instance_private (self);
	self->priv->names = NULL;
	self->priv->names_length1 = 0;
	self->priv->_names_size_ = self->priv->names_length1;
}

static void
geary_rf_c822_header_finalize (GObject * obj)
{
	GearyRFC822Header * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_RF_C822_TYPE_HEADER, GearyRFC822Header);
	_g_object_unref0 (self->priv->headers);
	self->priv->names = (_vala_array_free (self->priv->names, self->priv->names_length1, (GDestroyNotify) g_free), NULL);
	G_OBJECT_CLASS (geary_rf_c822_header_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
geary_rf_c822_header_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyRFC822HeaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_rf_c822_header_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyRFC822Header), 0, (GInstanceInitFunc) geary_rf_c822_header_instance_init, NULL };
	static const GInterfaceInfo geary_rf_c822_encoded_message_data_info = { (GInterfaceInitFunc) geary_rf_c822_header_geary_rf_c822_encoded_message_data_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType geary_rf_c822_header_type_id;
	geary_rf_c822_header_type_id = g_type_register_static (GEARY_MESSAGE_DATA_TYPE_BLOCK_MESSAGE_DATA, "GearyRFC822Header", &g_define_type_info, 0);
	g_type_add_interface_static (geary_rf_c822_header_type_id, GEARY_RF_C822_TYPE_ENCODED_MESSAGE_DATA, &geary_rf_c822_encoded_message_data_info);
	GearyRFC822Header_private_offset = g_type_add_instance_private (geary_rf_c822_header_type_id, sizeof (GearyRFC822HeaderPrivate));
	return geary_rf_c822_header_type_id;
}

GType
geary_rf_c822_header_get_type (void)
{
	static gsize geary_rf_c822_header_type_id__once = 0;
	if (g_once_init_enter (&geary_rf_c822_header_type_id__once)) {
		GType geary_rf_c822_header_type_id;
		geary_rf_c822_header_type_id = geary_rf_c822_header_get_type_once ();
		g_once_init_leave (&geary_rf_c822_header_type_id__once, geary_rf_c822_header_type_id);
	}
	return geary_rf_c822_header_type_id__once;
}

GearyRFC822Text*
geary_rf_c822_text_construct (GType object_type,
                              GearyMemoryBuffer* buffer)
{
	GearyRFC822Text * self = NULL;
	g_return_val_if_fail (GEARY_MEMORY_IS_BUFFER (buffer), NULL);
	self = (GearyRFC822Text*) geary_message_data_block_message_data_construct (object_type, "RFC822.Text", buffer);
	return self;
}

GearyRFC822Text*
geary_rf_c822_text_new (GearyMemoryBuffer* buffer)
{
	return geary_rf_c822_text_construct (GEARY_RF_C822_TYPE_TEXT, buffer);
}

GearyRFC822Text*
geary_rf_c822_text_construct_from_gmime (GType object_type,
                                         GMimeStream* gmime)
{
	GearyRFC822Text * self = NULL;
	GearyRFC822TextGMimeBuffer* _tmp0_;
	GearyRFC822TextGMimeBuffer* _tmp1_;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (gmime, g_mime_stream_get_type ()), NULL);
	_tmp0_ = geary_rf_c822_text_gmime_buffer_new (gmime);
	_tmp1_ = _tmp0_;
	self = (GearyRFC822Text*) geary_message_data_block_message_data_construct (object_type, "RFC822.Text", G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEARY_MEMORY_TYPE_BUFFER, GearyMemoryBuffer));
	_g_object_unref0 (_tmp1_);
	return self;
}

GearyRFC822Text*
geary_rf_c822_text_new_from_gmime (GMimeStream* gmime)
{
	return geary_rf_c822_text_construct_from_gmime (GEARY_RF_C822_TYPE_TEXT, gmime);
}

static inline gpointer
geary_rf_c822_text_gmime_buffer_get_instance_private (GearyRFC822TextGMimeBuffer* self)
{
	return G_STRUCT_MEMBER_P (self, GearyRFC822TextGMimeBuffer_private_offset);
}

static gsize
geary_rf_c822_text_gmime_buffer_real_get_allocated_size (GearyMemoryBuffer* base)
{
	gsize result;
	GearyRFC822TextGMimeBuffer* self;
	GMimeStream* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_RF_C822_TEXT_TYPE_GMIME_BUFFER, GearyRFC822TextGMimeBuffer);
	_tmp0_ = self->priv->stream;
	result = (gsize) g_mime_stream_length;
	return result;
}

static gsize
geary_rf_c822_text_gmime_buffer_real_get_size (GearyMemoryBuffer* base)
{
	gsize result;
	GearyRFC822TextGMimeBuffer* self;
	GMimeStream* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_RF_C822_TEXT_TYPE_GMIME_BUFFER, GearyRFC822TextGMimeBuffer);
	_tmp0_ = self->priv->stream;
	result = (gsize) g_mime_stream_length;
	return result;
}

static GearyRFC822TextGMimeBuffer*
geary_rf_c822_text_gmime_buffer_construct (GType object_type,
                                           GMimeStream* stream)
{
	GearyRFC822TextGMimeBuffer * self = NULL;
	GMimeStream* _tmp0_;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (stream, g_mime_stream_get_type ()), NULL);
	self = (GearyRFC822TextGMimeBuffer*) geary_memory_buffer_construct (object_type);
	_tmp0_ = _g_object_ref0 (stream);
	_g_object_unref0 (self->priv->stream);
	self->priv->stream = _tmp0_;
	return self;
}

static GearyRFC822TextGMimeBuffer*
geary_rf_c822_text_gmime_buffer_new (GMimeStream* stream)
{
	return geary_rf_c822_text_gmime_buffer_construct (GEARY_RF_C822_TEXT_TYPE_GMIME_BUFFER, stream);
}

static guint8*
_vala_array_dup15 (guint8* self,
                   gssize length)
{
	if (length > 0) {
		return g_memdup2 (self, length * sizeof (guint8));
	}
	return NULL;
}

static gpointer
_g_bytes_ref0 (gpointer self)
{
	return self ? g_bytes_ref (self) : NULL;
}

static GBytes*
geary_rf_c822_text_gmime_buffer_real_get_bytes (GearyMemoryBuffer* base)
{
	GearyRFC822TextGMimeBuffer * self;
	GBytes* _tmp0_;
	GBytes* _tmp9_;
	GBytes* _tmp10_;
	GBytes* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_RF_C822_TEXT_TYPE_GMIME_BUFFER, GearyRFC822TextGMimeBuffer);
	_tmp0_ = self->priv->buf;
	if (_tmp0_ == NULL) {
		GMimeStream* _tmp1_;
		guint8* bytes = NULL;
		GMimeStream* _tmp2_;
		guint8* _tmp3_;
		gint bytes_length1;
		gint _bytes_size_;
		GMimeStream* _tmp4_;
		guint8* _tmp5_;
		gint _tmp5__length1;
		guint8* _tmp6_;
		gint _tmp6__length1;
		guint8* _tmp7_;
		gint _tmp7__length1;
		GBytes* _tmp8_;
		_tmp1_ = self->priv->stream;
		g_mime_stream_seek (_tmp1_, (gint64) 0, GMIME_STREAM_SEEK_SET);
		_tmp2_ = self->priv->stream;
		_tmp3_ = g_new0 (guint8, g_mime_stream_length (_tmp2_));
		bytes = _tmp3_;
		bytes_length1 = g_mime_stream_length (_tmp2_);
		_bytes_size_ = bytes_length1;
		_tmp4_ = self->priv->stream;
		_tmp5_ = bytes;
		_tmp5__length1 = bytes_length1;
		g_mime_stream_read (_tmp4_, _tmp5_, (gsize) _tmp5__length1);
		_tmp6_ = bytes;
		_tmp6__length1 = bytes_length1;
		_tmp7_ = (_tmp6_ != NULL) ? _vala_array_dup15 (_tmp6_, _tmp6__length1) : _tmp6_;
		_tmp7__length1 = _tmp6__length1;
		_tmp8_ = g_bytes_new_take (_tmp7_, _tmp7__length1);
		_g_bytes_unref0 (self->priv->buf);
		self->priv->buf = _tmp8_;
		bytes = (g_free (bytes), NULL);
	}
	_tmp9_ = self->priv->buf;
	_tmp10_ = _g_bytes_ref0 (_tmp9_);
	result = _tmp10_;
	return result;
}

static guint8*
geary_rf_c822_text_gmime_buffer_real_to_unowned_uint8_array (GearyMemoryUnownedBytesBuffer* base,
                                                             gint* result_length1)
{
	GearyRFC822TextGMimeBuffer * self;
	GBytes* _tmp0_;
	GBytes* _tmp1_;
	gsize _tmp2_ = 0;
	guint8* _tmp3_;
	guint8* _tmp4_;
	gint _tmp4__length1;
	guint8* _tmp5_;
	gint _tmp5__length1;
	guint8* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_RF_C822_TEXT_TYPE_GMIME_BUFFER, GearyRFC822TextGMimeBuffer);
	_tmp0_ = geary_memory_buffer_get_bytes (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_MEMORY_TYPE_BUFFER, GearyMemoryBuffer));
	_tmp1_ = _tmp0_;
	_tmp3_ = g_bytes_get_data (_tmp1_, &_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp2_;
	_g_bytes_unref0 (_tmp1_);
	_tmp5_ = _tmp4_;
	_tmp5__length1 = _tmp4__length1;
	if (result_length1) {
		*result_length1 = _tmp5__length1;
	}
	result = _tmp5_;
	return result;
}

static void
geary_rf_c822_text_gmime_buffer_class_init (GearyRFC822TextGMimeBufferClass * klass,
                                            gpointer klass_data)
{
	geary_rf_c822_text_gmime_buffer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyRFC822TextGMimeBuffer_private_offset);
	((GearyMemoryBufferClass *) klass)->get_bytes = (GBytes* (*) (GearyMemoryBuffer*)) geary_rf_c822_text_gmime_buffer_real_get_bytes;
	GEARY_MEMORY_BUFFER_CLASS (klass)->get_allocated_size = geary_rf_c822_text_gmime_buffer_real_get_allocated_size;
	GEARY_MEMORY_BUFFER_CLASS (klass)->get_size = geary_rf_c822_text_gmime_buffer_real_get_size;
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_rf_c822_text_gmime_buffer_get_property;
	G_OBJECT_CLASS (klass)->finalize = geary_rf_c822_text_gmime_buffer_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_RF_C822_TEXT_GMIME_BUFFER_ALLOCATED_SIZE_PROPERTY, geary_rf_c822_text_gmime_buffer_properties[GEARY_RF_C822_TEXT_GMIME_BUFFER_ALLOCATED_SIZE_PROPERTY] = g_param_spec_ulong ("allocated-size", "allocated-size", "allocated-size", 0, G_MAXULONG, 0UL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_RF_C822_TEXT_GMIME_BUFFER_SIZE_PROPERTY, geary_rf_c822_text_gmime_buffer_properties[GEARY_RF_C822_TEXT_GMIME_BUFFER_SIZE_PROPERTY] = g_param_spec_ulong ("size", "size", "size", 0, G_MAXULONG, 0UL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
geary_rf_c822_text_gmime_buffer_geary_memory_unowned_bytes_buffer_interface_init (GearyMemoryUnownedBytesBufferIface * iface,
                                                                                  gpointer iface_data)
{
	geary_rf_c822_text_gmime_buffer_geary_memory_unowned_bytes_buffer_parent_iface = g_type_interface_peek_parent (iface);
	iface->to_unowned_uint8_array = (guint8* (*) (GearyMemoryUnownedBytesBuffer*, gint*)) geary_rf_c822_text_gmime_buffer_real_to_unowned_uint8_array;
}

static void
geary_rf_c822_text_gmime_buffer_instance_init (GearyRFC822TextGMimeBuffer * self,
                                               gpointer klass)
{
	self->priv = geary_rf_c822_text_gmime_buffer_get_instance_private (self);
	self->priv->buf = NULL;
}

static void
geary_rf_c822_text_gmime_buffer_finalize (GObject * obj)
{
	GearyRFC822TextGMimeBuffer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_RF_C822_TEXT_TYPE_GMIME_BUFFER, GearyRFC822TextGMimeBuffer);
	_g_object_unref0 (self->priv->stream);
	_g_bytes_unref0 (self->priv->buf);
	G_OBJECT_CLASS (geary_rf_c822_text_gmime_buffer_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
geary_rf_c822_text_gmime_buffer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyRFC822TextGMimeBufferClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_rf_c822_text_gmime_buffer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyRFC822TextGMimeBuffer), 0, (GInstanceInitFunc) geary_rf_c822_text_gmime_buffer_instance_init, NULL };
	static const GInterfaceInfo geary_memory_unowned_bytes_buffer_info = { (GInterfaceInitFunc) geary_rf_c822_text_gmime_buffer_geary_memory_unowned_bytes_buffer_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType geary_rf_c822_text_gmime_buffer_type_id;
	geary_rf_c822_text_gmime_buffer_type_id = g_type_register_static (GEARY_MEMORY_TYPE_BUFFER, "GearyRFC822TextGMimeBuffer", &g_define_type_info, 0);
	g_type_add_interface_static (geary_rf_c822_text_gmime_buffer_type_id, GEARY_MEMORY_TYPE_UNOWNED_BYTES_BUFFER, &geary_memory_unowned_bytes_buffer_info);
	GearyRFC822TextGMimeBuffer_private_offset = g_type_add_instance_private (geary_rf_c822_text_gmime_buffer_type_id, sizeof (GearyRFC822TextGMimeBufferPrivate));
	return geary_rf_c822_text_gmime_buffer_type_id;
}

static GType
geary_rf_c822_text_gmime_buffer_get_type (void)
{
	static gsize geary_rf_c822_text_gmime_buffer_type_id__once = 0;
	if (g_once_init_enter (&geary_rf_c822_text_gmime_buffer_type_id__once)) {
		GType geary_rf_c822_text_gmime_buffer_type_id;
		geary_rf_c822_text_gmime_buffer_type_id = geary_rf_c822_text_gmime_buffer_get_type_once ();
		g_once_init_leave (&geary_rf_c822_text_gmime_buffer_type_id__once, geary_rf_c822_text_gmime_buffer_type_id);
	}
	return geary_rf_c822_text_gmime_buffer_type_id__once;
}

static void
_vala_geary_rf_c822_text_gmime_buffer_get_property (GObject * object,
                                                    guint property_id,
                                                    GValue * value,
                                                    GParamSpec * pspec)
{
	GearyRFC822TextGMimeBuffer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_RF_C822_TEXT_TYPE_GMIME_BUFFER, GearyRFC822TextGMimeBuffer);
	switch (property_id) {
		case GEARY_RF_C822_TEXT_GMIME_BUFFER_ALLOCATED_SIZE_PROPERTY:
		g_value_set_ulong (value, geary_memory_buffer_get_allocated_size (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_MEMORY_TYPE_BUFFER, GearyMemoryBuffer)));
		break;
		case GEARY_RF_C822_TEXT_GMIME_BUFFER_SIZE_PROPERTY:
		g_value_set_ulong (value, geary_memory_buffer_get_size (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_MEMORY_TYPE_BUFFER, GearyMemoryBuffer)));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
geary_rf_c822_text_class_init (GearyRFC822TextClass * klass,
                               gpointer klass_data)
{
	geary_rf_c822_text_parent_class = g_type_class_peek_parent (klass);
}

static void
geary_rf_c822_text_geary_rf_c822_encoded_message_data_interface_init (GearyRFC822EncodedMessageDataIface * iface,
                                                                      gpointer iface_data)
{
	geary_rf_c822_text_geary_rf_c822_encoded_message_data_parent_iface = g_type_interface_peek_parent (iface);
}

static void
geary_rf_c822_text_instance_init (GearyRFC822Text * self,
                                  gpointer klass)
{
}

 G_GNUC_NO_INLINE static GType
geary_rf_c822_text_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyRFC822TextClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_rf_c822_text_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyRFC822Text), 0, (GInstanceInitFunc) geary_rf_c822_text_instance_init, NULL };
	static const GInterfaceInfo geary_rf_c822_encoded_message_data_info = { (GInterfaceInitFunc) geary_rf_c822_text_geary_rf_c822_encoded_message_data_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType geary_rf_c822_text_type_id;
	geary_rf_c822_text_type_id = g_type_register_static (GEARY_MESSAGE_DATA_TYPE_BLOCK_MESSAGE_DATA, "GearyRFC822Text", &g_define_type_info, 0);
	g_type_add_interface_static (geary_rf_c822_text_type_id, GEARY_RF_C822_TYPE_ENCODED_MESSAGE_DATA, &geary_rf_c822_encoded_message_data_info);
	return geary_rf_c822_text_type_id;
}

GType
geary_rf_c822_text_get_type (void)
{
	static gsize geary_rf_c822_text_type_id__once = 0;
	if (g_once_init_enter (&geary_rf_c822_text_type_id__once)) {
		GType geary_rf_c822_text_type_id;
		geary_rf_c822_text_type_id = geary_rf_c822_text_get_type_once ();
		g_once_init_leave (&geary_rf_c822_text_type_id__once, geary_rf_c822_text_type_id);
	}
	return geary_rf_c822_text_type_id__once;
}

GearyRFC822Full*
geary_rf_c822_full_construct (GType object_type,
                              GearyMemoryBuffer* buffer)
{
	GearyRFC822Full * self = NULL;
	g_return_val_if_fail (GEARY_MEMORY_IS_BUFFER (buffer), NULL);
	self = (GearyRFC822Full*) geary_message_data_block_message_data_construct (object_type, "RFC822.Full", buffer);
	return self;
}

GearyRFC822Full*
geary_rf_c822_full_new (GearyMemoryBuffer* buffer)
{
	return geary_rf_c822_full_construct (GEARY_RF_C822_TYPE_FULL, buffer);
}

static void
geary_rf_c822_full_class_init (GearyRFC822FullClass * klass,
                               gpointer klass_data)
{
	geary_rf_c822_full_parent_class = g_type_class_peek_parent (klass);
}

static void
geary_rf_c822_full_geary_rf_c822_encoded_message_data_interface_init (GearyRFC822EncodedMessageDataIface * iface,
                                                                      gpointer iface_data)
{
	geary_rf_c822_full_geary_rf_c822_encoded_message_data_parent_iface = g_type_interface_peek_parent (iface);
}

static void
geary_rf_c822_full_instance_init (GearyRFC822Full * self,
                                  gpointer klass)
{
}

 G_GNUC_NO_INLINE static GType
geary_rf_c822_full_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyRFC822FullClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_rf_c822_full_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyRFC822Full), 0, (GInstanceInitFunc) geary_rf_c822_full_instance_init, NULL };
	static const GInterfaceInfo geary_rf_c822_encoded_message_data_info = { (GInterfaceInitFunc) geary_rf_c822_full_geary_rf_c822_encoded_message_data_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType geary_rf_c822_full_type_id;
	geary_rf_c822_full_type_id = g_type_register_static (GEARY_MESSAGE_DATA_TYPE_BLOCK_MESSAGE_DATA, "GearyRFC822Full", &g_define_type_info, 0);
	g_type_add_interface_static (geary_rf_c822_full_type_id, GEARY_RF_C822_TYPE_ENCODED_MESSAGE_DATA, &geary_rf_c822_encoded_message_data_info);
	return geary_rf_c822_full_type_id;
}

GType
geary_rf_c822_full_get_type (void)
{
	static gsize geary_rf_c822_full_type_id__once = 0;
	if (g_once_init_enter (&geary_rf_c822_full_type_id__once)) {
		GType geary_rf_c822_full_type_id;
		geary_rf_c822_full_type_id = geary_rf_c822_full_get_type_once ();
		g_once_init_leave (&geary_rf_c822_full_type_id__once, geary_rf_c822_full_type_id);
	}
	return geary_rf_c822_full_type_id__once;
}

GearyRFC822PreviewText*
geary_rf_c822_preview_text_construct (GType object_type,
                                      GearyMemoryBuffer* _buffer)
{
	GearyRFC822PreviewText * self = NULL;
	g_return_val_if_fail (GEARY_MEMORY_IS_BUFFER (_buffer), NULL);
	self = (GearyRFC822PreviewText*) geary_rf_c822_text_construct (object_type, _buffer);
	return self;
}

GearyRFC822PreviewText*
geary_rf_c822_preview_text_new (GearyMemoryBuffer* _buffer)
{
	return geary_rf_c822_preview_text_construct (GEARY_RF_C822_TYPE_PREVIEW_TEXT, _buffer);
}

static void
_vala_GMimeParserOptions_free (GMimeParserOptions* self)
{
	g_boxed_free (g_mime_parser_options_get_type (), self);
}

GearyRFC822PreviewText*
geary_rf_c822_preview_text_construct_with_header (GType object_type,
                                                  GearyMemoryBuffer* preview_header,
                                                  GearyMemoryBuffer* preview)
{
	GearyRFC822PreviewText * self = NULL;
	gchar* preview_text = NULL;
	gchar* _tmp0_;
	GMimeStream* header_stream = NULL;
	GMimeStreamMem* _tmp1_;
	GMimeParser* parser = NULL;
	GMimeStream* _tmp2_;
	GMimeParser* _tmp3_;
	GMimePart* gpart = NULL;
	GMimeParser* _tmp4_;
	GMimeParserOptions* _tmp5_;
	GMimeParserOptions* _tmp6_;
	GMimeObject* _tmp7_;
	GMimePart* _tmp8_;
	GMimePart* _tmp9_;
	GMimePart* _tmp10_;
	const gchar* _tmp39_;
	GearyMemoryStringBuffer* _tmp40_;
	GearyMemoryStringBuffer* _tmp41_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (GEARY_MEMORY_IS_BUFFER (preview_header), NULL);
	g_return_val_if_fail (GEARY_MEMORY_IS_BUFFER (preview), NULL);
	_tmp0_ = g_strdup ("");
	preview_text = _tmp0_;
	_tmp1_ = geary_rf_c822_utils_create_stream_mem (preview_header);
	header_stream = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, g_mime_stream_get_type (), GMimeStream);
	_tmp2_ = header_stream;
	_tmp3_ = g_mime_parser_new_with_stream (_tmp2_);
	parser = _tmp3_;
	_tmp4_ = parser;
	_tmp5_ = geary_rf_c822_get_parser_options ();
	_tmp6_ = _tmp5_;
	_tmp7_ = g_mime_parser_construct_part (_tmp4_, _tmp6_);
	_tmp8_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, g_mime_part_get_type ()) ? ((GMimePart*) _tmp7_) : NULL;
	if (_tmp8_ == NULL) {
		_g_object_unref0 (_tmp7_);
	}
	_tmp9_ = _tmp8_;
	__vala_GMimeParserOptions_free0 (_tmp6_);
	gpart = _tmp9_;
	_tmp10_ = gpart;
	if (_tmp10_ != NULL) {
		GearyRFC822Part* part = NULL;
		GMimePart* _tmp11_;
		GearyRFC822Part* _tmp12_;
		GearyMimeContentType* content_type = NULL;
		GearyRFC822Part* _tmp13_;
		GearyMimeContentType* _tmp14_;
		GearyMimeContentType* _tmp15_;
		GearyMimeContentType* _tmp16_;
		gboolean is_plain = FALSE;
		GearyMimeContentType* _tmp17_;
		gboolean is_html = FALSE;
		GearyMimeContentType* _tmp18_;
		gboolean _tmp19_ = FALSE;
		_tmp11_ = gpart;
		_tmp12_ = geary_rf_c822_part_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, g_mime_object_get_type (), GMimeObject));
		part = _tmp12_;
		_tmp13_ = part;
		_tmp14_ = geary_rf_c822_part_get_content_type (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = _g_object_ref0 (_tmp15_);
		content_type = _tmp16_;
		_tmp17_ = content_type;
		is_plain = geary_mime_content_type_is_type (_tmp17_, "text", "plain");
		_tmp18_ = content_type;
		is_html = geary_mime_content_type_is_type (_tmp18_, "text", "html");
		if (is_plain) {
			_tmp19_ = TRUE;
		} else {
			_tmp19_ = is_html;
		}
		if (_tmp19_) {
			GMimeDataWrapper* body = NULL;
			gint _tmp20_ = 0;
			guint8* _tmp21_;
			guint8* _tmp22_;
			gint _tmp22__length1;
			GMimeStreamMem* _tmp23_;
			GMimeStreamMem* _tmp24_;
			GMimePart* _tmp25_;
			GMimeDataWrapper* _tmp26_;
			GMimeDataWrapper* _tmp27_;
			GMimePart* _tmp28_;
			GMimeDataWrapper* _tmp29_;
			_tmp21_ = geary_memory_buffer_get_uint8_array (preview, &_tmp20_);
			_tmp22_ = _tmp21_;
			_tmp22__length1 = _tmp20_;
			_tmp23_ = (GMimeStreamMem*) g_mime_stream_mem_new_with_buffer (_tmp22_, _tmp20_);
			_tmp24_ = _tmp23_;
			_tmp25_ = gpart;
			_tmp26_ = g_mime_data_wrapper_new_with_stream (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, g_mime_stream_get_type (), GMimeStream), g_mime_part_get_content_encoding (_tmp25_));
			_tmp27_ = _tmp26_;
			_g_object_unref0 (_tmp24_);
			_tmp22_ = (g_free (_tmp22_), NULL);
			body = _tmp27_;
			_tmp28_ = gpart;
			_tmp29_ = body;
			g_mime_part_set_content (_tmp28_, _tmp29_);
			{
				GearyMemoryBuffer* preview_buffer = NULL;
				GearyRFC822Part* _tmp30_;
				GearyMemoryBuffer* _tmp31_;
				GearyRFC822TextFormat _tmp32_ = 0;
				GearyMemoryBuffer* _tmp33_;
				gchar* _tmp34_;
				gchar* _tmp35_;
				gchar* _tmp36_;
				_tmp30_ = part;
				_tmp31_ = geary_rf_c822_part_write_to_buffer (_tmp30_, GEARY_RF_C822_PART_ENCODING_CONVERSION_UTF8, GEARY_RF_C822_PART_BODY_FORMATTING_NONE, &_inner_error0_);
				preview_buffer = _tmp31_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == GEARY_RF_C822_ERROR) {
						goto __catch0_geary_rf_c822_error;
					}
					_g_object_unref0 (body);
					_g_object_unref0 (content_type);
					_g_object_unref0 (part);
					_g_object_unref0 (gpart);
					_g_object_unref0 (parser);
					_g_object_unref0 (header_stream);
					_g_free0 (preview_text);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
				if (is_html) {
					_tmp32_ = GEARY_RF_C822_TEXT_FORMAT_HTML;
				} else {
					_tmp32_ = GEARY_RF_C822_TEXT_FORMAT_PLAIN;
				}
				_tmp33_ = preview_buffer;
				_tmp34_ = geary_memory_buffer_get_valid_utf8 (_tmp33_);
				_tmp35_ = _tmp34_;
				_tmp36_ = geary_rf_c822_utils_to_preview_text (_tmp35_, _tmp32_);
				_g_free0 (preview_text);
				preview_text = _tmp36_;
				_g_free0 (_tmp35_);
				_g_object_unref0 (preview_buffer);
			}
			goto __finally0;
			__catch0_geary_rf_c822_error:
			{
				GError* err = NULL;
				GError* _tmp37_;
				const gchar* _tmp38_;
				err = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp37_ = err;
				_tmp38_ = _tmp37_->message;
				g_debug ("rfc822-message-data.vala:609: Failed to parse preview body: %s", _tmp38_);
				_g_error_free0 (err);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (body);
				_g_object_unref0 (content_type);
				_g_object_unref0 (part);
				_g_object_unref0 (gpart);
				_g_object_unref0 (parser);
				_g_object_unref0 (header_stream);
				_g_free0 (preview_text);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
			_g_object_unref0 (body);
		}
		_g_object_unref0 (content_type);
		_g_object_unref0 (part);
	}
	_tmp39_ = preview_text;
	_tmp40_ = geary_memory_string_buffer_new (_tmp39_);
	_tmp41_ = _tmp40_;
	self = (GearyRFC822PreviewText*) geary_rf_c822_text_construct (object_type, G_TYPE_CHECK_INSTANCE_CAST (_tmp41_, GEARY_MEMORY_TYPE_BUFFER, GearyMemoryBuffer));
	_g_object_unref0 (_tmp41_);
	_g_object_unref0 (gpart);
	_g_object_unref0 (parser);
	_g_object_unref0 (header_stream);
	_g_free0 (preview_text);
	return self;
}

GearyRFC822PreviewText*
geary_rf_c822_preview_text_new_with_header (GearyMemoryBuffer* preview_header,
                                            GearyMemoryBuffer* preview)
{
	return geary_rf_c822_preview_text_construct_with_header (GEARY_RF_C822_TYPE_PREVIEW_TEXT, preview_header, preview);
}

GearyRFC822PreviewText*
geary_rf_c822_preview_text_construct_from_string (GType object_type,
                                                  const gchar* preview)
{
	GearyRFC822PreviewText * self = NULL;
	GearyMemoryStringBuffer* _tmp0_;
	GearyMemoryStringBuffer* _tmp1_;
	g_return_val_if_fail (preview != NULL, NULL);
	_tmp0_ = geary_memory_string_buffer_new (preview);
	_tmp1_ = _tmp0_;
	self = (GearyRFC822PreviewText*) geary_rf_c822_text_construct (object_type, G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEARY_MEMORY_TYPE_BUFFER, GearyMemoryBuffer));
	_g_object_unref0 (_tmp1_);
	return self;
}

GearyRFC822PreviewText*
geary_rf_c822_preview_text_new_from_string (const gchar* preview)
{
	return geary_rf_c822_preview_text_construct_from_string (GEARY_RF_C822_TYPE_PREVIEW_TEXT, preview);
}

static void
geary_rf_c822_preview_text_class_init (GearyRFC822PreviewTextClass * klass,
                                       gpointer klass_data)
{
	geary_rf_c822_preview_text_parent_class = g_type_class_peek_parent (klass);
}

static void
geary_rf_c822_preview_text_instance_init (GearyRFC822PreviewText * self,
                                          gpointer klass)
{
}

/** Represents text providing a preview of an email's body. */
 G_GNUC_NO_INLINE static GType
geary_rf_c822_preview_text_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyRFC822PreviewTextClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_rf_c822_preview_text_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyRFC822PreviewText), 0, (GInstanceInitFunc) geary_rf_c822_preview_text_instance_init, NULL };
	GType geary_rf_c822_preview_text_type_id;
	geary_rf_c822_preview_text_type_id = g_type_register_static (GEARY_RF_C822_TYPE_TEXT, "GearyRFC822PreviewText", &g_define_type_info, 0);
	return geary_rf_c822_preview_text_type_id;
}

GType
geary_rf_c822_preview_text_get_type (void)
{
	static gsize geary_rf_c822_preview_text_type_id__once = 0;
	if (g_once_init_enter (&geary_rf_c822_preview_text_type_id__once)) {
		GType geary_rf_c822_preview_text_type_id;
		geary_rf_c822_preview_text_type_id = geary_rf_c822_preview_text_get_type_once ();
		g_once_init_leave (&geary_rf_c822_preview_text_type_id__once, geary_rf_c822_preview_text_type_id);
	}
	return geary_rf_c822_preview_text_type_id__once;
}

GearyRFC822AuthenticationResults*
geary_rf_c822_authentication_results_construct (GType object_type,
                                                const gchar* value)
{
	GearyRFC822AuthenticationResults * self = NULL;
	g_return_val_if_fail (value != NULL, NULL);
	self = (GearyRFC822AuthenticationResults*) geary_message_data_string_message_data_construct (object_type, value);
	return self;
}

GearyRFC822AuthenticationResults*
geary_rf_c822_authentication_results_new (const gchar* value)
{
	return geary_rf_c822_authentication_results_construct (GEARY_RF_C822_TYPE_AUTHENTICATION_RESULTS, value);
}

/**
     * Returns the authentication result for dkim.
     */
static inline GRegex*
_thread_safe_regex_init (GRegex** re,
                         const gchar * pattern,
                         GRegexCompileFlags compile_flags)
{
	if (g_once_init_enter ((gsize*) re)) {
		GRegex* val = g_regex_new (pattern, compile_flags, 0, NULL);
		g_once_init_leave ((gsize*) re, (gsize) val);
	}
	return *re;
}

gboolean
geary_rf_c822_authentication_results_is_dkim_valid (GearyRFC822AuthenticationResults* self)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gboolean result;
	g_return_val_if_fail (GEARY_RF_C822_IS_AUTHENTICATION_RESULTS (self), FALSE);
	_tmp0_ = geary_message_data_string_message_data_get_value (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_MESSAGE_DATA_TYPE_STRING_MESSAGE_DATA, GearyMessageDataStringMessageData));
	_tmp1_ = _tmp0_;
	result = g_regex_match (_thread_safe_regex_init (&_tmp_regex_0, "^.*dkim=pass.*$", 0 | G_REGEX_CASELESS), _tmp1_, 0, NULL);
	return result;
}

/**
     * Returns the authentication result for dmarc.
     */
gboolean
geary_rf_c822_authentication_results_is_dmarc_valid (GearyRFC822AuthenticationResults* self)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gboolean result;
	g_return_val_if_fail (GEARY_RF_C822_IS_AUTHENTICATION_RESULTS (self), FALSE);
	_tmp0_ = geary_message_data_string_message_data_get_value (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_MESSAGE_DATA_TYPE_STRING_MESSAGE_DATA, GearyMessageDataStringMessageData));
	_tmp1_ = _tmp0_;
	result = g_regex_match (_thread_safe_regex_init (&_tmp_regex_1, "^.*dmarc=pass.*$", 0 | G_REGEX_CASELESS), _tmp1_, 0, NULL);
	return result;
}

static void
geary_rf_c822_authentication_results_class_init (GearyRFC822AuthenticationResultsClass * klass,
                                                 gpointer klass_data)
{
	geary_rf_c822_authentication_results_parent_class = g_type_class_peek_parent (klass);
}

static void
geary_rf_c822_authentication_results_instance_init (GearyRFC822AuthenticationResults * self,
                                                    gpointer klass)
{
}

 G_GNUC_NO_INLINE static GType
geary_rf_c822_authentication_results_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyRFC822AuthenticationResultsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_rf_c822_authentication_results_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyRFC822AuthenticationResults), 0, (GInstanceInitFunc) geary_rf_c822_authentication_results_instance_init, NULL };
	GType geary_rf_c822_authentication_results_type_id;
	geary_rf_c822_authentication_results_type_id = g_type_register_static (GEARY_MESSAGE_DATA_TYPE_STRING_MESSAGE_DATA, "GearyRFC822AuthenticationResults", &g_define_type_info, 0);
	return geary_rf_c822_authentication_results_type_id;
}

GType
geary_rf_c822_authentication_results_get_type (void)
{
	static gsize geary_rf_c822_authentication_results_type_id__once = 0;
	if (g_once_init_enter (&geary_rf_c822_authentication_results_type_id__once)) {
		GType geary_rf_c822_authentication_results_type_id;
		geary_rf_c822_authentication_results_type_id = geary_rf_c822_authentication_results_get_type_once ();
		g_once_init_leave (&geary_rf_c822_authentication_results_type_id__once, geary_rf_c822_authentication_results_type_id);
	}
	return geary_rf_c822_authentication_results_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

