/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.srtm;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import tim.prune.config.Config;
import tim.prune.function.srtm.SrtmAuthException;
import tim.prune.function.srtm.SrtmTile;

public abstract class SrtmSource {
    public static final int VOID_VAL = Short.MIN_VALUE;

    public abstract URL getUrl(SrtmTile var1);

    public abstract Result downloadTile(SrtmTile var1) throws SrtmAuthException;

    public abstract String getFilename(SrtmTile var1);

    public long getTileSizeBytes() {
        return (long)(this.getTilePixels() * this.getTilePixels()) * 2L;
    }

    public abstract int getTilePixels();

    public File getCacheDir() {
        String string = Config.getConfigString("prune.diskcache");
        if (string == null) {
            return null;
        }
        return new File(string, "srtm");
    }

    protected File getFileToWrite(URL uRL) {
        File file;
        File file2 = this.getCacheDir();
        if (file2 != null && file2.exists() && file2.isDirectory() && file2.canRead() && (!(file = new File(file2, new File(uRL.getFile()).getName())).exists() || !file.canRead() || file.length() <= 400L)) {
            return file;
        }
        return null;
    }

    protected boolean writeFileFromStream(URL uRL, InputStream inputStream) {
        FileOutputStream fileOutputStream = null;
        boolean bl = false;
        if (inputStream != null) {
            try {
                File file = this.getFileToWrite(uRL);
                if (file != null) {
                    int n;
                    byte[] byArray = new byte[512];
                    fileOutputStream = new FileOutputStream(file);
                    while ((n = inputStream.read(byArray)) != -1) {
                        fileOutputStream.write(byArray, 0, n);
                    }
                    bl = true;
                }
            }
            catch (IOException iOException) {
                System.err.println(String.valueOf(iOException.getClass().getName()) + " - " + iOException.getMessage());
            }
            try {
                fileOutputStream.close();
            }
            catch (Exception exception) {}
        }
        return bl;
    }

    public static enum Result {
        DOWNLOADED,
        NOTHING_TO_DO,
        DOWNLOAD_FAILED,
        CACHE_FAILED,
        NOT_ENABLED;

    }
}

