"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const env_replace_1 = require("./env-replace");
const ENV = {
    foo: 'foo_value',
    bar: 'bar_value',
};
test.each([
    ['-${foo}-${bar}', '-foo_value-bar_value'],
    ['\\${foo}', '${foo}'],
    ['\\${zoo}', '${zoo}'],
    ['\\\\${foo}', '\\foo_value'],
])('success %s => %s', (settingValue, expected) => {
    const actual = (0, env_replace_1.envReplace)(settingValue, ENV);
    expect(actual).toEqual(expected);
});
test('fail when the env variable is not found', () => {
    expect(() => (0, env_replace_1.envReplace)('${baz}', ENV)).toThrow(`Failed to replace env in config: \${baz}`);
});
//# sourceMappingURL=env-replace.spec.js.map