/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad;

import org.opensearch.action.ActionListener;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.ad.model.AnomalyDetector;
import org.opensearch.client.Client;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.ExistsQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.builder.SearchSourceBuilder;

public class ProfileUtil {
    private static SearchRequest createRealtimeInittedEverRequest(String detectorId, long enabledTime, String resultIndex) {
        BoolQueryBuilder filterQuery = new BoolQueryBuilder();
        filterQuery.filter((QueryBuilder)QueryBuilders.termQuery((String)"detector_id", (String)detectorId));
        filterQuery.filter((QueryBuilder)QueryBuilders.rangeQuery((String)"execution_end_time").gte((Object)enabledTime));
        filterQuery.filter((QueryBuilder)QueryBuilders.rangeQuery((String)"anomaly_score").gt((Object)0));
        ExistsQueryBuilder taskIdExistsFilter = QueryBuilders.existsQuery((String)"task_id");
        filterQuery.mustNot((QueryBuilder)taskIdExistsFilter);
        SearchSourceBuilder source = new SearchSourceBuilder().query((QueryBuilder)filterQuery).size(1);
        SearchRequest request = new SearchRequest(new String[]{".opendistro-anomaly-results"});
        request.source(source);
        if (resultIndex != null) {
            request.indices(new String[]{resultIndex});
        }
        return request;
    }

    public static void confirmDetectorRealtimeInitStatus(AnomalyDetector detector, long enabledTime, Client client, ActionListener<SearchResponse> listener) {
        SearchRequest searchLatestResult = ProfileUtil.createRealtimeInittedEverRequest(detector.getDetectorId(), enabledTime, detector.getResultIndex());
        client.search(searchLatestResult, listener);
    }
}

