/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.dataprocessor;

import java.util.Arrays;

public class SingleFeatureLinearUniformInterpolator {
    public double[] interpolate(double[] samples, int numInterpolants) {
        int numSamples = samples.length;
        double[] interpolants = new double[numInterpolants];
        if (numSamples == 0) {
            interpolants = new double[]{};
        } else if (numSamples == 1) {
            Arrays.fill(interpolants, samples[0]);
        } else {
            for (int interpolantIndex = 0; interpolantIndex < numInterpolants - 1; ++interpolantIndex) {
                double interpolant;
                double tGlobal = (double)interpolantIndex / ((double)numInterpolants - 1.0);
                double tInterval = tGlobal * ((double)numSamples - 1.0);
                int intervalIndex = (int)Math.floor(tInterval);
                double leftSample = samples[intervalIndex];
                double rightSample = samples[intervalIndex + 1];
                interpolants[interpolantIndex] = interpolant = (1.0 - (tInterval -= (double)intervalIndex)) * leftSample + tInterval * rightSample;
            }
            interpolants[numInterpolants - 1] = samples[numSamples - 1];
        }
        return interpolants;
    }
}

