/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2.impl;

import java.io.PrintWriter;
import java.util.Deque;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectState;
import org.apache.commons.pool2.TrackedUse;
import org.apache.commons.pool2.impl.CallStack;
import org.apache.commons.pool2.impl.CallStackUtils;
import org.apache.commons.pool2.impl.NoOpCallStack;

public class DefaultPooledObject<T>
implements PooledObject<T> {
    private final T object;
    private PooledObjectState state = PooledObjectState.IDLE;
    private final long createTimeMillis;
    private volatile long lastBorrowTimeMillis = this.createTimeMillis = System.currentTimeMillis();
    private volatile long lastUseTimeMillis = this.createTimeMillis;
    private volatile long lastReturnTimeMillis = this.createTimeMillis;
    private volatile boolean logAbandoned = false;
    private volatile CallStack borrowedBy = NoOpCallStack.INSTANCE;
    private volatile CallStack usedBy = NoOpCallStack.INSTANCE;
    private volatile long borrowedCount;

    public DefaultPooledObject(T object) {
        this.object = object;
    }

    @Override
    public synchronized boolean allocate() {
        if (this.state == PooledObjectState.IDLE) {
            this.state = PooledObjectState.ALLOCATED;
            this.lastUseTimeMillis = this.lastBorrowTimeMillis = System.currentTimeMillis();
            ++this.borrowedCount;
            if (this.logAbandoned) {
                this.borrowedBy.fillInStackTrace();
            }
            return true;
        }
        if (this.state == PooledObjectState.EVICTION) {
            this.state = PooledObjectState.EVICTION_RETURN_TO_HEAD;
        }
        return false;
    }

    @Override
    public int compareTo(PooledObject<T> other) {
        long lastActiveDiff = this.getLastReturnTime() - other.getLastReturnTime();
        if (lastActiveDiff == 0L) {
            return System.identityHashCode(this) - System.identityHashCode(other);
        }
        return (int)Math.min(Math.max(lastActiveDiff, Integer.MIN_VALUE), Integer.MAX_VALUE);
    }

    @Override
    public synchronized boolean deallocate() {
        if (this.state == PooledObjectState.ALLOCATED || this.state == PooledObjectState.RETURNING) {
            this.state = PooledObjectState.IDLE;
            this.lastReturnTimeMillis = System.currentTimeMillis();
            this.borrowedBy.clear();
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean endEvictionTest(Deque<PooledObject<T>> idleQueue) {
        if (this.state == PooledObjectState.EVICTION) {
            this.state = PooledObjectState.IDLE;
            return true;
        }
        if (this.state == PooledObjectState.EVICTION_RETURN_TO_HEAD) {
            this.state = PooledObjectState.IDLE;
            if (!idleQueue.offerFirst(this)) {
                // empty if block
            }
        }
        return false;
    }

    @Override
    public long getActiveTimeMillis() {
        long rTime = this.lastReturnTimeMillis;
        long bTime = this.lastBorrowTimeMillis;
        if (rTime > bTime) {
            return rTime - bTime;
        }
        return System.currentTimeMillis() - bTime;
    }

    @Override
    public long getBorrowedCount() {
        return this.borrowedCount;
    }

    @Override
    public long getCreateTime() {
        return this.createTimeMillis;
    }

    @Override
    public long getIdleTimeMillis() {
        long elapsed = System.currentTimeMillis() - this.lastReturnTimeMillis;
        return elapsed >= 0L ? elapsed : 0L;
    }

    @Override
    public long getLastBorrowTime() {
        return this.lastBorrowTimeMillis;
    }

    @Override
    public long getLastReturnTime() {
        return this.lastReturnTimeMillis;
    }

    @Override
    public long getLastUsedTime() {
        if (this.object instanceof TrackedUse) {
            return Math.max(((TrackedUse)this.object).getLastUsed(), this.lastUseTimeMillis);
        }
        return this.lastUseTimeMillis;
    }

    @Override
    public T getObject() {
        return this.object;
    }

    @Override
    public synchronized PooledObjectState getState() {
        return this.state;
    }

    @Override
    public synchronized void invalidate() {
        this.state = PooledObjectState.INVALID;
    }

    @Override
    public synchronized void markAbandoned() {
        this.state = PooledObjectState.ABANDONED;
    }

    @Override
    public synchronized void markReturning() {
        this.state = PooledObjectState.RETURNING;
    }

    @Override
    public void printStackTrace(PrintWriter writer) {
        boolean written = this.borrowedBy.printStackTrace(writer);
        if (written |= this.usedBy.printStackTrace(writer)) {
            writer.flush();
        }
    }

    @Override
    public void setLogAbandoned(boolean logAbandoned) {
        this.logAbandoned = logAbandoned;
    }

    @Override
    public void setRequireFullStackTrace(boolean requireFullStackTrace) {
        this.borrowedBy = CallStackUtils.newCallStack("'Pooled object created' yyyy-MM-dd HH:mm:ss Z 'by the following code has not been returned to the pool:'", true, requireFullStackTrace);
        this.usedBy = CallStackUtils.newCallStack("The last code to use this object was:", false, requireFullStackTrace);
    }

    @Override
    public synchronized boolean startEvictionTest() {
        if (this.state == PooledObjectState.IDLE) {
            this.state = PooledObjectState.EVICTION;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("Object: ");
        result.append(this.object.toString());
        result.append(", State: ");
        DefaultPooledObject defaultPooledObject = this;
        synchronized (defaultPooledObject) {
            result.append(this.state.toString());
        }
        return result.toString();
    }

    @Override
    public void use() {
        this.lastUseTimeMillis = System.currentTimeMillis();
        this.usedBy.fillInStackTrace();
    }
}

