/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.commons.alerting.model;

import com.cronutils.model.Cron;
import com.cronutils.model.time.ExecutionTime;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.commons.alerting.model.Schedule;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000 62\u00020\u0001:\u00016B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B!\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0016\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\bH\u00c6\u0003J\u000b\u0010\u0018\u001a\u0004\u0018\u00010\nH\u00c6\u0003J)\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nH\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u00d6\u0003J\u001c\u0010\u001e\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001f\u001a\u00020\n2\b\u0010 \u001a\u0004\u0018\u00010\nH\u0016J\u001e\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\"2\b\u0010#\u001a\u0004\u0018\u00010\nH\u0016J\u001e\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\"2\b\u0010%\u001a\u0004\u0018\u00010\nH\u0016J\t\u0010&\u001a\u00020'H\u00d6\u0001J\u0012\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010\u001f\u001a\u00020\nH\u0016J\u0012\u0010*\u001a\u00020\u001b2\b\u0010+\u001a\u0004\u0018\u00010\nH\u0016J\t\u0010,\u001a\u00020\u0006H\u00d6\u0001J\u0018\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020.2\u0006\u00100\u001a\u000201H\u0016J\u0010\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0016R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u00067"}, d2={"Lorg/opensearch/commons/alerting/model/CronSchedule;", "Lorg/opensearch/commons/alerting/model/Schedule;", "sin", "Lorg/opensearch/common/io/stream/StreamInput;", "(Lorg/opensearch/common/io/stream/StreamInput;)V", "expression", "", "timezone", "Ljava/time/ZoneId;", "testInstant", "Ljava/time/Instant;", "(Ljava/lang/String;Ljava/time/ZoneId;Ljava/time/Instant;)V", "executionTime", "Lcom/cronutils/model/time/ExecutionTime;", "getExecutionTime", "()Lcom/cronutils/model/time/ExecutionTime;", "getExpression", "()Ljava/lang/String;", "getTestInstant", "()Ljava/time/Instant;", "getTimezone", "()Ljava/time/ZoneId;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "getExpectedNextExecutionTime", "enabledTime", "expectedPreviousExecutionTime", "getPeriodEndingAt", "Lkotlin/Pair;", "endTime", "getPeriodStartingAt", "startTime", "hashCode", "", "nextTimeToExecute", "Ljava/time/Duration;", "runningOnTime", "lastExecutionTime", "toString", "toXContent", "Lorg/opensearch/common/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/common/xcontent/ToXContent$Params;", "writeTo", "", "out", "Lorg/opensearch/common/io/stream/StreamOutput;", "Companion", "common-utils"})
public final class CronSchedule
extends Schedule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String expression;
    @NotNull
    private final ZoneId timezone;
    @Nullable
    private final transient Instant testInstant;
    @NotNull
    private final transient ExecutionTime executionTime;

    public CronSchedule(@NotNull String expression, @NotNull ZoneId timezone, @Nullable Instant testInstant) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)timezone, (String)"timezone");
        super(null);
        this.expression = expression;
        this.timezone = timezone;
        this.testInstant = testInstant;
        ExecutionTime executionTime = ExecutionTime.forCron((Cron)Schedule.Companion.getCronParser().parse(this.expression));
        Intrinsics.checkNotNullExpressionValue((Object)executionTime, (String)"forCron(cronParser.parse(expression))");
        this.executionTime = executionTime;
    }

    public /* synthetic */ CronSchedule(String string, ZoneId zoneId, Instant instant, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            instant = null;
        }
        this(string, zoneId, instant);
    }

    @NotNull
    public final String getExpression() {
        return this.expression;
    }

    @NotNull
    public final ZoneId getTimezone() {
        return this.timezone;
    }

    @Nullable
    public final Instant getTestInstant() {
        return this.testInstant;
    }

    @NotNull
    public final ExecutionTime getExecutionTime() {
        return this.executionTime;
    }

    public CronSchedule(@NotNull StreamInput sin) throws IOException {
        Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
        Object object = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sin.readString()");
        String string = object;
        object = sin.readZoneId();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sin.readZoneId()");
        this(string, (ZoneId)object, null, 4, null);
    }

    @Override
    @Nullable
    public Duration nextTimeToExecute(@NotNull Instant enabledTime) {
        Intrinsics.checkNotNullParameter((Object)enabledTime, (String)"enabledTime");
        Instant instant = this.testInstant;
        if (instant == null) {
            instant = Instant.now();
        }
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(instant, this.timezone);
        Optional timeToNextExecution = this.executionTime.timeToNextExecution(zonedDateTime);
        return timeToNextExecution.orElse(null);
    }

    @Override
    @Nullable
    public Instant getExpectedNextExecutionTime(@NotNull Instant enabledTime, @Nullable Instant expectedPreviousExecutionTime) {
        Instant instant;
        Intrinsics.checkNotNullParameter((Object)enabledTime, (String)"enabledTime");
        Instant instant2 = expectedPreviousExecutionTime;
        if (instant2 == null) {
            instant2 = instant = this.testInstant;
        }
        if (instant2 == null) {
            instant = Instant.now();
        }
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(instant, this.timezone);
        Optional nextExecution = this.executionTime.nextExecution(zonedDateTime);
        ZonedDateTime zonedDateTime2 = nextExecution.orElse(null);
        return zonedDateTime2 == null ? null : zonedDateTime2.toInstant();
    }

    @Override
    @NotNull
    public Pair<Instant, Instant> getPeriodStartingAt(@Nullable Instant startTime) {
        Instant instant;
        ZonedDateTime newEndTime;
        Instant instant2;
        if (startTime != null) {
            instant2 = startTime;
        } else {
            Optional lastExecutionTime = this.executionTime.lastExecution(ZonedDateTime.now(this.timezone));
            if (!lastExecutionTime.isPresent()) {
                Instant currentTime = Instant.now();
                return new Pair((Object)currentTime, (Object)currentTime);
            }
            instant2 = ((ZonedDateTime)lastExecutionTime.get()).toInstant();
        }
        Instant realStartTime = instant2;
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(realStartTime, this.timezone);
        ZonedDateTime zonedDateTime2 = newEndTime = (ZonedDateTime)this.executionTime.nextExecution(zonedDateTime).orElse(null);
        if (zonedDateTime2 == null) {
            instant = realStartTime;
        } else {
            instant = zonedDateTime2.toInstant();
            if (instant == null) {
                instant = realStartTime;
            }
        }
        return new Pair((Object)realStartTime, (Object)instant);
    }

    @Override
    @NotNull
    public Pair<Instant, Instant> getPeriodEndingAt(@Nullable Instant endTime) {
        Instant instant;
        ZonedDateTime newStartTime;
        Instant instant2;
        if (endTime != null) {
            instant2 = endTime;
        } else {
            Optional nextExecutionTime = this.executionTime.nextExecution(ZonedDateTime.now(this.timezone));
            if (!nextExecutionTime.isPresent()) {
                Instant currentTime = Instant.now();
                return new Pair((Object)currentTime, (Object)currentTime);
            }
            instant2 = ((ZonedDateTime)nextExecutionTime.get()).toInstant();
        }
        Instant realEndTime = instant2;
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(realEndTime, this.timezone);
        ZonedDateTime zonedDateTime2 = newStartTime = (ZonedDateTime)this.executionTime.lastExecution(zonedDateTime).orElse(null);
        if (zonedDateTime2 == null) {
            instant = realEndTime;
        } else {
            instant = zonedDateTime2.toInstant();
            if (instant == null) {
                instant = realEndTime;
            }
        }
        return new Pair((Object)instant, (Object)realEndTime);
    }

    @Override
    public boolean runningOnTime(@Nullable Instant lastExecutionTime) {
        ZonedDateTime zonedDateTime;
        Optional expectedExecutionTime;
        if (lastExecutionTime == null) {
            return true;
        }
        Instant instant = this.testInstant;
        if (instant == null) {
            instant = Instant.now();
        }
        if (!(expectedExecutionTime = this.executionTime.lastExecution(zonedDateTime = ZonedDateTime.ofInstant(instant, this.timezone))).isPresent()) {
            return false;
        }
        ZonedDateTime actualExecutionTime = ZonedDateTime.ofInstant(lastExecutionTime, this.timezone);
        return ChronoUnit.SECONDS.between((Temporal)expectedExecutionTime.get(), actualExecutionTime) == 0L;
    }

    @NotNull
    public XContentBuilder toXContent(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        builder.startObject().startObject("cron").field("expression", this.expression).field("timezone", this.timezone.getId()).endObject().endObject();
        return builder;
    }

    public void writeTo(@NotNull StreamOutput out) throws IOException {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeString(this.expression);
        out.writeZoneId(this.timezone);
    }

    @NotNull
    public final String component1() {
        return this.expression;
    }

    @NotNull
    public final ZoneId component2() {
        return this.timezone;
    }

    @Nullable
    public final Instant component3() {
        return this.testInstant;
    }

    @NotNull
    public final CronSchedule copy(@NotNull String expression, @NotNull ZoneId timezone, @Nullable Instant testInstant) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)timezone, (String)"timezone");
        return new CronSchedule(expression, timezone, testInstant);
    }

    public static /* synthetic */ CronSchedule copy$default(CronSchedule cronSchedule, String string, ZoneId zoneId, Instant instant, int n, Object object) {
        if ((n & 1) != 0) {
            string = cronSchedule.expression;
        }
        if ((n & 2) != 0) {
            zoneId = cronSchedule.timezone;
        }
        if ((n & 4) != 0) {
            instant = cronSchedule.testInstant;
        }
        return cronSchedule.copy(string, zoneId, instant);
    }

    @NotNull
    public String toString() {
        return "CronSchedule(expression=" + this.expression + ", timezone=" + this.timezone + ", testInstant=" + this.testInstant + ")";
    }

    public int hashCode() {
        int result = this.expression.hashCode();
        result = result * 31 + this.timezone.hashCode();
        result = result * 31 + (this.testInstant == null ? 0 : this.testInstant.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CronSchedule)) {
            return false;
        }
        CronSchedule cronSchedule = (CronSchedule)other;
        if (!Intrinsics.areEqual((Object)this.expression, (Object)cronSchedule.expression)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.timezone, (Object)cronSchedule.timezone)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.testInstant, (Object)cronSchedule.testInstant);
    }

    @JvmStatic
    @NotNull
    public static final CronSchedule readFrom(@NotNull StreamInput sin) throws IOException {
        return Companion.readFrom(sin);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lorg/opensearch/commons/alerting/model/CronSchedule$Companion;", "", "()V", "readFrom", "Lorg/opensearch/commons/alerting/model/CronSchedule;", "sin", "Lorg/opensearch/common/io/stream/StreamInput;", "common-utils"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final CronSchedule readFrom(@NotNull StreamInput sin) throws IOException {
            Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
            return new CronSchedule(sin);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

