/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.commons.alerting.util;

import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.common.bytes.BytesReference;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentLocation;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentParserUtils;
import org.opensearch.commons.alerting.model.Monitor;
import org.opensearch.commons.authuser.User;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\f\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0004*\u00020\u0005\u001a\u001c\u0010\u0006\u001a\u00020\u0007*\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\u0000\u001a\u0004\u0018\u00010\u0001\u001a\u001c\u0010\n\u001a\u00020\u0007*\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u001a\n\u0010\r\u001a\u00020\t*\u00020\u0007\u00a8\u0006\u000e"}, d2={"instant", "Ljava/time/Instant;", "Lorg/opensearch/common/xcontent/XContentParser;", "isBucketLevelMonitor", "", "Lorg/opensearch/commons/alerting/model/Monitor;", "optionalTimeField", "Lorg/opensearch/common/xcontent/XContentBuilder;", "name", "", "optionalUserField", "user", "Lorg/opensearch/commons/authuser/User;", "string", "common-utils"})
public final class IndexUtilsKt {
    public static final boolean isBucketLevelMonitor(@NotNull Monitor $this$isBucketLevelMonitor) {
        Intrinsics.checkNotNullParameter((Object)$this$isBucketLevelMonitor, (String)"<this>");
        return $this$isBucketLevelMonitor.getMonitorType() == Monitor.MonitorType.BUCKET_LEVEL_MONITOR;
    }

    @NotNull
    public static final XContentBuilder optionalUserField(@NotNull XContentBuilder $this$optionalUserField, @NotNull String name, @Nullable User user) {
        Intrinsics.checkNotNullParameter((Object)$this$optionalUserField, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (user == null) {
            XContentBuilder xContentBuilder = $this$optionalUserField.nullField(name);
            Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"nullField(name)");
            return xContentBuilder;
        }
        XContentBuilder xContentBuilder = $this$optionalUserField.field(name, (ToXContent)user);
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"this.field(name, user)");
        return xContentBuilder;
    }

    @NotNull
    public static final XContentBuilder optionalTimeField(@NotNull XContentBuilder $this$optionalTimeField, @NotNull String name, @Nullable Instant instant) {
        Intrinsics.checkNotNullParameter((Object)$this$optionalTimeField, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (instant == null) {
            XContentBuilder xContentBuilder = $this$optionalTimeField.nullField(name);
            Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"nullField(name)");
            return xContentBuilder;
        }
        XContentBuilder xContentBuilder = $this$optionalTimeField.timeField(name, name + "_in_millis", instant.toEpochMilli());
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"this.timeField(name, \"${\u2026, instant.toEpochMilli())");
        return xContentBuilder;
    }

    @Nullable
    public static final Instant instant(@NotNull XContentParser $this$instant) {
        Instant instant;
        Intrinsics.checkNotNullParameter((Object)$this$instant, (String)"<this>");
        if ($this$instant.currentToken() == XContentParser.Token.VALUE_NULL) {
            instant = null;
        } else if ($this$instant.currentToken().isValue()) {
            instant = Instant.ofEpochMilli($this$instant.longValue());
        } else {
            XContentParserUtils.throwUnknownToken((XContentParser.Token)$this$instant.currentToken(), (XContentLocation)$this$instant.getTokenLocation());
            instant = null;
        }
        return instant;
    }

    @NotNull
    public static final String string(@NotNull XContentBuilder $this$string) {
        Intrinsics.checkNotNullParameter((Object)$this$string, (String)"<this>");
        String string = BytesReference.bytes((XContentBuilder)$this$string).utf8ToString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"bytes(this).utf8ToString()");
        return string;
    }
}

