/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.asynchronous.listener;

import java.util.ArrayList;
import java.util.List;
import org.opensearch.action.ActionListener;
import org.opensearch.search.asynchronous.listener.PrioritizedActionListener;

public class CompositeSearchProgressActionListener<T>
implements ActionListener<T> {
    private final List<ActionListener<T>> actionListeners = new ArrayList<ActionListener<T>>(1);
    private volatile boolean complete;

    CompositeSearchProgressActionListener() {
    }

    public void addOrExecuteListener(PrioritizedActionListener<T> listener) {
        if (!this.addListener(listener)) {
            listener.executeImmediately();
        }
    }

    public synchronized void removeListener(ActionListener<T> listener) {
        this.actionListeners.remove(listener);
    }

    private synchronized boolean addListener(ActionListener<T> listener) {
        if (!this.complete) {
            this.actionListeners.add(listener);
            return true;
        }
        return false;
    }

    public void onResponse(T response) {
        Iterable<ActionListener<T>> actionListenersToBeInvoked = this.finalizeListeners();
        if (actionListenersToBeInvoked != null) {
            ActionListener.onResponse(actionListenersToBeInvoked, response);
        }
    }

    public void onFailure(Exception exception) {
        Iterable<ActionListener<T>> actionListenersToBeInvoked = this.finalizeListeners();
        if (actionListenersToBeInvoked != null) {
            ActionListener.onFailure(actionListenersToBeInvoked, (Exception)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterable<ActionListener<T>> finalizeListeners() {
        ArrayList<ActionListener<T>> actionListenersToBeInvoked = null;
        CompositeSearchProgressActionListener compositeSearchProgressActionListener = this;
        synchronized (compositeSearchProgressActionListener) {
            if (!this.complete) {
                actionListenersToBeInvoked = new ArrayList<ActionListener<T>>(this.actionListeners);
                this.actionListeners.clear();
                this.complete = true;
            }
        }
        return actionListenersToBeInvoked;
    }
}

