"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.apiCallerMock = void 0;
Object.defineProperty(exports, "browserServicesMock", {
  enumerable: true,
  get: function () {
    return _browserServicesMock.default;
  }
});
Object.defineProperty(exports, "coreServicesMock", {
  enumerable: true,
  get: function () {
    return _coreServicesMock.default;
  }
});
Object.defineProperty(exports, "historyMock", {
  enumerable: true,
  get: function () {
    return _historyMock.default;
  }
});
Object.defineProperty(exports, "httpClientMock", {
  enumerable: true,
  get: function () {
    return _httpClientMock.default;
  }
});
Object.defineProperty(exports, "styleMock", {
  enumerable: true,
  get: function () {
    return _styleMock.default;
  }
});

var _browserServicesMock = _interopRequireDefault(require("./browserServicesMock"));

var _historyMock = _interopRequireDefault(require("./historyMock"));

var _httpClientMock = _interopRequireDefault(require("./httpClientMock"));

var _styleMock = _interopRequireDefault(require("./styleMock"));

var _coreServicesMock = _interopRequireDefault(require("./coreServicesMock"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
const apiCallerMock = browserServicesMockObject => {
  browserServicesMockObject.commonService.apiCaller = jest.fn(async payload => {
    var _payload$data4, _payload$data5, _payload$data6;

    switch (payload.endpoint) {
      case "transport.request":
        {
          var _payload$data, _payload$data$path, _payload$data2, _payload$data2$path, _payload$data3, _payload$data3$path;

          if ((_payload$data = payload.data) !== null && _payload$data !== void 0 && (_payload$data$path = _payload$data.path) !== null && _payload$data$path !== void 0 && _payload$data$path.startsWith("/_index_template/_simulate_index/bad_index")) {
            return {
              ok: true,
              response: {}
            };
          } else if ((_payload$data2 = payload.data) !== null && _payload$data2 !== void 0 && (_payload$data2$path = _payload$data2.path) !== null && _payload$data2$path !== void 0 && _payload$data2$path.startsWith("_index_template/bad_template")) {
            return {
              ok: false,
              error: "bad template"
            };
          } else if ((_payload$data3 = payload.data) !== null && _payload$data3 !== void 0 && (_payload$data3$path = _payload$data3.path) !== null && _payload$data3$path !== void 0 && _payload$data3$path.startsWith("_index_template/good_template")) {
            return {
              ok: true,
              response: {
                index_templates: [{
                  name: "good_template",
                  index_template: {}
                }]
              }
            };
          } else {
            return {
              ok: true,
              response: {
                template: {
                  settings: {
                    index: {
                      number_of_replicas: "10",
                      number_of_shards: "1"
                    }
                  }
                }
              }
            };
          }
        }

      case "indices.create":
        if (((_payload$data4 = payload.data) === null || _payload$data4 === void 0 ? void 0 : _payload$data4.index) === "bad_index") {
          return {
            ok: false,
            error: "bad_index"
          };
        }

        return {
          ok: true,
          response: {}
        };
        break;

      case "cat.aliases":
        return {
          ok: true,
          response: [{
            alias: ".kibana",
            index: ".kibana_1",
            filter: "-",
            is_write_index: "-"
          }, {
            alias: "2",
            index: "1234",
            filter: "-",
            is_write_index: "-"
          }]
        };

      case "indices.get":
        const payloadIndex = (_payload$data5 = payload.data) === null || _payload$data5 === void 0 ? void 0 : _payload$data5.index;

        if (payloadIndex === "bad_index") {
          return {
            ok: false,
            error: "bad_error",
            response: {}
          };
        }

        return {
          ok: true,
          response: {
            [(_payload$data6 = payload.data) === null || _payload$data6 === void 0 ? void 0 : _payload$data6.index]: {
              aliases: {
                update_test_1: {}
              },
              mappings: {
                properties: {
                  test_mapping_1: {
                    type: "text"
                  }
                }
              },
              settings: {
                "index.number_of_shards": "1",
                "index.number_of_replicas": "1"
              }
            }
          }
        };
    }

    return {
      ok: true,
      response: {}
    };
  });
};

exports.apiCallerMock = apiCallerMock;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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