"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createDemoPanel = void 0;

var _uuid = require("uuid");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
const createDemoPanel = savedVisualizationIds => {
  return {
    name: '[Logs] Web traffic Panel',
    visualizations: [{
      id: 'panel_viz_' + (0, _uuid.v4)(),
      savedVisualizationId: savedVisualizationIds[0],
      x: 4,
      y: 6,
      w: 8,
      h: 2
    }, {
      id: 'panel_viz_' + (0, _uuid.v4)(),
      savedVisualizationId: savedVisualizationIds[1],
      x: 0,
      y: 2,
      w: 12,
      h: 2
    }, {
      id: 'panel_viz_' + (0, _uuid.v4)(),
      savedVisualizationId: savedVisualizationIds[2],
      x: 0,
      y: 0,
      w: 4,
      h: 2
    }, {
      id: 'panel_viz_' + (0, _uuid.v4)(),
      savedVisualizationId: savedVisualizationIds[3],
      x: 4,
      y: 0,
      w: 4,
      h: 2
    }, {
      id: 'panel_viz_' + (0, _uuid.v4)(),
      savedVisualizationId: savedVisualizationIds[4],
      x: 8,
      y: 0,
      w: 4,
      h: 2
    }, {
      id: 'panel_viz_' + (0, _uuid.v4)(),
      savedVisualizationId: savedVisualizationIds[5],
      x: 0,
      y: 4,
      w: 4,
      h: 2
    }, {
      id: 'panel_viz_' + (0, _uuid.v4)(),
      savedVisualizationId: savedVisualizationIds[6],
      x: 0,
      y: 6,
      w: 4,
      h: 2
    }, {
      id: 'panel_viz_' + (0, _uuid.v4)(),
      savedVisualizationId: savedVisualizationIds[7],
      x: 4,
      y: 4,
      w: 8,
      h: 2
    }],
    timeRange: {
      to: 'now/y',
      from: 'now/y'
    },
    queryFilter: {
      query: '',
      language: 'ppl'
    }
  };
};

exports.createDemoPanel = createDemoPanel;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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