/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.geospatial.index.query.xyshape;

import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.Query;
import org.opensearch.common.geo.parsers.ShapeParser;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.geometry.Geometry;
import org.opensearch.geospatial.index.mapper.xyshape.XYShapeQueryable;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.query.AbstractGeometryQueryBuilder;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.index.query.QueryShardException;

public class XYShapeQueryBuilder
extends AbstractGeometryQueryBuilder<XYShapeQueryBuilder> {
    public static final String NAME = "xy_shape";

    public XYShapeQueryBuilder(String fieldName, Geometry geometry) {
        super(fieldName, geometry);
    }

    public XYShapeQueryBuilder(String fieldName, String indexedShapeID) {
        super(fieldName, indexedShapeID);
    }

    public XYShapeQueryBuilder(StreamInput in) throws IOException {
        super(in);
    }

    private XYShapeQueryBuilder(String fieldName, Supplier<Geometry> supplier, String docID) {
        super(fieldName, supplier, docID);
    }

    protected Query buildShapeQuery(QueryShardContext context, MappedFieldType fieldType) {
        if (fieldType instanceof XYShapeQueryable) {
            XYShapeQueryable query = (XYShapeQueryable)fieldType;
            return new ConstantScoreQuery(query.shapeQuery(this.shape, this.fieldName, this.relation, context));
        }
        throw new QueryShardException(context, String.format(Locale.getDefault(), "Field [%s] is of unsupported type [%s] for [%s] query", this.fieldName, fieldType.typeName(), NAME), new Object[0]);
    }

    protected void doShapeQueryXContent(XContentBuilder xContentBuilder, ToXContent.Params params) {
    }

    protected XYShapeQueryBuilder newShapeQueryBuilder(String fieldName, Geometry geometry) {
        return new XYShapeQueryBuilder(fieldName, geometry);
    }

    protected XYShapeQueryBuilder newShapeQueryBuilder(String fieldName, Supplier<Geometry> supplier, String docID) {
        return new XYShapeQueryBuilder(fieldName, supplier, docID);
    }

    public String getWriteableName() {
        return NAME;
    }

    public static XYShapeQueryBuilder fromXContent(XContentParser parser) throws IOException {
        ParsedXYShapeQueryParams params = (ParsedXYShapeQueryParams)AbstractGeometryQueryBuilder.parsedParamsFromXContent((XContentParser)parser, (AbstractGeometryQueryBuilder.ParsedGeometryQueryParams)new ParsedXYShapeQueryParams());
        XYShapeQueryBuilder builder = XYShapeQueryBuilder.createXYShapeQueryBuilder(params);
        if (Objects.nonNull(params.index)) {
            builder.indexedShapeIndex(params.index);
        }
        if (Objects.nonNull(params.shapePath)) {
            builder.indexedShapePath(params.shapePath);
        }
        if (Objects.nonNull(params.shapeRouting)) {
            builder.indexedShapeRouting(params.shapeRouting);
        }
        if (Objects.nonNull(params.relation)) {
            builder.relation(params.relation);
        }
        if (Objects.nonNull(params.queryName)) {
            builder.queryName(params.queryName);
        }
        builder.boost(params.boost);
        builder.ignoreUnmapped(params.ignoreUnmapped);
        return builder;
    }

    private static XYShapeQueryBuilder createXYShapeQueryBuilder(ParsedXYShapeQueryParams params) {
        if (Objects.nonNull(params.shape)) {
            Geometry geometry = params.shape.buildGeometry();
            return new XYShapeQueryBuilder(params.fieldName, geometry);
        }
        return new XYShapeQueryBuilder(params.fieldName, params.id);
    }

    private static class ParsedXYShapeQueryParams
    extends AbstractGeometryQueryBuilder.ParsedGeometryQueryParams {
        private ParsedXYShapeQueryParams() {
        }

        protected boolean parseXContentField(XContentParser parser) throws IOException {
            if (SHAPE_FIELD.match(parser.currentName(), parser.getDeprecationHandler())) {
                this.shape = ShapeParser.parse((XContentParser)parser);
                return true;
            }
            return false;
        }
    }
}

