/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SkinParamDelegator;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class SkinParamColors
extends SkinParamDelegator {
    private final Colors colors;

    public final Colors getColors() {
        return this.colors;
    }

    public SkinParamColors(ISkinParam skinParam, Colors colors) {
        super(skinParam);
        this.colors = colors;
    }

    public String toString() {
        return "SkinParamColors::" + this.colors;
    }

    @Override
    public boolean shadowing(Stereotype stereotype) {
        if (this.colors.getShadowing() == null) {
            return super.shadowing(stereotype);
        }
        return this.colors.getShadowing();
    }

    @Override
    public HColor getFontHtmlColor(Stereotype stereotype, FontParam ... param) {
        HColor value = this.colors.getColor(ColorType.TEXT);
        if (value == null) {
            return super.getFontHtmlColor(stereotype, param);
        }
        return value;
    }

    @Override
    public HColor getHtmlColor(ColorParam param, Stereotype stereotype, boolean clickable) {
        ColorType type = param.getColorType();
        if (type == null) {
            return super.getHtmlColor(param, stereotype, clickable);
        }
        HColor value = this.colors.getColor(type);
        if (value != null) {
            return value;
        }
        assert (value == null);
        return super.getHtmlColor(param, stereotype, clickable);
    }
}

