info = {
    "name": "sq",
    "date_order": "DMY",
    "january": [
        "jan",
        "janar"
    ],
    "february": [
        "shk",
        "shkurt"
    ],
    "march": [
        "mar",
        "mars"
    ],
    "april": [
        "pri",
        "prill"
    ],
    "may": [
        "maj"
    ],
    "june": [
        "qer",
        "qershor"
    ],
    "july": [
        "kor",
        "korrik"
    ],
    "august": [
        "gsh",
        "gusht"
    ],
    "september": [
        "sht",
        "shtator"
    ],
    "october": [
        "tet",
        "tetor"
    ],
    "november": [
        "nën",
        "nëntor"
    ],
    "december": [
        "dhj",
        "dhjetor"
    ],
    "monday": [
        "e hënë",
        "hën"
    ],
    "tuesday": [
        "e martë",
        "mar"
    ],
    "wednesday": [
        "e mërkurë",
        "mër"
    ],
    "thursday": [
        "e enjte",
        "enj"
    ],
    "friday": [
        "e premte",
        "pre"
    ],
    "saturday": [
        "e shtunë",
        "sht"
    ],
    "sunday": [
        "die",
        "e diel"
    ],
    "am": [
        "e paradites",
        "paradite"
    ],
    "pm": [
        "e pasdites",
        "pasdite"
    ],
    "year": [
        "vit"
    ],
    "month": [
        "muaj"
    ],
    "week": [
        "javë"
    ],
    "day": [
        "ditë"
    ],
    "hour": [
        "orë"
    ],
    "minute": [
        "min",
        "minutë"
    ],
    "second": [
        "sek",
        "sekondë"
    ],
    "relative-type": {
        "0 day ago": [
            "sot"
        ],
        "0 hour ago": [
            "këtë orë"
        ],
        "0 minute ago": [
            "këtë minutë"
        ],
        "0 month ago": [
            "këtë muaj"
        ],
        "0 second ago": [
            "tani"
        ],
        "0 week ago": [
            "këtë javë"
        ],
        "0 year ago": [
            "këtë vit"
        ],
        "1 day ago": [
            "dje"
        ],
        "1 month ago": [
            "muajin e kaluar"
        ],
        "1 week ago": [
            "javën e kaluar"
        ],
        "1 year ago": [
            "vitin e kaluar"
        ],
        "in 1 day": [
            "nesër"
        ],
        "in 1 month": [
            "muajin e ardhshëm"
        ],
        "in 1 week": [
            "javën e ardhshme"
        ],
        "in 1 year": [
            "vitin e ardhshëm"
        ]
    },
    "relative-type-regex": {
        "\\1 day ago": [
            "(\\d+) ditë më parë"
        ],
        "\\1 hour ago": [
            "(\\d+) orë më parë"
        ],
        "\\1 minute ago": [
            "(\\d+) min më parë",
            "(\\d+) minuta më parë",
            "(\\d+) minutë më parë"
        ],
        "\\1 month ago": [
            "(\\d+) muaj më parë"
        ],
        "\\1 second ago": [
            "(\\d+) sek më parë",
            "(\\d+) sekonda më parë",
            "(\\d+) sekondë më parë"
        ],
        "\\1 week ago": [
            "(\\d+) javë më parë"
        ],
        "\\1 year ago": [
            "(\\d+) vit më parë",
            "(\\d+) vjet më parë"
        ],
        "in \\1 day": [
            "pas (\\d+) dite",
            "pas (\\d+) ditësh"
        ],
        "in \\1 hour": [
            "pas (\\d+) ore",
            "pas (\\d+) orësh"
        ],
        "in \\1 minute": [
            "pas (\\d+) min",
            "pas (\\d+) minutash",
            "pas (\\d+) minute"
        ],
        "in \\1 month": [
            "pas (\\d+) muaji",
            "pas (\\d+) muajsh"
        ],
        "in \\1 second": [
            "pas (\\d+) sek",
            "pas (\\d+) sekondash",
            "pas (\\d+) sekonde"
        ],
        "in \\1 week": [
            "pas (\\d+) jave",
            "pas (\\d+) javësh"
        ],
        "in \\1 year": [
            "pas (\\d+) viti",
            "pas (\\d+) vjetësh"
        ]
    },
    "locale_specific": {
        "sq-MK": {
            "name": "sq-MK"
        },
        "sq-XK": {
            "name": "sq-XK"
        }
    },
    "skip": [
        " ",
        "'",
        ",",
        "-",
        ".",
        "/",
        ";",
        "@",
        "[",
        "]",
        "|",
        "，"
    ]
}
