#ifndef R2_CONFIGURE_H
#define R2_CONFIGURE_H

#ifdef __cplusplus
extern "C" {
#endif

#include "r_version.h"

#define R_CHECKS_LEVEL 2
#define R_CRITICAL_ENABLED 0
#define DEBUGGER 1
#define HAVE_DECL_ADDR_NO_RANDOMIZE 1
#define HAVE_ARC4RANDOM_UNIFORM 0
#define HAVE_EXPLICIT_BZERO 1
#define HAVE_EXPLICIT_MEMSET 0
#define HAVE_CLOCK_NANOSLEEP 1
#define HAVE_SIGACTION 1
#define WANT_THREADS 0
#define WANT_CAPSTONE 1

#define WITH_STATIC_THEMES 0

#define HAVE_GPERF 0
#if (HAVE_GPERF) == 1
#define HAVE_GPERF 0
#else
#define HAVE_GPERF 0
#endif

#ifdef R_MESON_VERSION
#define R2_PREFIX "/usr"
#define R2_ETCDIR "/usr/etc"
#define R2_LIBDIR "/usr/lib"
#define R2_INCDIR "/usr/include/libr"
#define R2_DATDIR "/usr/share"
#define R2_WWWROOT "/usr/share/radare2/5.8.2/www"
#define R2_PLUGINS "lib/radare2/5.8.2"
#define R2_EXTRAS "lib/radare2-extras/5.8.2"
#define R2_BINDINGS "lib/radare2-bindings/5.8.2"
#define R2_DATDIR_R2 "share/radare2"
#define R2_SDB "share/radare2/5.8.2"
#define R2_ZIGNS "share/radare2/5.8.2/zigns"
#define R2_THEMES "share/radare2/5.8.2/cons"
#define R2_FORTUNES R_JOIN_3_PATHS ("/usr/share", "doc", "radare2")
#define R2_FLAGS "share/radare2/5.8.2/flag"
#define R2_HUD "share/radare2/5.8.2/hud"
#else
#if R2__WINDOWS__ || _MSC_VER
#define R2_PREFIX "."
#define R2_ETCDIR "etc"
#define R2_LIBDIR "lib"
#define R2_INCDIR "include\\libr"
#define R2_DATDIR "share"
#define R2_WWWROOT "www"
#define R2_PLUGINS "lib\\plugins"
#define R2_EXTRAS "lib\\extras"
#define R2_BINDINGS "lib\\bindings"
#else
#define R2_PREFIX "/usr"
#define R2_ETCDIR "/usr/etc"
#define R2_LIBDIR "/usr/lib"
#define R2_INCDIR "/usr/include/libr/libr"
#define R2_DATDIR "/usr/share"
#define R2_WWWROOT R2_DATDIR "/radare2/" R2_VERSION "/www"
#define R2_PLUGINS "lib/radare2/" R2_VERSION
#define R2_EXTRAS "lib/radare2-extras/" R2_VERSION
#define R2_BINDINGS "lib/radare2-bindings/" R2_VERSION
#endif
#define R2_DATDIR_R2        R_JOIN_2_PATHS ("share", "radare2")
#define R2_SDB              R_JOIN_3_PATHS ("share", "radare2", R2_VERSION)
#define R2_ZIGNS            R_JOIN_4_PATHS ("share", "radare2", R2_VERSION, "zigns")
#define R2_THEMES           R_JOIN_4_PATHS ("share", "radare2", R2_VERSION, "cons")
#define R2_FLAGS            R_JOIN_4_PATHS ("share", "radare2", R2_VERSION, "flag")
#define R2_FORTUNES         R_JOIN_3_PATHS ("share", "doc", "radare2")
#define R2_HUD              R_JOIN_4_PATHS ("share", "radare2", R2_VERSION, "hud")
#endif

#define R2_SDB_FCNSIGN      R_JOIN_2_PATHS (R2_SDB, "fcnsign")
#define R2_SDB_OPCODES      R_JOIN_2_PATHS (R2_SDB, "opcodes")
#define R2_SDB_MAGIC        R_JOIN_2_PATHS (R2_SDB, "magic")
#define R2_SDB_FORMAT       R_JOIN_2_PATHS (R2_SDB, "format")

#define R2_GLOBAL_RC        R_JOIN_2_PATHS (R2_DATDIR_R2, "radare2rc")

#define HAVE_LIB_MAGIC 1
#define USE_LIB_MAGIC 1
#define HAVE_LIB_XXHASH 1
#define USE_LIB_XXHASH 1

#ifndef HAVE_LIB_SSL
#define HAVE_LIB_SSL 0
#endif

#ifndef WANT_SSL_CRYPTO
#define WANT_SSL_CRYPTO 0
#endif

#define HAVE_LIBUV 1

#if __MINGW32__
#define HAVE_PTRACE 0
#else
#define HAVE_PTRACE 1
#endif

#define USE_PTRACE_WRAP 1
#define HAVE_FORK 1
#define WANT_DYLINK 1
#define WITH_GPL 1

#if __APPLE__ && __POWERPC__
#define HAVE_JEMALLOC 0
#else
#define HAVE_JEMALLOC 1
#endif

#ifdef __cplusplus
}
#endif

#endif
