_ruff() {
    local i cur prev opts cmd
    COMPREPLY=()
    cur="${COMP_WORDS[COMP_CWORD]}"
    prev="${COMP_WORDS[COMP_CWORD-1]}"
    cmd=""
    opts=""

    for i in ${COMP_WORDS[@]}
    do
        case "${cmd},${i}" in
            ",$1")
                cmd="ruff"
                ;;
            ruff,check)
                cmd="ruff__check"
                ;;
            ruff,clean)
                cmd="ruff__clean"
                ;;
            ruff,config)
                cmd="ruff__config"
                ;;
            ruff,generate-shell-completion)
                cmd="ruff__generate__shell__completion"
                ;;
            ruff,help)
                cmd="ruff__help"
                ;;
            ruff,linter)
                cmd="ruff__linter"
                ;;
            ruff,rule)
                cmd="ruff__rule"
                ;;
            ruff__help,check)
                cmd="ruff__help__check"
                ;;
            ruff__help,clean)
                cmd="ruff__help__clean"
                ;;
            ruff__help,config)
                cmd="ruff__help__config"
                ;;
            ruff__help,generate-shell-completion)
                cmd="ruff__help__generate__shell__completion"
                ;;
            ruff__help,help)
                cmd="ruff__help__help"
                ;;
            ruff__help,linter)
                cmd="ruff__help__linter"
                ;;
            ruff__help,rule)
                cmd="ruff__help__rule"
                ;;
            *)
                ;;
        esac
    done

    case "${cmd}" in
        ruff)
            opts="-v -q -s -h -V --verbose --quiet --silent --help --version check rule config linter clean generate-shell-completion help"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 1 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        ruff__check)
            opts="-w -n -e -v -q -s -h --fix --no-fix --show-source --no-show-source --show-fixes --no-show-fixes --diff --watch --fix-only --no-fix-only --format --target-version --config --select --ignore --extend-select --extend-ignore --per-file-ignores --exclude --extend-exclude --fixable --unfixable --respect-gitignore --no-respect-gitignore --force-exclude --no-force-exclude --line-length --dummy-variable-rgx --no-cache --isolated --cache-dir --stdin-filename --exit-zero --exit-non-zero-on-fix --update-check --no-update-check --statistics --add-noqa --show-files --show-settings --verbose --quiet --silent --help [FILES]..."
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 2 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --format)
                    COMPREPLY=($(compgen -W "text json junit grouped github gitlab pylint" -- "${cur}"))
                    return 0
                    ;;
                --target-version)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --config)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --select)
                    COMPREPLY=($(compgen -W "ALL F C90 I N D UP YTT ANN S BLE FBT B A COM C4 DTZ T10 DJ EM EXE ISC ICN G INP PIE T20 PYI PT Q RSE RET SLF SIM TID TCH ARG PTH ERA PD PGH PL TRY NPY RUF ERA00 ERA001 ERA0 YTT2 YTT301 YTT302 YTT204 YTT1 YTT10 YTT30 YTT201 YTT3 YTT303 YTT20 YTT202 YTT103 YTT203 YTT102 YTT101 ANN102 ANN206 ANN00 ANN10 ANN001 ANN003 ANN1 ANN201 ANN40 ANN2 ANN101 ANN4 ANN0 ANN202 ANN205 ANN401 ANN20 ANN002 ANN204 S324 S104 S509 S608 S113 S110 S508 S10 S32 S112 S701 S61 S102 S6 S70 S5 S3 S1 S60 S7 S105 S101 S103 S501 S106 S506 S612 S107 S50 S108 S11 BLE0 BLE001 BLE00 FBT001 FBT003 FBT002 FBT0 FBT00 B005 B009 B023 B013 B018 B024 B0 B022 B02 B03 B002 B016 B007 B011 B9 B00 B014 B019 B032 B021 B01 B904 B025 B012 B90 B010 B027 B003 B004 B020 B905 B026 B006 B008 B017 B029 B015 A0 A00 A001 A002 A003 COM819 COM8 COM812 COM81 COM818 C417 C410 C413 C400 C402 C411 C405 C415 C401 C408 C406 C40 C404 C409 C416 C41 C403 C414 DTZ005 DTZ012 DTZ007 DTZ001 DTZ00 DTZ011 DTZ003 DTZ0 DTZ01 DTZ006 DTZ002 DTZ004 T100 DJ008 DJ001 DJ0 DJ00 DJ01 DJ013 EM102 EM103 EM1 EM101 EM10 EXE001 EXE003 EXE004 EXE005 EXE0 EXE00 EXE002 ISC002 ISC001 ISC0 ISC00 ISC003 ICN00 ICN0 ICN001 G004 G001 G2 G00 G202 G01 G002 G101 G003 G010 G20 G10 G201 G0 G1 INP001 INP0 INP00 PIE8 PIE807 PIE80 PIE81 PIE7 PIE794 PIE810 PIE800 PIE79 PIE804 PIE790 PIE796 T201 T203 PYI007 PYI001 PYI008 PYI0 PYI00 PT018 PT008 PT010 PT009 PT020 PT023 PT013 PT011 PT022 PT00 PT016 PT026 PT007 PT012 PT02 PT024 PT004 PT019 PT01 PT005 PT001 PT006 PT002 PT015 PT021 PT025 PT003 PT0 PT017 Q001 Q002 Q003 Q0 Q00 Q000 RSE102 RSE1 RSE10 RET503 RET5 RET508 RET501 RET50 RET502 RET507 RET504 RET505 RET506 SLF0 SLF001 SLF00 SIM221 SIM108 SIM110 SIM300 SIM211 SIM101 SIM118 SIM114 SIM112 SIM115 SIM223 SIM220 SIM10 SIM22 SIM3 SIM107 SIM210 SIM102 SIM21 SIM105 SIM117 SIM1 SIM40 SIM4 SIM208 SIM103 SIM401 SIM30 SIM212 SIM116 SIM20 SIM201 SIM109 SIM11 SIM222 SIM202 SIM2 TID251 TID252 TID2 TID25 TCH00 TCH001 TCH002 TCH0 TCH003 TCH004 TCH005 ARG001 ARG003 ARG004 ARG005 ARG0 ARG002 ARG00 PTH1 PTH121 PTH122 PTH103 PTH110 PTH112 PTH119 PTH104 PTH101 PTH124 PTH108 PTH105 PTH115 PTH118 PTH123 PTH120 PTH109 PTH100 PTH11 PTH113 PTH114 PTH107 PTH106 PTH117 PTH102 PTH116 PTH111 PTH10 PTH12 I002 I0 I001 I00 C901 NPY00 NPY001 NPY002 NPY0 N813 N814 N9 N816 N999 N811 N99 N801 N817 N803 N8 N80 N807 N818 N802 N804 N812 N815 N81 N806 N805 PD015 PD013 PD901 PD00 PD008 PD009 PD011 PD9 PD004 PD012 PD01 PD003 PD007 PD0 PD002 PD010 PD90 E999 E73 E712 E501 E90 E402 E741 E902 E4 W505 E731 E722 E50 W292 E401 W605 E70 E99 E72 W2 E703 E71 W60 E743 E7 W5 E714 E101 E711 E5 E10 E701 E713 E E40 E702 W50 W6 E742 E721 E1 E9 W W29 E74 D410 D103 D204 D107 D212 D414 D100 D211 D400 D207 D405 D419 D40 D213 D418 D416 D206 D210 D402 D300 D1 D10 D30 D202 D104 D209 D215 D408 D403 D417 D2 D41 D407 D106 D415 D20 D411 D102 D203 D21 D301 D200 D409 D3 D4 D101 D201 D208 D105 D214 D412 D401 D404 D406 D413 D205 F631 F811 F522 F523 F822 F401 F52 F405 F704 F821 F823 F722 F506 F407 F402 F508 F633 F842 F507 F901 F406 F622 F5 F541 F701 F707 F70 F8 F601 F634 F504 F505 F63 F50 F403 F502 F632 F7 F509 F706 F81 F524 F4 F72 F84 F54 F702 F82 F404 F503 F60 F621 F841 F602 F501 F525 F62 F6 F9 F40 F90 F521 PGH0 PGH001 PGH002 PGH004 PGH003 PGH00 PLE PLR09 PLE130 PLR091 PLW29 PLE0100 PLR2004 PLW290 PLR0915 PLC300 PLR02 PLR0206 PLW PLW2 PLR172 PLE011 PLC04 PLE0118 PLR PLC0 PLE12 PLE1 PLE250 PLC30 PLE13 PLE0605 PLR0911 PLE1206 PLR1722 PLW2901 PLC041 PLE060 PLR200 PLW01 PLW012 PLR20 PLW060 PLE25 PLE1142 PLE1205 PLC3002 PLR0913 PLW0 PLR01 PLR1 PLR0912 PLR013 PLW0120 PLE1307 PLE06 PLE114 PLE120 PLC0414 PLR0402 PLE0117 PLR1701 PLR0 PLR020 PLW06 PLC3 PLE010 PLE11 PLE1310 PLR17 PLR04 PLR040 PLE2502 PLE0604 PLE01 PLC PLE131 PLE0101 PLR0133 PLR2 PLW0602 PLE0 PLE2 PLR170 UP023 UP02 UP012 UP007 UP018 UP026 UP036 UP014 UP017 UP020 UP034 UP00 UP030 UP033 UP028 UP008 UP001 UP006 UP010 UP011 UP025 UP037 UP0 UP029 UP01 UP03 UP005 UP003 UP024 UP004 UP013 UP021 UP027 UP031 UP032 UP022 UP009 UP015 UP019 UP035 RUF002 RUF100 RUF006 RUF004 RUF001 RUF1 RUF005 RUF003 RUF0 RUF00 RUF10 TRY2 TRY401 TRY4 TRY300 TRY201 TRY002 TRY3 TRY301 TRY40 TRY0 TRY00 TRY004 TRY400 TRY30 TRY20 TRY003 TRY200" -- "${cur}"))
                    return 0
                    ;;
                --ignore)
                    COMPREPLY=($(compgen -W "ALL F C90 I N D UP YTT ANN S BLE FBT B A COM C4 DTZ T10 DJ EM EXE ISC ICN G INP PIE T20 PYI PT Q RSE RET SLF SIM TID TCH ARG PTH ERA PD PGH PL TRY NPY RUF ERA00 ERA001 ERA0 YTT2 YTT301 YTT302 YTT204 YTT1 YTT10 YTT30 YTT201 YTT3 YTT303 YTT20 YTT202 YTT103 YTT203 YTT102 YTT101 ANN102 ANN206 ANN00 ANN10 ANN001 ANN003 ANN1 ANN201 ANN40 ANN2 ANN101 ANN4 ANN0 ANN202 ANN205 ANN401 ANN20 ANN002 ANN204 S324 S104 S509 S608 S113 S110 S508 S10 S32 S112 S701 S61 S102 S6 S70 S5 S3 S1 S60 S7 S105 S101 S103 S501 S106 S506 S612 S107 S50 S108 S11 BLE0 BLE001 BLE00 FBT001 FBT003 FBT002 FBT0 FBT00 B005 B009 B023 B013 B018 B024 B0 B022 B02 B03 B002 B016 B007 B011 B9 B00 B014 B019 B032 B021 B01 B904 B025 B012 B90 B010 B027 B003 B004 B020 B905 B026 B006 B008 B017 B029 B015 A0 A00 A001 A002 A003 COM819 COM8 COM812 COM81 COM818 C417 C410 C413 C400 C402 C411 C405 C415 C401 C408 C406 C40 C404 C409 C416 C41 C403 C414 DTZ005 DTZ012 DTZ007 DTZ001 DTZ00 DTZ011 DTZ003 DTZ0 DTZ01 DTZ006 DTZ002 DTZ004 T100 DJ008 DJ001 DJ0 DJ00 DJ01 DJ013 EM102 EM103 EM1 EM101 EM10 EXE001 EXE003 EXE004 EXE005 EXE0 EXE00 EXE002 ISC002 ISC001 ISC0 ISC00 ISC003 ICN00 ICN0 ICN001 G004 G001 G2 G00 G202 G01 G002 G101 G003 G010 G20 G10 G201 G0 G1 INP001 INP0 INP00 PIE8 PIE807 PIE80 PIE81 PIE7 PIE794 PIE810 PIE800 PIE79 PIE804 PIE790 PIE796 T201 T203 PYI007 PYI001 PYI008 PYI0 PYI00 PT018 PT008 PT010 PT009 PT020 PT023 PT013 PT011 PT022 PT00 PT016 PT026 PT007 PT012 PT02 PT024 PT004 PT019 PT01 PT005 PT001 PT006 PT002 PT015 PT021 PT025 PT003 PT0 PT017 Q001 Q002 Q003 Q0 Q00 Q000 RSE102 RSE1 RSE10 RET503 RET5 RET508 RET501 RET50 RET502 RET507 RET504 RET505 RET506 SLF0 SLF001 SLF00 SIM221 SIM108 SIM110 SIM300 SIM211 SIM101 SIM118 SIM114 SIM112 SIM115 SIM223 SIM220 SIM10 SIM22 SIM3 SIM107 SIM210 SIM102 SIM21 SIM105 SIM117 SIM1 SIM40 SIM4 SIM208 SIM103 SIM401 SIM30 SIM212 SIM116 SIM20 SIM201 SIM109 SIM11 SIM222 SIM202 SIM2 TID251 TID252 TID2 TID25 TCH00 TCH001 TCH002 TCH0 TCH003 TCH004 TCH005 ARG001 ARG003 ARG004 ARG005 ARG0 ARG002 ARG00 PTH1 PTH121 PTH122 PTH103 PTH110 PTH112 PTH119 PTH104 PTH101 PTH124 PTH108 PTH105 PTH115 PTH118 PTH123 PTH120 PTH109 PTH100 PTH11 PTH113 PTH114 PTH107 PTH106 PTH117 PTH102 PTH116 PTH111 PTH10 PTH12 I002 I0 I001 I00 C901 NPY00 NPY001 NPY002 NPY0 N813 N814 N9 N816 N999 N811 N99 N801 N817 N803 N8 N80 N807 N818 N802 N804 N812 N815 N81 N806 N805 PD015 PD013 PD901 PD00 PD008 PD009 PD011 PD9 PD004 PD012 PD01 PD003 PD007 PD0 PD002 PD010 PD90 E999 E73 E712 E501 E90 E402 E741 E902 E4 W505 E731 E722 E50 W292 E401 W605 E70 E99 E72 W2 E703 E71 W60 E743 E7 W5 E714 E101 E711 E5 E10 E701 E713 E E40 E702 W50 W6 E742 E721 E1 E9 W W29 E74 D410 D103 D204 D107 D212 D414 D100 D211 D400 D207 D405 D419 D40 D213 D418 D416 D206 D210 D402 D300 D1 D10 D30 D202 D104 D209 D215 D408 D403 D417 D2 D41 D407 D106 D415 D20 D411 D102 D203 D21 D301 D200 D409 D3 D4 D101 D201 D208 D105 D214 D412 D401 D404 D406 D413 D205 F631 F811 F522 F523 F822 F401 F52 F405 F704 F821 F823 F722 F506 F407 F402 F508 F633 F842 F507 F901 F406 F622 F5 F541 F701 F707 F70 F8 F601 F634 F504 F505 F63 F50 F403 F502 F632 F7 F509 F706 F81 F524 F4 F72 F84 F54 F702 F82 F404 F503 F60 F621 F841 F602 F501 F525 F62 F6 F9 F40 F90 F521 PGH0 PGH001 PGH002 PGH004 PGH003 PGH00 PLE PLR09 PLE130 PLR091 PLW29 PLE0100 PLR2004 PLW290 PLR0915 PLC300 PLR02 PLR0206 PLW PLW2 PLR172 PLE011 PLC04 PLE0118 PLR PLC0 PLE12 PLE1 PLE250 PLC30 PLE13 PLE0605 PLR0911 PLE1206 PLR1722 PLW2901 PLC041 PLE060 PLR200 PLW01 PLW012 PLR20 PLW060 PLE25 PLE1142 PLE1205 PLC3002 PLR0913 PLW0 PLR01 PLR1 PLR0912 PLR013 PLW0120 PLE1307 PLE06 PLE114 PLE120 PLC0414 PLR0402 PLE0117 PLR1701 PLR0 PLR020 PLW06 PLC3 PLE010 PLE11 PLE1310 PLR17 PLR04 PLR040 PLE2502 PLE0604 PLE01 PLC PLE131 PLE0101 PLR0133 PLR2 PLW0602 PLE0 PLE2 PLR170 UP023 UP02 UP012 UP007 UP018 UP026 UP036 UP014 UP017 UP020 UP034 UP00 UP030 UP033 UP028 UP008 UP001 UP006 UP010 UP011 UP025 UP037 UP0 UP029 UP01 UP03 UP005 UP003 UP024 UP004 UP013 UP021 UP027 UP031 UP032 UP022 UP009 UP015 UP019 UP035 RUF002 RUF100 RUF006 RUF004 RUF001 RUF1 RUF005 RUF003 RUF0 RUF00 RUF10 TRY2 TRY401 TRY4 TRY300 TRY201 TRY002 TRY3 TRY301 TRY40 TRY0 TRY00 TRY004 TRY400 TRY30 TRY20 TRY003 TRY200" -- "${cur}"))
                    return 0
                    ;;
                --extend-select)
                    COMPREPLY=($(compgen -W "ALL F C90 I N D UP YTT ANN S BLE FBT B A COM C4 DTZ T10 DJ EM EXE ISC ICN G INP PIE T20 PYI PT Q RSE RET SLF SIM TID TCH ARG PTH ERA PD PGH PL TRY NPY RUF ERA00 ERA001 ERA0 YTT2 YTT301 YTT302 YTT204 YTT1 YTT10 YTT30 YTT201 YTT3 YTT303 YTT20 YTT202 YTT103 YTT203 YTT102 YTT101 ANN102 ANN206 ANN00 ANN10 ANN001 ANN003 ANN1 ANN201 ANN40 ANN2 ANN101 ANN4 ANN0 ANN202 ANN205 ANN401 ANN20 ANN002 ANN204 S324 S104 S509 S608 S113 S110 S508 S10 S32 S112 S701 S61 S102 S6 S70 S5 S3 S1 S60 S7 S105 S101 S103 S501 S106 S506 S612 S107 S50 S108 S11 BLE0 BLE001 BLE00 FBT001 FBT003 FBT002 FBT0 FBT00 B005 B009 B023 B013 B018 B024 B0 B022 B02 B03 B002 B016 B007 B011 B9 B00 B014 B019 B032 B021 B01 B904 B025 B012 B90 B010 B027 B003 B004 B020 B905 B026 B006 B008 B017 B029 B015 A0 A00 A001 A002 A003 COM819 COM8 COM812 COM81 COM818 C417 C410 C413 C400 C402 C411 C405 C415 C401 C408 C406 C40 C404 C409 C416 C41 C403 C414 DTZ005 DTZ012 DTZ007 DTZ001 DTZ00 DTZ011 DTZ003 DTZ0 DTZ01 DTZ006 DTZ002 DTZ004 T100 DJ008 DJ001 DJ0 DJ00 DJ01 DJ013 EM102 EM103 EM1 EM101 EM10 EXE001 EXE003 EXE004 EXE005 EXE0 EXE00 EXE002 ISC002 ISC001 ISC0 ISC00 ISC003 ICN00 ICN0 ICN001 G004 G001 G2 G00 G202 G01 G002 G101 G003 G010 G20 G10 G201 G0 G1 INP001 INP0 INP00 PIE8 PIE807 PIE80 PIE81 PIE7 PIE794 PIE810 PIE800 PIE79 PIE804 PIE790 PIE796 T201 T203 PYI007 PYI001 PYI008 PYI0 PYI00 PT018 PT008 PT010 PT009 PT020 PT023 PT013 PT011 PT022 PT00 PT016 PT026 PT007 PT012 PT02 PT024 PT004 PT019 PT01 PT005 PT001 PT006 PT002 PT015 PT021 PT025 PT003 PT0 PT017 Q001 Q002 Q003 Q0 Q00 Q000 RSE102 RSE1 RSE10 RET503 RET5 RET508 RET501 RET50 RET502 RET507 RET504 RET505 RET506 SLF0 SLF001 SLF00 SIM221 SIM108 SIM110 SIM300 SIM211 SIM101 SIM118 SIM114 SIM112 SIM115 SIM223 SIM220 SIM10 SIM22 SIM3 SIM107 SIM210 SIM102 SIM21 SIM105 SIM117 SIM1 SIM40 SIM4 SIM208 SIM103 SIM401 SIM30 SIM212 SIM116 SIM20 SIM201 SIM109 SIM11 SIM222 SIM202 SIM2 TID251 TID252 TID2 TID25 TCH00 TCH001 TCH002 TCH0 TCH003 TCH004 TCH005 ARG001 ARG003 ARG004 ARG005 ARG0 ARG002 ARG00 PTH1 PTH121 PTH122 PTH103 PTH110 PTH112 PTH119 PTH104 PTH101 PTH124 PTH108 PTH105 PTH115 PTH118 PTH123 PTH120 PTH109 PTH100 PTH11 PTH113 PTH114 PTH107 PTH106 PTH117 PTH102 PTH116 PTH111 PTH10 PTH12 I002 I0 I001 I00 C901 NPY00 NPY001 NPY002 NPY0 N813 N814 N9 N816 N999 N811 N99 N801 N817 N803 N8 N80 N807 N818 N802 N804 N812 N815 N81 N806 N805 PD015 PD013 PD901 PD00 PD008 PD009 PD011 PD9 PD004 PD012 PD01 PD003 PD007 PD0 PD002 PD010 PD90 E999 E73 E712 E501 E90 E402 E741 E902 E4 W505 E731 E722 E50 W292 E401 W605 E70 E99 E72 W2 E703 E71 W60 E743 E7 W5 E714 E101 E711 E5 E10 E701 E713 E E40 E702 W50 W6 E742 E721 E1 E9 W W29 E74 D410 D103 D204 D107 D212 D414 D100 D211 D400 D207 D405 D419 D40 D213 D418 D416 D206 D210 D402 D300 D1 D10 D30 D202 D104 D209 D215 D408 D403 D417 D2 D41 D407 D106 D415 D20 D411 D102 D203 D21 D301 D200 D409 D3 D4 D101 D201 D208 D105 D214 D412 D401 D404 D406 D413 D205 F631 F811 F522 F523 F822 F401 F52 F405 F704 F821 F823 F722 F506 F407 F402 F508 F633 F842 F507 F901 F406 F622 F5 F541 F701 F707 F70 F8 F601 F634 F504 F505 F63 F50 F403 F502 F632 F7 F509 F706 F81 F524 F4 F72 F84 F54 F702 F82 F404 F503 F60 F621 F841 F602 F501 F525 F62 F6 F9 F40 F90 F521 PGH0 PGH001 PGH002 PGH004 PGH003 PGH00 PLE PLR09 PLE130 PLR091 PLW29 PLE0100 PLR2004 PLW290 PLR0915 PLC300 PLR02 PLR0206 PLW PLW2 PLR172 PLE011 PLC04 PLE0118 PLR PLC0 PLE12 PLE1 PLE250 PLC30 PLE13 PLE0605 PLR0911 PLE1206 PLR1722 PLW2901 PLC041 PLE060 PLR200 PLW01 PLW012 PLR20 PLW060 PLE25 PLE1142 PLE1205 PLC3002 PLR0913 PLW0 PLR01 PLR1 PLR0912 PLR013 PLW0120 PLE1307 PLE06 PLE114 PLE120 PLC0414 PLR0402 PLE0117 PLR1701 PLR0 PLR020 PLW06 PLC3 PLE010 PLE11 PLE1310 PLR17 PLR04 PLR040 PLE2502 PLE0604 PLE01 PLC PLE131 PLE0101 PLR0133 PLR2 PLW0602 PLE0 PLE2 PLR170 UP023 UP02 UP012 UP007 UP018 UP026 UP036 UP014 UP017 UP020 UP034 UP00 UP030 UP033 UP028 UP008 UP001 UP006 UP010 UP011 UP025 UP037 UP0 UP029 UP01 UP03 UP005 UP003 UP024 UP004 UP013 UP021 UP027 UP031 UP032 UP022 UP009 UP015 UP019 UP035 RUF002 RUF100 RUF006 RUF004 RUF001 RUF1 RUF005 RUF003 RUF0 RUF00 RUF10 TRY2 TRY401 TRY4 TRY300 TRY201 TRY002 TRY3 TRY301 TRY40 TRY0 TRY00 TRY004 TRY400 TRY30 TRY20 TRY003 TRY200" -- "${cur}"))
                    return 0
                    ;;
                --extend-ignore)
                    COMPREPLY=($(compgen -W "ALL F C90 I N D UP YTT ANN S BLE FBT B A COM C4 DTZ T10 DJ EM EXE ISC ICN G INP PIE T20 PYI PT Q RSE RET SLF SIM TID TCH ARG PTH ERA PD PGH PL TRY NPY RUF ERA00 ERA001 ERA0 YTT2 YTT301 YTT302 YTT204 YTT1 YTT10 YTT30 YTT201 YTT3 YTT303 YTT20 YTT202 YTT103 YTT203 YTT102 YTT101 ANN102 ANN206 ANN00 ANN10 ANN001 ANN003 ANN1 ANN201 ANN40 ANN2 ANN101 ANN4 ANN0 ANN202 ANN205 ANN401 ANN20 ANN002 ANN204 S324 S104 S509 S608 S113 S110 S508 S10 S32 S112 S701 S61 S102 S6 S70 S5 S3 S1 S60 S7 S105 S101 S103 S501 S106 S506 S612 S107 S50 S108 S11 BLE0 BLE001 BLE00 FBT001 FBT003 FBT002 FBT0 FBT00 B005 B009 B023 B013 B018 B024 B0 B022 B02 B03 B002 B016 B007 B011 B9 B00 B014 B019 B032 B021 B01 B904 B025 B012 B90 B010 B027 B003 B004 B020 B905 B026 B006 B008 B017 B029 B015 A0 A00 A001 A002 A003 COM819 COM8 COM812 COM81 COM818 C417 C410 C413 C400 C402 C411 C405 C415 C401 C408 C406 C40 C404 C409 C416 C41 C403 C414 DTZ005 DTZ012 DTZ007 DTZ001 DTZ00 DTZ011 DTZ003 DTZ0 DTZ01 DTZ006 DTZ002 DTZ004 T100 DJ008 DJ001 DJ0 DJ00 DJ01 DJ013 EM102 EM103 EM1 EM101 EM10 EXE001 EXE003 EXE004 EXE005 EXE0 EXE00 EXE002 ISC002 ISC001 ISC0 ISC00 ISC003 ICN00 ICN0 ICN001 G004 G001 G2 G00 G202 G01 G002 G101 G003 G010 G20 G10 G201 G0 G1 INP001 INP0 INP00 PIE8 PIE807 PIE80 PIE81 PIE7 PIE794 PIE810 PIE800 PIE79 PIE804 PIE790 PIE796 T201 T203 PYI007 PYI001 PYI008 PYI0 PYI00 PT018 PT008 PT010 PT009 PT020 PT023 PT013 PT011 PT022 PT00 PT016 PT026 PT007 PT012 PT02 PT024 PT004 PT019 PT01 PT005 PT001 PT006 PT002 PT015 PT021 PT025 PT003 PT0 PT017 Q001 Q002 Q003 Q0 Q00 Q000 RSE102 RSE1 RSE10 RET503 RET5 RET508 RET501 RET50 RET502 RET507 RET504 RET505 RET506 SLF0 SLF001 SLF00 SIM221 SIM108 SIM110 SIM300 SIM211 SIM101 SIM118 SIM114 SIM112 SIM115 SIM223 SIM220 SIM10 SIM22 SIM3 SIM107 SIM210 SIM102 SIM21 SIM105 SIM117 SIM1 SIM40 SIM4 SIM208 SIM103 SIM401 SIM30 SIM212 SIM116 SIM20 SIM201 SIM109 SIM11 SIM222 SIM202 SIM2 TID251 TID252 TID2 TID25 TCH00 TCH001 TCH002 TCH0 TCH003 TCH004 TCH005 ARG001 ARG003 ARG004 ARG005 ARG0 ARG002 ARG00 PTH1 PTH121 PTH122 PTH103 PTH110 PTH112 PTH119 PTH104 PTH101 PTH124 PTH108 PTH105 PTH115 PTH118 PTH123 PTH120 PTH109 PTH100 PTH11 PTH113 PTH114 PTH107 PTH106 PTH117 PTH102 PTH116 PTH111 PTH10 PTH12 I002 I0 I001 I00 C901 NPY00 NPY001 NPY002 NPY0 N813 N814 N9 N816 N999 N811 N99 N801 N817 N803 N8 N80 N807 N818 N802 N804 N812 N815 N81 N806 N805 PD015 PD013 PD901 PD00 PD008 PD009 PD011 PD9 PD004 PD012 PD01 PD003 PD007 PD0 PD002 PD010 PD90 E999 E73 E712 E501 E90 E402 E741 E902 E4 W505 E731 E722 E50 W292 E401 W605 E70 E99 E72 W2 E703 E71 W60 E743 E7 W5 E714 E101 E711 E5 E10 E701 E713 E E40 E702 W50 W6 E742 E721 E1 E9 W W29 E74 D410 D103 D204 D107 D212 D414 D100 D211 D400 D207 D405 D419 D40 D213 D418 D416 D206 D210 D402 D300 D1 D10 D30 D202 D104 D209 D215 D408 D403 D417 D2 D41 D407 D106 D415 D20 D411 D102 D203 D21 D301 D200 D409 D3 D4 D101 D201 D208 D105 D214 D412 D401 D404 D406 D413 D205 F631 F811 F522 F523 F822 F401 F52 F405 F704 F821 F823 F722 F506 F407 F402 F508 F633 F842 F507 F901 F406 F622 F5 F541 F701 F707 F70 F8 F601 F634 F504 F505 F63 F50 F403 F502 F632 F7 F509 F706 F81 F524 F4 F72 F84 F54 F702 F82 F404 F503 F60 F621 F841 F602 F501 F525 F62 F6 F9 F40 F90 F521 PGH0 PGH001 PGH002 PGH004 PGH003 PGH00 PLE PLR09 PLE130 PLR091 PLW29 PLE0100 PLR2004 PLW290 PLR0915 PLC300 PLR02 PLR0206 PLW PLW2 PLR172 PLE011 PLC04 PLE0118 PLR PLC0 PLE12 PLE1 PLE250 PLC30 PLE13 PLE0605 PLR0911 PLE1206 PLR1722 PLW2901 PLC041 PLE060 PLR200 PLW01 PLW012 PLR20 PLW060 PLE25 PLE1142 PLE1205 PLC3002 PLR0913 PLW0 PLR01 PLR1 PLR0912 PLR013 PLW0120 PLE1307 PLE06 PLE114 PLE120 PLC0414 PLR0402 PLE0117 PLR1701 PLR0 PLR020 PLW06 PLC3 PLE010 PLE11 PLE1310 PLR17 PLR04 PLR040 PLE2502 PLE0604 PLE01 PLC PLE131 PLE0101 PLR0133 PLR2 PLW0602 PLE0 PLE2 PLR170 UP023 UP02 UP012 UP007 UP018 UP026 UP036 UP014 UP017 UP020 UP034 UP00 UP030 UP033 UP028 UP008 UP001 UP006 UP010 UP011 UP025 UP037 UP0 UP029 UP01 UP03 UP005 UP003 UP024 UP004 UP013 UP021 UP027 UP031 UP032 UP022 UP009 UP015 UP019 UP035 RUF002 RUF100 RUF006 RUF004 RUF001 RUF1 RUF005 RUF003 RUF0 RUF00 RUF10 TRY2 TRY401 TRY4 TRY300 TRY201 TRY002 TRY3 TRY301 TRY40 TRY0 TRY00 TRY004 TRY400 TRY30 TRY20 TRY003 TRY200" -- "${cur}"))
                    return 0
                    ;;
                --per-file-ignores)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --exclude)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --extend-exclude)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --fixable)
                    COMPREPLY=($(compgen -W "ALL F C90 I N D UP YTT ANN S BLE FBT B A COM C4 DTZ T10 DJ EM EXE ISC ICN G INP PIE T20 PYI PT Q RSE RET SLF SIM TID TCH ARG PTH ERA PD PGH PL TRY NPY RUF ERA00 ERA001 ERA0 YTT2 YTT301 YTT302 YTT204 YTT1 YTT10 YTT30 YTT201 YTT3 YTT303 YTT20 YTT202 YTT103 YTT203 YTT102 YTT101 ANN102 ANN206 ANN00 ANN10 ANN001 ANN003 ANN1 ANN201 ANN40 ANN2 ANN101 ANN4 ANN0 ANN202 ANN205 ANN401 ANN20 ANN002 ANN204 S324 S104 S509 S608 S113 S110 S508 S10 S32 S112 S701 S61 S102 S6 S70 S5 S3 S1 S60 S7 S105 S101 S103 S501 S106 S506 S612 S107 S50 S108 S11 BLE0 BLE001 BLE00 FBT001 FBT003 FBT002 FBT0 FBT00 B005 B009 B023 B013 B018 B024 B0 B022 B02 B03 B002 B016 B007 B011 B9 B00 B014 B019 B032 B021 B01 B904 B025 B012 B90 B010 B027 B003 B004 B020 B905 B026 B006 B008 B017 B029 B015 A0 A00 A001 A002 A003 COM819 COM8 COM812 COM81 COM818 C417 C410 C413 C400 C402 C411 C405 C415 C401 C408 C406 C40 C404 C409 C416 C41 C403 C414 DTZ005 DTZ012 DTZ007 DTZ001 DTZ00 DTZ011 DTZ003 DTZ0 DTZ01 DTZ006 DTZ002 DTZ004 T100 DJ008 DJ001 DJ0 DJ00 DJ01 DJ013 EM102 EM103 EM1 EM101 EM10 EXE001 EXE003 EXE004 EXE005 EXE0 EXE00 EXE002 ISC002 ISC001 ISC0 ISC00 ISC003 ICN00 ICN0 ICN001 G004 G001 G2 G00 G202 G01 G002 G101 G003 G010 G20 G10 G201 G0 G1 INP001 INP0 INP00 PIE8 PIE807 PIE80 PIE81 PIE7 PIE794 PIE810 PIE800 PIE79 PIE804 PIE790 PIE796 T201 T203 PYI007 PYI001 PYI008 PYI0 PYI00 PT018 PT008 PT010 PT009 PT020 PT023 PT013 PT011 PT022 PT00 PT016 PT026 PT007 PT012 PT02 PT024 PT004 PT019 PT01 PT005 PT001 PT006 PT002 PT015 PT021 PT025 PT003 PT0 PT017 Q001 Q002 Q003 Q0 Q00 Q000 RSE102 RSE1 RSE10 RET503 RET5 RET508 RET501 RET50 RET502 RET507 RET504 RET505 RET506 SLF0 SLF001 SLF00 SIM221 SIM108 SIM110 SIM300 SIM211 SIM101 SIM118 SIM114 SIM112 SIM115 SIM223 SIM220 SIM10 SIM22 SIM3 SIM107 SIM210 SIM102 SIM21 SIM105 SIM117 SIM1 SIM40 SIM4 SIM208 SIM103 SIM401 SIM30 SIM212 SIM116 SIM20 SIM201 SIM109 SIM11 SIM222 SIM202 SIM2 TID251 TID252 TID2 TID25 TCH00 TCH001 TCH002 TCH0 TCH003 TCH004 TCH005 ARG001 ARG003 ARG004 ARG005 ARG0 ARG002 ARG00 PTH1 PTH121 PTH122 PTH103 PTH110 PTH112 PTH119 PTH104 PTH101 PTH124 PTH108 PTH105 PTH115 PTH118 PTH123 PTH120 PTH109 PTH100 PTH11 PTH113 PTH114 PTH107 PTH106 PTH117 PTH102 PTH116 PTH111 PTH10 PTH12 I002 I0 I001 I00 C901 NPY00 NPY001 NPY002 NPY0 N813 N814 N9 N816 N999 N811 N99 N801 N817 N803 N8 N80 N807 N818 N802 N804 N812 N815 N81 N806 N805 PD015 PD013 PD901 PD00 PD008 PD009 PD011 PD9 PD004 PD012 PD01 PD003 PD007 PD0 PD002 PD010 PD90 E999 E73 E712 E501 E90 E402 E741 E902 E4 W505 E731 E722 E50 W292 E401 W605 E70 E99 E72 W2 E703 E71 W60 E743 E7 W5 E714 E101 E711 E5 E10 E701 E713 E E40 E702 W50 W6 E742 E721 E1 E9 W W29 E74 D410 D103 D204 D107 D212 D414 D100 D211 D400 D207 D405 D419 D40 D213 D418 D416 D206 D210 D402 D300 D1 D10 D30 D202 D104 D209 D215 D408 D403 D417 D2 D41 D407 D106 D415 D20 D411 D102 D203 D21 D301 D200 D409 D3 D4 D101 D201 D208 D105 D214 D412 D401 D404 D406 D413 D205 F631 F811 F522 F523 F822 F401 F52 F405 F704 F821 F823 F722 F506 F407 F402 F508 F633 F842 F507 F901 F406 F622 F5 F541 F701 F707 F70 F8 F601 F634 F504 F505 F63 F50 F403 F502 F632 F7 F509 F706 F81 F524 F4 F72 F84 F54 F702 F82 F404 F503 F60 F621 F841 F602 F501 F525 F62 F6 F9 F40 F90 F521 PGH0 PGH001 PGH002 PGH004 PGH003 PGH00 PLE PLR09 PLE130 PLR091 PLW29 PLE0100 PLR2004 PLW290 PLR0915 PLC300 PLR02 PLR0206 PLW PLW2 PLR172 PLE011 PLC04 PLE0118 PLR PLC0 PLE12 PLE1 PLE250 PLC30 PLE13 PLE0605 PLR0911 PLE1206 PLR1722 PLW2901 PLC041 PLE060 PLR200 PLW01 PLW012 PLR20 PLW060 PLE25 PLE1142 PLE1205 PLC3002 PLR0913 PLW0 PLR01 PLR1 PLR0912 PLR013 PLW0120 PLE1307 PLE06 PLE114 PLE120 PLC0414 PLR0402 PLE0117 PLR1701 PLR0 PLR020 PLW06 PLC3 PLE010 PLE11 PLE1310 PLR17 PLR04 PLR040 PLE2502 PLE0604 PLE01 PLC PLE131 PLE0101 PLR0133 PLR2 PLW0602 PLE0 PLE2 PLR170 UP023 UP02 UP012 UP007 UP018 UP026 UP036 UP014 UP017 UP020 UP034 UP00 UP030 UP033 UP028 UP008 UP001 UP006 UP010 UP011 UP025 UP037 UP0 UP029 UP01 UP03 UP005 UP003 UP024 UP004 UP013 UP021 UP027 UP031 UP032 UP022 UP009 UP015 UP019 UP035 RUF002 RUF100 RUF006 RUF004 RUF001 RUF1 RUF005 RUF003 RUF0 RUF00 RUF10 TRY2 TRY401 TRY4 TRY300 TRY201 TRY002 TRY3 TRY301 TRY40 TRY0 TRY00 TRY004 TRY400 TRY30 TRY20 TRY003 TRY200" -- "${cur}"))
                    return 0
                    ;;
                --unfixable)
                    COMPREPLY=($(compgen -W "ALL F C90 I N D UP YTT ANN S BLE FBT B A COM C4 DTZ T10 DJ EM EXE ISC ICN G INP PIE T20 PYI PT Q RSE RET SLF SIM TID TCH ARG PTH ERA PD PGH PL TRY NPY RUF ERA00 ERA001 ERA0 YTT2 YTT301 YTT302 YTT204 YTT1 YTT10 YTT30 YTT201 YTT3 YTT303 YTT20 YTT202 YTT103 YTT203 YTT102 YTT101 ANN102 ANN206 ANN00 ANN10 ANN001 ANN003 ANN1 ANN201 ANN40 ANN2 ANN101 ANN4 ANN0 ANN202 ANN205 ANN401 ANN20 ANN002 ANN204 S324 S104 S509 S608 S113 S110 S508 S10 S32 S112 S701 S61 S102 S6 S70 S5 S3 S1 S60 S7 S105 S101 S103 S501 S106 S506 S612 S107 S50 S108 S11 BLE0 BLE001 BLE00 FBT001 FBT003 FBT002 FBT0 FBT00 B005 B009 B023 B013 B018 B024 B0 B022 B02 B03 B002 B016 B007 B011 B9 B00 B014 B019 B032 B021 B01 B904 B025 B012 B90 B010 B027 B003 B004 B020 B905 B026 B006 B008 B017 B029 B015 A0 A00 A001 A002 A003 COM819 COM8 COM812 COM81 COM818 C417 C410 C413 C400 C402 C411 C405 C415 C401 C408 C406 C40 C404 C409 C416 C41 C403 C414 DTZ005 DTZ012 DTZ007 DTZ001 DTZ00 DTZ011 DTZ003 DTZ0 DTZ01 DTZ006 DTZ002 DTZ004 T100 DJ008 DJ001 DJ0 DJ00 DJ01 DJ013 EM102 EM103 EM1 EM101 EM10 EXE001 EXE003 EXE004 EXE005 EXE0 EXE00 EXE002 ISC002 ISC001 ISC0 ISC00 ISC003 ICN00 ICN0 ICN001 G004 G001 G2 G00 G202 G01 G002 G101 G003 G010 G20 G10 G201 G0 G1 INP001 INP0 INP00 PIE8 PIE807 PIE80 PIE81 PIE7 PIE794 PIE810 PIE800 PIE79 PIE804 PIE790 PIE796 T201 T203 PYI007 PYI001 PYI008 PYI0 PYI00 PT018 PT008 PT010 PT009 PT020 PT023 PT013 PT011 PT022 PT00 PT016 PT026 PT007 PT012 PT02 PT024 PT004 PT019 PT01 PT005 PT001 PT006 PT002 PT015 PT021 PT025 PT003 PT0 PT017 Q001 Q002 Q003 Q0 Q00 Q000 RSE102 RSE1 RSE10 RET503 RET5 RET508 RET501 RET50 RET502 RET507 RET504 RET505 RET506 SLF0 SLF001 SLF00 SIM221 SIM108 SIM110 SIM300 SIM211 SIM101 SIM118 SIM114 SIM112 SIM115 SIM223 SIM220 SIM10 SIM22 SIM3 SIM107 SIM210 SIM102 SIM21 SIM105 SIM117 SIM1 SIM40 SIM4 SIM208 SIM103 SIM401 SIM30 SIM212 SIM116 SIM20 SIM201 SIM109 SIM11 SIM222 SIM202 SIM2 TID251 TID252 TID2 TID25 TCH00 TCH001 TCH002 TCH0 TCH003 TCH004 TCH005 ARG001 ARG003 ARG004 ARG005 ARG0 ARG002 ARG00 PTH1 PTH121 PTH122 PTH103 PTH110 PTH112 PTH119 PTH104 PTH101 PTH124 PTH108 PTH105 PTH115 PTH118 PTH123 PTH120 PTH109 PTH100 PTH11 PTH113 PTH114 PTH107 PTH106 PTH117 PTH102 PTH116 PTH111 PTH10 PTH12 I002 I0 I001 I00 C901 NPY00 NPY001 NPY002 NPY0 N813 N814 N9 N816 N999 N811 N99 N801 N817 N803 N8 N80 N807 N818 N802 N804 N812 N815 N81 N806 N805 PD015 PD013 PD901 PD00 PD008 PD009 PD011 PD9 PD004 PD012 PD01 PD003 PD007 PD0 PD002 PD010 PD90 E999 E73 E712 E501 E90 E402 E741 E902 E4 W505 E731 E722 E50 W292 E401 W605 E70 E99 E72 W2 E703 E71 W60 E743 E7 W5 E714 E101 E711 E5 E10 E701 E713 E E40 E702 W50 W6 E742 E721 E1 E9 W W29 E74 D410 D103 D204 D107 D212 D414 D100 D211 D400 D207 D405 D419 D40 D213 D418 D416 D206 D210 D402 D300 D1 D10 D30 D202 D104 D209 D215 D408 D403 D417 D2 D41 D407 D106 D415 D20 D411 D102 D203 D21 D301 D200 D409 D3 D4 D101 D201 D208 D105 D214 D412 D401 D404 D406 D413 D205 F631 F811 F522 F523 F822 F401 F52 F405 F704 F821 F823 F722 F506 F407 F402 F508 F633 F842 F507 F901 F406 F622 F5 F541 F701 F707 F70 F8 F601 F634 F504 F505 F63 F50 F403 F502 F632 F7 F509 F706 F81 F524 F4 F72 F84 F54 F702 F82 F404 F503 F60 F621 F841 F602 F501 F525 F62 F6 F9 F40 F90 F521 PGH0 PGH001 PGH002 PGH004 PGH003 PGH00 PLE PLR09 PLE130 PLR091 PLW29 PLE0100 PLR2004 PLW290 PLR0915 PLC300 PLR02 PLR0206 PLW PLW2 PLR172 PLE011 PLC04 PLE0118 PLR PLC0 PLE12 PLE1 PLE250 PLC30 PLE13 PLE0605 PLR0911 PLE1206 PLR1722 PLW2901 PLC041 PLE060 PLR200 PLW01 PLW012 PLR20 PLW060 PLE25 PLE1142 PLE1205 PLC3002 PLR0913 PLW0 PLR01 PLR1 PLR0912 PLR013 PLW0120 PLE1307 PLE06 PLE114 PLE120 PLC0414 PLR0402 PLE0117 PLR1701 PLR0 PLR020 PLW06 PLC3 PLE010 PLE11 PLE1310 PLR17 PLR04 PLR040 PLE2502 PLE0604 PLE01 PLC PLE131 PLE0101 PLR0133 PLR2 PLW0602 PLE0 PLE2 PLR170 UP023 UP02 UP012 UP007 UP018 UP026 UP036 UP014 UP017 UP020 UP034 UP00 UP030 UP033 UP028 UP008 UP001 UP006 UP010 UP011 UP025 UP037 UP0 UP029 UP01 UP03 UP005 UP003 UP024 UP004 UP013 UP021 UP027 UP031 UP032 UP022 UP009 UP015 UP019 UP035 RUF002 RUF100 RUF006 RUF004 RUF001 RUF1 RUF005 RUF003 RUF0 RUF00 RUF10 TRY2 TRY401 TRY4 TRY300 TRY201 TRY002 TRY3 TRY301 TRY40 TRY0 TRY00 TRY004 TRY400 TRY30 TRY20 TRY003 TRY200" -- "${cur}"))
                    return 0
                    ;;
                --line-length)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --dummy-variable-rgx)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --cache-dir)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --stdin-filename)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        ruff__clean)
            opts="-v -q -s -h --verbose --quiet --silent --help"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 2 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        ruff__config)
            opts="-v -q -s -h --verbose --quiet --silent --help [OPTION]"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 2 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        ruff__generate__shell__completion)
            opts="-v -q -s -h --verbose --quiet --silent --help bash elvish fig fish powershell zsh"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 2 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        ruff__help)
            opts="check rule config linter clean generate-shell-completion help"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 2 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        ruff__help__check)
            opts=""
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        ruff__help__clean)
            opts=""
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        ruff__help__config)
            opts=""
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        ruff__help__generate__shell__completion)
            opts=""
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        ruff__help__help)
            opts=""
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        ruff__help__linter)
            opts=""
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        ruff__help__rule)
            opts=""
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        ruff__linter)
            opts="-v -q -s -h --format --verbose --quiet --silent --help"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 2 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --format)
                    COMPREPLY=($(compgen -W "text json" -- "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        ruff__rule)
            opts="-v -q -s -h --format --verbose --quiet --silent --help <RULE>"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 2 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --format)
                    COMPREPLY=($(compgen -W "text json" -- "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
    esac
}

complete -F _ruff -o bashdefault -o default ruff
