complete -c ruff -n "__fish_use_subcommand" -s v -l verbose -d 'Enable verbose logging'
complete -c ruff -n "__fish_use_subcommand" -s q -l quiet -d 'Print lint violations, but nothing else'
complete -c ruff -n "__fish_use_subcommand" -s s -l silent -d 'Disable all logging (but still exit with status code "1" upon detecting lint violations)'
complete -c ruff -n "__fish_use_subcommand" -s h -l help -d 'Print help'
complete -c ruff -n "__fish_use_subcommand" -s V -l version -d 'Print version'
complete -c ruff -n "__fish_use_subcommand" -f -a "check" -d 'Run Ruff on the given files or directories (default)'
complete -c ruff -n "__fish_use_subcommand" -f -a "rule" -d 'Explain a rule'
complete -c ruff -n "__fish_use_subcommand" -f -a "config" -d 'List or describe the available configuration options'
complete -c ruff -n "__fish_use_subcommand" -f -a "linter" -d 'List all supported upstream linters'
complete -c ruff -n "__fish_use_subcommand" -f -a "clean" -d 'Clear any caches in the current directory and any subdirectories'
complete -c ruff -n "__fish_use_subcommand" -f -a "generate-shell-completion" -d 'Generate shell completion'
complete -c ruff -n "__fish_use_subcommand" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c ruff -n "__fish_seen_subcommand_from check" -l format -d 'Output serialization format for violations' -r -f -a "{text	,json	,junit	,grouped	,github	,gitlab	,pylint	}"
complete -c ruff -n "__fish_seen_subcommand_from check" -l target-version -d 'The minimum Python version that should be supported' -r
complete -c ruff -n "__fish_seen_subcommand_from check" -l config -d 'Path to the `pyproject.toml` or `ruff.toml` file to use for configuration' -r -F
complete -c ruff -n "__fish_seen_subcommand_from check" -l select -d 'Comma-separated list of rule codes to enable (or ALL, to enable all rules)' -r -f -a "{ALL	all rules,F	Pyflakes,C90	mccabe,I	isort,N	pep8-naming,D	pydocstyle,UP	pyupgrade,YTT	flake8-2020,ANN	flake8-annotations,S	flake8-bandit,BLE	flake8-blind-except,FBT	flake8-boolean-trap,B	flake8-bugbear,A	flake8-builtins,COM	flake8-commas,C4	flake8-comprehensions,DTZ	flake8-datetimez,T10	flake8-debugger,DJ	flake8-django,EM	flake8-errmsg,EXE	flake8-executable,ISC	flake8-implicit-str-concat,ICN	flake8-import-conventions,G	flake8-logging-format,INP	flake8-no-pep420,PIE	flake8-pie,T20	flake8-print,PYI	flake8-pyi,PT	flake8-pytest-style,Q	flake8-quotes,RSE	flake8-raise,RET	flake8-return,SLF	flake8-self,SIM	flake8-simplify,TID	flake8-tidy-imports,TCH	flake8-type-checking,ARG	flake8-unused-arguments,PTH	flake8-use-pathlib,ERA	eradicate,PD	pandas-vet,PGH	pygrep-hooks,PL	Pylint,TRY	tryceratops,NPY	NumPy-specific rules,RUF	Ruff-specific rules,ERA00	commented-out-code,ERA001	commented-out-code,ERA0	commented-out-code,YTT2	,YTT301	sys-version0-referenced,YTT302	sys-version-cmp-str10,YTT204	sys-version-info-minor-cmp-int,YTT1	,YTT10	,YTT30	,YTT201	sys-version-info0-eq3-referenced,YTT3	,YTT303	sys-version-slice1-referenced,YTT20	,YTT202	six-py3-referenced,YTT103	sys-version-cmp-str3,YTT203	sys-version-info1-cmp-int,YTT102	sys-version2-referenced,YTT101	sys-version-slice3-referenced,ANN102	missing-type-cls,ANN206	missing-return-type-class-method,ANN00	,ANN10	,ANN001	missing-type-function-argument,ANN003	missing-type-kwargs,ANN1	,ANN201	missing-return-type-public-function,ANN40	any-type,ANN2	,ANN101	missing-type-self,ANN4	any-type,ANN0	,ANN202	missing-return-type-private-function,ANN205	missing-return-type-static-method,ANN401	any-type,ANN20	,ANN002	missing-type-args,ANN204	missing-return-type-special-method,S324	hashlib-insecure-hash-function,S104	hardcoded-bind-all-interfaces,S509	snmp-weak-cryptography,S608	hardcoded-sql-expression,S113	request-without-timeout,S110	try-except-pass,S508	snmp-insecure-version,S10	,S32	hashlib-insecure-hash-function,S112	try-except-continue,S701	jinja2-autoescape-false,S61	logging-config-insecure-listen,S102	exec-builtin,S6	,S70	jinja2-autoescape-false,S5	,S3	hashlib-insecure-hash-function,S1	,S60	hardcoded-sql-expression,S7	jinja2-autoescape-false,S105	hardcoded-password-string,S101	assert,S103	bad-file-permissions,S501	request-with-no-cert-validation,S106	hardcoded-password-func-arg,S506	unsafe-yaml-load,S612	logging-config-insecure-listen,S107	hardcoded-password-default,S50	,S108	hardcoded-temp-file,S11	,BLE0	blind-except,BLE001	blind-except,BLE00	blind-except,FBT001	boolean-positional-arg-in-function-definition,FBT003	boolean-positional-value-in-function-call,FBT002	boolean-default-value-in-function-definition,FBT0	,FBT00	,B005	strip-with-multi-characters,B009	get-attr-with-constant,B023	function-uses-loop-variable,B013	redundant-tuple-in-exception-handler,B018	useless-expression,B024	abstract-base-class-without-abstract-method,B0	,B022	useless-contextlib-suppress,B02	,B03	unintentional-type-annotation,B002	unary-prefix-increment,B016	cannot-raise-literal,B007	unused-loop-control-variable,B011	assert-false,B9	,B00	,B014	duplicate-handler-exception,B019	cached-instance-method,B032	unintentional-type-annotation,B021	f-string-docstring,B01	,B904	raise-without-from-inside-except,B025	duplicate-try-block-exception,B012	jump-statement-in-finally,B90	,B010	set-attr-with-constant,B027	empty-method-without-abstract-decorator,B003	assignment-to-os-environ,B004	unreliable-callable-check,B020	loop-variable-overrides-iterator,B905	zip-without-explicit-strict,B026	star-arg-unpacking-after-keyword-arg,B006	mutable-argument-default,B008	function-call-argument-default,B017	assert-raises-exception,B029	except-with-empty-tuple,B015	useless-comparison,A0	,A00	,A001	builtin-variable-shadowing,A002	builtin-argument-shadowing,A003	builtin-attribute-shadowing,COM819	trailing-comma-prohibited,COM8	,COM812	trailing-comma-missing,COM81	,COM818	trailing-comma-on-bare-tuple-prohibited,C417	unnecessary-map,C410	unnecessary-literal-within-list-call,C413	unnecessary-call-around-sorted,C400	unnecessary-generator-list,C402	unnecessary-generator-dict,C411	unnecessary-list-call,C405	unnecessary-literal-set,C415	unnecessary-subscript-reversal,C401	unnecessary-generator-set,C408	unnecessary-collection-call,C406	unnecessary-literal-dict,C40	,C404	unnecessary-list-comprehension-dict,C409	unnecessary-literal-within-tuple-call,C416	unnecessary-comprehension,C41	,C403	unnecessary-list-comprehension-set,C414	unnecessary-double-cast-or-process,DTZ005	call-datetime-now-without-tzinfo,DTZ012	call-date-fromtimestamp,DTZ007	call-datetime-strptime-without-zone,DTZ001	call-datetime-without-tzinfo,DTZ00	,DTZ011	call-date-today,DTZ003	call-datetime-utcnow,DTZ0	,DTZ01	,DTZ006	call-datetime-fromtimestamp,DTZ002	call-datetime-today,DTZ004	call-datetime-utcfromtimestamp,T100	debugger,DJ008	model-without-dunder-str,DJ001	nullable-model-string-field,DJ0	,DJ00	,DJ01	non-leading-receiver-decorator,DJ013	non-leading-receiver-decorator,EM102	f-string-in-exception,EM103	dot-format-in-exception,EM1	,EM101	raw-string-in-exception,EM10	,EXE001	shebang-not-executable,EXE003	shebang-python,EXE004	shebang-whitespace,EXE005	shebang-newline,EXE0	,EXE00	,EXE002	shebang-missing-executable-file,ISC002	multi-line-implicit-string-concatenation,ISC001	single-line-implicit-string-concatenation,ISC0	,ISC00	,ISC003	explicit-string-concatenation,ICN00	unconventional-import-alias,ICN0	unconventional-import-alias,ICN001	unconventional-import-alias,G004	logging-f-string,G001	logging-string-format,G2	,G00	,G202	logging-redundant-exc-info,G01	logging-warn,G002	logging-percent-format,G101	logging-extra-attr-clash,G003	logging-string-concat,G010	logging-warn,G20	,G10	logging-extra-attr-clash,G201	logging-exc-info,G0	,G1	logging-extra-attr-clash,INP001	implicit-namespace-package,INP0	implicit-namespace-package,INP00	implicit-namespace-package,PIE8	,PIE807	prefer-list-builtin,PIE80	,PIE81	single-starts-ends-with,PIE7	,PIE794	dupe-class-field-definitions,PIE810	single-starts-ends-with,PIE800	unnecessary-spread,PIE79	,PIE804	unnecessary-dict-kwargs,PIE790	unnecessary-pass,PIE796	prefer-unique-enums,T201	print-found,T203	p-print-found,PYI007	unrecognized-platform-check,PYI001	prefix-type-params,PYI008	unrecognized-platform-name,PYI0	,PYI00	,PT018	composite-assertion,PT008	patch-with-lambda,PT010	raises-without-exception,PT009	unittest-assertion,PT020	deprecated-yield-fixture,PT023	incorrect-mark-parentheses-style,PT013	incorrect-pytest-import,PT011	raises-too-broad,PT022	useless-yield-fixture,PT00	,PT016	fail-without-message,PT026	use-fixtures-without-parameters,PT007	parametrize-values-wrong-type,PT012	raises-with-multiple-statements,PT02	,PT024	unnecessary-asyncio-mark-on-fixture,PT004	missing-fixture-name-underscore,PT019	fixture-param-without-value,PT01	,PT005	incorrect-fixture-name-underscore,PT001	incorrect-fixture-parentheses-style,PT006	parametrize-names-wrong-type,PT002	fixture-positional-args,PT015	assert-always-false,PT021	fixture-finalizer-callback,PT025	erroneous-use-fixtures-on-fixture,PT003	extraneous-scope-function,PT0	,PT017	assert-in-except,Q001	bad-quotes-multiline-string,Q002	bad-quotes-docstring,Q003	avoidable-escaped-quote,Q0	,Q00	,Q000	bad-quotes-inline-string,RSE102	unnecessary-paren-on-raise-exception,RSE1	unnecessary-paren-on-raise-exception,RSE10	unnecessary-paren-on-raise-exception,RET503	implicit-return,RET5	,RET508	superfluous-else-break,RET501	unnecessary-return-none,RET50	,RET502	implicit-return-value,RET507	superfluous-else-continue,RET504	unnecessary-assign,RET505	superfluous-else-return,RET506	superfluous-else-raise,SLF0	private-member-access,SLF001	private-member-access,SLF00	private-member-access,SIM221	a-or-not-a,SIM108	use-ternary-operator,SIM110	reimplemented-builtin,SIM300	yoda-conditions,SIM211	if-expr-with-false-true,SIM101	duplicate-isinstance-call,SIM118	key-in-dict,SIM114	if-with-same-arms,SIM112	use-capital-environment-variables,SIM115	open-file-with-context-handler,SIM223	and-false,SIM220	a-and-not-a,SIM10	,SIM22	,SIM3	yoda-conditions,SIM107	return-in-try-except-finally,SIM210	if-expr-with-true-false,SIM102	collapsible-if,SIM21	,SIM105	use-contextlib-suppress,SIM117	multiple-with-statements,SIM1	,SIM40	dict-get-with-default,SIM4	dict-get-with-default,SIM208	double-negation,SIM103	needless-bool,SIM401	dict-get-with-default,SIM30	yoda-conditions,SIM212	if-expr-with-twisted-arms,SIM116	manual-dict-lookup,SIM20	,SIM201	negate-equal-op,SIM109	compare-with-tuple,SIM11	,SIM222	or-true,SIM202	negate-not-equal-op,SIM2	,TID251	banned-api,TID252	relative-imports,TID2	,TID25	,TCH00	,TCH001	typing-only-first-party-import,TCH002	typing-only-third-party-import,TCH0	,TCH003	typing-only-standard-library-import,TCH004	runtime-import-in-type-checking-block,TCH005	empty-type-checking-block,ARG001	unused-function-argument,ARG003	unused-class-method-argument,ARG004	unused-static-method-argument,ARG005	unused-lambda-argument,ARG0	,ARG002	unused-method-argument,ARG00	,PTH1	,PTH121	pathlib-samefile,PTH122	pathlib-splitext,PTH103	pathlib-makedirs,PTH110	pathlib-exists,PTH112	pathlib-is-dir,PTH119	pathlib-basename,PTH104	pathlib-rename,PTH101	pathlib-chmod,PTH124	pathlib-py-path,PTH108	pathlib-unlink,PTH105	pathlib-replace,PTH115	pathlib-readlink,PTH118	pathlib-join,PTH123	pathlib-open,PTH120	pathlib-dirname,PTH109	pathlib-getcwd,PTH100	pathlib-abspath,PTH11	,PTH113	pathlib-is-file,PTH114	pathlib-is-link,PTH107	pathlib-remove,PTH106	pathlib-rmdir,PTH117	pathlib-is-abs,PTH102	pathlib-mkdir,PTH116	pathlib-stat,PTH111	pathlib-expanduser,PTH10	,PTH12	,I002	missing-required-import,I0	,I001	unsorted-imports,I00	,C901	complex-structure,NPY00	,NPY001	numpy-deprecated-type-alias,NPY002	numpy-legacy-random,NPY0	,N813	camelcase-imported-as-lowercase,N814	camelcase-imported-as-constant,N9	invalid-module-name,N816	mixed-case-variable-in-global-scope,N999	invalid-module-name,N811	constant-imported-as-non-constant,N99	invalid-module-name,N801	invalid-class-name,N817	camelcase-imported-as-acronym,N803	invalid-argument-name,N8	,N80	,N807	dunder-function-name,N818	error-suffix-on-exception-name,N802	invalid-function-name,N804	invalid-first-argument-name-for-class-method,N812	lowercase-imported-as-non-lowercase,N815	mixed-case-variable-in-class-scope,N81	,N806	non-lowercase-variable-in-function,N805	invalid-first-argument-name-for-method,PD015	use-of-pd-merge,PD013	use-of-dot-stack,PD901	df-is-a-bad-variable-name,PD00	,PD008	use-of-dot-at,PD009	use-of-dot-iat,PD011	use-of-dot-values,PD9	df-is-a-bad-variable-name,PD004	use-of-dot-not-null,PD012	use-of-dot-read-table,PD01	,PD003	use-of-dot-is-null,PD007	use-of-dot-ix,PD0	,PD002	use-of-inplace-argument,PD010	use-of-dot-pivot-or-unstack,PD90	df-is-a-bad-variable-name,E999	syntax-error,E73	lambda-assignment,E712	true-false-comparison,E501	line-too-long,E90	io-error,E402	module-import-not-at-top-of-file,E741	ambiguous-variable-name,E902	io-error,E4	,W505	doc-line-too-long,E731	lambda-assignment,E722	bare-except,E50	line-too-long,W292	no-new-line-at-end-of-file,E401	multiple-imports-on-one-line,W605	invalid-escape-sequence,E70	,E99	syntax-error,E72	,W2	no-new-line-at-end-of-file,E703	useless-semicolon,E71	,W60	invalid-escape-sequence,E743	ambiguous-function-name,E7	,W5	doc-line-too-long,E714	not-is-test,E101	mixed-spaces-and-tabs,E711	none-comparison,E5	line-too-long,E10	mixed-spaces-and-tabs,E701	multiple-statements-on-one-line-colon,E713	not-in-test,E	,E40	,E702	multiple-statements-on-one-line-semicolon,W50	doc-line-too-long,W6	invalid-escape-sequence,E742	ambiguous-class-name,E721	type-comparison,E1	mixed-spaces-and-tabs,E9	,W	,W29	no-new-line-at-end-of-file,E74	,D410	blank-line-after-section,D103	public-function,D204	one-blank-line-after-class,D107	public-init,D212	multi-line-summary-first-line,D414	empty-docstring-section,D100	public-module,D211	no-blank-line-before-class,D400	ends-in-period,D207	no-under-indentation,D405	capitalize-section-name,D419	empty-docstring,D40	,D213	multi-line-summary-second-line,D418	overload-with-docstring,D416	section-name-ends-in-colon,D206	indent-with-spaces,D210	no-surrounding-whitespace,D402	no-signature,D300	triple-single-quotes,D1	,D10	,D30	,D202	no-blank-line-after-function,D104	public-package,D209	new-line-after-last-paragraph,D215	section-underline-not-over-indented,D408	section-underline-after-name,D403	first-line-capitalized,D417	undocumented-param,D2	,D41	,D407	dashed-underline-after-section,D106	public-nested-class,D415	ends-in-punctuation,D20	,D411	blank-line-before-section,D102	public-method,D203	one-blank-line-before-class,D21	,D301	escape-sequence-in-docstring,D200	fits-on-one-line,D409	section-underline-matches-section-length,D3	,D4	,D101	public-class,D201	no-blank-line-before-function,D208	no-over-indentation,D105	magic-method,D214	section-not-over-indented,D412	no-blank-lines-between-header-and-content,D401	non-imperative-mood,D404	docstring-starts-with-this,D406	new-line-after-section-name,D413	blank-line-after-last-section,D205	blank-line-after-summary,F631	assert-tuple,F811	redefined-while-unused,F522	string-dot-format-extra-named-arguments,F523	string-dot-format-extra-positional-arguments,F822	undefined-export,F401	unused-import,F52	,F405	import-star-usage,F704	yield-outside-function,F821	undefined-name,F823	undefined-local,F722	forward-annotation-syntax-error,F506	percent-format-mixed-positional-and-named,F407	future-feature-not-defined,F402	import-shadowed-by-loop-var,F508	percent-format-star-requires-sequence,F633	invalid-print-syntax,F842	unused-annotation,F507	percent-format-positional-count-mismatch,F901	raise-not-implemented,F406	import-star-not-permitted,F622	two-starred-expressions,F5	,F541	f-string-missing-placeholders,F701	break-outside-loop,F707	default-except-not-last,F70	,F8	,F601	multi-value-repeated-key-literal,F634	if-tuple,F504	percent-format-extra-named-arguments,F505	percent-format-missing-argument,F63	,F50	,F403	import-star,F502	percent-format-expected-mapping,F632	is-literal,F7	,F509	percent-format-unsupported-format-character,F706	return-outside-function,F81	redefined-while-unused,F524	string-dot-format-missing-arguments,F4	,F72	forward-annotation-syntax-error,F84	,F54	f-string-missing-placeholders,F702	continue-outside-loop,F82	,F404	late-future-import,F503	percent-format-expected-sequence,F60	,F621	expressions-in-star-assignment,F841	unused-variable,F602	multi-value-repeated-key-variable,F501	percent-format-invalid-format,F525	string-dot-format-mixing-automatic,F62	,F6	,F9	raise-not-implemented,F40	,F90	raise-not-implemented,F521	string-dot-format-invalid-format,PGH0	,PGH001	no-eval,PGH002	deprecated-log-warn,PGH004	blanket-noqa,PGH003	blanket-type-ignore,PGH00	,PLE	,PLR09	,PLE130	bad-string-format-type,PLR091	,PLW29	redefined-loop-name,PLE0100	yield-in-init,PLR2004	magic-value-comparison,PLW290	redefined-loop-name,PLR0915	too-many-statements,PLC300	unnecessary-direct-lambda-call,PLR02	property-with-parameters,PLR0206	property-with-parameters,PLW	,PLW2	redefined-loop-name,PLR172	consider-using-sys-exit,PLE011	,PLC04	useless-import-alias,PLE0118	used-prior-global-declaration,PLR	,PLC0	useless-import-alias,PLE12	,PLE1	,PLE250	bidirectional-unicode,PLC30	unnecessary-direct-lambda-call,PLE13	,PLE0605	invalid-all-format,PLR0911	too-many-return-statements,PLE1206	logging-too-few-args,PLR1722	consider-using-sys-exit,PLW2901	redefined-loop-name,PLC041	useless-import-alias,PLE060	,PLR200	magic-value-comparison,PLW01	useless-else-on-loop,PLW012	useless-else-on-loop,PLR20	magic-value-comparison,PLW060	global-variable-not-assigned,PLE25	bidirectional-unicode,PLE1142	await-outside-async,PLE1205	logging-too-many-args,PLC3002	unnecessary-direct-lambda-call,PLR0913	too-many-arguments,PLW0	,PLR01	comparison-of-constant,PLR1	,PLR0912	too-many-branches,PLR013	comparison-of-constant,PLW0120	useless-else-on-loop,PLE1307	bad-string-format-type,PLE06	,PLE114	await-outside-async,PLE120	,PLC0414	useless-import-alias,PLR0402	consider-using-from-import,PLE0117	nonlocal-without-binding,PLR1701	consider-merging-isinstance,PLR0	,PLR020	property-with-parameters,PLW06	global-variable-not-assigned,PLC3	unnecessary-direct-lambda-call,PLE010	,PLE11	await-outside-async,PLE1310	bad-str-strip-call,PLR17	,PLR04	consider-using-from-import,PLR040	consider-using-from-import,PLE2502	bidirectional-unicode,PLE0604	invalid-all-object,PLE01	,PLC	,PLE131	bad-str-strip-call,PLE0101	return-in-init,PLR0133	comparison-of-constant,PLR2	magic-value-comparison,PLW0602	global-variable-not-assigned,PLE0	,PLE2	bidirectional-unicode,PLR170	consider-merging-isinstance,UP023	rewrite-c-element-tree,UP02	,UP012	unnecessary-encode-utf8,UP007	typing-union,UP018	native-literals,UP026	rewrite-mock-import,UP036	outdated-version-block,UP014	convert-named-tuple-functional-to-class,UP017	datetime-timezone-utc,UP020	open-alias,UP034	extraneous-parentheses,UP00	,UP030	format-literals,UP033	functools-cache,UP028	rewrite-yield-from,UP008	super-call-with-parameters,UP001	useless-metaclass-type,UP006	deprecated-collection-type,UP010	unnecessary-future-import,UP011	lru-cache-without-parameters,UP025	rewrite-unicode-literal,UP037	quoted-annotation,UP0	,UP029	unnecessary-builtin-import,UP01	,UP03	,UP005	deprecated-unittest-alias,UP003	type-of-primitive,UP024	os-error-alias,UP004	useless-object-inheritance,UP013	convert-typed-dict-functional-to-class,UP021	replace-universal-newlines,UP027	rewrite-list-comprehension,UP031	printf-string-formatting,UP032	f-string,UP022	replace-stdout-stderr,UP009	utf8-encoding-declaration,UP015	redundant-open-modes,UP019	typing-text-str-alias,UP035	import-replacements,RUF002	ambiguous-unicode-character-docstring,RUF100	unused-noqa,RUF006	asyncio-dangling-task,RUF004	keyword-argument-before-star-argument,RUF001	ambiguous-unicode-character-string,RUF1	unused-noqa,RUF005	unpack-instead-of-concatenating-to-collection-literal,RUF003	ambiguous-unicode-character-comment,RUF0	,RUF00	,RUF10	unused-noqa,TRY2	,TRY401	verbose-log-message,TRY4	,TRY300	try-consider-else,TRY201	verbose-raise,TRY002	raise-vanilla-class,TRY3	,TRY301	raise-within-try,TRY40	,TRY0	,TRY00	,TRY004	prefer-type-error,TRY400	error-instead-of-exception,TRY30	,TRY20	,TRY003	raise-vanilla-args,TRY200	reraise-no-cause}"
complete -c ruff -n "__fish_seen_subcommand_from check" -l ignore -d 'Comma-separated list of rule codes to disable' -r -f -a "{ALL	all rules,F	Pyflakes,C90	mccabe,I	isort,N	pep8-naming,D	pydocstyle,UP	pyupgrade,YTT	flake8-2020,ANN	flake8-annotations,S	flake8-bandit,BLE	flake8-blind-except,FBT	flake8-boolean-trap,B	flake8-bugbear,A	flake8-builtins,COM	flake8-commas,C4	flake8-comprehensions,DTZ	flake8-datetimez,T10	flake8-debugger,DJ	flake8-django,EM	flake8-errmsg,EXE	flake8-executable,ISC	flake8-implicit-str-concat,ICN	flake8-import-conventions,G	flake8-logging-format,INP	flake8-no-pep420,PIE	flake8-pie,T20	flake8-print,PYI	flake8-pyi,PT	flake8-pytest-style,Q	flake8-quotes,RSE	flake8-raise,RET	flake8-return,SLF	flake8-self,SIM	flake8-simplify,TID	flake8-tidy-imports,TCH	flake8-type-checking,ARG	flake8-unused-arguments,PTH	flake8-use-pathlib,ERA	eradicate,PD	pandas-vet,PGH	pygrep-hooks,PL	Pylint,TRY	tryceratops,NPY	NumPy-specific rules,RUF	Ruff-specific rules,ERA00	commented-out-code,ERA001	commented-out-code,ERA0	commented-out-code,YTT2	,YTT301	sys-version0-referenced,YTT302	sys-version-cmp-str10,YTT204	sys-version-info-minor-cmp-int,YTT1	,YTT10	,YTT30	,YTT201	sys-version-info0-eq3-referenced,YTT3	,YTT303	sys-version-slice1-referenced,YTT20	,YTT202	six-py3-referenced,YTT103	sys-version-cmp-str3,YTT203	sys-version-info1-cmp-int,YTT102	sys-version2-referenced,YTT101	sys-version-slice3-referenced,ANN102	missing-type-cls,ANN206	missing-return-type-class-method,ANN00	,ANN10	,ANN001	missing-type-function-argument,ANN003	missing-type-kwargs,ANN1	,ANN201	missing-return-type-public-function,ANN40	any-type,ANN2	,ANN101	missing-type-self,ANN4	any-type,ANN0	,ANN202	missing-return-type-private-function,ANN205	missing-return-type-static-method,ANN401	any-type,ANN20	,ANN002	missing-type-args,ANN204	missing-return-type-special-method,S324	hashlib-insecure-hash-function,S104	hardcoded-bind-all-interfaces,S509	snmp-weak-cryptography,S608	hardcoded-sql-expression,S113	request-without-timeout,S110	try-except-pass,S508	snmp-insecure-version,S10	,S32	hashlib-insecure-hash-function,S112	try-except-continue,S701	jinja2-autoescape-false,S61	logging-config-insecure-listen,S102	exec-builtin,S6	,S70	jinja2-autoescape-false,S5	,S3	hashlib-insecure-hash-function,S1	,S60	hardcoded-sql-expression,S7	jinja2-autoescape-false,S105	hardcoded-password-string,S101	assert,S103	bad-file-permissions,S501	request-with-no-cert-validation,S106	hardcoded-password-func-arg,S506	unsafe-yaml-load,S612	logging-config-insecure-listen,S107	hardcoded-password-default,S50	,S108	hardcoded-temp-file,S11	,BLE0	blind-except,BLE001	blind-except,BLE00	blind-except,FBT001	boolean-positional-arg-in-function-definition,FBT003	boolean-positional-value-in-function-call,FBT002	boolean-default-value-in-function-definition,FBT0	,FBT00	,B005	strip-with-multi-characters,B009	get-attr-with-constant,B023	function-uses-loop-variable,B013	redundant-tuple-in-exception-handler,B018	useless-expression,B024	abstract-base-class-without-abstract-method,B0	,B022	useless-contextlib-suppress,B02	,B03	unintentional-type-annotation,B002	unary-prefix-increment,B016	cannot-raise-literal,B007	unused-loop-control-variable,B011	assert-false,B9	,B00	,B014	duplicate-handler-exception,B019	cached-instance-method,B032	unintentional-type-annotation,B021	f-string-docstring,B01	,B904	raise-without-from-inside-except,B025	duplicate-try-block-exception,B012	jump-statement-in-finally,B90	,B010	set-attr-with-constant,B027	empty-method-without-abstract-decorator,B003	assignment-to-os-environ,B004	unreliable-callable-check,B020	loop-variable-overrides-iterator,B905	zip-without-explicit-strict,B026	star-arg-unpacking-after-keyword-arg,B006	mutable-argument-default,B008	function-call-argument-default,B017	assert-raises-exception,B029	except-with-empty-tuple,B015	useless-comparison,A0	,A00	,A001	builtin-variable-shadowing,A002	builtin-argument-shadowing,A003	builtin-attribute-shadowing,COM819	trailing-comma-prohibited,COM8	,COM812	trailing-comma-missing,COM81	,COM818	trailing-comma-on-bare-tuple-prohibited,C417	unnecessary-map,C410	unnecessary-literal-within-list-call,C413	unnecessary-call-around-sorted,C400	unnecessary-generator-list,C402	unnecessary-generator-dict,C411	unnecessary-list-call,C405	unnecessary-literal-set,C415	unnecessary-subscript-reversal,C401	unnecessary-generator-set,C408	unnecessary-collection-call,C406	unnecessary-literal-dict,C40	,C404	unnecessary-list-comprehension-dict,C409	unnecessary-literal-within-tuple-call,C416	unnecessary-comprehension,C41	,C403	unnecessary-list-comprehension-set,C414	unnecessary-double-cast-or-process,DTZ005	call-datetime-now-without-tzinfo,DTZ012	call-date-fromtimestamp,DTZ007	call-datetime-strptime-without-zone,DTZ001	call-datetime-without-tzinfo,DTZ00	,DTZ011	call-date-today,DTZ003	call-datetime-utcnow,DTZ0	,DTZ01	,DTZ006	call-datetime-fromtimestamp,DTZ002	call-datetime-today,DTZ004	call-datetime-utcfromtimestamp,T100	debugger,DJ008	model-without-dunder-str,DJ001	nullable-model-string-field,DJ0	,DJ00	,DJ01	non-leading-receiver-decorator,DJ013	non-leading-receiver-decorator,EM102	f-string-in-exception,EM103	dot-format-in-exception,EM1	,EM101	raw-string-in-exception,EM10	,EXE001	shebang-not-executable,EXE003	shebang-python,EXE004	shebang-whitespace,EXE005	shebang-newline,EXE0	,EXE00	,EXE002	shebang-missing-executable-file,ISC002	multi-line-implicit-string-concatenation,ISC001	single-line-implicit-string-concatenation,ISC0	,ISC00	,ISC003	explicit-string-concatenation,ICN00	unconventional-import-alias,ICN0	unconventional-import-alias,ICN001	unconventional-import-alias,G004	logging-f-string,G001	logging-string-format,G2	,G00	,G202	logging-redundant-exc-info,G01	logging-warn,G002	logging-percent-format,G101	logging-extra-attr-clash,G003	logging-string-concat,G010	logging-warn,G20	,G10	logging-extra-attr-clash,G201	logging-exc-info,G0	,G1	logging-extra-attr-clash,INP001	implicit-namespace-package,INP0	implicit-namespace-package,INP00	implicit-namespace-package,PIE8	,PIE807	prefer-list-builtin,PIE80	,PIE81	single-starts-ends-with,PIE7	,PIE794	dupe-class-field-definitions,PIE810	single-starts-ends-with,PIE800	unnecessary-spread,PIE79	,PIE804	unnecessary-dict-kwargs,PIE790	unnecessary-pass,PIE796	prefer-unique-enums,T201	print-found,T203	p-print-found,PYI007	unrecognized-platform-check,PYI001	prefix-type-params,PYI008	unrecognized-platform-name,PYI0	,PYI00	,PT018	composite-assertion,PT008	patch-with-lambda,PT010	raises-without-exception,PT009	unittest-assertion,PT020	deprecated-yield-fixture,PT023	incorrect-mark-parentheses-style,PT013	incorrect-pytest-import,PT011	raises-too-broad,PT022	useless-yield-fixture,PT00	,PT016	fail-without-message,PT026	use-fixtures-without-parameters,PT007	parametrize-values-wrong-type,PT012	raises-with-multiple-statements,PT02	,PT024	unnecessary-asyncio-mark-on-fixture,PT004	missing-fixture-name-underscore,PT019	fixture-param-without-value,PT01	,PT005	incorrect-fixture-name-underscore,PT001	incorrect-fixture-parentheses-style,PT006	parametrize-names-wrong-type,PT002	fixture-positional-args,PT015	assert-always-false,PT021	fixture-finalizer-callback,PT025	erroneous-use-fixtures-on-fixture,PT003	extraneous-scope-function,PT0	,PT017	assert-in-except,Q001	bad-quotes-multiline-string,Q002	bad-quotes-docstring,Q003	avoidable-escaped-quote,Q0	,Q00	,Q000	bad-quotes-inline-string,RSE102	unnecessary-paren-on-raise-exception,RSE1	unnecessary-paren-on-raise-exception,RSE10	unnecessary-paren-on-raise-exception,RET503	implicit-return,RET5	,RET508	superfluous-else-break,RET501	unnecessary-return-none,RET50	,RET502	implicit-return-value,RET507	superfluous-else-continue,RET504	unnecessary-assign,RET505	superfluous-else-return,RET506	superfluous-else-raise,SLF0	private-member-access,SLF001	private-member-access,SLF00	private-member-access,SIM221	a-or-not-a,SIM108	use-ternary-operator,SIM110	reimplemented-builtin,SIM300	yoda-conditions,SIM211	if-expr-with-false-true,SIM101	duplicate-isinstance-call,SIM118	key-in-dict,SIM114	if-with-same-arms,SIM112	use-capital-environment-variables,SIM115	open-file-with-context-handler,SIM223	and-false,SIM220	a-and-not-a,SIM10	,SIM22	,SIM3	yoda-conditions,SIM107	return-in-try-except-finally,SIM210	if-expr-with-true-false,SIM102	collapsible-if,SIM21	,SIM105	use-contextlib-suppress,SIM117	multiple-with-statements,SIM1	,SIM40	dict-get-with-default,SIM4	dict-get-with-default,SIM208	double-negation,SIM103	needless-bool,SIM401	dict-get-with-default,SIM30	yoda-conditions,SIM212	if-expr-with-twisted-arms,SIM116	manual-dict-lookup,SIM20	,SIM201	negate-equal-op,SIM109	compare-with-tuple,SIM11	,SIM222	or-true,SIM202	negate-not-equal-op,SIM2	,TID251	banned-api,TID252	relative-imports,TID2	,TID25	,TCH00	,TCH001	typing-only-first-party-import,TCH002	typing-only-third-party-import,TCH0	,TCH003	typing-only-standard-library-import,TCH004	runtime-import-in-type-checking-block,TCH005	empty-type-checking-block,ARG001	unused-function-argument,ARG003	unused-class-method-argument,ARG004	unused-static-method-argument,ARG005	unused-lambda-argument,ARG0	,ARG002	unused-method-argument,ARG00	,PTH1	,PTH121	pathlib-samefile,PTH122	pathlib-splitext,PTH103	pathlib-makedirs,PTH110	pathlib-exists,PTH112	pathlib-is-dir,PTH119	pathlib-basename,PTH104	pathlib-rename,PTH101	pathlib-chmod,PTH124	pathlib-py-path,PTH108	pathlib-unlink,PTH105	pathlib-replace,PTH115	pathlib-readlink,PTH118	pathlib-join,PTH123	pathlib-open,PTH120	pathlib-dirname,PTH109	pathlib-getcwd,PTH100	pathlib-abspath,PTH11	,PTH113	pathlib-is-file,PTH114	pathlib-is-link,PTH107	pathlib-remove,PTH106	pathlib-rmdir,PTH117	pathlib-is-abs,PTH102	pathlib-mkdir,PTH116	pathlib-stat,PTH111	pathlib-expanduser,PTH10	,PTH12	,I002	missing-required-import,I0	,I001	unsorted-imports,I00	,C901	complex-structure,NPY00	,NPY001	numpy-deprecated-type-alias,NPY002	numpy-legacy-random,NPY0	,N813	camelcase-imported-as-lowercase,N814	camelcase-imported-as-constant,N9	invalid-module-name,N816	mixed-case-variable-in-global-scope,N999	invalid-module-name,N811	constant-imported-as-non-constant,N99	invalid-module-name,N801	invalid-class-name,N817	camelcase-imported-as-acronym,N803	invalid-argument-name,N8	,N80	,N807	dunder-function-name,N818	error-suffix-on-exception-name,N802	invalid-function-name,N804	invalid-first-argument-name-for-class-method,N812	lowercase-imported-as-non-lowercase,N815	mixed-case-variable-in-class-scope,N81	,N806	non-lowercase-variable-in-function,N805	invalid-first-argument-name-for-method,PD015	use-of-pd-merge,PD013	use-of-dot-stack,PD901	df-is-a-bad-variable-name,PD00	,PD008	use-of-dot-at,PD009	use-of-dot-iat,PD011	use-of-dot-values,PD9	df-is-a-bad-variable-name,PD004	use-of-dot-not-null,PD012	use-of-dot-read-table,PD01	,PD003	use-of-dot-is-null,PD007	use-of-dot-ix,PD0	,PD002	use-of-inplace-argument,PD010	use-of-dot-pivot-or-unstack,PD90	df-is-a-bad-variable-name,E999	syntax-error,E73	lambda-assignment,E712	true-false-comparison,E501	line-too-long,E90	io-error,E402	module-import-not-at-top-of-file,E741	ambiguous-variable-name,E902	io-error,E4	,W505	doc-line-too-long,E731	lambda-assignment,E722	bare-except,E50	line-too-long,W292	no-new-line-at-end-of-file,E401	multiple-imports-on-one-line,W605	invalid-escape-sequence,E70	,E99	syntax-error,E72	,W2	no-new-line-at-end-of-file,E703	useless-semicolon,E71	,W60	invalid-escape-sequence,E743	ambiguous-function-name,E7	,W5	doc-line-too-long,E714	not-is-test,E101	mixed-spaces-and-tabs,E711	none-comparison,E5	line-too-long,E10	mixed-spaces-and-tabs,E701	multiple-statements-on-one-line-colon,E713	not-in-test,E	,E40	,E702	multiple-statements-on-one-line-semicolon,W50	doc-line-too-long,W6	invalid-escape-sequence,E742	ambiguous-class-name,E721	type-comparison,E1	mixed-spaces-and-tabs,E9	,W	,W29	no-new-line-at-end-of-file,E74	,D410	blank-line-after-section,D103	public-function,D204	one-blank-line-after-class,D107	public-init,D212	multi-line-summary-first-line,D414	empty-docstring-section,D100	public-module,D211	no-blank-line-before-class,D400	ends-in-period,D207	no-under-indentation,D405	capitalize-section-name,D419	empty-docstring,D40	,D213	multi-line-summary-second-line,D418	overload-with-docstring,D416	section-name-ends-in-colon,D206	indent-with-spaces,D210	no-surrounding-whitespace,D402	no-signature,D300	triple-single-quotes,D1	,D10	,D30	,D202	no-blank-line-after-function,D104	public-package,D209	new-line-after-last-paragraph,D215	section-underline-not-over-indented,D408	section-underline-after-name,D403	first-line-capitalized,D417	undocumented-param,D2	,D41	,D407	dashed-underline-after-section,D106	public-nested-class,D415	ends-in-punctuation,D20	,D411	blank-line-before-section,D102	public-method,D203	one-blank-line-before-class,D21	,D301	escape-sequence-in-docstring,D200	fits-on-one-line,D409	section-underline-matches-section-length,D3	,D4	,D101	public-class,D201	no-blank-line-before-function,D208	no-over-indentation,D105	magic-method,D214	section-not-over-indented,D412	no-blank-lines-between-header-and-content,D401	non-imperative-mood,D404	docstring-starts-with-this,D406	new-line-after-section-name,D413	blank-line-after-last-section,D205	blank-line-after-summary,F631	assert-tuple,F811	redefined-while-unused,F522	string-dot-format-extra-named-arguments,F523	string-dot-format-extra-positional-arguments,F822	undefined-export,F401	unused-import,F52	,F405	import-star-usage,F704	yield-outside-function,F821	undefined-name,F823	undefined-local,F722	forward-annotation-syntax-error,F506	percent-format-mixed-positional-and-named,F407	future-feature-not-defined,F402	import-shadowed-by-loop-var,F508	percent-format-star-requires-sequence,F633	invalid-print-syntax,F842	unused-annotation,F507	percent-format-positional-count-mismatch,F901	raise-not-implemented,F406	import-star-not-permitted,F622	two-starred-expressions,F5	,F541	f-string-missing-placeholders,F701	break-outside-loop,F707	default-except-not-last,F70	,F8	,F601	multi-value-repeated-key-literal,F634	if-tuple,F504	percent-format-extra-named-arguments,F505	percent-format-missing-argument,F63	,F50	,F403	import-star,F502	percent-format-expected-mapping,F632	is-literal,F7	,F509	percent-format-unsupported-format-character,F706	return-outside-function,F81	redefined-while-unused,F524	string-dot-format-missing-arguments,F4	,F72	forward-annotation-syntax-error,F84	,F54	f-string-missing-placeholders,F702	continue-outside-loop,F82	,F404	late-future-import,F503	percent-format-expected-sequence,F60	,F621	expressions-in-star-assignment,F841	unused-variable,F602	multi-value-repeated-key-variable,F501	percent-format-invalid-format,F525	string-dot-format-mixing-automatic,F62	,F6	,F9	raise-not-implemented,F40	,F90	raise-not-implemented,F521	string-dot-format-invalid-format,PGH0	,PGH001	no-eval,PGH002	deprecated-log-warn,PGH004	blanket-noqa,PGH003	blanket-type-ignore,PGH00	,PLE	,PLR09	,PLE130	bad-string-format-type,PLR091	,PLW29	redefined-loop-name,PLE0100	yield-in-init,PLR2004	magic-value-comparison,PLW290	redefined-loop-name,PLR0915	too-many-statements,PLC300	unnecessary-direct-lambda-call,PLR02	property-with-parameters,PLR0206	property-with-parameters,PLW	,PLW2	redefined-loop-name,PLR172	consider-using-sys-exit,PLE011	,PLC04	useless-import-alias,PLE0118	used-prior-global-declaration,PLR	,PLC0	useless-import-alias,PLE12	,PLE1	,PLE250	bidirectional-unicode,PLC30	unnecessary-direct-lambda-call,PLE13	,PLE0605	invalid-all-format,PLR0911	too-many-return-statements,PLE1206	logging-too-few-args,PLR1722	consider-using-sys-exit,PLW2901	redefined-loop-name,PLC041	useless-import-alias,PLE060	,PLR200	magic-value-comparison,PLW01	useless-else-on-loop,PLW012	useless-else-on-loop,PLR20	magic-value-comparison,PLW060	global-variable-not-assigned,PLE25	bidirectional-unicode,PLE1142	await-outside-async,PLE1205	logging-too-many-args,PLC3002	unnecessary-direct-lambda-call,PLR0913	too-many-arguments,PLW0	,PLR01	comparison-of-constant,PLR1	,PLR0912	too-many-branches,PLR013	comparison-of-constant,PLW0120	useless-else-on-loop,PLE1307	bad-string-format-type,PLE06	,PLE114	await-outside-async,PLE120	,PLC0414	useless-import-alias,PLR0402	consider-using-from-import,PLE0117	nonlocal-without-binding,PLR1701	consider-merging-isinstance,PLR0	,PLR020	property-with-parameters,PLW06	global-variable-not-assigned,PLC3	unnecessary-direct-lambda-call,PLE010	,PLE11	await-outside-async,PLE1310	bad-str-strip-call,PLR17	,PLR04	consider-using-from-import,PLR040	consider-using-from-import,PLE2502	bidirectional-unicode,PLE0604	invalid-all-object,PLE01	,PLC	,PLE131	bad-str-strip-call,PLE0101	return-in-init,PLR0133	comparison-of-constant,PLR2	magic-value-comparison,PLW0602	global-variable-not-assigned,PLE0	,PLE2	bidirectional-unicode,PLR170	consider-merging-isinstance,UP023	rewrite-c-element-tree,UP02	,UP012	unnecessary-encode-utf8,UP007	typing-union,UP018	native-literals,UP026	rewrite-mock-import,UP036	outdated-version-block,UP014	convert-named-tuple-functional-to-class,UP017	datetime-timezone-utc,UP020	open-alias,UP034	extraneous-parentheses,UP00	,UP030	format-literals,UP033	functools-cache,UP028	rewrite-yield-from,UP008	super-call-with-parameters,UP001	useless-metaclass-type,UP006	deprecated-collection-type,UP010	unnecessary-future-import,UP011	lru-cache-without-parameters,UP025	rewrite-unicode-literal,UP037	quoted-annotation,UP0	,UP029	unnecessary-builtin-import,UP01	,UP03	,UP005	deprecated-unittest-alias,UP003	type-of-primitive,UP024	os-error-alias,UP004	useless-object-inheritance,UP013	convert-typed-dict-functional-to-class,UP021	replace-universal-newlines,UP027	rewrite-list-comprehension,UP031	printf-string-formatting,UP032	f-string,UP022	replace-stdout-stderr,UP009	utf8-encoding-declaration,UP015	redundant-open-modes,UP019	typing-text-str-alias,UP035	import-replacements,RUF002	ambiguous-unicode-character-docstring,RUF100	unused-noqa,RUF006	asyncio-dangling-task,RUF004	keyword-argument-before-star-argument,RUF001	ambiguous-unicode-character-string,RUF1	unused-noqa,RUF005	unpack-instead-of-concatenating-to-collection-literal,RUF003	ambiguous-unicode-character-comment,RUF0	,RUF00	,RUF10	unused-noqa,TRY2	,TRY401	verbose-log-message,TRY4	,TRY300	try-consider-else,TRY201	verbose-raise,TRY002	raise-vanilla-class,TRY3	,TRY301	raise-within-try,TRY40	,TRY0	,TRY00	,TRY004	prefer-type-error,TRY400	error-instead-of-exception,TRY30	,TRY20	,TRY003	raise-vanilla-args,TRY200	reraise-no-cause}"
complete -c ruff -n "__fish_seen_subcommand_from check" -l extend-select -d 'Like --select, but adds additional rule codes on top of the selected ones' -r -f -a "{ALL	all rules,F	Pyflakes,C90	mccabe,I	isort,N	pep8-naming,D	pydocstyle,UP	pyupgrade,YTT	flake8-2020,ANN	flake8-annotations,S	flake8-bandit,BLE	flake8-blind-except,FBT	flake8-boolean-trap,B	flake8-bugbear,A	flake8-builtins,COM	flake8-commas,C4	flake8-comprehensions,DTZ	flake8-datetimez,T10	flake8-debugger,DJ	flake8-django,EM	flake8-errmsg,EXE	flake8-executable,ISC	flake8-implicit-str-concat,ICN	flake8-import-conventions,G	flake8-logging-format,INP	flake8-no-pep420,PIE	flake8-pie,T20	flake8-print,PYI	flake8-pyi,PT	flake8-pytest-style,Q	flake8-quotes,RSE	flake8-raise,RET	flake8-return,SLF	flake8-self,SIM	flake8-simplify,TID	flake8-tidy-imports,TCH	flake8-type-checking,ARG	flake8-unused-arguments,PTH	flake8-use-pathlib,ERA	eradicate,PD	pandas-vet,PGH	pygrep-hooks,PL	Pylint,TRY	tryceratops,NPY	NumPy-specific rules,RUF	Ruff-specific rules,ERA00	commented-out-code,ERA001	commented-out-code,ERA0	commented-out-code,YTT2	,YTT301	sys-version0-referenced,YTT302	sys-version-cmp-str10,YTT204	sys-version-info-minor-cmp-int,YTT1	,YTT10	,YTT30	,YTT201	sys-version-info0-eq3-referenced,YTT3	,YTT303	sys-version-slice1-referenced,YTT20	,YTT202	six-py3-referenced,YTT103	sys-version-cmp-str3,YTT203	sys-version-info1-cmp-int,YTT102	sys-version2-referenced,YTT101	sys-version-slice3-referenced,ANN102	missing-type-cls,ANN206	missing-return-type-class-method,ANN00	,ANN10	,ANN001	missing-type-function-argument,ANN003	missing-type-kwargs,ANN1	,ANN201	missing-return-type-public-function,ANN40	any-type,ANN2	,ANN101	missing-type-self,ANN4	any-type,ANN0	,ANN202	missing-return-type-private-function,ANN205	missing-return-type-static-method,ANN401	any-type,ANN20	,ANN002	missing-type-args,ANN204	missing-return-type-special-method,S324	hashlib-insecure-hash-function,S104	hardcoded-bind-all-interfaces,S509	snmp-weak-cryptography,S608	hardcoded-sql-expression,S113	request-without-timeout,S110	try-except-pass,S508	snmp-insecure-version,S10	,S32	hashlib-insecure-hash-function,S112	try-except-continue,S701	jinja2-autoescape-false,S61	logging-config-insecure-listen,S102	exec-builtin,S6	,S70	jinja2-autoescape-false,S5	,S3	hashlib-insecure-hash-function,S1	,S60	hardcoded-sql-expression,S7	jinja2-autoescape-false,S105	hardcoded-password-string,S101	assert,S103	bad-file-permissions,S501	request-with-no-cert-validation,S106	hardcoded-password-func-arg,S506	unsafe-yaml-load,S612	logging-config-insecure-listen,S107	hardcoded-password-default,S50	,S108	hardcoded-temp-file,S11	,BLE0	blind-except,BLE001	blind-except,BLE00	blind-except,FBT001	boolean-positional-arg-in-function-definition,FBT003	boolean-positional-value-in-function-call,FBT002	boolean-default-value-in-function-definition,FBT0	,FBT00	,B005	strip-with-multi-characters,B009	get-attr-with-constant,B023	function-uses-loop-variable,B013	redundant-tuple-in-exception-handler,B018	useless-expression,B024	abstract-base-class-without-abstract-method,B0	,B022	useless-contextlib-suppress,B02	,B03	unintentional-type-annotation,B002	unary-prefix-increment,B016	cannot-raise-literal,B007	unused-loop-control-variable,B011	assert-false,B9	,B00	,B014	duplicate-handler-exception,B019	cached-instance-method,B032	unintentional-type-annotation,B021	f-string-docstring,B01	,B904	raise-without-from-inside-except,B025	duplicate-try-block-exception,B012	jump-statement-in-finally,B90	,B010	set-attr-with-constant,B027	empty-method-without-abstract-decorator,B003	assignment-to-os-environ,B004	unreliable-callable-check,B020	loop-variable-overrides-iterator,B905	zip-without-explicit-strict,B026	star-arg-unpacking-after-keyword-arg,B006	mutable-argument-default,B008	function-call-argument-default,B017	assert-raises-exception,B029	except-with-empty-tuple,B015	useless-comparison,A0	,A00	,A001	builtin-variable-shadowing,A002	builtin-argument-shadowing,A003	builtin-attribute-shadowing,COM819	trailing-comma-prohibited,COM8	,COM812	trailing-comma-missing,COM81	,COM818	trailing-comma-on-bare-tuple-prohibited,C417	unnecessary-map,C410	unnecessary-literal-within-list-call,C413	unnecessary-call-around-sorted,C400	unnecessary-generator-list,C402	unnecessary-generator-dict,C411	unnecessary-list-call,C405	unnecessary-literal-set,C415	unnecessary-subscript-reversal,C401	unnecessary-generator-set,C408	unnecessary-collection-call,C406	unnecessary-literal-dict,C40	,C404	unnecessary-list-comprehension-dict,C409	unnecessary-literal-within-tuple-call,C416	unnecessary-comprehension,C41	,C403	unnecessary-list-comprehension-set,C414	unnecessary-double-cast-or-process,DTZ005	call-datetime-now-without-tzinfo,DTZ012	call-date-fromtimestamp,DTZ007	call-datetime-strptime-without-zone,DTZ001	call-datetime-without-tzinfo,DTZ00	,DTZ011	call-date-today,DTZ003	call-datetime-utcnow,DTZ0	,DTZ01	,DTZ006	call-datetime-fromtimestamp,DTZ002	call-datetime-today,DTZ004	call-datetime-utcfromtimestamp,T100	debugger,DJ008	model-without-dunder-str,DJ001	nullable-model-string-field,DJ0	,DJ00	,DJ01	non-leading-receiver-decorator,DJ013	non-leading-receiver-decorator,EM102	f-string-in-exception,EM103	dot-format-in-exception,EM1	,EM101	raw-string-in-exception,EM10	,EXE001	shebang-not-executable,EXE003	shebang-python,EXE004	shebang-whitespace,EXE005	shebang-newline,EXE0	,EXE00	,EXE002	shebang-missing-executable-file,ISC002	multi-line-implicit-string-concatenation,ISC001	single-line-implicit-string-concatenation,ISC0	,ISC00	,ISC003	explicit-string-concatenation,ICN00	unconventional-import-alias,ICN0	unconventional-import-alias,ICN001	unconventional-import-alias,G004	logging-f-string,G001	logging-string-format,G2	,G00	,G202	logging-redundant-exc-info,G01	logging-warn,G002	logging-percent-format,G101	logging-extra-attr-clash,G003	logging-string-concat,G010	logging-warn,G20	,G10	logging-extra-attr-clash,G201	logging-exc-info,G0	,G1	logging-extra-attr-clash,INP001	implicit-namespace-package,INP0	implicit-namespace-package,INP00	implicit-namespace-package,PIE8	,PIE807	prefer-list-builtin,PIE80	,PIE81	single-starts-ends-with,PIE7	,PIE794	dupe-class-field-definitions,PIE810	single-starts-ends-with,PIE800	unnecessary-spread,PIE79	,PIE804	unnecessary-dict-kwargs,PIE790	unnecessary-pass,PIE796	prefer-unique-enums,T201	print-found,T203	p-print-found,PYI007	unrecognized-platform-check,PYI001	prefix-type-params,PYI008	unrecognized-platform-name,PYI0	,PYI00	,PT018	composite-assertion,PT008	patch-with-lambda,PT010	raises-without-exception,PT009	unittest-assertion,PT020	deprecated-yield-fixture,PT023	incorrect-mark-parentheses-style,PT013	incorrect-pytest-import,PT011	raises-too-broad,PT022	useless-yield-fixture,PT00	,PT016	fail-without-message,PT026	use-fixtures-without-parameters,PT007	parametrize-values-wrong-type,PT012	raises-with-multiple-statements,PT02	,PT024	unnecessary-asyncio-mark-on-fixture,PT004	missing-fixture-name-underscore,PT019	fixture-param-without-value,PT01	,PT005	incorrect-fixture-name-underscore,PT001	incorrect-fixture-parentheses-style,PT006	parametrize-names-wrong-type,PT002	fixture-positional-args,PT015	assert-always-false,PT021	fixture-finalizer-callback,PT025	erroneous-use-fixtures-on-fixture,PT003	extraneous-scope-function,PT0	,PT017	assert-in-except,Q001	bad-quotes-multiline-string,Q002	bad-quotes-docstring,Q003	avoidable-escaped-quote,Q0	,Q00	,Q000	bad-quotes-inline-string,RSE102	unnecessary-paren-on-raise-exception,RSE1	unnecessary-paren-on-raise-exception,RSE10	unnecessary-paren-on-raise-exception,RET503	implicit-return,RET5	,RET508	superfluous-else-break,RET501	unnecessary-return-none,RET50	,RET502	implicit-return-value,RET507	superfluous-else-continue,RET504	unnecessary-assign,RET505	superfluous-else-return,RET506	superfluous-else-raise,SLF0	private-member-access,SLF001	private-member-access,SLF00	private-member-access,SIM221	a-or-not-a,SIM108	use-ternary-operator,SIM110	reimplemented-builtin,SIM300	yoda-conditions,SIM211	if-expr-with-false-true,SIM101	duplicate-isinstance-call,SIM118	key-in-dict,SIM114	if-with-same-arms,SIM112	use-capital-environment-variables,SIM115	open-file-with-context-handler,SIM223	and-false,SIM220	a-and-not-a,SIM10	,SIM22	,SIM3	yoda-conditions,SIM107	return-in-try-except-finally,SIM210	if-expr-with-true-false,SIM102	collapsible-if,SIM21	,SIM105	use-contextlib-suppress,SIM117	multiple-with-statements,SIM1	,SIM40	dict-get-with-default,SIM4	dict-get-with-default,SIM208	double-negation,SIM103	needless-bool,SIM401	dict-get-with-default,SIM30	yoda-conditions,SIM212	if-expr-with-twisted-arms,SIM116	manual-dict-lookup,SIM20	,SIM201	negate-equal-op,SIM109	compare-with-tuple,SIM11	,SIM222	or-true,SIM202	negate-not-equal-op,SIM2	,TID251	banned-api,TID252	relative-imports,TID2	,TID25	,TCH00	,TCH001	typing-only-first-party-import,TCH002	typing-only-third-party-import,TCH0	,TCH003	typing-only-standard-library-import,TCH004	runtime-import-in-type-checking-block,TCH005	empty-type-checking-block,ARG001	unused-function-argument,ARG003	unused-class-method-argument,ARG004	unused-static-method-argument,ARG005	unused-lambda-argument,ARG0	,ARG002	unused-method-argument,ARG00	,PTH1	,PTH121	pathlib-samefile,PTH122	pathlib-splitext,PTH103	pathlib-makedirs,PTH110	pathlib-exists,PTH112	pathlib-is-dir,PTH119	pathlib-basename,PTH104	pathlib-rename,PTH101	pathlib-chmod,PTH124	pathlib-py-path,PTH108	pathlib-unlink,PTH105	pathlib-replace,PTH115	pathlib-readlink,PTH118	pathlib-join,PTH123	pathlib-open,PTH120	pathlib-dirname,PTH109	pathlib-getcwd,PTH100	pathlib-abspath,PTH11	,PTH113	pathlib-is-file,PTH114	pathlib-is-link,PTH107	pathlib-remove,PTH106	pathlib-rmdir,PTH117	pathlib-is-abs,PTH102	pathlib-mkdir,PTH116	pathlib-stat,PTH111	pathlib-expanduser,PTH10	,PTH12	,I002	missing-required-import,I0	,I001	unsorted-imports,I00	,C901	complex-structure,NPY00	,NPY001	numpy-deprecated-type-alias,NPY002	numpy-legacy-random,NPY0	,N813	camelcase-imported-as-lowercase,N814	camelcase-imported-as-constant,N9	invalid-module-name,N816	mixed-case-variable-in-global-scope,N999	invalid-module-name,N811	constant-imported-as-non-constant,N99	invalid-module-name,N801	invalid-class-name,N817	camelcase-imported-as-acronym,N803	invalid-argument-name,N8	,N80	,N807	dunder-function-name,N818	error-suffix-on-exception-name,N802	invalid-function-name,N804	invalid-first-argument-name-for-class-method,N812	lowercase-imported-as-non-lowercase,N815	mixed-case-variable-in-class-scope,N81	,N806	non-lowercase-variable-in-function,N805	invalid-first-argument-name-for-method,PD015	use-of-pd-merge,PD013	use-of-dot-stack,PD901	df-is-a-bad-variable-name,PD00	,PD008	use-of-dot-at,PD009	use-of-dot-iat,PD011	use-of-dot-values,PD9	df-is-a-bad-variable-name,PD004	use-of-dot-not-null,PD012	use-of-dot-read-table,PD01	,PD003	use-of-dot-is-null,PD007	use-of-dot-ix,PD0	,PD002	use-of-inplace-argument,PD010	use-of-dot-pivot-or-unstack,PD90	df-is-a-bad-variable-name,E999	syntax-error,E73	lambda-assignment,E712	true-false-comparison,E501	line-too-long,E90	io-error,E402	module-import-not-at-top-of-file,E741	ambiguous-variable-name,E902	io-error,E4	,W505	doc-line-too-long,E731	lambda-assignment,E722	bare-except,E50	line-too-long,W292	no-new-line-at-end-of-file,E401	multiple-imports-on-one-line,W605	invalid-escape-sequence,E70	,E99	syntax-error,E72	,W2	no-new-line-at-end-of-file,E703	useless-semicolon,E71	,W60	invalid-escape-sequence,E743	ambiguous-function-name,E7	,W5	doc-line-too-long,E714	not-is-test,E101	mixed-spaces-and-tabs,E711	none-comparison,E5	line-too-long,E10	mixed-spaces-and-tabs,E701	multiple-statements-on-one-line-colon,E713	not-in-test,E	,E40	,E702	multiple-statements-on-one-line-semicolon,W50	doc-line-too-long,W6	invalid-escape-sequence,E742	ambiguous-class-name,E721	type-comparison,E1	mixed-spaces-and-tabs,E9	,W	,W29	no-new-line-at-end-of-file,E74	,D410	blank-line-after-section,D103	public-function,D204	one-blank-line-after-class,D107	public-init,D212	multi-line-summary-first-line,D414	empty-docstring-section,D100	public-module,D211	no-blank-line-before-class,D400	ends-in-period,D207	no-under-indentation,D405	capitalize-section-name,D419	empty-docstring,D40	,D213	multi-line-summary-second-line,D418	overload-with-docstring,D416	section-name-ends-in-colon,D206	indent-with-spaces,D210	no-surrounding-whitespace,D402	no-signature,D300	triple-single-quotes,D1	,D10	,D30	,D202	no-blank-line-after-function,D104	public-package,D209	new-line-after-last-paragraph,D215	section-underline-not-over-indented,D408	section-underline-after-name,D403	first-line-capitalized,D417	undocumented-param,D2	,D41	,D407	dashed-underline-after-section,D106	public-nested-class,D415	ends-in-punctuation,D20	,D411	blank-line-before-section,D102	public-method,D203	one-blank-line-before-class,D21	,D301	escape-sequence-in-docstring,D200	fits-on-one-line,D409	section-underline-matches-section-length,D3	,D4	,D101	public-class,D201	no-blank-line-before-function,D208	no-over-indentation,D105	magic-method,D214	section-not-over-indented,D412	no-blank-lines-between-header-and-content,D401	non-imperative-mood,D404	docstring-starts-with-this,D406	new-line-after-section-name,D413	blank-line-after-last-section,D205	blank-line-after-summary,F631	assert-tuple,F811	redefined-while-unused,F522	string-dot-format-extra-named-arguments,F523	string-dot-format-extra-positional-arguments,F822	undefined-export,F401	unused-import,F52	,F405	import-star-usage,F704	yield-outside-function,F821	undefined-name,F823	undefined-local,F722	forward-annotation-syntax-error,F506	percent-format-mixed-positional-and-named,F407	future-feature-not-defined,F402	import-shadowed-by-loop-var,F508	percent-format-star-requires-sequence,F633	invalid-print-syntax,F842	unused-annotation,F507	percent-format-positional-count-mismatch,F901	raise-not-implemented,F406	import-star-not-permitted,F622	two-starred-expressions,F5	,F541	f-string-missing-placeholders,F701	break-outside-loop,F707	default-except-not-last,F70	,F8	,F601	multi-value-repeated-key-literal,F634	if-tuple,F504	percent-format-extra-named-arguments,F505	percent-format-missing-argument,F63	,F50	,F403	import-star,F502	percent-format-expected-mapping,F632	is-literal,F7	,F509	percent-format-unsupported-format-character,F706	return-outside-function,F81	redefined-while-unused,F524	string-dot-format-missing-arguments,F4	,F72	forward-annotation-syntax-error,F84	,F54	f-string-missing-placeholders,F702	continue-outside-loop,F82	,F404	late-future-import,F503	percent-format-expected-sequence,F60	,F621	expressions-in-star-assignment,F841	unused-variable,F602	multi-value-repeated-key-variable,F501	percent-format-invalid-format,F525	string-dot-format-mixing-automatic,F62	,F6	,F9	raise-not-implemented,F40	,F90	raise-not-implemented,F521	string-dot-format-invalid-format,PGH0	,PGH001	no-eval,PGH002	deprecated-log-warn,PGH004	blanket-noqa,PGH003	blanket-type-ignore,PGH00	,PLE	,PLR09	,PLE130	bad-string-format-type,PLR091	,PLW29	redefined-loop-name,PLE0100	yield-in-init,PLR2004	magic-value-comparison,PLW290	redefined-loop-name,PLR0915	too-many-statements,PLC300	unnecessary-direct-lambda-call,PLR02	property-with-parameters,PLR0206	property-with-parameters,PLW	,PLW2	redefined-loop-name,PLR172	consider-using-sys-exit,PLE011	,PLC04	useless-import-alias,PLE0118	used-prior-global-declaration,PLR	,PLC0	useless-import-alias,PLE12	,PLE1	,PLE250	bidirectional-unicode,PLC30	unnecessary-direct-lambda-call,PLE13	,PLE0605	invalid-all-format,PLR0911	too-many-return-statements,PLE1206	logging-too-few-args,PLR1722	consider-using-sys-exit,PLW2901	redefined-loop-name,PLC041	useless-import-alias,PLE060	,PLR200	magic-value-comparison,PLW01	useless-else-on-loop,PLW012	useless-else-on-loop,PLR20	magic-value-comparison,PLW060	global-variable-not-assigned,PLE25	bidirectional-unicode,PLE1142	await-outside-async,PLE1205	logging-too-many-args,PLC3002	unnecessary-direct-lambda-call,PLR0913	too-many-arguments,PLW0	,PLR01	comparison-of-constant,PLR1	,PLR0912	too-many-branches,PLR013	comparison-of-constant,PLW0120	useless-else-on-loop,PLE1307	bad-string-format-type,PLE06	,PLE114	await-outside-async,PLE120	,PLC0414	useless-import-alias,PLR0402	consider-using-from-import,PLE0117	nonlocal-without-binding,PLR1701	consider-merging-isinstance,PLR0	,PLR020	property-with-parameters,PLW06	global-variable-not-assigned,PLC3	unnecessary-direct-lambda-call,PLE010	,PLE11	await-outside-async,PLE1310	bad-str-strip-call,PLR17	,PLR04	consider-using-from-import,PLR040	consider-using-from-import,PLE2502	bidirectional-unicode,PLE0604	invalid-all-object,PLE01	,PLC	,PLE131	bad-str-strip-call,PLE0101	return-in-init,PLR0133	comparison-of-constant,PLR2	magic-value-comparison,PLW0602	global-variable-not-assigned,PLE0	,PLE2	bidirectional-unicode,PLR170	consider-merging-isinstance,UP023	rewrite-c-element-tree,UP02	,UP012	unnecessary-encode-utf8,UP007	typing-union,UP018	native-literals,UP026	rewrite-mock-import,UP036	outdated-version-block,UP014	convert-named-tuple-functional-to-class,UP017	datetime-timezone-utc,UP020	open-alias,UP034	extraneous-parentheses,UP00	,UP030	format-literals,UP033	functools-cache,UP028	rewrite-yield-from,UP008	super-call-with-parameters,UP001	useless-metaclass-type,UP006	deprecated-collection-type,UP010	unnecessary-future-import,UP011	lru-cache-without-parameters,UP025	rewrite-unicode-literal,UP037	quoted-annotation,UP0	,UP029	unnecessary-builtin-import,UP01	,UP03	,UP005	deprecated-unittest-alias,UP003	type-of-primitive,UP024	os-error-alias,UP004	useless-object-inheritance,UP013	convert-typed-dict-functional-to-class,UP021	replace-universal-newlines,UP027	rewrite-list-comprehension,UP031	printf-string-formatting,UP032	f-string,UP022	replace-stdout-stderr,UP009	utf8-encoding-declaration,UP015	redundant-open-modes,UP019	typing-text-str-alias,UP035	import-replacements,RUF002	ambiguous-unicode-character-docstring,RUF100	unused-noqa,RUF006	asyncio-dangling-task,RUF004	keyword-argument-before-star-argument,RUF001	ambiguous-unicode-character-string,RUF1	unused-noqa,RUF005	unpack-instead-of-concatenating-to-collection-literal,RUF003	ambiguous-unicode-character-comment,RUF0	,RUF00	,RUF10	unused-noqa,TRY2	,TRY401	verbose-log-message,TRY4	,TRY300	try-consider-else,TRY201	verbose-raise,TRY002	raise-vanilla-class,TRY3	,TRY301	raise-within-try,TRY40	,TRY0	,TRY00	,TRY004	prefer-type-error,TRY400	error-instead-of-exception,TRY30	,TRY20	,TRY003	raise-vanilla-args,TRY200	reraise-no-cause}"
complete -c ruff -n "__fish_seen_subcommand_from check" -l extend-ignore -d 'Like --ignore. (Deprecated: You can just use --ignore instead.)' -r -f -a "{ALL	all rules,F	Pyflakes,C90	mccabe,I	isort,N	pep8-naming,D	pydocstyle,UP	pyupgrade,YTT	flake8-2020,ANN	flake8-annotations,S	flake8-bandit,BLE	flake8-blind-except,FBT	flake8-boolean-trap,B	flake8-bugbear,A	flake8-builtins,COM	flake8-commas,C4	flake8-comprehensions,DTZ	flake8-datetimez,T10	flake8-debugger,DJ	flake8-django,EM	flake8-errmsg,EXE	flake8-executable,ISC	flake8-implicit-str-concat,ICN	flake8-import-conventions,G	flake8-logging-format,INP	flake8-no-pep420,PIE	flake8-pie,T20	flake8-print,PYI	flake8-pyi,PT	flake8-pytest-style,Q	flake8-quotes,RSE	flake8-raise,RET	flake8-return,SLF	flake8-self,SIM	flake8-simplify,TID	flake8-tidy-imports,TCH	flake8-type-checking,ARG	flake8-unused-arguments,PTH	flake8-use-pathlib,ERA	eradicate,PD	pandas-vet,PGH	pygrep-hooks,PL	Pylint,TRY	tryceratops,NPY	NumPy-specific rules,RUF	Ruff-specific rules,ERA00	commented-out-code,ERA001	commented-out-code,ERA0	commented-out-code,YTT2	,YTT301	sys-version0-referenced,YTT302	sys-version-cmp-str10,YTT204	sys-version-info-minor-cmp-int,YTT1	,YTT10	,YTT30	,YTT201	sys-version-info0-eq3-referenced,YTT3	,YTT303	sys-version-slice1-referenced,YTT20	,YTT202	six-py3-referenced,YTT103	sys-version-cmp-str3,YTT203	sys-version-info1-cmp-int,YTT102	sys-version2-referenced,YTT101	sys-version-slice3-referenced,ANN102	missing-type-cls,ANN206	missing-return-type-class-method,ANN00	,ANN10	,ANN001	missing-type-function-argument,ANN003	missing-type-kwargs,ANN1	,ANN201	missing-return-type-public-function,ANN40	any-type,ANN2	,ANN101	missing-type-self,ANN4	any-type,ANN0	,ANN202	missing-return-type-private-function,ANN205	missing-return-type-static-method,ANN401	any-type,ANN20	,ANN002	missing-type-args,ANN204	missing-return-type-special-method,S324	hashlib-insecure-hash-function,S104	hardcoded-bind-all-interfaces,S509	snmp-weak-cryptography,S608	hardcoded-sql-expression,S113	request-without-timeout,S110	try-except-pass,S508	snmp-insecure-version,S10	,S32	hashlib-insecure-hash-function,S112	try-except-continue,S701	jinja2-autoescape-false,S61	logging-config-insecure-listen,S102	exec-builtin,S6	,S70	jinja2-autoescape-false,S5	,S3	hashlib-insecure-hash-function,S1	,S60	hardcoded-sql-expression,S7	jinja2-autoescape-false,S105	hardcoded-password-string,S101	assert,S103	bad-file-permissions,S501	request-with-no-cert-validation,S106	hardcoded-password-func-arg,S506	unsafe-yaml-load,S612	logging-config-insecure-listen,S107	hardcoded-password-default,S50	,S108	hardcoded-temp-file,S11	,BLE0	blind-except,BLE001	blind-except,BLE00	blind-except,FBT001	boolean-positional-arg-in-function-definition,FBT003	boolean-positional-value-in-function-call,FBT002	boolean-default-value-in-function-definition,FBT0	,FBT00	,B005	strip-with-multi-characters,B009	get-attr-with-constant,B023	function-uses-loop-variable,B013	redundant-tuple-in-exception-handler,B018	useless-expression,B024	abstract-base-class-without-abstract-method,B0	,B022	useless-contextlib-suppress,B02	,B03	unintentional-type-annotation,B002	unary-prefix-increment,B016	cannot-raise-literal,B007	unused-loop-control-variable,B011	assert-false,B9	,B00	,B014	duplicate-handler-exception,B019	cached-instance-method,B032	unintentional-type-annotation,B021	f-string-docstring,B01	,B904	raise-without-from-inside-except,B025	duplicate-try-block-exception,B012	jump-statement-in-finally,B90	,B010	set-attr-with-constant,B027	empty-method-without-abstract-decorator,B003	assignment-to-os-environ,B004	unreliable-callable-check,B020	loop-variable-overrides-iterator,B905	zip-without-explicit-strict,B026	star-arg-unpacking-after-keyword-arg,B006	mutable-argument-default,B008	function-call-argument-default,B017	assert-raises-exception,B029	except-with-empty-tuple,B015	useless-comparison,A0	,A00	,A001	builtin-variable-shadowing,A002	builtin-argument-shadowing,A003	builtin-attribute-shadowing,COM819	trailing-comma-prohibited,COM8	,COM812	trailing-comma-missing,COM81	,COM818	trailing-comma-on-bare-tuple-prohibited,C417	unnecessary-map,C410	unnecessary-literal-within-list-call,C413	unnecessary-call-around-sorted,C400	unnecessary-generator-list,C402	unnecessary-generator-dict,C411	unnecessary-list-call,C405	unnecessary-literal-set,C415	unnecessary-subscript-reversal,C401	unnecessary-generator-set,C408	unnecessary-collection-call,C406	unnecessary-literal-dict,C40	,C404	unnecessary-list-comprehension-dict,C409	unnecessary-literal-within-tuple-call,C416	unnecessary-comprehension,C41	,C403	unnecessary-list-comprehension-set,C414	unnecessary-double-cast-or-process,DTZ005	call-datetime-now-without-tzinfo,DTZ012	call-date-fromtimestamp,DTZ007	call-datetime-strptime-without-zone,DTZ001	call-datetime-without-tzinfo,DTZ00	,DTZ011	call-date-today,DTZ003	call-datetime-utcnow,DTZ0	,DTZ01	,DTZ006	call-datetime-fromtimestamp,DTZ002	call-datetime-today,DTZ004	call-datetime-utcfromtimestamp,T100	debugger,DJ008	model-without-dunder-str,DJ001	nullable-model-string-field,DJ0	,DJ00	,DJ01	non-leading-receiver-decorator,DJ013	non-leading-receiver-decorator,EM102	f-string-in-exception,EM103	dot-format-in-exception,EM1	,EM101	raw-string-in-exception,EM10	,EXE001	shebang-not-executable,EXE003	shebang-python,EXE004	shebang-whitespace,EXE005	shebang-newline,EXE0	,EXE00	,EXE002	shebang-missing-executable-file,ISC002	multi-line-implicit-string-concatenation,ISC001	single-line-implicit-string-concatenation,ISC0	,ISC00	,ISC003	explicit-string-concatenation,ICN00	unconventional-import-alias,ICN0	unconventional-import-alias,ICN001	unconventional-import-alias,G004	logging-f-string,G001	logging-string-format,G2	,G00	,G202	logging-redundant-exc-info,G01	logging-warn,G002	logging-percent-format,G101	logging-extra-attr-clash,G003	logging-string-concat,G010	logging-warn,G20	,G10	logging-extra-attr-clash,G201	logging-exc-info,G0	,G1	logging-extra-attr-clash,INP001	implicit-namespace-package,INP0	implicit-namespace-package,INP00	implicit-namespace-package,PIE8	,PIE807	prefer-list-builtin,PIE80	,PIE81	single-starts-ends-with,PIE7	,PIE794	dupe-class-field-definitions,PIE810	single-starts-ends-with,PIE800	unnecessary-spread,PIE79	,PIE804	unnecessary-dict-kwargs,PIE790	unnecessary-pass,PIE796	prefer-unique-enums,T201	print-found,T203	p-print-found,PYI007	unrecognized-platform-check,PYI001	prefix-type-params,PYI008	unrecognized-platform-name,PYI0	,PYI00	,PT018	composite-assertion,PT008	patch-with-lambda,PT010	raises-without-exception,PT009	unittest-assertion,PT020	deprecated-yield-fixture,PT023	incorrect-mark-parentheses-style,PT013	incorrect-pytest-import,PT011	raises-too-broad,PT022	useless-yield-fixture,PT00	,PT016	fail-without-message,PT026	use-fixtures-without-parameters,PT007	parametrize-values-wrong-type,PT012	raises-with-multiple-statements,PT02	,PT024	unnecessary-asyncio-mark-on-fixture,PT004	missing-fixture-name-underscore,PT019	fixture-param-without-value,PT01	,PT005	incorrect-fixture-name-underscore,PT001	incorrect-fixture-parentheses-style,PT006	parametrize-names-wrong-type,PT002	fixture-positional-args,PT015	assert-always-false,PT021	fixture-finalizer-callback,PT025	erroneous-use-fixtures-on-fixture,PT003	extraneous-scope-function,PT0	,PT017	assert-in-except,Q001	bad-quotes-multiline-string,Q002	bad-quotes-docstring,Q003	avoidable-escaped-quote,Q0	,Q00	,Q000	bad-quotes-inline-string,RSE102	unnecessary-paren-on-raise-exception,RSE1	unnecessary-paren-on-raise-exception,RSE10	unnecessary-paren-on-raise-exception,RET503	implicit-return,RET5	,RET508	superfluous-else-break,RET501	unnecessary-return-none,RET50	,RET502	implicit-return-value,RET507	superfluous-else-continue,RET504	unnecessary-assign,RET505	superfluous-else-return,RET506	superfluous-else-raise,SLF0	private-member-access,SLF001	private-member-access,SLF00	private-member-access,SIM221	a-or-not-a,SIM108	use-ternary-operator,SIM110	reimplemented-builtin,SIM300	yoda-conditions,SIM211	if-expr-with-false-true,SIM101	duplicate-isinstance-call,SIM118	key-in-dict,SIM114	if-with-same-arms,SIM112	use-capital-environment-variables,SIM115	open-file-with-context-handler,SIM223	and-false,SIM220	a-and-not-a,SIM10	,SIM22	,SIM3	yoda-conditions,SIM107	return-in-try-except-finally,SIM210	if-expr-with-true-false,SIM102	collapsible-if,SIM21	,SIM105	use-contextlib-suppress,SIM117	multiple-with-statements,SIM1	,SIM40	dict-get-with-default,SIM4	dict-get-with-default,SIM208	double-negation,SIM103	needless-bool,SIM401	dict-get-with-default,SIM30	yoda-conditions,SIM212	if-expr-with-twisted-arms,SIM116	manual-dict-lookup,SIM20	,SIM201	negate-equal-op,SIM109	compare-with-tuple,SIM11	,SIM222	or-true,SIM202	negate-not-equal-op,SIM2	,TID251	banned-api,TID252	relative-imports,TID2	,TID25	,TCH00	,TCH001	typing-only-first-party-import,TCH002	typing-only-third-party-import,TCH0	,TCH003	typing-only-standard-library-import,TCH004	runtime-import-in-type-checking-block,TCH005	empty-type-checking-block,ARG001	unused-function-argument,ARG003	unused-class-method-argument,ARG004	unused-static-method-argument,ARG005	unused-lambda-argument,ARG0	,ARG002	unused-method-argument,ARG00	,PTH1	,PTH121	pathlib-samefile,PTH122	pathlib-splitext,PTH103	pathlib-makedirs,PTH110	pathlib-exists,PTH112	pathlib-is-dir,PTH119	pathlib-basename,PTH104	pathlib-rename,PTH101	pathlib-chmod,PTH124	pathlib-py-path,PTH108	pathlib-unlink,PTH105	pathlib-replace,PTH115	pathlib-readlink,PTH118	pathlib-join,PTH123	pathlib-open,PTH120	pathlib-dirname,PTH109	pathlib-getcwd,PTH100	pathlib-abspath,PTH11	,PTH113	pathlib-is-file,PTH114	pathlib-is-link,PTH107	pathlib-remove,PTH106	pathlib-rmdir,PTH117	pathlib-is-abs,PTH102	pathlib-mkdir,PTH116	pathlib-stat,PTH111	pathlib-expanduser,PTH10	,PTH12	,I002	missing-required-import,I0	,I001	unsorted-imports,I00	,C901	complex-structure,NPY00	,NPY001	numpy-deprecated-type-alias,NPY002	numpy-legacy-random,NPY0	,N813	camelcase-imported-as-lowercase,N814	camelcase-imported-as-constant,N9	invalid-module-name,N816	mixed-case-variable-in-global-scope,N999	invalid-module-name,N811	constant-imported-as-non-constant,N99	invalid-module-name,N801	invalid-class-name,N817	camelcase-imported-as-acronym,N803	invalid-argument-name,N8	,N80	,N807	dunder-function-name,N818	error-suffix-on-exception-name,N802	invalid-function-name,N804	invalid-first-argument-name-for-class-method,N812	lowercase-imported-as-non-lowercase,N815	mixed-case-variable-in-class-scope,N81	,N806	non-lowercase-variable-in-function,N805	invalid-first-argument-name-for-method,PD015	use-of-pd-merge,PD013	use-of-dot-stack,PD901	df-is-a-bad-variable-name,PD00	,PD008	use-of-dot-at,PD009	use-of-dot-iat,PD011	use-of-dot-values,PD9	df-is-a-bad-variable-name,PD004	use-of-dot-not-null,PD012	use-of-dot-read-table,PD01	,PD003	use-of-dot-is-null,PD007	use-of-dot-ix,PD0	,PD002	use-of-inplace-argument,PD010	use-of-dot-pivot-or-unstack,PD90	df-is-a-bad-variable-name,E999	syntax-error,E73	lambda-assignment,E712	true-false-comparison,E501	line-too-long,E90	io-error,E402	module-import-not-at-top-of-file,E741	ambiguous-variable-name,E902	io-error,E4	,W505	doc-line-too-long,E731	lambda-assignment,E722	bare-except,E50	line-too-long,W292	no-new-line-at-end-of-file,E401	multiple-imports-on-one-line,W605	invalid-escape-sequence,E70	,E99	syntax-error,E72	,W2	no-new-line-at-end-of-file,E703	useless-semicolon,E71	,W60	invalid-escape-sequence,E743	ambiguous-function-name,E7	,W5	doc-line-too-long,E714	not-is-test,E101	mixed-spaces-and-tabs,E711	none-comparison,E5	line-too-long,E10	mixed-spaces-and-tabs,E701	multiple-statements-on-one-line-colon,E713	not-in-test,E	,E40	,E702	multiple-statements-on-one-line-semicolon,W50	doc-line-too-long,W6	invalid-escape-sequence,E742	ambiguous-class-name,E721	type-comparison,E1	mixed-spaces-and-tabs,E9	,W	,W29	no-new-line-at-end-of-file,E74	,D410	blank-line-after-section,D103	public-function,D204	one-blank-line-after-class,D107	public-init,D212	multi-line-summary-first-line,D414	empty-docstring-section,D100	public-module,D211	no-blank-line-before-class,D400	ends-in-period,D207	no-under-indentation,D405	capitalize-section-name,D419	empty-docstring,D40	,D213	multi-line-summary-second-line,D418	overload-with-docstring,D416	section-name-ends-in-colon,D206	indent-with-spaces,D210	no-surrounding-whitespace,D402	no-signature,D300	triple-single-quotes,D1	,D10	,D30	,D202	no-blank-line-after-function,D104	public-package,D209	new-line-after-last-paragraph,D215	section-underline-not-over-indented,D408	section-underline-after-name,D403	first-line-capitalized,D417	undocumented-param,D2	,D41	,D407	dashed-underline-after-section,D106	public-nested-class,D415	ends-in-punctuation,D20	,D411	blank-line-before-section,D102	public-method,D203	one-blank-line-before-class,D21	,D301	escape-sequence-in-docstring,D200	fits-on-one-line,D409	section-underline-matches-section-length,D3	,D4	,D101	public-class,D201	no-blank-line-before-function,D208	no-over-indentation,D105	magic-method,D214	section-not-over-indented,D412	no-blank-lines-between-header-and-content,D401	non-imperative-mood,D404	docstring-starts-with-this,D406	new-line-after-section-name,D413	blank-line-after-last-section,D205	blank-line-after-summary,F631	assert-tuple,F811	redefined-while-unused,F522	string-dot-format-extra-named-arguments,F523	string-dot-format-extra-positional-arguments,F822	undefined-export,F401	unused-import,F52	,F405	import-star-usage,F704	yield-outside-function,F821	undefined-name,F823	undefined-local,F722	forward-annotation-syntax-error,F506	percent-format-mixed-positional-and-named,F407	future-feature-not-defined,F402	import-shadowed-by-loop-var,F508	percent-format-star-requires-sequence,F633	invalid-print-syntax,F842	unused-annotation,F507	percent-format-positional-count-mismatch,F901	raise-not-implemented,F406	import-star-not-permitted,F622	two-starred-expressions,F5	,F541	f-string-missing-placeholders,F701	break-outside-loop,F707	default-except-not-last,F70	,F8	,F601	multi-value-repeated-key-literal,F634	if-tuple,F504	percent-format-extra-named-arguments,F505	percent-format-missing-argument,F63	,F50	,F403	import-star,F502	percent-format-expected-mapping,F632	is-literal,F7	,F509	percent-format-unsupported-format-character,F706	return-outside-function,F81	redefined-while-unused,F524	string-dot-format-missing-arguments,F4	,F72	forward-annotation-syntax-error,F84	,F54	f-string-missing-placeholders,F702	continue-outside-loop,F82	,F404	late-future-import,F503	percent-format-expected-sequence,F60	,F621	expressions-in-star-assignment,F841	unused-variable,F602	multi-value-repeated-key-variable,F501	percent-format-invalid-format,F525	string-dot-format-mixing-automatic,F62	,F6	,F9	raise-not-implemented,F40	,F90	raise-not-implemented,F521	string-dot-format-invalid-format,PGH0	,PGH001	no-eval,PGH002	deprecated-log-warn,PGH004	blanket-noqa,PGH003	blanket-type-ignore,PGH00	,PLE	,PLR09	,PLE130	bad-string-format-type,PLR091	,PLW29	redefined-loop-name,PLE0100	yield-in-init,PLR2004	magic-value-comparison,PLW290	redefined-loop-name,PLR0915	too-many-statements,PLC300	unnecessary-direct-lambda-call,PLR02	property-with-parameters,PLR0206	property-with-parameters,PLW	,PLW2	redefined-loop-name,PLR172	consider-using-sys-exit,PLE011	,PLC04	useless-import-alias,PLE0118	used-prior-global-declaration,PLR	,PLC0	useless-import-alias,PLE12	,PLE1	,PLE250	bidirectional-unicode,PLC30	unnecessary-direct-lambda-call,PLE13	,PLE0605	invalid-all-format,PLR0911	too-many-return-statements,PLE1206	logging-too-few-args,PLR1722	consider-using-sys-exit,PLW2901	redefined-loop-name,PLC041	useless-import-alias,PLE060	,PLR200	magic-value-comparison,PLW01	useless-else-on-loop,PLW012	useless-else-on-loop,PLR20	magic-value-comparison,PLW060	global-variable-not-assigned,PLE25	bidirectional-unicode,PLE1142	await-outside-async,PLE1205	logging-too-many-args,PLC3002	unnecessary-direct-lambda-call,PLR0913	too-many-arguments,PLW0	,PLR01	comparison-of-constant,PLR1	,PLR0912	too-many-branches,PLR013	comparison-of-constant,PLW0120	useless-else-on-loop,PLE1307	bad-string-format-type,PLE06	,PLE114	await-outside-async,PLE120	,PLC0414	useless-import-alias,PLR0402	consider-using-from-import,PLE0117	nonlocal-without-binding,PLR1701	consider-merging-isinstance,PLR0	,PLR020	property-with-parameters,PLW06	global-variable-not-assigned,PLC3	unnecessary-direct-lambda-call,PLE010	,PLE11	await-outside-async,PLE1310	bad-str-strip-call,PLR17	,PLR04	consider-using-from-import,PLR040	consider-using-from-import,PLE2502	bidirectional-unicode,PLE0604	invalid-all-object,PLE01	,PLC	,PLE131	bad-str-strip-call,PLE0101	return-in-init,PLR0133	comparison-of-constant,PLR2	magic-value-comparison,PLW0602	global-variable-not-assigned,PLE0	,PLE2	bidirectional-unicode,PLR170	consider-merging-isinstance,UP023	rewrite-c-element-tree,UP02	,UP012	unnecessary-encode-utf8,UP007	typing-union,UP018	native-literals,UP026	rewrite-mock-import,UP036	outdated-version-block,UP014	convert-named-tuple-functional-to-class,UP017	datetime-timezone-utc,UP020	open-alias,UP034	extraneous-parentheses,UP00	,UP030	format-literals,UP033	functools-cache,UP028	rewrite-yield-from,UP008	super-call-with-parameters,UP001	useless-metaclass-type,UP006	deprecated-collection-type,UP010	unnecessary-future-import,UP011	lru-cache-without-parameters,UP025	rewrite-unicode-literal,UP037	quoted-annotation,UP0	,UP029	unnecessary-builtin-import,UP01	,UP03	,UP005	deprecated-unittest-alias,UP003	type-of-primitive,UP024	os-error-alias,UP004	useless-object-inheritance,UP013	convert-typed-dict-functional-to-class,UP021	replace-universal-newlines,UP027	rewrite-list-comprehension,UP031	printf-string-formatting,UP032	f-string,UP022	replace-stdout-stderr,UP009	utf8-encoding-declaration,UP015	redundant-open-modes,UP019	typing-text-str-alias,UP035	import-replacements,RUF002	ambiguous-unicode-character-docstring,RUF100	unused-noqa,RUF006	asyncio-dangling-task,RUF004	keyword-argument-before-star-argument,RUF001	ambiguous-unicode-character-string,RUF1	unused-noqa,RUF005	unpack-instead-of-concatenating-to-collection-literal,RUF003	ambiguous-unicode-character-comment,RUF0	,RUF00	,RUF10	unused-noqa,TRY2	,TRY401	verbose-log-message,TRY4	,TRY300	try-consider-else,TRY201	verbose-raise,TRY002	raise-vanilla-class,TRY3	,TRY301	raise-within-try,TRY40	,TRY0	,TRY00	,TRY004	prefer-type-error,TRY400	error-instead-of-exception,TRY30	,TRY20	,TRY003	raise-vanilla-args,TRY200	reraise-no-cause}"
complete -c ruff -n "__fish_seen_subcommand_from check" -l per-file-ignores -d 'List of mappings from file pattern to code to exclude' -r
complete -c ruff -n "__fish_seen_subcommand_from check" -l exclude -d 'List of paths, used to omit files and/or directories from analysis' -r
complete -c ruff -n "__fish_seen_subcommand_from check" -l extend-exclude -d 'Like --exclude, but adds additional files and directories on top of those already excluded' -r
complete -c ruff -n "__fish_seen_subcommand_from check" -l fixable -d 'List of rule codes to treat as eligible for autofix. Only applicable when autofix itself is enabled (e.g., via `--fix`)' -r -f -a "{ALL	all rules,F	Pyflakes,C90	mccabe,I	isort,N	pep8-naming,D	pydocstyle,UP	pyupgrade,YTT	flake8-2020,ANN	flake8-annotations,S	flake8-bandit,BLE	flake8-blind-except,FBT	flake8-boolean-trap,B	flake8-bugbear,A	flake8-builtins,COM	flake8-commas,C4	flake8-comprehensions,DTZ	flake8-datetimez,T10	flake8-debugger,DJ	flake8-django,EM	flake8-errmsg,EXE	flake8-executable,ISC	flake8-implicit-str-concat,ICN	flake8-import-conventions,G	flake8-logging-format,INP	flake8-no-pep420,PIE	flake8-pie,T20	flake8-print,PYI	flake8-pyi,PT	flake8-pytest-style,Q	flake8-quotes,RSE	flake8-raise,RET	flake8-return,SLF	flake8-self,SIM	flake8-simplify,TID	flake8-tidy-imports,TCH	flake8-type-checking,ARG	flake8-unused-arguments,PTH	flake8-use-pathlib,ERA	eradicate,PD	pandas-vet,PGH	pygrep-hooks,PL	Pylint,TRY	tryceratops,NPY	NumPy-specific rules,RUF	Ruff-specific rules,ERA00	commented-out-code,ERA001	commented-out-code,ERA0	commented-out-code,YTT2	,YTT301	sys-version0-referenced,YTT302	sys-version-cmp-str10,YTT204	sys-version-info-minor-cmp-int,YTT1	,YTT10	,YTT30	,YTT201	sys-version-info0-eq3-referenced,YTT3	,YTT303	sys-version-slice1-referenced,YTT20	,YTT202	six-py3-referenced,YTT103	sys-version-cmp-str3,YTT203	sys-version-info1-cmp-int,YTT102	sys-version2-referenced,YTT101	sys-version-slice3-referenced,ANN102	missing-type-cls,ANN206	missing-return-type-class-method,ANN00	,ANN10	,ANN001	missing-type-function-argument,ANN003	missing-type-kwargs,ANN1	,ANN201	missing-return-type-public-function,ANN40	any-type,ANN2	,ANN101	missing-type-self,ANN4	any-type,ANN0	,ANN202	missing-return-type-private-function,ANN205	missing-return-type-static-method,ANN401	any-type,ANN20	,ANN002	missing-type-args,ANN204	missing-return-type-special-method,S324	hashlib-insecure-hash-function,S104	hardcoded-bind-all-interfaces,S509	snmp-weak-cryptography,S608	hardcoded-sql-expression,S113	request-without-timeout,S110	try-except-pass,S508	snmp-insecure-version,S10	,S32	hashlib-insecure-hash-function,S112	try-except-continue,S701	jinja2-autoescape-false,S61	logging-config-insecure-listen,S102	exec-builtin,S6	,S70	jinja2-autoescape-false,S5	,S3	hashlib-insecure-hash-function,S1	,S60	hardcoded-sql-expression,S7	jinja2-autoescape-false,S105	hardcoded-password-string,S101	assert,S103	bad-file-permissions,S501	request-with-no-cert-validation,S106	hardcoded-password-func-arg,S506	unsafe-yaml-load,S612	logging-config-insecure-listen,S107	hardcoded-password-default,S50	,S108	hardcoded-temp-file,S11	,BLE0	blind-except,BLE001	blind-except,BLE00	blind-except,FBT001	boolean-positional-arg-in-function-definition,FBT003	boolean-positional-value-in-function-call,FBT002	boolean-default-value-in-function-definition,FBT0	,FBT00	,B005	strip-with-multi-characters,B009	get-attr-with-constant,B023	function-uses-loop-variable,B013	redundant-tuple-in-exception-handler,B018	useless-expression,B024	abstract-base-class-without-abstract-method,B0	,B022	useless-contextlib-suppress,B02	,B03	unintentional-type-annotation,B002	unary-prefix-increment,B016	cannot-raise-literal,B007	unused-loop-control-variable,B011	assert-false,B9	,B00	,B014	duplicate-handler-exception,B019	cached-instance-method,B032	unintentional-type-annotation,B021	f-string-docstring,B01	,B904	raise-without-from-inside-except,B025	duplicate-try-block-exception,B012	jump-statement-in-finally,B90	,B010	set-attr-with-constant,B027	empty-method-without-abstract-decorator,B003	assignment-to-os-environ,B004	unreliable-callable-check,B020	loop-variable-overrides-iterator,B905	zip-without-explicit-strict,B026	star-arg-unpacking-after-keyword-arg,B006	mutable-argument-default,B008	function-call-argument-default,B017	assert-raises-exception,B029	except-with-empty-tuple,B015	useless-comparison,A0	,A00	,A001	builtin-variable-shadowing,A002	builtin-argument-shadowing,A003	builtin-attribute-shadowing,COM819	trailing-comma-prohibited,COM8	,COM812	trailing-comma-missing,COM81	,COM818	trailing-comma-on-bare-tuple-prohibited,C417	unnecessary-map,C410	unnecessary-literal-within-list-call,C413	unnecessary-call-around-sorted,C400	unnecessary-generator-list,C402	unnecessary-generator-dict,C411	unnecessary-list-call,C405	unnecessary-literal-set,C415	unnecessary-subscript-reversal,C401	unnecessary-generator-set,C408	unnecessary-collection-call,C406	unnecessary-literal-dict,C40	,C404	unnecessary-list-comprehension-dict,C409	unnecessary-literal-within-tuple-call,C416	unnecessary-comprehension,C41	,C403	unnecessary-list-comprehension-set,C414	unnecessary-double-cast-or-process,DTZ005	call-datetime-now-without-tzinfo,DTZ012	call-date-fromtimestamp,DTZ007	call-datetime-strptime-without-zone,DTZ001	call-datetime-without-tzinfo,DTZ00	,DTZ011	call-date-today,DTZ003	call-datetime-utcnow,DTZ0	,DTZ01	,DTZ006	call-datetime-fromtimestamp,DTZ002	call-datetime-today,DTZ004	call-datetime-utcfromtimestamp,T100	debugger,DJ008	model-without-dunder-str,DJ001	nullable-model-string-field,DJ0	,DJ00	,DJ01	non-leading-receiver-decorator,DJ013	non-leading-receiver-decorator,EM102	f-string-in-exception,EM103	dot-format-in-exception,EM1	,EM101	raw-string-in-exception,EM10	,EXE001	shebang-not-executable,EXE003	shebang-python,EXE004	shebang-whitespace,EXE005	shebang-newline,EXE0	,EXE00	,EXE002	shebang-missing-executable-file,ISC002	multi-line-implicit-string-concatenation,ISC001	single-line-implicit-string-concatenation,ISC0	,ISC00	,ISC003	explicit-string-concatenation,ICN00	unconventional-import-alias,ICN0	unconventional-import-alias,ICN001	unconventional-import-alias,G004	logging-f-string,G001	logging-string-format,G2	,G00	,G202	logging-redundant-exc-info,G01	logging-warn,G002	logging-percent-format,G101	logging-extra-attr-clash,G003	logging-string-concat,G010	logging-warn,G20	,G10	logging-extra-attr-clash,G201	logging-exc-info,G0	,G1	logging-extra-attr-clash,INP001	implicit-namespace-package,INP0	implicit-namespace-package,INP00	implicit-namespace-package,PIE8	,PIE807	prefer-list-builtin,PIE80	,PIE81	single-starts-ends-with,PIE7	,PIE794	dupe-class-field-definitions,PIE810	single-starts-ends-with,PIE800	unnecessary-spread,PIE79	,PIE804	unnecessary-dict-kwargs,PIE790	unnecessary-pass,PIE796	prefer-unique-enums,T201	print-found,T203	p-print-found,PYI007	unrecognized-platform-check,PYI001	prefix-type-params,PYI008	unrecognized-platform-name,PYI0	,PYI00	,PT018	composite-assertion,PT008	patch-with-lambda,PT010	raises-without-exception,PT009	unittest-assertion,PT020	deprecated-yield-fixture,PT023	incorrect-mark-parentheses-style,PT013	incorrect-pytest-import,PT011	raises-too-broad,PT022	useless-yield-fixture,PT00	,PT016	fail-without-message,PT026	use-fixtures-without-parameters,PT007	parametrize-values-wrong-type,PT012	raises-with-multiple-statements,PT02	,PT024	unnecessary-asyncio-mark-on-fixture,PT004	missing-fixture-name-underscore,PT019	fixture-param-without-value,PT01	,PT005	incorrect-fixture-name-underscore,PT001	incorrect-fixture-parentheses-style,PT006	parametrize-names-wrong-type,PT002	fixture-positional-args,PT015	assert-always-false,PT021	fixture-finalizer-callback,PT025	erroneous-use-fixtures-on-fixture,PT003	extraneous-scope-function,PT0	,PT017	assert-in-except,Q001	bad-quotes-multiline-string,Q002	bad-quotes-docstring,Q003	avoidable-escaped-quote,Q0	,Q00	,Q000	bad-quotes-inline-string,RSE102	unnecessary-paren-on-raise-exception,RSE1	unnecessary-paren-on-raise-exception,RSE10	unnecessary-paren-on-raise-exception,RET503	implicit-return,RET5	,RET508	superfluous-else-break,RET501	unnecessary-return-none,RET50	,RET502	implicit-return-value,RET507	superfluous-else-continue,RET504	unnecessary-assign,RET505	superfluous-else-return,RET506	superfluous-else-raise,SLF0	private-member-access,SLF001	private-member-access,SLF00	private-member-access,SIM221	a-or-not-a,SIM108	use-ternary-operator,SIM110	reimplemented-builtin,SIM300	yoda-conditions,SIM211	if-expr-with-false-true,SIM101	duplicate-isinstance-call,SIM118	key-in-dict,SIM114	if-with-same-arms,SIM112	use-capital-environment-variables,SIM115	open-file-with-context-handler,SIM223	and-false,SIM220	a-and-not-a,SIM10	,SIM22	,SIM3	yoda-conditions,SIM107	return-in-try-except-finally,SIM210	if-expr-with-true-false,SIM102	collapsible-if,SIM21	,SIM105	use-contextlib-suppress,SIM117	multiple-with-statements,SIM1	,SIM40	dict-get-with-default,SIM4	dict-get-with-default,SIM208	double-negation,SIM103	needless-bool,SIM401	dict-get-with-default,SIM30	yoda-conditions,SIM212	if-expr-with-twisted-arms,SIM116	manual-dict-lookup,SIM20	,SIM201	negate-equal-op,SIM109	compare-with-tuple,SIM11	,SIM222	or-true,SIM202	negate-not-equal-op,SIM2	,TID251	banned-api,TID252	relative-imports,TID2	,TID25	,TCH00	,TCH001	typing-only-first-party-import,TCH002	typing-only-third-party-import,TCH0	,TCH003	typing-only-standard-library-import,TCH004	runtime-import-in-type-checking-block,TCH005	empty-type-checking-block,ARG001	unused-function-argument,ARG003	unused-class-method-argument,ARG004	unused-static-method-argument,ARG005	unused-lambda-argument,ARG0	,ARG002	unused-method-argument,ARG00	,PTH1	,PTH121	pathlib-samefile,PTH122	pathlib-splitext,PTH103	pathlib-makedirs,PTH110	pathlib-exists,PTH112	pathlib-is-dir,PTH119	pathlib-basename,PTH104	pathlib-rename,PTH101	pathlib-chmod,PTH124	pathlib-py-path,PTH108	pathlib-unlink,PTH105	pathlib-replace,PTH115	pathlib-readlink,PTH118	pathlib-join,PTH123	pathlib-open,PTH120	pathlib-dirname,PTH109	pathlib-getcwd,PTH100	pathlib-abspath,PTH11	,PTH113	pathlib-is-file,PTH114	pathlib-is-link,PTH107	pathlib-remove,PTH106	pathlib-rmdir,PTH117	pathlib-is-abs,PTH102	pathlib-mkdir,PTH116	pathlib-stat,PTH111	pathlib-expanduser,PTH10	,PTH12	,I002	missing-required-import,I0	,I001	unsorted-imports,I00	,C901	complex-structure,NPY00	,NPY001	numpy-deprecated-type-alias,NPY002	numpy-legacy-random,NPY0	,N813	camelcase-imported-as-lowercase,N814	camelcase-imported-as-constant,N9	invalid-module-name,N816	mixed-case-variable-in-global-scope,N999	invalid-module-name,N811	constant-imported-as-non-constant,N99	invalid-module-name,N801	invalid-class-name,N817	camelcase-imported-as-acronym,N803	invalid-argument-name,N8	,N80	,N807	dunder-function-name,N818	error-suffix-on-exception-name,N802	invalid-function-name,N804	invalid-first-argument-name-for-class-method,N812	lowercase-imported-as-non-lowercase,N815	mixed-case-variable-in-class-scope,N81	,N806	non-lowercase-variable-in-function,N805	invalid-first-argument-name-for-method,PD015	use-of-pd-merge,PD013	use-of-dot-stack,PD901	df-is-a-bad-variable-name,PD00	,PD008	use-of-dot-at,PD009	use-of-dot-iat,PD011	use-of-dot-values,PD9	df-is-a-bad-variable-name,PD004	use-of-dot-not-null,PD012	use-of-dot-read-table,PD01	,PD003	use-of-dot-is-null,PD007	use-of-dot-ix,PD0	,PD002	use-of-inplace-argument,PD010	use-of-dot-pivot-or-unstack,PD90	df-is-a-bad-variable-name,E999	syntax-error,E73	lambda-assignment,E712	true-false-comparison,E501	line-too-long,E90	io-error,E402	module-import-not-at-top-of-file,E741	ambiguous-variable-name,E902	io-error,E4	,W505	doc-line-too-long,E731	lambda-assignment,E722	bare-except,E50	line-too-long,W292	no-new-line-at-end-of-file,E401	multiple-imports-on-one-line,W605	invalid-escape-sequence,E70	,E99	syntax-error,E72	,W2	no-new-line-at-end-of-file,E703	useless-semicolon,E71	,W60	invalid-escape-sequence,E743	ambiguous-function-name,E7	,W5	doc-line-too-long,E714	not-is-test,E101	mixed-spaces-and-tabs,E711	none-comparison,E5	line-too-long,E10	mixed-spaces-and-tabs,E701	multiple-statements-on-one-line-colon,E713	not-in-test,E	,E40	,E702	multiple-statements-on-one-line-semicolon,W50	doc-line-too-long,W6	invalid-escape-sequence,E742	ambiguous-class-name,E721	type-comparison,E1	mixed-spaces-and-tabs,E9	,W	,W29	no-new-line-at-end-of-file,E74	,D410	blank-line-after-section,D103	public-function,D204	one-blank-line-after-class,D107	public-init,D212	multi-line-summary-first-line,D414	empty-docstring-section,D100	public-module,D211	no-blank-line-before-class,D400	ends-in-period,D207	no-under-indentation,D405	capitalize-section-name,D419	empty-docstring,D40	,D213	multi-line-summary-second-line,D418	overload-with-docstring,D416	section-name-ends-in-colon,D206	indent-with-spaces,D210	no-surrounding-whitespace,D402	no-signature,D300	triple-single-quotes,D1	,D10	,D30	,D202	no-blank-line-after-function,D104	public-package,D209	new-line-after-last-paragraph,D215	section-underline-not-over-indented,D408	section-underline-after-name,D403	first-line-capitalized,D417	undocumented-param,D2	,D41	,D407	dashed-underline-after-section,D106	public-nested-class,D415	ends-in-punctuation,D20	,D411	blank-line-before-section,D102	public-method,D203	one-blank-line-before-class,D21	,D301	escape-sequence-in-docstring,D200	fits-on-one-line,D409	section-underline-matches-section-length,D3	,D4	,D101	public-class,D201	no-blank-line-before-function,D208	no-over-indentation,D105	magic-method,D214	section-not-over-indented,D412	no-blank-lines-between-header-and-content,D401	non-imperative-mood,D404	docstring-starts-with-this,D406	new-line-after-section-name,D413	blank-line-after-last-section,D205	blank-line-after-summary,F631	assert-tuple,F811	redefined-while-unused,F522	string-dot-format-extra-named-arguments,F523	string-dot-format-extra-positional-arguments,F822	undefined-export,F401	unused-import,F52	,F405	import-star-usage,F704	yield-outside-function,F821	undefined-name,F823	undefined-local,F722	forward-annotation-syntax-error,F506	percent-format-mixed-positional-and-named,F407	future-feature-not-defined,F402	import-shadowed-by-loop-var,F508	percent-format-star-requires-sequence,F633	invalid-print-syntax,F842	unused-annotation,F507	percent-format-positional-count-mismatch,F901	raise-not-implemented,F406	import-star-not-permitted,F622	two-starred-expressions,F5	,F541	f-string-missing-placeholders,F701	break-outside-loop,F707	default-except-not-last,F70	,F8	,F601	multi-value-repeated-key-literal,F634	if-tuple,F504	percent-format-extra-named-arguments,F505	percent-format-missing-argument,F63	,F50	,F403	import-star,F502	percent-format-expected-mapping,F632	is-literal,F7	,F509	percent-format-unsupported-format-character,F706	return-outside-function,F81	redefined-while-unused,F524	string-dot-format-missing-arguments,F4	,F72	forward-annotation-syntax-error,F84	,F54	f-string-missing-placeholders,F702	continue-outside-loop,F82	,F404	late-future-import,F503	percent-format-expected-sequence,F60	,F621	expressions-in-star-assignment,F841	unused-variable,F602	multi-value-repeated-key-variable,F501	percent-format-invalid-format,F525	string-dot-format-mixing-automatic,F62	,F6	,F9	raise-not-implemented,F40	,F90	raise-not-implemented,F521	string-dot-format-invalid-format,PGH0	,PGH001	no-eval,PGH002	deprecated-log-warn,PGH004	blanket-noqa,PGH003	blanket-type-ignore,PGH00	,PLE	,PLR09	,PLE130	bad-string-format-type,PLR091	,PLW29	redefined-loop-name,PLE0100	yield-in-init,PLR2004	magic-value-comparison,PLW290	redefined-loop-name,PLR0915	too-many-statements,PLC300	unnecessary-direct-lambda-call,PLR02	property-with-parameters,PLR0206	property-with-parameters,PLW	,PLW2	redefined-loop-name,PLR172	consider-using-sys-exit,PLE011	,PLC04	useless-import-alias,PLE0118	used-prior-global-declaration,PLR	,PLC0	useless-import-alias,PLE12	,PLE1	,PLE250	bidirectional-unicode,PLC30	unnecessary-direct-lambda-call,PLE13	,PLE0605	invalid-all-format,PLR0911	too-many-return-statements,PLE1206	logging-too-few-args,PLR1722	consider-using-sys-exit,PLW2901	redefined-loop-name,PLC041	useless-import-alias,PLE060	,PLR200	magic-value-comparison,PLW01	useless-else-on-loop,PLW012	useless-else-on-loop,PLR20	magic-value-comparison,PLW060	global-variable-not-assigned,PLE25	bidirectional-unicode,PLE1142	await-outside-async,PLE1205	logging-too-many-args,PLC3002	unnecessary-direct-lambda-call,PLR0913	too-many-arguments,PLW0	,PLR01	comparison-of-constant,PLR1	,PLR0912	too-many-branches,PLR013	comparison-of-constant,PLW0120	useless-else-on-loop,PLE1307	bad-string-format-type,PLE06	,PLE114	await-outside-async,PLE120	,PLC0414	useless-import-alias,PLR0402	consider-using-from-import,PLE0117	nonlocal-without-binding,PLR1701	consider-merging-isinstance,PLR0	,PLR020	property-with-parameters,PLW06	global-variable-not-assigned,PLC3	unnecessary-direct-lambda-call,PLE010	,PLE11	await-outside-async,PLE1310	bad-str-strip-call,PLR17	,PLR04	consider-using-from-import,PLR040	consider-using-from-import,PLE2502	bidirectional-unicode,PLE0604	invalid-all-object,PLE01	,PLC	,PLE131	bad-str-strip-call,PLE0101	return-in-init,PLR0133	comparison-of-constant,PLR2	magic-value-comparison,PLW0602	global-variable-not-assigned,PLE0	,PLE2	bidirectional-unicode,PLR170	consider-merging-isinstance,UP023	rewrite-c-element-tree,UP02	,UP012	unnecessary-encode-utf8,UP007	typing-union,UP018	native-literals,UP026	rewrite-mock-import,UP036	outdated-version-block,UP014	convert-named-tuple-functional-to-class,UP017	datetime-timezone-utc,UP020	open-alias,UP034	extraneous-parentheses,UP00	,UP030	format-literals,UP033	functools-cache,UP028	rewrite-yield-from,UP008	super-call-with-parameters,UP001	useless-metaclass-type,UP006	deprecated-collection-type,UP010	unnecessary-future-import,UP011	lru-cache-without-parameters,UP025	rewrite-unicode-literal,UP037	quoted-annotation,UP0	,UP029	unnecessary-builtin-import,UP01	,UP03	,UP005	deprecated-unittest-alias,UP003	type-of-primitive,UP024	os-error-alias,UP004	useless-object-inheritance,UP013	convert-typed-dict-functional-to-class,UP021	replace-universal-newlines,UP027	rewrite-list-comprehension,UP031	printf-string-formatting,UP032	f-string,UP022	replace-stdout-stderr,UP009	utf8-encoding-declaration,UP015	redundant-open-modes,UP019	typing-text-str-alias,UP035	import-replacements,RUF002	ambiguous-unicode-character-docstring,RUF100	unused-noqa,RUF006	asyncio-dangling-task,RUF004	keyword-argument-before-star-argument,RUF001	ambiguous-unicode-character-string,RUF1	unused-noqa,RUF005	unpack-instead-of-concatenating-to-collection-literal,RUF003	ambiguous-unicode-character-comment,RUF0	,RUF00	,RUF10	unused-noqa,TRY2	,TRY401	verbose-log-message,TRY4	,TRY300	try-consider-else,TRY201	verbose-raise,TRY002	raise-vanilla-class,TRY3	,TRY301	raise-within-try,TRY40	,TRY0	,TRY00	,TRY004	prefer-type-error,TRY400	error-instead-of-exception,TRY30	,TRY20	,TRY003	raise-vanilla-args,TRY200	reraise-no-cause}"
complete -c ruff -n "__fish_seen_subcommand_from check" -l unfixable -d 'List of rule codes to treat as ineligible for autofix. Only applicable when autofix itself is enabled (e.g., via `--fix`)' -r -f -a "{ALL	all rules,F	Pyflakes,C90	mccabe,I	isort,N	pep8-naming,D	pydocstyle,UP	pyupgrade,YTT	flake8-2020,ANN	flake8-annotations,S	flake8-bandit,BLE	flake8-blind-except,FBT	flake8-boolean-trap,B	flake8-bugbear,A	flake8-builtins,COM	flake8-commas,C4	flake8-comprehensions,DTZ	flake8-datetimez,T10	flake8-debugger,DJ	flake8-django,EM	flake8-errmsg,EXE	flake8-executable,ISC	flake8-implicit-str-concat,ICN	flake8-import-conventions,G	flake8-logging-format,INP	flake8-no-pep420,PIE	flake8-pie,T20	flake8-print,PYI	flake8-pyi,PT	flake8-pytest-style,Q	flake8-quotes,RSE	flake8-raise,RET	flake8-return,SLF	flake8-self,SIM	flake8-simplify,TID	flake8-tidy-imports,TCH	flake8-type-checking,ARG	flake8-unused-arguments,PTH	flake8-use-pathlib,ERA	eradicate,PD	pandas-vet,PGH	pygrep-hooks,PL	Pylint,TRY	tryceratops,NPY	NumPy-specific rules,RUF	Ruff-specific rules,ERA00	commented-out-code,ERA001	commented-out-code,ERA0	commented-out-code,YTT2	,YTT301	sys-version0-referenced,YTT302	sys-version-cmp-str10,YTT204	sys-version-info-minor-cmp-int,YTT1	,YTT10	,YTT30	,YTT201	sys-version-info0-eq3-referenced,YTT3	,YTT303	sys-version-slice1-referenced,YTT20	,YTT202	six-py3-referenced,YTT103	sys-version-cmp-str3,YTT203	sys-version-info1-cmp-int,YTT102	sys-version2-referenced,YTT101	sys-version-slice3-referenced,ANN102	missing-type-cls,ANN206	missing-return-type-class-method,ANN00	,ANN10	,ANN001	missing-type-function-argument,ANN003	missing-type-kwargs,ANN1	,ANN201	missing-return-type-public-function,ANN40	any-type,ANN2	,ANN101	missing-type-self,ANN4	any-type,ANN0	,ANN202	missing-return-type-private-function,ANN205	missing-return-type-static-method,ANN401	any-type,ANN20	,ANN002	missing-type-args,ANN204	missing-return-type-special-method,S324	hashlib-insecure-hash-function,S104	hardcoded-bind-all-interfaces,S509	snmp-weak-cryptography,S608	hardcoded-sql-expression,S113	request-without-timeout,S110	try-except-pass,S508	snmp-insecure-version,S10	,S32	hashlib-insecure-hash-function,S112	try-except-continue,S701	jinja2-autoescape-false,S61	logging-config-insecure-listen,S102	exec-builtin,S6	,S70	jinja2-autoescape-false,S5	,S3	hashlib-insecure-hash-function,S1	,S60	hardcoded-sql-expression,S7	jinja2-autoescape-false,S105	hardcoded-password-string,S101	assert,S103	bad-file-permissions,S501	request-with-no-cert-validation,S106	hardcoded-password-func-arg,S506	unsafe-yaml-load,S612	logging-config-insecure-listen,S107	hardcoded-password-default,S50	,S108	hardcoded-temp-file,S11	,BLE0	blind-except,BLE001	blind-except,BLE00	blind-except,FBT001	boolean-positional-arg-in-function-definition,FBT003	boolean-positional-value-in-function-call,FBT002	boolean-default-value-in-function-definition,FBT0	,FBT00	,B005	strip-with-multi-characters,B009	get-attr-with-constant,B023	function-uses-loop-variable,B013	redundant-tuple-in-exception-handler,B018	useless-expression,B024	abstract-base-class-without-abstract-method,B0	,B022	useless-contextlib-suppress,B02	,B03	unintentional-type-annotation,B002	unary-prefix-increment,B016	cannot-raise-literal,B007	unused-loop-control-variable,B011	assert-false,B9	,B00	,B014	duplicate-handler-exception,B019	cached-instance-method,B032	unintentional-type-annotation,B021	f-string-docstring,B01	,B904	raise-without-from-inside-except,B025	duplicate-try-block-exception,B012	jump-statement-in-finally,B90	,B010	set-attr-with-constant,B027	empty-method-without-abstract-decorator,B003	assignment-to-os-environ,B004	unreliable-callable-check,B020	loop-variable-overrides-iterator,B905	zip-without-explicit-strict,B026	star-arg-unpacking-after-keyword-arg,B006	mutable-argument-default,B008	function-call-argument-default,B017	assert-raises-exception,B029	except-with-empty-tuple,B015	useless-comparison,A0	,A00	,A001	builtin-variable-shadowing,A002	builtin-argument-shadowing,A003	builtin-attribute-shadowing,COM819	trailing-comma-prohibited,COM8	,COM812	trailing-comma-missing,COM81	,COM818	trailing-comma-on-bare-tuple-prohibited,C417	unnecessary-map,C410	unnecessary-literal-within-list-call,C413	unnecessary-call-around-sorted,C400	unnecessary-generator-list,C402	unnecessary-generator-dict,C411	unnecessary-list-call,C405	unnecessary-literal-set,C415	unnecessary-subscript-reversal,C401	unnecessary-generator-set,C408	unnecessary-collection-call,C406	unnecessary-literal-dict,C40	,C404	unnecessary-list-comprehension-dict,C409	unnecessary-literal-within-tuple-call,C416	unnecessary-comprehension,C41	,C403	unnecessary-list-comprehension-set,C414	unnecessary-double-cast-or-process,DTZ005	call-datetime-now-without-tzinfo,DTZ012	call-date-fromtimestamp,DTZ007	call-datetime-strptime-without-zone,DTZ001	call-datetime-without-tzinfo,DTZ00	,DTZ011	call-date-today,DTZ003	call-datetime-utcnow,DTZ0	,DTZ01	,DTZ006	call-datetime-fromtimestamp,DTZ002	call-datetime-today,DTZ004	call-datetime-utcfromtimestamp,T100	debugger,DJ008	model-without-dunder-str,DJ001	nullable-model-string-field,DJ0	,DJ00	,DJ01	non-leading-receiver-decorator,DJ013	non-leading-receiver-decorator,EM102	f-string-in-exception,EM103	dot-format-in-exception,EM1	,EM101	raw-string-in-exception,EM10	,EXE001	shebang-not-executable,EXE003	shebang-python,EXE004	shebang-whitespace,EXE005	shebang-newline,EXE0	,EXE00	,EXE002	shebang-missing-executable-file,ISC002	multi-line-implicit-string-concatenation,ISC001	single-line-implicit-string-concatenation,ISC0	,ISC00	,ISC003	explicit-string-concatenation,ICN00	unconventional-import-alias,ICN0	unconventional-import-alias,ICN001	unconventional-import-alias,G004	logging-f-string,G001	logging-string-format,G2	,G00	,G202	logging-redundant-exc-info,G01	logging-warn,G002	logging-percent-format,G101	logging-extra-attr-clash,G003	logging-string-concat,G010	logging-warn,G20	,G10	logging-extra-attr-clash,G201	logging-exc-info,G0	,G1	logging-extra-attr-clash,INP001	implicit-namespace-package,INP0	implicit-namespace-package,INP00	implicit-namespace-package,PIE8	,PIE807	prefer-list-builtin,PIE80	,PIE81	single-starts-ends-with,PIE7	,PIE794	dupe-class-field-definitions,PIE810	single-starts-ends-with,PIE800	unnecessary-spread,PIE79	,PIE804	unnecessary-dict-kwargs,PIE790	unnecessary-pass,PIE796	prefer-unique-enums,T201	print-found,T203	p-print-found,PYI007	unrecognized-platform-check,PYI001	prefix-type-params,PYI008	unrecognized-platform-name,PYI0	,PYI00	,PT018	composite-assertion,PT008	patch-with-lambda,PT010	raises-without-exception,PT009	unittest-assertion,PT020	deprecated-yield-fixture,PT023	incorrect-mark-parentheses-style,PT013	incorrect-pytest-import,PT011	raises-too-broad,PT022	useless-yield-fixture,PT00	,PT016	fail-without-message,PT026	use-fixtures-without-parameters,PT007	parametrize-values-wrong-type,PT012	raises-with-multiple-statements,PT02	,PT024	unnecessary-asyncio-mark-on-fixture,PT004	missing-fixture-name-underscore,PT019	fixture-param-without-value,PT01	,PT005	incorrect-fixture-name-underscore,PT001	incorrect-fixture-parentheses-style,PT006	parametrize-names-wrong-type,PT002	fixture-positional-args,PT015	assert-always-false,PT021	fixture-finalizer-callback,PT025	erroneous-use-fixtures-on-fixture,PT003	extraneous-scope-function,PT0	,PT017	assert-in-except,Q001	bad-quotes-multiline-string,Q002	bad-quotes-docstring,Q003	avoidable-escaped-quote,Q0	,Q00	,Q000	bad-quotes-inline-string,RSE102	unnecessary-paren-on-raise-exception,RSE1	unnecessary-paren-on-raise-exception,RSE10	unnecessary-paren-on-raise-exception,RET503	implicit-return,RET5	,RET508	superfluous-else-break,RET501	unnecessary-return-none,RET50	,RET502	implicit-return-value,RET507	superfluous-else-continue,RET504	unnecessary-assign,RET505	superfluous-else-return,RET506	superfluous-else-raise,SLF0	private-member-access,SLF001	private-member-access,SLF00	private-member-access,SIM221	a-or-not-a,SIM108	use-ternary-operator,SIM110	reimplemented-builtin,SIM300	yoda-conditions,SIM211	if-expr-with-false-true,SIM101	duplicate-isinstance-call,SIM118	key-in-dict,SIM114	if-with-same-arms,SIM112	use-capital-environment-variables,SIM115	open-file-with-context-handler,SIM223	and-false,SIM220	a-and-not-a,SIM10	,SIM22	,SIM3	yoda-conditions,SIM107	return-in-try-except-finally,SIM210	if-expr-with-true-false,SIM102	collapsible-if,SIM21	,SIM105	use-contextlib-suppress,SIM117	multiple-with-statements,SIM1	,SIM40	dict-get-with-default,SIM4	dict-get-with-default,SIM208	double-negation,SIM103	needless-bool,SIM401	dict-get-with-default,SIM30	yoda-conditions,SIM212	if-expr-with-twisted-arms,SIM116	manual-dict-lookup,SIM20	,SIM201	negate-equal-op,SIM109	compare-with-tuple,SIM11	,SIM222	or-true,SIM202	negate-not-equal-op,SIM2	,TID251	banned-api,TID252	relative-imports,TID2	,TID25	,TCH00	,TCH001	typing-only-first-party-import,TCH002	typing-only-third-party-import,TCH0	,TCH003	typing-only-standard-library-import,TCH004	runtime-import-in-type-checking-block,TCH005	empty-type-checking-block,ARG001	unused-function-argument,ARG003	unused-class-method-argument,ARG004	unused-static-method-argument,ARG005	unused-lambda-argument,ARG0	,ARG002	unused-method-argument,ARG00	,PTH1	,PTH121	pathlib-samefile,PTH122	pathlib-splitext,PTH103	pathlib-makedirs,PTH110	pathlib-exists,PTH112	pathlib-is-dir,PTH119	pathlib-basename,PTH104	pathlib-rename,PTH101	pathlib-chmod,PTH124	pathlib-py-path,PTH108	pathlib-unlink,PTH105	pathlib-replace,PTH115	pathlib-readlink,PTH118	pathlib-join,PTH123	pathlib-open,PTH120	pathlib-dirname,PTH109	pathlib-getcwd,PTH100	pathlib-abspath,PTH11	,PTH113	pathlib-is-file,PTH114	pathlib-is-link,PTH107	pathlib-remove,PTH106	pathlib-rmdir,PTH117	pathlib-is-abs,PTH102	pathlib-mkdir,PTH116	pathlib-stat,PTH111	pathlib-expanduser,PTH10	,PTH12	,I002	missing-required-import,I0	,I001	unsorted-imports,I00	,C901	complex-structure,NPY00	,NPY001	numpy-deprecated-type-alias,NPY002	numpy-legacy-random,NPY0	,N813	camelcase-imported-as-lowercase,N814	camelcase-imported-as-constant,N9	invalid-module-name,N816	mixed-case-variable-in-global-scope,N999	invalid-module-name,N811	constant-imported-as-non-constant,N99	invalid-module-name,N801	invalid-class-name,N817	camelcase-imported-as-acronym,N803	invalid-argument-name,N8	,N80	,N807	dunder-function-name,N818	error-suffix-on-exception-name,N802	invalid-function-name,N804	invalid-first-argument-name-for-class-method,N812	lowercase-imported-as-non-lowercase,N815	mixed-case-variable-in-class-scope,N81	,N806	non-lowercase-variable-in-function,N805	invalid-first-argument-name-for-method,PD015	use-of-pd-merge,PD013	use-of-dot-stack,PD901	df-is-a-bad-variable-name,PD00	,PD008	use-of-dot-at,PD009	use-of-dot-iat,PD011	use-of-dot-values,PD9	df-is-a-bad-variable-name,PD004	use-of-dot-not-null,PD012	use-of-dot-read-table,PD01	,PD003	use-of-dot-is-null,PD007	use-of-dot-ix,PD0	,PD002	use-of-inplace-argument,PD010	use-of-dot-pivot-or-unstack,PD90	df-is-a-bad-variable-name,E999	syntax-error,E73	lambda-assignment,E712	true-false-comparison,E501	line-too-long,E90	io-error,E402	module-import-not-at-top-of-file,E741	ambiguous-variable-name,E902	io-error,E4	,W505	doc-line-too-long,E731	lambda-assignment,E722	bare-except,E50	line-too-long,W292	no-new-line-at-end-of-file,E401	multiple-imports-on-one-line,W605	invalid-escape-sequence,E70	,E99	syntax-error,E72	,W2	no-new-line-at-end-of-file,E703	useless-semicolon,E71	,W60	invalid-escape-sequence,E743	ambiguous-function-name,E7	,W5	doc-line-too-long,E714	not-is-test,E101	mixed-spaces-and-tabs,E711	none-comparison,E5	line-too-long,E10	mixed-spaces-and-tabs,E701	multiple-statements-on-one-line-colon,E713	not-in-test,E	,E40	,E702	multiple-statements-on-one-line-semicolon,W50	doc-line-too-long,W6	invalid-escape-sequence,E742	ambiguous-class-name,E721	type-comparison,E1	mixed-spaces-and-tabs,E9	,W	,W29	no-new-line-at-end-of-file,E74	,D410	blank-line-after-section,D103	public-function,D204	one-blank-line-after-class,D107	public-init,D212	multi-line-summary-first-line,D414	empty-docstring-section,D100	public-module,D211	no-blank-line-before-class,D400	ends-in-period,D207	no-under-indentation,D405	capitalize-section-name,D419	empty-docstring,D40	,D213	multi-line-summary-second-line,D418	overload-with-docstring,D416	section-name-ends-in-colon,D206	indent-with-spaces,D210	no-surrounding-whitespace,D402	no-signature,D300	triple-single-quotes,D1	,D10	,D30	,D202	no-blank-line-after-function,D104	public-package,D209	new-line-after-last-paragraph,D215	section-underline-not-over-indented,D408	section-underline-after-name,D403	first-line-capitalized,D417	undocumented-param,D2	,D41	,D407	dashed-underline-after-section,D106	public-nested-class,D415	ends-in-punctuation,D20	,D411	blank-line-before-section,D102	public-method,D203	one-blank-line-before-class,D21	,D301	escape-sequence-in-docstring,D200	fits-on-one-line,D409	section-underline-matches-section-length,D3	,D4	,D101	public-class,D201	no-blank-line-before-function,D208	no-over-indentation,D105	magic-method,D214	section-not-over-indented,D412	no-blank-lines-between-header-and-content,D401	non-imperative-mood,D404	docstring-starts-with-this,D406	new-line-after-section-name,D413	blank-line-after-last-section,D205	blank-line-after-summary,F631	assert-tuple,F811	redefined-while-unused,F522	string-dot-format-extra-named-arguments,F523	string-dot-format-extra-positional-arguments,F822	undefined-export,F401	unused-import,F52	,F405	import-star-usage,F704	yield-outside-function,F821	undefined-name,F823	undefined-local,F722	forward-annotation-syntax-error,F506	percent-format-mixed-positional-and-named,F407	future-feature-not-defined,F402	import-shadowed-by-loop-var,F508	percent-format-star-requires-sequence,F633	invalid-print-syntax,F842	unused-annotation,F507	percent-format-positional-count-mismatch,F901	raise-not-implemented,F406	import-star-not-permitted,F622	two-starred-expressions,F5	,F541	f-string-missing-placeholders,F701	break-outside-loop,F707	default-except-not-last,F70	,F8	,F601	multi-value-repeated-key-literal,F634	if-tuple,F504	percent-format-extra-named-arguments,F505	percent-format-missing-argument,F63	,F50	,F403	import-star,F502	percent-format-expected-mapping,F632	is-literal,F7	,F509	percent-format-unsupported-format-character,F706	return-outside-function,F81	redefined-while-unused,F524	string-dot-format-missing-arguments,F4	,F72	forward-annotation-syntax-error,F84	,F54	f-string-missing-placeholders,F702	continue-outside-loop,F82	,F404	late-future-import,F503	percent-format-expected-sequence,F60	,F621	expressions-in-star-assignment,F841	unused-variable,F602	multi-value-repeated-key-variable,F501	percent-format-invalid-format,F525	string-dot-format-mixing-automatic,F62	,F6	,F9	raise-not-implemented,F40	,F90	raise-not-implemented,F521	string-dot-format-invalid-format,PGH0	,PGH001	no-eval,PGH002	deprecated-log-warn,PGH004	blanket-noqa,PGH003	blanket-type-ignore,PGH00	,PLE	,PLR09	,PLE130	bad-string-format-type,PLR091	,PLW29	redefined-loop-name,PLE0100	yield-in-init,PLR2004	magic-value-comparison,PLW290	redefined-loop-name,PLR0915	too-many-statements,PLC300	unnecessary-direct-lambda-call,PLR02	property-with-parameters,PLR0206	property-with-parameters,PLW	,PLW2	redefined-loop-name,PLR172	consider-using-sys-exit,PLE011	,PLC04	useless-import-alias,PLE0118	used-prior-global-declaration,PLR	,PLC0	useless-import-alias,PLE12	,PLE1	,PLE250	bidirectional-unicode,PLC30	unnecessary-direct-lambda-call,PLE13	,PLE0605	invalid-all-format,PLR0911	too-many-return-statements,PLE1206	logging-too-few-args,PLR1722	consider-using-sys-exit,PLW2901	redefined-loop-name,PLC041	useless-import-alias,PLE060	,PLR200	magic-value-comparison,PLW01	useless-else-on-loop,PLW012	useless-else-on-loop,PLR20	magic-value-comparison,PLW060	global-variable-not-assigned,PLE25	bidirectional-unicode,PLE1142	await-outside-async,PLE1205	logging-too-many-args,PLC3002	unnecessary-direct-lambda-call,PLR0913	too-many-arguments,PLW0	,PLR01	comparison-of-constant,PLR1	,PLR0912	too-many-branches,PLR013	comparison-of-constant,PLW0120	useless-else-on-loop,PLE1307	bad-string-format-type,PLE06	,PLE114	await-outside-async,PLE120	,PLC0414	useless-import-alias,PLR0402	consider-using-from-import,PLE0117	nonlocal-without-binding,PLR1701	consider-merging-isinstance,PLR0	,PLR020	property-with-parameters,PLW06	global-variable-not-assigned,PLC3	unnecessary-direct-lambda-call,PLE010	,PLE11	await-outside-async,PLE1310	bad-str-strip-call,PLR17	,PLR04	consider-using-from-import,PLR040	consider-using-from-import,PLE2502	bidirectional-unicode,PLE0604	invalid-all-object,PLE01	,PLC	,PLE131	bad-str-strip-call,PLE0101	return-in-init,PLR0133	comparison-of-constant,PLR2	magic-value-comparison,PLW0602	global-variable-not-assigned,PLE0	,PLE2	bidirectional-unicode,PLR170	consider-merging-isinstance,UP023	rewrite-c-element-tree,UP02	,UP012	unnecessary-encode-utf8,UP007	typing-union,UP018	native-literals,UP026	rewrite-mock-import,UP036	outdated-version-block,UP014	convert-named-tuple-functional-to-class,UP017	datetime-timezone-utc,UP020	open-alias,UP034	extraneous-parentheses,UP00	,UP030	format-literals,UP033	functools-cache,UP028	rewrite-yield-from,UP008	super-call-with-parameters,UP001	useless-metaclass-type,UP006	deprecated-collection-type,UP010	unnecessary-future-import,UP011	lru-cache-without-parameters,UP025	rewrite-unicode-literal,UP037	quoted-annotation,UP0	,UP029	unnecessary-builtin-import,UP01	,UP03	,UP005	deprecated-unittest-alias,UP003	type-of-primitive,UP024	os-error-alias,UP004	useless-object-inheritance,UP013	convert-typed-dict-functional-to-class,UP021	replace-universal-newlines,UP027	rewrite-list-comprehension,UP031	printf-string-formatting,UP032	f-string,UP022	replace-stdout-stderr,UP009	utf8-encoding-declaration,UP015	redundant-open-modes,UP019	typing-text-str-alias,UP035	import-replacements,RUF002	ambiguous-unicode-character-docstring,RUF100	unused-noqa,RUF006	asyncio-dangling-task,RUF004	keyword-argument-before-star-argument,RUF001	ambiguous-unicode-character-string,RUF1	unused-noqa,RUF005	unpack-instead-of-concatenating-to-collection-literal,RUF003	ambiguous-unicode-character-comment,RUF0	,RUF00	,RUF10	unused-noqa,TRY2	,TRY401	verbose-log-message,TRY4	,TRY300	try-consider-else,TRY201	verbose-raise,TRY002	raise-vanilla-class,TRY3	,TRY301	raise-within-try,TRY40	,TRY0	,TRY00	,TRY004	prefer-type-error,TRY400	error-instead-of-exception,TRY30	,TRY20	,TRY003	raise-vanilla-args,TRY200	reraise-no-cause}"
complete -c ruff -n "__fish_seen_subcommand_from check" -l line-length -d 'Set the line-length for length-associated rules and automatic formatting' -r
complete -c ruff -n "__fish_seen_subcommand_from check" -l dummy-variable-rgx -d 'Regular expression matching the name of dummy variables' -r
complete -c ruff -n "__fish_seen_subcommand_from check" -l cache-dir -d 'Path to the cache directory' -r -F
complete -c ruff -n "__fish_seen_subcommand_from check" -l stdin-filename -d 'The name of the file when passing it through stdin' -r -F
complete -c ruff -n "__fish_seen_subcommand_from check" -l fix -d 'Attempt to automatically fix lint violations'
complete -c ruff -n "__fish_seen_subcommand_from check" -l no-fix
complete -c ruff -n "__fish_seen_subcommand_from check" -l show-source -d 'Show violations with source code'
complete -c ruff -n "__fish_seen_subcommand_from check" -l no-show-source
complete -c ruff -n "__fish_seen_subcommand_from check" -l show-fixes -d 'Show an enumeration of all autofixed lint violations'
complete -c ruff -n "__fish_seen_subcommand_from check" -l no-show-fixes
complete -c ruff -n "__fish_seen_subcommand_from check" -l diff -d 'Avoid writing any fixed files back; instead, output a diff for each changed file to stdout'
complete -c ruff -n "__fish_seen_subcommand_from check" -s w -l watch -d 'Run in watch mode by re-running whenever files change'
complete -c ruff -n "__fish_seen_subcommand_from check" -l fix-only -d 'Fix any fixable lint violations, but don\'t report on leftover violations. Implies `--fix`'
complete -c ruff -n "__fish_seen_subcommand_from check" -l no-fix-only
complete -c ruff -n "__fish_seen_subcommand_from check" -l respect-gitignore -d 'Respect file exclusions via `.gitignore` and other standard ignore files'
complete -c ruff -n "__fish_seen_subcommand_from check" -l no-respect-gitignore
complete -c ruff -n "__fish_seen_subcommand_from check" -l force-exclude -d 'Enforce exclusions, even for paths passed to Ruff directly on the command-line'
complete -c ruff -n "__fish_seen_subcommand_from check" -l no-force-exclude
complete -c ruff -n "__fish_seen_subcommand_from check" -s n -l no-cache -d 'Disable cache reads'
complete -c ruff -n "__fish_seen_subcommand_from check" -l isolated -d 'Ignore all configuration files'
complete -c ruff -n "__fish_seen_subcommand_from check" -s e -l exit-zero -d 'Exit with status code "0", even upon detecting lint violations'
complete -c ruff -n "__fish_seen_subcommand_from check" -l exit-non-zero-on-fix -d 'Exit with a non-zero status code if any files were modified via autofix, even if no lint violations remain'
complete -c ruff -n "__fish_seen_subcommand_from check" -l update-check -d 'Does nothing and will be removed in the future'
complete -c ruff -n "__fish_seen_subcommand_from check" -l no-update-check
complete -c ruff -n "__fish_seen_subcommand_from check" -l statistics -d 'Show counts for every rule with at least one violation'
complete -c ruff -n "__fish_seen_subcommand_from check" -l add-noqa -d 'Enable automatic additions of `noqa` directives to failing lines'
complete -c ruff -n "__fish_seen_subcommand_from check" -l show-files -d 'See the files Ruff will be run against with the current settings'
complete -c ruff -n "__fish_seen_subcommand_from check" -l show-settings -d 'See the settings Ruff will use to lint a given Python file'
complete -c ruff -n "__fish_seen_subcommand_from check" -s v -l verbose -d 'Enable verbose logging'
complete -c ruff -n "__fish_seen_subcommand_from check" -s q -l quiet -d 'Print lint violations, but nothing else'
complete -c ruff -n "__fish_seen_subcommand_from check" -s s -l silent -d 'Disable all logging (but still exit with status code "1" upon detecting lint violations)'
complete -c ruff -n "__fish_seen_subcommand_from check" -s h -l help -d 'Print help'
complete -c ruff -n "__fish_seen_subcommand_from rule" -l format -d 'Output format' -r -f -a "{text	,json	}"
complete -c ruff -n "__fish_seen_subcommand_from rule" -s v -l verbose -d 'Enable verbose logging'
complete -c ruff -n "__fish_seen_subcommand_from rule" -s q -l quiet -d 'Print lint violations, but nothing else'
complete -c ruff -n "__fish_seen_subcommand_from rule" -s s -l silent -d 'Disable all logging (but still exit with status code "1" upon detecting lint violations)'
complete -c ruff -n "__fish_seen_subcommand_from rule" -s h -l help -d 'Print help'
complete -c ruff -n "__fish_seen_subcommand_from config" -s v -l verbose -d 'Enable verbose logging'
complete -c ruff -n "__fish_seen_subcommand_from config" -s q -l quiet -d 'Print lint violations, but nothing else'
complete -c ruff -n "__fish_seen_subcommand_from config" -s s -l silent -d 'Disable all logging (but still exit with status code "1" upon detecting lint violations)'
complete -c ruff -n "__fish_seen_subcommand_from config" -s h -l help -d 'Print help'
complete -c ruff -n "__fish_seen_subcommand_from linter" -l format -d 'Output format' -r -f -a "{text	,json	}"
complete -c ruff -n "__fish_seen_subcommand_from linter" -s v -l verbose -d 'Enable verbose logging'
complete -c ruff -n "__fish_seen_subcommand_from linter" -s q -l quiet -d 'Print lint violations, but nothing else'
complete -c ruff -n "__fish_seen_subcommand_from linter" -s s -l silent -d 'Disable all logging (but still exit with status code "1" upon detecting lint violations)'
complete -c ruff -n "__fish_seen_subcommand_from linter" -s h -l help -d 'Print help'
complete -c ruff -n "__fish_seen_subcommand_from clean" -s v -l verbose -d 'Enable verbose logging'
complete -c ruff -n "__fish_seen_subcommand_from clean" -s q -l quiet -d 'Print lint violations, but nothing else'
complete -c ruff -n "__fish_seen_subcommand_from clean" -s s -l silent -d 'Disable all logging (but still exit with status code "1" upon detecting lint violations)'
complete -c ruff -n "__fish_seen_subcommand_from clean" -s h -l help -d 'Print help'
complete -c ruff -n "__fish_seen_subcommand_from generate-shell-completion" -s v -l verbose -d 'Enable verbose logging'
complete -c ruff -n "__fish_seen_subcommand_from generate-shell-completion" -s q -l quiet -d 'Print lint violations, but nothing else'
complete -c ruff -n "__fish_seen_subcommand_from generate-shell-completion" -s s -l silent -d 'Disable all logging (but still exit with status code "1" upon detecting lint violations)'
complete -c ruff -n "__fish_seen_subcommand_from generate-shell-completion" -s h -l help -d 'Print help'
complete -c ruff -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from check; and not __fish_seen_subcommand_from rule; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from linter; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from generate-shell-completion; and not __fish_seen_subcommand_from help" -f -a "check" -d 'Run Ruff on the given files or directories (default)'
complete -c ruff -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from check; and not __fish_seen_subcommand_from rule; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from linter; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from generate-shell-completion; and not __fish_seen_subcommand_from help" -f -a "rule" -d 'Explain a rule'
complete -c ruff -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from check; and not __fish_seen_subcommand_from rule; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from linter; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from generate-shell-completion; and not __fish_seen_subcommand_from help" -f -a "config" -d 'List or describe the available configuration options'
complete -c ruff -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from check; and not __fish_seen_subcommand_from rule; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from linter; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from generate-shell-completion; and not __fish_seen_subcommand_from help" -f -a "linter" -d 'List all supported upstream linters'
complete -c ruff -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from check; and not __fish_seen_subcommand_from rule; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from linter; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from generate-shell-completion; and not __fish_seen_subcommand_from help" -f -a "clean" -d 'Clear any caches in the current directory and any subdirectories'
complete -c ruff -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from check; and not __fish_seen_subcommand_from rule; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from linter; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from generate-shell-completion; and not __fish_seen_subcommand_from help" -f -a "generate-shell-completion" -d 'Generate shell completion'
complete -c ruff -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from check; and not __fish_seen_subcommand_from rule; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from linter; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from generate-shell-completion; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
