"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createSvelteSys = void 0;
const utils_1 = require("./utils");
const fileCollection_1 = require("../../lib/documents/fileCollection");
/**
 * This should only be accessed by TS svelte module resolution.
 */
function createSvelteSys(getSnapshot, tsSystem) {
    const fileExistsCache = new fileCollection_1.FileMap();
    const svelteSys = {
        ...tsSystem,
        fileExists(path) {
            var _a;
            path = (0, utils_1.ensureRealSvelteFilePath)(path);
            const exists = (_a = fileExistsCache.get(path)) !== null && _a !== void 0 ? _a : tsSystem.fileExists(path);
            fileExistsCache.set(path, exists);
            return exists;
        },
        readFile(path) {
            const snapshot = getSnapshot(path);
            return snapshot.getText(0, snapshot.getLength());
        },
        readDirectory(path, extensions, exclude, include, depth) {
            const extensionsWithSvelte = (extensions !== null && extensions !== void 0 ? extensions : []).concat('.svelte');
            return tsSystem.readDirectory(path, extensionsWithSvelte, exclude, include, depth);
        },
        deleteFile(path) {
            var _a;
            fileExistsCache.delete((0, utils_1.ensureRealSvelteFilePath)(path));
            return (_a = tsSystem.deleteFile) === null || _a === void 0 ? void 0 : _a.call(tsSystem, path);
        },
        deleteFromCache(path) {
            fileExistsCache.delete((0, utils_1.ensureRealSvelteFilePath)(path));
        }
    };
    if (tsSystem.realpath) {
        const realpath = tsSystem.realpath;
        svelteSys.realpath = function (path) {
            if ((0, utils_1.isVirtualSvelteFilePath)(path)) {
                return realpath((0, utils_1.toRealSvelteFilePath)(path)) + '.ts';
            }
            return realpath(path);
        };
    }
    return svelteSys;
}
exports.createSvelteSys = createSvelteSys;
//# sourceMappingURL=svelte-sys.js.map