// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-avr.go from ATmega406.atdf, see http://packs.download.atmel.com/

//go:build avr && atmega406

// Device information for the ATmega406.
package avr

import (
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	DEVICE = "ATmega406"
	ARCH   = "AVR8"
	FAMILY = "megaAVR"
)

// Interrupts
const (
	IRQ_RESET         = 0  // External Pin, Power-on Reset, Brown-out Reset and Watchdog Reset
	IRQ_BPINT         = 1  // Battery Protection Interrupt
	IRQ_INT0          = 2  // External Interrupt Request 0
	IRQ_INT1          = 3  // External Interrupt Request 1
	IRQ_INT2          = 4  // External Interrupt Request 2
	IRQ_INT3          = 5  // External Interrupt Request 3
	IRQ_PCINT0        = 6  // Pin Change Interrupt 0
	IRQ_PCINT1        = 7  // Pin Change Interrupt 1
	IRQ_WDT           = 8  // Watchdog Timeout Interrupt
	IRQ_WAKE_UP       = 9  // Wakeup timer overflow
	IRQ_TIM1_COMP     = 10 // Timer/Counter 1 Compare Match
	IRQ_TIM1_OVF      = 11 // Timer/Counter 1 Overflow
	IRQ_TIM0_COMPA    = 12 // Timer/Counter0 Compare A Match
	IRQ_TIM0_COMPB    = 13 // Timer/Counter0 Compare B Match
	IRQ_TIM0_OVF      = 14 // Timer/Counter0 Overflow
	IRQ_TWI_BUS_CD    = 15 // Two-Wire Bus Connect/Disconnect
	IRQ_TWI           = 16 // Two-Wire Serial Interface
	IRQ_VADC          = 17 // Voltage ADC Conversion Complete
	IRQ_CCADC_CONV    = 18 // Coulomb Counter ADC Conversion Complete
	IRQ_CCADC_REG_CUR = 19 // Coloumb Counter ADC Regular Current
	IRQ_CCADC_ACC     = 20 // Coloumb Counter ADC Accumulator
	IRQ_EE_READY      = 21 // EEPROM Ready
	IRQ_SPM_READY     = 22 // Store Program Memory Ready
	IRQ_max           = 22 // Highest interrupt number on this device.
)

// Pseudo function call that is replaced by the compiler with the actual
// functions registered through interrupt.New.
//
//go:linkname callHandlers runtime/interrupt.callHandlers
func callHandlers(num int)

//export __vector_RESET
//go:interrupt
func interruptRESET() {
	callHandlers(IRQ_RESET)
}

//export __vector_BPINT
//go:interrupt
func interruptBPINT() {
	callHandlers(IRQ_BPINT)
}

//export __vector_INT0
//go:interrupt
func interruptINT0() {
	callHandlers(IRQ_INT0)
}

//export __vector_INT1
//go:interrupt
func interruptINT1() {
	callHandlers(IRQ_INT1)
}

//export __vector_INT2
//go:interrupt
func interruptINT2() {
	callHandlers(IRQ_INT2)
}

//export __vector_INT3
//go:interrupt
func interruptINT3() {
	callHandlers(IRQ_INT3)
}

//export __vector_PCINT0
//go:interrupt
func interruptPCINT0() {
	callHandlers(IRQ_PCINT0)
}

//export __vector_PCINT1
//go:interrupt
func interruptPCINT1() {
	callHandlers(IRQ_PCINT1)
}

//export __vector_WDT
//go:interrupt
func interruptWDT() {
	callHandlers(IRQ_WDT)
}

//export __vector_WAKE_UP
//go:interrupt
func interruptWAKE_UP() {
	callHandlers(IRQ_WAKE_UP)
}

//export __vector_TIM1_COMP
//go:interrupt
func interruptTIM1_COMP() {
	callHandlers(IRQ_TIM1_COMP)
}

//export __vector_TIM1_OVF
//go:interrupt
func interruptTIM1_OVF() {
	callHandlers(IRQ_TIM1_OVF)
}

//export __vector_TIM0_COMPA
//go:interrupt
func interruptTIM0_COMPA() {
	callHandlers(IRQ_TIM0_COMPA)
}

//export __vector_TIM0_COMPB
//go:interrupt
func interruptTIM0_COMPB() {
	callHandlers(IRQ_TIM0_COMPB)
}

//export __vector_TIM0_OVF
//go:interrupt
func interruptTIM0_OVF() {
	callHandlers(IRQ_TIM0_OVF)
}

//export __vector_TWI_BUS_CD
//go:interrupt
func interruptTWI_BUS_CD() {
	callHandlers(IRQ_TWI_BUS_CD)
}

//export __vector_TWI
//go:interrupt
func interruptTWI() {
	callHandlers(IRQ_TWI)
}

//export __vector_VADC
//go:interrupt
func interruptVADC() {
	callHandlers(IRQ_VADC)
}

//export __vector_CCADC_CONV
//go:interrupt
func interruptCCADC_CONV() {
	callHandlers(IRQ_CCADC_CONV)
}

//export __vector_CCADC_REG_CUR
//go:interrupt
func interruptCCADC_REG_CUR() {
	callHandlers(IRQ_CCADC_REG_CUR)
}

//export __vector_CCADC_ACC
//go:interrupt
func interruptCCADC_ACC() {
	callHandlers(IRQ_CCADC_ACC)
}

//export __vector_EE_READY
//go:interrupt
func interruptEE_READY() {
	callHandlers(IRQ_EE_READY)
}

//export __vector_SPM_READY
//go:interrupt
func interruptSPM_READY() {
	callHandlers(IRQ_SPM_READY)
}

// Peripherals.
var (
	// Fuses
	HIGH = (*volatile.Register8)(unsafe.Pointer(uintptr(0x1)))
	LOW  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x0)))

	// Lockbits
	LOCKBIT = (*volatile.Register8)(unsafe.Pointer(uintptr(0x0)))

	// Analog-to-Digital Converter
	VADMUX = (*volatile.Register8)(unsafe.Pointer(uintptr(0x7c)))
	VADCL  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x78)))
	VADCH  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x79)))
	VADCSR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x7a)))

	// External Interrupts
	EICRA  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x69)))
	EIMSK  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3d)))
	EIFR   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3c)))
	PCICR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x68)))
	PCIFR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3b)))
	PCMSK1 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x6c)))
	PCMSK0 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x6b)))

	// Timer/Counter, 16-bit
	TCCR1B = (*volatile.Register8)(unsafe.Pointer(uintptr(0x81)))
	TCNT1L = (*volatile.Register8)(unsafe.Pointer(uintptr(0x84)))
	TCNT1H = (*volatile.Register8)(unsafe.Pointer(uintptr(0x85)))
	OCR1AL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x88)))
	OCR1AH = (*volatile.Register8)(unsafe.Pointer(uintptr(0x89)))
	TIMSK1 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x6f)))
	TIFR1  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x36)))
	GTCCR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x43)))

	// Wakeup Timer
	WUTCSR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x62)))

	// Battery Protection
	BPPLR = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf8)))
	BPCR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf7)))
	CBPTR = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf6)))
	BPOCD = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf5)))
	BPSCD = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf4)))
	BPDUV = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf3)))
	BPIR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf2)))

	// FET Control
	FCSR = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf0)))

	// Coulomb Counter
	CADCSRA = (*volatile.Register8)(unsafe.Pointer(uintptr(0xe4)))
	CADCSRB = (*volatile.Register8)(unsafe.Pointer(uintptr(0xe5)))
	CADICL  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xe8)))
	CADICH  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xe9)))
	CADAC3  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xe3)))
	CADAC2  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xe2)))
	CADAC1  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xe1)))
	CADAC0  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xe0)))
	CADRCC  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xe6)))
	CADRDC  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xe7)))

	// Cell Balancing
	CBCR = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf1)))

	// CPU Registers
	SREG    = (*volatile.Register8)(unsafe.Pointer(uintptr(0x5f)))
	SPL     = (*volatile.Register8)(unsafe.Pointer(uintptr(0x5d)))
	SPH     = (*volatile.Register8)(unsafe.Pointer(uintptr(0x5e)))
	MCUCR   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x55)))
	MCUSR   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x54)))
	FOSCCAL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x66)))
	SMCR    = (*volatile.Register8)(unsafe.Pointer(uintptr(0x53)))
	GPIOR2  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4b)))
	GPIOR1  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4a)))
	GPIOR0  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3e)))
	CCSR    = (*volatile.Register8)(unsafe.Pointer(uintptr(0xc0)))
	DIDR0   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x7e)))
	PRR0    = (*volatile.Register8)(unsafe.Pointer(uintptr(0x64)))

	// Watchdog Timer
	WDTCSR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x60)))

	// Timer/Counter, 8-bit
	TCCR0A = (*volatile.Register8)(unsafe.Pointer(uintptr(0x44)))
	TCCR0B = (*volatile.Register8)(unsafe.Pointer(uintptr(0x45)))
	TCNT0  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x46)))
	OCR0A  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x47)))
	OCR0B  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x48)))
	TIMSK0 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x6e)))
	TIFR0  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x35)))

	// I/O Port
	PORTA = (*volatile.Register8)(unsafe.Pointer(uintptr(0x22)))
	DDRA  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x21)))
	PINA  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x20)))
	PORTB = (*volatile.Register8)(unsafe.Pointer(uintptr(0x25)))
	DDRB  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x24)))
	PINB  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x23)))
	PORTC = (*volatile.Register8)(unsafe.Pointer(uintptr(0x28)))
	PORTD = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2b)))
	DDRD  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2a)))
	PIND  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x29)))

	// Bootloader
	SPMCSR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x57)))

	// Two Wire Serial Interface
	TWBCSR = (*volatile.Register8)(unsafe.Pointer(uintptr(0xbe)))
	TWAMR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xbd)))
	TWBR   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xb8)))
	TWCR   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xbc)))
	TWSR   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xb9)))
	TWDR   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xbb)))
	TWAR   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xba)))

	// Bandgap
	BGCRR = (*volatile.Register8)(unsafe.Pointer(uintptr(0xd1)))
	BGCCR = (*volatile.Register8)(unsafe.Pointer(uintptr(0xd0)))

	// EEPROM
	EEARL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x41)))
	EEARH = (*volatile.Register8)(unsafe.Pointer(uintptr(0x42)))
	EEDR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x40)))
	EECR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3f)))
)

// Bitfields for FUSE: Fuses
const (
	// HIGH
	HIGH_OCDEN      = 0x2 // On-Chip Debug Enabled
	HIGH_OCDEN_Msk  = 0x2 // On-Chip Debug Enabled
	HIGH_JTAGEN     = 0x1 // JTAG Interface Enabled
	HIGH_JTAGEN_Msk = 0x1 // JTAG Interface Enabled

	// LOW
	LOW_WDTON         = 0x80 // Watchdog timer always on
	LOW_WDTON_Msk     = 0x80 // Watchdog timer always on
	LOW_EESAVE        = 0x40 // Preserve EEPROM through the Chip Erase cycle
	LOW_EESAVE_Msk    = 0x40 // Preserve EEPROM through the Chip Erase cycle
	LOW_BOOTSZ0       = 0x10 // Select boot size
	LOW_BOOTSZ1       = 0x20 // Select boot size
	LOW_BOOTSZ_Msk    = 0x30 // Select boot size
	LOW_BOOTRST       = 0x8  // Boot Reset vector Enabled
	LOW_BOOTRST_Msk   = 0x8  // Boot Reset vector Enabled
	LOW_SUT_CKSEL0    = 0x1  // Clock Selection
	LOW_SUT_CKSEL1    = 0x2  // Clock Selection
	LOW_SUT_CKSEL2    = 0x4  // Clock Selection
	LOW_SUT_CKSEL_Msk = 0x7  // Clock Selection
)

// Bitfields for LOCKBIT: Lockbits
const (
	// LOCKBIT
	LOCKBIT_LB0      = 0x1  // Memory Lock
	LOCKBIT_LB1      = 0x2  // Memory Lock
	LOCKBIT_LB_Msk   = 0x3  // Memory Lock
	LOCKBIT_BLB00    = 0x4  // Boot Loader Protection Mode
	LOCKBIT_BLB01    = 0x8  // Boot Loader Protection Mode
	LOCKBIT_BLB0_Msk = 0xc  // Boot Loader Protection Mode
	LOCKBIT_BLB10    = 0x10 // Boot Loader Protection Mode
	LOCKBIT_BLB11    = 0x20 // Boot Loader Protection Mode
	LOCKBIT_BLB1_Msk = 0x30 // Boot Loader Protection Mode
)

// Bitfields for ADC: Analog-to-Digital Converter
const (
	// VADMUX: The VADC multiplexer Selection Register
	VADMUX_VADMUX0    = 0x1 // Analog Channel and Gain Selection Bits
	VADMUX_VADMUX1    = 0x2 // Analog Channel and Gain Selection Bits
	VADMUX_VADMUX2    = 0x4 // Analog Channel and Gain Selection Bits
	VADMUX_VADMUX3    = 0x8 // Analog Channel and Gain Selection Bits
	VADMUX_VADMUX_Msk = 0xf // Analog Channel and Gain Selection Bits

	// VADCSR: The VADC Control and Status register
	VADCSR_VADEN       = 0x8 // VADC Enable
	VADCSR_VADEN_Msk   = 0x8 // VADC Enable
	VADCSR_VADSC       = 0x4 // VADC Satrt Conversion
	VADCSR_VADSC_Msk   = 0x4 // VADC Satrt Conversion
	VADCSR_VADCCIF     = 0x2 // VADC Conversion Complete Interrupt Flag
	VADCSR_VADCCIF_Msk = 0x2 // VADC Conversion Complete Interrupt Flag
	VADCSR_VADCCIE     = 0x1 // VADC Conversion Complete Interrupt Enable
	VADCSR_VADCCIE_Msk = 0x1 // VADC Conversion Complete Interrupt Enable
)

// Bitfields for EXINT: External Interrupts
const (
	// EICRA: External Interrupt Control Register
	EICRA_ISC30    = 0x40 // External Interrupt Sense Control 3 Bits
	EICRA_ISC31    = 0x80 // External Interrupt Sense Control 3 Bits
	EICRA_ISC3_Msk = 0xc0 // External Interrupt Sense Control 3 Bits
	EICRA_ISC20    = 0x10 // External Interrupt Sense Control 2 Bits
	EICRA_ISC21    = 0x20 // External Interrupt Sense Control 2 Bits
	EICRA_ISC2_Msk = 0x30 // External Interrupt Sense Control 2 Bits
	EICRA_ISC10    = 0x4  // External Interrupt Sense Control 1 Bits
	EICRA_ISC11    = 0x8  // External Interrupt Sense Control 1 Bits
	EICRA_ISC1_Msk = 0xc  // External Interrupt Sense Control 1 Bits
	EICRA_ISC00    = 0x1  // External Interrupt Sense Control 0 Bits
	EICRA_ISC01    = 0x2  // External Interrupt Sense Control 0 Bits
	EICRA_ISC0_Msk = 0x3  // External Interrupt Sense Control 0 Bits

	// EIMSK: External Interrupt Mask Register
	EIMSK_INT0    = 0x1 // External Interrupt Request 1 Enable
	EIMSK_INT1    = 0x2 // External Interrupt Request 1 Enable
	EIMSK_INT2    = 0x4 // External Interrupt Request 1 Enable
	EIMSK_INT3    = 0x8 // External Interrupt Request 1 Enable
	EIMSK_INT_Msk = 0xf // External Interrupt Request 1 Enable

	// EIFR: External Interrupt Flag Register
	EIFR_INTF0    = 0x1 // External Interrupt Flags
	EIFR_INTF1    = 0x2 // External Interrupt Flags
	EIFR_INTF2    = 0x4 // External Interrupt Flags
	EIFR_INTF3    = 0x8 // External Interrupt Flags
	EIFR_INTF_Msk = 0xf // External Interrupt Flags

	// PCICR: Pin Change Interrupt Control Register
	PCICR_PCIE0    = 0x1 // Pin Change Interrupt Enables
	PCICR_PCIE1    = 0x2 // Pin Change Interrupt Enables
	PCICR_PCIE_Msk = 0x3 // Pin Change Interrupt Enables

	// PCIFR: Pin Change Interrupt Flag Register
	PCIFR_PCIF0    = 0x1 // Pin Change Interrupt Flags
	PCIFR_PCIF1    = 0x2 // Pin Change Interrupt Flags
	PCIFR_PCIF_Msk = 0x3 // Pin Change Interrupt Flags
)

// Bitfields for TC16: Timer/Counter, 16-bit
const (
	// TCCR1B: Timer/Counter1 Control Register B
	TCCR1B_CTC1     = 0x8 // Clear Timer/Counter on Compare Match
	TCCR1B_CTC1_Msk = 0x8 // Clear Timer/Counter on Compare Match
	TCCR1B_CS10     = 0x1 // Clock Select1 bits
	TCCR1B_CS11     = 0x2 // Clock Select1 bits
	TCCR1B_CS12     = 0x4 // Clock Select1 bits
	TCCR1B_CS1_Msk  = 0x7 // Clock Select1 bits

	// TIMSK1: Timer/Counter Interrupt Mask Register
	TIMSK1_OCIE1A     = 0x2 // Timer/Counter1 Output Compare Interrupt Enable
	TIMSK1_OCIE1A_Msk = 0x2 // Timer/Counter1 Output Compare Interrupt Enable
	TIMSK1_TOIE1      = 0x1 // Timer/Counter1 Overflow Interrupt Enable
	TIMSK1_TOIE1_Msk  = 0x1 // Timer/Counter1 Overflow Interrupt Enable

	// TIFR1: Timer/Counter Interrupt Flag register
	TIFR1_OCF1A     = 0x2 // Timer/Counter1 Output Compare Flag A
	TIFR1_OCF1A_Msk = 0x2 // Timer/Counter1 Output Compare Flag A
	TIFR1_TOV1      = 0x1 // Timer/Counter1 Overflow Flag
	TIFR1_TOV1_Msk  = 0x1 // Timer/Counter1 Overflow Flag

	// GTCCR: General Timer/Counter Control Register
	GTCCR_TSM         = 0x80 // Timer/Counter Synchronization Mode
	GTCCR_TSM_Msk     = 0x80 // Timer/Counter Synchronization Mode
	GTCCR_PSRSYNC     = 0x1  // Prescaler Reset
	GTCCR_PSRSYNC_Msk = 0x1  // Prescaler Reset
)

// Bitfields for WAKEUP_TIMER: Wakeup Timer
const (
	// WUTCSR: Wake-up Timer Control Register
	WUTCSR_WUTIF     = 0x80 // Wake-up Timer Interrupt Flag
	WUTCSR_WUTIF_Msk = 0x80 // Wake-up Timer Interrupt Flag
	WUTCSR_WUTIE     = 0x40 // Wake-up Timer Interrupt Enable
	WUTCSR_WUTIE_Msk = 0x40 // Wake-up Timer Interrupt Enable
	WUTCSR_WUTCF     = 0x20 // Wake-up timer Calibration Flag
	WUTCSR_WUTCF_Msk = 0x20 // Wake-up timer Calibration Flag
	WUTCSR_WUTR      = 0x10 // Wake-up Timer Reset
	WUTCSR_WUTR_Msk  = 0x10 // Wake-up Timer Reset
	WUTCSR_WUTE      = 0x8  // Wake-up Timer Enable
	WUTCSR_WUTE_Msk  = 0x8  // Wake-up Timer Enable
	WUTCSR_WUTP0     = 0x1  // Wake-up Timer Prescaler Bits
	WUTCSR_WUTP1     = 0x2  // Wake-up Timer Prescaler Bits
	WUTCSR_WUTP2     = 0x4  // Wake-up Timer Prescaler Bits
	WUTCSR_WUTP_Msk  = 0x7  // Wake-up Timer Prescaler Bits
)

// Bitfields for BATTERY_PROTECTION: Battery Protection
const (
	// BPPLR: Battery Protection Parameter Lock Register
	BPPLR_BPPLE     = 0x2 // Battery Protection Parameter Lock Enable
	BPPLR_BPPLE_Msk = 0x2 // Battery Protection Parameter Lock Enable
	BPPLR_BPPL      = 0x1 // Battery Protection Parameter Lock
	BPPLR_BPPL_Msk  = 0x1 // Battery Protection Parameter Lock

	// BPCR: Battery Protection Control Register
	BPCR_DUVD     = 0x8
	BPCR_DUVD_Msk = 0x8
	BPCR_SCD      = 0x4
	BPCR_SCD_Msk  = 0x4
	BPCR_DCD      = 0x2
	BPCR_DCD_Msk  = 0x2
	BPCR_CCD      = 0x1
	BPCR_CCD_Msk  = 0x1

	// CBPTR: Current Battery Protection Timing Register
	CBPTR_SCPT0    = 0x10
	CBPTR_SCPT1    = 0x20
	CBPTR_SCPT2    = 0x40
	CBPTR_SCPT3    = 0x80
	CBPTR_SCPT_Msk = 0xf0
	CBPTR_OCPT0    = 0x1
	CBPTR_OCPT1    = 0x2
	CBPTR_OCPT2    = 0x4
	CBPTR_OCPT3    = 0x8
	CBPTR_OCPT_Msk = 0xf

	// BPOCD: Battery Protection OverCurrent Detection Level Register
	BPOCD_DCDL0    = 0x10
	BPOCD_DCDL1    = 0x20
	BPOCD_DCDL2    = 0x40
	BPOCD_DCDL3    = 0x80
	BPOCD_DCDL_Msk = 0xf0
	BPOCD_CCDL0    = 0x1
	BPOCD_CCDL1    = 0x2
	BPOCD_CCDL2    = 0x4
	BPOCD_CCDL3    = 0x8
	BPOCD_CCDL_Msk = 0xf

	// BPSCD: Battery Protection Short-Circuit Detection Level Register
	BPSCD_SCDL0    = 0x1
	BPSCD_SCDL1    = 0x2
	BPSCD_SCDL2    = 0x4
	BPSCD_SCDL3    = 0x8
	BPSCD_SCDL_Msk = 0xf

	// BPDUV: Battery Protection Deep Under Voltage Register
	BPDUV_DUVT0    = 0x10
	BPDUV_DUVT1    = 0x20
	BPDUV_DUVT_Msk = 0x30
	BPDUV_DUDL0    = 0x1
	BPDUV_DUDL1    = 0x2
	BPDUV_DUDL2    = 0x4
	BPDUV_DUDL3    = 0x8
	BPDUV_DUDL_Msk = 0xf

	// BPIR: Battery Protection Interrupt Register
	BPIR_DUVIF     = 0x80 // Deep Under-voltage Early Warning Interrupt Flag
	BPIR_DUVIF_Msk = 0x80 // Deep Under-voltage Early Warning Interrupt Flag
	BPIR_COCIF     = 0x40 // Charge Over-current Protection Activated Interrupt Flag
	BPIR_COCIF_Msk = 0x40 // Charge Over-current Protection Activated Interrupt Flag
	BPIR_DOCIF     = 0x20
	BPIR_DOCIF_Msk = 0x20
	BPIR_SCIF      = 0x10
	BPIR_SCIF_Msk  = 0x10
	BPIR_DUVIE     = 0x8 // Deep Under-voltage Early Warning Interrupt Enable
	BPIR_DUVIE_Msk = 0x8 // Deep Under-voltage Early Warning Interrupt Enable
	BPIR_COCIE     = 0x4
	BPIR_COCIE_Msk = 0x4
	BPIR_DOCIE     = 0x2
	BPIR_DOCIE_Msk = 0x2
	BPIR_SCIE      = 0x1
	BPIR_SCIE_Msk  = 0x1
)

// Bitfields for FET: FET Control
const (
	// FCSR
	FCSR_PWMOC      = 0x20 // Pulse Width Modulation of OC output
	FCSR_PWMOC_Msk  = 0x20 // Pulse Width Modulation of OC output
	FCSR_PWMOPC     = 0x10 // Pulse Width Modulation Modulation of OPC output
	FCSR_PWMOPC_Msk = 0x10 // Pulse Width Modulation Modulation of OPC output
	FCSR_CPS        = 0x8  // Current Protection Status
	FCSR_CPS_Msk    = 0x8  // Current Protection Status
	FCSR_DFE        = 0x4  // Discharge FET Enable
	FCSR_DFE_Msk    = 0x4  // Discharge FET Enable
	FCSR_CFE        = 0x2  // Charge FET Enable
	FCSR_CFE_Msk    = 0x2  // Charge FET Enable
	FCSR_PFD        = 0x1  // Precharge FET disable
	FCSR_PFD_Msk    = 0x1  // Precharge FET disable
)

// Bitfields for COULOMB_COUNTER: Coulomb Counter
const (
	// CADCSRA: CC-ADC Control and Status Register A
	CADCSRA_CADEN     = 0x80 // When the CADEN bit is cleared (zero), the CC-ADC is disabled. When the CADEN bit is set (one), the CC-ADC will continuously measure the voltage drop over the external sense resistor RSENSE. In Power-down, only the Regular Current detection is active. In Power-off, the CC-ADC is always disabled.
	CADCSRA_CADEN_Msk = 0x80 // When the CADEN bit is cleared (zero), the CC-ADC is disabled. When the CADEN bit is set (one), the CC-ADC will continuously measure the voltage drop over the external sense resistor RSENSE. In Power-down, only the Regular Current detection is active. In Power-off, the CC-ADC is always disabled.
	CADCSRA_CADUB     = 0x20 // CC_ADC Update Busy
	CADCSRA_CADUB_Msk = 0x20 // CC_ADC Update Busy
	CADCSRA_CADAS0    = 0x8  // CC_ADC Accumulate Current Select Bits
	CADCSRA_CADAS1    = 0x10 // CC_ADC Accumulate Current Select Bits
	CADCSRA_CADAS_Msk = 0x18 // CC_ADC Accumulate Current Select Bits
	CADCSRA_CADSI0    = 0x2  // The CADSI bits determine the current sampling interval for the Regular Current detection in Power-down mode. The actual settings remain to be determined.
	CADCSRA_CADSI1    = 0x4  // The CADSI bits determine the current sampling interval for the Regular Current detection in Power-down mode. The actual settings remain to be determined.
	CADCSRA_CADSI_Msk = 0x6  // The CADSI bits determine the current sampling interval for the Regular Current detection in Power-down mode. The actual settings remain to be determined.
	CADCSRA_CADSE     = 0x1  // When the CADSE bit is written to one, the ongoing CC-ADC conversion is aborted, and the CC-ADC enters Regular Current detection mode.
	CADCSRA_CADSE_Msk = 0x1  // When the CADSE bit is written to one, the ongoing CC-ADC conversion is aborted, and the CC-ADC enters Regular Current detection mode.

	// CADCSRB: CC-ADC Control and Status Register B
	CADCSRB_CADACIE     = 0x40
	CADCSRB_CADACIE_Msk = 0x40
	CADCSRB_CADRCIE     = 0x20 // Regular Current Interrupt Enable
	CADCSRB_CADRCIE_Msk = 0x20 // Regular Current Interrupt Enable
	CADCSRB_CADICIE     = 0x10 // CAD Instantenous Current Interrupt Enable
	CADCSRB_CADICIE_Msk = 0x10 // CAD Instantenous Current Interrupt Enable
	CADCSRB_CADACIF     = 0x4  // CC-ADC Accumulate Current Interrupt Flag
	CADCSRB_CADACIF_Msk = 0x4  // CC-ADC Accumulate Current Interrupt Flag
	CADCSRB_CADRCIF     = 0x2  // CC-ADC Accumulate Current Interrupt Flag
	CADCSRB_CADRCIF_Msk = 0x2  // CC-ADC Accumulate Current Interrupt Flag
	CADCSRB_CADICIF     = 0x1  // CC-ADC Instantaneous Current Interrupt Flag
	CADCSRB_CADICIF_Msk = 0x1  // CC-ADC Instantaneous Current Interrupt Flag
)

// Bitfields for CELL_BALANCING: Cell Balancing
const (
	// CBCR: Cell Balancing Control Register
	CBCR_CBE0    = 0x1 // Cell Balancing Enables
	CBCR_CBE1    = 0x2 // Cell Balancing Enables
	CBCR_CBE2    = 0x4 // Cell Balancing Enables
	CBCR_CBE3    = 0x8 // Cell Balancing Enables
	CBCR_CBE_Msk = 0xf // Cell Balancing Enables
)

// Bitfields for CPU: CPU Registers
const (
	// SREG: Status Register
	SREG_I     = 0x80 // Global Interrupt Enable
	SREG_I_Msk = 0x80 // Global Interrupt Enable
	SREG_T     = 0x40 // Bit Copy Storage
	SREG_T_Msk = 0x40 // Bit Copy Storage
	SREG_H     = 0x20 // Half Carry Flag
	SREG_H_Msk = 0x20 // Half Carry Flag
	SREG_S     = 0x10 // Sign Bit
	SREG_S_Msk = 0x10 // Sign Bit
	SREG_V     = 0x8  // Two's Complement Overflow Flag
	SREG_V_Msk = 0x8  // Two's Complement Overflow Flag
	SREG_N     = 0x4  // Negative Flag
	SREG_N_Msk = 0x4  // Negative Flag
	SREG_Z     = 0x2  // Zero Flag
	SREG_Z_Msk = 0x2  // Zero Flag
	SREG_C     = 0x1  // Carry Flag
	SREG_C_Msk = 0x1  // Carry Flag

	// MCUCR: MCU Control Register
	MCUCR_JTD       = 0x80 // JTAG Disable
	MCUCR_JTD_Msk   = 0x80 // JTAG Disable
	MCUCR_PUD       = 0x10 // Pull-up disable
	MCUCR_PUD_Msk   = 0x10 // Pull-up disable
	MCUCR_IVSEL     = 0x2  // Interrupt Vector Select
	MCUCR_IVSEL_Msk = 0x2  // Interrupt Vector Select
	MCUCR_IVCE      = 0x1  // Interrupt Vector Change Enable
	MCUCR_IVCE_Msk  = 0x1  // Interrupt Vector Change Enable

	// MCUSR: MCU Status Register
	MCUSR_JTRF      = 0x10 // JTAG Reset Flag
	MCUSR_JTRF_Msk  = 0x10 // JTAG Reset Flag
	MCUSR_WDRF      = 0x8  // Watchdog Reset Flag
	MCUSR_WDRF_Msk  = 0x8  // Watchdog Reset Flag
	MCUSR_BODRF     = 0x4  // Brown-out Reset Flag
	MCUSR_BODRF_Msk = 0x4  // Brown-out Reset Flag
	MCUSR_EXTRF     = 0x2  // External Reset Flag
	MCUSR_EXTRF_Msk = 0x2  // External Reset Flag
	MCUSR_PORF      = 0x1  // Power-on reset flag
	MCUSR_PORF_Msk  = 0x1  // Power-on reset flag

	// SMCR: Sleep Mode Control Register
	SMCR_SM0    = 0x2 // Sleep Mode Select bits
	SMCR_SM1    = 0x4 // Sleep Mode Select bits
	SMCR_SM2    = 0x8 // Sleep Mode Select bits
	SMCR_SM_Msk = 0xe // Sleep Mode Select bits
	SMCR_SE     = 0x1 // Sleep Enable
	SMCR_SE_Msk = 0x1 // Sleep Enable

	// CCSR: Clock Control and Status Register
	CCSR_XOE     = 0x2 // 32 kHz Crystal Oscillator Enable
	CCSR_XOE_Msk = 0x2 // 32 kHz Crystal Oscillator Enable
	CCSR_ACS     = 0x1 // Asynchronous Clock Select
	CCSR_ACS_Msk = 0x1 // Asynchronous Clock Select

	// PRR0: Power Reduction Register 0
	PRR0_PRTWI      = 0x8 // Power Reduction TWI
	PRR0_PRTWI_Msk  = 0x8 // Power Reduction TWI
	PRR0_PRTIM1     = 0x4 // Power Reduction Timer/Counter1
	PRR0_PRTIM1_Msk = 0x4 // Power Reduction Timer/Counter1
	PRR0_PRTIM0     = 0x2 // Power Reduction Timer/Counter0
	PRR0_PRTIM0_Msk = 0x2 // Power Reduction Timer/Counter0
	PRR0_PRVADC     = 0x1 // Power Reduction V-ADC
	PRR0_PRVADC_Msk = 0x1 // Power Reduction V-ADC
)

// Bitfields for WDT: Watchdog Timer
const (
	// WDTCSR: Watchdog Timer Control Register
	WDTCSR_WDIF     = 0x80 // Watchdog Timeout Interrupt Flag
	WDTCSR_WDIF_Msk = 0x80 // Watchdog Timeout Interrupt Flag
	WDTCSR_WDIE     = 0x40 // Watchdog Timeout Interrupt Enable
	WDTCSR_WDIE_Msk = 0x40 // Watchdog Timeout Interrupt Enable
	WDTCSR_WDP0     = 0x1  // Watchdog Timer Prescaler Bits
	WDTCSR_WDP1     = 0x2  // Watchdog Timer Prescaler Bits
	WDTCSR_WDP2     = 0x4  // Watchdog Timer Prescaler Bits
	WDTCSR_WDP3     = 0x20 // Watchdog Timer Prescaler Bits
	WDTCSR_WDP_Msk  = 0x27 // Watchdog Timer Prescaler Bits
	WDTCSR_WDCE     = 0x10 // Watchdog Change Enable
	WDTCSR_WDCE_Msk = 0x10 // Watchdog Change Enable
	WDTCSR_WDE      = 0x8  // Watch Dog Enable
	WDTCSR_WDE_Msk  = 0x8  // Watch Dog Enable
)

// Bitfields for TC8: Timer/Counter, 8-bit
const (
	// TCCR0A: Timer/Counter0 Control Register
	TCCR0A_COM0A0    = 0x40 // Force Output Compare
	TCCR0A_COM0A1    = 0x80 // Force Output Compare
	TCCR0A_COM0A_Msk = 0xc0 // Force Output Compare
	TCCR0A_COM0B0    = 0x10
	TCCR0A_COM0B1    = 0x20
	TCCR0A_COM0B_Msk = 0x30
	TCCR0A_WGM00     = 0x1 // Clock Select0 bits
	TCCR0A_WGM01     = 0x2 // Clock Select0 bits
	TCCR0A_WGM0_Msk  = 0x3 // Clock Select0 bits

	// TCCR0B: Timer/Counter0 Control Register
	TCCR0B_FOC0A     = 0x80 // Force Output Compare
	TCCR0B_FOC0A_Msk = 0x80 // Force Output Compare
	TCCR0B_FOC0B     = 0x40 // Waveform Generation Mode
	TCCR0B_FOC0B_Msk = 0x40 // Waveform Generation Mode
	TCCR0B_WGM02     = 0x8
	TCCR0B_WGM02_Msk = 0x8
	TCCR0B_CS00      = 0x1 // Clock Select0 bits
	TCCR0B_CS01      = 0x2 // Clock Select0 bits
	TCCR0B_CS02      = 0x4 // Clock Select0 bits
	TCCR0B_CS0_Msk   = 0x7 // Clock Select0 bits

	// OCR0A: Output compare Register A
	OCR0A_OCR0A0    = 0x1
	OCR0A_OCR0A1    = 0x2
	OCR0A_OCR0A2    = 0x4
	OCR0A_OCR0A3    = 0x8
	OCR0A_OCR0A4    = 0x10
	OCR0A_OCR0A5    = 0x20
	OCR0A_OCR0A6    = 0x40
	OCR0A_OCR0A7    = 0x80
	OCR0A_OCR0A_Msk = 0xff

	// OCR0B: Output compare Register B
	OCR0B_OCR0B0    = 0x1
	OCR0B_OCR0B1    = 0x2
	OCR0B_OCR0B2    = 0x4
	OCR0B_OCR0B3    = 0x8
	OCR0B_OCR0B4    = 0x10
	OCR0B_OCR0B5    = 0x20
	OCR0B_OCR0B6    = 0x40
	OCR0B_OCR0B7    = 0x80
	OCR0B_OCR0B_Msk = 0xff

	// TIMSK0: Timer/Counter Interrupt Mask Register
	TIMSK0_OCIE0B     = 0x4 // Output Compare Interrupt Enable
	TIMSK0_OCIE0B_Msk = 0x4 // Output Compare Interrupt Enable
	TIMSK0_OCIE0A     = 0x2 // Output Compare Interrupt Enable
	TIMSK0_OCIE0A_Msk = 0x2 // Output Compare Interrupt Enable
	TIMSK0_TOIE0      = 0x1 // Overflow Interrupt Enable
	TIMSK0_TOIE0_Msk  = 0x1 // Overflow Interrupt Enable

	// TIFR0: Timer/Counter Interrupt Flag register
	TIFR0_OCF0B     = 0x4 // Output Compare Flag
	TIFR0_OCF0B_Msk = 0x4 // Output Compare Flag
	TIFR0_OCF0A     = 0x2 // Output Compare Flag
	TIFR0_OCF0A_Msk = 0x2 // Output Compare Flag
	TIFR0_TOV0      = 0x1 // Overflow Flag
	TIFR0_TOV0_Msk  = 0x1 // Overflow Flag
)

// Bitfields for BOOT_LOAD: Bootloader
const (
	// SPMCSR: Store Program Memory Control Register
	SPMCSR_SPMIE      = 0x80 // SPM Interrupt Enable
	SPMCSR_SPMIE_Msk  = 0x80 // SPM Interrupt Enable
	SPMCSR_RWWSB      = 0x40 // Read While Write Section Busy
	SPMCSR_RWWSB_Msk  = 0x40 // Read While Write Section Busy
	SPMCSR_SIGRD      = 0x20 // Signature Row Read
	SPMCSR_SIGRD_Msk  = 0x20 // Signature Row Read
	SPMCSR_RWWSRE     = 0x10 // Read While Write section read enable
	SPMCSR_RWWSRE_Msk = 0x10 // Read While Write section read enable
	SPMCSR_BLBSET     = 0x8  // Boot Lock Bit Set
	SPMCSR_BLBSET_Msk = 0x8  // Boot Lock Bit Set
	SPMCSR_PGWRT      = 0x4  // Page Write
	SPMCSR_PGWRT_Msk  = 0x4  // Page Write
	SPMCSR_PGERS      = 0x2  // Page Erase
	SPMCSR_PGERS_Msk  = 0x2  // Page Erase
	SPMCSR_SPMEN      = 0x1  // Store Program Memory Enable
	SPMCSR_SPMEN_Msk  = 0x1  // Store Program Memory Enable
)

// Bitfields for TWI: Two Wire Serial Interface
const (
	// TWBCSR: TWI Bus Control and Status Register
	TWBCSR_TWBCIF     = 0x80 // TWI Bus Connect/Disconnect Interrupt Flag
	TWBCSR_TWBCIF_Msk = 0x80 // TWI Bus Connect/Disconnect Interrupt Flag
	TWBCSR_TWBCIE     = 0x40 // TWI Bus Connect/Disconnect Interrupt Enable
	TWBCSR_TWBCIE_Msk = 0x40 // TWI Bus Connect/Disconnect Interrupt Enable
	TWBCSR_TWBDT0     = 0x2  // TWI Bus Disconnect Time-out Period
	TWBCSR_TWBDT1     = 0x4  // TWI Bus Disconnect Time-out Period
	TWBCSR_TWBDT_Msk  = 0x6  // TWI Bus Disconnect Time-out Period
	TWBCSR_TWBCIP     = 0x1  // TWI Bus Connect/Disconnect Interrupt Polarity
	TWBCSR_TWBCIP_Msk = 0x1  // TWI Bus Connect/Disconnect Interrupt Polarity

	// TWAMR: TWI (Slave) Address Mask Register
	TWAMR_TWAM0    = 0x2
	TWAMR_TWAM1    = 0x4
	TWAMR_TWAM2    = 0x8
	TWAMR_TWAM3    = 0x10
	TWAMR_TWAM4    = 0x20
	TWAMR_TWAM5    = 0x40
	TWAMR_TWAM6    = 0x80
	TWAMR_TWAM_Msk = 0xfe

	// TWCR: TWI Control Register
	TWCR_TWINT     = 0x80 // TWI Interrupt Flag
	TWCR_TWINT_Msk = 0x80 // TWI Interrupt Flag
	TWCR_TWEA      = 0x40 // TWI Enable Acknowledge Bit
	TWCR_TWEA_Msk  = 0x40 // TWI Enable Acknowledge Bit
	TWCR_TWSTA     = 0x20 // TWI Start Condition Bit
	TWCR_TWSTA_Msk = 0x20 // TWI Start Condition Bit
	TWCR_TWSTO     = 0x10 // TWI Stop Condition Bit
	TWCR_TWSTO_Msk = 0x10 // TWI Stop Condition Bit
	TWCR_TWWC      = 0x8  // TWI Write Collition Flag
	TWCR_TWWC_Msk  = 0x8  // TWI Write Collition Flag
	TWCR_TWEN      = 0x4  // TWI Enable Bit
	TWCR_TWEN_Msk  = 0x4  // TWI Enable Bit
	TWCR_TWIE      = 0x1  // TWI Interrupt Enable
	TWCR_TWIE_Msk  = 0x1  // TWI Interrupt Enable

	// TWSR: TWI Status Register
	TWSR_TWS0     = 0x8  // TWI Status
	TWSR_TWS1     = 0x10 // TWI Status
	TWSR_TWS2     = 0x20 // TWI Status
	TWSR_TWS3     = 0x40 // TWI Status
	TWSR_TWS4     = 0x80 // TWI Status
	TWSR_TWS_Msk  = 0xf8 // TWI Status
	TWSR_TWPS0    = 0x1  // TWI Prescaler
	TWSR_TWPS1    = 0x2  // TWI Prescaler
	TWSR_TWPS_Msk = 0x3  // TWI Prescaler

	// TWAR: TWI (Slave) Address register
	TWAR_TWA0      = 0x2  // TWI (Slave) Address register Bits
	TWAR_TWA1      = 0x4  // TWI (Slave) Address register Bits
	TWAR_TWA2      = 0x8  // TWI (Slave) Address register Bits
	TWAR_TWA3      = 0x10 // TWI (Slave) Address register Bits
	TWAR_TWA4      = 0x20 // TWI (Slave) Address register Bits
	TWAR_TWA5      = 0x40 // TWI (Slave) Address register Bits
	TWAR_TWA6      = 0x80 // TWI (Slave) Address register Bits
	TWAR_TWA_Msk   = 0xfe // TWI (Slave) Address register Bits
	TWAR_TWGCE     = 0x1  // TWI General Call Recognition Enable Bit
	TWAR_TWGCE_Msk = 0x1  // TWI General Call Recognition Enable Bit
)

// Bitfields for BANDGAP: Bandgap
const (
	// BGCCR: Bandgap Calibration Register
	BGCCR_BGD      = 0x80 // Setting the BGD bit to one will disable the bandgap voltage reference. This bit must be cleared before enabling CC-ADC or V-ADC, and must remain unset while either ADC is enabled.
	BGCCR_BGD_Msk  = 0x80 // Setting the BGD bit to one will disable the bandgap voltage reference. This bit must be cleared before enabling CC-ADC or V-ADC, and must remain unset while either ADC is enabled.
	BGCCR_BGCC0    = 0x1  // BG Calibration of PTAT Current Bits
	BGCCR_BGCC1    = 0x2  // BG Calibration of PTAT Current Bits
	BGCCR_BGCC2    = 0x4  // BG Calibration of PTAT Current Bits
	BGCCR_BGCC3    = 0x8  // BG Calibration of PTAT Current Bits
	BGCCR_BGCC4    = 0x10 // BG Calibration of PTAT Current Bits
	BGCCR_BGCC5    = 0x20 // BG Calibration of PTAT Current Bits
	BGCCR_BGCC_Msk = 0x3f // BG Calibration of PTAT Current Bits
)

// Bitfields for EEPROM: EEPROM
const (
	// EECR: EEPROM Control Register
	EECR_EEPM0     = 0x10 // EEPROM Programming Mode Bits
	EECR_EEPM1     = 0x20 // EEPROM Programming Mode Bits
	EECR_EEPM_Msk  = 0x30 // EEPROM Programming Mode Bits
	EECR_EERIE     = 0x8  // EEPROM Ready Interrupt Enable
	EECR_EERIE_Msk = 0x8  // EEPROM Ready Interrupt Enable
	EECR_EEMPE     = 0x4  // EEPROM Master Programming Enable
	EECR_EEMPE_Msk = 0x4  // EEPROM Master Programming Enable
	EECR_EEPE      = 0x2  // EEPROM Programming Enable
	EECR_EEPE_Msk  = 0x2  // EEPROM Programming Enable
	EECR_EERE      = 0x1  // EEPROM Read Enable
	EECR_EERE_Msk  = 0x1  // EEPROM Read Enable
)
