/*
 * Copyright (c) 2012, 2022, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2012 Unicode, Inc. All rights reserved. Distributed under
 * the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of the Unicode data files and any associated documentation (the "Data
 * Files") or Unicode software and any associated documentation (the
 * "Software") to deal in the Data Files or Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, and/or sell copies of the Data Files or Software, and
 * to permit persons to whom the Data Files or Software are furnished to do so,
 * provided that (a) the above copyright notice(s) and this permission notice
 * appear with all copies of the Data Files or Software, (b) both the above
 * copyright notice(s) and this permission notice appear in associated
 * documentation, and (c) there is clear notice in each modified Data File or
 * in the Software as well as in the documentation associated with the Data
 * File(s) or Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR
 * CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall not
 * be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written authorization
 * of the copyright holder.
 */

package sun.util.resources.cldr.zh;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_zh extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final Object[][] data = new Object[][] {
            { "001", "\u4e16\u754c" },
            { "002", "\u975e\u6d32" },
            { "003", "\u5317\u7f8e\u6d32" },
            { "005", "\u5357\u7f8e\u6d32" },
            { "009", "\u5927\u6d0b\u6d32" },
            { "011", "\u897f\u975e" },
            { "013", "\u4e2d\u7f8e\u6d32" },
            { "014", "\u4e1c\u975e" },
            { "015", "\u5317\u975e" },
            { "017", "\u4e2d\u975e" },
            { "018", "\u5357\u90e8\u975e\u6d32" },
            { "019", "\u7f8e\u6d32" },
            { "021", "\u7f8e\u6d32\u5317\u90e8" },
            { "029", "\u52a0\u52d2\u6bd4\u6d77" },
            { "030", "\u4e1c\u4e9a" },
            { "034", "\u5357\u4e9a" },
            { "035", "\u4e1c\u5357\u4e9a" },
            { "039", "\u5357\u6b27" },
            { "053", "\u6fb3\u5927\u5229\u4e9a\u548c\u65b0\u897f\u5170" },
            { "054", "\u7f8e\u62c9\u5c3c\u897f\u4e9a" },
            { "057", "\u5bc6\u514b\u7f57\u5c3c\u897f\u4e9a" },
            { "061", "\u73bb\u5229\u5c3c\u897f\u4e9a" },
            { "142", "\u4e9a\u6d32" },
            { "143", "\u4e2d\u4e9a" },
            { "145", "\u897f\u4e9a" },
            { "150", "\u6b27\u6d32" },
            { "151", "\u4e1c\u6b27" },
            { "154", "\u5317\u6b27" },
            { "155", "\u897f\u6b27" },
            { "419", "\u62c9\u4e01\u7f8e\u6d32" },
            { "AC", "\u963f\u68ee\u677e\u5c9b" },
            { "AD", "\u5b89\u9053\u5c14" },
            { "AE", "\u963f\u62c9\u4f2f\u8054\u5408\u914b\u957f\u56fd" },
            { "AF", "\u963f\u5bcc\u6c57" },
            { "AG", "\u5b89\u63d0\u74dc\u548c\u5df4\u5e03\u8fbe" },
            { "AI", "\u5b89\u572d\u62c9" },
            { "AL", "\u963f\u5c14\u5df4\u5c3c\u4e9a" },
            { "AM", "\u4e9a\u7f8e\u5c3c\u4e9a" },
            { "AN", "\u8377\u5c5e\u5b89\u7684\u5217\u65af\u7fa4\u5c9b" },
            { "AO", "\u5b89\u54e5\u62c9" },
            { "AQ", "\u5357\u6781\u6d32" },
            { "AR", "\u963f\u6839\u5ef7" },
            { "AS", "\u7f8e\u5c5e\u8428\u6469\u4e9a" },
            { "AT", "\u5965\u5730\u5229" },
            { "AU", "\u6fb3\u5927\u5229\u4e9a" },
            { "AW", "\u963f\u9c81\u5df4" },
            { "AX", "\u5965\u5170\u7fa4\u5c9b" },
            { "AZ", "\u963f\u585e\u62dc\u7586" },
            { "BA", "\u6ce2\u65af\u5c3c\u4e9a\u548c\u9ed1\u585e\u54e5\u7ef4\u90a3" },
            { "BB", "\u5df4\u5df4\u591a\u65af" },
            { "BD", "\u5b5f\u52a0\u62c9\u56fd" },
            { "BE", "\u6bd4\u5229\u65f6" },
            { "BF", "\u5e03\u57fa\u7eb3\u6cd5\u7d22" },
            { "BG", "\u4fdd\u52a0\u5229\u4e9a" },
            { "BH", "\u5df4\u6797" },
            { "BI", "\u5e03\u9686\u8fea" },
            { "BJ", "\u8d1d\u5b81" },
            { "BL", "\u5723\u5df4\u6cf0\u52d2\u7c73" },
            { "BM", "\u767e\u6155\u5927" },
            { "BN", "\u6587\u83b1" },
            { "BO", "\u73bb\u5229\u7ef4\u4e9a" },
            { "BR", "\u5df4\u897f" },
            { "BS", "\u5df4\u54c8\u9a6c" },
            { "BT", "\u4e0d\u4e39" },
            { "BV", "\u5e03\u7ef4\u7279\u5c9b" },
            { "BW", "\u535a\u8328\u74e6\u7eb3" },
            { "BY", "\u767d\u4fc4\u7f57\u65af" },
            { "BZ", "\u4f2f\u5229\u5179" },
            { "CA", "\u52a0\u62ff\u5927" },
            { "CC", "\u79d1\u79d1\u65af\u7fa4\u5c9b" },
            { "CD", "\u521a\u679c\uff08\u91d1\uff09" },
            { "CF", "\u4e2d\u975e\u5171\u548c\u56fd" },
            { "CG", "\u521a\u679c\uff08\u5e03\uff09" },
            { "CH", "\u745e\u58eb" },
            { "CI", "\u79d1\u7279\u8fea\u74e6" },
            { "CK", "\u5e93\u514b\u7fa4\u5c9b" },
            { "CL", "\u667a\u5229" },
            { "CM", "\u5580\u9ea6\u9686" },
            { "CN", "\u4e2d\u56fd" },
            { "CO", "\u54e5\u4f26\u6bd4\u4e9a" },
            { "CP", "\u514b\u5229\u73c0\u987f\u5c9b" },
            { "CR", "\u54e5\u65af\u8fbe\u9ece\u52a0" },
            { "CS", "\u585e\u5c14\u7ef4\u4e9a\u548c\u9ed1\u5c71" },
            { "CU", "\u53e4\u5df4" },
            { "CV", "\u4f5b\u5f97\u89d2" },
            { "CX", "\u5723\u8bde\u5c9b" },
            { "CY", "\u585e\u6d66\u8def\u65af" },
            { "CZ", "\u6377\u514b\u5171\u548c\u56fd" },
            { "DE", "\u5fb7\u56fd" },
            { "DG", "\u8fea\u6208\u52a0\u897f\u4e9a\u5c9b" },
            { "DJ", "\u5409\u5e03\u63d0" },
            { "DK", "\u4e39\u9ea6" },
            { "DM", "\u591a\u7c73\u5c3c\u52a0" },
            { "DO", "\u591a\u7c73\u5c3c\u52a0\u5171\u548c\u56fd" },
            { "DZ", "\u963f\u5c14\u53ca\u5229\u4e9a" },
            { "EA", "\u4f11\u8fbe\u53ca\u6885\u5229\u5229\u4e9a" },
            { "EC", "\u5384\u74dc\u591a\u5c14" },
            { "EE", "\u7231\u6c99\u5c3c\u4e9a" },
            { "EG", "\u57c3\u53ca" },
            { "EH", "\u897f\u6492\u54c8\u62c9" },
            { "ER", "\u5384\u7acb\u7279\u91cc\u4e9a" },
            { "ES", "\u897f\u73ed\u7259" },
            { "ET", "\u57c3\u585e\u4fc4\u6bd4\u4e9a" },
            { "EU", "\u6b27\u76df" },
            { "FI", "\u82ac\u5170" },
            { "FJ", "\u6590\u6d4e" },
            { "FK", "\u798f\u514b\u5170\u7fa4\u5c9b" },
            { "FM", "\u5bc6\u514b\u7f57\u5c3c\u897f\u4e9a\u8054\u90a6" },
            { "FO", "\u6cd5\u7f57\u7fa4\u5c9b" },
            { "FR", "\u6cd5\u56fd" },
            { "GA", "\u52a0\u84ec" },
            { "GB", "\u82f1\u56fd" },
            { "GD", "\u683c\u6797\u7eb3\u8fbe" },
            { "GE", "\u683c\u9c81\u5409\u4e9a" },
            { "GF", "\u6cd5\u5c5e\u572d\u4e9a\u90a3" },
            { "GG", "\u683c\u6069\u897f\u5c9b" },
            { "GH", "\u52a0\u7eb3" },
            { "GI", "\u76f4\u5e03\u7f57\u9640" },
            { "GL", "\u683c\u9675\u5170" },
            { "GM", "\u5188\u6bd4\u4e9a" },
            { "GN", "\u51e0\u5185\u4e9a" },
            { "GP", "\u74dc\u5fb7\u7f57\u666e\u5c9b" },
            { "GQ", "\u8d64\u9053\u51e0\u5185\u4e9a" },
            { "GR", "\u5e0c\u814a" },
            { "GS", "\u5357\u4e54\u6cbb\u4e9a\u5c9b\u548c\u5357\u6851\u5a01\u9f50\u7fa4\u5c9b" },
            { "GT", "\u5371\u5730\u9a6c\u62c9" },
            { "GU", "\u5173\u5c9b" },
            { "GW", "\u51e0\u5185\u4e9a\u6bd4\u7ecd" },
            { "GY", "\u572d\u4e9a\u90a3" },
            { "HK", "\u4e2d\u56fd\u9999\u6e2f\u7279\u522b\u884c\u653f\u533a" },
            { "HM", "\u8d6b\u5fb7\u4e0e\u9ea6\u514b\u5510\u7eb3\u7fa4\u5c9b" },
            { "HN", "\u6d2a\u90fd\u62c9\u65af" },
            { "HR", "\u514b\u7f57\u5730\u4e9a" },
            { "HT", "\u6d77\u5730" },
            { "HU", "\u5308\u7259\u5229" },
            { "IC", "\u52a0\u7eb3\u5229\u7fa4\u5c9b" },
            { "ID", "\u5370\u5ea6\u5c3c\u897f\u4e9a" },
            { "IE", "\u7231\u5c14\u5170" },
            { "IL", "\u4ee5\u8272\u5217" },
            { "IM", "\u66fc\u5c9b" },
            { "IN", "\u5370\u5ea6" },
            { "IO", "\u82f1\u5c5e\u5370\u5ea6\u6d0b\u9886\u5730" },
            { "IQ", "\u4f0a\u62c9\u514b" },
            { "IR", "\u4f0a\u6717" },
            { "IS", "\u51b0\u5c9b" },
            { "IT", "\u610f\u5927\u5229" },
            { "JE", "\u6cfd\u897f\u5c9b" },
            { "JM", "\u7259\u4e70\u52a0" },
            { "JO", "\u7ea6\u65e6" },
            { "JP", "\u65e5\u672c" },
            { "KE", "\u80af\u5c3c\u4e9a" },
            { "KG", "\u5409\u5c14\u5409\u65af\u65af\u5766" },
            { "KH", "\u67ec\u57d4\u5be8" },
            { "KI", "\u57fa\u91cc\u5df4\u65af" },
            { "KM", "\u79d1\u6469\u7f57" },
            { "KN", "\u5723\u57fa\u8328\u548c\u5c3c\u7ef4\u65af" },
            { "KP", "\u671d\u9c9c" },
            { "KR", "\u97e9\u56fd" },
            { "KW", "\u79d1\u5a01\u7279" },
            { "KY", "\u5f00\u66fc\u7fa4\u5c9b" },
            { "KZ", "\u54c8\u8428\u514b\u65af\u5766" },
            { "LA", "\u8001\u631d\u4eba\u6c11\u6c11\u4e3b\u5171\u548c\u56fd" },
            { "LB", "\u9ece\u5df4\u5ae9" },
            { "LC", "\u5723\u5362\u897f\u4e9a" },
            { "LI", "\u5217\u652f\u6566\u58eb\u767b" },
            { "LK", "\u65af\u91cc\u5170\u5361" },
            { "LR", "\u5229\u6bd4\u91cc\u4e9a" },
            { "LS", "\u83b1\u7d22\u6258" },
            { "LT", "\u7acb\u9676\u5b9b" },
            { "LU", "\u5362\u68ee\u5821" },
            { "LV", "\u62c9\u8131\u7ef4\u4e9a" },
            { "LY", "\u5229\u6bd4\u4e9a" },
            { "MA", "\u6469\u6d1b\u54e5" },
            { "MC", "\u6469\u7eb3\u54e5" },
            { "MD", "\u6469\u5c14\u591a\u74e6" },
            { "ME", "\u9ed1\u5c71\u5171\u548c\u56fd" },
            { "MF", "\u5723\u9a6c\u4e01" },
            { "MG", "\u9a6c\u8fbe\u52a0\u65af\u52a0" },
            { "MH", "\u9a6c\u7ecd\u5c14\u7fa4\u5c9b" },
            { "MK", "\u9a6c\u5176\u987f" },
            { "ML", "\u9a6c\u91cc" },
            { "MM", "\u7f05\u7538" },
            { "MN", "\u8499\u53e4" },
            { "MO", "\u4e2d\u56fd\u6fb3\u95e8\u7279\u522b\u884c\u653f\u533a" },
            { "MP", "\u5317\u9a6c\u91cc\u4e9a\u7eb3\u7fa4\u5c9b" },
            { "MQ", "\u9a6c\u63d0\u5c3c\u514b\u7fa4\u5c9b" },
            { "MR", "\u6bdb\u91cc\u5854\u5c3c\u4e9a" },
            { "MS", "\u8499\u585e\u62c9\u7279\u7fa4\u5c9b" },
            { "MT", "\u9a6c\u8033\u4ed6" },
            { "MU", "\u6bdb\u91cc\u6c42\u65af" },
            { "MV", "\u9a6c\u5c14\u4ee3\u592b" },
            { "MW", "\u9a6c\u62c9\u7ef4" },
            { "MX", "\u58a8\u897f\u54e5" },
            { "MY", "\u9a6c\u6765\u897f\u4e9a" },
            { "MZ", "\u83ab\u6851\u6bd4\u514b" },
            { "NA", "\u7eb3\u7c73\u6bd4\u4e9a" },
            { "NC", "\u65b0\u5580\u91cc\u591a\u5c3c\u4e9a" },
            { "NE", "\u5c3c\u65e5\u5c14" },
            { "NF", "\u8bfa\u798f\u514b\u5c9b" },
            { "NG", "\u5c3c\u65e5\u5229\u4e9a" },
            { "NI", "\u5c3c\u52a0\u62c9\u74dc" },
            { "NL", "\u8377\u5170" },
            { "NO", "\u632a\u5a01" },
            { "NP", "\u5c3c\u6cca\u5c14" },
            { "NR", "\u7459\u9c81" },
            { "NU", "\u7ebd\u57c3" },
            { "NZ", "\u65b0\u897f\u5170" },
            { "OM", "\u963f\u66fc" },
            { "PA", "\u5df4\u62ff\u9a6c" },
            { "PE", "\u79d8\u9c81" },
            { "PF", "\u6cd5\u5c5e\u6ce2\u5229\u5c3c\u897f\u4e9a" },
            { "PG", "\u5df4\u5e03\u4e9a\u65b0\u51e0\u5185\u4e9a" },
            { "PH", "\u83f2\u5f8b\u5bbe" },
            { "PK", "\u5df4\u57fa\u65af\u5766" },
            { "PL", "\u6ce2\u5170" },
            { "PM", "\u5723\u76ae\u57c3\u5c14\u548c\u5bc6\u514b\u9686" },
            { "PN", "\u76ae\u7279\u51ef\u6069\u7fa4\u5c9b" },
            { "PR", "\u6ce2\u591a\u9ece\u5404" },
            { "PS", "\u5df4\u52d2\u65af\u5766\u9886\u571f" },
            { "PT", "\u8461\u8404\u7259" },
            { "PW", "\u5e15\u52b3" },
            { "PY", "\u5df4\u62c9\u572d" },
            { "QA", "\u5361\u5854\u5c14" },
            { "QO", "\u5927\u6d0b\u6d32\u8fb9\u8fdc\u7fa4\u5c9b" },
            { "RE", "\u7559\u5c3c\u6c6a" },
            { "RO", "\u7f57\u9a6c\u5c3c\u4e9a" },
            { "RS", "\u585e\u5c14\u7ef4\u4e9a" },
            { "RU", "\u4fc4\u7f57\u65af" },
            { "RW", "\u5362\u65fa\u8fbe" },
            { "SA", "\u6c99\u7279\u963f\u62c9\u4f2f" },
            { "SB", "\u6240\u7f57\u95e8\u7fa4\u5c9b" },
            { "SC", "\u585e\u820c\u5c14\u7fa4\u5c9b" },
            { "SD", "\u82cf\u4e39" },
            { "SE", "\u745e\u5178" },
            { "SG", "\u65b0\u52a0\u5761" },
            { "SH", "\u5723\u8d6b\u52d2\u62ff" },
            { "SI", "\u65af\u6d1b\u6587\u5c3c\u4e9a" },
            { "SJ", "\u65af\u74e6\u5c14\u5df4\u7279\u548c\u626c\u9a6c\u5ef6" },
            { "SK", "\u65af\u6d1b\u4f10\u514b" },
            { "SL", "\u585e\u62c9\u5229\u6602" },
            { "SM", "\u5723\u9a6c\u529b\u8bfa" },
            { "SN", "\u585e\u5185\u52a0\u5c14" },
            { "SO", "\u7d22\u9a6c\u91cc" },
            { "SR", "\u82cf\u91cc\u5357" },
            { "ST", "\u5723\u591a\u7f8e\u548c\u666e\u6797\u897f\u6bd4" },
            { "SV", "\u8428\u5c14\u74e6\u591a" },
            { "SY", "\u53d9\u5229\u4e9a" },
            { "SZ", "\u65af\u5a01\u58eb\u5170" },
            { "TA", "\u7279\u91cc\u65af\u5766-\u8fbe\u5e93\u5c3c\u4e9a\u7fa4\u5c9b" },
            { "TC", "\u7279\u514b\u65af\u548c\u51ef\u79d1\u65af\u7fa4\u5c9b" },
            { "TD", "\u4e4d\u5f97" },
            { "TF", "\u6cd5\u5c5e\u5357\u90e8\u9886\u571f" },
            { "TG", "\u591a\u54e5" },
            { "TH", "\u6cf0\u56fd" },
            { "TJ", "\u5854\u5409\u514b\u65af\u5766" },
            { "TK", "\u6258\u514b\u52b3" },
            { "TL", "\u4e1c\u5e1d\u6c76" },
            { "TM", "\u571f\u5e93\u66fc\u65af\u5766" },
            { "TN", "\u7a81\u5c3c\u65af" },
            { "TO", "\u6c64\u52a0" },
            { "TR", "\u571f\u8033\u5176" },
            { "TT", "\u7279\u7acb\u5c3c\u8fbe\u548c\u591a\u5df4\u54e5" },
            { "TV", "\u56fe\u74e6\u5362" },
            { "TW", "\u53f0\u6e7e" },
            { "TZ", "\u5766\u6851\u5c3c\u4e9a" },
            { "UA", "\u4e4c\u514b\u5170" },
            { "UG", "\u4e4c\u5e72\u8fbe" },
            { "UM", "\u7f8e\u56fd\u8fb9\u8fdc\u5c0f\u5c9b" },
            { "US", "\u7f8e\u56fd" },
            { "UY", "\u4e4c\u62c9\u572d" },
            { "UZ", "\u4e4c\u5179\u522b\u514b\u65af\u5766" },
            { "VA", "\u68b5\u8482\u5188" },
            { "VC", "\u5723\u6587\u68ee\u7279\u548c\u683c\u6797\u7eb3\u4e01\u65af" },
            { "VE", "\u59d4\u5185\u745e\u62c9" },
            { "VG", "\u82f1\u5c5e\u7ef4\u4eac\u7fa4\u5c9b" },
            { "VI", "\u7f8e\u5c5e\u7ef4\u4eac\u7fa4\u5c9b" },
            { "VN", "\u8d8a\u5357" },
            { "VU", "\u74e6\u52aa\u963f\u56fe" },
            { "WF", "\u74e6\u5229\u65af\u548c\u5bcc\u56fe\u7eb3" },
            { "WS", "\u8428\u6469\u4e9a" },
            { "YE", "\u4e5f\u95e8" },
            { "YT", "\u9a6c\u7ea6\u7279" },
            { "ZA", "\u5357\u975e" },
            { "ZM", "\u8d5e\u6bd4\u4e9a" },
            { "ZW", "\u6d25\u5df4\u5e03\u97e6" },
            { "ZZ", "\u672a\u77e5\u5730\u533a" },
            { "aa", "\u963f\u6cd5\u6587" },
            { "ab", "\u963f\u5e03\u54c8\u897f\u4e9a\u6587" },
            { "ae", "\u963f\u7ef4\u65af\u5854\u6587" },
            { "af", "\u5357\u975e\u8377\u5170\u6587" },
            { "ak", "\u963f\u80af\u6587" },
            { "am", "\u963f\u59c6\u54c8\u62c9\u6587" },
            { "an", "\u963f\u62c9\u8d21\u6587" },
            { "ar", "\u963f\u62c9\u4f2f\u6587" },
            { "as", "\u963f\u8428\u59c6\u6587" },
            { "av", "\u963f\u74e6\u5c14\u6587" },
            { "ay", "\u827e\u9a6c\u62c9\u6587" },
            { "az", "\u963f\u585e\u62dc\u7586\u6587" },
            { "ba", "\u5df4\u4ec0\u5ba2\u5c14\u6587" },
            { "be", "\u767d\u4fc4\u7f57\u65af\u6587" },
            { "bg", "\u4fdd\u52a0\u5229\u4e9a\u6587" },
            { "bh", "\u6bd4\u54c8\u5c14\u6587" },
            { "bi", "\u6bd4\u65af\u62c9\u9a6c\u6587" },
            { "bm", "\u73ed\u5df4\u62c9\u6587" },
            { "bn", "\u5b5f\u52a0\u62c9\u6587" },
            { "bo", "\u85cf\u6587" },
            { "br", "\u5e03\u91cc\u591a\u5c3c\u6587" },
            { "bs", "\u6ce2\u65af\u5c3c\u4e9a\u6587" },
            { "ca", "\u52a0\u6cf0\u7f57\u5c3c\u4e9a\u6587" },
            { "ce", "\u8f66\u81e3\u6587" },
            { "ch", "\u67e5\u83ab\u7f57\u6587" },
            { "co", "\u79d1\u897f\u5609\u6587" },
            { "cr", "\u514b\u91cc\u65cf\u6587" },
            { "cs", "\u6377\u514b\u6587" },
            { "cu", "\u5b97\u6559\u65af\u62c9\u592b\u6587" },
            { "cv", "\u695a\u74e6\u4ec0\u6587" },
            { "cy", "\u5a01\u5c14\u58eb\u6587" },
            { "da", "\u4e39\u9ea6\u6587" },
            { "de", "\u5fb7\u6587" },
            { "dv", "\u8fea\u7ef4\u5e0c\u6587" },
            { "dz", "\u4e0d\u4e39\u6587" },
            { "ee", "\u57c3\u7ef4\u6587" },
            { "el", "\u5e0c\u814a\u6587" },
            { "en", "\u82f1\u6587" },
            { "eo", "\u4e16\u754c\u6587" },
            { "es", "\u897f\u73ed\u7259\u6587" },
            { "et", "\u7231\u6c99\u5c3c\u4e9a\u6587" },
            { "eu", "\u5df4\u65af\u514b\u6587" },
            { "fa", "\u6ce2\u65af\u6587" },
            { "ff", "\u592b\u62c9\u6587" },
            { "fi", "\u82ac\u5170\u6587" },
            { "fj", "\u6590\u6d4e\u6587" },
            { "fo", "\u6cd5\u7f57\u6587" },
            { "fr", "\u6cd5\u6587" },
            { "fy", "\u897f\u5f17\u91cc\u897f\u4e9a\u6587" },
            { "ga", "\u7231\u5c14\u5170\u6587" },
            { "gd", "\u82cf\u683c\u5170\u76d6\u5c14\u6587" },
            { "gl", "\u52a0\u5229\u897f\u4e9a\u6587" },
            { "gn", "\u74dc\u62c9\u5c3c\u6587" },
            { "gu", "\u53e4\u52a0\u62c9\u63d0\u6587" },
            { "gv", "\u9a6c\u6069\u5c9b\u6587" },
            { "ha", "\u8c6a\u6492\u6587" },
            { "he", "\u5e0c\u4f2f\u6765\u6587" },
            { "hi", "\u5370\u5730\u6587" },
            { "ho", "\u5e0c\u91cc\u83ab\u56fe\u6587" },
            { "hr", "\u514b\u7f57\u5730\u4e9a\u6587" },
            { "ht", "\u6d77\u5730\u6587" },
            { "hu", "\u5308\u7259\u5229\u6587" },
            { "hy", "\u4e9a\u7f8e\u5c3c\u4e9a\u6587" },
            { "hz", "\u8d6b\u96f7\u7f57\u6587" },
            { "ia", "\u56fd\u9645\u8bed" },
            { "id", "\u5370\u5ea6\u5c3c\u897f\u4e9a\u6587" },
            { "ie", "\u56fd\u9645\u8bed\uff08E\uff09" },
            { "ig", "\u4f0a\u683c\u535a\u6587" },
            { "ii", "\u56db\u5ddd\u5f5d\u6587" },
            { "ik", "\u4f9d\u5974\u76ae\u7ef4\u514b\u6587" },
            { "io", "\u4f0a\u591a\u6587" },
            { "is", "\u51b0\u5c9b\u6587" },
            { "it", "\u610f\u5927\u5229\u6587" },
            { "iu", "\u4f0a\u52aa\u4f0a\u7279\u6587" },
            { "ja", "\u65e5\u6587" },
            { "jv", "\u722a\u54c7\u6587" },
            { "ka", "\u683c\u9c81\u5409\u4e9a\u6587" },
            { "kg", "\u521a\u679c\u6587" },
            { "ki", "\u5409\u5e93\u5c24\u6587" },
            { "kj", "\u5bbd\u4e9a\u739b\u6587" },
            { "kk", "\u54c8\u8428\u514b\u6587" },
            { "kl", "\u683c\u9675\u5170\u6587" },
            { "km", "\u67ec\u57d4\u5be8\u6587" },
            { "kn", "\u574e\u7eb3\u8fbe\u6587" },
            { "ko", "\u97e9\u6587" },
            { "kr", "\u5361\u52aa\u91cc\u6587" },
            { "ks", "\u514b\u4ec0\u7c73\u5c14\u6587" },
            { "ku", "\u5e93\u5c14\u5fb7\u6587" },
            { "kv", "\u79d1\u7c73\u6587" },
            { "kw", "\u51ef\u5c14\u7279\u6587" },
            { "ky", "\u5409\u5c14\u5409\u65af\u6587" },
            { "la", "\u62c9\u4e01\u6587" },
            { "lb", "\u5362\u68ee\u5821\u6587" },
            { "lg", "\u5362\u5e72\u8fbe\u6587" },
            { "li", "\u6dcb\u5e03\u5c14\u5409\u6587" },
            { "ln", "\u6797\u52a0\u62c9\u6587" },
            { "lo", "\u8001\u631d\u6587" },
            { "lt", "\u7acb\u9676\u5b9b\u6587" },
            { "lu", "\u9c81\u5df4\u52a0\u4e39\u52a0\u6587" },
            { "lv", "\u62c9\u8131\u7ef4\u4e9a\u6587" },
            { "mg", "\u9a6c\u5c14\u52a0\u4ec0\u6587" },
            { "mh", "\u9a6c\u7ecd\u5c14\u6587" },
            { "mi", "\u6bdb\u5229\u6587" },
            { "mk", "\u9a6c\u5176\u987f\u6587" },
            { "ml", "\u9a6c\u6765\u4e9a\u62c9\u59c6\u6587" },
            { "mn", "\u8499\u53e4\u6587" },
            { "mo", "\u6469\u5c14\u591a\u74e6\u6587" },
            { "mr", "\u9a6c\u62c9\u5730\u6587" },
            { "ms", "\u9a6c\u6765\u6587" },
            { "mt", "\u9a6c\u8033\u4ed6\u6587" },
            { "my", "\u7f05\u7538\u6587" },
            { "na", "\u7459\u9c81\u6587" },
            { "nb", "\u632a\u5a01\u535a\u514b\u9a6c\u5c14\u6587" },
            { "nd", "\u5317\u6069\u5fb7\u8d1d\u52d2\u6587" },
            { "ne", "\u5c3c\u6cca\u5c14\u6587" },
            { "ng", "\u6069\u4e1c\u52a0\u6587" },
            { "nl", "\u8377\u5170\u6587" },
            { "nn", "\u632a\u5a01\u5c3c\u8bfa\u65af\u514b\u6587" },
            { "no", "\u632a\u5a01\u6587" },
            { "nr", "\u5357\u6069\u5fb7\u8d1d\u52d2\u6587" },
            { "nv", "\u7eb3\u74e6\u970d\u6587" },
            { "ny", "\u5c3c\u626c\u624e\u6587" },
            { "oc", "\u5965\u514b\u897f\u5510\u8bed" },
            { "oj", "\u5965\u5409\u5e03\u74e6\u6587" },
            { "om", "\u5965\u6d1b\u83ab\u6587" },
            { "or", "\u6b27\u91cc\u4e9a\u6587" },
            { "os", "\u5965\u585e\u68af\u6587" },
            { "pa", "\u65c1\u906e\u666e\u6587" },
            { "pi", "\u5df4\u5229\u6587" },
            { "pl", "\u6ce2\u5170\u6587" },
            { "ps", "\u666e\u4ec0\u56fe\u6587" },
            { "pt", "\u8461\u8404\u7259\u6587" },
            { "qu", "\u76d6\u4e18\u4e9a\u6587" },
            { "rm", "\u7f57\u66fc\u4ec0\u6587" },
            { "rn", "\u57fa\u9686\u8fea\u6587" },
            { "ro", "\u7f57\u9a6c\u5c3c\u4e9a\u6587" },
            { "ru", "\u4fc4\u6587" },
            { "rw", "\u5362\u65fa\u8fbe\u6587" },
            { "sa", "\u68b5\u6587" },
            { "sc", "\u8428\u4e01\u6587" },
            { "sd", "\u4fe1\u5fb7\u6587" },
            { "se", "\u5317\u8428\u7c73\u6587" },
            { "sg", "\u6851\u6208\u6587" },
            { "sh", "\u585e\u5c14\u7ef4\u4e9a-\u514b\u7f57\u5730\u4e9a\u6587" },
            { "si", "\u50e7\u4f3d\u7f57\u6587" },
            { "sk", "\u65af\u6d1b\u4f10\u514b\u6587" },
            { "sl", "\u65af\u6d1b\u6587\u5c3c\u4e9a\u6587" },
            { "sm", "\u8428\u6469\u4e9a\u6587" },
            { "sn", "\u7ecd\u7eb3\u6587" },
            { "so", "\u7d22\u9a6c\u91cc\u6587" },
            { "sq", "\u963f\u5c14\u5df4\u5c3c\u4e9a\u6587" },
            { "sr", "\u585e\u5c14\u7ef4\u4e9a\u6587" },
            { "ss", "\u65af\u74e6\u7279\u6587" },
            { "st", "\u5357\u7d22\u6258\u6587" },
            { "su", "\u5dfd\u4ed6\u8bed" },
            { "sv", "\u745e\u5178\u6587" },
            { "sw", "\u65af\u74e6\u5e0c\u91cc\u6587" },
            { "ta", "\u6cf0\u7c73\u5c14\u6587" },
            { "te", "\u6cf0\u5362\u56fa\u6587" },
            { "tg", "\u5854\u5409\u514b\u6587" },
            { "th", "\u6cf0\u6587" },
            { "ti", "\u63d0\u683c\u91cc\u5c3c\u4e9a\u6587" },
            { "tk", "\u571f\u5e93\u66fc\u6587" },
            { "tl", "\u5854\u52a0\u6d1b\u8bed" },
            { "tn", "\u585e\u8328\u74e6\u7eb3\u6587" },
            { "to", "\u6c64\u52a0\u6587" },
            { "tr", "\u571f\u8033\u5176\u6587" },
            { "ts", "\u5b97\u52a0\u6587" },
            { "tt", "\u5854\u5854\u5c14\u6587" },
            { "tw", "\u7279\u5a01\u6587" },
            { "ty", "\u5854\u897f\u63d0\u6587" },
            { "ug", "\u7ef4\u543e\u5c14\u6587" },
            { "uk", "\u4e4c\u514b\u5170\u6587" },
            { "ur", "\u4e4c\u5c14\u90fd\u6587" },
            { "uz", "\u4e4c\u5179\u522b\u514b\u6587" },
            { "ve", "\u6587\u8fbe\u6587" },
            { "vi", "\u8d8a\u5357\u6587" },
            { "vo", "\u6c83\u62c9\u666e\u514b\u6587" },
            { "wa", "\u74e6\u9686\u6587" },
            { "wo", "\u6c83\u6d1b\u592b\u6587" },
            { "xh", "\u79d1\u8428\u6587" },
            { "yi", "\u4f9d\u5730\u6587" },
            { "yo", "\u7ea6\u9c81\u5df4\u6587" },
            { "za", "\u58ee\u8bed" },
            { "zh", "\u4e2d\u6587" },
            { "zu", "\u7956\u9c81\u6587" },
            { "ace", "\u4e9a\u9f50\u6587" },
            { "ach", "\u963f\u4e54\u5229\u6587" },
            { "ada", "\u963f\u5f53\u6885\u6587" },
            { "ady", "\u963f\u8fea\u4f55\u6587" },
            { "afa", "\u5176\u4ed6\u4e9a\u975e\u8bed\u7cfb" },
            { "afh", "\u963f\u5f17\u91cc\u5e0c\u5229\u6587" },
            { "ain", "\u963f\u4f0a\u52aa\u6587" },
            { "akk", "\u963f\u5361\u5fb7\u6587" },
            { "ale", "\u963f\u7559\u7533\u6587" },
            { "alg", "\u5176\u4ed6\u963f\u5c14\u8d21\u8bed\u7cfb" },
            { "alt", "\u5357\u963f\u5c14\u6cf0\u6587" },
            { "ang", "\u53e4\u82f1\u6587" },
            { "anp", "\u6602\u52a0\u8bed" },
            { "apa", "\u963f\u5e15\u5207\u6587" },
            { "arc", "\u963f\u62c9\u7c73\u6587" },
            { "arn", "\u963f\u52b3\u574e\u6587" },
            { "arp", "\u963f\u62c9\u5e15\u970d\u6587" },
            { "art", "\u5176\u4ed6\u4eba\u5de5\u8bed\u7cfb" },
            { "arw", "\u963f\u62c9\u74e6\u514b\u6587" },
            { "ast", "\u963f\u65af\u56fe\u91cc\u4e9a\u601d\u7279\u6587" },
            { "ath", "\u963f\u8428\u5e15\u65af\u574e\u8bed\u7cfb" },
            { "aus", "\u6fb3\u5927\u5229\u4e9a\u8bed\u7cfb" },
            { "awa", "\u963f\u74e6\u4e54\u6587" },
            { "bad", "\u73ed\u8fbe\u6587" },
            { "bai", "\u5df4\u7c73\u7d2f\u514b\u8bed\u7cfb" },
            { "bal", "\u4ffe\u8def\u652f\u6587" },
            { "ban", "\u5df4\u91cc\u6587" },
            { "bas", "\u5df4\u8428\u6587" },
            { "bat", "\u5176\u4ed6\u6ce2\u7f57\u7684\u8bed\u7cfb" },
            { "bej", "\u522b\u672d\u6587" },
            { "bem", "\u522b\u59c6\u5df4\u6587" },
            { "ber", "\u67cf\u67cf\u5c14\u6587" },
            { "bho", "\u535a\u6770\u666e\u5c14\u6587" },
            { "bik", "\u6bd5\u5e93\u5c14\u6587" },
            { "bin", "\u6bd4\u5c3c\u6587" },
            { "bla", "\u53f8\u514b\u53f8\u5361\u6587" },
            { "bnt", "\u73ed\u56fe\u6587" },
            { "bra", "\u5e03\u62c9\u6770\u6587" },
            { "btk", "\u5df4\u5854\u514b\u6587" },
            { "bua", "\u5e03\u91cc\u4e9a\u7279\u6587" },
            { "bug", "\u5e03\u5409\u6587" },
            { "byn", "\u5e03\u6797\u6587" },
            { "cad", "\u5361\u591a\u6587" },
            { "cai", "\u5176\u4ed6\u4e2d\u7f8e\u5370\u7b2c\u5b89\u8bed\u7cfb" },
            { "car", "\u5df4\u52d2\u6bd4\u6587" },
            { "cau", "\u5176\u4ed6\u9ad8\u52a0\u7d22\u8bed\u7cfb" },
            { "ceb", "\u5bbf\u52a1\u6587" },
            { "cel", "\u5176\u4ed6\u51ef\u5c14\u7279\u8bed\u7cfb" },
            { "chb", "\u5951\u5e03\u5361\u6587" },
            { "chg", "\u67e5\u52a0\u6587" },
            { "chk", "\u695a\u543e\u514b\u6587" },
            { "chm", "\u9a6c\u91cc\u6587" },
            { "chn", "\u5951\u52aa\u514b\u6587" },
            { "cho", "\u4e54\u514b\u6258\u6587" },
            { "chp", "\u4f69\u74e6\u626c\u6587" },
            { "chr", "\u5f7b\u7f57\u57fa\u6587" },
            { "chy", "\u590f\u5ef6\u6587" },
            { "cmc", "\u67e5\u7c73\u514b\u6587" },
            { "cop", "\u79d1\u666e\u7279\u6587" },
            { "cpe", "\u5176\u4ed6\u4ee5\u82f1\u6587\u4e3a\u57fa\u7840\u7684\u514b\u91cc\u5965\u5c14\u6df7\u5408\u8bed\u7cfb" },
            { "cpf", "\u5176\u4ed6\u4ee5\u6cd5\u6587\u4e3a\u57fa\u7840\u7684\u514b\u91cc\u5965\u5c14\u6df7\u5408\u8bed\u7cfb" },
            { "cpp", "\u5176\u4ed6\u4ee5\u8461\u8404\u7259\u6587\u4e3a\u57fa\u7840\u7684\u514b\u91cc\u5965\u5c14\u6df7\u5408\u8bed\u7cfb" },
            { "crh", "\u514b\u91cc\u7c73\u4e9a\u571f\u8033\u5176\u6587\uff1b\u514b\u91cc\u7c73\u4e9a\u5854\u5854\u6587" },
            { "crp", "\u5176\u4ed6\u514b\u91cc\u5965\u5c14\u6df7\u5408\u8bed\u7cfb" },
            { "csb", "\u5361\u8212\u6587" },
            { "cus", "\u5176\u4ed6\u5e93\u65bd\u7279\u8bed\u7cfb" },
            { "dak", "\u8fbe\u79d1\u4ed6\u6587" },
            { "dar", "\u8fbe\u5c14\u683c\u74e6\u6587" },
            { "day", "\u8fbe\u96c5\u514b\u6587" },
            { "del", "\u7279\u62c9\u534e\u6587" },
            { "den", "\u53f8\u96f7\u592b\u6587" },
            { "dgr", "\u591a\u683c\u91cc\u5e03\u6587" },
            { "din", "\u4e01\u5361\u6587" },
            { "doi", "\u591a\u683c\u62c9\u6587" },
            { "dra", "\u5176\u4ed6\u5fb7\u62c9\u7ef4\u8bed\u7cfb" },
            { "dsb", "\u4e0b\u7d22\u5e03\u6587" },
            { "dua", "\u90fd\u963f\u62c9\u6587" },
            { "dum", "\u4e2d\u53e4\u8377\u5170\u6587" },
            { "dyu", "\u8fea\u5c24\u62c9\u6587" },
            { "efi", "\u57c3\u83f2\u514b\u6587" },
            { "egy", "\u53e4\u57c3\u53ca\u6587" },
            { "eka", "\u57c3\u514b\u4e18\u514b\u6587" },
            { "elx", "\u827e\u62c9\u7c73\u7279\u6587" },
            { "enm", "\u4e2d\u53e4\u82f1\u6587" },
            { "ewo", "\u65fa\u675c\u6587" },
            { "fan", "\u82b3\u683c\u6587" },
            { "fat", "\u82b3\u8482\u6587" },
            { "fil", "\u83f2\u5f8b\u5bbe\u6587" },
            { "fiu", "\u5176\u4ed6\u82ac\u5170\u4e4c\u6208\u5c14\u8bed\u7cfb" },
            { "fon", "\u4e30\u6587" },
            { "frm", "\u4e2d\u53e4\u6cd5\u6587" },
            { "fro", "\u53e4\u6cd5\u6587" },
            { "frr", "\u5317\u5f17\u91cc\u897f\u4e9a\u8bed" },
            { "frs", "\u4e1c\u5f17\u91cc\u897f\u4e9a\u6587" },
            { "fur", "\u5f17\u7559\u5229\u6587" },
            { "gaa", "\u52a0\u6587" },
            { "gay", "\u8fe6\u7ea6\u6587" },
            { "gba", "\u845b\u5df4\u4e9a\u6587" },
            { "gem", "\u5176\u4ed6\u65e5\u5c14\u66fc\u8bed\u7cfb" },
            { "gez", "\u5409\u5179\u6587" },
            { "gil", "\u5409\u5c14\u4f2f\u7279\u65af\u6587" },
            { "gmh", "\u4e2d\u53e4\u9ad8\u5730\u5fb7\u6587" },
            { "goh", "\u53e4\u9ad8\u5730\u5fb7\u6587" },
            { "gon", "\u5c97\u5fb7\u6587" },
            { "gor", "\u79d1\u6d1b\u6d85\u8fbe\u7f57\u6587" },
            { "got", "\u54e5\u7279\u6587" },
            { "grb", "\u683c\u5217\u535a\u6587" },
            { "grc", "\u53e4\u5e0c\u814a\u6587" },
            { "gsw", "\u745e\u58eb\u5fb7\u6587" },
            { "gwi", "\u5409\u7ef4\u514b\u7434\u6587" },
            { "hai", "\u6d77\u8fbe\u6587" },
            { "haw", "\u590f\u5a01\u5937\u6587" },
            { "hil", "\u5e0c\u5229\u76d6\u519c\u6587" },
            { "him", "\u8d6b\u9a6c\u67e5\u5229\u6587" },
            { "hit", "\u8d6b\u68af\u6587" },
            { "hmn", "\u8d6b\u8499\u6587" },
            { "hsb", "\u4e0a\u7d22\u5e03\u6587" },
            { "hup", "\u80e1\u5e15\u6587" },
            { "iba", "\u4f0a\u73ed\u6587" },
            { "ijo", "\u4f0a\u4e54\u6587" },
            { "ilo", "\u4f0a\u6d1b\u5e72\u8bfa\u6587" },
            { "inc", "\u5176\u4ed6\u5370\u5ea6\u8bed\u7cfb" },
            { "ine", "\u5176\u4ed6\u5370\u6b27\u8bed\u7cfb" },
            { "inh", "\u5370\u53e4\u4ec0\u6587" },
            { "ira", "\u4f0a\u6717\u6587" },
            { "iro", "\u4f0a\u6d1b\u9b41\u8bed\u7cfb" },
            { "jbo", "\u903b\u8f91\u6587" },
            { "jpr", "\u72b9\u592a\u6ce2\u65af\u6587" },
            { "jrb", "\u72b9\u592a\u963f\u62c9\u4f2f\u6587" },
            { "kaa", "\u5361\u62c9\u5361\u5c14\u5e15\u514b\u6587" },
            { "kab", "\u5361\u6bd4\u5c14\u6587" },
            { "kac", "\u5361\u7434\u6587" },
            { "kam", "\u5361\u59c6\u5df4\u6587" },
            { "kar", "\u5580\u4f26\u6587" },
            { "kaw", "\u5361\u5a01\u6587" },
            { "kbd", "\u5361\u5df4\u5c14\u8fbe\u6587" },
            { "kfo", "\u79d1\u7f57\u8bed" },
            { "kha", "\u5361\u897f\u6587" },
            { "khi", "\u5176\u4ed6\u79d1\u4f0a\u6851\u8bed\u7cfb" },
            { "kho", "\u548c\u7530\u6587" },
            { "kmb", "\u91d1\u90a6\u675c\u6587" },
            { "kok", "\u521a\u5361\u5c3c\u6587" },
            { "kos", "\u79d1\u65af\u62c9\u4f0a\u6587" },
            { "kpe", "\u514b\u4f69\u5217\u6587" },
            { "krc", "\u5361\u62c9\u6070\u4f0a\u5df4\u5c14\u5361\u5c14\u6587" },
            { "krl", "\u5361\u7d2f\u5229\u963f\u6587" },
            { "kro", "\u514b\u9c81\u6587" },
            { "kru", "\u5e93\u9c81\u514b\u6587" },
            { "kum", "\u5e93\u6885\u514b\u6587" },
            { "kut", "\u5e93\u7279\u5185\u6587" },
            { "lad", "\u62c9\u8fea\u8bfa\u6587" },
            { "lah", "\u62c9\u4ea8\u8fbe\u6587" },
            { "lam", "\u5170\u5df4\u6587" },
            { "lez", "\u83b1\u5179\u4f9d\u6602\u6587" },
            { "lol", "\u8292\u6208\u6587" },
            { "loz", "\u6d1b\u5179\u6587" },
            { "lua", "\u9c81\u5df4\u9c81\u74e6\u6587" },
            { "lui", "\u8def\u6613\u585e\u8bfa\u6587" },
            { "lun", "\u9686\u8fbe\u6587" },
            { "luo", "\u5362\u5965\u6587" },
            { "lus", "\u5362\u6652\u6587" },
            { "mad", "\u9a6c\u90fd\u62c9\u6587" },
            { "mag", "\u9a6c\u52a0\u4f0a\u6587" },
            { "mai", "\u8fc8\u8482\u5229\u6587" },
            { "mak", "\u671b\u52a0\u9521\u6587" },
            { "man", "\u66fc\u4e01\u54e5\u6587" },
            { "map", "\u6fb3\u65af\u7279\u7f57\u5c3c\u897f\u4e9a\u8bed\u7cfb" },
            { "mas", "\u8428\u4f0a\u8bed" },
            { "mdf", "\u83ab\u514b\u6c99\u6587" },
            { "mdr", "\u66fc\u8fbe\u5c14" },
            { "men", "\u95e8\u8fea\u6587" },
            { "mga", "\u4e2d\u53e4\u7231\u5c14\u5170\u6587" },
            { "mic", "\u7c73\u514b\u9a6c\u514b\u6587" },
            { "min", "\u7c73\u5357\u5361\u4fdd\u6587" },
            { "mis", "\u5404\u79cd\u4e0d\u540c\u8bed\u7cfb" },
            { "mkh", "\u5176\u4ed6\u5b5f\u9ad8\u68c9\u8bed\u7cfb" },
            { "mnc", "\u6ee1\u6587" },
            { "mni", "\u66fc\u5c3c\u666e\u91cc\u6587" },
            { "mno", "\u9a6c\u8bfa\u535a\u8bed\u7cfb" },
            { "moh", "\u6469\u970d\u514b\u6587" },
            { "mos", "\u83ab\u897f\u6587" },
            { "mul", "\u591a\u79cd\u8bed\u7cfb" },
            { "mun", "\u8499\u8fbe\u8bed\u7cfb" },
            { "mus", "\u514b\u91cc\u514b\u6587" },
            { "mwl", "\u7c73\u5170\u5fb7\u65af\u6587" },
            { "mwr", "\u9a6c\u5c14\u74e6\u5229\u6587" },
            { "myn", "\u739b\u96c5\u8bed\u7cfb" },
            { "myv", "\u4fc4\u65e5\u4e9a\u6587" },
            { "nah", "\u7eb3\u74e6\u7279\u5c14\u6587" },
            { "nai", "\u5176\u4ed6\u5317\u7f8e\u5370\u7b2c\u5b89\u8bed\u7cfb" },
            { "nap", "\u62ff\u6ce2\u91cc\u6587" },
            { "nds", "\u4f4e\u5730\u5fb7\u6587\uff1b\u4f4e\u5730\u6492\u514b\u900a\u6587" },
            { "new", "\u5c3c\u74e6\u5c14\u6587" },
            { "nia", "\u5c3c\u4e9a\u65af\u6587" },
            { "nic", "\u5176\u4ed6\u5c3c\u65e5\u5c14\u79d1\u5c14\u591a\u51e1\u8bed\u7cfb" },
            { "niu", "\u7ebd\u57c3\u6587" },
            { "nog", "\u8bfa\u76d6\u6587" },
            { "non", "\u53e4\u8bfa\u5c14\u65af\u6587" },
            { "nqo", "\u897f\u975e\u4e66\u9762\u8bed\u8a00" },
            { "nso", "\u5317\u7d22\u6258\u6587" },
            { "nub", "\u52aa\u6bd4\u4e9a\u8bed\u7cfb" },
            { "nwc", "\u5c3c\u74e6\u5c14\u6587\uff08Classical Newari\uff09" },
            { "nym", "\u5c3c\u4e9a\u59c6\u97e6\u9f50\u6587" },
            { "nyn", "\u5c3c\u6602\u79d1\u52d2\u6587" },
            { "nyo", "\u5c3c\u7ea6\u7f57\u6587" },
            { "nzi", "\u6069\u6d4e\u9a6c\u6587" },
            { "osa", "\u5965\u8428\u683c\u6587" },
            { "ota", "\u5965\u6258\u66fc\u571f\u8033\u5176\u6587" },
            { "oto", "\u5965\u6258\u7c73\u8bed\u7cfb" },
            { "paa", "\u5176\u4ed6\u5df4\u5e03\u4e9a\u6587" },
            { "pag", "\u90a6\u963f\u897f\u6960\u8bed" },
            { "pal", "\u5e15\u62c9\u7ef4\u6587" },
            { "pam", "\u90a6\u677f\u7259\u6587" },
            { "pap", "\u5e15\u76ae\u4e9a\u95e8\u6258\u6587" },
            { "pau", "\u5e15\u52b3\u6587" },
            { "peo", "\u53e4\u8001\u6ce2\u65af\u8bed" },
            { "phi", "\u5176\u4ed6\u83f2\u5f8b\u5bbe\u8bed\u7cfb" },
            { "phn", "\u8153\u5c3c\u57fa\u6587" },
            { "pon", "\u6ce2\u7eb3\u4f69\u6587" },
            { "pra", "\u666e\u62c9\u514b\u91cc\u7279\u8bf8\u8bed\u8a00" },
            { "pro", "\u666e\u7f57\u6587\u65af\u6587" },
            { "raj", "\u62c9\u8d3e\u65af\u5766\u6587" },
            { "rap", "\u62c9\u5e15\u52aa\u4f0a\u6587" },
            { "rar", "\u62c9\u7f57\u6c64\u52a0\u6587" },
            { "roa", "\u5176\u4ed6\u62c9\u4e01\u8bed\u7cfb" },
            { "rom", "\u5409\u666e\u8d5b\u6587" },
            { "rup", "\u4e9a\u7f8e\u5c3c\u4e9a\u8bed" },
            { "sad", "\u6563\u8fbe\u7ef4\u6587" },
            { "sah", "\u96c5\u5e93\u7279\u6587" },
            { "sai", "\u5176\u4ed6\u5357\u7f8e\u5370\u7b2c\u5b89\u6587" },
            { "sal", "\u8428\u5229\u4ec0\u6587" },
            { "sam", "\u8428\u739b\u5229\u4e9a\u6587" },
            { "sas", "\u8428\u8428\u514b\u6587" },
            { "sat", "\u6851\u5854\u5229\u6587" },
            { "scn", "\u897f\u897f\u91cc\u6587" },
            { "sco", "\u82cf\u683c\u5170\u6587" },
            { "sel", "\u585e\u5c14\u5e93\u666e\u6587" },
            { "sem", "\u5176\u4ed6\u95ea\u65cf\u8bed\u7cfb" },
            { "sga", "\u53e4\u7231\u5c14\u5170\u6587" },
            { "sgn", "\u624b\u8bed" },
            { "shn", "\u63b8\u6587" },
            { "sid", "\u6089\u8fbe\u6469\u6587" },
            { "sio", "\u82cf\u8bed\u8bf8\u8bed\u8a00" },
            { "sit", "\u5176\u4ed6\u6c49\u85cf\u8bed\u7cfb" },
            { "sla", "\u5176\u4ed6\u65af\u62c9\u592b\u8bed\u7cfb" },
            { "sma", "\u5357\u8428\u7c73\u6587" },
            { "smi", "\u5176\u4ed6\u8428\u7c73\u6587" },
            { "smj", "\u5f8b\u52d2\u6b27\u8428\u83ab\u65af\u8bed" },
            { "smn", "\u4f0a\u7eb3\u91cc\u8428\u7c73\u8bed" },
            { "sms", "\u65af\u79d1\u7279\u8428\u7c73\u6587" },
            { "snk", "\u7d22\u5c3c\u57fa\u6587" },
            { "sog", "\u53e4\u7c9f\u7279\u8bed" },
            { "son", "\u6851\u6d77\u6587" },
            { "srn", "\u82cf\u91cc\u5357\u6c64\u52a0\u8bed" },
            { "srr", "\u8c22\u5217\u5c14\u6587" },
            { "ssa", "\u975e\u6d32\u6492\u54c8\u62c9\u6c99\u6f20\u8fb9\u7f18\u5730\u5e26\u8bed\u8a00" },
            { "suk", "\u82cf\u5e93\u9a6c\u6587" },
            { "sus", "\u82cf\u82cf\u6587" },
            { "sux", "\u82cf\u9a6c\u6587" },
            { "swb", "\u79d1\u6469\u7f57\u8bed" },
            { "syr", "\u53d9\u5229\u4e9a\u6587" },
            { "tai", "\u50a3\u8bed\u8bf8\u8bed\u8a00\uff08\u5176\u4ed6\uff09" },
            { "tem", "\u6ed5\u5185\u8bed" },
            { "ter", "\u7279\u5217\u7eb3\u6587" },
            { "tet", "\u7279\u5854\u59c6\u6587" },
            { "tig", "\u63d0\u683c\u96f7\u6587" },
            { "tiv", "\u8482\u592b\u6587" },
            { "tkl", "\u6258\u514b\u52b3\u6587" },
            { "tlh", "\u514b\u6797\u8d21\u6587" },
            { "tli", "\u7279\u6797\u5409\u7279\u6587" },
            { "tmh", "\u5854\u9a6c\u5947\u514b\u6587" },
            { "tog", "\u6c64\u52a0\u6587\uff08\u5c3c\u4e9a\u8428\u5730\u533a\uff09" },
            { "tpi", "\u6258\u514b\u76ae\u8f9b\u6587" },
            { "tsi", "\u8482\u59c6\u897f\u4e9a\u6587" },
            { "tum", "\u901a\u5e03\u5361\u6587" },
            { "tup", "\u56fe\u76ae\u8bed\u7cfb" },
            { "tut", "\u963f\u5c14\u6cf0\u8bf8\u8bed\u8a00\uff08\u5176\u4ed6\uff09" },
            { "tvl", "\u56fe\u74e6\u5362\u6587" },
            { "tyv", "\u56fe\u74e6\u6587" },
            { "udm", "\u4e4c\u5fb7\u7a46\u5c14\u7279\u6587" },
            { "uga", "\u4e4c\u52a0\u91cc\u7279\u6587" },
            { "umb", "\u7fc1\u672c\u675c\u6587" },
            { "und", "\u672a\u77e5\u8bed\u8a00" },
            { "vai", "\u74e6\u4f0a\u6587" },
            { "vot", "\u6c83\u63d0\u514b\u6587" },
            { "wak", "\u74e6\u5361\u4ec0\u8bf8\u8bed\u8a00" },
            { "wal", "\u74e6\u62c9\u83ab\u6587" },
            { "war", "\u74e6\u8d56\u6587" },
            { "was", "\u74e6\u7ecd\u6587" },
            { "wen", "\u7d22\u5e03\u8bf8\u8bed\u8a00" },
            { "xal", "\u5361\u5c14\u6885\u514b\u6587" },
            { "yao", "\u7476\u65cf\u6587" },
            { "yap", "\u96c5\u6d66\u6587" },
            { "ypk", "\u5c24\u76ae\u514b\u8bf8\u8bed\u8a00" },
            { "yue", "\u7ca4\u8bed" },
            { "zap", "\u8428\u6ce2\u8482\u514b\u6587" },
            { "zen", "\u6cfd\u7eb3\u52a0\u6587" },
            { "znd", "\u8d5e\u5fb7\u6587" },
            { "zun", "\u7956\u5c3c\u8bed" },
            { "zxx", "\u65e0\u8bed\u8a00\u5185\u5bb9" },
            { "zza", "\u624e\u624e\u6587" },
            { "Arab", "\u963f\u62c9\u4f2f\u8bed" },
            { "Armn", "\u4e9a\u7f8e\u5c3c\u4e9a\u8bed" },
            { "Bali", "\u5df4\u5398\u8bed" },
            { "Batk", "\u5df4\u5854\u514b\u8bed" },
            { "Beng", "\u5b5f\u52a0\u62c9\u8bed" },
            { "Blis", "\u5e03\u5217\u65af\u7b26\u53f7" },
            { "Bopo", "\u6c49\u8bed\u62fc\u97f3" },
            { "Brah", "\u5a46\u7f57\u7c73\u6587\u5b57" },
            { "Brai", "\u5e03\u83b1\u53f6\u76f2\u6587" },
            { "Bugi", "\u5e03\u5409\u8bed" },
            { "Buhd", "\u5e03\u5e0c\u5fb7\u8bed" },
            { "Cans", "\u52a0\u62ff\u5927\u571f\u8457\u7edf\u4e00\u97f3\u8282" },
            { "Cari", "\u5361\u91cc\u4e9a\u8bed" },
            { "Cham", "\u5360\u8bed" },
            { "Cher", "\u5207\u7f57\u57fa\u8bed" },
            { "Cirt", "\u8272\u65af\u6587" },
            { "Copt", "\u514b\u666e\u7279\u8bed" },
            { "Cprt", "\u585e\u6d66\u8def\u65af\u8bed" },
            { "Cyrl", "\u897f\u91cc\u5c14\u8bed" },
            { "Cyrs", "\u897f\u91cc\u5c14\u6587\u5b57\uff08\u53e4\u6559\u4f1a\u65af\u62c9\u592b\u8bed\u7684\u53d8\u4f53\uff09" },
            { "Deva", "\u68b5\u6587" },
            { "Dsrt", "\u5fb7\u585e\u83b1\u7279\u6587" },
            { "Egyd", "\u540e\u671f\u57c3\u53ca\u8bed" },
            { "Egyh", "\u53e4\u57c3\u53ca\u50e7\u4fa3\u4e66\u5199\u4f53" },
            { "Egyp", "\u53e4\u57c3\u53ca\u8c61\u5f62\u6587" },
            { "Ethi", "\u57c3\u585e\u4fc4\u6bd4\u4e9a\u8bed" },
            { "Geok", "\u683c\u9c81\u5409\u4e9a\u8bed\uff08\u6559\u5802\u4f53\uff09" },
            { "Geor", "\u683c\u9c81\u5409\u4e9a\u8bed" },
            { "Glag", "\u683c\u62c9\u54e5\u91cc\u8bed" },
            { "Goth", "\u54e5\u7279\u8bed" },
            { "Grek", "\u5e0c\u814a\u8bed" },
            { "Gujr", "\u53e4\u5409\u62c9\u7279\u8bed" },
            { "Guru", "\u679c\u9c81\u7a46\u5947\u8bed" },
            { "Hang", "\u97e9\u6587" },
            { "Hani", "\u6c49\u8bed" },
            { "Hano", "\u6c49\u5974\u7f57\u8bed" },
            { "Hans", "\u7b80\u4f53\u4e2d\u6587" },
            { "Hant", "\u7e41\u4f53\u4e2d\u6587" },
            { "Hebr", "\u5e0c\u4f2f\u6765\u8bed" },
            { "Hira", "\u5e73\u5047\u540d" },
            { "Hmng", "\u6768\u677e\u5f55\u82d7\u6587" },
            { "Hrkt", "\u7247\u5047\u540d\u6216\u5e73\u5047\u540d" },
            { "Hung", "\u53e4\u5308\u7259\u5229\u8bed" },
            { "Inds", "\u53e4\u5e0c\u814a\u54c8\u62c9\u6f58" },
            { "Ital", "\u53e4\u610f\u5927\u5229\u8bed" },
            { "Java", "\u722a\u54c7\u8bed" },
            { "Jpan", "\u65e5\u8bed" },
            { "Kali", "\u514b\u8036\u674e\u6587\u5b57" },
            { "Kana", "\u7247\u5047\u540d" },
            { "Khar", "\u5361\u7f57\u987b\u63d0\u6587" },
            { "Khmr", "\u9ad8\u68c9\u8bed" },
            { "Knda", "\u5361\u7eb3\u5854\u514b\u8bed" },
            { "Kore", "\u97e9\u8bed" },
            { "Lana", "\u5170\u62ff\u8bed" },
            { "Laoo", "\u8001\u631d\u8bed" },
            { "Latf", "\u62c9\u4e01\u6587\uff08\u54e5\u7279\u5f0f\u5b57\u4f53\u53d8\u4f53\uff09" },
            { "Latg", "\u62c9\u4e01\u6587\uff08\u76d6\u5c14\u8bed\u53d8\u4f53\uff09" },
            { "Latn", "\u62c9\u4e01\u8bed" },
            { "Lepc", "\u96f7\u5e03\u67e5\u8bed" },
            { "Limb", "\u6797\u5e03\u8bed" },
            { "Lina", "\u7ebf\u5f62\u6587\u5b57\uff08A\uff09" },
            { "Linb", "\u7ebf\u5f62\u6587\u5b57\uff08B\uff09" },
            { "Lyci", "\u5229\u897f\u4e9a\u8bed" },
            { "Lydi", "\u5415\u5e95\u4e9a\u8bed" },
            { "Mand", "\u963f\u62c9\u7c73\u8bed" },
            { "Maya", "\u739b\u96c5\u5723\u7b26\u6587" },
            { "Mero", "\u9ea6\u82e5\u63d0\u514b\u6587" },
            { "Mlym", "\u9a6c\u62c9\u4e9a\u62c9\u59c6\u8bed" },
            { "Mong", "\u8499\u53e4\u8bed" },
            { "Moon", "\u97e9\u6587\u8bed\u7cfb" },
            { "Mtei", "\u66fc\u5c3c\u666e\u5c14\u8bed" },
            { "Mymr", "\u7f05\u7538" },
            { "Nkoo", "\u897f\u975e\u4e66\u9762\u8bed\u8a00\uff08N\u2019Ko\uff09" },
            { "Ogam", "\u6b27\u7518\u8bed" },
            { "Olck", "\u6851\u5854\u5229\u8bed" },
            { "Orkh", "\u9102\u5c14\u6d51\u6587" },
            { "Orya", "\u5965\u91cc\u4e9a\u8bed" },
            { "Osma", "\u5965\u65af\u66fc\u4e9a\u8bed" },
            { "Perm", "\u53e4\u5f7c\u5c14\u59c6\u8bf8\u8bed" },
            { "Phag", "\u516b\u601d\u5df4\u6587" },
            { "Phnx", "\u8153\u5c3c\u57fa\u8bed" },
            { "Plrd", "\u6ce2\u62c9\u5fb7\u97f3\u6807\u6587\u5b57" },
            { "Rjng", "\u62c9\u8ba9\u8bed" },
            { "Roro", "\u6717\u683c\u6717\u683c\u6587" },
            { "Runr", "\u53e4\u4ee3\u5317\u6b27\u6587" },
            { "Sara", "\u6c99\u62c9\u5824\u6587" },
            { "Saur", "\u7d22\u62c9\u4ec0\u7279\u62c9\u8bed" },
            { "Sgnw", "\u4e66\u5199\u7b26\u53f7" },
            { "Shaw", "\u8427\u4f2f\u7eb3\u5f0f\u8bed" },
            { "Sinh", "\u8f9b\u54c8\u62c9\u8bed" },
            { "Sund", "\u5dfd\u4ed6\u6587" },
            { "Syrc", "\u53d9\u5229\u4e9a\u8bed" },
            { "Syre", "\u798f\u97f3\u4f53\u53d9\u5229\u4e9a\u6587" },
            { "Syrj", "\u897f\u53d9\u5229\u4e9a\u8bed" },
            { "Syrn", "\u4e1c\u53d9\u5229\u4e9a\u8bed" },
            { "Tagb", "\u5854\u683c\u73ed\u74e6\u8bed" },
            { "Tale", "\u6cf0\u4e50\u8bed" },
            { "Talu", "\u65b0\u50a3\u6587" },
            { "Taml", "\u6cf0\u7c73\u5c14\u8bed" },
            { "Telu", "\u6cf0\u5362\u56fa\u8bed" },
            { "Teng", "\u817e\u683c\u74e6\u6587\u5b57" },
            { "Tfng", "\u63d0\u975e\u7eb3\u6587" },
            { "Tglg", "\u5854\u52a0\u8def\u8bed" },
            { "Thaa", "\u5854\u5b89\u5a1c\u8bed" },
            { "Thai", "\u6cf0\u8bed" },
            { "Tibt", "\u85cf\u8bed" },
            { "Ugar", "\u4e4c\u52a0\u91cc\u7279\u8bed" },
            { "Vaii", "\u74e6\u4f9d\u8bed" },
            { "Visp", "\u53ef\u89c1\u8bed\u8a00" },
            { "Xpeo", "\u53e4\u6ce2\u65af\u8bed" },
            { "Xsux", "\u82cf\u7f8e\u5c14-\u963f\u5361\u5fb7\u6954\u5f62\u6587\u5b57" },
            { "Yiii", "\u5f5d\u6587" },
            { "Zinh", "\u9057\u4f20\u5b66\u672f\u8bed" },
            { "Zsym", "\u7b26\u53f7" },
            { "Zxxx", "\u64a4\u9500\u5199\u5165" },
            { "Zyyy", "\u901a\u7528" },
            { "Zzzz", "\u811a\u672c\u672a\u77e5\u6216\u8005\u65e0\u6548" },
            { "root", "\u6839\u8bed\u8a00" },
            { "de_AT", "\u5965\u5730\u5229\u5fb7\u8bed" },
            { "de_CH", "\u745e\u58eb\u9ad8\u5730\u5fb7\u6587" },
            { "en_AU", "\u82f1\u8bed\uff08\u6fb3\u5927\u5229\u4e9a\uff09" },
            { "en_CA", "\u52a0\u62ff\u5927\u82f1\u8bed" },
            { "en_GB", "\u82f1\u8bed\uff08\u82f1\u56fd\uff09" },
            { "en_US", "\u82f1\u8bed\uff08\u7f8e\u56fd\uff09" },
            { "es_ES", "\u897f\u73ed\u7259\u8bed\uff08\u4f0a\u6bd4\u5229\u4e9a\uff09" },
            { "fr_CA", "\u52a0\u62ff\u5927\u6cd5\u8bed" },
            { "fr_CH", "\u745e\u58eb\u6cd5\u8bed" },
            { "nl_BE", "\u5f17\u62c9\u8292\u8bed" },
            { "pt_BR", "\u8461\u8404\u7259\u8bed\uff08\u5df4\u897f\uff09" },
            { "pt_PT", "\u4f9d\u4f2f\u5229\u4e9a\u8461\u8404\u7259\u6587" },
            { "es_419", "\u62c9\u4e01\u7f8e\u6d32\u897f\u73ed\u7259\u8bed" },
            { "zh_Hans", "\u4e2d\u6587\uff08\u7b80\u4f53\uff09" },
            { "zh_Hant", "\u4e2d\u6587\uff08\u7e41\u4f53\uff09" },
        };
        return data;
    }
}
