/*
 * Decompiled with CFR 0.152.
 */
package org.apache.subversion.javahl.types;

import java.io.Serializable;
import java.util.Date;
import org.apache.subversion.javahl.types.Depth;
import org.apache.subversion.javahl.types.Lock;
import org.apache.subversion.javahl.types.NodeKind;
import org.apache.subversion.javahl.types.Revision;

public class Status
implements Serializable {
    private static final long serialVersionUID = 3L;
    private String url;
    private String path;
    private NodeKind nodeKind;
    private long revision;
    private long lastChangedRevision;
    private long lastChangedDate;
    private String lastCommitAuthor;
    private Kind nodeStatus;
    private Kind textStatus;
    private Kind propStatus;
    private boolean locked;
    private boolean copied;
    private boolean switched;
    private boolean fileExternal;
    private Depth depth;
    private boolean isConflicted;
    private Kind repositoryNodeStatus;
    private Kind repositoryTextStatus;
    private Kind repositoryPropStatus;
    private Lock localLock;
    private Lock reposLock;
    private long reposLastCmtRevision = -1L;
    private long reposLastCmtDate = 0L;
    private NodeKind reposKind = NodeKind.none;
    private String reposLastCmtAuthor;
    private String changelist;
    private String movedFromAbspath;
    private String movedToAbspath;

    public Status(String string, String string2, NodeKind nodeKind, long l, long l2, long l3, String string3, Kind kind, Kind kind2, Kind kind3, Kind kind4, Kind kind5, Kind kind6, boolean bl, boolean bl2, Depth depth, boolean bl3, boolean bl4, boolean bl5, Lock lock, Lock lock2, long l4, long l5, NodeKind nodeKind2, String string4, String string5, String string6, String string7) {
        this.path = string;
        this.url = string2;
        this.nodeKind = nodeKind != null ? nodeKind : NodeKind.unknown;
        this.revision = l;
        this.lastChangedRevision = l2;
        this.lastChangedDate = l3;
        this.lastCommitAuthor = string3;
        this.nodeStatus = kind;
        this.textStatus = kind2;
        this.propStatus = kind3;
        this.repositoryNodeStatus = kind4;
        this.repositoryTextStatus = kind5;
        this.repositoryPropStatus = kind6;
        this.locked = bl;
        this.copied = bl2;
        this.depth = depth;
        this.isConflicted = bl3;
        this.switched = bl4;
        this.fileExternal = bl5;
        this.localLock = lock;
        this.reposLock = lock2;
        this.reposLastCmtRevision = l4;
        this.reposLastCmtDate = l5;
        this.reposKind = nodeKind2;
        this.reposLastCmtAuthor = string4;
        this.changelist = string5;
        this.movedFromAbspath = string6;
        this.movedToAbspath = string7;
    }

    @Deprecated
    public Status(String string, String string2, NodeKind nodeKind, long l, long l2, long l3, String string3, Kind kind, Kind kind2, Kind kind3, Kind kind4, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, Lock lock, Lock lock2, long l4, long l5, NodeKind nodeKind2, String string4, String string5, String string6, String string7) {
        this(string, string2, nodeKind, l, l2, l3, string3, Kind.none, kind, kind2, Kind.none, kind3, kind4, bl, bl2, Depth.unknown, bl3, bl4, bl5, lock, lock2, l4, l5, nodeKind2, string4, string5, string6, string7);
    }

    public String getPath() {
        return this.path;
    }

    public Revision.Number getRevision() {
        return Revision.createNumber(this.revision);
    }

    public long getRevisionNumber() {
        return this.revision;
    }

    public Date getLastChangedDate() {
        return Status.microsecondsToDate(this.lastChangedDate);
    }

    public long getLastChangedDateMicros() {
        return this.lastChangedDate;
    }

    public String getLastCommitAuthor() {
        return this.lastCommitAuthor;
    }

    public Kind getNodeStatus() {
        return this.nodeStatus;
    }

    public String getNodeStatusDescription() {
        return this.nodeStatus.toString();
    }

    public Kind getRawTextStatus() {
        return this.textStatus;
    }

    public String getRawTextStatusDescription() {
        return this.textStatus.toString();
    }

    public Kind getTextStatus() {
        if (this.nodeStatus == Kind.modified || this.nodeStatus == Kind.conflicted) {
            return this.textStatus;
        }
        return this.nodeStatus;
    }

    public String getTextStatusDescription() {
        return this.getTextStatus().toString();
    }

    public Kind getPropStatus() {
        return this.propStatus;
    }

    public String getPropStatusDescription() {
        return this.propStatus.toString();
    }

    public Kind getRepositoryNodeStatus() {
        return this.repositoryNodeStatus;
    }

    public Kind getRawRepositoryTextStatus() {
        return this.repositoryTextStatus;
    }

    public Kind getRepositoryTextStatus() {
        if (this.repositoryNodeStatus == Kind.modified || this.repositoryNodeStatus == Kind.conflicted) {
            return this.repositoryTextStatus;
        }
        return this.repositoryNodeStatus;
    }

    public Kind getRepositoryPropStatus() {
        return this.repositoryPropStatus;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public boolean isCopied() {
        return this.copied;
    }

    public String getUrl() {
        return this.url;
    }

    public Revision.Number getLastChangedRevision() {
        return Revision.createNumber(this.lastChangedRevision);
    }

    public long getLastChangedRevisionNumber() {
        return this.lastChangedRevision;
    }

    public NodeKind getNodeKind() {
        return this.nodeKind;
    }

    public boolean isSwitched() {
        return this.switched;
    }

    public boolean isFileExternal() {
        return this.fileExternal;
    }

    public boolean isManaged() {
        Kind kind = this.getNodeStatus();
        return kind != Kind.unversioned && kind != Kind.none && kind != Kind.ignored;
    }

    public boolean hasRemote() {
        return this.isManaged() && !this.isAdded();
    }

    public boolean isAdded() {
        return this.getNodeStatus() == Kind.added;
    }

    public boolean isDeleted() {
        return this.getNodeStatus() == Kind.deleted;
    }

    public boolean isMerged() {
        return this.getNodeStatus() == Kind.merged;
    }

    public boolean isIgnored() {
        return this.getNodeStatus() == Kind.ignored;
    }

    public boolean isModified() {
        return this.getTextStatus() == Kind.modified;
    }

    public Lock getLocalLock() {
        return this.localLock;
    }

    public Lock getReposLock() {
        return this.reposLock;
    }

    public Revision.Number getReposLastCmtRevision() {
        return Revision.createNumber(this.reposLastCmtRevision);
    }

    public long getReposLastCmtRevisionNumber() {
        return this.reposLastCmtRevision;
    }

    public Date getReposLastCmtDate() {
        return Status.microsecondsToDate(this.reposLastCmtDate);
    }

    public long getReposLastCmtDateMicros() {
        return this.reposLastCmtDate;
    }

    public NodeKind getReposKind() {
        return this.reposKind;
    }

    public String getReposLastCmtAuthor() {
        return this.reposLastCmtAuthor;
    }

    public String getChangelist() {
        return this.changelist;
    }

    public boolean isConflicted() {
        return this.isConflicted;
    }

    public String getMovedFromAbspath() {
        return this.movedFromAbspath;
    }

    public String getMovedToAbspath() {
        return this.movedToAbspath;
    }

    public Depth getDepth() {
        return this.depth;
    }

    private static Date microsecondsToDate(long l) {
        return l == 0L ? null : new Date(l / 1000L);
    }

    public static enum Kind {
        none("non-svn"),
        unversioned("unversioned"),
        normal("normal"),
        added("added"),
        missing("missing"),
        deleted("deleted"),
        replaced("replaced"),
        modified("modified"),
        merged("merged"),
        conflicted("conflicted"),
        ignored("ignored"),
        obstructed("obstructed"),
        external("external"),
        incomplete("incomplete");

        private String description;

        private Kind(String string2) {
            this.description = string2;
        }

        public String toString() {
            return this.description;
        }
    }
}

