/*
 * Decompiled with CFR 0.152.
 */
package jakarta.el;

import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.ExpressionFactory;
import jakarta.el.MethodNotFoundException;
import java.lang.ref.WeakReference;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

class Util {
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final boolean IS_SECURITY_ENABLED;
    private static final boolean GET_CLASSLOADER_USE_PRIVILEGED;
    private static final CacheValue nullTcclFactory;
    private static final Map<CacheKey, CacheValue> factoryCache;

    Util() {
    }

    static void handleThrowable(Throwable throwable) {
        if (throwable instanceof ThreadDeath) {
            throw (ThreadDeath)throwable;
        }
        if (throwable instanceof VirtualMachineError) {
            throw (VirtualMachineError)throwable;
        }
    }

    static String message(ELContext eLContext, String string, Object ... objectArray) {
        Locale locale = null;
        if (eLContext != null) {
            locale = eLContext.getLocale();
        }
        if (locale == null && (locale = Locale.getDefault()) == null) {
            return "";
        }
        ResourceBundle resourceBundle = ResourceBundle.getBundle("jakarta.el.LocalStrings", locale);
        try {
            String string2 = resourceBundle.getString(string);
            if (objectArray != null) {
                string2 = MessageFormat.format(string2, objectArray);
            }
            return string2;
        }
        catch (MissingResourceException missingResourceException) {
            return "Missing Resource: '" + string + "' for Locale " + locale.getDisplayName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ExpressionFactory getExpressionFactory() {
        Object object;
        Object object2;
        ClassLoader classLoader = Util.getContextClassLoader();
        Object object3 = null;
        ExpressionFactory expressionFactory = null;
        if (classLoader == null) {
            object3 = nullTcclFactory;
        } else {
            object2 = new CacheKey(classLoader);
            object3 = factoryCache.get(object2);
            if (object3 == null && (object3 = factoryCache.putIfAbsent((CacheKey)object2, (CacheValue)(object = new CacheValue()))) == null) {
                object3 = object;
            }
        }
        object2 = ((CacheValue)object3).getLock().readLock();
        object2.lock();
        try {
            expressionFactory = ((CacheValue)object3).getExpressionFactory();
        }
        finally {
            object2.unlock();
        }
        if (expressionFactory == null) {
            object = ((CacheValue)object3).getLock().writeLock();
            object.lock();
            try {
                expressionFactory = ((CacheValue)object3).getExpressionFactory();
                if (expressionFactory == null) {
                    expressionFactory = ExpressionFactory.newInstance();
                    ((CacheValue)object3).setExpressionFactory(expressionFactory);
                }
            }
            finally {
                object.unlock();
            }
        }
        return expressionFactory;
    }

    static Method findMethod(ELContext eLContext, Class<?> clazz, Object object, String string, Class<?>[] classArray, Object[] objectArray) {
        if (clazz == null || string == null) {
            throw new MethodNotFoundException(Util.message(null, "util.method.notfound", clazz, string, Util.paramString(classArray)));
        }
        if (classArray == null) {
            classArray = Util.getTypesFromValues(objectArray);
        }
        Method[] methodArray = clazz.getMethods();
        List list = Wrapper.wrap(methodArray, string);
        Wrapper wrapper = Util.findWrapper(eLContext, clazz, list, string, classArray, objectArray);
        return Util.getMethod(clazz, object, (Method)wrapper.unWrap());
    }

    private static <T> Wrapper<T> findWrapper(ELContext eLContext, Class<?> clazz, List<Wrapper<T>> list, String string, Class<?>[] classArray, Object[] objectArray) {
        int n;
        Wrapper<T> wrapper2;
        HashMap<Wrapper, MatchResult> hashMap = new HashMap<Wrapper, MatchResult>();
        int n2 = classArray.length;
        for (Wrapper<T> wrapper2 : list) {
            Class<?>[] classArray2 = wrapper2.getParameterTypes();
            int n3 = classArray2 == null ? 0 : classArray2.length;
            if (!wrapper2.isVarArgs() && n2 != n3 || wrapper2.isVarArgs() && n2 < n3 - 1 || wrapper2.isVarArgs() && n2 == n3 && objectArray != null && objectArray.length > n2 && !classArray[n3 - 1].isArray() || wrapper2.isVarArgs() && n2 > n3 && objectArray != null && objectArray.length != n2 || !wrapper2.isVarArgs() && objectArray != null && n2 != objectArray.length) continue;
            int n4 = 0;
            n = 0;
            int n5 = 0;
            int n6 = 0;
            boolean bl = false;
            block1: for (int i = 0; i < n3; ++i) {
                if (wrapper2.isVarArgs() && i == n3 - 1) {
                    if (i == n2 || objectArray != null && objectArray.length == i) {
                        n6 = Integer.MAX_VALUE;
                        break;
                    }
                    Class<?> clazz2 = classArray2[i].getComponentType();
                    for (int j = i; j < n2; ++j) {
                        if (Util.isAssignableFrom(classArray[j], clazz2)) {
                            ++n;
                            ++n6;
                            continue;
                        }
                        if (objectArray == null) {
                            bl = true;
                            continue block1;
                        }
                        if (Util.isCoercibleFrom(eLContext, objectArray[j], clazz2)) {
                            ++n5;
                            ++n6;
                            continue;
                        }
                        bl = true;
                        continue block1;
                    }
                    continue;
                }
                if (classArray2[i].equals(classArray[i])) {
                    ++n4;
                    continue;
                }
                if (classArray[i] != null && Util.isAssignableFrom(classArray[i], classArray2[i])) {
                    ++n;
                    continue;
                }
                if (objectArray == null) {
                    bl = true;
                    break;
                }
                if (Util.isCoercibleFrom(eLContext, objectArray[i], classArray2[i])) {
                    ++n5;
                    continue;
                }
                bl = true;
                break;
            }
            if (bl) continue;
            if (n4 == n2 && n6 == 0) {
                return wrapper2;
            }
            hashMap.put(wrapper2, new MatchResult(wrapper2.isVarArgs(), n4, n, n5, n6, wrapper2.isBridge()));
        }
        Object object = new MatchResult(true, 0, 0, 0, 0, true);
        wrapper2 = null;
        boolean bl = false;
        for (Map.Entry entry : hashMap.entrySet()) {
            n = ((MatchResult)entry.getValue()).compareTo((MatchResult)object);
            if (n > 0 || wrapper2 == null) {
                object = (MatchResult)entry.getValue();
                wrapper2 = (Wrapper<T>)entry.getKey();
                bl = false;
                continue;
            }
            if (n != 0) continue;
            bl = true;
        }
        if (bl && (wrapper2 = ((MatchResult)object).getExactCount() == n2 - 1 ? Util.resolveAmbiguousWrapper(hashMap.keySet(), classArray) : null) == null) {
            throw new MethodNotFoundException(Util.message(null, "util.method.ambiguous", clazz, string, Util.paramString(classArray)));
        }
        if (wrapper2 == null) {
            throw new MethodNotFoundException(Util.message(null, "util.method.notfound", clazz, string, Util.paramString(classArray)));
        }
        return wrapper2;
    }

    private static String paramString(Class<?>[] classArray) {
        if (classArray != null) {
            StringBuilder stringBuilder = new StringBuilder();
            for (Class<?> clazz : classArray) {
                if (clazz == null) {
                    stringBuilder.append("null, ");
                    continue;
                }
                stringBuilder.append(clazz.getName()).append(", ");
            }
            if (stringBuilder.length() > 2) {
                stringBuilder.setLength(stringBuilder.length() - 2);
            }
            return stringBuilder.toString();
        }
        return null;
    }

    private static <T> Wrapper<T> resolveAmbiguousWrapper(Set<Wrapper<T>> set, Class<?>[] classArray) {
        Wrapper<T> wrapper;
        Wrapper<T> wrapper2 = set.iterator().next();
        int n = 0;
        Class<?> clazz = null;
        for (int i = 0; i < classArray.length; ++i) {
            if (wrapper2.getParameterTypes()[i] == classArray[i]) continue;
            n = i;
            clazz = classArray[i];
            break;
        }
        if (clazz == null) {
            return null;
        }
        Class clazz2 = set.iterator();
        while (clazz2.hasNext()) {
            wrapper = clazz2.next();
            if (wrapper.getParameterTypes()[n] != classArray[n]) continue;
            return null;
        }
        for (clazz2 = clazz.getSuperclass(); clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            for (Wrapper object : set) {
                if (!object.getParameterTypes()[n].equals(clazz2)) continue;
                return object;
            }
        }
        wrapper = null;
        if (Number.class.isAssignableFrom(clazz)) {
            for (Wrapper<T> wrapper3 : set) {
                Class<?> clazz3 = wrapper3.getParameterTypes()[n];
                if (!Number.class.isAssignableFrom(clazz3) && !clazz3.isPrimitive()) continue;
                if (wrapper == null) {
                    wrapper = wrapper3;
                    continue;
                }
                wrapper = null;
                break;
            }
        }
        return wrapper;
    }

    static boolean isAssignableFrom(Class<?> clazz, Class<?> clazz2) {
        if (clazz == null) {
            return true;
        }
        Class<Object> clazz3 = clazz2.isPrimitive() ? (clazz2 == Boolean.TYPE ? Boolean.class : (clazz2 == Character.TYPE ? Character.class : (clazz2 == Byte.TYPE ? Byte.class : (clazz2 == Short.TYPE ? Short.class : (clazz2 == Integer.TYPE ? Integer.class : (clazz2 == Long.TYPE ? Long.class : (clazz2 == Float.TYPE ? Float.class : Double.class))))))) : clazz2;
        return clazz3.isAssignableFrom(clazz);
    }

    private static boolean isCoercibleFrom(ELContext eLContext, Object object, Class<?> clazz) {
        try {
            eLContext.convertToType(object, clazz);
        }
        catch (ELException eLException) {
            return false;
        }
        return true;
    }

    private static Class<?>[] getTypesFromValues(Object[] objectArray) {
        if (objectArray == null) {
            return EMPTY_CLASS_ARRAY;
        }
        Class[] classArray = new Class[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            classArray[i] = objectArray[i] == null ? null : objectArray[i].getClass();
        }
        return classArray;
    }

    static Method getMethod(Class<?> clazz, Object object, Method method) {
        if (method == null || Modifier.isPublic(clazz.getModifiers()) && (Modifier.isStatic(method.getModifiers()) && Util.canAccess(null, method) || Util.canAccess(object, method))) {
            return method;
        }
        Class<?>[] classArray = clazz.getInterfaces();
        Method method2 = null;
        for (Class<?> clazz2 : classArray) {
            try {
                method2 = clazz2.getMethod(method.getName(), method.getParameterTypes());
                method2 = Util.getMethod(method2.getDeclaringClass(), object, method2);
                if (method2 == null) continue;
                return method2;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        Class<?> clazz3 = clazz.getSuperclass();
        if (clazz3 != null) {
            try {
                method2 = clazz3.getMethod(method.getName(), method.getParameterTypes());
                method2 = Util.getMethod(method2.getDeclaringClass(), object, method2);
                if (method2 != null) {
                    return method2;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return null;
    }

    static Constructor<?> findConstructor(ELContext eLContext, Class<?> clazz, Class<?>[] classArray, Object[] objectArray) {
        String string = "<init>";
        if (clazz == null) {
            throw new MethodNotFoundException(Util.message(null, "util.method.notfound", null, string, Util.paramString(classArray)));
        }
        if (classArray == null) {
            classArray = Util.getTypesFromValues(objectArray);
        }
        Constructor<?>[] constructorArray = clazz.getConstructors();
        List list = Wrapper.wrap(constructorArray);
        Wrapper wrapper = Util.findWrapper(eLContext, clazz, list, string, classArray, objectArray);
        Constructor constructor = (Constructor)wrapper.unWrap();
        if (!Modifier.isPublic(clazz.getModifiers()) || !Util.canAccess(null, constructor)) {
            throw new MethodNotFoundException(Util.message(null, "util.method.notfound", clazz, string, Util.paramString(classArray)));
        }
        return constructor;
    }

    static boolean canAccess(Object object, AccessibleObject accessibleObject) {
        try {
            return accessibleObject.canAccess(object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    static Object[] buildParameters(ELContext eLContext, Class<?>[] classArray, boolean bl, Object[] objectArray) {
        Object[] objectArray2 = null;
        if (classArray.length > 0) {
            objectArray2 = new Object[classArray.length];
            if (objectArray == null) {
                objectArray = EMPTY_OBJECT_ARRAY;
            }
            int n = objectArray.length;
            if (bl) {
                int n2 = classArray.length - 1;
                for (int i = 0; i < n2; ++i) {
                    objectArray2[i] = eLContext.convertToType(objectArray[i], classArray[i]);
                }
                Class<?> clazz = classArray[n2].getComponentType();
                Object object = Array.newInstance(clazz, n - n2);
                for (int i = n2; i < n; ++i) {
                    Array.set(object, i - n2, eLContext.convertToType(objectArray[i], clazz));
                }
                objectArray2[n2] = object;
            } else {
                objectArray2 = new Object[classArray.length];
                for (int i = 0; i < classArray.length; ++i) {
                    objectArray2[i] = eLContext.convertToType(objectArray[i], classArray[i]);
                }
            }
        }
        return objectArray2;
    }

    static ClassLoader getContextClassLoader() {
        ClassLoader classLoader;
        if (IS_SECURITY_ENABLED && GET_CLASSLOADER_USE_PRIVILEGED) {
            PrivilegedGetTccl privilegedGetTccl = new PrivilegedGetTccl();
            classLoader = AccessController.doPrivileged(privilegedGetTccl);
        } else {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        return classLoader;
    }

    static {
        boolean bl = IS_SECURITY_ENABLED = System.getSecurityManager() != null;
        if (IS_SECURITY_ENABLED) {
            String string = AccessController.doPrivileged(() -> System.getProperty("org.apache.el.GET_CLASSLOADER_USE_PRIVILEGED", "true"));
            GET_CLASSLOADER_USE_PRIVILEGED = Boolean.parseBoolean(string);
        } else {
            GET_CLASSLOADER_USE_PRIVILEGED = false;
        }
        nullTcclFactory = new CacheValue();
        factoryCache = new ConcurrentHashMap<CacheKey, CacheValue>();
    }

    private static class PrivilegedGetTccl
    implements PrivilegedAction<ClassLoader> {
        private PrivilegedGetTccl() {
        }

        @Override
        public ClassLoader run() {
            return Thread.currentThread().getContextClassLoader();
        }
    }

    private static class MatchResult
    implements Comparable<MatchResult> {
        private final boolean varArgs;
        private final int exactCount;
        private final int assignableCount;
        private final int coercibleCount;
        private final int varArgsCount;
        private final boolean bridge;

        MatchResult(boolean bl, int n, int n2, int n3, int n4, boolean bl2) {
            this.varArgs = bl;
            this.exactCount = n;
            this.assignableCount = n2;
            this.coercibleCount = n3;
            this.varArgsCount = n4;
            this.bridge = bl2;
        }

        public boolean isVarArgs() {
            return this.varArgs;
        }

        public int getExactCount() {
            return this.exactCount;
        }

        public int getAssignableCount() {
            return this.assignableCount;
        }

        public int getCoercibleCount() {
            return this.coercibleCount;
        }

        public int getVarArgsCount() {
            return this.varArgsCount;
        }

        public boolean isBridge() {
            return this.bridge;
        }

        @Override
        public int compareTo(MatchResult matchResult) {
            int n = Boolean.compare(matchResult.isVarArgs(), this.isVarArgs());
            if (n == 0 && (n = Integer.compare(this.getExactCount(), matchResult.getExactCount())) == 0 && (n = Integer.compare(this.getAssignableCount(), matchResult.getAssignableCount())) == 0 && (n = Integer.compare(this.getCoercibleCount(), matchResult.getCoercibleCount())) == 0 && (n = Integer.compare(matchResult.getVarArgsCount(), this.getVarArgsCount())) == 0) {
                n = Boolean.compare(matchResult.isBridge(), this.isBridge());
            }
            return n;
        }

        public boolean equals(Object object) {
            return object == this || null != object && this.getClass().equals(object.getClass()) && ((MatchResult)object).getExactCount() == this.getExactCount() && ((MatchResult)object).getAssignableCount() == this.getAssignableCount() && ((MatchResult)object).getCoercibleCount() == this.getCoercibleCount() && ((MatchResult)object).getVarArgsCount() == this.getVarArgsCount() && ((MatchResult)object).isVarArgs() == this.isVarArgs() && ((MatchResult)object).isBridge() == this.isBridge();
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + this.assignableCount;
            n = 31 * n + (this.bridge ? 1231 : 1237);
            n = 31 * n + this.coercibleCount;
            n = 31 * n + this.exactCount;
            n = 31 * n + (this.varArgs ? 1231 : 1237);
            n = 31 * n + this.varArgsCount;
            return n;
        }
    }

    private static class ConstructorWrapper
    extends Wrapper<Constructor<?>> {
        private final Constructor<?> c;

        ConstructorWrapper(Constructor<?> constructor) {
            this.c = constructor;
        }

        @Override
        public Constructor<?> unWrap() {
            return this.c;
        }

        @Override
        public Class<?>[] getParameterTypes() {
            return this.c.getParameterTypes();
        }

        @Override
        public boolean isVarArgs() {
            return this.c.isVarArgs();
        }

        @Override
        public boolean isBridge() {
            return false;
        }
    }

    private static class MethodWrapper
    extends Wrapper<Method> {
        private final Method m;

        MethodWrapper(Method method) {
            this.m = method;
        }

        @Override
        public Method unWrap() {
            return this.m;
        }

        @Override
        public Class<?>[] getParameterTypes() {
            return this.m.getParameterTypes();
        }

        @Override
        public boolean isVarArgs() {
            return this.m.isVarArgs();
        }

        @Override
        public boolean isBridge() {
            return this.m.isBridge();
        }
    }

    private static abstract class Wrapper<T> {
        private Wrapper() {
        }

        public static List<Wrapper<Method>> wrap(Method[] methodArray, String string) {
            ArrayList<Wrapper<Method>> arrayList = new ArrayList<Wrapper<Method>>();
            for (Method method : methodArray) {
                if (!method.getName().equals(string)) continue;
                arrayList.add(new MethodWrapper(method));
            }
            return arrayList;
        }

        public static List<Wrapper<Constructor<?>>> wrap(Constructor<?>[] constructorArray) {
            ArrayList arrayList = new ArrayList();
            for (Constructor<?> constructor : constructorArray) {
                arrayList.add(new ConstructorWrapper(constructor));
            }
            return arrayList;
        }

        public abstract T unWrap();

        public abstract Class<?>[] getParameterTypes();

        public abstract boolean isVarArgs();

        public abstract boolean isBridge();
    }

    private static class CacheValue {
        private final ReadWriteLock lock = new ReentrantReadWriteLock();
        private WeakReference<ExpressionFactory> ref;

        CacheValue() {
        }

        public ReadWriteLock getLock() {
            return this.lock;
        }

        public ExpressionFactory getExpressionFactory() {
            return this.ref != null ? (ExpressionFactory)this.ref.get() : null;
        }

        public void setExpressionFactory(ExpressionFactory expressionFactory) {
            this.ref = new WeakReference<ExpressionFactory>(expressionFactory);
        }
    }

    private static class CacheKey {
        private final int hash;
        private final WeakReference<ClassLoader> ref;

        CacheKey(ClassLoader classLoader) {
            this.hash = classLoader.hashCode();
            this.ref = new WeakReference<ClassLoader>(classLoader);
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof CacheKey)) {
                return false;
            }
            ClassLoader classLoader = (ClassLoader)this.ref.get();
            if (classLoader == null) {
                return false;
            }
            return classLoader == ((CacheKey)object).ref.get();
        }
    }
}

