/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http.parser;

import java.nio.charset.StandardCharsets;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.http.ServerCookie;
import org.apache.tomcat.util.http.ServerCookies;
import org.apache.tomcat.util.http.parser.HttpParser;
import org.apache.tomcat.util.http.parser.SkipResult;
import org.apache.tomcat.util.log.UserDataHelper;
import org.apache.tomcat.util.res.StringManager;

public class Cookie {
    private static final Log log;
    private static final UserDataHelper invalidCookieLog;
    private static final StringManager sm;
    private static final boolean[] isCookieOctet;
    private static final boolean[] isText;
    private static final byte[] EMPTY_BYTES;
    private static final byte TAB_BYTE = 9;
    private static final byte SPACE_BYTE = 32;
    private static final byte QUOTE_BYTE = 34;
    private static final byte COMMA_BYTE = 44;
    private static final byte SEMICOLON_BYTE = 59;
    private static final byte EQUALS_BYTE = 61;
    private static final byte SLASH_BYTE = 92;
    private static final byte DEL_BYTE = 127;

    private Cookie() {
    }

    public static void parseCookie(byte[] byArray, int n, int n2, ServerCookies serverCookies) {
        ByteBuffer byteBuffer = new ByteBuffer(byArray, n, n2);
        boolean bl = true;
        while (bl) {
            Cookie.skipLWS(byteBuffer);
            int n3 = byteBuffer.position();
            ByteBuffer byteBuffer2 = Cookie.readToken(byteBuffer);
            ByteBuffer byteBuffer3 = null;
            Cookie.skipLWS(byteBuffer);
            SkipResult skipResult = Cookie.skipByte(byteBuffer, (byte)61);
            if (skipResult == SkipResult.FOUND) {
                Cookie.skipLWS(byteBuffer);
                byteBuffer3 = Cookie.readCookieValueRfc6265(byteBuffer);
                if (byteBuffer3 == null) {
                    Cookie.skipUntilSemiColon(byteBuffer);
                    Cookie.logInvalidHeader(n3, byteBuffer);
                    continue;
                }
                Cookie.skipLWS(byteBuffer);
            }
            if ((skipResult = Cookie.skipByte(byteBuffer, (byte)59)) != SkipResult.FOUND) {
                if (skipResult == SkipResult.NOT_FOUND) {
                    Cookie.skipUntilSemiColon(byteBuffer);
                    Cookie.logInvalidHeader(n3, byteBuffer);
                    continue;
                }
                bl = false;
            }
            if (!byteBuffer2.hasRemaining()) continue;
            ServerCookie serverCookie = serverCookies.addCookie();
            serverCookie.getName().setBytes(byteBuffer2.array(), byteBuffer2.position(), byteBuffer2.remaining());
            if (byteBuffer3 == null) {
                serverCookie.getValue().setBytes(EMPTY_BYTES, 0, EMPTY_BYTES.length);
                continue;
            }
            serverCookie.getValue().setBytes(byteBuffer3.array(), byteBuffer3.position(), byteBuffer3.remaining());
        }
    }

    private static void skipLWS(ByteBuffer byteBuffer) {
        while (byteBuffer.hasRemaining()) {
            byte by = byteBuffer.get();
            if (by == 9 || by == 32) continue;
            byteBuffer.rewind();
            break;
        }
    }

    private static void skipUntilSemiColon(ByteBuffer byteBuffer) {
        while (byteBuffer.hasRemaining() && byteBuffer.get() != 59) {
        }
    }

    private static SkipResult skipByte(ByteBuffer byteBuffer, byte by) {
        if (!byteBuffer.hasRemaining()) {
            return SkipResult.EOF;
        }
        if (byteBuffer.get() == by) {
            return SkipResult.FOUND;
        }
        byteBuffer.rewind();
        return SkipResult.NOT_FOUND;
    }

    private static ByteBuffer readCookieValueRfc6265(ByteBuffer byteBuffer) {
        boolean bl = false;
        if (byteBuffer.hasRemaining()) {
            if (byteBuffer.get() == 34) {
                bl = true;
            } else {
                byteBuffer.rewind();
            }
        }
        int n = byteBuffer.position();
        int n2 = byteBuffer.limit();
        while (byteBuffer.hasRemaining()) {
            byte by = byteBuffer.get();
            if (isCookieOctet[by & 0xFF]) continue;
            if (by == 59 || by == 32 || by == 9) {
                n2 = byteBuffer.position() - 1;
                byteBuffer.position(n2);
                break;
            }
            if (bl && by == 34) {
                n2 = byteBuffer.position() - 1;
                break;
            }
            return null;
        }
        return new ByteBuffer(byteBuffer.bytes, n, n2 - n);
    }

    private static ByteBuffer readToken(ByteBuffer byteBuffer) {
        int n = byteBuffer.position();
        int n2 = byteBuffer.limit();
        while (byteBuffer.hasRemaining()) {
            if (HttpParser.isToken(byteBuffer.get())) continue;
            n2 = byteBuffer.position() - 1;
            byteBuffer.position(n2);
            break;
        }
        return new ByteBuffer(byteBuffer.bytes, n, n2 - n);
    }

    private static void logInvalidHeader(int n, ByteBuffer byteBuffer) {
        UserDataHelper.Mode mode = invalidCookieLog.getNextMode();
        if (mode != null) {
            String string = new String(byteBuffer.array(), n, byteBuffer.position() - n, StandardCharsets.UTF_8);
            Object object = sm.getString("cookie.invalidCookieValue", new Object[]{string});
            switch (mode) {
                case INFO_THEN_DEBUG: {
                    object = (String)object + sm.getString("cookie.fallToDebug");
                }
                case INFO: {
                    log.info(object);
                    break;
                }
                case DEBUG: {
                    log.debug(object);
                }
            }
        }
    }

    static {
        int n;
        log = LogFactory.getLog(Cookie.class);
        invalidCookieLog = new UserDataHelper(log);
        sm = StringManager.getManager((String)"org.apache.tomcat.util.http.parser");
        isCookieOctet = new boolean[256];
        isText = new boolean[256];
        EMPTY_BYTES = new byte[0];
        for (n = 0; n < 256; ++n) {
            Cookie.isCookieOctet[n] = n >= 33 && n != 34 && n != 44 && n != 59 && n != 92 && n != 127;
        }
        for (n = 0; n < 256; ++n) {
            Cookie.isText[n] = n >= 9 && (n <= 9 || n >= 32) && n != 127;
        }
    }

    private static class ByteBuffer {
        private final byte[] bytes;
        private int limit;
        private int position = 0;

        ByteBuffer(byte[] byArray, int n, int n2) {
            this.bytes = byArray;
            this.position = n;
            this.limit = n + n2;
        }

        public int position() {
            return this.position;
        }

        public void position(int n) {
            this.position = n;
        }

        public int limit() {
            return this.limit;
        }

        public int remaining() {
            return this.limit - this.position;
        }

        public boolean hasRemaining() {
            return this.position < this.limit;
        }

        public byte get() {
            return this.bytes[this.position++];
        }

        public void rewind() {
            --this.position;
        }

        public byte[] array() {
            return this.bytes;
        }

        public String toString() {
            return "position [" + this.position + "], limit [" + this.limit + "]";
        }
    }
}

