/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.jni;

import java.io.File;
import org.apache.tomcat.jni.LibraryNotFoundError;

public final class Library {
    private static final String[] NAMES = new String[]{"tcnative-2", "libtcnative-2", "tcnative-1", "libtcnative-1"};
    private static Library _instance = null;
    public static int TCN_MAJOR_VERSION = 0;
    public static int TCN_MINOR_VERSION = 0;
    public static int TCN_PATCH_VERSION = 0;
    public static int TCN_IS_DEV_VERSION = 0;
    public static int APR_MAJOR_VERSION = 0;
    public static int APR_MINOR_VERSION = 0;
    public static int APR_PATCH_VERSION = 0;
    public static int APR_IS_DEV_VERSION = 0;

    private Library() throws Exception {
        String[] stringArray;
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        File file = new File(System.getProperty("catalina.home"), "bin");
        for (int i = 0; i < NAMES.length; ++i) {
            stringArray = new File(file, System.mapLibraryName(NAMES[i]));
            try {
                System.load(stringArray.getAbsolutePath());
                bl = true;
            }
            catch (ThreadDeath | VirtualMachineError error) {
                throw error;
            }
            catch (Throwable throwable) {
                if (stringArray.exists()) {
                    throw throwable;
                }
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(throwable.getMessage());
            }
            if (bl) break;
        }
        if (!bl) {
            String string = System.getProperty("java.library.path");
            stringArray = string.split(File.pathSeparator);
            String[] stringArray2 = NAMES;
            int n = stringArray2.length;
            for (int i = 0; i < n; ++i) {
                String string2 = stringArray2[i];
                try {
                    System.loadLibrary(string2);
                    bl = true;
                }
                catch (ThreadDeath | VirtualMachineError error) {
                    throw error;
                }
                catch (Throwable throwable) {
                    String string3 = System.mapLibraryName(string2);
                    for (String string4 : stringArray) {
                        File file2 = new File(string4, string3);
                        if (!file2.exists()) continue;
                        throw throwable;
                    }
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(throwable.getMessage());
                }
                if (bl) break;
            }
        }
        if (!bl) {
            StringBuilder stringBuilder2 = new StringBuilder();
            for (String string : NAMES) {
                stringBuilder2.append(string);
                stringBuilder2.append(", ");
            }
            throw new LibraryNotFoundError(stringBuilder2.substring(0, stringBuilder2.length() - 2), stringBuilder.toString());
        }
    }

    private Library(String string) {
        System.loadLibrary(string);
    }

    private static native boolean initialize();

    public static native void terminate();

    private static native int version(int var0);

    public static native String versionString();

    public static native String aprVersionString();

    public static synchronized boolean initialize(String string) throws Exception {
        if (_instance == null) {
            _instance = string == null ? new Library() : new Library(string);
            TCN_MAJOR_VERSION = Library.version(1);
            TCN_MINOR_VERSION = Library.version(2);
            TCN_PATCH_VERSION = Library.version(3);
            TCN_IS_DEV_VERSION = Library.version(4);
            APR_MAJOR_VERSION = Library.version(17);
            APR_MINOR_VERSION = Library.version(18);
            APR_PATCH_VERSION = Library.version(19);
            APR_IS_DEV_VERSION = Library.version(20);
            if (APR_MAJOR_VERSION < 1) {
                throw new UnsatisfiedLinkError("Unsupported APR Version (" + Library.aprVersionString() + ")");
            }
        }
        return Library.initialize();
    }
}

