test("length is 1", () => {
    expect(Number).toHaveLength(1);
});

test("constructor without new", () => {
    expect(typeof Number()).toBe("number");
    expect(typeof new Number()).toBe("object");

    expect(Number()).toBe(0);
    expect(Number(123)).toBe(123);
    expect(Number(-123)).toBe(-123);
    expect(Number(123n)).toBe(123);
    expect(Number(-123n)).toBe(-123);
    expect(Number("1_23")).toBeNaN();
    expect(Number("00123")).toBe(123);
    expect(Number("123n")).toBeNaN();
    expect(Number("42")).toBe(42);
    expect(Number(null)).toBe(0);
    expect(Number(true)).toBe(1);
    expect(Number("Infinity")).toBe(Infinity);
    expect(Number("+Infinity")).toBe(Infinity);
    expect(Number("-Infinity")).toBe(-Infinity);
    expect(Number("infinity")).toBeNaN();
    expect(Number("-infinity")).toBeNaN();
    expect(Number("INFINITY")).toBeNaN();
    expect(Number("-INFINITY")).toBeNaN();
    expect(Number("inf")).toBeNaN();
    expect(Number(undefined)).toBeNaN();
    expect(Number({})).toBeNaN();
    expect(Number({ a: 1 })).toBeNaN();
    expect(Number([1, 2, 3])).toBeNaN();
    expect(Number("foo")).toBeNaN();
    expect(Number("10e10000")).toBe(Infinity);
    expect(Number("-10e10000")).toBe(-Infinity);
    expect(Number("0b1")).toBe(1);
    expect(Number("0B1")).toBe(1);
    expect(Number("0b01")).toBe(1);
    expect(Number("0b11")).toBe(3);
    expect(Number("0b")).toBeNaN();
    expect(Number("0B")).toBeNaN();
    expect(Number("-0b1")).toBeNaN();
    expect(Number("+0b1")).toBeNaN();
    expect(Number("0b1.1")).toBeNaN();
    expect(Number("0b1e10")).toBeNaN();
    expect(Number("0b1e+10")).toBeNaN();
    expect(Number("0b1e-10")).toBeNaN();
    expect(Number("0b1_1")).toBeNaN();
    expect(Number("0o7")).toBe(7);
    expect(Number("0O7")).toBe(7);
    expect(Number("0o07")).toBe(7);
    expect(Number("0o77")).toBe(63);
    expect(Number("0o")).toBeNaN();
    expect(Number("0O")).toBeNaN();
    expect(Number("-0o1")).toBeNaN();
    expect(Number("+0o1")).toBeNaN();
    expect(Number("0o1.1")).toBeNaN();
    expect(Number("0o1e10")).toBeNaN();
    expect(Number("0o1e+10")).toBeNaN();
    expect(Number("0o1e-10")).toBeNaN();
    expect(Number("0o1_1")).toBeNaN();
    expect(Number("0x1")).toBe(1);
    expect(Number("0X1")).toBe(1);
    expect(Number("0x01")).toBe(1);
    expect(Number("0x11")).toBe(17);
    expect(Number("0x")).toBeNaN();
    expect(Number("0X")).toBeNaN();
    expect(Number("-0x1")).toBeNaN();
    expect(Number("+0x1")).toBeNaN();
    expect(Number("0x1.1")).toBeNaN();
    expect(Number("0x1e10")).toBe(7696);
    expect(Number("0x1e+10")).toBeNaN();
    expect(Number("0x1e-10")).toBeNaN();
    expect(Number("0x1_1")).toBeNaN();
});

test("constructor with new", () => {
    expect(typeof new Number()).toBe("object");

    expect(new Number().valueOf()).toBe(0);
    expect(new Number(123).valueOf()).toBe(123);
    expect(new Number(-123).valueOf()).toBe(-123);
    expect(new Number(123n).valueOf()).toBe(123);
    expect(new Number(-123n).valueOf()).toBe(-123);
    expect(new Number("1_23").valueOf()).toBeNaN();
    expect(new Number("00123").valueOf()).toBe(123);
    expect(new Number("123n").valueOf()).toBeNaN();
    expect(new Number("42").valueOf()).toBe(42);
    expect(new Number(null).valueOf()).toBe(0);
    expect(new Number(true).valueOf()).toBe(1);
    expect(new Number("Infinity").valueOf()).toBe(Infinity);
    expect(new Number("+Infinity").valueOf()).toBe(Infinity);
    expect(new Number("-Infinity").valueOf()).toBe(-Infinity);
    expect(new Number("infinity").valueOf()).toBeNaN();
    expect(new Number("-infinity").valueOf()).toBeNaN();
    expect(new Number("INFINITY").valueOf()).toBeNaN();
    expect(new Number("-INFINITY").valueOf()).toBeNaN();
    expect(new Number("inf").valueOf()).toBeNaN();
    expect(new Number(undefined).valueOf()).toBeNaN();
    expect(new Number({}).valueOf()).toBeNaN();
    expect(new Number({ a: 1 }).valueOf()).toBeNaN();
    expect(new Number([1, 2, 3]).valueOf()).toBeNaN();
    expect(new Number("foo").valueOf()).toBeNaN();
    expect(new Number("10e10000").valueOf()).toBe(Infinity);
    expect(new Number("-10e10000").valueOf()).toBe(-Infinity);
    expect(new Number("0b1").valueOf()).toBe(1);
    expect(new Number("0B1").valueOf()).toBe(1);
    expect(new Number("0b01").valueOf()).toBe(1);
    expect(new Number("0b11").valueOf()).toBe(3);
    expect(new Number("0b").valueOf()).toBeNaN();
    expect(new Number("0B").valueOf()).toBeNaN();
    expect(new Number("-0b1").valueOf()).toBeNaN();
    expect(new Number("+0b1").valueOf()).toBeNaN();
    expect(new Number("0b1.1").valueOf()).toBeNaN();
    expect(new Number("0b1e10").valueOf()).toBeNaN();
    expect(new Number("0b1e+10").valueOf()).toBeNaN();
    expect(new Number("0b1e-10").valueOf()).toBeNaN();
    expect(new Number("0b1_1").valueOf()).toBeNaN();
    expect(new Number("0o7").valueOf()).toBe(7);
    expect(new Number("0O7").valueOf()).toBe(7);
    expect(new Number("0o07").valueOf()).toBe(7);
    expect(new Number("0o77").valueOf()).toBe(63);
    expect(new Number("0o").valueOf()).toBeNaN();
    expect(new Number("0O").valueOf()).toBeNaN();
    expect(new Number("-0o1").valueOf()).toBeNaN();
    expect(new Number("+0o1").valueOf()).toBeNaN();
    expect(new Number("0o1.1").valueOf()).toBeNaN();
    expect(new Number("0o1e7").valueOf()).toBeNaN();
    expect(new Number("0o1e+10").valueOf()).toBeNaN();
    expect(new Number("0o1e-10").valueOf()).toBeNaN();
    expect(new Number("0o1_1").valueOf()).toBeNaN();
    expect(new Number("0x1").valueOf()).toBe(1);
    expect(new Number("0X1").valueOf()).toBe(1);
    expect(new Number("0x01").valueOf()).toBe(1);
    expect(new Number("0x11").valueOf()).toBe(17);
    expect(new Number("0x").valueOf()).toBeNaN();
    expect(new Number("0X").valueOf()).toBeNaN();
    expect(new Number("-0x1").valueOf()).toBeNaN();
    expect(new Number("+0x1").valueOf()).toBeNaN();
    expect(new Number("0x1.1").valueOf()).toBeNaN();
    expect(new Number("0x1e10").valueOf()).toBe(7696);
    expect(new Number("0x1e+10").valueOf()).toBeNaN();
    expect(new Number("0x1e-10").valueOf()).toBeNaN();
    expect(new Number("0x1_1").valueOf()).toBeNaN();
});
