# AvogadroLibs CMake configuration file - http://www.openchemistry.org/

# If this file was found, then OpenQube has been found
set(AvogadroLibs_FOUND 1)

set(AvogadroLibs_VERSION_MAJOR   "1")
set(AvogadroLibs_VERSION_MINOR   "97")
set(AvogadroLibs_VERSION_PATCH   "0")
set(AvogadroLibs_VERSION         "${AvogadroLibs_VERSION_MAJOR}.${AvogadroLibs_VERSION_MINOR}.${AvogadroLibs_VERSION_PATCH}")

set(AvogadroLibs_INSTALL_PREFIX  "/usr")
set(AvogadroLibs_INCLUDE_DIRS    "${AvogadroLibs_INSTALL_PREFIX}/include")
set(AvogadroLibs_LIBRARY_DIR     "${AvogadroLibs_INSTALL_PREFIX}/lib")
set(AvogadroLibs_RUNTIME_DIR     "${AvogadroLibs_INSTALL_PREFIX}/bin")
set(AvogadroLibs_DATA_DIR        "${AvogadroLibs_INSTALL_PREFIX}/share")
set(AvogadroLibs_CMAKE_DIR       "${AvogadroLibs_LIBRARY_DIR}/cmake/avogadrolibs")

# List of target names that are plugins:
set(AvogadroLibs_PLUGINS         "")
set(AvogadroLibs_STATIC_PLUGINS  "ThreeDMol;ApplyColors;BondCentric;Bonding;Cartoons;CoordinateEditor;CopyPaste;Crystal;CrystalScene;CustomElements;Editor;FetchPDB;Focus;Hydrogens;ImportPQR;NucleicInput;InsertFragment;Label;LabelEditor;LammpsInput;LineFormatInput;Manipulator;MeasureTool;MolecularProperties;MongoChem;Navigator;NetworkDatabases;OpenBabel;OpenMMInput;PlayerTool;PropertyTables;POVRay;ResetView;Select;Selection;SpaceGroup;Surfaces;SVG;Spectra;VRML;PlotPdf;PlotRmsd;PlotXrd;ColorOpacityMap;apbs;Cp2kInput;GamessInput;commands;QuantumInput;ScriptFileFormats;ScriptCharges;PluginDownloader;Symmetry;SymmetryScene;BallStick;CloseContacts;Force;Licorice;Meshes;NonCovalent;VanDerWaals;VanDerWaalsAO;Wireframe;OverlayAxes")

if(NOT TARGET AvogadroCore)
  include("${AvogadroLibs_CMAKE_DIR}/AvogadroLibsTargets.cmake")
endif()
