/* tracker-dbus.c generated by valac 0.56.3, the Vala compiler
 * generated from tracker-dbus.vala, do not modify */

/*
 * Copyright (C) 2006, Jamie McCracken <jamiemcc@gnome.org>
 * Copyright (C) 2008-2011, Nokia <ivan.frade@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include "libtracker-common/tracker-common.h"
#include <gobject/gvaluecollector.h>

#define TRACKER_DBUS_SERVICE "org.freedesktop.Tracker1"
#define TRACKER_STATUS_PATH "/org/freedesktop/Tracker1/Status"
#define TRACKER_STATISTICS_PATH "/org/freedesktop/Tracker1/Statistics"
#define TRACKER_RESOURCES_PATH "/org/freedesktop/Tracker1/Resources"
#define TRACKER_STEROIDS_PATH "/org/freedesktop/Tracker1/Steroids"
#define TRACKER_BACKUP_PATH "/org/freedesktop/Tracker1/Backup"
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TRACKER_TYPE_DBUS (tracker_dbus_get_type ())
#define TRACKER_DBUS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_DBUS, TrackerDBus))
#define TRACKER_DBUS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_DBUS, TrackerDBusClass))
#define TRACKER_IS_DBUS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_DBUS))
#define TRACKER_IS_DBUS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_DBUS))
#define TRACKER_DBUS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_DBUS, TrackerDBusClass))

typedef struct _TrackerDBus TrackerDBus;
typedef struct _TrackerDBusClass TrackerDBusClass;
typedef struct _TrackerDBusPrivate TrackerDBusPrivate;

#define TRACKER_TYPE_STATISTICS (tracker_statistics_get_type ())
#define TRACKER_STATISTICS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_STATISTICS, TrackerStatistics))
#define TRACKER_STATISTICS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_STATISTICS, TrackerStatisticsClass))
#define TRACKER_IS_STATISTICS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_STATISTICS))
#define TRACKER_IS_STATISTICS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_STATISTICS))
#define TRACKER_STATISTICS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_STATISTICS, TrackerStatisticsClass))

typedef struct _TrackerStatistics TrackerStatistics;
typedef struct _TrackerStatisticsClass TrackerStatisticsClass;

#define TRACKER_TYPE_RESOURCES (tracker_resources_get_type ())
#define TRACKER_RESOURCES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_RESOURCES, TrackerResources))
#define TRACKER_RESOURCES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_RESOURCES, TrackerResourcesClass))
#define TRACKER_IS_RESOURCES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_RESOURCES))
#define TRACKER_IS_RESOURCES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_RESOURCES))
#define TRACKER_RESOURCES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_RESOURCES, TrackerResourcesClass))

typedef struct _TrackerResources TrackerResources;
typedef struct _TrackerResourcesClass TrackerResourcesClass;

#define TRACKER_TYPE_STEROIDS (tracker_steroids_get_type ())
#define TRACKER_STEROIDS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_STEROIDS, TrackerSteroids))
#define TRACKER_STEROIDS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_STEROIDS, TrackerSteroidsClass))
#define TRACKER_IS_STEROIDS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_STEROIDS))
#define TRACKER_IS_STEROIDS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_STEROIDS))
#define TRACKER_STEROIDS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_STEROIDS, TrackerSteroidsClass))

typedef struct _TrackerSteroids TrackerSteroids;
typedef struct _TrackerSteroidsClass TrackerSteroidsClass;

#define TRACKER_TYPE_STATUS (tracker_status_get_type ())
#define TRACKER_STATUS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_STATUS, TrackerStatus))
#define TRACKER_STATUS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_STATUS, TrackerStatusClass))
#define TRACKER_IS_STATUS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_STATUS))
#define TRACKER_IS_STATUS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_STATUS))
#define TRACKER_STATUS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_STATUS, TrackerStatusClass))

typedef struct _TrackerStatus TrackerStatus;
typedef struct _TrackerStatusClass TrackerStatusClass;

#define TRACKER_TYPE_BACKUP (tracker_backup_get_type ())
#define TRACKER_BACKUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_BACKUP, TrackerBackup))
#define TRACKER_BACKUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_BACKUP, TrackerBackupClass))
#define TRACKER_IS_BACKUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_BACKUP))
#define TRACKER_IS_BACKUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_BACKUP))
#define TRACKER_BACKUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_BACKUP, TrackerBackupClass))

typedef struct _TrackerBackup TrackerBackup;
typedef struct _TrackerBackupClass TrackerBackupClass;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _TrackerParamSpecDBus TrackerParamSpecDBus;

struct _TrackerDBus {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TrackerDBusPrivate * priv;
};

struct _TrackerDBusClass {
	GTypeClass parent_class;
	void (*finalize) (TrackerDBus *self);
};

struct _TrackerParamSpecDBus {
	GParamSpec parent_instance;
};

static gpointer tracker_dbus_parent_class = NULL;
static GDBusConnection* tracker_dbus_connection;
static GDBusConnection* tracker_dbus_connection = NULL;
static guint tracker_dbus_name_owner_changed_id;
static guint tracker_dbus_name_owner_changed_id = 0U;
static TrackerStatistics* tracker_dbus_statistics;
static TrackerStatistics* tracker_dbus_statistics = NULL;
static guint tracker_dbus_statistics_id;
static guint tracker_dbus_statistics_id = 0U;
static TrackerResources* tracker_dbus_resources;
static TrackerResources* tracker_dbus_resources = NULL;
static guint tracker_dbus_resources_id;
static guint tracker_dbus_resources_id = 0U;
static TrackerSteroids* tracker_dbus_steroids;
static TrackerSteroids* tracker_dbus_steroids = NULL;
static guint tracker_dbus_steroids_id;
static guint tracker_dbus_steroids_id = 0U;
static TrackerStatus* tracker_dbus_notifier;
static TrackerStatus* tracker_dbus_notifier = NULL;
static guint tracker_dbus_notifier_id;
static guint tracker_dbus_notifier_id = 0U;
static TrackerBackup* tracker_dbus_backup;
static TrackerBackup* tracker_dbus_backup = NULL;
static guint tracker_dbus_backup_id;
static guint tracker_dbus_backup_id = 0U;
static guint tracker_dbus_domain_watch_id;
static guint tracker_dbus_domain_watch_id = 0U;
static GMainLoop* tracker_dbus_watch_main_loop;
static GMainLoop* tracker_dbus_watch_main_loop = NULL;

VALA_EXTERN gpointer tracker_dbus_ref (gpointer instance);
VALA_EXTERN void tracker_dbus_unref (gpointer instance);
VALA_EXTERN GParamSpec* tracker_param_spec_dbus (const gchar* name,
                                     const gchar* nick,
                                     const gchar* blurb,
                                     GType object_type,
                                     GParamFlags flags);
VALA_EXTERN void tracker_value_set_dbus (GValue* value,
                             gpointer v_object);
VALA_EXTERN void tracker_value_take_dbus (GValue* value,
                              gpointer v_object);
VALA_EXTERN gpointer tracker_value_get_dbus (const GValue* value);
VALA_EXTERN GType tracker_dbus_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TrackerDBus, tracker_dbus_unref)
VALA_EXTERN GType tracker_statistics_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TrackerStatistics, g_object_unref)
VALA_EXTERN guint tracker_statistics_register_object (void* object,
                                          GDBusConnection* connection,
                                          const gchar* path,
                                          GError** error);
VALA_EXTERN GType tracker_resources_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TrackerResources, g_object_unref)
VALA_EXTERN guint tracker_resources_register_object (void* object,
                                         GDBusConnection* connection,
                                         const gchar* path,
                                         GError** error);
VALA_EXTERN GType tracker_steroids_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TrackerSteroids, g_object_unref)
VALA_EXTERN guint tracker_steroids_register_object (void* object,
                                        GDBusConnection* connection,
                                        const gchar* path,
                                        GError** error);
VALA_EXTERN GType tracker_status_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TrackerStatus, g_object_unref)
VALA_EXTERN guint tracker_status_register_object (void* object,
                                      GDBusConnection* connection,
                                      const gchar* path,
                                      GError** error);
VALA_EXTERN GType tracker_backup_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TrackerBackup, g_object_unref)
VALA_EXTERN guint tracker_backup_register_object (void* object,
                                      GDBusConnection* connection,
                                      const gchar* path,
                                      GError** error);
static gboolean tracker_dbus_dbus_register_service (const gchar* name);
static guint tracker_dbus_register_object (GType t_type,
                                    GBoxedCopyFunc t_dup_func,
                                    GDestroyNotify t_destroy_func,
                                    GDBusConnection* lconnection,
                                    gconstpointer object,
                                    const gchar* path);
static guint _vala_g_dbus_connection_register_object (GType type,
                                               void* object,
                                               GDBusConnection* connection,
                                               const gchar* path,
                                               GError** error);
VALA_EXTERN gboolean tracker_dbus_register_names (const gchar* domain);
VALA_EXTERN void tracker_dbus_on_domain_name_disappeared (GDBusConnection* connection,
                                              const gchar* name);
VALA_EXTERN void tracker_status_wait (TrackerStatus* self,
                          GAsyncReadyCallback _callback_,
                          gpointer _user_data_);
VALA_EXTERN void tracker_status_wait_finish (TrackerStatus* self,
                                 GAsyncResult* _res_,
                                 GError** error);
VALA_EXTERN void tracker_dbus_watch_domain (const gchar* domain,
                                GMainLoop* main_loop);
static void _tracker_dbus_on_domain_name_disappeared_gbus_name_vanished_callback (GDBusConnection* connection,
                                                                           const gchar* name,
                                                                           gpointer self);
VALA_EXTERN gboolean tracker_dbus_init (void);
static void tracker_dbus_name_owner_changed_cb (GDBusConnection* connection,
                                         const gchar* sender_name,
                                         const gchar* object_path,
                                         const gchar* interface_name,
                                         const gchar* signal_name,
                                         GVariant* parameters);
VALA_EXTERN void tracker_resources_unreg_batches (TrackerResources* self,
                                      const gchar* old_owner);
static void tracker_dbus_set_available (gboolean available);
VALA_EXTERN gboolean tracker_dbus_register_objects (void);
VALA_EXTERN void tracker_dbus_shutdown (void);
VALA_EXTERN TrackerStatus* tracker_dbus_register_notifier (void);
VALA_EXTERN TrackerStatus* tracker_status_new (void);
VALA_EXTERN TrackerStatus* tracker_status_construct (GType object_type);
VALA_EXTERN TrackerStatistics* tracker_statistics_new (void);
VALA_EXTERN TrackerStatistics* tracker_statistics_construct (GType object_type);
VALA_EXTERN TrackerResources* tracker_resources_new (GDBusConnection* connection);
VALA_EXTERN TrackerResources* tracker_resources_construct (GType object_type,
                                               GDBusConnection* connection);
static void _tracker_dbus_name_owner_changed_cb_gd_bus_signal_callback (GDBusConnection* connection,
                                                                 const gchar* sender_name,
                                                                 const gchar* object_path,
                                                                 const gchar* interface_name,
                                                                 const gchar* signal_name,
                                                                 GVariant* parameters,
                                                                 gpointer self);
VALA_EXTERN TrackerSteroids* tracker_steroids_new (void);
VALA_EXTERN TrackerSteroids* tracker_steroids_construct (GType object_type);
VALA_EXTERN TrackerBackup* tracker_backup_new (void);
VALA_EXTERN TrackerBackup* tracker_backup_construct (GType object_type);
VALA_EXTERN gboolean tracker_dbus_register_prepare_class_signal (void);
VALA_EXTERN void tracker_store_enable_signals (void);
VALA_EXTERN GObject* tracker_dbus_get_object (GType type);
VALA_EXTERN TrackerDBus* tracker_dbus_new (void);
VALA_EXTERN TrackerDBus* tracker_dbus_construct (GType object_type);
static void tracker_dbus_finalize (TrackerDBus * obj);
static GType tracker_dbus_get_type_once (void);

static gboolean
tracker_dbus_dbus_register_service (const gchar* name)
{
	gboolean _tmp9_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (name != NULL, FALSE);
	g_message ("Registering D-Bus service...\n  Name:'%s'", name);
	{
		GVariant* reply = NULL;
		GDBusConnection* _tmp0_;
		GVariant* _tmp1_;
		GVariant* _tmp2_;
		GVariant* _tmp3_;
		GVariant* _tmp4_;
		guint _result_ = 0U;
		GVariant* _tmp5_;
		guint _tmp6_ = 0U;
		_tmp0_ = tracker_dbus_connection;
		_tmp1_ = g_variant_new ("(su)", name, 1 << 2, NULL);
		g_variant_ref_sink (_tmp1_);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_dbus_connection_call_sync (_tmp0_, "org.freedesktop.DBus", "/org/freedesktop/DBus", "org.freedesktop.DBus", "RequestName", _tmp2_, (const GVariantType*) "(u)", 0, -1, NULL, &_inner_error0_);
		_tmp4_ = _tmp3_;
		_g_variant_unref0 (_tmp2_);
		reply = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp5_ = reply;
		g_variant_get (_tmp5_, "(u)", &_tmp6_, NULL);
		_result_ = _tmp6_;
		if (_result_ != ((guint) 1)) {
			g_critical ("D-Bus service name:'%s' is already taken, " "perhaps the daemon is already running?", name);
			result = FALSE;
			_g_variant_unref0 (reply);
			return result;
		}
		result = TRUE;
		_g_variant_unref0 (reply);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		g_critical ("Could not aquire name:'%s', %s", name, _tmp8_);
		result = FALSE;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp9_;
}

static guint
_vala_g_dbus_connection_register_object (GType type,
                                         void* object,
                                         GDBusConnection* connection,
                                         const gchar* path,
                                         GError** error)
{
	void *func;
	func = g_type_get_qdata (type, g_quark_from_static_string ("vala-dbus-register-object"));
	if (!func) {
		g_set_error_literal (error, G_IO_ERROR, G_IO_ERROR_FAILED, "The specified type does not support D-Bus registration");
		return 0;
	}
	return ((guint (*) (void *, GDBusConnection *, const gchar *, GError **)) func) (object, connection, path, error);
}

static guint
tracker_dbus_register_object (GType t_type,
                              GBoxedCopyFunc t_dup_func,
                              GDestroyNotify t_destroy_func,
                              GDBusConnection* lconnection,
                              gconstpointer object,
                              const gchar* path)
{
	const gchar* _tmp0_;
	guint _tmp4_ = 0U;
	GError* _inner_error0_ = NULL;
	guint result;
	g_return_val_if_fail (lconnection != NULL, 0U);
	g_return_val_if_fail (path != NULL, 0U);
	g_message ("Registering D-Bus object...");
	g_message ("  Path:'%s'", path);
	_tmp0_ = g_type_name (t_type);
	g_message ("  Type:'%s'", _tmp0_);
	{
		guint id = 0U;
		guint _tmp1_;
		_tmp1_ = _vala_g_dbus_connection_register_object (t_type, object, lconnection, path, &_inner_error0_);
		id = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		result = id;
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_critical ("Could not register D-Bus object: %s", _tmp3_);
		result = (guint) 0;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp4_;
}

gboolean
tracker_dbus_register_names (const gchar* domain)
{
	gchar* service_name = NULL;
	const gchar* _tmp2_;
	gboolean result;
	if (domain != NULL) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (domain);
		_g_free0 (service_name);
		service_name = _tmp0_;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup (TRACKER_DBUS_SERVICE);
		_g_free0 (service_name);
		service_name = _tmp1_;
	}
	_tmp2_ = service_name;
	result = tracker_dbus_dbus_register_service (_tmp2_);
	_g_free0 (service_name);
	return result;
}

void
tracker_dbus_on_domain_name_disappeared (GDBusConnection* connection,
                                         const gchar* name)
{
	TrackerStatus* _tmp0_;
	GMainLoop* _tmp1_;
	g_return_if_fail (connection != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = tracker_dbus_notifier;
	tracker_status_wait (_tmp0_, NULL, NULL);
	_tmp1_ = tracker_dbus_watch_main_loop;
	g_main_loop_quit (_tmp1_);
}

static gpointer
_g_main_loop_ref0 (gpointer self)
{
	return self ? g_main_loop_ref (self) : NULL;
}

static void
_tracker_dbus_on_domain_name_disappeared_gbus_name_vanished_callback (GDBusConnection* connection,
                                                                      const gchar* name,
                                                                      gpointer self)
{
	tracker_dbus_on_domain_name_disappeared (connection, name);
}

void
tracker_dbus_watch_domain (const gchar* domain,
                           GMainLoop* main_loop)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (main_loop != NULL);
	if (tracker_dbus_domain_watch_id == ((guint) 0)) {
		_tmp0_ = domain != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GMainLoop* _tmp1_;
		GDBusConnection* _tmp2_;
		_tmp1_ = _g_main_loop_ref0 (main_loop);
		_g_main_loop_unref0 (tracker_dbus_watch_main_loop);
		tracker_dbus_watch_main_loop = _tmp1_;
		_tmp2_ = tracker_dbus_connection;
		tracker_dbus_domain_watch_id = g_bus_watch_name_on_connection_with_closures (_tmp2_, domain, G_BUS_NAME_WATCHER_FLAGS_NONE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) g_cclosure_new ((GCallback) _tracker_dbus_on_domain_name_disappeared_gbus_name_vanished_callback, NULL, (GClosureNotify) NULL));
	}
}

gboolean
tracker_dbus_init (void)
{
	GDBusConnection* _tmp0_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	_tmp0_ = tracker_dbus_connection;
	if (_tmp0_ != NULL) {
		result = TRUE;
		return result;
	}
	{
		GDBusConnection* _tmp1_ = NULL;
		GDBusConnection* _tmp2_;
		GDBusConnection* _tmp3_;
		_tmp2_ = g_bus_get_sync (tracker_ipc_bus (), NULL, &_inner_error0_);
		_tmp1_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp1_;
		_tmp1_ = NULL;
		_g_object_unref0 (tracker_dbus_connection);
		tracker_dbus_connection = _tmp3_;
		_g_object_unref0 (_tmp1_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_critical ("Could not connect to the D-Bus session bus, %s", _tmp5_);
		result = FALSE;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp6_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp6_;
	}
	result = TRUE;
	return result;
}

static void
tracker_dbus_name_owner_changed_cb (GDBusConnection* connection,
                                    const gchar* sender_name,
                                    const gchar* object_path,
                                    const gchar* interface_name,
                                    const gchar* signal_name,
                                    GVariant* parameters)
{
	const gchar* name = NULL;
	const gchar* old_owner = NULL;
	const gchar* new_owner = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_;
	g_return_if_fail (connection != NULL);
	g_return_if_fail (object_path != NULL);
	g_return_if_fail (interface_name != NULL);
	g_return_if_fail (signal_name != NULL);
	g_return_if_fail (parameters != NULL);
	g_variant_get (parameters, "(&s&s&s)", &_tmp0_, &_tmp1_, &_tmp2_, NULL);
	name = _tmp0_;
	old_owner = _tmp1_;
	new_owner = _tmp2_;
	_tmp4_ = old_owner;
	if (g_strcmp0 (_tmp4_, "") != 0) {
		const gchar* _tmp5_;
		_tmp5_ = new_owner;
		_tmp3_ = g_strcmp0 (_tmp5_, "") == 0;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		TrackerResources* _tmp6_;
		const gchar* _tmp7_;
		_tmp6_ = tracker_dbus_resources;
		_tmp7_ = old_owner;
		tracker_resources_unreg_batches (_tmp6_, _tmp7_);
	}
}

static void
tracker_dbus_set_available (gboolean available)
{
	if (available) {
		if (tracker_dbus_resources_id == ((guint) 0)) {
			tracker_dbus_register_objects ();
		}
	} else {
		if (tracker_dbus_resources_id != ((guint) 0)) {
			GDBusConnection* _tmp0_;
			GDBusConnection* _tmp1_;
			GDBusConnection* _tmp2_;
			_tmp0_ = tracker_dbus_connection;
			g_dbus_connection_signal_unsubscribe (_tmp0_, tracker_dbus_name_owner_changed_id);
			tracker_dbus_name_owner_changed_id = (guint) 0;
			_tmp1_ = tracker_dbus_connection;
			g_dbus_connection_unregister_object (_tmp1_, tracker_dbus_resources_id);
			_g_object_unref0 (tracker_dbus_resources);
			tracker_dbus_resources = NULL;
			tracker_dbus_resources_id = (guint) 0;
			_tmp2_ = tracker_dbus_connection;
			g_dbus_connection_unregister_object (_tmp2_, tracker_dbus_steroids_id);
			_g_object_unref0 (tracker_dbus_steroids);
			tracker_dbus_steroids = NULL;
			tracker_dbus_steroids_id = (guint) 0;
		}
	}
}

void
tracker_dbus_shutdown (void)
{
	TrackerBackup* _tmp0_;
	TrackerStatus* _tmp2_;
	tracker_dbus_set_available (FALSE);
	_tmp0_ = tracker_dbus_backup;
	if (_tmp0_ != NULL) {
		GDBusConnection* _tmp1_;
		_tmp1_ = tracker_dbus_connection;
		g_dbus_connection_unregister_object (_tmp1_, tracker_dbus_backup_id);
		_g_object_unref0 (tracker_dbus_backup);
		tracker_dbus_backup = NULL;
		tracker_dbus_backup_id = (guint) 0;
	}
	_tmp2_ = tracker_dbus_notifier;
	if (_tmp2_ != NULL) {
		GDBusConnection* _tmp3_;
		_tmp3_ = tracker_dbus_connection;
		g_dbus_connection_unregister_object (_tmp3_, tracker_dbus_notifier_id);
		_g_object_unref0 (tracker_dbus_notifier);
		tracker_dbus_notifier = NULL;
		tracker_dbus_notifier_id = (guint) 0;
	}
	if (tracker_dbus_domain_watch_id != ((guint) 0)) {
		g_bus_unwatch_name (tracker_dbus_domain_watch_id);
		tracker_dbus_domain_watch_id = (guint) 0;
	}
	_g_object_unref0 (tracker_dbus_connection);
	tracker_dbus_connection = NULL;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

TrackerStatus*
tracker_dbus_register_notifier (void)
{
	GDBusConnection* _tmp0_;
	TrackerStatus* _tmp1_;
	TrackerStatus* _tmp2_;
	GDBusConnection* _tmp3_;
	TrackerStatus* _tmp4_;
	TrackerStatus* _tmp5_;
	TrackerStatus* _tmp6_;
	TrackerStatus* result;
	_tmp0_ = tracker_dbus_connection;
	if (_tmp0_ == NULL) {
		g_critical ("D-Bus support must be initialized before registering objects!");
		result = NULL;
		return result;
	}
	_tmp1_ = tracker_status_new ();
	_g_object_unref0 (tracker_dbus_notifier);
	tracker_dbus_notifier = _tmp1_;
	_tmp2_ = tracker_dbus_notifier;
	if (_tmp2_ == NULL) {
		g_critical ("Could not create TrackerStatus object to register");
		result = NULL;
		return result;
	}
	_tmp3_ = tracker_dbus_connection;
	_tmp4_ = tracker_dbus_notifier;
	tracker_dbus_notifier_id = tracker_dbus_register_object (TRACKER_TYPE_STATUS, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp3_, _tmp4_, TRACKER_STATUS_PATH);
	_tmp5_ = tracker_dbus_notifier;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	result = _tmp6_;
	return result;
}

static void
_tracker_dbus_name_owner_changed_cb_gd_bus_signal_callback (GDBusConnection* connection,
                                                            const gchar* sender_name,
                                                            const gchar* object_path,
                                                            const gchar* interface_name,
                                                            const gchar* signal_name,
                                                            GVariant* parameters,
                                                            gpointer self)
{
	tracker_dbus_name_owner_changed_cb (connection, sender_name, object_path, interface_name, signal_name, parameters);
}

gboolean
tracker_dbus_register_objects (void)
{
	GDBusConnection* _tmp0_;
	TrackerStatistics* _tmp1_;
	TrackerStatistics* _tmp2_;
	GDBusConnection* _tmp3_;
	TrackerStatistics* _tmp4_;
	GDBusConnection* _tmp5_;
	TrackerResources* _tmp6_;
	TrackerResources* _tmp7_;
	GDBusConnection* _tmp8_;
	GDBusConnection* _tmp9_;
	TrackerResources* _tmp10_;
	TrackerSteroids* _tmp11_;
	TrackerSteroids* _tmp12_;
	GDBusConnection* _tmp13_;
	TrackerSteroids* _tmp14_;
	TrackerBackup* _tmp15_;
	gboolean result;
	_tmp0_ = tracker_dbus_connection;
	if (_tmp0_ == NULL) {
		g_critical ("D-Bus support must be initialized before registering objects!");
		result = FALSE;
		return result;
	}
	_tmp1_ = tracker_statistics_new ();
	_g_object_unref0 (tracker_dbus_statistics);
	tracker_dbus_statistics = _tmp1_;
	_tmp2_ = tracker_dbus_statistics;
	if (_tmp2_ == NULL) {
		g_critical ("Could not create TrackerStatistics object to register");
		result = FALSE;
		return result;
	}
	_tmp3_ = tracker_dbus_connection;
	_tmp4_ = tracker_dbus_statistics;
	tracker_dbus_statistics_id = tracker_dbus_register_object (TRACKER_TYPE_STATISTICS, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp3_, _tmp4_, TRACKER_STATISTICS_PATH);
	_tmp5_ = tracker_dbus_connection;
	_tmp6_ = tracker_resources_new (_tmp5_);
	_g_object_unref0 (tracker_dbus_resources);
	tracker_dbus_resources = _tmp6_;
	_tmp7_ = tracker_dbus_resources;
	if (_tmp7_ == NULL) {
		g_critical ("Could not create TrackerResources object to register");
		result = FALSE;
		return result;
	}
	_tmp8_ = tracker_dbus_connection;
	tracker_dbus_name_owner_changed_id = g_dbus_connection_signal_subscribe (_tmp8_, "org.freedesktop.DBus", "org.freedesktop.DBus", "NameOwnerChanged", "/org/freedesktop/DBus", NULL, 0, _tracker_dbus_name_owner_changed_cb_gd_bus_signal_callback, NULL, NULL);
	_tmp9_ = tracker_dbus_connection;
	_tmp10_ = tracker_dbus_resources;
	tracker_dbus_resources_id = tracker_dbus_register_object (TRACKER_TYPE_RESOURCES, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp9_, _tmp10_, TRACKER_RESOURCES_PATH);
	_tmp11_ = tracker_steroids_new ();
	_g_object_unref0 (tracker_dbus_steroids);
	tracker_dbus_steroids = _tmp11_;
	_tmp12_ = tracker_dbus_steroids;
	if (_tmp12_ == NULL) {
		g_critical ("Could not create TrackerSteroids object to register");
		result = FALSE;
		return result;
	}
	_tmp13_ = tracker_dbus_connection;
	_tmp14_ = tracker_dbus_steroids;
	tracker_dbus_steroids_id = tracker_dbus_register_object (TRACKER_TYPE_STEROIDS, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp13_, _tmp14_, TRACKER_STEROIDS_PATH);
	_tmp15_ = tracker_dbus_backup;
	if (_tmp15_ == NULL) {
		TrackerBackup* _tmp16_;
		TrackerBackup* _tmp17_;
		GDBusConnection* _tmp18_;
		TrackerBackup* _tmp19_;
		_tmp16_ = tracker_backup_new ();
		_g_object_unref0 (tracker_dbus_backup);
		tracker_dbus_backup = _tmp16_;
		_tmp17_ = tracker_dbus_backup;
		if (_tmp17_ == NULL) {
			g_critical ("Could not create TrackerBackup object to register");
			result = FALSE;
			return result;
		}
		_tmp18_ = tracker_dbus_connection;
		_tmp19_ = tracker_dbus_backup;
		tracker_dbus_backup_id = tracker_dbus_register_object (TRACKER_TYPE_BACKUP, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp18_, _tmp19_, TRACKER_BACKUP_PATH);
	}
	result = TRUE;
	return result;
}

gboolean
tracker_dbus_register_prepare_class_signal (void)
{
	TrackerResources* _tmp0_;
	gboolean result;
	_tmp0_ = tracker_dbus_resources;
	if (_tmp0_ == NULL) {
		g_message ("Error during initialization, Resources DBus object not available");
		result = FALSE;
		return result;
	}
	tracker_store_enable_signals ();
	result = TRUE;
	return result;
}

GObject*
tracker_dbus_get_object (GType type)
{
	GObject* result;
	if (type == TRACKER_TYPE_RESOURCES) {
		TrackerResources* _tmp0_;
		GObject* _tmp1_;
		_tmp0_ = tracker_dbus_resources;
		_tmp1_ = _g_object_ref0 ((GObject*) _tmp0_);
		result = _tmp1_;
		return result;
	}
	if (type == TRACKER_TYPE_STEROIDS) {
		TrackerSteroids* _tmp2_;
		GObject* _tmp3_;
		_tmp2_ = tracker_dbus_steroids;
		_tmp3_ = _g_object_ref0 ((GObject*) _tmp2_);
		result = _tmp3_;
		return result;
	}
	if (type == TRACKER_TYPE_STATUS) {
		TrackerStatus* _tmp4_;
		GObject* _tmp5_;
		_tmp4_ = tracker_dbus_notifier;
		_tmp5_ = _g_object_ref0 ((GObject*) _tmp4_);
		result = _tmp5_;
		return result;
	}
	if (type == TRACKER_TYPE_BACKUP) {
		TrackerBackup* _tmp6_;
		GObject* _tmp7_;
		_tmp6_ = tracker_dbus_backup;
		_tmp7_ = _g_object_ref0 ((GObject*) _tmp6_);
		result = _tmp7_;
		return result;
	}
	result = NULL;
	return result;
}

TrackerDBus*
tracker_dbus_construct (GType object_type)
{
	TrackerDBus* self = NULL;
	self = (TrackerDBus*) g_type_create_instance (object_type);
	return self;
}

TrackerDBus*
tracker_dbus_new (void)
{
	return tracker_dbus_construct (TRACKER_TYPE_DBUS);
}

static void
tracker_value_dbus_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
tracker_value_dbus_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		tracker_dbus_unref (value->data[0].v_pointer);
	}
}

static void
tracker_value_dbus_copy_value (const GValue* src_value,
                               GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = tracker_dbus_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
tracker_value_dbus_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
tracker_value_dbus_collect_value (GValue* value,
                                  guint n_collect_values,
                                  GTypeCValue* collect_values,
                                  guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		TrackerDBus * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = tracker_dbus_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
tracker_value_dbus_lcopy_value (const GValue* value,
                                guint n_collect_values,
                                GTypeCValue* collect_values,
                                guint collect_flags)
{
	TrackerDBus ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = tracker_dbus_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
tracker_param_spec_dbus (const gchar* name,
                         const gchar* nick,
                         const gchar* blurb,
                         GType object_type,
                         GParamFlags flags)
{
	TrackerParamSpecDBus* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TRACKER_TYPE_DBUS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
tracker_value_get_dbus (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_TYPE_DBUS), NULL);
	return value->data[0].v_pointer;
}

void
tracker_value_set_dbus (GValue* value,
                        gpointer v_object)
{
	TrackerDBus * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_TYPE_DBUS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_TYPE_DBUS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		tracker_dbus_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		tracker_dbus_unref (old);
	}
}

void
tracker_value_take_dbus (GValue* value,
                         gpointer v_object)
{
	TrackerDBus * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_TYPE_DBUS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_TYPE_DBUS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		tracker_dbus_unref (old);
	}
}

static void
tracker_dbus_class_init (TrackerDBusClass * klass,
                         gpointer klass_data)
{
	tracker_dbus_parent_class = g_type_class_peek_parent (klass);
	((TrackerDBusClass *) klass)->finalize = tracker_dbus_finalize;
}

static void
tracker_dbus_instance_init (TrackerDBus * self,
                            gpointer klass)
{
	self->ref_count = 1;
}

static void
tracker_dbus_finalize (TrackerDBus * obj)
{
	TrackerDBus * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_TYPE_DBUS, TrackerDBus);
	g_signal_handlers_destroy (self);
}

static GType
tracker_dbus_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { tracker_value_dbus_init, tracker_value_dbus_free_value, tracker_value_dbus_copy_value, tracker_value_dbus_peek_pointer, "p", tracker_value_dbus_collect_value, "p", tracker_value_dbus_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (TrackerDBusClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_dbus_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerDBus), 0, (GInstanceInitFunc) tracker_dbus_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType tracker_dbus_type_id;
	tracker_dbus_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TrackerDBus", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return tracker_dbus_type_id;
}

GType
tracker_dbus_get_type (void)
{
	static volatile gsize tracker_dbus_type_id__once = 0;
	if (g_once_init_enter (&tracker_dbus_type_id__once)) {
		GType tracker_dbus_type_id;
		tracker_dbus_type_id = tracker_dbus_get_type_once ();
		g_once_init_leave (&tracker_dbus_type_id__once, tracker_dbus_type_id);
	}
	return tracker_dbus_type_id__once;
}

gpointer
tracker_dbus_ref (gpointer instance)
{
	TrackerDBus * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
tracker_dbus_unref (gpointer instance)
{
	TrackerDBus * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		TRACKER_DBUS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

