/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ssi;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.connector.Request;
import org.apache.catalina.ssi.ByteArrayServletOutputStream;
import org.apache.catalina.ssi.ResponseIncludeWrapper;
import org.apache.catalina.ssi.SSIExternalResolver;
import org.apache.catalina.ssi.SSIServletRequestUtil;
import org.apache.coyote.Constants;
import org.apache.tomcat.util.buf.B2CConverter;
import org.apache.tomcat.util.buf.UDecoder;
import org.apache.tomcat.util.http.RequestUtil;

public class SSIServletExternalResolver
implements SSIExternalResolver {
    protected final String[] VARIABLE_NAMES = new String[]{"AUTH_TYPE", "CONTENT_LENGTH", "CONTENT_TYPE", "DOCUMENT_NAME", "DOCUMENT_URI", "GATEWAY_INTERFACE", "HTTP_ACCEPT", "HTTP_ACCEPT_ENCODING", "HTTP_ACCEPT_LANGUAGE", "HTTP_CONNECTION", "HTTP_HOST", "HTTP_REFERER", "HTTP_USER_AGENT", "PATH_INFO", "PATH_TRANSLATED", "QUERY_STRING", "QUERY_STRING_UNESCAPED", "REMOTE_ADDR", "REMOTE_HOST", "REMOTE_PORT", "REMOTE_USER", "REQUEST_METHOD", "REQUEST_URI", "SCRIPT_FILENAME", "SCRIPT_NAME", "SERVER_ADDR", "SERVER_NAME", "SERVER_PORT", "SERVER_PROTOCOL", "SERVER_SOFTWARE", "UNIQUE_ID"};
    protected final ServletContext context;
    protected final HttpServletRequest req;
    protected final HttpServletResponse res;
    protected final boolean isVirtualWebappRelative;
    protected final int debug;
    protected final String inputEncoding;

    public SSIServletExternalResolver(ServletContext servletContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, boolean bl, int n, String string) {
        this.context = servletContext;
        this.req = httpServletRequest;
        this.res = httpServletResponse;
        this.isVirtualWebappRelative = bl;
        this.debug = n;
        this.inputEncoding = string;
    }

    @Override
    public void log(String string, Throwable throwable) {
        if (throwable != null) {
            this.context.log(string, throwable);
        } else {
            this.context.log(string);
        }
    }

    @Override
    public void addVariableNames(Collection<String> collection) {
        for (String string : this.VARIABLE_NAMES) {
            String string2 = this.getVariableValue(string);
            if (string2 == null) continue;
            collection.add(string);
        }
        Enumeration enumeration = this.req.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (this.isNameReserved(string)) continue;
            collection.add(string);
        }
    }

    protected Object getReqAttributeIgnoreCase(String string) {
        Object object;
        block1: {
            String string2;
            object = null;
            if (this.isNameReserved(string) || (object = this.req.getAttribute(string)) != null) break block1;
            Enumeration enumeration = this.req.getAttributeNames();
            while (enumeration.hasMoreElements() && (!string.equalsIgnoreCase(string2 = (String)enumeration.nextElement()) || this.isNameReserved(string2) || (object = this.req.getAttribute(string2)) == null)) {
            }
        }
        return object;
    }

    protected boolean isNameReserved(String string) {
        return string.startsWith("java.") || string.startsWith("javax.") || string.startsWith("sun.");
    }

    @Override
    public void setVariableValue(String string, String string2) {
        if (!this.isNameReserved(string)) {
            this.req.setAttribute(string, (Object)string2);
        }
    }

    @Override
    public String getVariableValue(String string) {
        String string2 = null;
        Object object = this.getReqAttributeIgnoreCase(string);
        string2 = object != null ? object.toString() : this.getCGIVariable(string);
        return string2;
    }

    protected String getCGIVariable(String string) {
        String string2 = null;
        String[] stringArray = string.toUpperCase(Locale.ENGLISH).split("_");
        int n = 2;
        if (stringArray.length == 1) {
            if (stringArray[0].equals("PATH")) {
                n = 1;
            }
        } else if (stringArray[0].equals("AUTH")) {
            if (stringArray[1].equals("TYPE")) {
                string2 = this.req.getAuthType();
            }
        } else if (stringArray[0].equals("CONTENT")) {
            if (stringArray[1].equals("LENGTH")) {
                long l = this.req.getContentLengthLong();
                if (l >= 0L) {
                    string2 = Long.toString(l);
                }
            } else if (stringArray[1].equals("TYPE")) {
                string2 = this.req.getContentType();
            }
        } else if (stringArray[0].equals("DOCUMENT")) {
            if (stringArray[1].equals("NAME")) {
                String string3 = this.req.getRequestURI();
                string2 = string3.substring(string3.lastIndexOf(47) + 1);
            } else if (stringArray[1].equals("URI")) {
                string2 = this.req.getRequestURI();
            }
        } else if (string.equalsIgnoreCase("GATEWAY_INTERFACE")) {
            string2 = "CGI/1.1";
        } else if (stringArray[0].equals("HTTP")) {
            if (stringArray[1].equals("ACCEPT")) {
                Enumeration enumeration;
                String string4 = null;
                if (stringArray.length == 2) {
                    string4 = "Accept";
                } else if (stringArray[2].equals("ENCODING")) {
                    n = 3;
                    string4 = "Accept-Encoding";
                } else if (stringArray[2].equals("LANGUAGE")) {
                    n = 3;
                    string4 = "Accept-Language";
                }
                if (string4 != null && (enumeration = this.req.getHeaders(string4)) != null && enumeration.hasMoreElements()) {
                    StringBuilder stringBuilder = new StringBuilder((String)enumeration.nextElement());
                    while (enumeration.hasMoreElements()) {
                        stringBuilder.append(", ");
                        stringBuilder.append((String)enumeration.nextElement());
                    }
                    string2 = stringBuilder.toString();
                }
            } else if (stringArray[1].equals("CONNECTION")) {
                string2 = this.req.getHeader("Connection");
            } else if (stringArray[1].equals("HOST")) {
                string2 = this.req.getHeader("Host");
            } else if (stringArray[1].equals("REFERER")) {
                string2 = this.req.getHeader("Referer");
            } else if (stringArray[1].equals("USER") && stringArray.length == 3 && stringArray[2].equals("AGENT")) {
                n = 3;
                string2 = this.req.getHeader("User-Agent");
            }
        } else if (stringArray[0].equals("PATH")) {
            if (stringArray[1].equals("INFO")) {
                string2 = this.req.getPathInfo();
            } else if (stringArray[1].equals("TRANSLATED")) {
                string2 = this.req.getPathTranslated();
            }
        } else if (stringArray[0].equals("QUERY")) {
            if (stringArray[1].equals("STRING")) {
                String string5 = this.req.getQueryString();
                if (stringArray.length == 2) {
                    string2 = this.nullToEmptyString(string5);
                } else if (stringArray[2].equals("UNESCAPED")) {
                    n = 3;
                    if (string5 != null) {
                        Object object;
                        Charset charset = null;
                        Charset charset2 = null;
                        boolean bl = false;
                        if (this.req instanceof Request) {
                            try {
                                charset2 = ((Request)this.req).getCoyoteRequest().getCharset();
                            }
                            catch (UnsupportedEncodingException unsupportedEncodingException) {
                                // empty catch block
                            }
                            object = ((Request)this.req).getConnector();
                            charset = ((Connector)object).getURICharset();
                            bl = ((Connector)object).getUseBodyEncodingForURI();
                        }
                        object = bl && charset2 != null ? charset2 : (charset != null ? charset : Constants.DEFAULT_URI_CHARSET);
                        string2 = UDecoder.URLDecode((String)string5, (Charset)object);
                    }
                }
            }
        } else if (stringArray[0].equals("REMOTE")) {
            if (stringArray[1].equals("ADDR")) {
                string2 = this.req.getRemoteAddr();
            } else if (stringArray[1].equals("HOST")) {
                string2 = this.req.getRemoteHost();
            } else if (!stringArray[1].equals("IDENT")) {
                if (stringArray[1].equals("PORT")) {
                    string2 = Integer.toString(this.req.getRemotePort());
                } else if (stringArray[1].equals("USER")) {
                    string2 = this.req.getRemoteUser();
                }
            }
        } else if (stringArray[0].equals("REQUEST")) {
            if (stringArray[1].equals("METHOD")) {
                string2 = this.req.getMethod();
            } else if (stringArray[1].equals("URI") && (string2 = (String)this.req.getAttribute("javax.servlet.forward.request_uri")) == null) {
                string2 = this.req.getRequestURI();
            }
        } else if (stringArray[0].equals("SCRIPT")) {
            String string6 = this.req.getServletPath();
            if (stringArray[1].equals("FILENAME")) {
                string2 = this.context.getRealPath(string6);
            } else if (stringArray[1].equals("NAME")) {
                string2 = string6;
            }
        } else if (stringArray[0].equals("SERVER")) {
            if (stringArray[1].equals("ADDR")) {
                string2 = this.req.getLocalAddr();
            }
            if (stringArray[1].equals("NAME")) {
                string2 = this.req.getServerName();
            } else if (stringArray[1].equals("PORT")) {
                string2 = Integer.toString(this.req.getServerPort());
            } else if (stringArray[1].equals("PROTOCOL")) {
                string2 = this.req.getProtocol();
            } else if (stringArray[1].equals("SOFTWARE")) {
                StringBuilder stringBuilder = new StringBuilder(this.context.getServerInfo());
                stringBuilder.append(' ');
                stringBuilder.append(System.getProperty("java.vm.name"));
                stringBuilder.append('/');
                stringBuilder.append(System.getProperty("java.vm.version"));
                stringBuilder.append(' ');
                stringBuilder.append(System.getProperty("os.name"));
                string2 = stringBuilder.toString();
            }
        } else if (string.equalsIgnoreCase("UNIQUE_ID")) {
            string2 = this.req.getRequestedSessionId();
        }
        if (n != stringArray.length) {
            return null;
        }
        return string2;
    }

    @Override
    public Date getCurrentDate() {
        return new Date();
    }

    protected String nullToEmptyString(String string) {
        String string2 = string;
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    protected String getPathWithoutFileName(String string) {
        String string2 = null;
        int n = string.lastIndexOf(47);
        if (n >= 0) {
            string2 = string.substring(0, n + 1);
        }
        return string2;
    }

    protected String getPathWithoutContext(String string, String string2) {
        if (string2.startsWith(string)) {
            return string2.substring(string.length());
        }
        return string2;
    }

    protected String getAbsolutePath(String string) throws IOException {
        String string2 = SSIServletRequestUtil.getRelativePath(this.req);
        String string3 = this.getPathWithoutFileName(string2);
        if (string3 == null) {
            throw new IOException("Couldn't remove filename from path: " + string2);
        }
        String string4 = string3 + string;
        String string5 = RequestUtil.normalize((String)string4);
        if (string5 == null) {
            throw new IOException("Normalization yielded null on path: " + string4);
        }
        return string5;
    }

    protected ServletContextAndPath getServletContextAndPathFromNonVirtualPath(String string) throws IOException {
        if (string.startsWith("/") || string.startsWith("\\")) {
            throw new IOException("A non-virtual path can't be absolute: " + string);
        }
        if (string.indexOf("../") >= 0) {
            throw new IOException("A non-virtual path can't contain '../' : " + string);
        }
        String string2 = this.getAbsolutePath(string);
        ServletContextAndPath servletContextAndPath = new ServletContextAndPath(this.context, string2);
        return servletContextAndPath;
    }

    protected ServletContextAndPath getServletContextAndPathFromVirtualPath(String string) throws IOException {
        if (!string.startsWith("/") && !string.startsWith("\\")) {
            return new ServletContextAndPath(this.context, this.getAbsolutePath(string));
        }
        String string2 = RequestUtil.normalize((String)string);
        if (this.isVirtualWebappRelative) {
            return new ServletContextAndPath(this.context, string2);
        }
        ServletContext servletContext = this.context.getContext(string2);
        if (servletContext == null) {
            throw new IOException("Couldn't get context for path: " + string2);
        }
        if (!this.isRootContext(servletContext)) {
            String string3 = this.getPathWithoutContext(servletContext.getContextPath(), string2);
            if (string3 == null) {
                throw new IOException("Couldn't remove context from path: " + string2);
            }
            return new ServletContextAndPath(servletContext, string3);
        }
        return new ServletContextAndPath(servletContext, string2);
    }

    protected boolean isRootContext(ServletContext servletContext) {
        return servletContext == servletContext.getContext("/");
    }

    protected ServletContextAndPath getServletContextAndPath(String string, boolean bl) throws IOException {
        ServletContextAndPath servletContextAndPath = null;
        if (this.debug > 0) {
            this.log("SSIServletExternalResolver.getServletContextAndPath( " + string + ", " + bl + ")", null);
        }
        servletContextAndPath = bl ? this.getServletContextAndPathFromVirtualPath(string) : this.getServletContextAndPathFromNonVirtualPath(string);
        return servletContextAndPath;
    }

    protected URLConnection getURLConnection(String string, boolean bl) throws IOException {
        String string2;
        ServletContextAndPath servletContextAndPath = this.getServletContextAndPath(string, bl);
        ServletContext servletContext = servletContextAndPath.getServletContext();
        URL uRL = servletContext.getResource(string2 = servletContextAndPath.getPath());
        if (uRL == null) {
            throw new IOException("Context did not contain resource: " + string2);
        }
        URLConnection uRLConnection = uRL.openConnection();
        return uRLConnection;
    }

    @Override
    public long getFileLastModified(String string, boolean bl) throws IOException {
        long l = 0L;
        try {
            URLConnection uRLConnection = this.getURLConnection(string, bl);
            l = uRLConnection.getLastModified();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return l;
    }

    @Override
    public long getFileSize(String string, boolean bl) throws IOException {
        long l = -1L;
        try {
            URLConnection uRLConnection = this.getURLConnection(string, bl);
            l = uRLConnection.getContentLengthLong();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return l;
    }

    @Override
    public String getFileText(String string, boolean bl) throws IOException {
        try {
            ServletContextAndPath servletContextAndPath = this.getServletContextAndPath(string, bl);
            ServletContext servletContext = servletContextAndPath.getServletContext();
            String string2 = servletContextAndPath.getPath();
            RequestDispatcher requestDispatcher = servletContext.getRequestDispatcher(string2);
            if (requestDispatcher == null) {
                throw new IOException("Couldn't get request dispatcher for path: " + string2);
            }
            ByteArrayServletOutputStream byteArrayServletOutputStream = new ByteArrayServletOutputStream();
            ResponseIncludeWrapper responseIncludeWrapper = new ResponseIncludeWrapper(this.res, byteArrayServletOutputStream);
            requestDispatcher.include((ServletRequest)this.req, (ServletResponse)responseIncludeWrapper);
            responseIncludeWrapper.flushOutputStreamOrWriter();
            byte[] byArray = byteArrayServletOutputStream.toByteArray();
            String string3 = this.inputEncoding == null ? new String(byArray) : new String(byArray, B2CConverter.getCharset((String)this.inputEncoding));
            if (string3.equals("") && !this.req.getMethod().equalsIgnoreCase("HEAD")) {
                throw new IOException("Couldn't find file: " + string2);
            }
            return string3;
        }
        catch (ServletException servletException) {
            throw new IOException("Couldn't include file: " + string + " because of ServletException: " + servletException.getMessage());
        }
    }

    protected static class ServletContextAndPath {
        protected final ServletContext servletContext;
        protected final String path;

        public ServletContextAndPath(ServletContext servletContext, String string) {
            this.servletContext = servletContext;
            this.path = string;
        }

        public ServletContext getServletContext() {
            return this.servletContext;
        }

        public String getPath() {
            return this.path;
        }
    }
}

