/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.AlgorithmConstraints;
import java.security.GeneralSecurityException;
import javax.crypto.BadPaddingException;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.SSLSession;
import sun.security.ssl.Alerts;
import sun.security.ssl.CipherBox;
import sun.security.ssl.CipherSuiteList;
import sun.security.ssl.ClientHandshaker;
import sun.security.ssl.Debug;
import sun.security.ssl.EngineArgs;
import sun.security.ssl.EngineInputRecord;
import sun.security.ssl.EngineOutputRecord;
import sun.security.ssl.EngineWriter;
import sun.security.ssl.Handshaker;
import sun.security.ssl.MAC;
import sun.security.ssl.ProtocolList;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.Record;
import sun.security.ssl.SSLContextImpl;
import sun.security.ssl.SSLSessionImpl;
import sun.security.ssl.ServerHandshaker;

public final class SSLEngineImpl
extends SSLEngine {
    private int connectionState;
    private static final int cs_START = 0;
    private static final int cs_HANDSHAKE = 1;
    private static final int cs_DATA = 2;
    private static final int cs_RENEGOTIATE = 3;
    private static final int cs_ERROR = 4;
    private static final int cs_CLOSED = 6;
    private boolean inboundDone = false;
    EngineWriter writer;
    private SSLContextImpl sslContext;
    private Handshaker handshaker;
    private SSLSessionImpl sess;
    private volatile SSLSessionImpl handshakeSession;
    static final byte clauth_none = 0;
    static final byte clauth_requested = 1;
    static final byte clauth_required = 2;
    private boolean expectingFinished;
    private boolean recvCN;
    private SSLException closeReason;
    private byte doClientAuth;
    private boolean enableSessionCreation = true;
    EngineInputRecord inputRecord;
    EngineOutputRecord outputRecord;
    private AccessControlContext acc;
    private CipherSuiteList enabledCipherSuites;
    private String identificationProtocol = null;
    private AlgorithmConstraints algorithmConstraints = null;
    private boolean serverModeSet = false;
    private boolean roleIsServer;
    private ProtocolList enabledProtocols;
    private ProtocolVersion protocolVersion = ProtocolVersion.DEFAULT;
    private MAC readMAC;
    private MAC writeMAC;
    private CipherBox readCipher;
    private CipherBox writeCipher;
    private boolean secureRenegotiation;
    private byte[] clientVerifyData;
    private byte[] serverVerifyData;
    private Object wrapLock;
    private Object unwrapLock;
    Object writeLock;
    private boolean isFirstAppOutputRecord = true;
    private static final Debug debug = Debug.getInstance("ssl");

    SSLEngineImpl(SSLContextImpl ctx) {
        this.init(ctx);
    }

    SSLEngineImpl(SSLContextImpl ctx, String host, int port) {
        super(host, port);
        this.init(ctx);
    }

    private void init(SSLContextImpl ctx) {
        if (debug != null && Debug.isOn("ssl")) {
            System.out.println("Using SSLEngineImpl.");
        }
        this.sslContext = ctx;
        this.sess = new SSLSessionImpl();
        this.handshakeSession = null;
        this.roleIsServer = true;
        this.connectionState = 0;
        this.readCipher = CipherBox.NULL;
        this.readMAC = MAC.NULL;
        this.writeCipher = CipherBox.NULL;
        this.writeMAC = MAC.NULL;
        this.secureRenegotiation = false;
        this.clientVerifyData = new byte[0];
        this.serverVerifyData = new byte[0];
        this.enabledCipherSuites = this.sslContext.getDefaultCipherSuiteList(this.roleIsServer);
        this.enabledProtocols = this.sslContext.getDefaultProtocolList(this.roleIsServer);
        this.wrapLock = new Object();
        this.unwrapLock = new Object();
        this.writeLock = new Object();
        this.acc = AccessController.getContext();
        this.outputRecord = new EngineOutputRecord(23, this);
        this.inputRecord = new EngineInputRecord(this);
        this.inputRecord.enableFormatChecks();
        this.writer = new EngineWriter();
    }

    private void initHandshaker() {
        switch (this.connectionState) {
            case 0: 
            case 2: {
                break;
            }
            case 1: 
            case 3: {
                return;
            }
            default: {
                throw new IllegalStateException("Internal error");
            }
        }
        this.connectionState = this.connectionState == 0 ? 1 : 3;
        this.handshaker = this.roleIsServer ? new ServerHandshaker(this, this.sslContext, this.enabledProtocols, this.doClientAuth, this.protocolVersion, this.connectionState == 1, this.secureRenegotiation, this.clientVerifyData, this.serverVerifyData) : new ClientHandshaker(this, this.sslContext, this.enabledProtocols, this.protocolVersion, this.connectionState == 1, this.secureRenegotiation, this.clientVerifyData, this.serverVerifyData);
        this.handshaker.setEnabledCipherSuites(this.enabledCipherSuites);
        this.handshaker.setEnableSessionCreation(this.enableSessionCreation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SSLEngineResult.HandshakeStatus getHSStatus(SSLEngineResult.HandshakeStatus hss) {
        if (hss != null) {
            return hss;
        }
        SSLEngineImpl sSLEngineImpl = this;
        synchronized (sSLEngineImpl) {
            if (this.writer.hasOutboundData()) {
                return SSLEngineResult.HandshakeStatus.NEED_WRAP;
            }
            if (this.handshaker != null) {
                if (this.handshaker.taskOutstanding()) {
                    return SSLEngineResult.HandshakeStatus.NEED_TASK;
                }
                return SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
            }
            if (this.connectionState == 6 && !this.isInboundDone()) {
                return SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
            }
            return SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
        }
    }

    private synchronized void checkTaskThrown() throws SSLException {
        if (this.handshaker != null) {
            this.handshaker.checkThrown();
        }
        this.isFirstAppOutputRecord = true;
    }

    private synchronized int getConnectionState() {
        return this.connectionState;
    }

    private synchronized void setConnectionState(int state) {
        this.connectionState = state;
    }

    AccessControlContext getAcc() {
        return this.acc;
    }

    @Override
    public SSLEngineResult.HandshakeStatus getHandshakeStatus() {
        return this.getHSStatus(null);
    }

    private void changeReadCiphers() throws SSLException {
        CipherBox oldCipher = this.readCipher;
        try {
            this.readCipher = this.handshaker.newReadCipher();
            this.readMAC = this.handshaker.newReadMAC();
        }
        catch (GeneralSecurityException e) {
            throw new SSLException("Algorithm missing:  ", e);
        }
        oldCipher.dispose();
    }

    void changeWriteCiphers() throws SSLException {
        if (this.connectionState != 1 && this.connectionState != 3) {
            throw new SSLProtocolException("State error, change cipher specs");
        }
        CipherBox oldCipher = this.writeCipher;
        try {
            this.writeCipher = this.handshaker.newWriteCipher();
            this.writeMAC = this.handshaker.newWriteMAC();
        }
        catch (GeneralSecurityException e) {
            throw new SSLException("Algorithm missing:  ", e);
        }
        oldCipher.dispose();
        this.isFirstAppOutputRecord = true;
    }

    synchronized void setVersion(ProtocolVersion protocolVersion) {
        this.protocolVersion = protocolVersion;
        this.outputRecord.setVersion(protocolVersion);
    }

    private synchronized void kickstartHandshake() throws IOException {
        switch (this.connectionState) {
            case 0: {
                if (!this.serverModeSet) {
                    throw new IllegalStateException("Client/Server mode not yet set.");
                }
                this.initHandshaker();
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                if (!this.secureRenegotiation && !Handshaker.allowUnsafeRenegotiation) {
                    throw new SSLHandshakeException("Insecure renegotiation is not allowed");
                }
                if (!this.secureRenegotiation && debug != null && Debug.isOn("handshake")) {
                    System.out.println("Warning: Using insecure renegotiation");
                }
                this.initHandshaker();
                break;
            }
            case 3: {
                return;
            }
            default: {
                throw new SSLException("SSLEngine is closing/closed");
            }
        }
        if (!this.handshaker.activated()) {
            if (this.connectionState == 3) {
                this.handshaker.activate(this.protocolVersion);
            } else {
                this.handshaker.activate(null);
            }
            if (this.handshaker instanceof ClientHandshaker) {
                this.handshaker.kickstart();
            } else if (this.connectionState != 1) {
                this.handshaker.kickstart();
                this.handshaker.handshakeHash.reset();
            }
        }
    }

    @Override
    public void beginHandshake() throws SSLException {
        try {
            this.kickstartHandshake();
        }
        catch (Exception e) {
            this.fatal((byte)40, "Couldn't kickstart handshaking", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SSLEngineResult unwrap(ByteBuffer netData, ByteBuffer[] appData, int offset, int length) throws SSLException {
        EngineArgs ea = new EngineArgs(netData, appData, offset, length);
        try {
            Object object = this.unwrapLock;
            synchronized (object) {
                try {
                    SSLEngineResult sSLEngineResult = this.readNetRecord(ea);
                    return sSLEngineResult;
                }
                catch (Throwable throwable) {
                    try {
                        throw throwable;
                    }
                    catch (SSLProtocolException spe) {
                        this.fatal((byte)10, spe.getMessage(), spe);
                        SSLEngineResult sSLEngineResult = null;
                        return sSLEngineResult;
                    }
                    catch (Exception e) {
                        this.fatal((byte)80, "problem unwrapping net record", e);
                        SSLEngineResult sSLEngineResult = null;
                        return sSLEngineResult;
                    }
                }
            }
        }
        finally {
            ea.resetLim();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SSLEngineResult readNetRecord(EngineArgs ea) throws IOException {
        SSLEngineResult.Status status = null;
        SSLEngineResult.HandshakeStatus hsStatus = null;
        this.checkTaskThrown();
        if (this.isInboundDone()) {
            return new SSLEngineResult(SSLEngineResult.Status.CLOSED, this.getHSStatus(null), 0, 0);
        }
        SSLEngineImpl sSLEngineImpl = this;
        synchronized (sSLEngineImpl) {
            if (this.connectionState == 1 || this.connectionState == 0) {
                this.kickstartHandshake();
                hsStatus = this.getHSStatus(null);
                if (hsStatus == SSLEngineResult.HandshakeStatus.NEED_WRAP) {
                    return new SSLEngineResult(SSLEngineResult.Status.OK, hsStatus, 0, 0);
                }
            }
        }
        if (hsStatus == null) {
            hsStatus = this.getHSStatus(null);
        }
        if (hsStatus == SSLEngineResult.HandshakeStatus.NEED_TASK) {
            return new SSLEngineResult(SSLEngineResult.Status.OK, hsStatus, 0, 0);
        }
        int packetLen = this.inputRecord.bytesInCompletePacket(ea.netData);
        if (packetLen > this.sess.getPacketBufferSize()) {
            if (packetLen > 33305) {
                throw new SSLProtocolException("Input SSL/TLS record too big: max = 33305 len = " + packetLen);
            }
            this.sess.expandBufferSizes();
        }
        if (packetLen - 5 > ea.getAppRemaining()) {
            return new SSLEngineResult(SSLEngineResult.Status.BUFFER_OVERFLOW, hsStatus, 0, 0);
        }
        if (packetLen == -1 || ea.netData.remaining() < packetLen) {
            return new SSLEngineResult(SSLEngineResult.Status.BUFFER_UNDERFLOW, hsStatus, 0, 0);
        }
        try {
            hsStatus = this.readRecord(ea);
        }
        catch (SSLException e) {
            throw e;
        }
        catch (IOException e) {
            throw new SSLException("readRecord", e);
        }
        status = this.isInboundDone() ? SSLEngineResult.Status.CLOSED : SSLEngineResult.Status.OK;
        hsStatus = this.getHSStatus(hsStatus);
        return new SSLEngineResult(status, hsStatus, ea.deltaNet(), ea.deltaApp());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SSLEngineResult.HandshakeStatus readRecord(EngineArgs ea) throws IOException {
        SSLEngineResult.HandshakeStatus hsStatus = null;
        ByteBuffer readBB = null;
        ByteBuffer decryptedBB = null;
        if (this.getConnectionState() != 4) {
            try {
                readBB = this.inputRecord.read(ea.netData);
            }
            catch (IOException e) {
                this.fatal((byte)10, e);
            }
            try {
                decryptedBB = this.inputRecord.decrypt(this.readMAC, this.readCipher, readBB);
            }
            catch (BadPaddingException e) {
                byte alertType = this.inputRecord.contentType() == 22 ? (byte)40 : 20;
                this.fatal(alertType, e.getMessage(), e);
            }
            SSLEngineImpl sSLEngineImpl = this;
            synchronized (sSLEngineImpl) {
                switch (this.inputRecord.contentType()) {
                    case 22: {
                        this.initHandshaker();
                        if (!this.handshaker.activated()) {
                            if (this.connectionState == 3) {
                                this.handshaker.activate(this.protocolVersion);
                            } else {
                                this.handshaker.activate(null);
                            }
                        }
                        this.handshaker.process_record(this.inputRecord, this.expectingFinished);
                        this.expectingFinished = false;
                        if (this.handshaker.invalidated) {
                            this.handshaker = null;
                            if (this.connectionState != 3) break;
                            this.connectionState = 2;
                            break;
                        }
                        if (this.handshaker.isDone()) {
                            this.secureRenegotiation = this.handshaker.isSecureRenegotiation();
                            this.clientVerifyData = this.handshaker.getClientVerifyData();
                            this.serverVerifyData = this.handshaker.getServerVerifyData();
                            this.sess = this.handshaker.getSession();
                            this.handshakeSession = null;
                            if (!this.writer.hasOutboundData()) {
                                hsStatus = SSLEngineResult.HandshakeStatus.FINISHED;
                            }
                            this.handshaker = null;
                            this.connectionState = 2;
                            break;
                        }
                        if (!this.handshaker.taskOutstanding()) break;
                        hsStatus = SSLEngineResult.HandshakeStatus.NEED_TASK;
                        break;
                    }
                    case 23: {
                        if (this.connectionState != 2 && this.connectionState != 3 && this.connectionState != 6) {
                            throw new SSLProtocolException("Data received in non-data state: " + this.connectionState);
                        }
                        if (this.expectingFinished) {
                            throw new SSLProtocolException("Expecting finished message, received data");
                        }
                        if (this.inboundDone) break;
                        ea.scatter(decryptedBB.slice());
                        break;
                    }
                    case 21: {
                        this.recvAlert();
                        break;
                    }
                    case 20: {
                        if (this.connectionState != 1 && this.connectionState != 3) {
                            this.fatal((byte)10, "illegal change cipher spec msg, conn state = " + this.connectionState);
                        } else if (this.inputRecord.available() != 1 || this.inputRecord.read() != 1) {
                            this.fatal((byte)10, "Malformed change cipher spec msg");
                        }
                        this.handshaker.receiveChangeCipherSpec();
                        this.changeReadCiphers();
                        this.expectingFinished = true;
                        break;
                    }
                    default: {
                        if (debug == null || !Debug.isOn("ssl")) break;
                        System.out.println(SSLEngineImpl.threadName() + ", Received record type: " + this.inputRecord.contentType());
                    }
                }
                if (this.connectionState < 4 && !this.isInboundDone() && hsStatus == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING && this.checkSequenceNumber(this.readMAC, this.inputRecord.contentType())) {
                    hsStatus = this.getHSStatus(null);
                }
            }
        }
        return hsStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SSLEngineResult wrap(ByteBuffer[] appData, int offset, int length, ByteBuffer netData) throws SSLException {
        EngineArgs ea = new EngineArgs(appData, offset, length, netData);
        if (netData.remaining() < 16921) {
            return new SSLEngineResult(SSLEngineResult.Status.BUFFER_OVERFLOW, this.getHSStatus(null), 0, 0);
        }
        try {
            Object object = this.wrapLock;
            synchronized (object) {
                try {
                    SSLEngineResult sSLEngineResult = this.writeAppRecord(ea);
                    return sSLEngineResult;
                }
                catch (Throwable throwable) {
                    try {
                        throw throwable;
                    }
                    catch (SSLProtocolException spe) {
                        this.fatal((byte)10, spe.getMessage(), spe);
                        SSLEngineResult sSLEngineResult = null;
                        return sSLEngineResult;
                    }
                    catch (Exception e) {
                        ea.resetPos();
                        this.fatal((byte)80, "problem wrapping app data", e);
                        SSLEngineResult sSLEngineResult = null;
                        return sSLEngineResult;
                    }
                }
            }
        }
        finally {
            ea.resetLim();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SSLEngineResult writeAppRecord(EngineArgs ea) throws IOException {
        SSLEngineResult.Status status = null;
        SSLEngineResult.HandshakeStatus hsStatus = null;
        this.checkTaskThrown();
        if (this.writer.isOutboundDone()) {
            return new SSLEngineResult(SSLEngineResult.Status.CLOSED, this.getHSStatus(null), 0, 0);
        }
        Object object = this;
        synchronized (object) {
            if (this.connectionState == 1 || this.connectionState == 0) {
                this.kickstartHandshake();
                hsStatus = this.getHSStatus(null);
                if (hsStatus == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                    return new SSLEngineResult(SSLEngineResult.Status.OK, hsStatus, 0, 0);
                }
            }
        }
        if (hsStatus == null) {
            hsStatus = this.getHSStatus(null);
        }
        if (hsStatus == SSLEngineResult.HandshakeStatus.NEED_TASK) {
            return new SSLEngineResult(SSLEngineResult.Status.OK, hsStatus, 0, 0);
        }
        try {
            object = this.writeLock;
            synchronized (object) {
                hsStatus = this.writeRecord(this.outputRecord, ea);
            }
        }
        catch (SSLException e) {
            throw e;
        }
        catch (IOException e) {
            throw new SSLException("Write problems", e);
        }
        status = this.isOutboundDone() ? SSLEngineResult.Status.CLOSED : SSLEngineResult.Status.OK;
        hsStatus = this.getHSStatus(hsStatus);
        return new SSLEngineResult(status, hsStatus, ea.deltaApp(), ea.deltaNet());
    }

    private SSLEngineResult.HandshakeStatus writeRecord(EngineOutputRecord eor, EngineArgs ea) throws IOException {
        SSLEngineResult.HandshakeStatus hsStatus = this.writer.writeRecord(eor, ea, this.writeMAC, this.writeCipher);
        if (this.isFirstAppOutputRecord && ea.deltaApp() > 0) {
            this.isFirstAppOutputRecord = false;
        }
        if (this.connectionState < 4 && !this.isOutboundDone() && hsStatus == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING && this.checkSequenceNumber(this.writeMAC, eor.contentType())) {
            hsStatus = this.getHSStatus(null);
        }
        if (this.isFirstAppOutputRecord && ea.deltaApp() > 0) {
            this.isFirstAppOutputRecord = false;
        }
        return hsStatus;
    }

    boolean needToSplitPayload(CipherBox cipher, ProtocolVersion protocol) {
        return protocol.v <= ProtocolVersion.TLS10.v && cipher.isCBCMode() && !this.isFirstAppOutputRecord && Record.enableCBCProtection;
    }

    void writeRecord(EngineOutputRecord eor) throws IOException {
        this.writer.writeRecord(eor, this.writeMAC, this.writeCipher);
        if (this.connectionState < 4 && !this.isOutboundDone()) {
            this.checkSequenceNumber(this.writeMAC, eor.contentType());
        }
    }

    private boolean checkSequenceNumber(MAC mac, byte type) throws IOException {
        if (this.connectionState >= 4 || mac == MAC.NULL) {
            return false;
        }
        if (mac.seqNumOverflow()) {
            if (debug != null && Debug.isOn("ssl")) {
                System.out.println(SSLEngineImpl.threadName() + ", sequence number extremely close to overflow " + "(2^64-1 packets). Closing connection.");
            }
            this.fatal((byte)40, "sequence number overflow");
            return true;
        }
        if (type != 22 && mac.seqNumIsHuge()) {
            if (debug != null && Debug.isOn("ssl")) {
                System.out.println(SSLEngineImpl.threadName() + ", request renegotiation " + "to avoid sequence number overflow");
            }
            this.beginHandshake();
            return true;
        }
        return false;
    }

    private void closeOutboundInternal() {
        if (debug != null && Debug.isOn("ssl")) {
            System.out.println(SSLEngineImpl.threadName() + ", closeOutboundInternal()");
        }
        if (this.writer.isOutboundDone()) {
            return;
        }
        switch (this.connectionState) {
            case 0: {
                this.writer.closeOutbound();
                this.inboundDone = true;
                break;
            }
            case 4: 
            case 6: {
                break;
            }
            default: {
                this.warning((byte)0);
                this.writer.closeOutbound();
            }
        }
        this.writeCipher.dispose();
        this.connectionState = 6;
    }

    @Override
    public synchronized void closeOutbound() {
        if (debug != null && Debug.isOn("ssl")) {
            System.out.println(SSLEngineImpl.threadName() + ", called closeOutbound()");
        }
        this.closeOutboundInternal();
    }

    @Override
    public boolean isOutboundDone() {
        return this.writer.isOutboundDone();
    }

    private void closeInboundInternal() {
        if (debug != null && Debug.isOn("ssl")) {
            System.out.println(SSLEngineImpl.threadName() + ", closeInboundInternal()");
        }
        if (this.inboundDone) {
            return;
        }
        this.closeOutboundInternal();
        this.inboundDone = true;
        this.readCipher.dispose();
        this.connectionState = 6;
    }

    @Override
    public synchronized void closeInbound() throws SSLException {
        if (debug != null && Debug.isOn("ssl")) {
            System.out.println(SSLEngineImpl.threadName() + ", called closeInbound()");
        }
        if (this.connectionState != 0 && !this.recvCN) {
            this.recvCN = true;
            this.fatal((byte)80, "Inbound closed before receiving peer's close_notify: possible truncation attack?");
        } else {
            this.closeInboundInternal();
        }
    }

    @Override
    public synchronized boolean isInboundDone() {
        return this.inboundDone;
    }

    @Override
    public synchronized SSLSession getSession() {
        return this.sess;
    }

    @Override
    public synchronized SSLSession getHandshakeSession() {
        return this.handshakeSession;
    }

    synchronized void setHandshakeSession(SSLSessionImpl session) {
        this.handshakeSession = session;
    }

    @Override
    public synchronized Runnable getDelegatedTask() {
        if (this.handshaker != null) {
            return this.handshaker.getTask();
        }
        return null;
    }

    void warning(byte description) {
        this.sendAlert((byte)1, description);
    }

    synchronized void fatal(byte description, String diagnostic) throws SSLException {
        this.fatal(description, diagnostic, null);
    }

    synchronized void fatal(byte description, Throwable cause) throws SSLException {
        this.fatal(description, null, cause);
    }

    synchronized void fatal(byte description, String diagnostic, Throwable cause) throws SSLException {
        if (diagnostic == null) {
            diagnostic = "General SSLEngine problem";
        }
        if (cause == null) {
            cause = Alerts.getSSLException(description, cause, diagnostic);
        }
        if (this.closeReason != null) {
            if (debug != null && Debug.isOn("ssl")) {
                System.out.println(SSLEngineImpl.threadName() + ", fatal: engine already closed.  Rethrowing " + cause.toString());
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof SSLException) {
                throw (SSLException)cause;
            }
            if (cause instanceof Exception) {
                throw new SSLException("fatal SSLEngine condition", cause);
            }
        }
        if (debug != null && Debug.isOn("ssl")) {
            System.out.println(SSLEngineImpl.threadName() + ", fatal error: " + description + ": " + diagnostic + "\n" + cause.toString());
        }
        int oldState = this.connectionState;
        this.connectionState = 4;
        this.inboundDone = true;
        this.sess.invalidate();
        if (this.handshakeSession != null) {
            this.handshakeSession.invalidate();
        }
        if (oldState != 0) {
            this.sendAlert((byte)2, description);
        }
        this.closeReason = cause instanceof SSLException ? (SSLException)cause : Alerts.getSSLException(description, cause, diagnostic);
        this.writer.closeOutbound();
        this.connectionState = 6;
        this.readCipher.dispose();
        this.writeCipher.dispose();
        if (cause instanceof RuntimeException) {
            throw (RuntimeException)cause;
        }
        throw this.closeReason;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recvAlert() throws IOException {
        byte level = (byte)this.inputRecord.read();
        byte description = (byte)this.inputRecord.read();
        if (description == -1) {
            this.fatal((byte)47, "Short alert message");
        }
        if (debug != null && (Debug.isOn("record") || Debug.isOn("handshake"))) {
            PrintStream printStream = System.out;
            synchronized (printStream) {
                System.out.print(SSLEngineImpl.threadName());
                System.out.print(", RECV " + this.protocolVersion + " ALERT:  ");
                if (level == 2) {
                    System.out.print("fatal, ");
                } else if (level == 1) {
                    System.out.print("warning, ");
                } else {
                    System.out.print("<level " + (0xFF & level) + ">, ");
                }
                System.out.println(Alerts.alertDescription(description));
            }
        }
        if (level == 1) {
            if (description == 0) {
                if (this.connectionState == 1) {
                    this.fatal((byte)10, "Received close_notify during handshake");
                } else {
                    this.recvCN = true;
                    this.closeInboundInternal();
                }
            } else if (this.handshaker != null) {
                this.handshaker.handshakeAlert(description);
            }
        } else {
            String reason = "Received fatal alert: " + Alerts.alertDescription(description);
            if (this.closeReason == null) {
                this.closeReason = Alerts.getSSLException(description, reason);
            }
            this.fatal((byte)10, reason);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendAlert(byte level, byte description) {
        block12: {
            boolean useDebug;
            if (this.connectionState >= 6) {
                return;
            }
            if (!(this.connectionState != 1 || this.handshaker != null && this.handshaker.started())) {
                return;
            }
            EngineOutputRecord r = new EngineOutputRecord(21, this);
            r.setVersion(this.protocolVersion);
            boolean bl = useDebug = debug != null && Debug.isOn("ssl");
            if (useDebug) {
                PrintStream printStream = System.out;
                synchronized (printStream) {
                    System.out.print(SSLEngineImpl.threadName());
                    System.out.print(", SEND " + this.protocolVersion + " ALERT:  ");
                    if (level == 2) {
                        System.out.print("fatal, ");
                    } else if (level == 1) {
                        System.out.print("warning, ");
                    } else {
                        System.out.print("<level = " + (0xFF & level) + ">, ");
                    }
                    System.out.println("description = " + Alerts.alertDescription(description));
                }
            }
            r.write(level);
            r.write(description);
            try {
                this.writeRecord(r);
            }
            catch (IOException e) {
                if (!useDebug) break block12;
                System.out.println(SSLEngineImpl.threadName() + ", Exception sending alert: " + e);
            }
        }
    }

    @Override
    public synchronized void setEnableSessionCreation(boolean flag) {
        this.enableSessionCreation = flag;
        if (this.handshaker != null && !this.handshaker.activated()) {
            this.handshaker.setEnableSessionCreation(this.enableSessionCreation);
        }
    }

    @Override
    public synchronized boolean getEnableSessionCreation() {
        return this.enableSessionCreation;
    }

    @Override
    public synchronized void setNeedClientAuth(boolean flag) {
        this.doClientAuth = (byte)(flag ? 2 : 0);
        if (this.handshaker != null && this.handshaker instanceof ServerHandshaker && !this.handshaker.activated()) {
            ((ServerHandshaker)this.handshaker).setClientAuth(this.doClientAuth);
        }
    }

    @Override
    public synchronized boolean getNeedClientAuth() {
        return this.doClientAuth == 2;
    }

    @Override
    public synchronized void setWantClientAuth(boolean flag) {
        byte by = this.doClientAuth = flag ? (byte)1 : 0;
        if (this.handshaker != null && this.handshaker instanceof ServerHandshaker && !this.handshaker.activated()) {
            ((ServerHandshaker)this.handshaker).setClientAuth(this.doClientAuth);
        }
    }

    @Override
    public synchronized boolean getWantClientAuth() {
        return this.doClientAuth == 1;
    }

    @Override
    public synchronized void setUseClientMode(boolean flag) {
        switch (this.connectionState) {
            case 0: {
                if (this.roleIsServer != !flag) {
                    if (this.sslContext.isDefaultProtocolList(this.enabledProtocols)) {
                        this.enabledProtocols = this.sslContext.getDefaultProtocolList(!flag);
                    }
                    if (this.sslContext.isDefaultCipherSuiteList(this.enabledCipherSuites)) {
                        this.enabledCipherSuites = this.sslContext.getDefaultCipherSuiteList(!flag);
                    }
                }
                this.roleIsServer = !flag;
                this.serverModeSet = true;
                break;
            }
            case 1: {
                assert (this.handshaker != null);
                if (!this.handshaker.activated()) {
                    if (this.roleIsServer != !flag && this.sslContext.isDefaultProtocolList(this.enabledProtocols)) {
                        this.enabledProtocols = this.sslContext.getDefaultProtocolList(!flag);
                    }
                    this.roleIsServer = !flag;
                    this.connectionState = 0;
                    this.initHandshaker();
                    break;
                }
            }
            default: {
                if (debug != null && Debug.isOn("ssl")) {
                    System.out.println(SSLEngineImpl.threadName() + ", setUseClientMode() invoked in state = " + this.connectionState);
                }
                throw new IllegalArgumentException("Cannot change mode after SSL traffic has started");
            }
        }
    }

    @Override
    public synchronized boolean getUseClientMode() {
        return !this.roleIsServer;
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.sslContext.getSupportedCipherSuiteList().toStringArray();
    }

    @Override
    public synchronized void setEnabledCipherSuites(String[] suites) {
        this.enabledCipherSuites = new CipherSuiteList(suites);
        if (this.handshaker != null && !this.handshaker.activated()) {
            this.handshaker.setEnabledCipherSuites(this.enabledCipherSuites);
        }
    }

    @Override
    public synchronized String[] getEnabledCipherSuites() {
        return this.enabledCipherSuites.toStringArray();
    }

    @Override
    public String[] getSupportedProtocols() {
        return this.sslContext.getSuportedProtocolList().toStringArray();
    }

    @Override
    public synchronized void setEnabledProtocols(String[] protocols) {
        this.enabledProtocols = new ProtocolList(protocols);
        if (this.handshaker != null && !this.handshaker.activated()) {
            this.handshaker.setEnabledProtocols(this.enabledProtocols);
        }
    }

    @Override
    public synchronized String[] getEnabledProtocols() {
        return this.enabledProtocols.toStringArray();
    }

    @Override
    public synchronized SSLParameters getSSLParameters() {
        SSLParameters params = super.getSSLParameters();
        params.setEndpointIdentificationAlgorithm(this.identificationProtocol);
        params.setAlgorithmConstraints(this.algorithmConstraints);
        return params;
    }

    @Override
    public synchronized void setSSLParameters(SSLParameters params) {
        super.setSSLParameters(params);
        this.identificationProtocol = params.getEndpointIdentificationAlgorithm();
        this.algorithmConstraints = params.getAlgorithmConstraints();
        if (this.handshaker != null && !this.handshaker.started()) {
            this.handshaker.setIdentificationProtocol(this.identificationProtocol);
            this.handshaker.setAlgorithmConstraints(this.algorithmConstraints);
        }
    }

    private static String threadName() {
        return Thread.currentThread().getName();
    }

    public String toString() {
        StringBuilder retval = new StringBuilder(80);
        retval.append(Integer.toHexString(this.hashCode()));
        retval.append("[");
        retval.append("SSLEngine[hostname=");
        String host = this.getPeerHost();
        retval.append(host == null ? "null" : host);
        retval.append(" port=");
        retval.append(Integer.toString(this.getPeerPort()));
        retval.append("] ");
        retval.append(this.getSession().getCipherSuite());
        retval.append("]");
        return retval.toString();
    }
}

