/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.midi;

import com.sun.media.sound.AutoConnectSequencer;
import com.sun.media.sound.JDK13Services;
import com.sun.media.sound.MidiDeviceReceiverEnvelope;
import com.sun.media.sound.MidiDeviceTransmitterEnvelope;
import com.sun.media.sound.ReferenceCountingDevice;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiDeviceReceiver;
import javax.sound.midi.MidiDeviceTransmitter;
import javax.sound.midi.MidiFileFormat;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Soundbank;
import javax.sound.midi.Synthesizer;
import javax.sound.midi.Transmitter;
import javax.sound.midi.spi.MidiDeviceProvider;
import javax.sound.midi.spi.MidiFileReader;
import javax.sound.midi.spi.MidiFileWriter;
import javax.sound.midi.spi.SoundbankReader;

public class MidiSystem {
    private MidiSystem() {
    }

    public static MidiDevice.Info[] getMidiDeviceInfo() {
        ArrayList<MidiDevice.Info> allInfos = new ArrayList<MidiDevice.Info>();
        List providers = MidiSystem.getMidiDeviceProviders();
        for (int i = 0; i < providers.size(); ++i) {
            MidiDeviceProvider provider = (MidiDeviceProvider)providers.get(i);
            MidiDevice.Info[] tmpinfo = provider.getDeviceInfo();
            for (int j = 0; j < tmpinfo.length; ++j) {
                allInfos.add(tmpinfo[j]);
            }
        }
        MidiDevice.Info[] infosArray = allInfos.toArray(new MidiDevice.Info[0]);
        return infosArray;
    }

    public static MidiDevice getMidiDevice(MidiDevice.Info info) throws MidiUnavailableException {
        List providers = MidiSystem.getMidiDeviceProviders();
        for (int i = 0; i < providers.size(); ++i) {
            MidiDeviceProvider provider = (MidiDeviceProvider)providers.get(i);
            if (!provider.isDeviceSupported(info)) continue;
            MidiDevice device = provider.getDevice(info);
            return device;
        }
        throw new IllegalArgumentException("Requested device not installed: " + info);
    }

    public static Receiver getReceiver() throws MidiUnavailableException {
        MidiDevice device = MidiSystem.getDefaultDeviceWrapper(Receiver.class);
        Receiver receiver = device instanceof ReferenceCountingDevice ? ((ReferenceCountingDevice)((Object)device)).getReceiverReferenceCounting() : device.getReceiver();
        if (!(receiver instanceof MidiDeviceReceiver)) {
            receiver = new MidiDeviceReceiverEnvelope(device, receiver);
        }
        return receiver;
    }

    public static Transmitter getTransmitter() throws MidiUnavailableException {
        MidiDevice device = MidiSystem.getDefaultDeviceWrapper(Transmitter.class);
        Transmitter transmitter = device instanceof ReferenceCountingDevice ? ((ReferenceCountingDevice)((Object)device)).getTransmitterReferenceCounting() : device.getTransmitter();
        if (!(transmitter instanceof MidiDeviceTransmitter)) {
            transmitter = new MidiDeviceTransmitterEnvelope(device, transmitter);
        }
        return transmitter;
    }

    public static Synthesizer getSynthesizer() throws MidiUnavailableException {
        return (Synthesizer)MidiSystem.getDefaultDeviceWrapper(Synthesizer.class);
    }

    public static Sequencer getSequencer() throws MidiUnavailableException {
        return MidiSystem.getSequencer(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Sequencer getSequencer(boolean connected) throws MidiUnavailableException {
        Sequencer seq = (Sequencer)MidiSystem.getDefaultDeviceWrapper(Sequencer.class);
        if (connected) {
            MidiUnavailableException mue;
            Receiver rec;
            block16: {
                block15: {
                    rec = null;
                    mue = null;
                    try {
                        Synthesizer synth2 = MidiSystem.getSynthesizer();
                        if (synth2 instanceof ReferenceCountingDevice) {
                            rec = ((ReferenceCountingDevice)((Object)synth2)).getReceiverReferenceCounting();
                            break block15;
                        }
                        synth2.open();
                        try {
                            rec = synth2.getReceiver();
                        }
                        finally {
                            if (rec == null) {
                                synth2.close();
                            }
                        }
                    }
                    catch (MidiUnavailableException e) {
                        if (!(e instanceof MidiUnavailableException)) break block15;
                        mue = e;
                    }
                }
                if (rec == null) {
                    try {
                        rec = MidiSystem.getReceiver();
                    }
                    catch (Exception e) {
                        if (!(e instanceof MidiUnavailableException)) break block16;
                        mue = (MidiUnavailableException)e;
                    }
                }
            }
            if (rec != null) {
                seq.getTransmitter().setReceiver(rec);
                if (seq instanceof AutoConnectSequencer) {
                    ((AutoConnectSequencer)((Object)seq)).setAutoConnect(rec);
                }
            } else {
                if (mue != null) {
                    throw mue;
                }
                throw new MidiUnavailableException("no receiver available");
            }
        }
        return seq;
    }

    public static Soundbank getSoundbank(InputStream stream) throws InvalidMidiDataException, IOException {
        SoundbankReader sp = null;
        Soundbank s = null;
        List providers = MidiSystem.getSoundbankReaders();
        for (int i = 0; i < providers.size(); ++i) {
            sp = (SoundbankReader)providers.get(i);
            s = sp.getSoundbank(stream);
            if (s == null) continue;
            return s;
        }
        throw new InvalidMidiDataException("cannot get soundbank from stream");
    }

    public static Soundbank getSoundbank(URL url) throws InvalidMidiDataException, IOException {
        SoundbankReader sp = null;
        Soundbank s = null;
        List providers = MidiSystem.getSoundbankReaders();
        for (int i = 0; i < providers.size(); ++i) {
            sp = (SoundbankReader)providers.get(i);
            s = sp.getSoundbank(url);
            if (s == null) continue;
            return s;
        }
        throw new InvalidMidiDataException("cannot get soundbank from stream");
    }

    public static Soundbank getSoundbank(File file) throws InvalidMidiDataException, IOException {
        SoundbankReader sp = null;
        Soundbank s = null;
        List providers = MidiSystem.getSoundbankReaders();
        for (int i = 0; i < providers.size(); ++i) {
            sp = (SoundbankReader)providers.get(i);
            s = sp.getSoundbank(file);
            if (s == null) continue;
            return s;
        }
        throw new InvalidMidiDataException("cannot get soundbank from stream");
    }

    public static MidiFileFormat getMidiFileFormat(InputStream stream) throws InvalidMidiDataException, IOException {
        List providers = MidiSystem.getMidiFileReaders();
        MidiFileFormat format = null;
        for (int i = 0; i < providers.size(); ++i) {
            MidiFileReader reader = (MidiFileReader)providers.get(i);
            try {
                format = reader.getMidiFileFormat(stream);
                break;
            }
            catch (InvalidMidiDataException e) {
                continue;
            }
        }
        if (format == null) {
            throw new InvalidMidiDataException("input stream is not a supported file type");
        }
        return format;
    }

    public static MidiFileFormat getMidiFileFormat(URL url) throws InvalidMidiDataException, IOException {
        List providers = MidiSystem.getMidiFileReaders();
        MidiFileFormat format = null;
        for (int i = 0; i < providers.size(); ++i) {
            MidiFileReader reader = (MidiFileReader)providers.get(i);
            try {
                format = reader.getMidiFileFormat(url);
                break;
            }
            catch (InvalidMidiDataException e) {
                continue;
            }
        }
        if (format == null) {
            throw new InvalidMidiDataException("url is not a supported file type");
        }
        return format;
    }

    public static MidiFileFormat getMidiFileFormat(File file) throws InvalidMidiDataException, IOException {
        List providers = MidiSystem.getMidiFileReaders();
        MidiFileFormat format = null;
        for (int i = 0; i < providers.size(); ++i) {
            MidiFileReader reader = (MidiFileReader)providers.get(i);
            try {
                format = reader.getMidiFileFormat(file);
                break;
            }
            catch (InvalidMidiDataException e) {
                continue;
            }
        }
        if (format == null) {
            throw new InvalidMidiDataException("file is not a supported file type");
        }
        return format;
    }

    public static Sequence getSequence(InputStream stream) throws InvalidMidiDataException, IOException {
        List providers = MidiSystem.getMidiFileReaders();
        Sequence sequence = null;
        for (int i = 0; i < providers.size(); ++i) {
            MidiFileReader reader = (MidiFileReader)providers.get(i);
            try {
                sequence = reader.getSequence(stream);
                break;
            }
            catch (InvalidMidiDataException e) {
                continue;
            }
        }
        if (sequence == null) {
            throw new InvalidMidiDataException("could not get sequence from input stream");
        }
        return sequence;
    }

    public static Sequence getSequence(URL url) throws InvalidMidiDataException, IOException {
        List providers = MidiSystem.getMidiFileReaders();
        Sequence sequence = null;
        for (int i = 0; i < providers.size(); ++i) {
            MidiFileReader reader = (MidiFileReader)providers.get(i);
            try {
                sequence = reader.getSequence(url);
                break;
            }
            catch (InvalidMidiDataException e) {
                continue;
            }
        }
        if (sequence == null) {
            throw new InvalidMidiDataException("could not get sequence from URL");
        }
        return sequence;
    }

    public static Sequence getSequence(File file) throws InvalidMidiDataException, IOException {
        List providers = MidiSystem.getMidiFileReaders();
        Sequence sequence = null;
        for (int i = 0; i < providers.size(); ++i) {
            MidiFileReader reader = (MidiFileReader)providers.get(i);
            try {
                sequence = reader.getSequence(file);
                break;
            }
            catch (InvalidMidiDataException e) {
                continue;
            }
        }
        if (sequence == null) {
            throw new InvalidMidiDataException("could not get sequence from file");
        }
        return sequence;
    }

    public static int[] getMidiFileTypes() {
        List providers = MidiSystem.getMidiFileWriters();
        HashSet<Integer> allTypes = new HashSet<Integer>();
        for (int i = 0; i < providers.size(); ++i) {
            MidiFileWriter writer = (MidiFileWriter)providers.get(i);
            int[] types = writer.getMidiFileTypes();
            for (int j = 0; j < types.length; ++j) {
                allTypes.add(new Integer(types[j]));
            }
        }
        int[] resultTypes = new int[allTypes.size()];
        int index = 0;
        for (Integer integer : allTypes) {
            resultTypes[index++] = integer;
        }
        return resultTypes;
    }

    public static boolean isFileTypeSupported(int fileType) {
        List providers = MidiSystem.getMidiFileWriters();
        for (int i = 0; i < providers.size(); ++i) {
            MidiFileWriter writer = (MidiFileWriter)providers.get(i);
            if (!writer.isFileTypeSupported(fileType)) continue;
            return true;
        }
        return false;
    }

    public static int[] getMidiFileTypes(Sequence sequence) {
        List providers = MidiSystem.getMidiFileWriters();
        HashSet<Integer> allTypes = new HashSet<Integer>();
        for (int i = 0; i < providers.size(); ++i) {
            MidiFileWriter writer = (MidiFileWriter)providers.get(i);
            int[] types = writer.getMidiFileTypes(sequence);
            for (int j = 0; j < types.length; ++j) {
                allTypes.add(new Integer(types[j]));
            }
        }
        int[] resultTypes = new int[allTypes.size()];
        int index = 0;
        for (Integer integer : allTypes) {
            resultTypes[index++] = integer;
        }
        return resultTypes;
    }

    public static boolean isFileTypeSupported(int fileType, Sequence sequence) {
        List providers = MidiSystem.getMidiFileWriters();
        for (int i = 0; i < providers.size(); ++i) {
            MidiFileWriter writer = (MidiFileWriter)providers.get(i);
            if (!writer.isFileTypeSupported(fileType, sequence)) continue;
            return true;
        }
        return false;
    }

    public static int write(Sequence in, int fileType, OutputStream out) throws IOException {
        List providers = MidiSystem.getMidiFileWriters();
        int bytesWritten = -2;
        for (int i = 0; i < providers.size(); ++i) {
            MidiFileWriter writer = (MidiFileWriter)providers.get(i);
            if (!writer.isFileTypeSupported(fileType, in)) continue;
            bytesWritten = writer.write(in, fileType, out);
            break;
        }
        if (bytesWritten == -2) {
            throw new IllegalArgumentException("MIDI file type is not supported");
        }
        return bytesWritten;
    }

    public static int write(Sequence in, int type, File out) throws IOException {
        List providers = MidiSystem.getMidiFileWriters();
        int bytesWritten = -2;
        for (int i = 0; i < providers.size(); ++i) {
            MidiFileWriter writer = (MidiFileWriter)providers.get(i);
            if (!writer.isFileTypeSupported(type, in)) continue;
            bytesWritten = writer.write(in, type, out);
            break;
        }
        if (bytesWritten == -2) {
            throw new IllegalArgumentException("MIDI file type is not supported");
        }
        return bytesWritten;
    }

    private static List getMidiDeviceProviders() {
        return MidiSystem.getProviders(MidiDeviceProvider.class);
    }

    private static List getSoundbankReaders() {
        return MidiSystem.getProviders(SoundbankReader.class);
    }

    private static List getMidiFileWriters() {
        return MidiSystem.getProviders(MidiFileWriter.class);
    }

    private static List getMidiFileReaders() {
        return MidiSystem.getProviders(MidiFileReader.class);
    }

    private static MidiDevice getDefaultDeviceWrapper(Class deviceClass) throws MidiUnavailableException {
        try {
            return MidiSystem.getDefaultDevice(deviceClass);
        }
        catch (IllegalArgumentException iae) {
            MidiUnavailableException mae = new MidiUnavailableException();
            mae.initCause(iae);
            throw mae;
        }
    }

    private static MidiDevice getDefaultDevice(Class deviceClass) {
        MidiDevice device;
        MidiDeviceProvider defaultProvider;
        List providers = MidiSystem.getMidiDeviceProviders();
        String providerClassName = JDK13Services.getDefaultProviderClassName(deviceClass);
        String instanceName = JDK13Services.getDefaultInstanceName(deviceClass);
        if (providerClassName != null && (defaultProvider = MidiSystem.getNamedProvider(providerClassName, providers)) != null) {
            if (instanceName != null && (device = MidiSystem.getNamedDevice(instanceName, defaultProvider, deviceClass)) != null) {
                return device;
            }
            device = MidiSystem.getFirstDevice(defaultProvider, deviceClass);
            if (device != null) {
                return device;
            }
        }
        if (instanceName != null && (device = MidiSystem.getNamedDevice(instanceName, providers, deviceClass)) != null) {
            return device;
        }
        device = MidiSystem.getFirstDevice(providers, deviceClass);
        if (device != null) {
            return device;
        }
        throw new IllegalArgumentException("Requested device not installed");
    }

    private static MidiDeviceProvider getNamedProvider(String providerClassName, List providers) {
        for (int i = 0; i < providers.size(); ++i) {
            MidiDeviceProvider provider = (MidiDeviceProvider)providers.get(i);
            if (!provider.getClass().getName().equals(providerClassName)) continue;
            return provider;
        }
        return null;
    }

    private static MidiDevice getNamedDevice(String deviceName, MidiDeviceProvider provider, Class deviceClass) {
        MidiDevice device = MidiSystem.getNamedDevice(deviceName, provider, deviceClass, false, false);
        if (device != null) {
            return device;
        }
        if (deviceClass == Receiver.class && (device = MidiSystem.getNamedDevice(deviceName, provider, deviceClass, true, false)) != null) {
            return device;
        }
        return null;
    }

    private static MidiDevice getNamedDevice(String deviceName, MidiDeviceProvider provider, Class deviceClass, boolean allowSynthesizer, boolean allowSequencer) {
        MidiDevice.Info[] infos = provider.getDeviceInfo();
        for (int i = 0; i < infos.length; ++i) {
            MidiDevice device;
            if (!infos[i].getName().equals(deviceName) || !MidiSystem.isAppropriateDevice(device = provider.getDevice(infos[i]), deviceClass, allowSynthesizer, allowSequencer)) continue;
            return device;
        }
        return null;
    }

    private static MidiDevice getNamedDevice(String deviceName, List providers, Class deviceClass) {
        MidiDevice device = MidiSystem.getNamedDevice(deviceName, providers, deviceClass, false, false);
        if (device != null) {
            return device;
        }
        if (deviceClass == Receiver.class && (device = MidiSystem.getNamedDevice(deviceName, providers, deviceClass, true, false)) != null) {
            return device;
        }
        return null;
    }

    private static MidiDevice getNamedDevice(String deviceName, List providers, Class deviceClass, boolean allowSynthesizer, boolean allowSequencer) {
        for (int i = 0; i < providers.size(); ++i) {
            MidiDeviceProvider provider = (MidiDeviceProvider)providers.get(i);
            MidiDevice device = MidiSystem.getNamedDevice(deviceName, provider, deviceClass, allowSynthesizer, allowSequencer);
            if (device == null) continue;
            return device;
        }
        return null;
    }

    private static MidiDevice getFirstDevice(MidiDeviceProvider provider, Class deviceClass) {
        MidiDevice device = MidiSystem.getFirstDevice(provider, deviceClass, false, false);
        if (device != null) {
            return device;
        }
        if (deviceClass == Receiver.class && (device = MidiSystem.getFirstDevice(provider, deviceClass, true, false)) != null) {
            return device;
        }
        return null;
    }

    private static MidiDevice getFirstDevice(MidiDeviceProvider provider, Class deviceClass, boolean allowSynthesizer, boolean allowSequencer) {
        MidiDevice.Info[] infos = provider.getDeviceInfo();
        for (int j = 0; j < infos.length; ++j) {
            MidiDevice device = provider.getDevice(infos[j]);
            if (!MidiSystem.isAppropriateDevice(device, deviceClass, allowSynthesizer, allowSequencer)) continue;
            return device;
        }
        return null;
    }

    private static MidiDevice getFirstDevice(List providers, Class deviceClass) {
        MidiDevice device = MidiSystem.getFirstDevice(providers, deviceClass, false, false);
        if (device != null) {
            return device;
        }
        if (deviceClass == Receiver.class && (device = MidiSystem.getFirstDevice(providers, deviceClass, true, false)) != null) {
            return device;
        }
        return null;
    }

    private static MidiDevice getFirstDevice(List providers, Class deviceClass, boolean allowSynthesizer, boolean allowSequencer) {
        for (int i = 0; i < providers.size(); ++i) {
            MidiDeviceProvider provider = (MidiDeviceProvider)providers.get(i);
            MidiDevice device = MidiSystem.getFirstDevice(provider, deviceClass, allowSynthesizer, allowSequencer);
            if (device == null) continue;
            return device;
        }
        return null;
    }

    private static boolean isAppropriateDevice(MidiDevice device, Class deviceClass, boolean allowSynthesizer, boolean allowSequencer) {
        if (deviceClass.isInstance(device)) {
            return true;
        }
        return (!(device instanceof Sequencer) && !(device instanceof Synthesizer) || device instanceof Sequencer && allowSequencer || device instanceof Synthesizer && allowSynthesizer) && (deviceClass == Receiver.class && device.getMaxReceivers() != 0 || deviceClass == Transmitter.class && device.getMaxTransmitters() != 0);
    }

    private static List getProviders(Class providerClass) {
        return JDK13Services.getProviders(providerClass);
    }
}

