/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.heapwalk.details.jdk.ui;

import java.awt.Component;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToggleButton;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.jdk.ui.BaseBuilders;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.jdk.ui.ComponentBuilders;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.jdk.ui.Utils;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.spi.DetailsUtils;

final class ButtonBuilders {
    ButtonBuilders() {
    }

    static ComponentBuilders.ComponentBuilder getBuilder(Instance instance) {
        if (DetailsUtils.isSubclassOf(instance, JButton.class.getName())) {
            return new JButtonBuilder(instance);
        }
        if (DetailsUtils.isSubclassOf(instance, JCheckBox.class.getName())) {
            return new JCheckBoxBuilder(instance);
        }
        if (DetailsUtils.isSubclassOf(instance, JRadioButton.class.getName())) {
            return new JRadioButtonBuilder(instance);
        }
        if (DetailsUtils.isSubclassOf(instance, JToggleButton.class.getName())) {
            return new JToggleButtonBuilder(instance);
        }
        if (DetailsUtils.isSubclassOf(instance, JCheckBoxMenuItem.class.getName())) {
            return new JCheckBoxMenuItemBuilder(instance);
        }
        if (DetailsUtils.isSubclassOf(instance, JRadioButtonMenuItem.class.getName())) {
            return new JRadioButtonMenuItemBuilder(instance);
        }
        if (DetailsUtils.isSubclassOf(instance, JMenu.class.getName())) {
            return new JMenuBuilder(instance);
        }
        if (DetailsUtils.isSubclassOf(instance, JMenuBar.class.getName())) {
            return new JMenuBarBuilder(instance);
        }
        if (DetailsUtils.isSubclassOf(instance, JMenuItem.class.getName())) {
            return new JMenuItemBuilder(instance);
        }
        return null;
    }

    private static class JMenuBarBuilder
    extends ComponentBuilders.JComponentBuilder<JMenuBar> {
        private final boolean paintBorder;
        private final BaseBuilders.InsetsBuilder margin;

        JMenuBarBuilder(Instance instance) {
            super(instance);
            this.paintBorder = DetailsUtils.getBooleanFieldValue(instance, "paintBorder", true);
            this.margin = BaseBuilders.InsetsBuilder.fromField(instance, "margin");
        }

        @Override
        protected void setupInstance(JMenuBar instance) {
            super.setupInstance(instance);
            instance.setBorderPainted(this.paintBorder);
            if (this.margin != null) {
                instance.setMargin((Insets)this.margin.createInstance());
            }
        }

        @Override
        protected JMenuBar createInstanceImpl() {
            return new JMenuBar();
        }
    }

    private static class JMenuBuilder
    extends JMenuItemBuilder {
        JMenuBuilder(Instance instance) {
            super(instance);
        }

        @Override
        protected JMenuItem createInstanceImpl() {
            return new JMenu();
        }

        @Override
        protected Component createPresenterImpl(JMenuItem instance) {
            JMenuBar menuBar = new JMenuBar();
            menuBar.add(instance);
            return menuBar;
        }
    }

    private static class JRadioButtonMenuItemBuilder
    extends JMenuItemBuilder {
        JRadioButtonMenuItemBuilder(Instance instance) {
            super(instance);
        }

        @Override
        protected JMenuItem createInstanceImpl() {
            return new JRadioButtonMenuItem();
        }
    }

    private static class JCheckBoxMenuItemBuilder
    extends JMenuItemBuilder {
        JCheckBoxMenuItemBuilder(Instance instance) {
            super(instance);
        }

        @Override
        protected JMenuItem createInstanceImpl() {
            return new JCheckBoxMenuItem();
        }
    }

    private static class JMenuItemBuilder
    extends AbstractButtonBuilder<JMenuItem> {
        JMenuItemBuilder(Instance instance) {
            super(instance, true);
        }

        @Override
        protected JMenuItem createInstanceImpl() {
            return new JMenuItem();
        }

        @Override
        protected Component createPresenterImpl(JMenuItem instance) {
            Utils.JPopupMenuImpl popupMenu = new Utils.JPopupMenuImpl();
            popupMenu.add(instance);
            return popupMenu;
        }
    }

    private static class JRadioButtonBuilder
    extends JToggleButtonBuilder {
        JRadioButtonBuilder(Instance instance) {
            super(instance);
        }

        @Override
        protected JToggleButton createInstanceImpl() {
            return new JRadioButton();
        }
    }

    private static class JCheckBoxBuilder
    extends JToggleButtonBuilder {
        private final boolean flat;

        JCheckBoxBuilder(Instance instance) {
            super(instance);
            this.flat = DetailsUtils.getBooleanFieldValue(instance, "flat", false);
        }

        @Override
        protected JToggleButton createInstanceImpl() {
            JCheckBox checkBox = new JCheckBox();
            checkBox.setBorderPaintedFlat(this.flat);
            return checkBox;
        }
    }

    private static class JToggleButtonBuilder
    extends AbstractButtonBuilder<JToggleButton> {
        JToggleButtonBuilder(Instance instance) {
            super(instance);
        }

        @Override
        protected JToggleButton createInstanceImpl() {
            return new JToggleButton();
        }
    }

    private static final class JButtonBuilder
    extends AbstractButtonBuilder<JButton> {
        JButtonBuilder(Instance instance) {
            super(instance);
        }

        @Override
        protected JButton createInstanceImpl() {
            return new JButton();
        }
    }

    private static abstract class AbstractButtonBuilder<T extends AbstractButton>
    extends ComponentBuilders.JComponentBuilder<T> {
        private final DefaultButtonModelBuilder model;
        private final String text;
        private final BaseBuilders.InsetsBuilder margin;
        private final BaseBuilders.IconBuilder defaultIcon;
        private final int verticalAlignment;
        private final boolean borderPaintedSet;
        private final boolean paintBorder;
        private final boolean contentAreaFilledSet;
        private final boolean contentAreaFilled;
        private final int horizontalAlignment;
        private final int verticalTextPosition;
        private final int horizontalTextPosition;
        private final int iconTextGap;

        AbstractButtonBuilder(Instance instance) {
            this(instance, false);
        }

        AbstractButtonBuilder(Instance instance, boolean trackChildren) {
            super(instance, false);
            this.model = DefaultButtonModelBuilder.fromField(instance, "model");
            this.text = Utils.getFieldString(instance, "text");
            this.margin = BaseBuilders.InsetsBuilder.fromField(instance, "margin");
            this.defaultIcon = BaseBuilders.IconBuilder.fromField(instance, "defaultIcon");
            this.borderPaintedSet = DetailsUtils.getBooleanFieldValue(instance, "borderPaintedSet", false);
            this.paintBorder = DetailsUtils.getBooleanFieldValue(instance, "paintBorder", true);
            this.contentAreaFilledSet = DetailsUtils.getBooleanFieldValue(instance, "contentAreaFilledSet", false);
            this.contentAreaFilled = DetailsUtils.getBooleanFieldValue(instance, "contentAreaFilled", true);
            this.verticalAlignment = DetailsUtils.getIntFieldValue(instance, "verticalAlignment", 0);
            this.horizontalAlignment = DetailsUtils.getIntFieldValue(instance, "horizontalAlignment", 10);
            this.verticalTextPosition = DetailsUtils.getIntFieldValue(instance, "verticalTextPosition", 0);
            this.horizontalTextPosition = DetailsUtils.getIntFieldValue(instance, "horizontalTextPosition", 11);
            this.iconTextGap = DetailsUtils.getIntFieldValue(instance, "iconTextGap", 4);
        }

        @Override
        protected void setupInstance(T instance) {
            super.setupInstance(instance);
            if (this.model != null) {
                ((AbstractButton)instance).setModel((ButtonModel)this.model.createInstance());
            }
            ((AbstractButton)instance).setText(this.text);
            if (this.margin != null) {
                ((AbstractButton)instance).setMargin((Insets)this.margin.createInstance());
            }
            if (this.defaultIcon != null) {
                ((AbstractButton)instance).setIcon((Icon)this.defaultIcon.createInstance());
            }
            if (this.borderPaintedSet) {
                ((AbstractButton)instance).setBorderPainted(this.paintBorder);
            }
            if (this.contentAreaFilledSet) {
                ((AbstractButton)instance).setContentAreaFilled(this.contentAreaFilled);
            }
            ((AbstractButton)instance).setVerticalAlignment(this.verticalAlignment);
            ((AbstractButton)instance).setHorizontalAlignment(this.horizontalAlignment);
            ((AbstractButton)instance).setVerticalTextPosition(this.verticalTextPosition);
            ((AbstractButton)instance).setHorizontalTextPosition(this.horizontalTextPosition);
            ((AbstractButton)instance).setIconTextGap(this.iconTextGap);
        }
    }

    private static final class DefaultButtonModelBuilder
    extends Utils.InstanceBuilder<DefaultButtonModel> {
        private final int stateMask;

        DefaultButtonModelBuilder(Instance instance) {
            super(instance);
            this.stateMask = DetailsUtils.getIntFieldValue(instance, "stateMask", 0);
        }

        static DefaultButtonModelBuilder fromField(Instance instance, String field) {
            Object model = instance.getValueOfField(field);
            if (!(model instanceof Instance)) {
                return null;
            }
            if (!DetailsUtils.isSubclassOf((Instance)model, DefaultButtonModel.class.getName())) {
                return null;
            }
            return new DefaultButtonModelBuilder((Instance)model);
        }

        @Override
        protected void setupInstance(DefaultButtonModel instance) {
            super.setupInstance(instance);
            instance.setArmed((this.stateMask & 1) != 0);
            instance.setSelected((this.stateMask & 2) != 0);
            instance.setEnabled((this.stateMask & 8) != 0);
            instance.setPressed((this.stateMask & 4) != 0);
            instance.setRollover((this.stateMask & 0x10) != 0);
        }

        @Override
        protected DefaultButtonModel createInstanceImpl() {
            return new DefaultButtonModel();
        }
    }
}

