/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.jakartaee.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import org.apache.tomcat.jakartaee.bcel.classfile.Attribute;
import org.apache.tomcat.jakartaee.bcel.classfile.CodeException;
import org.apache.tomcat.jakartaee.bcel.classfile.ConstantPool;
import org.apache.tomcat.jakartaee.bcel.classfile.LineNumberTable;
import org.apache.tomcat.jakartaee.bcel.classfile.LocalVariableTable;
import org.apache.tomcat.jakartaee.bcel.classfile.Utility;
import org.apache.tomcat.jakartaee.bcel.classfile.Visitor;
import org.apache.tomcat.jakartaee.commons.lang3.ArrayUtils;

public final class Code
extends Attribute {
    private int maxStack;
    private int maxLocals;
    private byte[] code;
    private CodeException[] exceptionTable;
    private Attribute[] attributes;

    public Code(Code c) {
        this(c.getNameIndex(), c.getLength(), c.getMaxStack(), c.getMaxLocals(), c.getCode(), c.getExceptionTable(), c.getAttributes(), c.getConstantPool());
    }

    Code(int name_index, int length, DataInput file, ConstantPool constant_pool) throws IOException {
        this(name_index, length, file.readUnsignedShort(), file.readUnsignedShort(), null, null, null, constant_pool);
        int code_length = file.readInt();
        this.code = new byte[code_length];
        file.readFully(this.code);
        int exception_table_length = file.readUnsignedShort();
        this.exceptionTable = new CodeException[exception_table_length];
        for (int i = 0; i < exception_table_length; ++i) {
            this.exceptionTable[i] = new CodeException(file);
        }
        int attributes_count = file.readUnsignedShort();
        this.attributes = new Attribute[attributes_count];
        for (int i = 0; i < attributes_count; ++i) {
            this.attributes[i] = Attribute.readAttribute(file, constant_pool);
        }
        super.setLength(length);
    }

    public Code(int name_index, int length, int maxStack, int maxLocals, byte[] code, CodeException[] exceptionTable, Attribute[] attributes, ConstantPool constant_pool) {
        super((byte)2, name_index, length, constant_pool);
        this.maxStack = maxStack;
        this.maxLocals = maxLocals;
        this.code = code != null ? code : ArrayUtils.EMPTY_BYTE_ARRAY;
        this.exceptionTable = exceptionTable != null ? exceptionTable : CodeException.EMPTY_CODE_EXCEPTION_ARRAY;
        this.attributes = attributes != null ? attributes : EMPTY_ARRAY;
        super.setLength(this.calculateLength());
    }

    @Override
    public void accept(Visitor v) {
        v.visitCode(this);
    }

    private int calculateLength() {
        int len = 0;
        if (this.attributes != null) {
            for (Attribute attribute : this.attributes) {
                len += attribute.getLength() + 6;
            }
        }
        return len + this.getInternalLength();
    }

    @Override
    public Attribute copy(ConstantPool constantPool) {
        Code c = (Code)this.clone();
        if (this.code != null) {
            c.code = new byte[this.code.length];
            System.arraycopy(this.code, 0, c.code, 0, this.code.length);
        }
        c.setConstantPool(constantPool);
        c.exceptionTable = new CodeException[this.exceptionTable.length];
        Arrays.setAll(c.exceptionTable, i -> this.exceptionTable[i].copy());
        c.attributes = new Attribute[this.attributes.length];
        Arrays.setAll(c.attributes, i -> this.attributes[i].copy(constantPool));
        return c;
    }

    @Override
    public void dump(DataOutputStream file) throws IOException {
        super.dump(file);
        file.writeShort(this.maxStack);
        file.writeShort(this.maxLocals);
        file.writeInt(this.code.length);
        file.write(this.code, 0, this.code.length);
        file.writeShort(this.exceptionTable.length);
        for (CodeException codeException : this.exceptionTable) {
            codeException.dump(file);
        }
        file.writeShort(this.attributes.length);
        for (Cloneable cloneable : this.attributes) {
            ((Attribute)cloneable).dump(file);
        }
    }

    public Attribute[] getAttributes() {
        return this.attributes;
    }

    public byte[] getCode() {
        return this.code;
    }

    public CodeException[] getExceptionTable() {
        return this.exceptionTable;
    }

    private int getInternalLength() {
        return 8 + this.code.length + 2 + 8 * (this.exceptionTable == null ? 0 : this.exceptionTable.length) + 2;
    }

    public LineNumberTable getLineNumberTable() {
        for (Attribute attribute : this.attributes) {
            if (!(attribute instanceof LineNumberTable)) continue;
            return (LineNumberTable)attribute;
        }
        return null;
    }

    public LocalVariableTable getLocalVariableTable() {
        for (Attribute attribute : this.attributes) {
            if (!(attribute instanceof LocalVariableTable)) continue;
            return (LocalVariableTable)attribute;
        }
        return null;
    }

    public int getMaxLocals() {
        return this.maxLocals;
    }

    public int getMaxStack() {
        return this.maxStack;
    }

    public void setAttributes(Attribute[] attributes) {
        this.attributes = attributes != null ? attributes : EMPTY_ARRAY;
        super.setLength(this.calculateLength());
    }

    public void setCode(byte[] code) {
        this.code = code != null ? code : ArrayUtils.EMPTY_BYTE_ARRAY;
        super.setLength(this.calculateLength());
    }

    public void setExceptionTable(CodeException[] exceptionTable) {
        this.exceptionTable = exceptionTable != null ? exceptionTable : CodeException.EMPTY_CODE_EXCEPTION_ARRAY;
        super.setLength(this.calculateLength());
    }

    public void setMaxLocals(int maxLocals) {
        this.maxLocals = maxLocals;
    }

    public void setMaxStack(int maxStack) {
        this.maxStack = maxStack;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean verbose) {
        StringBuilder buf = new StringBuilder(100);
        buf.append("Code(maxStack = ").append(this.maxStack).append(", maxLocals = ").append(this.maxLocals).append(", code_length = ").append(this.code.length).append(")\n").append(Utility.codeToString(this.code, super.getConstantPool(), 0, -1, verbose));
        if (this.exceptionTable.length > 0) {
            buf.append("\nException handler(s) = \n").append("From\tTo\tHandler\tType\n");
            for (Cloneable cloneable : this.exceptionTable) {
                buf.append(((CodeException)cloneable).toString(super.getConstantPool(), verbose)).append("\n");
            }
        }
        if (this.attributes.length > 0) {
            buf.append("\nAttribute(s) = ");
            for (Cloneable cloneable : this.attributes) {
                buf.append("\n").append(((Attribute)cloneable).getName()).append(":");
                buf.append("\n").append(cloneable);
            }
        }
        return buf.toString();
    }
}

