/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.im;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.TextHitInfo;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.awt.im.InputMethodRequests;
import java.text.AttributedCharacterIterator;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import sun.awt.im.CompositionAreaHandler;
import sun.awt.im.InputContext;
import sun.awt.im.InputMethodContext;
import sun.awt.im.InputMethodWindow;

public final class CompositionArea
extends JPanel
implements InputMethodListener {
    private CompositionAreaHandler handler;
    private TextLayout composedTextLayout;
    private TextHitInfo caret = null;
    private JFrame compositionWindow;
    private static final int TEXT_ORIGIN_X = 5;
    private static final int TEXT_ORIGIN_Y = 15;
    private static final int PASSIVE_WIDTH = 480;
    private static final int WIDTH_MARGIN = 10;
    private static final int HEIGHT_MARGIN = 3;
    private static final long serialVersionUID = -1057247068746557444L;

    CompositionArea() {
        String string = Toolkit.getProperty("AWT.CompositionWindowTitle", "Input Window");
        this.compositionWindow = (JFrame)InputMethodContext.createInputMethodWindow(string, null, true);
        this.setOpaque(true);
        this.setBorder(LineBorder.createGrayLineBorder());
        this.setForeground(Color.black);
        this.setBackground(Color.white);
        this.enableInputMethods(true);
        this.enableEvents(8L);
        this.compositionWindow.getContentPane().add(this);
        this.compositionWindow.addWindowListener(new FrameWindowAdapter());
        this.addInputMethodListener(this);
        this.compositionWindow.enableInputMethods(false);
        this.compositionWindow.pack();
        Dimension dimension = this.compositionWindow.getSize();
        Dimension dimension2 = this.getToolkit().getScreenSize();
        this.compositionWindow.setLocation(dimension2.width - dimension.width - 20, dimension2.height - dimension.height - 100);
        this.compositionWindow.setVisible(false);
    }

    synchronized void setHandlerInfo(CompositionAreaHandler compositionAreaHandler, InputContext inputContext) {
        this.handler = compositionAreaHandler;
        ((InputMethodWindow)((Object)this.compositionWindow)).setInputContext(inputContext);
    }

    @Override
    public InputMethodRequests getInputMethodRequests() {
        return this.handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Rectangle getCaretRectangle(TextHitInfo textHitInfo) {
        int n = 0;
        TextLayout textLayout = this.composedTextLayout;
        if (textLayout != null) {
            n = Math.round(textLayout.getCaretInfo(textHitInfo)[0]);
        }
        Graphics graphics = this.getGraphics();
        FontMetrics fontMetrics = null;
        try {
            fontMetrics = graphics.getFontMetrics();
        }
        finally {
            graphics.dispose();
        }
        return new Rectangle(5 + n, 15 - fontMetrics.getAscent(), 0, fontMetrics.getAscent() + fontMetrics.getDescent());
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        graphics.setColor(this.getForeground());
        TextLayout textLayout = this.composedTextLayout;
        if (textLayout != null) {
            textLayout.draw((Graphics2D)graphics, 5.0f, 15.0f);
        }
        if (this.caret != null) {
            Rectangle rectangle = this.getCaretRectangle(this.caret);
            graphics.setXORMode(this.getBackground());
            graphics.fillRect(rectangle.x, rectangle.y, 1, rectangle.height);
            graphics.setPaintMode();
        }
    }

    void setCompositionAreaVisible(boolean bl) {
        this.compositionWindow.setVisible(bl);
    }

    boolean isCompositionAreaVisible() {
        return this.compositionWindow.isVisible();
    }

    @Override
    public void inputMethodTextChanged(InputMethodEvent inputMethodEvent) {
        this.handler.inputMethodTextChanged(inputMethodEvent);
    }

    @Override
    public void caretPositionChanged(InputMethodEvent inputMethodEvent) {
        this.handler.caretPositionChanged(inputMethodEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setText(AttributedCharacterIterator attributedCharacterIterator, TextHitInfo textHitInfo) {
        this.composedTextLayout = null;
        if (attributedCharacterIterator == null) {
            this.compositionWindow.setVisible(false);
            this.caret = null;
        } else {
            Graphics graphics;
            if (!this.compositionWindow.isVisible()) {
                this.compositionWindow.setVisible(true);
            }
            if ((graphics = this.getGraphics()) == null) {
                return;
            }
            try {
                this.updateWindowLocation();
                FontRenderContext fontRenderContext = ((Graphics2D)graphics).getFontRenderContext();
                this.composedTextLayout = new TextLayout(attributedCharacterIterator, fontRenderContext);
                Rectangle2D rectangle2D = this.composedTextLayout.getBounds();
                this.caret = textHitInfo;
                FontMetrics fontMetrics = graphics.getFontMetrics();
                Rectangle2D rectangle2D2 = fontMetrics.getMaxCharBounds(graphics);
                int n = (int)rectangle2D2.getHeight() + 3;
                int n2 = n + this.compositionWindow.getInsets().top + this.compositionWindow.getInsets().bottom;
                InputMethodRequests inputMethodRequests = this.handler.getClientInputMethodRequests();
                int n3 = inputMethodRequests == null ? 480 : (int)rectangle2D.getWidth() + 10;
                int n4 = n3 + this.compositionWindow.getInsets().left + this.compositionWindow.getInsets().right;
                this.setPreferredSize(new Dimension(n3, n));
                this.compositionWindow.setSize(new Dimension(n4, n2));
                this.paint(graphics);
            }
            finally {
                graphics.dispose();
            }
        }
    }

    void setCaret(TextHitInfo textHitInfo) {
        this.caret = textHitInfo;
        if (this.compositionWindow.isVisible()) {
            Graphics graphics = this.getGraphics();
            try {
                this.paint(graphics);
            }
            finally {
                graphics.dispose();
            }
        }
    }

    void updateWindowLocation() {
        InputMethodRequests inputMethodRequests = this.handler.getClientInputMethodRequests();
        if (inputMethodRequests == null) {
            return;
        }
        Point point = new Point();
        Rectangle rectangle = inputMethodRequests.getTextLocation(null);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.compositionWindow.getSize();
        point.x = rectangle.x + dimension2.width > dimension.width ? dimension.width - dimension2.width : rectangle.x;
        point.y = rectangle.y + rectangle.height + 2 + dimension2.height > dimension.height ? rectangle.y - 2 - dimension2.height : rectangle.y + rectangle.height + 2;
        this.compositionWindow.setLocation(point);
    }

    Rectangle getTextLocation(TextHitInfo textHitInfo) {
        Rectangle rectangle = this.getCaretRectangle(textHitInfo);
        Point point = this.getLocationOnScreen();
        rectangle.translate(point.x, point.y);
        return rectangle;
    }

    TextHitInfo getLocationOffset(int n, int n2) {
        TextLayout textLayout = this.composedTextLayout;
        if (textLayout == null) {
            return null;
        }
        Point point = this.getLocationOnScreen();
        if (textLayout.getBounds().contains(n -= point.x + 5, n2 -= point.y + 15)) {
            return textLayout.hitTestChar(n, n2);
        }
        return null;
    }

    void setCompositionAreaUndecorated(boolean bl) {
        if (this.compositionWindow.isDisplayable()) {
            this.compositionWindow.removeNotify();
        }
        this.compositionWindow.setUndecorated(bl);
        this.compositionWindow.pack();
    }

    class FrameWindowAdapter
    extends WindowAdapter {
        FrameWindowAdapter() {
        }

        @Override
        public void windowActivated(WindowEvent windowEvent) {
            CompositionArea.this.requestFocus();
        }
    }
}

