/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5;

import sun.security.krb5.Checksum;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.internal.KDCRep;
import sun.security.krb5.internal.KDCReq;
import sun.security.krb5.internal.Krb5;
import sun.security.krb5.internal.KrbApErrException;
import sun.security.krb5.internal.PAData;
import sun.security.util.DerInputStream;

abstract class KrbKdcRep {
    KrbKdcRep() {
    }

    static void check(boolean bl, KDCReq kDCReq, KDCRep kDCRep, EncryptionKey encryptionKey) throws KrbApErrException {
        int n;
        if (bl && !kDCReq.reqBody.cname.equals(kDCRep.cname) && (!kDCReq.reqBody.kdcOptions.get(15) && kDCReq.reqBody.cname.getNameType() != 10 || !kDCRep.encKDCRepPart.flags.get(15))) {
            kDCRep.encKDCRepPart.key.destroy();
            throw new KrbApErrException(41);
        }
        if (!kDCReq.reqBody.sname.equals(kDCRep.encKDCRepPart.sname)) {
            String[] stringArray = kDCRep.encKDCRepPart.sname.getNameStrings();
            if (bl || !kDCReq.reqBody.kdcOptions.get(15) || stringArray == null || stringArray.length != 2 || !stringArray[0].equals("krbtgt") || !kDCRep.encKDCRepPart.sname.getRealmString().equals(kDCReq.reqBody.sname.getRealmString())) {
                kDCRep.encKDCRepPart.key.destroy();
                throw new KrbApErrException(41);
            }
        }
        if (kDCReq.reqBody.getNonce() != kDCRep.encKDCRepPart.nonce) {
            kDCRep.encKDCRepPart.key.destroy();
            throw new KrbApErrException(41);
        }
        if (kDCReq.reqBody.addresses != null && kDCRep.encKDCRepPart.caddr != null && !kDCReq.reqBody.addresses.equals(kDCRep.encKDCRepPart.caddr)) {
            kDCRep.encKDCRepPart.key.destroy();
            throw new KrbApErrException(41);
        }
        for (n = 2; n < 6; ++n) {
            if (kDCReq.reqBody.kdcOptions.get(n) == kDCRep.encKDCRepPart.flags.get(n)) continue;
            if (Krb5.DEBUG) {
                System.out.println("> KrbKdcRep.check: at #" + n + ". request for " + kDCReq.reqBody.kdcOptions.get(n) + ", received " + kDCRep.encKDCRepPart.flags.get(n));
            }
            throw new KrbApErrException(41);
        }
        if (kDCReq.reqBody.kdcOptions.get(8) && !kDCRep.encKDCRepPart.flags.get(8)) {
            throw new KrbApErrException(41);
        }
        if ((kDCReq.reqBody.from == null || kDCReq.reqBody.from.isZero()) && kDCRep.encKDCRepPart.starttime != null && !kDCRep.encKDCRepPart.starttime.inClockSkew()) {
            kDCRep.encKDCRepPart.key.destroy();
            throw new KrbApErrException(37);
        }
        if (kDCReq.reqBody.from != null && !kDCReq.reqBody.from.isZero() && kDCRep.encKDCRepPart.starttime != null && !kDCReq.reqBody.from.equals(kDCRep.encKDCRepPart.starttime)) {
            kDCRep.encKDCRepPart.key.destroy();
            throw new KrbApErrException(41);
        }
        if (!kDCReq.reqBody.till.isZero() && kDCRep.encKDCRepPart.endtime.greaterThan(kDCReq.reqBody.till)) {
            kDCRep.encKDCRepPart.key.destroy();
            throw new KrbApErrException(41);
        }
        if (kDCRep.encKDCRepPart.flags.get(15)) {
            n = 0;
            boolean bl2 = false;
            if (kDCReq.pAData != null) {
                for (PAData pAData : kDCReq.pAData) {
                    if (pAData.getType() != 149) continue;
                    n = 1;
                    break;
                }
            }
            if (kDCRep.encKDCRepPart.pAData != null) {
                for (PAData pAData : kDCRep.encKDCRepPart.pAData) {
                    if (pAData.getType() != 149) continue;
                    try {
                        Checksum checksum = new Checksum(new DerInputStream(pAData.getValue()).getDerValue());
                        bl2 = checksum.verifyAnyChecksum(kDCReq.asn1Encode(), encryptionKey, 56);
                    }
                    catch (Exception exception) {
                        if (!Krb5.DEBUG) break;
                        exception.printStackTrace();
                    }
                    break;
                }
            }
            if (n != 0 && !bl2) {
                throw new KrbApErrException(41);
            }
        }
        if (kDCReq.reqBody.kdcOptions.get(8) && kDCReq.reqBody.rtime != null && !kDCReq.reqBody.rtime.isZero() && (kDCRep.encKDCRepPart.renewTill == null || kDCRep.encKDCRepPart.renewTill.greaterThan(kDCReq.reqBody.rtime))) {
            kDCRep.encKDCRepPart.key.destroy();
            throw new KrbApErrException(41);
        }
    }
}

