/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.internal.util;

import java.util.Objects;
import org.openjdk.jmc.common.IMCFrame;
import org.openjdk.jmc.flightrecorder.internal.InvalidJfrFileException;

public final class ParserToolkit {
    private ParserToolkit() {
        throw new Error("Don't");
    }

    public static <T> T get(T[] elements, int index) throws InvalidJfrFileException {
        if (index < 0 || index >= elements.length) {
            throw new InvalidJfrFileException();
        }
        return elements[index];
    }

    public static void assertValue(long value, long accepted) throws InvalidJfrFileException {
        if (value != accepted) {
            throw new InvalidJfrFileException(value + " is not the expected value " + accepted);
        }
    }

    public static void assertValue(Object value, Object accepted) throws InvalidJfrFileException {
        if (!Objects.equals(value, accepted)) {
            throw new InvalidJfrFileException(value + " is not the expected value " + accepted);
        }
    }

    public static void assertValue(Object value, Object ... accepted) throws InvalidJfrFileException {
        for (Object a : accepted) {
            if (!Objects.equals(a, value)) continue;
            return;
        }
        throw new InvalidJfrFileException(value + " is not among the expected values");
    }

    public static IMCFrame.Type parseFrameType(String type) {
        if ("Interpreted".equals(type)) {
            return IMCFrame.Type.INTERPRETED;
        }
        if ("JIT compiled".equals(type)) {
            return IMCFrame.Type.JIT_COMPILED;
        }
        if ("Inlined".equals(type)) {
            return IMCFrame.Type.INLINED;
        }
        if ("Native".equals(type)) {
            return IMCFrame.Type.NATIVE;
        }
        if ("C++".equals(type)) {
            return IMCFrame.Type.CPP;
        }
        if ("Kernel".equals(type)) {
            return IMCFrame.Type.KERNEL;
        }
        return IMCFrame.Type.UNKNOWN;
    }
}

