/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jfr.views.threads;

import javax.swing.ImageIcon;
import org.graalvm.visualvm.core.ui.components.DataViewComponent;
import org.graalvm.visualvm.jfr.JFRSnapshot;
import org.graalvm.visualvm.jfr.model.JFRModel;
import org.graalvm.visualvm.jfr.view.JFRViewTab;
import org.graalvm.visualvm.jfr.views.threads.ThreadsViewSupport;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

class JFRSnapshotThreadsView
extends JFRViewTab {
    private static final String IMAGE_PATH = "org/graalvm/visualvm/jfr/resources/threads.png";

    JFRSnapshotThreadsView(JFRSnapshot dataSource) {
        super(dataSource, NbBundle.getMessage(JFRSnapshotThreadsView.class, (String)"LBL_Threads"), new ImageIcon(ImageUtilities.loadImage((String)IMAGE_PATH, (boolean)true)).getImage(), 20);
    }

    @Override
    protected DataViewComponent createComponent() {
        JFRModel model = this.getModel();
        final ThreadsViewSupport.TimelineViewSupport timelineView = new ThreadsViewSupport.TimelineViewSupport(model);
        ThreadsViewSupport.MasterViewSupport masterView = new ThreadsViewSupport.MasterViewSupport(model){

            @Override
            void firstShown() {
                JFRSnapshotThreadsView.this.initialize(this, timelineView);
            }
        };
        DataViewComponent dvc = new DataViewComponent(masterView.getMasterView(), new DataViewComponent.MasterViewConfiguration(model == null));
        if (model != null) {
            dvc.configureDetailsArea(new DataViewComponent.DetailsAreaConfiguration(NbBundle.getMessage(JFRSnapshotThreadsView.class, (String)"LBL_Threads_visualization"), true), 1);
            dvc.addDetailsView(timelineView.getDetailsView(), 1);
        }
        return dvc;
    }

    private void initialize(final ThreadsViewSupport.MasterViewSupport masterView, final ThreadsViewSupport.TimelineViewSupport timelineView) {
        new RequestProcessor("JFR Threads Initializer").post(new Runnable(){

            @Override
            public void run() {
                JFRSnapshotThreadsView.this.getModel().visitEvents(timelineView);
                masterView.initialized(timelineView.getActiveTypes(), timelineView.getThreadsCount());
            }
        });
    }
}

