/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.servlet.ServletException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.UDecoder;

public class SSLValve
extends ValveBase {
    private static final Log log = LogFactory.getLog(SSLValve.class);
    private String sslClientCertHeader = "ssl_client_cert";
    private String sslClientEscapedCertHeader = "ssl_client_escaped_cert";
    private String sslCipherHeader = "ssl_cipher";
    private String sslSessionIdHeader = "ssl_session_id";
    private String sslCipherUserKeySizeHeader = "ssl_cipher_usekeysize";

    public SSLValve() {
        super(true);
    }

    public String getSslClientCertHeader() {
        return this.sslClientCertHeader;
    }

    public void setSslClientCertHeader(String string) {
        this.sslClientCertHeader = string;
    }

    public String getSslClientEscapedCertHeader() {
        return this.sslClientEscapedCertHeader;
    }

    public void setSslClientEscapedCertHeader(String string) {
        this.sslClientEscapedCertHeader = string;
    }

    public String getSslCipherHeader() {
        return this.sslCipherHeader;
    }

    public void setSslCipherHeader(String string) {
        this.sslCipherHeader = string;
    }

    public String getSslSessionIdHeader() {
        return this.sslSessionIdHeader;
    }

    public void setSslSessionIdHeader(String string) {
        this.sslSessionIdHeader = string;
    }

    public String getSslCipherUserKeySizeHeader() {
        return this.sslCipherUserKeySizeHeader;
    }

    public void setSslCipherUserKeySizeHeader(String string) {
        this.sslCipherUserKeySizeHeader = string;
    }

    public String mygetHeader(Request request, String string) {
        String string2 = request.getHeader(string);
        if (string2 == null) {
            return null;
        }
        if ("(null)".equals(string2)) {
            return null;
        }
        return string2;
    }

    @Override
    public void invoke(Request request, Response response) throws IOException, ServletException {
        String string = this.mygetHeader(request, this.sslClientEscapedCertHeader);
        String string2 = string != null ? UDecoder.URLDecode((String)string, (Charset)StandardCharsets.ISO_8859_1) : this.mygetHeader(request, this.sslClientCertHeader);
        if (string2 != null && (string2 = string2.trim()).length() > 27) {
            String string3 = string2.substring(27, string2.length() - 25);
            string3 = string3.replace(' ', '\n');
            string3 = string3.replace('\t', '\n');
            String string4 = "-----BEGIN CERTIFICATE-----\n";
            String string5 = "\n-----END CERTIFICATE-----\n";
            String string6 = string4.concat(string3).concat(string5);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string6.getBytes(StandardCharsets.ISO_8859_1));
            X509Certificate[] x509CertificateArray = null;
            String string7 = (String)request.getConnector().getProperty("clientCertProvider");
            try {
                CertificateFactory certificateFactory = string7 == null ? CertificateFactory.getInstance("X.509") : CertificateFactory.getInstance("X.509", string7);
                X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
                x509CertificateArray = new X509Certificate[]{x509Certificate};
            }
            catch (CertificateException certificateException) {
                log.warn((Object)sm.getString("sslValve.certError", new Object[]{string6}), (Throwable)certificateException);
            }
            catch (NoSuchProviderException noSuchProviderException) {
                log.error((Object)sm.getString("sslValve.invalidProvider", new Object[]{string7}), (Throwable)noSuchProviderException);
            }
            request.setAttribute("javax.servlet.request.X509Certificate", x509CertificateArray);
        }
        if ((string2 = this.mygetHeader(request, this.sslCipherHeader)) != null) {
            request.setAttribute("javax.servlet.request.cipher_suite", string2);
        }
        if ((string2 = this.mygetHeader(request, this.sslSessionIdHeader)) != null) {
            request.setAttribute("javax.servlet.request.ssl_session_id", string2);
        }
        if ((string2 = this.mygetHeader(request, this.sslCipherUserKeySizeHeader)) != null) {
            request.setAttribute("javax.servlet.request.key_size", Integer.valueOf(string2));
        }
        this.getNext().invoke(request, response);
    }
}

