/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.HashMap;
import java.util.stream.Stream;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.env.IBinaryAnnotation;
import org.eclipse.jdt.internal.compiler.env.IBinaryModule;
import org.eclipse.jdt.internal.compiler.env.IModule;
import org.eclipse.jdt.internal.compiler.env.IModuleAwareNameEnvironment;
import org.eclipse.jdt.internal.compiler.env.IUpdatableModule;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.ModuleBinding;
import org.eclipse.jdt.internal.compiler.lookup.PlainPackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class BinaryModuleBinding
extends ModuleBinding {
    private IModule.IPackageExport[] unresolvedExports;
    private IModule.IPackageExport[] unresolvedOpens;
    private char[][] unresolvedUses;
    private IModule.IService[] unresolvedProvides;

    public static ModuleBinding create(IModule iModule, LookupEnvironment lookupEnvironment) {
        if (iModule.isAutomatic()) {
            return new AutomaticModuleBinding(iModule, lookupEnvironment);
        }
        return new BinaryModuleBinding((IBinaryModule)iModule, lookupEnvironment);
    }

    private BinaryModuleBinding(IBinaryModule iBinaryModule, LookupEnvironment lookupEnvironment) {
        super(iBinaryModule.name(), lookupEnvironment);
        lookupEnvironment.root.knownModules.put(this.moduleName, this);
        this.cachePartsFrom(iBinaryModule);
    }

    void cachePartsFrom(IBinaryModule iBinaryModule) {
        if (iBinaryModule.isOpen()) {
            this.modifiers |= 0x20;
        }
        this.tagBits |= iBinaryModule.getTagBits();
        IModule.IModuleReference[] iModuleReferenceArray = iBinaryModule.requires();
        this.requires = new ModuleBinding[iModuleReferenceArray.length];
        this.requiresTransitive = new ModuleBinding[iModuleReferenceArray.length];
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < iModuleReferenceArray.length; ++i) {
            ModuleBinding moduleBinding = this.environment.getModule(iModuleReferenceArray[i].name());
            if (moduleBinding == null) continue;
            this.requires[n++] = moduleBinding;
            if (!iModuleReferenceArray[i].isTransitive()) continue;
            this.requiresTransitive[n2++] = moduleBinding;
        }
        if (n < this.requires.length) {
            this.requires = new ModuleBinding[n];
            System.arraycopy(this.requires, 0, this.requires, 0, n);
        }
        if (n2 < this.requiresTransitive.length) {
            this.requiresTransitive = new ModuleBinding[n2];
            System.arraycopy(this.requiresTransitive, 0, this.requiresTransitive, 0, n2);
        }
        this.unresolvedExports = iBinaryModule.exports();
        this.unresolvedOpens = iBinaryModule.opens();
        this.unresolvedUses = iBinaryModule.uses();
        this.unresolvedProvides = iBinaryModule.provides();
        if (this.environment.globalOptions.isAnnotationBasedNullAnalysisEnabled) {
            this.scanForNullDefaultAnnotation(iBinaryModule);
        }
        if ((this.tagBits & 0x400000000000L) != 0L || this.environment.globalOptions.storeAnnotations) {
            this.setAnnotations(BinaryTypeBinding.createAnnotations(iBinaryModule.getAnnotations(), this.environment, null), true);
        }
    }

    private void scanForNullDefaultAnnotation(IBinaryModule iBinaryModule) {
        char[][] cArray = this.environment.getNonNullByDefaultAnnotationName();
        if (cArray == null) {
            return;
        }
        IBinaryAnnotation[] iBinaryAnnotationArray = iBinaryModule.getAnnotations();
        if (iBinaryAnnotationArray != null) {
            int n = 0;
            int n2 = iBinaryAnnotationArray.length;
            for (int i = 0; i < n2; ++i) {
                int n3;
                char[] cArray2 = iBinaryAnnotationArray[i].getTypeName();
                if (cArray2[0] != 'L' || (n3 = this.environment.getNullAnnotationBit(BinaryTypeBinding.signature2qualifiedTypeName(cArray2))) != 128) continue;
                n |= BinaryTypeBinding.getNonNullByDefaultValue(iBinaryAnnotationArray[i], this.environment);
            }
            this.defaultNullness = n;
        }
    }

    @Override
    public PlainPackageBinding[] getExports() {
        if (this.exportedPackages == null && this.unresolvedExports != null) {
            this.resolvePackages();
        }
        return super.getExports();
    }

    @Override
    public PlainPackageBinding[] getOpens() {
        if (this.openedPackages == null && this.unresolvedOpens != null) {
            this.resolvePackages();
        }
        return super.getOpens();
    }

    private void resolvePackages() {
        PlainPackageBinding plainPackageBinding;
        IModule.IPackageExport iPackageExport;
        int n;
        this.exportedPackages = new PlainPackageBinding[this.unresolvedExports.length];
        int n2 = 0;
        for (n = 0; n < this.unresolvedExports.length; ++n) {
            iPackageExport = this.unresolvedExports[n];
            plainPackageBinding = this.getOrCreateDeclaredPackage(CharOperation.splitOn('.', iPackageExport.name()));
            this.exportedPackages[n2++] = plainPackageBinding;
            plainPackageBinding.isExported = Boolean.TRUE;
            this.recordExportRestrictions(plainPackageBinding, iPackageExport.targets());
        }
        if (n2 < this.exportedPackages.length) {
            this.exportedPackages = new PlainPackageBinding[n2];
            System.arraycopy(this.exportedPackages, 0, this.exportedPackages, 0, n2);
        }
        this.openedPackages = new PlainPackageBinding[this.unresolvedOpens.length];
        n2 = 0;
        for (n = 0; n < this.unresolvedOpens.length; ++n) {
            iPackageExport = this.unresolvedOpens[n];
            plainPackageBinding = this.getOrCreateDeclaredPackage(CharOperation.splitOn('.', iPackageExport.name()));
            this.openedPackages[n2++] = plainPackageBinding;
            this.recordOpensRestrictions(plainPackageBinding, iPackageExport.targets());
        }
        if (n2 < this.openedPackages.length) {
            this.openedPackages = new PlainPackageBinding[n2];
            System.arraycopy(this.openedPackages, 0, this.openedPackages, 0, n2);
        }
    }

    @Override
    PlainPackageBinding getDeclaredPackage(char[] cArray) {
        this.getExports();
        this.completeIfNeeded(IUpdatableModule.UpdateKind.PACKAGE);
        return super.getDeclaredPackage(cArray);
    }

    @Override
    public TypeBinding[] getUses() {
        if (this.uses == null) {
            this.uses = new TypeBinding[this.unresolvedUses.length];
            for (int i = 0; i < this.unresolvedUses.length; ++i) {
                this.uses[i] = this.environment.getType(CharOperation.splitOn('.', this.unresolvedUses[i]), this);
            }
        }
        return super.getUses();
    }

    @Override
    public TypeBinding[] getServices() {
        if (this.services == null) {
            this.resolveServices();
        }
        return super.getServices();
    }

    @Override
    public TypeBinding[] getImplementations(TypeBinding typeBinding) {
        if (this.implementations == null) {
            this.resolveServices();
        }
        return super.getImplementations(typeBinding);
    }

    private void resolveServices() {
        this.services = new TypeBinding[this.unresolvedProvides.length];
        this.implementations = new HashMap();
        for (int i = 0; i < this.unresolvedProvides.length; ++i) {
            this.services[i] = this.environment.getType(CharOperation.splitOn('.', this.unresolvedProvides[i].name()), this);
            char[][] cArray = this.unresolvedProvides[i].with();
            TypeBinding[] typeBindingArray = new TypeBinding[cArray.length];
            for (int j = 0; j < cArray.length; ++j) {
                typeBindingArray[j] = this.environment.getType(CharOperation.splitOn('.', cArray[j]), this);
            }
            this.implementations.put(this.services[i], typeBindingArray);
        }
    }

    @Override
    public AnnotationBinding[] getAnnotations() {
        return this.retrieveAnnotations(this);
    }

    private static class AutomaticModuleBinding
    extends ModuleBinding {
        boolean autoNameFromManifest;
        boolean hasScannedPackages;

        public AutomaticModuleBinding(IModule iModule, LookupEnvironment lookupEnvironment) {
            super(iModule.name(), lookupEnvironment);
            lookupEnvironment.root.knownModules.put(this.moduleName, this);
            this.isAuto = true;
            this.autoNameFromManifest = iModule.isAutoNameFromManifest();
            this.requires = Binding.NO_MODULES;
            this.requiresTransitive = Binding.NO_MODULES;
            this.exportedPackages = Binding.NO_PLAIN_PACKAGES;
            this.hasScannedPackages = false;
        }

        @Override
        public boolean hasUnstableAutoName() {
            return !this.autoNameFromManifest;
        }

        @Override
        public ModuleBinding[] getRequiresTransitive() {
            if (this.requiresTransitive == NO_MODULES) {
                char[][] cArray2 = ((IModuleAwareNameEnvironment)this.environment.nameEnvironment).getAllAutomaticModules();
                this.requiresTransitive = (ModuleBinding[])Stream.of(cArray2).filter(cArray -> !CharOperation.equals(cArray, this.moduleName)).map(cArray -> this.environment.getModule((char[])cArray)).filter(moduleBinding -> moduleBinding != null).toArray(ModuleBinding[]::new);
            }
            return this.requiresTransitive;
        }

        @Override
        PlainPackageBinding getDeclaredPackage(char[] cArray) {
            if (!this.hasScannedPackages) {
                for (char[] cArray2 : ((IModuleAwareNameEnvironment)this.environment.nameEnvironment).listPackages(this.nameForCUCheck())) {
                    this.getOrCreateDeclaredPackage(CharOperation.splitOn('.', cArray2));
                }
                this.hasScannedPackages = true;
            }
            return (PlainPackageBinding)this.declaredPackages.get(cArray);
        }

        @Override
        public char[] nameForLookup() {
            return ANY_NAMED;
        }

        @Override
        public char[] nameForCUCheck() {
            return this.moduleName;
        }
    }
}

