/*
 * Copyright (c) 2012, 2019, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class CurrencyNames_bg extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final Object[][] data = new Object[][] {
            { "AED", "AED" },
            { "AFN", "AFN" },
            { "ALL", "ALL" },
            { "AMD", "AMD" },
            { "ANG", "ANG" },
            { "AOA", "AOA" },
            { "ARS", "ARS" },
            { "AUD", "AUD" },
            { "AWG", "AWG" },
            { "AZN", "AZN" },
            { "BAM", "BAM" },
            { "BBD", "BBD" },
            { "BDT", "BDT" },
            { "BGN", "\u043b\u0432." },
            { "BHD", "BHD" },
            { "BIF", "BIF" },
            { "BMD", "BMD" },
            { "BND", "BND" },
            { "BOB", "BOB" },
            { "BRL", "BRL" },
            { "BSD", "BSD" },
            { "BTN", "BTN" },
            { "BWP", "BWP" },
            { "BYR", "BYR" },
            { "BZD", "BZD" },
            { "CAD", "CAD" },
            { "CDF", "CDF" },
            { "CHF", "CHF" },
            { "CLP", "CLP" },
            { "CNY", "CNY" },
            { "COP", "COP" },
            { "CRC", "CRC" },
            { "CUC", "CUC" },
            { "CUP", "CUP" },
            { "CVE", "CVE" },
            { "CZK", "CZK" },
            { "DJF", "DJF" },
            { "DKK", "DKK" },
            { "DOP", "DOP" },
            { "DZD", "DZD" },
            { "EGP", "EGP" },
            { "ERN", "ERN" },
            { "ETB", "ETB" },
            { "FJD", "FJD" },
            { "FKP", "FKP" },
            { "GBP", "GBP" },
            { "GEL", "GEL" },
            { "GHS", "GHS" },
            { "GIP", "GIP" },
            { "GMD", "GMD" },
            { "GNF", "GNF" },
            { "GTQ", "GTQ" },
            { "GYD", "GYD" },
            { "HKD", "HKD" },
            { "HNL", "HNL" },
            { "HRK", "HRK" },
            { "HTG", "HTG" },
            { "HUF", "HUF" },
            { "IDR", "IDR" },
            { "ILS", "ILS" },
            { "INR", "INR" },
            { "IQD", "IQD" },
            { "IRR", "IRR" },
            { "ISK", "ISK" },
            { "JMD", "JMD" },
            { "JOD", "JOD" },
            { "JPY", "JPY" },
            { "KES", "KES" },
            { "KGS", "KGS" },
            { "KHR", "KHR" },
            { "KMF", "KMF" },
            { "KPW", "KPW" },
            { "KRW", "KRW" },
            { "KWD", "KWD" },
            { "KYD", "KYD" },
            { "KZT", "KZT" },
            { "LAK", "LAK" },
            { "LBP", "LBP" },
            { "LKR", "LKR" },
            { "LRD", "LRD" },
            { "LTL", "LTL" },
            { "LVL", "LVL" },
            { "LYD", "LYD" },
            { "MAD", "MAD" },
            { "MDL", "MDL" },
            { "MGA", "MGA" },
            { "MKD", "MKD" },
            { "MMK", "MMK" },
            { "MNT", "MNT" },
            { "MOP", "MOP" },
            { "MRO", "MRO" },
            { "MUR", "MUR" },
            { "MVR", "MVR" },
            { "MWK", "MWK" },
            { "MXN", "MXN" },
            { "MXP", "MXP" },
            { "MXV", "MXV" },
            { "MYR", "MYR" },
            { "MZN", "MZN" },
            { "NAD", "NAD" },
            { "NGN", "NGN" },
            { "NIC", "NIC" },
            { "NIO", "NIO" },
            { "NOK", "NOK" },
            { "NPR", "NPR" },
            { "NZD", "NZD" },
            { "OMR", "OMR" },
            { "PAB", "PAB" },
            { "PEN", "PEN" },
            { "PGK", "PGK" },
            { "PHP", "PHP" },
            { "PKR", "PKR" },
            { "PLN", "PLN" },
            { "PYG", "PYG" },
            { "QAR", "QAR" },
            { "RON", "RON" },
            { "RSD", "RSD" },
            { "RUB", "RUB" },
            { "RWF", "RWF" },
            { "SAR", "SAR" },
            { "SBD", "SBD" },
            { "SCR", "SCR" },
            { "SDG", "SDG" },
            { "SEK", "SEK" },
            { "SGD", "SGD" },
            { "SHP", "SHP" },
            { "SLL", "SLL" },
            { "SOS", "SOS" },
            { "SRD", "SRD" },
            { "SSP", "SSP" },
            { "STD", "STD" },
            { "SVC", "SVC" },
            { "SYP", "SYP" },
            { "SZL", "SZL" },
            { "THB", "THB" },
            { "TJS", "TJS" },
            { "TMT", "TMT" },
            { "TND", "TND" },
            { "TOP", "TOP" },
            { "TRY", "TRY" },
            { "TTD", "TTD" },
            { "TWD", "TWD" },
            { "TZS", "TZS" },
            { "UAH", "UAH" },
            { "UGX", "UGX" },
            { "USD", "\u0449.\u0434." },
            { "USN", "USN" },
            { "USS", "USS" },
            { "UYU", "UYU" },
            { "UZS", "UZS" },
            { "VEF", "VEF" },
            { "VND", "VND" },
            { "VUV", "VUV" },
            { "WST", "WST" },
            { "XCD", "XCD" },
            { "YER", "YER" },
            { "ZAR", "ZAR" },
            { "ZMW", "ZMW" },
            { "adp", "\u0410\u043d\u0434\u043e\u0440\u0441\u043a\u0430 \u043f\u0435\u0441\u0435\u0442\u0430" },
            { "aed", "\u0414\u0438\u0440\u0445\u0430\u043c \u043d\u0430 \u041e\u0431\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0442\u0435 \u0430\u0440\u0430\u0431\u0441\u043a\u0438 \u0435\u043c\u0438\u0440\u0441\u0442\u0432\u0430" },
            { "afa", "\u0410\u0444\u0433\u0430\u043d\u0438\u0441\u0442\u0430\u043d\u0441\u043a\u0438 \u0430\u0444\u0433\u0430\u043d (1927\u20132002)" },
            { "afn", "\u0410\u0444\u0433\u0430\u043d\u0438\u0441\u0442\u0430\u043d\u0441\u043a\u0438 \u0430\u0444\u0433\u0430\u043d" },
            { "all", "\u0410\u043b\u0431\u0430\u043d\u0441\u043a\u0438 \u043b\u0435\u043a" },
            { "amd", "\u0410\u0440\u043c\u0435\u043d\u0441\u043a\u0438 \u0434\u0440\u0430\u043c" },
            { "ang", "\u0410\u043d\u0442\u0438\u043b\u0441\u043a\u0438 \u0433\u0443\u043b\u0434\u0435\u043d" },
            { "aoa", "\u0410\u043d\u0433\u043e\u043b\u0441\u043a\u0430 \u043a\u0432\u0430\u043d\u0437\u0430" },
            { "aok", "\u0410\u043d\u0433\u043e\u043b\u0441\u043a\u0430 \u043a\u0432\u0430\u043d\u0446\u0430 (1977\u20131990)" },
            { "aon", "\u0410\u043d\u0433\u043e\u043b\u0441\u043a\u0430 \u043d\u043e\u0432\u0430 \u043a\u0432\u0430\u043d\u0446\u0430 (1990\u20132000)" },
            { "aor", "\u0410\u043d\u0433\u043e\u043b\u0441\u043a\u0430 \u043d\u043e\u0432\u0430 \u043a\u0432\u0430\u043d\u0446\u0430 (1995\u20131999)" },
            { "ara", "\u0410\u0440\u0436\u0435\u043d\u0442\u0438\u043d\u0441\u043a\u0438 \u0430\u0432\u0441\u0442\u0440\u0430\u043b" },
            { "arp", "\u0410\u0440\u0436\u0435\u043d\u0442\u0438\u043d\u0441\u043a\u043e \u043f\u0435\u0441\u043e (1983\u20131985)" },
            { "ars", "\u0410\u0440\u0436\u0435\u043d\u0442\u0438\u043d\u0441\u043a\u043e \u043f\u0435\u0441\u043e" },
            { "ats", "\u0410\u0432\u0441\u0442\u0440\u0438\u0439\u0441\u043a\u0438 \u0448\u0438\u043b\u0438\u043d\u0433" },
            { "aud", "\u0410\u0432\u0441\u0442\u0440\u0430\u043b\u0438\u0439\u0441\u043a\u0438 \u0434\u043e\u043b\u0430\u0440" },
            { "awg", "\u0410\u0440\u0443\u0431\u0441\u043a\u0438 \u0444\u043b\u043e\u0440\u0438\u043d" },
            { "azm", "\u0410\u0437\u0435\u0440\u0431\u0430\u0439\u0434\u0436\u0430\u043d\u0441\u043a\u0438 \u043c\u0430\u043d\u0430\u0442 (1993\u20132006)" },
            { "azn", "\u0410\u0437\u0435\u0440\u0431\u0430\u0439\u0434\u0436\u0430\u043d\u0441\u043a\u0438 \u043c\u0430\u043d\u0430\u0442" },
            { "bad", "\u0411\u043e\u0441\u043d\u0430 \u0438 \u0425\u0435\u0440\u0446\u0435\u0433\u043e\u0432\u0438\u043d\u0430-\u0434\u0438\u043d\u0430\u0440" },
            { "bam", "\u0411\u043e\u0441\u043d\u0435\u043d\u0441\u043a\u0430 \u043a\u043e\u043d\u0432\u0435\u0440\u0442\u0438\u0440\u0443\u0435\u043c\u0430 \u043c\u0430\u0440\u043a\u0430" },
            { "bbd", "\u0411\u0430\u0440\u0431\u0430\u0434\u043e\u0441\u043a\u0438 \u0434\u043e\u043b\u0430\u0440" },
            { "bdt", "\u0411\u0430\u043d\u0433\u043b\u0430\u0434\u0435\u0448\u043a\u0430 \u0442\u0430\u043a\u0430" },
            { "bec", "\u0411\u0435\u043b\u0433\u0438\u0439\u0441\u043a\u0438 \u0444\u0440\u0430\u043d\u043a (\u043a\u043e\u043d\u0432\u0435\u0440\u0442\u0438\u0440\u0443\u0435\u043c)" },
            { "bef", "\u0411\u0435\u043b\u0433\u0438\u0439\u0441\u043a\u0438 \u0444\u0440\u0430\u043d\u043a" },
            { "bel", "\u0411\u0435\u043b\u0433\u0438\u0439\u0441\u043a\u0438 \u0444\u0440\u0430\u043d\u043a (\u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432)" },
            { "bgl", "\u0411\u044a\u043b\u0433\u0430\u0440\u0441\u043a\u0438 \u043a\u043e\u043d\u0432\u0435\u0440\u0442\u0438\u0440\u0443\u0435\u043c \u043b\u0435\u0432 (1962\u20131999)" },
            { "bgn", "\u0411\u044a\u043b\u0433\u0430\u0440\u0441\u043a\u0438 \u043b\u0435\u0432" },
            { "bhd", "\u0411\u0430\u0445\u0440\u0435\u0439\u043d\u0441\u043a\u0438 \u0434\u0438\u043d\u0430\u0440" },
            { "bif", "\u0411\u0443\u0440\u0443\u043d\u0434\u0438\u0439\u0441\u043a\u0438 \u0444\u0440\u0430\u043d\u043a" },
            { "bmd", "\u0411\u0435\u0440\u043c\u0443\u0434\u0441\u043a\u0438 \u0434\u043e\u043b\u0430\u0440" },
            { "bnd", "\u0411\u0440\u0443\u043d\u0435\u0439\u0441\u043a\u0438 \u0434\u043e\u043b\u0430\u0440" },
            { "bob", "\u0411\u043e\u043b\u0438\u0432\u0438\u0439\u0441\u043a\u043e \u0431\u043e\u043b\u0438\u0432\u0438\u0430\u043d\u043e" },
            { "bop", "\u0411\u043e\u043b\u0438\u0432\u0438\u0439\u0441\u043a\u043e \u043f\u0435\u0441\u043e" },
            { "bov", "\u0411\u043e\u043b\u0438\u0432\u0438\u0439\u0441\u043a\u0438 \u043c\u0432\u0434\u043e\u043b" },
            { "brb", "\u0411\u0440\u0430\u0437\u0438\u043b\u0441\u043a\u043e \u043d\u043e\u0432\u043e \u043a\u0440\u0443\u0437\u0435\u0439\u0440\u043e (1967\u20131986)" },
            { "brc", "\u0411\u0440\u0430\u0437\u0438\u043b\u0441\u043a\u043e \u043a\u0440\u043e\u0437\u0430\u0434\u043e" },
            { "bre", "\u0411\u0440\u0430\u0437\u0438\u043b\u0441\u043a\u043e \u043a\u0440\u0443\u0437\u0435\u0439\u0440\u043e (1990\u20131993)" },
            { "brl", "\u0411\u0440\u0430\u0437\u0438\u043b\u0441\u043a\u0438 \u0440\u0435\u0430\u043b" },
            { "brn", "\u0411\u0440\u0430\u0437\u0438\u043b\u0441\u043a\u043e \u043d\u043e\u0432\u043e \u043a\u0440\u043e\u0437\u0430\u0434\u043e" },
            { "brr", "\u0411\u0440\u0430\u0437\u0438\u043b\u0441\u043a\u043e \u043a\u0440\u0443\u0437\u0435\u0439\u0440\u043e" },
            { "bsd", "\u0411\u0430\u0445\u0430\u043c\u0441\u043a\u0438 \u0434\u043e\u043b\u0430\u0440" },
            { "btn", "\u0411\u0443\u0442\u0430\u043d\u0441\u043a\u0438 \u043d\u0433\u0443\u043b\u0442\u0440\u0443\u043c" },
            { "buk", "\u0411\u0438\u0440\u043c\u0430\u043d\u0441\u043a\u0438 \u043a\u0438\u0430\u0442" },
            { "bwp", "\u0411\u043e\u0442\u0441\u0432\u0430\u043d\u0441\u043a\u0430 \u043f\u0443\u043b\u0430" },
            { "byb", "\u0411\u0435\u043b\u0430\u0440\u0443\u0441\u043a\u0430 \u043d\u043e\u0432\u0430 \u0440\u0443\u0431\u043b\u0430 (1994\u20131999)" },
            { "byr", "\u0411\u0435\u043b\u0430\u0440\u0443\u0441\u043a\u0430 \u0440\u0443\u0431\u043b\u0430" },
            { "bzd", "\u0411\u0435\u043b\u0438\u0437\u0438\u0439\u0441\u043a\u0438 \u0434\u043e\u043b\u0430\u0440" },
            { "cad", "\u041a\u0430\u043d\u0430\u0434\u0441\u043a\u0438 \u0434\u043e\u043b\u0430\u0440" },
            { "cdf", "\u041a\u043e\u043d\u0433\u043e\u0430\u043d\u0441\u043a\u0438 \u0444\u0440\u0430\u043d\u043a" },
            { "che", "WIR \u0435\u0432\u0440\u043e" },
            { "chf", "\u0428\u0432\u0435\u0439\u0446\u0430\u0440\u0441\u043a\u0438 \u0444\u0440\u0430\u043d\u043a" },
            { "chw", "WIR \u0444\u0440\u0430\u043d\u043a" },
            { "clf", "\u0423\u0441\u043b\u043e\u0432\u043d\u0430 \u0440\u0430\u0437\u0447\u0435\u0442\u043d\u0430 \u0435\u0434\u0438\u043d\u0438\u0446\u0430 \u043d\u0430 \u0427\u0438\u043b\u0438" },
            { "clp", "\u0427\u0438\u043b\u0438\u0439\u0441\u043a\u043e \u043f\u0435\u0441\u043e" },
            { "cny", "\u041a\u0438\u0442\u0430\u0439\u0441\u043a\u0438 \u044e\u0430\u043d" },
            { "cop", "\u041a\u043e\u043b\u0443\u043c\u0431\u0438\u0439\u0441\u043a\u043e \u043f\u0435\u0441\u043e" },
            { "cou", "\u041a\u043e\u043b\u0443\u043c\u0431\u0438\u0439\u0441\u043a\u0430 \u0435\u0434\u0438\u043d\u0438\u0446\u0430 \u043d\u0430 \u0440\u0435\u0430\u043b\u043d\u0430\u0442\u0430 \u0441\u0442\u043e\u0439\u043d\u043e\u0441\u0442" },
            { "crc", "\u041a\u043e\u0441\u0442\u0430\u0440\u0438\u043a\u0430\u043d\u0441\u043a\u0438 \u043a\u043e\u043b\u043e\u043d" },
            { "csd", "\u0421\u0442\u0430\u0440 \u0441\u0440\u044a\u0431\u0441\u043a\u0438 \u0434\u0438\u043d\u0430\u0440" },
            { "csk", "\u0427\u0435\u0445\u043e\u0441\u043b\u043e\u0432\u0430\u0448\u043a\u0430 \u043a\u043e\u043d\u0432\u0435\u0440\u0442\u0438\u0440\u0443\u0435\u043c\u0430 \u043a\u0440\u043e\u043d\u0430" },
            { "cuc", "\u041a\u0443\u0431\u0438\u043d\u0441\u043a\u043e \u043a\u043e\u043d\u0432\u0435\u0440\u0442\u0438\u0440\u0443\u0435\u043c\u043e \u043f\u0435\u0441\u043e" },
            { "cup", "\u041a\u0443\u0431\u0438\u043d\u0441\u043a\u043e \u043f\u0435\u0441\u043e" },
            { "cve", "\u0415\u0441\u043a\u0443\u0434\u043e \u043d\u0430 \u041a\u0430\u0431\u043e \u0412\u0435\u0440\u0434\u0435" },
            { "cyp", "\u041a\u0438\u043f\u044a\u0440\u0441\u043a\u0430 \u043b\u0438\u0440\u0430" },
            { "czk", "\u0427\u0435\u0448\u043a\u0430 \u043a\u0440\u043e\u043d\u0430" },
            { "ddm", "\u0418\u0437\u0442\u043e\u0447\u043d\u043e\u0433\u0435\u0440\u043c\u0430\u043d\u0441\u043a\u0430 \u043c\u0430\u0440\u043a\u0430" },
            { "dem", "\u0413\u0435\u0440\u043c\u0430\u043d\u0441\u043a\u0430 \u043c\u0430\u0440\u043a\u0430" },
            { "djf", "\u0414\u0436\u0438\u0431\u0443\u0442\u0441\u043a\u0438 \u0444\u0440\u0430\u043d\u043a" },
            { "dkk", "\u0414\u0430\u0442\u0441\u043a\u0430 \u043a\u0440\u043e\u043d\u0430" },
            { "dop", "\u0414\u043e\u043c\u0438\u043d\u0438\u043a\u0430\u043d\u0441\u043a\u043e \u043f\u0435\u0441\u043e" },
            { "dzd", "\u0410\u043b\u0436\u0438\u0440\u0441\u043a\u0438 \u0434\u0438\u043d\u0430\u0440" },
            { "ecs", "\u0415\u043a\u0432\u0430\u0434\u043e\u0440\u0441\u043a\u043e \u0441\u0443\u043a\u0440\u0435" },
            { "ecv", "\u0415\u043a\u0432\u0430\u0434\u043e\u0440\u0441\u043a\u0430 \u0431\u0430\u043d\u043a\u043e\u0432\u0430 \u0435\u0434\u0438\u043d\u0438\u0446\u0430" },
            { "eek", "\u0415\u0441\u0442\u043e\u043d\u0441\u043a\u0430 \u043a\u0440\u043e\u043d\u0430" },
            { "egp", "\u0415\u0433\u0438\u043f\u0435\u0442\u0441\u043a\u0430 \u043b\u0438\u0440\u0430" },
            { "ern", "\u0415\u0440\u0438\u0442\u0440\u0435\u0439\u0441\u043a\u0430 \u043d\u0430\u043a\u0444\u0430" },
            { "esp", "\u0418\u0441\u043f\u0430\u043d\u0441\u043a\u0430 \u043f\u0435\u0441\u0435\u0442\u0430" },
            { "etb", "\u0415\u0442\u0438\u043e\u043f\u0441\u043a\u0438 \u0431\u0438\u0440" },
            { "eur", "\u0415\u0432\u0440\u043e" },
            { "fim", "\u0424\u0438\u043d\u043b\u0430\u043d\u0434\u0441\u043a\u0430 \u043c\u0430\u0440\u043a\u0430" },
            { "fjd", "\u0424\u0438\u0434\u0436\u0438\u0439\u0441\u043a\u0438 \u0434\u043e\u043b\u0430\u0440" },
            { "fkp", "\u0424\u043e\u043b\u043a\u043b\u0435\u043d\u0434\u0441\u043a\u0430 \u043b\u0438\u0440\u0430" },
            { "frf", "\u0424\u0440\u0435\u043d\u0441\u043a\u0438 \u0444\u0440\u0430\u043d\u043a" },
            { "gbp", "\u0411\u0440\u0438\u0442\u0430\u043d\u0441\u043a\u0430 \u043b\u0438\u0440\u0430" },
            { "gek", "\u0413\u0440\u0443\u0437\u0438\u043d\u0441\u043a\u0438 \u043a\u0443\u043f\u043e\u043d" },
            { "gel", "\u0413\u0440\u0443\u0437\u0438\u043d\u0441\u043a\u0438 \u043b\u0430\u0440\u0438" },
            { "ghc", "\u0413\u0430\u043d\u0430\u0439\u0441\u043a\u043e \u0441\u0435\u0434\u0438 (1979\u20132007)" },
            { "ghs", "\u0413\u0430\u043d\u0430\u0439\u0441\u043a\u043e \u0441\u0435\u0434\u0438" },
            { "gip", "\u0413\u0438\u0431\u0440\u0430\u043b\u0442\u0430\u0440\u0441\u043a\u0430 \u043b\u0438\u0440\u0430" },
            { "gmd", "\u0413\u0430\u043c\u0431\u0438\u0439\u0441\u043a\u043e \u0434\u0430\u043b\u0430\u0441\u0438" },
            { "gnf", "\u0413\u0432\u0438\u043d\u0435\u0439\u0441\u043a\u0438 \u0444\u0440\u0430\u043d\u043a" },
            { "gns", "\u0413\u0432\u0438\u043d\u0435\u0439\u0441\u043a\u0430 \u0441\u0438\u043b\u0438" },
            { "gqe", "\u0415\u043a\u0432\u0430\u0442\u043e\u0440\u0438\u0430\u043b\u043d\u043e \u0433\u0432\u0438\u043d\u0435\u0439\u0441\u043a\u043e \u0435\u043a\u0432\u0435\u043b\u0435" },
            { "grd", "\u0413\u0440\u044a\u0446\u043a\u0430 \u0434\u0440\u0430\u0445\u043c\u0430" },
            { "gtq", "\u0413\u0432\u0430\u0442\u0435\u043c\u0430\u043b\u0441\u043a\u0438 \u043a\u0435\u0442\u0446\u0430\u043b" },
            { "gwe", "\u0415\u0441\u043a\u0443\u0434\u043e \u043e\u0442 \u041f\u043e\u0440\u0442\u0443\u0433\u0430\u043b\u0441\u043a\u0430 \u0413\u0432\u0438\u043d\u0435\u044f" },
            { "gwp", "\u0413\u0432\u0438\u043d\u0435\u044f-\u0411\u0438\u0441\u0430\u0443 \u043f\u0435\u0441\u043e" },
            { "gyd", "\u0413\u0430\u044f\u043d\u0441\u043a\u0438 \u0434\u043e\u043b\u0430\u0440" },
            { "hkd", "\u0425\u043e\u043d\u043a\u043e\u043d\u0433\u0441\u043a\u0438 \u0434\u043e\u043b\u0430\u0440" },
            { "hnl", "\u0425\u043e\u043d\u0434\u0443\u0440\u0430\u0441\u043a\u0430 \u043b\u0435\u043c\u043f\u0438\u0440\u0430" },
            { "hrd", "\u0425\u044a\u0440\u0432\u0430\u0442\u0441\u043a\u0438 \u0434\u0438\u043d\u0430\u0440" },
            { "hrk", "\u0425\u044a\u0440\u0432\u0430\u0442\u0441\u043a\u0430 \u043a\u0443\u043d\u0430" },
            { "htg", "\u0425\u0430\u0438\u0442\u0441\u043a\u0438 \u0433\u0443\u0440\u0434" },
            { "huf", "\u0423\u043d\u0433\u0430\u0440\u0441\u043a\u0438 \u0444\u043e\u0440\u0438\u043d\u0442" },
            { "idr", "\u0418\u043d\u0434\u043e\u043d\u0435\u0437\u0438\u0439\u0441\u043a\u0430 \u0440\u0443\u043f\u0438\u044f" },
            { "iep", "\u0418\u0440\u043b\u0430\u043d\u0434\u0441\u043a\u0430 \u043b\u0438\u0440\u0430" },
            { "ilp", "\u0418\u0437\u0440\u0430\u0435\u043b\u0441\u043a\u0430 \u043b\u0438\u0440\u0430" },
            { "ils", "\u0418\u0437\u0440\u0430\u0435\u043b\u0441\u043a\u0438 \u043d\u043e\u0432 \u0448\u0435\u043a\u0435\u043b" },
            { "inr", "\u0418\u043d\u0434\u0438\u0439\u0441\u043a\u0430 \u0440\u0443\u043f\u0438\u044f" },
            { "iqd", "\u0418\u0440\u0430\u043a\u0441\u043a\u0438 \u0434\u0438\u043d\u0430\u0440" },
            { "irr", "\u0418\u0440\u0430\u043d\u0441\u043a\u0438 \u0440\u0438\u0430\u043b" },
            { "isk", "\u0418\u0441\u043b\u0430\u043d\u0434\u0441\u043a\u0430 \u043a\u0440\u043e\u043d\u0430" },
            { "itl", "\u0418\u0442\u0430\u043b\u0438\u0430\u043d\u0441\u043a\u0430 \u043b\u0438\u0440\u0430" },
            { "jmd", "\u042f\u043c\u0430\u0439\u0441\u043a\u0438 \u0434\u043e\u043b\u0430\u0440" },
            { "jod", "\u0419\u043e\u0440\u0434\u0430\u043d\u0441\u043a\u0438 \u0434\u0438\u043d\u0430\u0440" },
            { "jpy", "\u042f\u043f\u043e\u043d\u0441\u043a\u0430 \u0439\u0435\u043d\u0430" },
            { "kes", "\u041a\u0435\u043d\u0438\u0439\u0441\u043a\u0438 \u0448\u0438\u043b\u0438\u043d\u0433" },
            { "kgs", "\u041a\u0438\u0440\u0433\u0438\u0437\u0441\u0442\u0430\u043d\u0441\u043a\u0438 \u0441\u043e\u043c" },
            { "khr", "\u041a\u0430\u043c\u0431\u043e\u0434\u0436\u0430\u043d\u0441\u043a\u0438 \u0440\u0438\u0435\u043b" },
            { "kmf", "\u041a\u043e\u043c\u043e\u0440\u0441\u043a\u0438 \u0444\u0440\u0430\u043d\u043a" },
            { "kpw", "\u0421\u0435\u0432\u0435\u0440\u043d\u043e\u043a\u043e\u0440\u0435\u0439\u0441\u043a\u0438 \u0432\u043e\u043d" },
            { "krw", "\u042e\u0436\u043d\u043e\u043a\u043e\u0440\u0435\u0439\u0441\u043a\u0438 \u0432\u043e\u043d" },
            { "kwd", "\u041a\u0443\u0432\u0435\u0439\u0442\u0441\u043a\u0438 \u0434\u0438\u043d\u0430\u0440" },
            { "kyd", "\u041a\u0430\u0439\u043c\u0430\u043d\u043e\u0432 \u0434\u043e\u043b\u0430\u0440" },
            { "kzt", "\u041a\u0430\u0437\u0430\u0445\u0441\u0442\u0430\u043d\u0441\u043a\u043e \u0442\u0435\u043d\u0433\u0435" },
            { "lak", "\u041b\u0430\u043e\u0441\u043a\u0438 \u043a\u0438\u043f" },
            { "lbp", "\u041b\u0438\u0432\u0430\u043d\u0441\u043a\u0430 \u043b\u0438\u0440\u0430" },
            { "lkr", "\u0428\u0440\u0438\u043b\u0430\u043d\u043a\u0441\u043a\u0430 \u0440\u0443\u043f\u0438\u044f" },
            { "lrd", "\u041b\u0438\u0431\u0435\u0440\u0438\u0439\u0441\u043a\u0438 \u0434\u043e\u043b\u0430\u0440" },
            { "lsl", "\u041b\u0435\u0441\u043e\u0442\u0441\u043a\u043e \u043b\u043e\u0442\u0438" },
            { "ltl", "\u041b\u0438\u0442\u043e\u0432\u0441\u043a\u0438 \u043b\u0438\u0442\u0430\u0441" },
            { "ltt", "\u041b\u0438\u0442\u043e\u0432\u0441\u043a\u0438 \u0442\u0430\u043b\u043e\u043d" },
            { "luf", "\u041b\u044e\u043a\u0441\u0435\u043c\u0431\u0443\u0440\u0433\u0441\u043a\u0438 \u0444\u0440\u0430\u043d\u043a" },
            { "lvl", "\u041b\u0430\u0442\u0432\u0438\u0439\u0441\u043a\u0438 \u043b\u0430\u0442" },
            { "lvr", "\u041b\u0430\u0442\u0432\u0438\u0439\u0441\u043a\u0430 \u0440\u0443\u0431\u043b\u0430" },
            { "lyd", "\u041b\u0438\u0431\u0438\u0439\u0441\u043a\u0438 \u0434\u0438\u043d\u0430\u0440" },
            { "mad", "\u041c\u0430\u0440\u043e\u043a\u0430\u043d\u0441\u043a\u0438 \u0434\u0438\u0440\u0445\u0430\u043c" },
            { "maf", "\u041c\u0430\u0440\u043e\u043a\u0430\u043d\u0441\u043a\u0438 \u0444\u0440\u0430\u043d\u043a" },
            { "mdl", "\u041c\u043e\u043b\u0434\u043e\u0432\u0441\u043a\u043e \u043b\u0435\u0443" },
            { "mga", "\u041c\u0430\u043b\u0433\u0430\u0448\u043a\u043e \u0430\u0440\u0438\u0430\u0440\u0438" },
            { "mgf", "\u041c\u0430\u043b\u0433\u0430\u0448\u043a\u0438 \u0444\u0440\u0430\u043d\u043a - \u041c\u0430\u0434\u0430\u0433\u0430\u0441\u043a\u0430\u0440" },
            { "mkd", "\u041c\u0430\u043a\u0435\u0434\u043e\u043d\u0441\u043a\u0438 \u0434\u0435\u043d\u0430\u0440" },
            { "mlf", "\u041c\u0430\u043b\u0438\u0439\u0441\u043a\u0438 \u0444\u0440\u0430\u043d\u043a" },
            { "mmk", "\u041c\u0438\u0430\u043d\u043c\u0430\u0440\u0441\u043a\u0438 \u043a\u0438\u044f\u0442" },
            { "mnt", "\u041c\u043e\u043d\u0433\u043e\u043b\u0441\u043a\u0438 \u0442\u0443\u0433\u0440\u0438\u043a" },
            { "mop", "\u041f\u0430\u0442\u0430\u043a\u0430 \u043d\u0430 \u041c\u0430\u043a\u0430\u043e" },
            { "mro", "\u041c\u0430\u0432\u0440\u0438\u0442\u0430\u043d\u0441\u043a\u0430 \u0443\u0433\u0438\u044f" },
            { "mtl", "\u041c\u0430\u043b\u0442\u0438\u0439\u0441\u043a\u0430 \u043b\u0438\u0440\u0430" },
            { "mur", "\u041c\u0430\u0432\u0440\u0438\u0446\u0438\u0439\u0441\u043a\u0430 \u0440\u0443\u043f\u0438\u044f" },
            { "mvr", "\u041c\u0430\u043b\u0434\u0438\u0432\u0441\u043a\u0430 \u0440\u0443\u0444\u0438\u044f" },
            { "mwk", "\u041c\u0430\u043b\u0430\u0432\u0438\u0439\u0441\u043a\u0430 \u043a\u0432\u0430\u0447\u0430" },
            { "mxn", "\u041c\u0435\u043a\u0441\u0438\u043a\u0430\u043d\u0441\u043a\u043e \u043f\u0435\u0441\u043e" },
            { "mxp", "\u041c\u0435\u043a\u0441\u0438\u043a\u0430\u043d\u0441\u043a\u043e \u0441\u0440\u0435\u0431\u044a\u0440\u043d\u043e \u043f\u0435\u0441\u043e (1861\u20131992)" },
            { "mxv", "\u041c\u0435\u043a\u0441\u0438\u043a\u0430\u043d\u0441\u043a\u0430 \u043a\u043e\u043d\u0432\u0435\u0440\u0442\u0438\u0440\u0443\u0435\u043c\u0430 \u0435\u0434\u0438\u043d\u0438\u0446\u0430 (UDI)" },
            { "myr", "\u041c\u0430\u043b\u0430\u0439\u0437\u0438\u0439\u0441\u043a\u0438 \u0440\u0438\u043d\u0433\u0438\u0442" },
            { "mze", "\u041c\u043e\u0437\u0430\u043c\u0431\u0438\u043a\u0441\u043a\u043e \u0435\u0441\u043a\u0443\u0434\u043e" },
            { "mzm", "\u041c\u043e\u0437\u0430\u043c\u0431\u0438\u043a\u0441\u043a\u0438 \u043c\u0435\u0442\u0438\u043a\u0430\u043b (1980\u20132006)" },
            { "mzn", "\u041c\u043e\u0437\u0430\u043c\u0431\u0438\u043a\u0441\u043a\u0438 \u043c\u0435\u0442\u0438\u043a\u0430\u043b" },
            { "nad", "\u041d\u0430\u043c\u0438\u0431\u0438\u0439\u0441\u043a\u0438 \u0434\u043e\u043b\u0430\u0440" },
            { "ngn", "\u041d\u0438\u0433\u0435\u0440\u0438\u0439\u0441\u043a\u0430 \u043d\u0430\u0439\u0440\u0430" },
            { "nic", "\u041d\u0438\u043a\u0430\u0440\u0430\u0433\u0443\u0430\u043d\u0441\u043a\u0430 \u043a\u043e\u0440\u0434\u043e\u0431\u0430 (1988\u20131991)" },
            { "nio", "\u041d\u0438\u043a\u0430\u0440\u0430\u0433\u0443\u0430\u043d\u0441\u043a\u0430 \u043a\u043e\u0440\u0434\u043e\u0431\u0430" },
            { "nlg", "\u0425\u043e\u043b\u0430\u043d\u0434\u0441\u043a\u0438 \u0433\u0443\u043b\u0434\u0435\u043d" },
            { "nok", "\u041d\u043e\u0440\u0432\u0435\u0436\u043a\u0430 \u043a\u0440\u043e\u043d\u0430" },
            { "npr", "\u041d\u0435\u043f\u0430\u043b\u0441\u043a\u0430 \u0440\u0443\u043f\u0438\u044f" },
            { "nzd", "\u041d\u043e\u0432\u043e\u0437\u0435\u043b\u0430\u043d\u0434\u0441\u043a\u0438 \u0434\u043e\u043b\u0430\u0440" },
            { "omr", "\u041e\u043c\u0430\u043d\u0441\u043a\u0438 \u0440\u0438\u0430\u043b" },
            { "pab", "\u041f\u0430\u043d\u0430\u043c\u0441\u043a\u0430 \u0431\u0430\u043b\u0431\u043e\u0430" },
            { "pei", "\u041f\u0435\u0440\u0443\u0430\u043d\u0441\u043a\u043e \u0438\u043d\u0442\u0438" },
            { "pen", "\u041f\u0435\u0440\u0443\u0430\u043d\u0441\u043a\u0438 \u043d\u043e\u0432 \u0441\u043e\u043b" },
            { "pes", "\u041f\u0435\u0440\u0443\u0430\u043d\u0441\u043a\u0438 \u0441\u043e\u043b" },
            { "pgk", "\u041f\u0430\u043f\u0443\u0430-\u043d\u043e\u0432\u043e\u0433\u0432\u0438\u043d\u0435\u0439\u0441\u043a\u0430 \u043a\u0438\u043d\u0430" },
            { "php", "\u0424\u0438\u043b\u0438\u043f\u0438\u043d\u0441\u043a\u043e \u043f\u0435\u0441\u043e" },
            { "pkr", "\u041f\u0430\u043a\u0438\u0441\u0442\u0430\u043d\u0441\u043a\u0430 \u0440\u0443\u043f\u0438\u044f" },
            { "pln", "\u041f\u043e\u043b\u0441\u043a\u0430 \u0437\u043b\u043e\u0442\u0430" },
            { "plz", "\u041f\u043e\u043b\u0441\u043a\u0430 \u0437\u043b\u043e\u0442\u0430 (1950\u20131995)" },
            { "pte", "\u041f\u043e\u0440\u0442\u0443\u0433\u0430\u043b\u0441\u043a\u043e \u0435\u0441\u043a\u0443\u0434\u043e" },
            { "pyg", "\u041f\u0430\u0440\u0430\u0433\u0432\u0430\u0439\u0441\u043a\u043e \u0433\u0443\u0430\u0440\u0430\u043d\u0438" },
            { "qar", "\u041a\u0430\u0442\u0430\u0440\u0441\u043a\u0438 \u0440\u0438\u0430\u043b" },
            { "rhd", "\u0420\u043e\u0434\u0435\u0437\u0438\u0439\u0441\u043a\u0438 \u0434\u043e\u043b\u0430\u0440" },
            { "rol", "\u0421\u0442\u0430\u0440\u0430 \u0440\u0443\u043c\u044a\u043d\u0441\u043a\u0430 \u043b\u0435\u044f" },
            { "ron", "\u0420\u0443\u043c\u044a\u043d\u0441\u043a\u0430 \u043b\u0435\u044f" },
            { "rsd", "\u0421\u0440\u044a\u0431\u0441\u043a\u0438 \u0434\u0438\u043d\u0430\u0440" },
            { "rub", "\u0420\u0443\u0441\u043a\u0430 \u0440\u0443\u0431\u043b\u0430" },
            { "rur", "\u0420\u0443\u0441\u043a\u0430 \u0440\u0443\u0431\u043b\u0430 (1991\u20131998)" },
            { "rwf", "\u0420\u0443\u0430\u043d\u0434\u0441\u043a\u0438 \u0444\u0440\u0430\u043d\u043a" },
            { "sar", "\u0421\u0430\u0443\u0434\u0438\u0442\u0441\u043a\u043e\u0430\u0440\u0430\u0431\u0441\u043a\u0438 \u0440\u0438\u0430\u043b" },
            { "sbd", "\u0414\u043e\u043b\u0430\u0440 \u043d\u0430 \u0421\u043e\u043b\u043e\u043c\u043e\u043d\u043e\u0432\u0438\u0442\u0435 \u043e\u0441\u0442\u0440\u043e\u0432\u0438" },
            { "scr", "\u0421\u0435\u0439\u0448\u0435\u043b\u0441\u043a\u0430 \u0440\u0443\u043f\u0438\u044f" },
            { "sdd", "\u0421\u0443\u0434\u0430\u043d\u0441\u043a\u0438 \u0434\u0438\u043d\u0430\u0440" },
            { "sdg", "\u0421\u0443\u0434\u0430\u043d\u0441\u043a\u0430 \u043b\u0438\u0440\u0430" },
            { "sek", "\u0428\u0432\u0435\u0434\u0441\u043a\u0430 \u043a\u0440\u043e\u043d\u0430" },
            { "sgd", "\u0421\u0438\u043d\u0433\u0430\u043f\u0443\u0440\u0441\u043a\u0438 \u0434\u043e\u043b\u0430\u0440" },
            { "shp", "\u041b\u0438\u0440\u0430 \u043d\u0430 \u0421\u0432\u0435\u0442\u0430 \u0415\u043b\u0435\u043d\u0430" },
            { "sit", "\u0421\u043b\u043e\u0432\u0435\u043d\u0441\u043a\u0438 \u0442\u043e\u043b\u0430\u0440" },
            { "skk", "\u0421\u043b\u043e\u0432\u0430\u0448\u043a\u0430 \u043a\u0440\u043e\u043d\u0430" },
            { "sll", "\u0421\u0438\u0435\u0440\u0430\u043b\u0435\u043e\u043d\u0441\u043a\u043e \u043b\u0435\u043e\u043d\u0435" },
            { "sos", "\u0421\u043e\u043c\u0430\u043b\u0438\u0439\u0441\u043a\u0438 \u0448\u0438\u043b\u0438\u043d\u0433" },
            { "srd", "\u0421\u0443\u0440\u0438\u043d\u0430\u043c\u0441\u043a\u0438 \u0434\u043e\u043b\u0430\u0440" },
            { "srg", "\u0421\u0443\u0440\u0438\u043d\u0430\u043c\u0441\u043a\u0438 \u0433\u0438\u043b\u0434\u0435\u0440" },
            { "ssp", "\u042e\u0436\u043d\u043e\u0441\u0443\u0434\u0430\u043d\u0441\u043a\u0430 \u043b\u0438\u0440\u0430" },
            { "std", "\u0414\u043e\u0431\u0440\u0430 \u043d\u0430 \u0421\u0430\u043e \u0422\u043e\u043c\u0435 \u0438 \u041f\u0440\u0438\u043d\u0441\u0438\u043f\u0438" },
            { "sur", "\u0421\u044a\u0432\u0435\u0442\u0441\u043a\u0430 \u0440\u0443\u0431\u043b\u0430" },
            { "svc", "\u0421\u0430\u043b\u0432\u0430\u0434\u043e\u0440\u0441\u043a\u0438 \u043a\u043e\u043b\u043e\u043d" },
            { "syp", "\u0421\u0438\u0440\u0438\u0439\u0441\u043a\u0430 \u043b\u0438\u0440\u0430" },
            { "szl", "\u0421\u0432\u0430\u0437\u0438\u043b\u0435\u043d\u0434\u0441\u043a\u0438 \u043b\u0438\u043b\u0430\u043d\u0433\u0435\u043d\u0438" },
            { "thb", "\u0422\u0430\u0439\u043b\u0430\u043d\u0434\u0441\u043a\u0438 \u0431\u0430\u0442" },
            { "tjr", "\u0422\u0430\u0434\u0436\u0438\u043a\u0438\u0441\u0442\u0430\u043d\u0441\u043a\u0430 \u0440\u0443\u0431\u043b\u0430" },
            { "tjs", "\u0422\u0430\u0434\u0436\u0438\u043a\u0438\u0441\u0442\u0430\u043d\u0441\u043a\u0438 \u0441\u043e\u043c\u043e\u043d\u0438" },
            { "tmm", "\u0422\u0443\u0440\u043a\u043c\u0435\u043d\u0438\u0441\u0442\u0430\u043d\u0441\u043a\u0438 \u043c\u0430\u043d\u0430\u0442" },
            { "tmt", "\u0422\u0443\u0440\u043a\u043c\u0435\u043d\u0441\u043a\u0438 \u043c\u0430\u043d\u0430\u0442" },
            { "tnd", "\u0422\u0443\u043d\u0438\u0437\u0438\u0439\u0441\u043a\u0438 \u0434\u0438\u043d\u0430\u0440" },
            { "top", "\u0422\u043e\u043d\u0433\u0430\u043d\u0441\u043a\u0430 \u043f\u0430\u0430\u043d\u0433\u0430" },
            { "tpe", "\u0422\u0438\u043c\u043e\u0440\u0441\u043a\u043e \u0435\u0441\u043a\u0443\u0434\u043e" },
            { "trl", "\u0422\u0443\u0440\u0441\u043a\u0430 \u043b\u0438\u0440\u0430 (1922\u20132005)" },
            { "try", "\u0422\u0443\u0440\u0441\u043a\u0430 \u043b\u0438\u0440\u0430" },
            { "ttd", "\u0414\u043e\u043b\u0430\u0440 \u043d\u0430 \u0422\u0440\u0438\u043d\u0438\u0434\u0430\u0434 \u0438 \u0422\u043e\u0431\u0430\u0433\u043e" },
            { "twd", "\u0422\u0430\u0439\u0432\u0430\u043d\u0441\u043a\u0438 \u0434\u043e\u043b\u0430\u0440" },
            { "tzs", "\u0422\u0430\u043d\u0437\u0430\u043d\u0438\u0439\u0441\u043a\u0438 \u0448\u0438\u043b\u0438\u043d\u0433" },
            { "uah", "\u0423\u043a\u0440\u0430\u0438\u043d\u0441\u043a\u0430 \u0445\u0440\u0438\u0432\u043d\u044f" },
            { "uak", "\u0423\u043a\u0440\u0430\u0438\u043d\u0441\u043a\u0438 \u043a\u0430\u0440\u0431\u043e\u0432\u0430\u043d\u0435\u0446" },
            { "ugs", "\u0423\u0433\u0430\u043d\u0434\u0438\u0439\u0441\u043a\u0438 \u0448\u0438\u043b\u0438\u043d\u0433 (1966\u20131987)" },
            { "ugx", "\u0423\u0433\u0430\u043d\u0434\u0441\u043a\u0438 \u0448\u0438\u043b\u0438\u043d\u0433" },
            { "usd", "\u0429\u0430\u0442\u0441\u043a\u0438 \u0434\u043e\u043b\u0430\u0440" },
            { "uyi", "\u0423\u0440\u0443\u0433\u0432\u0430\u0439\u0441\u043a\u043e \u043f\u0435\u0441\u043e (\u0438\u043d\u0434\u0435\u043a\u0441 \u043d\u0430 \u0438\u043d\u0444\u043b\u0430\u0446\u0438\u044f\u0442\u0430)" },
            { "uyp", "\u0423\u0440\u0443\u0433\u0432\u0430\u0439\u0441\u043a\u043e \u043f\u0435\u0441\u043e (1975\u20131993)" },
            { "uyu", "\u0423\u0440\u0443\u0433\u0432\u0430\u0439\u0441\u043a\u043e \u043f\u0435\u0441\u043e" },
            { "uzs", "\u0423\u0437\u0431\u0435\u043a\u0441\u043a\u0438 \u0441\u0443\u043c" },
            { "veb", "\u0412\u0435\u043d\u0435\u0446\u0443\u0435\u043b\u0441\u043a\u0438 \u0431\u043e\u043b\u0438\u0432\u0430\u0440 (1871\u20132008)" },
            { "vef", "\u0412\u0435\u043d\u0435\u0446\u0443\u0435\u043b\u0441\u043a\u0438 \u0431\u043e\u043b\u0438\u0432\u0430\u0440" },
            { "vnd", "\u0412\u0438\u0435\u0442\u043d\u0430\u043c\u0441\u043a\u0438 \u0434\u043e\u043d\u0433" },
            { "vuv", "\u0412\u0430\u043d\u0443\u0430\u0442\u0441\u043a\u043e \u0432\u0430\u0442\u0443" },
            { "wst", "\u0421\u0430\u043c\u043e\u0430\u043d\u0441\u043a\u0430 \u0442\u0430\u043b\u0430" },
            { "xaf", "\u0426\u0435\u043d\u0442\u0440\u0430\u043b\u043d\u043e\u0430\u0444\u0440\u0438\u043a\u0430\u043d\u0441\u043a\u0438 \u0444\u0440\u0430\u043d\u043a" },
            { "xag", "\u0421\u0440\u0435\u0431\u0440\u043e" },
            { "xau", "\u0417\u043b\u0430\u0442\u043e" },
            { "xba", "\u0415\u0432\u0440\u043e\u043f\u0435\u0439\u0441\u043a\u0430 \u0441\u044a\u0441\u0442\u0430\u0432\u043d\u0430 \u0435\u0434\u0438\u043d\u0438\u0446\u0430" },
            { "xbb", "\u0415\u0432\u0440\u043e\u043f\u0435\u0439\u0441\u043a\u0430 \u0432\u0430\u043b\u0443\u0442\u043d\u0430 \u0435\u0434\u0438\u043d\u0438\u0446\u0430" },
            { "xbc", "\u0415\u0432\u0440\u043e\u043f\u0435\u0439\u0441\u043a\u0430 \u0435\u0434\u0438\u043d\u0438\u0446\u0430 \u043f\u043e \u0441\u043c\u0435\u0442\u043a\u0430 (XBC)" },
            { "xbd", "\u0415\u0432\u0440\u043e\u043f\u0435\u0439\u0441\u043a\u0430 \u0435\u0434\u0438\u043d\u0438\u0446\u0430 \u043f\u043e \u0441\u043c\u0435\u0442\u043a\u0430 (XBD)" },
            { "xcd", "\u0418\u0437\u0442\u043e\u0447\u043d\u043e\u043a\u0430\u0440\u0438\u0431\u0441\u043a\u0438 \u0434\u043e\u043b\u0430\u0440" },
            { "xdr", "\u0421\u043f\u0435\u0446\u0438\u0430\u043b\u043d\u0438 \u043f\u0440\u0430\u0432\u0430 \u043d\u0430 \u0442\u0438\u0440\u0430\u0436" },
            { "xeu", "\u0415\u043a\u0443 \u043d\u0430 \u0415\u0418\u041e" },
            { "xfo", "\u0424\u0440\u0435\u043d\u0441\u043a\u0438 \u0437\u043b\u0430\u0442\u0435\u043d \u0444\u0440\u0430\u043d\u043a" },
            { "xof", "\u0417\u0430\u043f\u0430\u0434\u043d\u043e\u0430\u0444\u0440\u0438\u043a\u0430\u043d\u0441\u043a\u0438 \u0444\u0440\u0430\u043d\u043a" },
            { "xpd", "\u041f\u0430\u043b\u0430\u0434\u0438\u0439" },
            { "xpf", "\u0424\u0440\u0435\u043d\u0441\u043a\u043e\u043f\u043e\u043b\u0438\u043d\u0435\u0437\u0438\u0439\u0441\u043a\u0438 \u0444\u0440\u0430\u043d\u043a" },
            { "xpt", "\u041f\u043b\u0430\u0442\u0438\u043d\u0430" },
            { "xts", "\u041a\u043e\u0434 \u0440\u0435\u0437\u0435\u0440\u0432\u0438\u0440\u0430\u043d \u0437\u0430 \u0446\u0435\u043b\u0438\u0442\u0435 \u043d\u0430 \u0442\u0435\u0441\u0442\u0432\u0430\u043d\u0435" },
            { "xxx", "\u041d\u0435\u043f\u043e\u0437\u043d\u0430\u0442\u0430 \u0432\u0430\u043b\u0443\u0442\u0430" },
            { "ydd", "\u0419\u0435\u043c\u0435\u043d\u0441\u043a\u0438 \u0434\u0438\u043d\u0430\u0440" },
            { "yer", "\u0419\u0435\u043c\u0435\u043d\u0441\u043a\u0438 \u0440\u0438\u0430\u043b" },
            { "yud", "\u042e\u0433\u043e\u0441\u043b\u0430\u0432\u0441\u043a\u0438 \u0442\u0432\u044a\u0440\u0434 \u0434\u0438\u043d\u0430\u0440" },
            { "yum", "\u042e\u0433\u043e\u0441\u043b\u0430\u0432\u0441\u043a\u0438 \u0434\u0438\u043d\u0430\u0440" },
            { "yun", "\u042e\u0433\u043e\u0441\u043b\u0430\u0432\u0441\u043a\u0438 \u043a\u043e\u043d\u0432\u0435\u0440\u0442\u0438\u0440\u0443\u0435\u043c \u0434\u0438\u043d\u0430\u0440" },
            { "zal", "\u042e\u0436\u043d\u043e\u0430\u0444\u0440\u0438\u043a\u0430\u043d\u0441\u043a\u0438 \u0440\u0430\u043d\u0434 (\u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432)" },
            { "zar", "\u042e\u0436\u043d\u043e\u0430\u0444\u0440\u0438\u043a\u0430\u043d\u0441\u043a\u0438 \u0440\u0430\u043d\u0434" },
            { "zmk", "\u0417\u0430\u043c\u0431\u0438\u0439\u0441\u043a\u0430 \u043a\u0432\u0430\u0447\u0430 (1968\u20132012)" },
            { "zmw", "\u0417\u0430\u043c\u0431\u0438\u0439\u0441\u043a\u0430 \u043a\u0443\u0430\u0447\u0430" },
            { "zrn", "\u0417\u0430\u0438\u0440\u0441\u043a\u043e \u043d\u043e\u0432\u043e \u0437\u0430\u0439\u0440\u0435" },
            { "zrz", "\u0417\u0430\u0438\u0440\u0441\u043a\u043e \u0437\u0430\u0439\u0440\u0435" },
            { "zwd", "\u0417\u0438\u043c\u0431\u0430\u0431\u0432\u0438\u0439\u0441\u043a\u0438 \u0434\u043e\u043b\u0430\u0440" },
            { "zwl", "\u0417\u0438\u043c\u0431\u0430\u0431\u0432\u0438\u0439\u0441\u043a\u0438 \u0434\u043e\u043b\u0430\u0440 (2009)" },
        };
        return data;
    }
}
