/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import java.io.IOException;
import java.io.Writer;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.WriteListener;
import org.apache.catalina.Globals;
import org.apache.catalina.connector.ClientAbortException;
import org.apache.catalina.connector.Request;
import org.apache.coyote.ActionCode;
import org.apache.coyote.CloseNowException;
import org.apache.coyote.Constants;
import org.apache.coyote.Response;
import org.apache.tomcat.util.buf.B2CConverter;
import org.apache.tomcat.util.buf.C2BConverter;
import org.apache.tomcat.util.res.StringManager;

public class OutputBuffer
extends Writer {
    private static final StringManager sm = StringManager.getManager(OutputBuffer.class);
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    private final Map<Charset, C2BConverter> encoders = new HashMap<Charset, C2BConverter>();
    private final int defaultBufferSize;
    private ByteBuffer bb;
    private final CharBuffer cb;
    private boolean initial = true;
    private long bytesWritten = 0L;
    private long charsWritten = 0L;
    private volatile boolean closed = false;
    private boolean doFlush = false;
    protected C2BConverter conv;
    private Response coyoteResponse;
    private volatile boolean suspended = false;

    public OutputBuffer(int n) {
        this.defaultBufferSize = n;
        this.bb = ByteBuffer.allocate(n);
        this.clear(this.bb);
        this.cb = CharBuffer.allocate(n);
        this.clear(this.cb);
    }

    public void setResponse(Response response) {
        this.coyoteResponse = response;
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public void setSuspended(boolean bl) {
        this.suspended = bl;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void recycle() {
        this.initial = true;
        this.bytesWritten = 0L;
        this.charsWritten = 0L;
        if (this.bb.capacity() > 16 * this.defaultBufferSize) {
            this.bb = ByteBuffer.allocate(this.defaultBufferSize);
        }
        this.clear(this.bb);
        this.clear(this.cb);
        this.closed = false;
        this.suspended = false;
        this.doFlush = false;
        if (this.conv != null) {
            this.conv.recycle();
            this.conv = null;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        if (this.suspended) {
            return;
        }
        if (this.cb.remaining() > 0) {
            this.flushCharBuffer();
        }
        if (!(this.coyoteResponse.isCommitted() || this.coyoteResponse.getContentLengthLong() != -1L || this.coyoteResponse.getRequest().method().equals("HEAD") || this.coyoteResponse.isCommitted())) {
            this.coyoteResponse.setContentLength((long)this.bb.remaining());
        }
        if (this.coyoteResponse.getStatus() == 101) {
            this.doFlush(true);
        } else {
            this.doFlush(false);
        }
        this.closed = true;
        Request request = (Request)this.coyoteResponse.getRequest().getNote(1);
        request.inputBuffer.close();
        this.coyoteResponse.action(ActionCode.CLOSE, null);
    }

    @Override
    public void flush() throws IOException {
        this.doFlush(true);
    }

    protected void doFlush(boolean bl) throws IOException {
        if (this.suspended) {
            return;
        }
        try {
            this.doFlush = true;
            if (this.initial) {
                this.coyoteResponse.sendHeaders();
                this.initial = false;
            }
            if (this.cb.remaining() > 0) {
                this.flushCharBuffer();
            }
            if (this.bb.remaining() > 0) {
                this.flushByteBuffer();
            }
        }
        finally {
            this.doFlush = false;
        }
        if (bl) {
            this.coyoteResponse.action(ActionCode.CLIENT_FLUSH, null);
            if (this.coyoteResponse.isExceptionPresent()) {
                throw new ClientAbortException(this.coyoteResponse.getErrorException());
            }
        }
    }

    public void realWriteBytes(ByteBuffer byteBuffer) throws IOException {
        if (this.closed) {
            return;
        }
        if (this.coyoteResponse == null) {
            return;
        }
        if (byteBuffer.remaining() > 0) {
            try {
                this.coyoteResponse.doWrite(byteBuffer);
            }
            catch (CloseNowException closeNowException) {
                this.closed = true;
                throw closeNowException;
            }
            catch (IOException iOException) {
                this.coyoteResponse.setErrorException((Exception)iOException);
                throw new ClientAbortException(iOException);
            }
        }
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.suspended) {
            return;
        }
        this.writeBytes(byArray, n, n2);
    }

    public void write(ByteBuffer byteBuffer) throws IOException {
        if (this.suspended) {
            return;
        }
        this.writeBytes(byteBuffer);
    }

    private void writeBytes(byte[] byArray, int n, int n2) throws IOException {
        if (this.closed) {
            return;
        }
        this.append(byArray, n, n2);
        this.bytesWritten += (long)n2;
        if (this.doFlush) {
            this.flushByteBuffer();
        }
    }

    private void writeBytes(ByteBuffer byteBuffer) throws IOException {
        if (this.closed) {
            return;
        }
        int n = byteBuffer.remaining();
        this.append(byteBuffer);
        this.bytesWritten += (long)n;
        if (this.doFlush) {
            this.flushByteBuffer();
        }
    }

    public void writeByte(int n) throws IOException {
        if (this.suspended) {
            return;
        }
        if (this.isFull(this.bb)) {
            this.flushByteBuffer();
        }
        this.transfer((byte)n, this.bb);
        ++this.bytesWritten;
    }

    public void realWriteChars(CharBuffer charBuffer) throws IOException {
        while (charBuffer.remaining() > 0) {
            this.conv.convert(charBuffer, this.bb);
            if (this.bb.remaining() == 0) break;
            if (charBuffer.remaining() > 0) {
                this.flushByteBuffer();
                continue;
            }
            if (!this.conv.isUndeflow() || this.bb.limit() <= this.bb.capacity() - 4) continue;
            this.flushByteBuffer();
        }
    }

    @Override
    public void write(int n) throws IOException {
        if (this.suspended) {
            return;
        }
        if (this.isFull(this.cb)) {
            this.flushCharBuffer();
        }
        this.transfer((char)n, this.cb);
        ++this.charsWritten;
    }

    @Override
    public void write(char[] cArray) throws IOException {
        if (this.suspended) {
            return;
        }
        this.write(cArray, 0, cArray.length);
    }

    @Override
    public void write(char[] cArray, int n, int n2) throws IOException {
        if (this.suspended) {
            return;
        }
        this.append(cArray, n, n2);
        this.charsWritten += (long)n2;
    }

    @Override
    public void write(String string, int n, int n2) throws IOException {
        if (this.suspended) {
            return;
        }
        if (string == null) {
            throw new NullPointerException(sm.getString("outputBuffer.writeNull"));
        }
        int n3 = n;
        int n4 = n + n2;
        while (n3 < n4) {
            int n5;
            if ((n3 += (n5 = this.transfer(string, n3, n4 - n3, this.cb))) >= n4 || !this.isFull(this.cb)) continue;
            this.flushCharBuffer();
        }
        this.charsWritten += (long)n2;
    }

    @Override
    public void write(String string) throws IOException {
        if (this.suspended) {
            return;
        }
        if (string == null) {
            string = "null";
        }
        this.write(string, 0, string.length());
    }

    public void checkConverter() throws IOException {
        if (this.conv != null) {
            return;
        }
        Charset charset = null;
        if (this.coyoteResponse != null) {
            charset = this.coyoteResponse.getCharset();
        }
        if (charset == null) {
            if (this.coyoteResponse.getCharacterEncoding() != null) {
                charset = B2CConverter.getCharset((String)this.coyoteResponse.getCharacterEncoding());
            }
            charset = Constants.DEFAULT_BODY_CHARSET;
        }
        this.conv = this.encoders.get(charset);
        if (this.conv == null) {
            this.conv = OutputBuffer.createConverter(charset);
            this.encoders.put(charset, this.conv);
        }
    }

    private static C2BConverter createConverter(Charset charset) throws IOException {
        if (Globals.IS_SECURITY_ENABLED) {
            try {
                return AccessController.doPrivileged(new PrivilegedCreateConverter(charset));
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new IOException(privilegedActionException);
            }
        }
        return new C2BConverter(charset);
    }

    public long getContentWritten() {
        return this.bytesWritten + this.charsWritten;
    }

    public boolean isNew() {
        return this.bytesWritten == 0L && this.charsWritten == 0L;
    }

    public void setBufferSize(int n) {
        if (n > this.bb.capacity()) {
            this.bb = ByteBuffer.allocate(n);
            this.clear(this.bb);
        }
    }

    public void reset() {
        this.reset(false);
    }

    public void reset(boolean bl) {
        this.clear(this.bb);
        this.clear(this.cb);
        this.bytesWritten = 0L;
        this.charsWritten = 0L;
        if (bl) {
            if (this.conv != null) {
                this.conv.recycle();
            }
            this.conv = null;
        }
        this.initial = true;
    }

    public int getBufferSize() {
        return this.bb.capacity();
    }

    public boolean isReady() {
        return this.coyoteResponse.isReady();
    }

    public void setWriteListener(WriteListener writeListener) {
        this.coyoteResponse.setWriteListener(writeListener);
    }

    public boolean isBlocking() {
        return this.coyoteResponse.getWriteListener() == null;
    }

    public void checkRegisterForWrite() {
        this.coyoteResponse.checkRegisterForWrite();
    }

    public void append(byte[] byArray, int n, int n2) throws IOException {
        if (this.bb.remaining() == 0) {
            this.appendByteArray(byArray, n, n2);
        } else {
            int n3 = this.transfer(byArray, n, n2, this.bb);
            n += n3;
            if ((n2 -= n3) > 0 && this.isFull(this.bb)) {
                this.flushByteBuffer();
                this.appendByteArray(byArray, n, n2);
            }
        }
    }

    public void append(char[] cArray, int n, int n2) throws IOException {
        if (n2 <= this.cb.capacity() - this.cb.limit()) {
            this.transfer(cArray, n, n2, this.cb);
            return;
        }
        if (n2 + this.cb.limit() < 2 * this.cb.capacity()) {
            int n3 = this.transfer(cArray, n, n2, this.cb);
            this.flushCharBuffer();
            this.transfer(cArray, n + n3, n2 - n3, this.cb);
        } else {
            this.flushCharBuffer();
            this.realWriteChars(CharBuffer.wrap(cArray, n, n2));
        }
    }

    public void append(ByteBuffer byteBuffer) throws IOException {
        if (this.bb.remaining() == 0) {
            this.appendByteBuffer(byteBuffer);
        } else {
            this.transfer(byteBuffer, this.bb);
            if (byteBuffer.hasRemaining() && this.isFull(this.bb)) {
                this.flushByteBuffer();
                this.appendByteBuffer(byteBuffer);
            }
        }
    }

    private void appendByteArray(byte[] byArray, int n, int n2) throws IOException {
        if (n2 == 0) {
            return;
        }
        int n3 = this.bb.capacity();
        while (n2 > n3) {
            this.realWriteBytes(ByteBuffer.wrap(byArray, n, n3));
            n2 -= n3;
            n += n3;
        }
        if (n2 > 0) {
            this.transfer(byArray, n, n2, this.bb);
        }
    }

    private void appendByteBuffer(ByteBuffer byteBuffer) throws IOException {
        if (byteBuffer.remaining() == 0) {
            return;
        }
        int n = this.bb.capacity();
        int n2 = byteBuffer.limit();
        while (byteBuffer.remaining() > n) {
            byteBuffer.limit(byteBuffer.position() + n);
            this.realWriteBytes(byteBuffer.slice());
            byteBuffer.position(byteBuffer.limit());
            byteBuffer.limit(n2);
        }
        if (byteBuffer.remaining() > 0) {
            this.transfer(byteBuffer, this.bb);
        }
    }

    private void flushByteBuffer() throws IOException {
        this.realWriteBytes(this.bb.slice());
        this.clear(this.bb);
    }

    private void flushCharBuffer() throws IOException {
        this.realWriteChars(this.cb.slice());
        this.clear(this.cb);
    }

    private void transfer(byte by, ByteBuffer byteBuffer) {
        this.toWriteMode(byteBuffer);
        byteBuffer.put(by);
        this.toReadMode(byteBuffer);
    }

    private void transfer(char c, CharBuffer charBuffer) {
        this.toWriteMode(charBuffer);
        charBuffer.put(c);
        this.toReadMode(charBuffer);
    }

    private int transfer(byte[] byArray, int n, int n2, ByteBuffer byteBuffer) {
        this.toWriteMode(byteBuffer);
        int n3 = Math.min(n2, byteBuffer.remaining());
        if (n3 > 0) {
            byteBuffer.put(byArray, n, n3);
        }
        this.toReadMode(byteBuffer);
        return n3;
    }

    private int transfer(char[] cArray, int n, int n2, CharBuffer charBuffer) {
        this.toWriteMode(charBuffer);
        int n3 = Math.min(n2, charBuffer.remaining());
        if (n3 > 0) {
            charBuffer.put(cArray, n, n3);
        }
        this.toReadMode(charBuffer);
        return n3;
    }

    private int transfer(String string, int n, int n2, CharBuffer charBuffer) {
        this.toWriteMode(charBuffer);
        int n3 = Math.min(n2, charBuffer.remaining());
        if (n3 > 0) {
            charBuffer.put(string, n, n + n3);
        }
        this.toReadMode(charBuffer);
        return n3;
    }

    private void transfer(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        this.toWriteMode(byteBuffer2);
        int n = Math.min(byteBuffer.remaining(), byteBuffer2.remaining());
        if (n > 0) {
            int n2 = byteBuffer.limit();
            byteBuffer.limit(byteBuffer.position() + n);
            byteBuffer2.put(byteBuffer);
            byteBuffer.limit(n2);
        }
        this.toReadMode(byteBuffer2);
    }

    private void clear(Buffer buffer) {
        buffer.rewind().limit(0);
    }

    private boolean isFull(Buffer buffer) {
        return buffer.limit() == buffer.capacity();
    }

    private void toReadMode(Buffer buffer) {
        buffer.limit(buffer.position()).reset();
    }

    private void toWriteMode(Buffer buffer) {
        buffer.mark().position(buffer.limit()).limit(buffer.capacity());
    }

    private static class PrivilegedCreateConverter
    implements PrivilegedExceptionAction<C2BConverter> {
        private final Charset charset;

        PrivilegedCreateConverter(Charset charset) {
            this.charset = charset;
        }

        @Override
        public C2BConverter run() throws IOException {
            return new C2BConverter(this.charset);
        }
    }
}

