/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.core.scheduler;

import java.util.concurrent.TimeUnit;

public class Quantum {
    public static final Quantum SUSPENDED = new Quantum(TimeUnit.NANOSECONDS, -1);
    public final TimeUnit unit;
    public final int interval;

    public Quantum(TimeUnit unit, int interval) {
        this.unit = unit;
        this.interval = interval;
    }

    public static Quantum seconds(int interval) {
        return new Quantum(TimeUnit.SECONDS, interval);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Quantum other = (Quantum)obj;
        return this.getNanos() == other.getNanos();
    }

    public int hashCode() {
        return (int)(this.getNanos() % 321721L);
    }

    private long getNanos() {
        long multiplier = 1L;
        switch (this.unit) {
            case MICROSECONDS: {
                multiplier = 1000L;
                break;
            }
            case MILLISECONDS: {
                multiplier = 1000000L;
                break;
            }
            case SECONDS: {
                multiplier = 1000000000L;
                break;
            }
            case MINUTES: {
                multiplier = -129542144L;
                break;
            }
            case HOURS: {
                multiplier = 817405952L;
                break;
            }
            case DAYS: {
                multiplier = 1185955840L;
            }
        }
        return (long)this.interval * multiplier;
    }

    public String toString() {
        return this.interval + this.unit.toString();
    }
}

