/*
 * Decompiled with CFR 0.152.
 */
package java.time.chrono;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.time.Clock;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.ChronoLocalDateImpl;
import java.time.chrono.ChronoLocalDateTime;
import java.time.chrono.ChronoPeriod;
import java.time.chrono.MinguoChronology;
import java.time.chrono.MinguoEra;
import java.time.chrono.Ser;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.time.temporal.ValueRange;
import java.util.Objects;

public final class MinguoDate
extends ChronoLocalDateImpl<MinguoDate>
implements ChronoLocalDate,
Serializable {
    private static final long serialVersionUID = 1300372329181994526L;
    private final transient LocalDate isoDate;

    public static MinguoDate now() {
        return MinguoDate.now(Clock.systemDefaultZone());
    }

    public static MinguoDate now(ZoneId zoneId) {
        return MinguoDate.now(Clock.system(zoneId));
    }

    public static MinguoDate now(Clock clock) {
        return new MinguoDate(LocalDate.now(clock));
    }

    public static MinguoDate of(int n, int n2, int n3) {
        return new MinguoDate(LocalDate.of(n + 1911, n2, n3));
    }

    public static MinguoDate from(TemporalAccessor temporalAccessor) {
        return MinguoChronology.INSTANCE.date(temporalAccessor);
    }

    MinguoDate(LocalDate localDate) {
        Objects.requireNonNull(localDate, "isoDate");
        this.isoDate = localDate;
    }

    @Override
    public MinguoChronology getChronology() {
        return MinguoChronology.INSTANCE;
    }

    @Override
    public MinguoEra getEra() {
        return this.getProlepticYear() >= 1 ? MinguoEra.ROC : MinguoEra.BEFORE_ROC;
    }

    @Override
    public int lengthOfMonth() {
        return this.isoDate.lengthOfMonth();
    }

    @Override
    public ValueRange range(TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            if (this.isSupported(temporalField)) {
                ChronoField chronoField = (ChronoField)temporalField;
                switch (chronoField) {
                    case DAY_OF_MONTH: 
                    case DAY_OF_YEAR: 
                    case ALIGNED_WEEK_OF_MONTH: {
                        return this.isoDate.range(temporalField);
                    }
                    case YEAR_OF_ERA: {
                        ValueRange valueRange = ChronoField.YEAR.range();
                        long l = this.getProlepticYear() <= 0 ? -valueRange.getMinimum() + 1L + 1911L : valueRange.getMaximum() - 1911L;
                        return ValueRange.of(1L, l);
                    }
                }
                return this.getChronology().range(chronoField);
            }
            throw new UnsupportedTemporalTypeException("Unsupported field: " + temporalField);
        }
        return temporalField.rangeRefinedBy(this);
    }

    @Override
    public long getLong(TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            switch ((ChronoField)temporalField) {
                case PROLEPTIC_MONTH: {
                    return this.getProlepticMonth();
                }
                case YEAR_OF_ERA: {
                    int n = this.getProlepticYear();
                    return n >= 1 ? n : 1 - n;
                }
                case YEAR: {
                    return this.getProlepticYear();
                }
                case ERA: {
                    return this.getProlepticYear() >= 1 ? 1 : 0;
                }
            }
            return this.isoDate.getLong(temporalField);
        }
        return temporalField.getFrom(this);
    }

    private long getProlepticMonth() {
        return (long)this.getProlepticYear() * 12L + (long)this.isoDate.getMonthValue() - 1L;
    }

    private int getProlepticYear() {
        return this.isoDate.getYear() - 1911;
    }

    @Override
    public MinguoDate with(TemporalField temporalField, long l) {
        if (temporalField instanceof ChronoField) {
            ChronoField chronoField = (ChronoField)temporalField;
            if (this.getLong(chronoField) == l) {
                return this;
            }
            switch (chronoField) {
                case PROLEPTIC_MONTH: {
                    this.getChronology().range(chronoField).checkValidValue(l, chronoField);
                    return this.plusMonths(l - this.getProlepticMonth());
                }
                case YEAR_OF_ERA: 
                case YEAR: 
                case ERA: {
                    int n = this.getChronology().range(chronoField).checkValidIntValue(l, chronoField);
                    switch (chronoField) {
                        case YEAR_OF_ERA: {
                            return this.with(this.isoDate.withYear(this.getProlepticYear() >= 1 ? n + 1911 : 1 - n + 1911));
                        }
                        case YEAR: {
                            return this.with(this.isoDate.withYear(n + 1911));
                        }
                        case ERA: {
                            return this.with(this.isoDate.withYear(1 - this.getProlepticYear() + 1911));
                        }
                    }
                }
            }
            return this.with(this.isoDate.with(temporalField, l));
        }
        return (MinguoDate)super.with(temporalField, l);
    }

    @Override
    public MinguoDate with(TemporalAdjuster temporalAdjuster) {
        return (MinguoDate)super.with(temporalAdjuster);
    }

    @Override
    public MinguoDate plus(TemporalAmount temporalAmount) {
        return (MinguoDate)super.plus(temporalAmount);
    }

    @Override
    public MinguoDate minus(TemporalAmount temporalAmount) {
        return (MinguoDate)super.minus(temporalAmount);
    }

    @Override
    MinguoDate plusYears(long l) {
        return this.with(this.isoDate.plusYears(l));
    }

    @Override
    MinguoDate plusMonths(long l) {
        return this.with(this.isoDate.plusMonths(l));
    }

    @Override
    MinguoDate plusWeeks(long l) {
        return (MinguoDate)super.plusWeeks(l);
    }

    @Override
    MinguoDate plusDays(long l) {
        return this.with(this.isoDate.plusDays(l));
    }

    @Override
    public MinguoDate plus(long l, TemporalUnit temporalUnit) {
        return (MinguoDate)super.plus(l, temporalUnit);
    }

    @Override
    public MinguoDate minus(long l, TemporalUnit temporalUnit) {
        return (MinguoDate)super.minus(l, temporalUnit);
    }

    @Override
    MinguoDate minusYears(long l) {
        return (MinguoDate)super.minusYears(l);
    }

    @Override
    MinguoDate minusMonths(long l) {
        return (MinguoDate)super.minusMonths(l);
    }

    @Override
    MinguoDate minusWeeks(long l) {
        return (MinguoDate)super.minusWeeks(l);
    }

    @Override
    MinguoDate minusDays(long l) {
        return (MinguoDate)super.minusDays(l);
    }

    private MinguoDate with(LocalDate localDate) {
        return localDate.equals(this.isoDate) ? this : new MinguoDate(localDate);
    }

    public final ChronoLocalDateTime<MinguoDate> atTime(LocalTime localTime) {
        return super.atTime(localTime);
    }

    @Override
    public ChronoPeriod until(ChronoLocalDate chronoLocalDate) {
        Period period = this.isoDate.until(chronoLocalDate);
        return this.getChronology().period(period.getYears(), period.getMonths(), period.getDays());
    }

    @Override
    public long toEpochDay() {
        return this.isoDate.toEpochDay();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof MinguoDate) {
            MinguoDate minguoDate = (MinguoDate)object;
            return this.isoDate.equals(minguoDate.isoDate);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.getChronology().getId().hashCode() ^ this.isoDate.hashCode();
    }

    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        throw new InvalidObjectException("Deserialization via serialization delegate");
    }

    private Object writeReplace() {
        return new Ser(7, this);
    }

    void writeExternal(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.get(ChronoField.YEAR));
        dataOutput.writeByte(this.get(ChronoField.MONTH_OF_YEAR));
        dataOutput.writeByte(this.get(ChronoField.DAY_OF_MONTH));
    }

    static MinguoDate readExternal(DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        byte by = dataInput.readByte();
        byte by2 = dataInput.readByte();
        return MinguoChronology.INSTANCE.date(n, by, by2);
    }
}

