# Rubix ML

[![PHP from Packagist](https://img.shields.io/packagist/php-v/rubix/ml.svg?style=flat&colorB=8892BF)](https://www.php.net/) [![Latest Stable Version](https://img.shields.io/packagist/v/rubix/ml.svg?style=flat&colorB=orange)](https://packagist.org/packages/rubix/ml) [![Downloads from Packagist](https://img.shields.io/packagist/dt/rubix/ml.svg?style=flat&colorB=red)](https://packagist.org/packages/rubix/ml) [![Code Checks](https://github.com/RubixML/ML/actions/workflows/ci.yml/badge.svg)](https://github.com/RubixML/ML/actions/workflows/ci.yml) [![GitHub](https://img.shields.io/github/license/RubixML/RubixML)](https://github.com/RubixML/ML/blob/master/LICENSE.md)

A high-level machine learning and deep learning library for the [PHP](https://php.net) language.

- **Developer-friendly** API is delightful to use
- **40+** supervised and unsupervised learning algorithms
- **Support** for ETL, preprocessing, and cross-validation
- **Open source** and free to use commercially

## Installation
Install Rubix ML into your project using [Composer](https://getcomposer.org/):
```sh
$ composer require rubix/ml
```

### Requirements
- [PHP](https://php.net/manual/en/install.php) 7.4 or above

#### Recommended
- [Tensor extension](https://github.com/Scien-ide/Tensor) for fast Matrix/Vector computing

#### Optional

- [Extras Package](https://github.com/RubixML/Extras) for experimental features
- [GD extension](https://php.net/manual/en/book.image.php) for image support
- [Mbstring extension](https://www.php.net/manual/en/book.mbstring.php) for fast multibyte string manipulation
- [SVM extension](https://php.net/manual/en/book.svm.php) for Support Vector Machine engine (libsvm)
- [PDO extension](https://www.php.net/manual/en/book.pdo.php) for relational database support
- [GraphViz](https://graphviz.org/) for graph visualization

## Documentation
Read the latest docs [here](https://docs.rubixml.com).

## What is Rubix ML?
Rubix ML is a free open-source machine learning (ML) library that allows you to build programs that learn from your data using the PHP language. We provide tools for the entire machine learning life cycle from ETL to training, cross-validation, and production with over 40 supervised and unsupervised learning algorithms. In addition, we provide tutorials and other educational content to help you get started using ML in your projects.

## Getting Started
If you are new to machine learning, we recommend taking a look at the [What is Machine Learning?](https://docs.rubixml.com/latest/what-is-machine-learning.html) section to get started. If you are already familiar with basic ML concepts, you can browse the [basic introduction](https://docs.rubixml.com/latest/basic-introduction.html) for a brief look at a typical Rubix ML project. From there, you can browse the official tutorials below which range from beginner to advanced skill level.

### Tutorials & Example Projects
Check out these example projects using the Rubix ML library. Many come with instructions and a pre-cleaned dataset.

- [CIFAR-10 Image Recognizer](https://github.com/RubixML/CIFAR-10)
- [Color Clusterer](https://github.com/RubixML/Colors)
- [Credit Default Risk Predictor](https://github.com/RubixML/Credit)
- [Divorce Predictor](https://github.com/RubixML/Divorce)
- [DNA Taxonomer](https://github.com/RubixML/DNA)
- [Dota 2 Game Outcome Predictor](https://github.com/RubixML/Dota2)
- [Human Activity Recognizer](https://github.com/RubixML/HAR)
- [Housing Price Predictor](https://github.com/RubixML/Housing)
- [Iris Flower Classifier](https://github.com/RubixML/Iris)
- [MNIST Handwritten Digit Recognizer](https://github.com/RubixML/MNIST)
- [Text Sentiment Analyzer](https://github.com/RubixML/Sentiment)

## Interact With The Community

- [Join Our Telegram Channel](https://t.me/RubixML)

## Contributing
See [CONTRIBUTING.md](CONTRIBUTING.md) for guidelines.

## License
The code is licensed [MIT](LICENSE) and the documentation is licensed [CC BY-NC 4.0](https://creativecommons.org/licenses/by-nc/4.0/).
