/* inspect.c generated by valac 0.56.0, the Vala compiler
 * generated from inspect.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 * Copyright (C) 2012 Philip Withnall
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Philip Withnall <philip.withnall@collabora.co.uk>
 */

#include <glib-object.h>
#include <glib.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include "folks/folks.h"
#include <termios.h>
#include <stdio.h>
#include <locale.h>
#include <glib/gi18n-lib.h>
#include "config.h"
#include <glib-unix.h>
#include <signal.h>
#include <sys/types.h>
#include <gio/gio.h>
#include <unistd.h>
#include <readline/readline.h>
#include <readline/history.h>
#include <sys/wait.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define FOLKS_INSPECT_TYPE_CLIENT (folks_inspect_client_get_type ())
#define FOLKS_INSPECT_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_INSPECT_TYPE_CLIENT, FolksInspectClient))
#define FOLKS_INSPECT_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_INSPECT_TYPE_CLIENT, FolksInspectClientClass))
#define FOLKS_INSPECT_IS_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_INSPECT_TYPE_CLIENT))
#define FOLKS_INSPECT_IS_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_INSPECT_TYPE_CLIENT))
#define FOLKS_INSPECT_CLIENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_INSPECT_TYPE_CLIENT, FolksInspectClientClass))

typedef struct _FolksInspectClient FolksInspectClient;
typedef struct _FolksInspectClientClass FolksInspectClientClass;
typedef struct _FolksInspectClientPrivate FolksInspectClientPrivate;

#define FOLKS_INSPECT_TYPE_COMMAND (folks_inspect_command_get_type ())
#define FOLKS_INSPECT_COMMAND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_INSPECT_TYPE_COMMAND, FolksInspectCommand))
#define FOLKS_INSPECT_COMMAND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_INSPECT_TYPE_COMMAND, FolksInspectCommandClass))
#define FOLKS_INSPECT_IS_COMMAND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_INSPECT_TYPE_COMMAND))
#define FOLKS_INSPECT_IS_COMMAND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_INSPECT_TYPE_COMMAND))
#define FOLKS_INSPECT_COMMAND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_INSPECT_TYPE_COMMAND, FolksInspectCommandClass))

typedef struct _FolksInspectCommand FolksInspectCommand;
typedef struct _FolksInspectCommandClass FolksInspectCommandClass;

#define FOLKS_INSPECT_TYPE_SIGNAL_MANAGER (folks_inspect_signal_manager_get_type ())
#define FOLKS_INSPECT_SIGNAL_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_INSPECT_TYPE_SIGNAL_MANAGER, FolksInspectSignalManager))
#define FOLKS_INSPECT_SIGNAL_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_INSPECT_TYPE_SIGNAL_MANAGER, FolksInspectSignalManagerClass))
#define FOLKS_INSPECT_IS_SIGNAL_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_INSPECT_TYPE_SIGNAL_MANAGER))
#define FOLKS_INSPECT_IS_SIGNAL_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_INSPECT_TYPE_SIGNAL_MANAGER))
#define FOLKS_INSPECT_SIGNAL_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_INSPECT_TYPE_SIGNAL_MANAGER, FolksInspectSignalManagerClass))

typedef struct _FolksInspectSignalManager FolksInspectSignalManager;
typedef struct _FolksInspectSignalManagerClass FolksInspectSignalManagerClass;
enum  {
	FOLKS_INSPECT_CLIENT_0_PROPERTY,
	FOLKS_INSPECT_CLIENT_AGGREGATOR_PROPERTY,
	FOLKS_INSPECT_CLIENT_BACKEND_STORE_PROPERTY,
	FOLKS_INSPECT_CLIENT_SIGNAL_MANAGER_PROPERTY,
	FOLKS_INSPECT_CLIENT_NUM_PROPERTIES
};
static GParamSpec* folks_inspect_client_properties[FOLKS_INSPECT_CLIENT_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_io_channel_unref0(var) ((var == NULL) ? NULL : (var = (g_io_channel_unref (var), NULL)))
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define FOLKS_INSPECT_COMMANDS_TYPE_QUIT (folks_inspect_commands_quit_get_type ())
#define FOLKS_INSPECT_COMMANDS_QUIT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_INSPECT_COMMANDS_TYPE_QUIT, FolksInspectCommandsQuit))
#define FOLKS_INSPECT_COMMANDS_QUIT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_INSPECT_COMMANDS_TYPE_QUIT, FolksInspectCommandsQuitClass))
#define FOLKS_INSPECT_COMMANDS_IS_QUIT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_INSPECT_COMMANDS_TYPE_QUIT))
#define FOLKS_INSPECT_COMMANDS_IS_QUIT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_INSPECT_COMMANDS_TYPE_QUIT))
#define FOLKS_INSPECT_COMMANDS_QUIT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_INSPECT_COMMANDS_TYPE_QUIT, FolksInspectCommandsQuitClass))

typedef struct _FolksInspectCommandsQuit FolksInspectCommandsQuit;
typedef struct _FolksInspectCommandsQuitClass FolksInspectCommandsQuitClass;
#define _folks_inspect_command_unref0(var) ((var == NULL) ? NULL : (var = (folks_inspect_command_unref (var), NULL)))

#define FOLKS_INSPECT_COMMANDS_TYPE_HELP (folks_inspect_commands_help_get_type ())
#define FOLKS_INSPECT_COMMANDS_HELP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_INSPECT_COMMANDS_TYPE_HELP, FolksInspectCommandsHelp))
#define FOLKS_INSPECT_COMMANDS_HELP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_INSPECT_COMMANDS_TYPE_HELP, FolksInspectCommandsHelpClass))
#define FOLKS_INSPECT_COMMANDS_IS_HELP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_INSPECT_COMMANDS_TYPE_HELP))
#define FOLKS_INSPECT_COMMANDS_IS_HELP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_INSPECT_COMMANDS_TYPE_HELP))
#define FOLKS_INSPECT_COMMANDS_HELP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_INSPECT_COMMANDS_TYPE_HELP, FolksInspectCommandsHelpClass))

typedef struct _FolksInspectCommandsHelp FolksInspectCommandsHelp;
typedef struct _FolksInspectCommandsHelpClass FolksInspectCommandsHelpClass;

#define FOLKS_INSPECT_COMMANDS_TYPE_INDIVIDUALS (folks_inspect_commands_individuals_get_type ())
#define FOLKS_INSPECT_COMMANDS_INDIVIDUALS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_INSPECT_COMMANDS_TYPE_INDIVIDUALS, FolksInspectCommandsIndividuals))
#define FOLKS_INSPECT_COMMANDS_INDIVIDUALS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_INSPECT_COMMANDS_TYPE_INDIVIDUALS, FolksInspectCommandsIndividualsClass))
#define FOLKS_INSPECT_COMMANDS_IS_INDIVIDUALS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_INSPECT_COMMANDS_TYPE_INDIVIDUALS))
#define FOLKS_INSPECT_COMMANDS_IS_INDIVIDUALS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_INSPECT_COMMANDS_TYPE_INDIVIDUALS))
#define FOLKS_INSPECT_COMMANDS_INDIVIDUALS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_INSPECT_COMMANDS_TYPE_INDIVIDUALS, FolksInspectCommandsIndividualsClass))

typedef struct _FolksInspectCommandsIndividuals FolksInspectCommandsIndividuals;
typedef struct _FolksInspectCommandsIndividualsClass FolksInspectCommandsIndividualsClass;

#define FOLKS_INSPECT_COMMANDS_TYPE_LINKING (folks_inspect_commands_linking_get_type ())
#define FOLKS_INSPECT_COMMANDS_LINKING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_INSPECT_COMMANDS_TYPE_LINKING, FolksInspectCommandsLinking))
#define FOLKS_INSPECT_COMMANDS_LINKING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_INSPECT_COMMANDS_TYPE_LINKING, FolksInspectCommandsLinkingClass))
#define FOLKS_INSPECT_COMMANDS_IS_LINKING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_INSPECT_COMMANDS_TYPE_LINKING))
#define FOLKS_INSPECT_COMMANDS_IS_LINKING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_INSPECT_COMMANDS_TYPE_LINKING))
#define FOLKS_INSPECT_COMMANDS_LINKING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_INSPECT_COMMANDS_TYPE_LINKING, FolksInspectCommandsLinkingClass))

typedef struct _FolksInspectCommandsLinking FolksInspectCommandsLinking;
typedef struct _FolksInspectCommandsLinkingClass FolksInspectCommandsLinkingClass;

#define FOLKS_INSPECT_COMMANDS_TYPE_PERSONAS (folks_inspect_commands_personas_get_type ())
#define FOLKS_INSPECT_COMMANDS_PERSONAS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_INSPECT_COMMANDS_TYPE_PERSONAS, FolksInspectCommandsPersonas))
#define FOLKS_INSPECT_COMMANDS_PERSONAS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_INSPECT_COMMANDS_TYPE_PERSONAS, FolksInspectCommandsPersonasClass))
#define FOLKS_INSPECT_COMMANDS_IS_PERSONAS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_INSPECT_COMMANDS_TYPE_PERSONAS))
#define FOLKS_INSPECT_COMMANDS_IS_PERSONAS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_INSPECT_COMMANDS_TYPE_PERSONAS))
#define FOLKS_INSPECT_COMMANDS_PERSONAS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_INSPECT_COMMANDS_TYPE_PERSONAS, FolksInspectCommandsPersonasClass))

typedef struct _FolksInspectCommandsPersonas FolksInspectCommandsPersonas;
typedef struct _FolksInspectCommandsPersonasClass FolksInspectCommandsPersonasClass;

#define FOLKS_INSPECT_COMMANDS_TYPE_BACKENDS (folks_inspect_commands_backends_get_type ())
#define FOLKS_INSPECT_COMMANDS_BACKENDS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_INSPECT_COMMANDS_TYPE_BACKENDS, FolksInspectCommandsBackends))
#define FOLKS_INSPECT_COMMANDS_BACKENDS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_INSPECT_COMMANDS_TYPE_BACKENDS, FolksInspectCommandsBackendsClass))
#define FOLKS_INSPECT_COMMANDS_IS_BACKENDS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_INSPECT_COMMANDS_TYPE_BACKENDS))
#define FOLKS_INSPECT_COMMANDS_IS_BACKENDS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_INSPECT_COMMANDS_TYPE_BACKENDS))
#define FOLKS_INSPECT_COMMANDS_BACKENDS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_INSPECT_COMMANDS_TYPE_BACKENDS, FolksInspectCommandsBackendsClass))

typedef struct _FolksInspectCommandsBackends FolksInspectCommandsBackends;
typedef struct _FolksInspectCommandsBackendsClass FolksInspectCommandsBackendsClass;

#define FOLKS_INSPECT_COMMANDS_TYPE_PERSONA_STORES (folks_inspect_commands_persona_stores_get_type ())
#define FOLKS_INSPECT_COMMANDS_PERSONA_STORES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_INSPECT_COMMANDS_TYPE_PERSONA_STORES, FolksInspectCommandsPersonaStores))
#define FOLKS_INSPECT_COMMANDS_PERSONA_STORES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_INSPECT_COMMANDS_TYPE_PERSONA_STORES, FolksInspectCommandsPersonaStoresClass))
#define FOLKS_INSPECT_COMMANDS_IS_PERSONA_STORES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_INSPECT_COMMANDS_TYPE_PERSONA_STORES))
#define FOLKS_INSPECT_COMMANDS_IS_PERSONA_STORES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_INSPECT_COMMANDS_TYPE_PERSONA_STORES))
#define FOLKS_INSPECT_COMMANDS_PERSONA_STORES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_INSPECT_COMMANDS_TYPE_PERSONA_STORES, FolksInspectCommandsPersonaStoresClass))

typedef struct _FolksInspectCommandsPersonaStores FolksInspectCommandsPersonaStores;
typedef struct _FolksInspectCommandsPersonaStoresClass FolksInspectCommandsPersonaStoresClass;

#define FOLKS_INSPECT_COMMANDS_TYPE_SET (folks_inspect_commands_set_get_type ())
#define FOLKS_INSPECT_COMMANDS_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_INSPECT_COMMANDS_TYPE_SET, FolksInspectCommandsSet))
#define FOLKS_INSPECT_COMMANDS_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_INSPECT_COMMANDS_TYPE_SET, FolksInspectCommandsSetClass))
#define FOLKS_INSPECT_COMMANDS_IS_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_INSPECT_COMMANDS_TYPE_SET))
#define FOLKS_INSPECT_COMMANDS_IS_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_INSPECT_COMMANDS_TYPE_SET))
#define FOLKS_INSPECT_COMMANDS_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_INSPECT_COMMANDS_TYPE_SET, FolksInspectCommandsSetClass))

typedef struct _FolksInspectCommandsSet FolksInspectCommandsSet;
typedef struct _FolksInspectCommandsSetClass FolksInspectCommandsSetClass;

#define FOLKS_INSPECT_COMMANDS_TYPE_SIGNALS (folks_inspect_commands_signals_get_type ())
#define FOLKS_INSPECT_COMMANDS_SIGNALS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_INSPECT_COMMANDS_TYPE_SIGNALS, FolksInspectCommandsSignals))
#define FOLKS_INSPECT_COMMANDS_SIGNALS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_INSPECT_COMMANDS_TYPE_SIGNALS, FolksInspectCommandsSignalsClass))
#define FOLKS_INSPECT_COMMANDS_IS_SIGNALS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_INSPECT_COMMANDS_TYPE_SIGNALS))
#define FOLKS_INSPECT_COMMANDS_IS_SIGNALS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_INSPECT_COMMANDS_TYPE_SIGNALS))
#define FOLKS_INSPECT_COMMANDS_SIGNALS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_INSPECT_COMMANDS_TYPE_SIGNALS, FolksInspectCommandsSignalsClass))

typedef struct _FolksInspectCommandsSignals FolksInspectCommandsSignals;
typedef struct _FolksInspectCommandsSignalsClass FolksInspectCommandsSignalsClass;

#define FOLKS_INSPECT_COMMANDS_TYPE_DEBUG (folks_inspect_commands_debug_get_type ())
#define FOLKS_INSPECT_COMMANDS_DEBUG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_INSPECT_COMMANDS_TYPE_DEBUG, FolksInspectCommandsDebug))
#define FOLKS_INSPECT_COMMANDS_DEBUG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_INSPECT_COMMANDS_TYPE_DEBUG, FolksInspectCommandsDebugClass))
#define FOLKS_INSPECT_COMMANDS_IS_DEBUG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_INSPECT_COMMANDS_TYPE_DEBUG))
#define FOLKS_INSPECT_COMMANDS_IS_DEBUG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_INSPECT_COMMANDS_TYPE_DEBUG))
#define FOLKS_INSPECT_COMMANDS_DEBUG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_INSPECT_COMMANDS_TYPE_DEBUG, FolksInspectCommandsDebugClass))

typedef struct _FolksInspectCommandsDebug FolksInspectCommandsDebug;
typedef struct _FolksInspectCommandsDebugClass FolksInspectCommandsDebugClass;

#define FOLKS_INSPECT_COMMANDS_TYPE_SEARCH (folks_inspect_commands_search_get_type ())
#define FOLKS_INSPECT_COMMANDS_SEARCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_INSPECT_COMMANDS_TYPE_SEARCH, FolksInspectCommandsSearch))
#define FOLKS_INSPECT_COMMANDS_SEARCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_INSPECT_COMMANDS_TYPE_SEARCH, FolksInspectCommandsSearchClass))
#define FOLKS_INSPECT_COMMANDS_IS_SEARCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_INSPECT_COMMANDS_TYPE_SEARCH))
#define FOLKS_INSPECT_COMMANDS_IS_SEARCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_INSPECT_COMMANDS_TYPE_SEARCH))
#define FOLKS_INSPECT_COMMANDS_SEARCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_INSPECT_COMMANDS_TYPE_SEARCH, FolksInspectCommandsSearchClass))

typedef struct _FolksInspectCommandsSearch FolksInspectCommandsSearch;
typedef struct _FolksInspectCommandsSearchClass FolksInspectCommandsSearchClass;
typedef struct _Block2Data Block2Data;
typedef struct _FolksInspectClientWaitForQuiescenceData FolksInspectClientWaitForQuiescenceData;
typedef struct _FolksInspectClientRunNonInteractiveData FolksInspectClientRunNonInteractiveData;
typedef struct _FolksInspectClientRunInteractiveData FolksInspectClientRunInteractiveData;
typedef struct _Block3Data Block3Data;
typedef struct _FolksInspectCommandPrivate FolksInspectCommandPrivate;
typedef struct _FolksInspectParamSpecCommand FolksInspectParamSpecCommand;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _FolksInspectClient {
	GObject parent_instance;
	FolksInspectClientPrivate * priv;
	GeeHashMap* commands;
};

struct _FolksInspectClientClass {
	GObjectClass parent_class;
};

struct _FolksInspectClientPrivate {
	GMainLoop* main_loop;
	FolksIndividualAggregator* _aggregator;
	FolksBackendStore* _backend_store;
	FolksInspectSignalManager* _signal_manager;
	struct termios _original_termios_p;
	gboolean _original_termios_p_valid;
	gboolean _quit_after_pager_dies;
	GIOChannel* _stdin_channel;
	FILE* _pager_channel;
	guint _pager_child_watch_id;
};

struct _Block1Data {
	int _ref_count_;
	gint retval;
};

struct _Block2Data {
	int _ref_count_;
	FolksInspectClient* self;
	gboolean has_yielded;
	gpointer _async_data_;
};

struct _FolksInspectClientWaitForQuiescenceData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FolksInspectClient* self;
	Block2Data* _data2_;
	gulong signal_id;
	FolksIndividualAggregator* _tmp0_;
	gulong _tmp1_;
	FolksIndividualAggregator* _tmp2_;
	FolksIndividualAggregator* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	GError* _inner_error1_;
	FolksIndividualAggregator* _tmp6_;
	FolksIndividualAggregator* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	GError* _inner_error0_;
};

struct _FolksInspectClientRunNonInteractiveData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FolksInspectClient* self;
	gchar* command_line;
	gint result;
	gchar* subcommand;
	gchar* command_name;
	FolksInspectCommand* command;
	gchar* _tmp0_;
	gchar* _tmp1_;
	FolksInspectCommand* _tmp2_;
	FolksInspectCommand* _tmp3_;
	FILE* _tmp4_;
	const gchar* _tmp5_;
	GError* e1;
	FILE* _tmp6_;
	GError* _tmp7_;
	const gchar* _tmp8_;
	gint retval;
	FolksInspectCommand* _tmp9_;
	const gchar* _tmp10_;
	GError* _inner_error0_;
};

struct _FolksInspectClientRunInteractiveData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FolksInspectClient* self;
	gint result;
	struct termios _tmp0_;
	gint _tmp1_;
	FILE* _tmp2_;
	GIOChannel* _tmp3_;
	FolksIndividualAggregator* _tmp4_;
};

struct _Block3Data {
	int _ref_count_;
	FolksInspectCommand* command;
};

struct _FolksInspectCommand {
	GTypeInstance parent_instance;
	volatile int ref_count;
	FolksInspectCommandPrivate * priv;
	FolksInspectClient* client;
};

struct _FolksInspectCommandClass {
	GTypeClass parent_class;
	void (*finalize) (FolksInspectCommand *self);
	void (*run) (FolksInspectCommand* self, const gchar* command_string, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gint (*run_finish) (FolksInspectCommand* self, GAsyncResult* _res_);
	gchar** (*complete_subcommand) (FolksInspectCommand* self, const gchar* subcommand, gint* result_length1);
	const gchar* (*get_name) (FolksInspectCommand* self);
	const gchar* (*get_description) (FolksInspectCommand* self);
	const gchar* (*get_help) (FolksInspectCommand* self);
};

struct _FolksInspectParamSpecCommand {
	GParamSpec parent_instance;
};

VALA_EXTERN FolksInspectClient* main_client;
FolksInspectClient* main_client = NULL;
static gint FolksInspectClient_private_offset;
static gpointer folks_inspect_client_parent_class = NULL;
static gboolean folks_inspect_client__is_readline_installed;
static gboolean folks_inspect_client__is_readline_installed = FALSE;
static GPid folks_inspect_client__pager_pid;
static GPid folks_inspect_client__pager_pid = (GPid) 0;
static guint folks_inspect_client__stdin_watch_id;
static guint folks_inspect_client__stdin_watch_id = (guint) 0;
VALA_EXTERN FILE* folks_inspect_utils_output_filestream;
static gpointer folks_inspect_command_parent_class = NULL;

VALA_EXTERN GType folks_inspect_client_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FolksInspectClient, g_object_unref)
VALA_EXTERN gpointer folks_inspect_command_ref (gpointer instance);
VALA_EXTERN void folks_inspect_command_unref (gpointer instance);
VALA_EXTERN GParamSpec* folks_inspect_param_spec_command (const gchar* name,
                                              const gchar* nick,
                                              const gchar* blurb,
                                              GType object_type,
                                              GParamFlags flags);
VALA_EXTERN void folks_inspect_value_set_command (GValue* value,
                                      gpointer v_object);
VALA_EXTERN void folks_inspect_value_take_command (GValue* value,
                                       gpointer v_object);
VALA_EXTERN gpointer folks_inspect_value_get_command (const GValue* value);
VALA_EXTERN GType folks_inspect_command_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FolksInspectCommand, folks_inspect_command_unref)
VALA_EXTERN GType folks_inspect_signal_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FolksInspectSignalManager, g_object_unref)
static gint folks_inspect_client_main (gchar** args,
                                gint args_length1);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
VALA_EXTERN FolksInspectClient* folks_inspect_client_new (void);
VALA_EXTERN FolksInspectClient* folks_inspect_client_construct (GType object_type);
static gboolean __lambda4_ (void);
VALA_EXTERN void folks_inspect_client_quit (FolksInspectClient* self);
static gboolean ___lambda4__gsource_func (gpointer self);
VALA_EXTERN void folks_inspect_client_run_interactive (FolksInspectClient* self,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
VALA_EXTERN gint folks_inspect_client_run_interactive_finish (FolksInspectClient* self,
                                                  GAsyncResult* _res_);
VALA_EXTERN void folks_inspect_client_run_non_interactive (FolksInspectClient* self,
                                               const gchar* command_line,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_);
VALA_EXTERN gint folks_inspect_client_run_non_interactive_finish (FolksInspectClient* self,
                                                      GAsyncResult* _res_);
static void ___lambda9_ (Block1Data* _data1_,
                  GObject* obj,
                  GAsyncResult* res);
static void ____lambda9__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
VALA_EXTERN void folks_inspect_utils_init (void);
VALA_EXTERN FolksInspectCommandsQuit* folks_inspect_commands_quit_new (FolksInspectClient* client);
VALA_EXTERN FolksInspectCommandsQuit* folks_inspect_commands_quit_construct (GType object_type,
                                                                 FolksInspectClient* client);
VALA_EXTERN GType folks_inspect_commands_quit_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FolksInspectCommandsQuit, folks_inspect_command_unref)
VALA_EXTERN FolksInspectCommandsHelp* folks_inspect_commands_help_new (FolksInspectClient* client);
VALA_EXTERN FolksInspectCommandsHelp* folks_inspect_commands_help_construct (GType object_type,
                                                                 FolksInspectClient* client);
VALA_EXTERN GType folks_inspect_commands_help_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FolksInspectCommandsHelp, folks_inspect_command_unref)
VALA_EXTERN FolksInspectCommandsIndividuals* folks_inspect_commands_individuals_new (FolksInspectClient* client);
VALA_EXTERN FolksInspectCommandsIndividuals* folks_inspect_commands_individuals_construct (GType object_type,
                                                                               FolksInspectClient* client);
VALA_EXTERN GType folks_inspect_commands_individuals_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FolksInspectCommandsIndividuals, folks_inspect_command_unref)
VALA_EXTERN FolksInspectCommandsLinking* folks_inspect_commands_linking_new (FolksInspectClient* client);
VALA_EXTERN FolksInspectCommandsLinking* folks_inspect_commands_linking_construct (GType object_type,
                                                                       FolksInspectClient* client);
VALA_EXTERN GType folks_inspect_commands_linking_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FolksInspectCommandsLinking, folks_inspect_command_unref)
VALA_EXTERN FolksInspectCommandsPersonas* folks_inspect_commands_personas_new (FolksInspectClient* client);
VALA_EXTERN FolksInspectCommandsPersonas* folks_inspect_commands_personas_construct (GType object_type,
                                                                         FolksInspectClient* client);
VALA_EXTERN GType folks_inspect_commands_personas_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FolksInspectCommandsPersonas, folks_inspect_command_unref)
VALA_EXTERN FolksInspectCommandsBackends* folks_inspect_commands_backends_new (FolksInspectClient* client);
VALA_EXTERN FolksInspectCommandsBackends* folks_inspect_commands_backends_construct (GType object_type,
                                                                         FolksInspectClient* client);
VALA_EXTERN GType folks_inspect_commands_backends_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FolksInspectCommandsBackends, folks_inspect_command_unref)
VALA_EXTERN FolksInspectCommandsPersonaStores* folks_inspect_commands_persona_stores_new (FolksInspectClient* client);
VALA_EXTERN FolksInspectCommandsPersonaStores* folks_inspect_commands_persona_stores_construct (GType object_type,
                                                                                    FolksInspectClient* client);
VALA_EXTERN GType folks_inspect_commands_persona_stores_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FolksInspectCommandsPersonaStores, folks_inspect_command_unref)
VALA_EXTERN FolksInspectCommandsSet* folks_inspect_commands_set_new (FolksInspectClient* client);
VALA_EXTERN FolksInspectCommandsSet* folks_inspect_commands_set_construct (GType object_type,
                                                               FolksInspectClient* client);
VALA_EXTERN GType folks_inspect_commands_set_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FolksInspectCommandsSet, folks_inspect_command_unref)
VALA_EXTERN FolksInspectCommandsSignals* folks_inspect_commands_signals_new (FolksInspectClient* client);
VALA_EXTERN FolksInspectCommandsSignals* folks_inspect_commands_signals_construct (GType object_type,
                                                                       FolksInspectClient* client);
VALA_EXTERN GType folks_inspect_commands_signals_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FolksInspectCommandsSignals, folks_inspect_command_unref)
VALA_EXTERN FolksInspectCommandsDebug* folks_inspect_commands_debug_new (FolksInspectClient* client);
VALA_EXTERN FolksInspectCommandsDebug* folks_inspect_commands_debug_construct (GType object_type,
                                                                   FolksInspectClient* client);
VALA_EXTERN GType folks_inspect_commands_debug_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FolksInspectCommandsDebug, folks_inspect_command_unref)
VALA_EXTERN FolksInspectCommandsSearch* folks_inspect_commands_search_new (FolksInspectClient* client);
VALA_EXTERN FolksInspectCommandsSearch* folks_inspect_commands_search_construct (GType object_type,
                                                                     FolksInspectClient* client);
VALA_EXTERN GType folks_inspect_commands_search_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FolksInspectCommandsSearch, folks_inspect_command_unref)
VALA_EXTERN FolksInspectSignalManager* folks_inspect_signal_manager_new (void);
VALA_EXTERN FolksInspectSignalManager* folks_inspect_signal_manager_construct (GType object_type);
static void folks_inspect_client_set_signal_manager (FolksInspectClient* self,
                                              FolksInspectSignalManager* value);
static void folks_inspect_client_set_backend_store (FolksInspectClient* self,
                                             FolksBackendStore* value);
static void folks_inspect_client_set_aggregator (FolksInspectClient* self,
                                          FolksIndividualAggregator* value);
static void _folks_inspect_client_stop_paged_output (FolksInspectClient* self);
static void _folks_inspect_client_uninstall_readline_and_stdin (FolksInspectClient* self);
static void _folks_inspect_client_wait_for_quiescence_data_free (gpointer _data);
static void _folks_inspect_client_wait_for_quiescence (FolksInspectClient* self,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_);
static void _folks_inspect_client_wait_for_quiescence_finish (FolksInspectClient* self,
                                                       GAsyncResult* _res_,
                                                       GError** error);
static gboolean _folks_inspect_client_wait_for_quiescence_co (FolksInspectClientWaitForQuiescenceData* _data_);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
VALA_EXTERN FolksIndividualAggregator* folks_inspect_client_get_aggregator (FolksInspectClient* self);
static void __lambda8_ (Block2Data* _data2_,
                 GObject* obj,
                 GParamSpec* pspec);
static void ___lambda8__g_object_notify (GObject* _sender,
                                  GParamSpec* pspec,
                                  gpointer self);
static void _folks_inspect_client_wait_for_quiescence_ready (GObject* source_object,
                                                      GAsyncResult* _res_,
                                                      gpointer _user_data_);
static void folks_inspect_client_run_non_interactive_data_free (gpointer _data);
static gboolean folks_inspect_client_run_non_interactive_co (FolksInspectClientRunNonInteractiveData* _data_);
static FolksInspectCommand* folks_inspect_client_parse_command_line (const gchar* command_line,
                                                              gchar** command_name,
                                                              gchar** subcommand);
static void folks_inspect_client_run_non_interactive_ready (GObject* source_object,
                                                     GAsyncResult* _res_,
                                                     gpointer _user_data_);
VALA_EXTERN void folks_inspect_command_run (FolksInspectCommand* self,
                                const gchar* command_string,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_);
VALA_EXTERN gint folks_inspect_command_run_finish (FolksInspectCommand* self,
                                       GAsyncResult* _res_);
static void folks_inspect_client_run_interactive_data_free (gpointer _data);
static gboolean folks_inspect_client_run_interactive_co (FolksInspectClientRunInteractiveData* _data_);
static gboolean __lambda5_ (FolksInspectClient* self);
static gboolean ___lambda5__gsource_func (gpointer self);
static gchar** folks_inspect_client_completion_cb (const gchar* word,
                                            gint start,
                                            gint end);
static gchar** _folks_inspect_client_completion_cb_rl_completion_func_t (const gchar* str,
                                                                  gint a,
                                                                  gint b);
static void _folks_inspect_client_install_readline_and_stdin (FolksInspectClient* self);
static gboolean _folks_inspect_client_stdin_handler_cb (FolksInspectClient* self,
                                                 GIOChannel* source,
                                                 GIOCondition cond);
static gboolean __folks_inspect_client_stdin_handler_cb_gio_func (GIOChannel* source,
                                                           GIOCondition condition,
                                                           gpointer self);
static void _folks_inspect_client_readline_handler_cb (const gchar* _command_line);
static void __folks_inspect_client_readline_handler_cb_rl_vcpfunc_t (const gchar* s);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void _folks_inspect_client_start_paged_output (FolksInspectClient* self);
static void ___lambda7_ (Block3Data* _data3_,
                  GObject* obj,
                  GAsyncResult* res);
static void ____lambda7__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void __lambda6_ (FolksInspectClient* self,
                 GPid pid,
                 gint status);
static void ___lambda6__gchild_watch_func (GPid pid,
                                    gint wait_status,
                                    gpointer self);
VALA_EXTERN gchar* folks_inspect_utils_command_name_completion_cb (const gchar* word,
                                                       gint state);
static gchar* _folks_inspect_utils_command_name_completion_cb_rl_compentry_func_t (const gchar* str,
                                                                            gint a);
static gchar** _vala_array_dup15 (gchar** self,
                           gssize length);
VALA_EXTERN gchar** folks_inspect_command_complete_subcommand (FolksInspectCommand* self,
                                                   const gchar* subcommand,
                                                   gint* result_length1);
VALA_EXTERN FolksBackendStore* folks_inspect_client_get_backend_store (FolksInspectClient* self);
VALA_EXTERN FolksInspectSignalManager* folks_inspect_client_get_signal_manager (FolksInspectClient* self);
static void folks_inspect_client_finalize (GObject * obj);
static GType folks_inspect_client_get_type_once (void);
static void _vala_folks_inspect_client_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_folks_inspect_client_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec);
VALA_EXTERN FolksInspectCommand* folks_inspect_command_construct (GType object_type,
                                                      FolksInspectClient* client);
static gchar** folks_inspect_command_real_complete_subcommand (FolksInspectCommand* self,
                                                        const gchar* subcommand,
                                                        gint* result_length1);
VALA_EXTERN const gchar* folks_inspect_command_get_name (FolksInspectCommand* self);
VALA_EXTERN const gchar* folks_inspect_command_get_description (FolksInspectCommand* self);
VALA_EXTERN const gchar* folks_inspect_command_get_help (FolksInspectCommand* self);
static void folks_inspect_command_finalize (FolksInspectCommand * obj);
static GType folks_inspect_command_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
folks_inspect_client_get_instance_private (FolksInspectClient* self)
{
	return G_STRUCT_MEMBER_P (self, FolksInspectClient_private_offset);
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		g_slice_free (Block1Data, _data1_);
	}
}

static gboolean
__lambda4_ (void)
{
	gboolean result;
	if (folks_inspect_client__pager_pid != ((GPid) 0)) {
		FolksInspectClient* _tmp0_;
		_tmp0_ = main_client;
		_tmp0_->priv->_quit_after_pager_dies = TRUE;
		kill ((pid_t) folks_inspect_client__pager_pid, (gint) SIGTERM);
	} else {
		FolksInspectClient* _tmp1_;
		_tmp1_ = main_client;
		folks_inspect_client_quit (_tmp1_);
	}
	result = FALSE;
	return result;
}

static gboolean
___lambda4__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda4_ ();
	return result;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

static void
___lambda9_ (Block1Data* _data1_,
             GObject* obj,
             GAsyncResult* res)
{
	FolksInspectClient* _tmp0_;
	FolksInspectClient* _tmp1_;
	g_return_if_fail (res != NULL);
	_tmp0_ = main_client;
	_data1_->retval = folks_inspect_client_run_non_interactive_finish (_tmp0_, res);
	_tmp1_ = main_client;
	folks_inspect_client_quit (_tmp1_);
}

static void
____lambda9__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	___lambda9_ (self, source_object, res);
	block1_data_unref (self);
}

static gint
folks_inspect_client_main (gchar** args,
                           gint args_length1)
{
	Block1Data* _data1_;
	GOptionContext* context = NULL;
	GOptionContext* _tmp0_;
	GOptionContext* _tmp1_;
	FolksInspectClient* _tmp8_;
	FolksInspectClient* _tmp15_;
	GMainLoop* _tmp16_;
	GError* _inner_error0_ = NULL;
	gint result;
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->retval = 0;
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALE_DIR);
	textdomain (GETTEXT_PACKAGE);
	_tmp0_ = g_option_context_new ("[COMMAND]");
	context = _tmp0_;
	_tmp1_ = context;
	g_option_context_set_summary (_tmp1_, "Inspect meta-contact information in libfolks.");
	{
		GOptionContext* _tmp2_;
		_tmp2_ = context;
		g_option_context_parse (_tmp2_, (gint*) (&args_length1), &args, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gint _tmp3_ = -1;
			if (_inner_error0_->domain == G_OPTION_ERROR) {
				goto __catch0_g_option_error;
			}
			_g_option_context_free0 (context);
			block1_data_unref (_data1_);
			_data1_ = NULL;
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp3_;
		}
	}
	goto __finally0;
	__catch0_g_option_error:
	{
		GError* e1 = NULL;
		FILE* _tmp4_;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e1 = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = stderr;
		_tmp5_ = e1;
		_tmp6_ = _tmp5_->message;
		fprintf (_tmp4_, "Couldn’t parse command line options: %s\n", _tmp6_);
		result = 1;
		_g_error_free0 (e1);
		_g_option_context_free0 (context);
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp7_ = -1;
		_g_option_context_free0 (context);
		block1_data_unref (_data1_);
		_data1_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp7_;
	}
	_tmp8_ = folks_inspect_client_new ();
	_g_object_unref0 (main_client);
	main_client = _tmp8_;
	g_unix_signal_add_full (G_PRIORITY_DEFAULT, (gint) SIGTERM, ___lambda4__gsource_func, NULL, NULL);
	if (args_length1 == 1) {
		FolksInspectClient* _tmp9_;
		_tmp9_ = main_client;
		folks_inspect_client_run_interactive (_tmp9_, NULL, NULL);
		_data1_->retval = 0;
	} else {
		gchar* command_line = NULL;
		const gchar* _tmp10_;
		FolksInspectClient* _tmp13_;
		const gchar* _tmp14_;
		_vala_assert (args_length1 > 1, "args.length > 1");
		_tmp10_ = args[1];
		if (g_strcmp0 (_tmp10_, "--") == 0) {
			gchar* _tmp11_;
			_tmp11_ = _vala_g_strjoinv (" ", args + 2, (gint) (0 - 2));
			_g_free0 (command_line);
			command_line = _tmp11_;
		} else {
			gchar* _tmp12_;
			_tmp12_ = _vala_g_strjoinv (" ", args + 1, (gint) (0 - 1));
			_g_free0 (command_line);
			command_line = _tmp12_;
		}
		_tmp13_ = main_client;
		_tmp14_ = command_line;
		folks_inspect_client_run_non_interactive (_tmp13_, _tmp14_, ____lambda9__gasync_ready_callback, block1_data_ref (_data1_));
		_g_free0 (command_line);
	}
	_tmp15_ = main_client;
	_tmp16_ = _tmp15_->priv->main_loop;
	g_main_loop_run (_tmp16_);
	result = _data1_->retval;
	_g_option_context_free0 (context);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return result;
}

int
main (int argc,
      char ** argv)
{
	return folks_inspect_client_main (argv, argc);
}

FolksInspectClient*
folks_inspect_client_construct (GType object_type)
{
	FolksInspectClient * self = NULL;
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	FolksInspectCommandsQuit* _tmp2_;
	FolksInspectCommandsQuit* _tmp3_;
	GeeHashMap* _tmp4_;
	FolksInspectCommandsHelp* _tmp5_;
	FolksInspectCommandsHelp* _tmp6_;
	GeeHashMap* _tmp7_;
	FolksInspectCommandsIndividuals* _tmp8_;
	FolksInspectCommandsIndividuals* _tmp9_;
	GeeHashMap* _tmp10_;
	FolksInspectCommandsLinking* _tmp11_;
	FolksInspectCommandsLinking* _tmp12_;
	GeeHashMap* _tmp13_;
	FolksInspectCommandsPersonas* _tmp14_;
	FolksInspectCommandsPersonas* _tmp15_;
	GeeHashMap* _tmp16_;
	FolksInspectCommandsBackends* _tmp17_;
	FolksInspectCommandsBackends* _tmp18_;
	GeeHashMap* _tmp19_;
	FolksInspectCommandsPersonaStores* _tmp20_;
	FolksInspectCommandsPersonaStores* _tmp21_;
	GeeHashMap* _tmp22_;
	FolksInspectCommandsSet* _tmp23_;
	FolksInspectCommandsSet* _tmp24_;
	GeeHashMap* _tmp25_;
	FolksInspectCommandsSignals* _tmp26_;
	FolksInspectCommandsSignals* _tmp27_;
	GeeHashMap* _tmp28_;
	FolksInspectCommandsDebug* _tmp29_;
	FolksInspectCommandsDebug* _tmp30_;
	GeeHashMap* _tmp31_;
	FolksInspectCommandsSearch* _tmp32_;
	FolksInspectCommandsSearch* _tmp33_;
	GMainLoop* _tmp34_;
	FolksInspectSignalManager* _tmp35_;
	FolksInspectSignalManager* _tmp36_;
	FolksBackendStore* _tmp37_;
	FolksBackendStore* _tmp38_;
	FolksIndividualAggregator* _tmp39_;
	FolksIndividualAggregator* _tmp40_;
	self = (FolksInspectClient*) g_object_new (object_type, NULL);
	folks_inspect_utils_init ();
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, FOLKS_INSPECT_TYPE_COMMAND, (GBoxedCopyFunc) folks_inspect_command_ref, (GDestroyNotify) folks_inspect_command_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->commands);
	self->commands = _tmp0_;
	_tmp1_ = self->commands;
	_tmp2_ = folks_inspect_commands_quit_new (self);
	_tmp3_ = _tmp2_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp1_, "quit", (FolksInspectCommand*) _tmp3_);
	_folks_inspect_command_unref0 (_tmp3_);
	_tmp4_ = self->commands;
	_tmp5_ = folks_inspect_commands_help_new (self);
	_tmp6_ = _tmp5_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp4_, "help", (FolksInspectCommand*) _tmp6_);
	_folks_inspect_command_unref0 (_tmp6_);
	_tmp7_ = self->commands;
	_tmp8_ = folks_inspect_commands_individuals_new (self);
	_tmp9_ = _tmp8_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp7_, "individuals", (FolksInspectCommand*) _tmp9_);
	_folks_inspect_command_unref0 (_tmp9_);
	_tmp10_ = self->commands;
	_tmp11_ = folks_inspect_commands_linking_new (self);
	_tmp12_ = _tmp11_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp10_, "linking", (FolksInspectCommand*) _tmp12_);
	_folks_inspect_command_unref0 (_tmp12_);
	_tmp13_ = self->commands;
	_tmp14_ = folks_inspect_commands_personas_new (self);
	_tmp15_ = _tmp14_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp13_, "personas", (FolksInspectCommand*) _tmp15_);
	_folks_inspect_command_unref0 (_tmp15_);
	_tmp16_ = self->commands;
	_tmp17_ = folks_inspect_commands_backends_new (self);
	_tmp18_ = _tmp17_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp16_, "backends", (FolksInspectCommand*) _tmp18_);
	_folks_inspect_command_unref0 (_tmp18_);
	_tmp19_ = self->commands;
	_tmp20_ = folks_inspect_commands_persona_stores_new (self);
	_tmp21_ = _tmp20_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp19_, "persona-stores", (FolksInspectCommand*) _tmp21_);
	_folks_inspect_command_unref0 (_tmp21_);
	_tmp22_ = self->commands;
	_tmp23_ = folks_inspect_commands_set_new (self);
	_tmp24_ = _tmp23_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp22_, "set", (FolksInspectCommand*) _tmp24_);
	_folks_inspect_command_unref0 (_tmp24_);
	_tmp25_ = self->commands;
	_tmp26_ = folks_inspect_commands_signals_new (self);
	_tmp27_ = _tmp26_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp25_, "signals", (FolksInspectCommand*) _tmp27_);
	_folks_inspect_command_unref0 (_tmp27_);
	_tmp28_ = self->commands;
	_tmp29_ = folks_inspect_commands_debug_new (self);
	_tmp30_ = _tmp29_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp28_, "debug", (FolksInspectCommand*) _tmp30_);
	_folks_inspect_command_unref0 (_tmp30_);
	_tmp31_ = self->commands;
	_tmp32_ = folks_inspect_commands_search_new (self);
	_tmp33_ = _tmp32_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp31_, "search", (FolksInspectCommand*) _tmp33_);
	_folks_inspect_command_unref0 (_tmp33_);
	_tmp34_ = g_main_loop_new (NULL, FALSE);
	_g_main_loop_unref0 (self->priv->main_loop);
	self->priv->main_loop = _tmp34_;
	_tmp35_ = folks_inspect_signal_manager_new ();
	_tmp36_ = _tmp35_;
	folks_inspect_client_set_signal_manager (self, _tmp36_);
	_g_object_unref0 (_tmp36_);
	_tmp37_ = folks_backend_store_dup ();
	_tmp38_ = _tmp37_;
	folks_inspect_client_set_backend_store (self, _tmp38_);
	_g_object_unref0 (_tmp38_);
	_tmp39_ = folks_individual_aggregator_dup ();
	_tmp40_ = _tmp39_;
	folks_inspect_client_set_aggregator (self, _tmp40_);
	_g_object_unref0 (_tmp40_);
	return self;
}

FolksInspectClient*
folks_inspect_client_new (void)
{
	return folks_inspect_client_construct (FOLKS_INSPECT_TYPE_CLIENT);
}

void
folks_inspect_client_quit (FolksInspectClient* self)
{
	GMainLoop* _tmp1_;
	g_return_if_fail (self != NULL);
	_folks_inspect_client_stop_paged_output (self);
	if (folks_inspect_client__is_readline_installed) {
		_folks_inspect_client_uninstall_readline_and_stdin (self);
	}
	if (self->priv->_original_termios_p_valid) {
		struct termios _tmp0_;
		_tmp0_ = self->priv->_original_termios_p;
		tcsetattr (STDIN_FILENO, TCSADRAIN, &_tmp0_);
	}
	_tmp1_ = self->priv->main_loop;
	g_main_loop_quit (_tmp1_);
}

static void
_folks_inspect_client_wait_for_quiescence_data_free (gpointer _data)
{
	FolksInspectClientWaitForQuiescenceData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksInspectClientWaitForQuiescenceData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_folks_inspect_client_wait_for_quiescence (FolksInspectClient* self,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_)
{
	FolksInspectClientWaitForQuiescenceData* _data_;
	FolksInspectClient* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (FolksInspectClientWaitForQuiescenceData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, _folks_inspect_client_wait_for_quiescence_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_folks_inspect_client_wait_for_quiescence_co (_data_);
}

static void
_folks_inspect_client_wait_for_quiescence_finish (FolksInspectClient* self,
                                                  GAsyncResult* _res_,
                                                  GError** error)
{
	FolksInspectClientWaitForQuiescenceData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		FolksInspectClient* self;
		self = _data2_->self;
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static void
__lambda8_ (Block2Data* _data2_,
            GObject* obj,
            GParamSpec* pspec)
{
	FolksInspectClient* self;
	self = _data2_->self;
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	if (_data2_->has_yielded == TRUE) {
		_folks_inspect_client_wait_for_quiescence_co (_data2_->_async_data_);
	}
}

static void
___lambda8__g_object_notify (GObject* _sender,
                             GParamSpec* pspec,
                             gpointer self)
{
	__lambda8_ (self, _sender, pspec);
}

static void
_folks_inspect_client_wait_for_quiescence_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_)
{
	FolksInspectClientWaitForQuiescenceData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_folks_inspect_client_wait_for_quiescence_co (_data_);
}

static gboolean
_folks_inspect_client_wait_for_quiescence_co (FolksInspectClientWaitForQuiescenceData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data2_ = g_slice_new0 (Block2Data);
	_data_->_data2_->_ref_count_ = 1;
	_data_->_data2_->self = g_object_ref (_data_->self);
	_data_->_data2_->_async_data_ = _data_;
	_data_->_data2_->has_yielded = FALSE;
	_data_->_tmp0_ = _data_->self->priv->_aggregator;
	_data_->_tmp1_ = g_signal_connect_data ((GObject*) _data_->_tmp0_, "notify::is-quiescent", (GCallback) ___lambda8__g_object_notify, block2_data_ref (_data_->_data2_), (GClosureNotify) block2_data_unref, 0);
	_data_->signal_id = _data_->_tmp1_;
	{
		_data_->_tmp2_ = _data_->self->priv->_aggregator;
		_data_->_state_ = 1;
		folks_individual_aggregator_prepare (_data_->_tmp2_, _folks_inspect_client_wait_for_quiescence_ready, _data_);
		return FALSE;
		_state_1:
		folks_individual_aggregator_prepare_finish (_data_->_tmp2_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __finally0;
		}
		_data_->_tmp3_ = _data_->self->priv->_aggregator;
		_data_->_tmp4_ = folks_individual_aggregator_get_is_quiescent (_data_->_tmp3_);
		_data_->_tmp5_ = _data_->_tmp4_;
		if (_data_->_tmp5_ == FALSE) {
			_data_->_data2_->has_yielded = TRUE;
			_data_->_state_ = 2;
			return FALSE;
			_state_2:
			;
		}
	}
	__finally0:
	{
		_data_->_tmp6_ = _data_->self->priv->_aggregator;
		g_signal_handler_disconnect ((GObject*) _data_->_tmp6_, _data_->signal_id);
		_data_->_tmp7_ = _data_->self->priv->_aggregator;
		_data_->_tmp8_ = folks_individual_aggregator_get_is_quiescent (_data_->_tmp7_);
		_data_->_tmp9_ = _data_->_tmp8_;
		_vala_assert (_data_->_tmp9_ == TRUE, "this.aggregator.is_quiescent == true");
	}
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		block2_data_unref (_data_->_data2_);
		_data_->_data2_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	block2_data_unref (_data_->_data2_);
	_data_->_data2_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
folks_inspect_client_run_non_interactive_data_free (gpointer _data)
{
	FolksInspectClientRunNonInteractiveData* _data_;
	_data_ = _data;
	_g_free0 (_data_->command_line);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksInspectClientRunNonInteractiveData, _data_);
}

void
folks_inspect_client_run_non_interactive (FolksInspectClient* self,
                                          const gchar* command_line,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_)
{
	FolksInspectClientRunNonInteractiveData* _data_;
	FolksInspectClient* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (command_line != NULL);
	_data_ = g_slice_new0 (FolksInspectClientRunNonInteractiveData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, folks_inspect_client_run_non_interactive_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (command_line);
	_g_free0 (_data_->command_line);
	_data_->command_line = _tmp1_;
	folks_inspect_client_run_non_interactive_co (_data_);
}

gint
folks_inspect_client_run_non_interactive_finish (FolksInspectClient* self,
                                                 GAsyncResult* _res_)
{
	gint result;
	FolksInspectClientRunNonInteractiveData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	return result;
}

static void
folks_inspect_client_run_non_interactive_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_)
{
	FolksInspectClientRunNonInteractiveData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	folks_inspect_client_run_non_interactive_co (_data_);
}

static gboolean
folks_inspect_client_run_non_interactive_co (FolksInspectClientRunNonInteractiveData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp1_ = NULL;
	_data_->_tmp2_ = folks_inspect_client_parse_command_line (_data_->command_line, &_data_->_tmp0_, &_data_->_tmp1_);
	_g_free0 (_data_->command_name);
	_data_->command_name = _data_->_tmp0_;
	_g_free0 (_data_->subcommand);
	_data_->subcommand = _data_->_tmp1_;
	_data_->command = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->command;
	if (_data_->_tmp3_ == NULL) {
		_data_->_tmp4_ = stdout;
		_data_->_tmp5_ = _data_->command_name;
		fprintf (_data_->_tmp4_, "Unrecognised command ‘%s’.\n", _data_->_tmp5_);
		_data_->result = 1;
		_folks_inspect_command_unref0 (_data_->command);
		_g_free0 (_data_->command_name);
		_g_free0 (_data_->subcommand);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_state_ = 1;
		_folks_inspect_client_wait_for_quiescence (_data_->self, folks_inspect_client_run_non_interactive_ready, _data_);
		return FALSE;
		_state_1:
		_folks_inspect_client_wait_for_quiescence_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e1 = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp6_ = stderr;
		_data_->_tmp7_ = _data_->e1;
		_data_->_tmp8_ = _data_->_tmp7_->message;
		fprintf (_data_->_tmp6_, "Error preparing aggregator: %s\n", _data_->_tmp8_);
		_data_->result = 1;
		_g_error_free0 (_data_->e1);
		_folks_inspect_command_unref0 (_data_->command);
		_g_free0 (_data_->command_name);
		_g_free0 (_data_->subcommand);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_folks_inspect_command_unref0 (_data_->command);
		_g_free0 (_data_->command_name);
		_g_free0 (_data_->subcommand);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp9_ = _data_->command;
	_data_->_tmp10_ = _data_->subcommand;
	_data_->_state_ = 2;
	folks_inspect_command_run (_data_->_tmp9_, _data_->_tmp10_, folks_inspect_client_run_non_interactive_ready, _data_);
	return FALSE;
	_state_2:
	_data_->retval = folks_inspect_command_run_finish (_data_->_tmp9_, _data_->_res_);
	folks_inspect_client_quit (_data_->self);
	_data_->result = _data_->retval;
	_folks_inspect_command_unref0 (_data_->command);
	_g_free0 (_data_->command_name);
	_g_free0 (_data_->subcommand);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
folks_inspect_client_run_interactive_data_free (gpointer _data)
{
	FolksInspectClientRunInteractiveData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksInspectClientRunInteractiveData, _data_);
}

void
folks_inspect_client_run_interactive (FolksInspectClient* self,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	FolksInspectClientRunInteractiveData* _data_;
	FolksInspectClient* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (FolksInspectClientRunInteractiveData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, folks_inspect_client_run_interactive_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	folks_inspect_client_run_interactive_co (_data_);
}

gint
folks_inspect_client_run_interactive_finish (FolksInspectClient* self,
                                             GAsyncResult* _res_)
{
	gint result;
	FolksInspectClientRunInteractiveData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	return result;
}

static gboolean
__lambda5_ (FolksInspectClient* self)
{
	FILE* _tmp0_;
	gboolean result;
	if (folks_inspect_client__is_readline_installed == FALSE) {
		result = TRUE;
		return result;
	}
	rl_free_line_state ();
	rl_cleanup_after_signal ();
	rl_reset_after_signal ();
	_tmp0_ = stdout;
	fprintf (_tmp0_, "^C");
	rl_crlf ();
	rl_reset_line_state ();
	rl_replace_line ("", 0);
	rl_redisplay ();
	result = TRUE;
	return result;
}

static gboolean
___lambda5__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda5_ ((FolksInspectClient*) self);
	return result;
}

static gchar**
_folks_inspect_client_completion_cb_rl_completion_func_t (const gchar* str,
                                                          gint a,
                                                          gint b)
{
	gchar** result;
	result = folks_inspect_client_completion_cb (str, a, b);
	return result;
}

static gboolean
folks_inspect_client_run_interactive_co (FolksInspectClientRunInteractiveData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	memset (&_data_->_tmp0_, 0, sizeof (struct termios));
	_data_->_tmp1_ = tcgetattr (STDIN_FILENO, &_data_->_tmp0_);
	_data_->self->priv->_original_termios_p = _data_->_tmp0_;
	if (_data_->_tmp1_ == 0) {
		_data_->self->priv->_original_termios_p_valid = TRUE;
	}
	g_unix_signal_add_full (G_PRIORITY_DEFAULT, (gint) SIGINT, ___lambda5__gsource_func, g_object_ref (_data_->self), g_object_unref);
	rl_readline_name = "folks-inspect";
	rl_attempted_completion_function = _folks_inspect_client_completion_cb_rl_completion_func_t;
	rl_catch_signals = 0;
	_data_->_tmp2_ = stdin;
	_data_->_tmp3_ = g_io_channel_unix_new (fileno (_data_->_tmp2_));
	_g_io_channel_unref0 (_data_->self->priv->_stdin_channel);
	_data_->self->priv->_stdin_channel = _data_->_tmp3_;
	_folks_inspect_client_install_readline_and_stdin (_data_->self);
	_data_->_tmp4_ = _data_->self->priv->_aggregator;
	folks_individual_aggregator_prepare (_data_->_tmp4_, NULL, NULL);
	_data_->result = 0;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gboolean
__folks_inspect_client_stdin_handler_cb_gio_func (GIOChannel* source,
                                                  GIOCondition condition,
                                                  gpointer self)
{
	gboolean result;
	result = _folks_inspect_client_stdin_handler_cb ((FolksInspectClient*) self, source, condition);
	return result;
}

static void
__folks_inspect_client_readline_handler_cb_rl_vcpfunc_t (const gchar* s)
{
	_folks_inspect_client_readline_handler_cb (s);
}

static void
_folks_inspect_client_install_readline_and_stdin (FolksInspectClient* self)
{
	GIOChannel* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_stdin_channel;
	folks_inspect_client__stdin_watch_id = g_io_add_watch (_tmp0_, G_IO_IN, __folks_inspect_client_stdin_handler_cb_gio_func, self);
	rl_callback_handler_install ("> ", __folks_inspect_client_readline_handler_cb_rl_vcpfunc_t);
	folks_inspect_client__is_readline_installed = TRUE;
}

static void
_folks_inspect_client_uninstall_readline_and_stdin (FolksInspectClient* self)
{
	g_return_if_fail (self != NULL);
	rl_callback_handler_remove ();
	folks_inspect_client__is_readline_installed = FALSE;
	g_source_remove (folks_inspect_client__stdin_watch_id);
	folks_inspect_client__stdin_watch_id = (guint) 0;
}

static gboolean
_folks_inspect_client_stdin_handler_cb (FolksInspectClient* self,
                                        GIOChannel* source,
                                        GIOCondition cond)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (source != NULL, FALSE);
	if ((cond & G_IO_IN) != 0) {
		rl_callback_read_char ();
		result = TRUE;
		return result;
	}
	g_assert_not_reached ();
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		_folks_inspect_command_unref0 (_data3_->command);
		g_slice_free (Block3Data, _data3_);
	}
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static void
___lambda7_ (Block3Data* _data3_,
             GObject* obj,
             GAsyncResult* res)
{
	FolksInspectCommand* _tmp0_;
	FolksInspectClient* _tmp1_;
	FILE* _tmp2_;
	g_return_if_fail (res != NULL);
	_tmp0_ = _data3_->command;
	folks_inspect_command_run_finish (_tmp0_, res);
	_tmp1_ = main_client;
	_tmp2_ = _tmp1_->priv->_pager_channel;
	if (_tmp2_ != NULL) {
		FolksInspectClient* _tmp3_;
		FILE* _tmp4_;
		_tmp3_ = main_client;
		_fclose0 (_tmp3_->priv->_pager_channel);
		_tmp3_->priv->_pager_channel = NULL;
		_tmp4_ = stdout;
		folks_inspect_utils_output_filestream = _tmp4_;
	} else {
		rl_reset_line_state ();
		rl_replace_line ("", 0);
		rl_redisplay ();
	}
}

static void
____lambda7__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	___lambda7_ (self, source_object, res);
	block3_data_unref (self);
}

static void
_folks_inspect_client_readline_handler_cb (const gchar* _command_line)
{
	Block3Data* _data3_;
	gchar* command_line = NULL;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* subcommand = NULL;
	gchar* command_name = NULL;
	const gchar* _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	FolksInspectCommand* _tmp9_;
	FolksInspectCommand* _tmp10_;
	const gchar* _tmp17_;
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	if (_command_line == NULL) {
		const gchar* _tmp0_;
		FolksInspectClient* _tmp1_;
		_tmp0_ = rl_line_buffer;
		if (g_strcmp0 (_tmp0_, "") != 0) {
			rl_ding ();
			block3_data_unref (_data3_);
			_data3_ = NULL;
			return;
		}
		_tmp1_ = main_client;
		folks_inspect_client_quit (_tmp1_);
		block3_data_unref (_data3_);
		_data3_ = NULL;
		return;
	}
	_tmp2_ = g_strdup ((const gchar*) _command_line);
	command_line = _tmp2_;
	_tmp3_ = command_line;
	_tmp4_ = string_strip (_tmp3_);
	_g_free0 (command_line);
	command_line = _tmp4_;
	_tmp5_ = command_line;
	if (g_strcmp0 (_tmp5_, "") == 0) {
		_g_free0 (command_line);
		block3_data_unref (_data3_);
		_data3_ = NULL;
		return;
	}
	_tmp6_ = command_line;
	_tmp9_ = folks_inspect_client_parse_command_line (_tmp6_, &_tmp7_, &_tmp8_);
	_g_free0 (command_name);
	command_name = _tmp7_;
	_g_free0 (subcommand);
	subcommand = _tmp8_;
	_data3_->command = _tmp9_;
	_tmp10_ = _data3_->command;
	if (_tmp10_ != NULL) {
		const gchar* _tmp11_;
		FolksInspectCommand* _tmp13_;
		const gchar* _tmp14_;
		_tmp11_ = command_name;
		if (g_strcmp0 (_tmp11_, "quit") != 0) {
			FolksInspectClient* _tmp12_;
			_tmp12_ = main_client;
			_folks_inspect_client_start_paged_output (_tmp12_);
		}
		_tmp13_ = _data3_->command;
		_tmp14_ = subcommand;
		folks_inspect_command_run (_tmp13_, _tmp14_, ____lambda7__gasync_ready_callback, block3_data_ref (_data3_));
	} else {
		FILE* _tmp15_;
		const gchar* _tmp16_;
		_tmp15_ = stdout;
		_tmp16_ = command_name;
		fprintf (_tmp15_, "Unrecognised command ‘%s’.\n", _tmp16_);
	}
	_tmp17_ = command_line;
	add_history (_tmp17_);
	_g_free0 (command_name);
	_g_free0 (subcommand);
	_g_free0 (command_line);
	block3_data_unref (_data3_);
	_data3_ = NULL;
}

static void
__lambda6_ (FolksInspectClient* self,
            GPid pid,
            gint status)
{
	_folks_inspect_client_stop_paged_output (self);
	if (WIFSIGNALED (status)) {
		rl_crlf ();
	}
	rl_reset_line_state ();
	rl_replace_line ("", 0);
	if (self->priv->_quit_after_pager_dies) {
		FolksInspectClient* _tmp0_;
		_tmp0_ = main_client;
		folks_inspect_client_quit (_tmp0_);
		return;
	}
	_folks_inspect_client_install_readline_and_stdin (self);
}

static void
___lambda6__gchild_watch_func (GPid pid,
                               gint wait_status,
                               gpointer self)
{
	__lambda6_ ((FolksInspectClient*) self, pid, wait_status);
}

static void
_folks_inspect_client_start_paged_output (FolksInspectClient* self)
{
	gchar* pager = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	const gchar* _tmp5_;
	gchar** args = NULL;
	gint args_length1 = 0;
	gint _args_size_ = 0;
	gint pager_fd = 0;
	FILE* _tmp17_;
	FILE* _tmp18_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	if (!isatty (1)) {
		return;
	}
	_tmp0_ = g_getenv ("PAGER");
	_tmp1_ = g_strdup (_tmp0_);
	pager = _tmp1_;
	_tmp3_ = pager;
	if (_tmp3_ != NULL) {
		const gchar* _tmp4_;
		_tmp4_ = pager;
		_tmp2_ = g_strcmp0 (_tmp4_, "") == 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_g_free0 (pager);
		return;
	}
	_tmp5_ = pager;
	if (_tmp5_ == NULL) {
		gchar* _tmp6_;
		_tmp6_ = g_strdup ("less -FRSX");
		_g_free0 (pager);
		pager = _tmp6_;
	}
	{
		const gchar* _tmp7_;
		gchar** _tmp8_ = NULL;
		gint _tmp9_ = 0;
		_tmp7_ = pager;
		g_shell_parse_argv (_tmp7_, &_tmp9_, &_tmp8_, &_inner_error0_);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		args = _tmp8_;
		args_length1 = _tmp9_;
		_args_size_ = args_length1;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_SHELL_ERROR) {
				goto __catch0_g_shell_error;
			}
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (pager);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_g_shell_error:
	{
		GError* e = NULL;
		GError* _tmp10_;
		const gchar* _tmp11_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp10_ = e;
		_tmp11_ = _tmp10_->message;
		g_warning ("inspect.vala:446: Error parsing pager arguments: %s", _tmp11_);
		_g_error_free0 (e);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (pager);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (pager);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_folks_inspect_client_uninstall_readline_and_stdin (self);
	rl_prep_terminal (1);
	pager_fd = 0;
	{
		gchar** _tmp12_;
		gint _tmp12__length1;
		GPid _tmp13_ = 0;
		gint _tmp14_ = 0;
		_tmp12_ = args;
		_tmp12__length1 = args_length1;
		g_spawn_async_with_pipes (NULL, _tmp12_, NULL, (G_SPAWN_LEAVE_DESCRIPTORS_OPEN | G_SPAWN_SEARCH_PATH) | G_SPAWN_DO_NOT_REAP_CHILD, NULL, NULL, &_tmp13_, &_tmp14_, NULL, NULL, &_inner_error0_);
		folks_inspect_client__pager_pid = _tmp13_;
		pager_fd = _tmp14_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_SPAWN_ERROR) {
				goto __catch1_g_spawn_error;
			}
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (pager);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally1;
	__catch1_g_spawn_error:
	{
		GError* e2 = NULL;
		GError* _tmp15_;
		const gchar* _tmp16_;
		e2 = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp15_ = e2;
		_tmp16_ = _tmp15_->message;
		g_warning ("inspect.vala:476: Error spawning pager: %s", _tmp16_);
		_folks_inspect_client_install_readline_and_stdin (self);
		_g_error_free0 (e2);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (pager);
		return;
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (pager);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp17_ = fdopen (pager_fd, "w");
	_fclose0 (self->priv->_pager_channel);
	self->priv->_pager_channel = _tmp17_;
	_tmp18_ = self->priv->_pager_channel;
	folks_inspect_utils_output_filestream = _tmp18_;
	self->priv->_pager_child_watch_id = g_child_watch_add_full (G_PRIORITY_DEFAULT_IDLE, folks_inspect_client__pager_pid, ___lambda6__gchild_watch_func, g_object_ref (self), g_object_unref);
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (pager);
}

static void
_folks_inspect_client_stop_paged_output (FolksInspectClient* self)
{
	FILE* _tmp0_;
	g_return_if_fail (self != NULL);
	if (folks_inspect_client__pager_pid == ((GPid) 0)) {
		return;
	}
	g_spawn_close_pid (folks_inspect_client__pager_pid);
	g_source_remove (self->priv->_pager_child_watch_id);
	_fclose0 (self->priv->_pager_channel);
	self->priv->_pager_channel = NULL;
	_tmp0_ = stdout;
	folks_inspect_utils_output_filestream = _tmp0_;
	folks_inspect_client__pager_pid = (GPid) 0;
	self->priv->_pager_child_watch_id = (guint) 0;
	rl_deprep_terminal ();
	rl_free_line_state ();
	rl_cleanup_after_signal ();
	rl_reset_after_signal ();
}

static FolksInspectCommand*
folks_inspect_client_parse_command_line (const gchar* command_line,
                                         gchar** command_name,
                                         gchar** subcommand)
{
	gchar* _vala_command_name = NULL;
	gchar* _vala_subcommand = NULL;
	gchar* _tmp0_;
	gchar** parts = NULL;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint parts_length1;
	gint _parts_size_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar** _tmp4_;
	gint _tmp4__length1;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gboolean _tmp7_ = FALSE;
	gchar** _tmp8_;
	gint _tmp8__length1;
	FolksInspectClient* _tmp14_;
	GeeHashMap* _tmp15_;
	gchar** _tmp16_;
	gint _tmp16__length1;
	const gchar* _tmp17_;
	gpointer _tmp18_;
	FolksInspectCommand* result;
	g_return_val_if_fail (command_line != NULL, NULL);
	_tmp0_ = g_strdup ("");
	_g_free0 (_vala_command_name);
	_vala_command_name = _tmp0_;
	_g_free0 (_vala_subcommand);
	_vala_subcommand = NULL;
	_tmp2_ = _tmp1_ = g_strsplit (command_line, " ", 2);
	parts = _tmp2_;
	parts_length1 = _vala_array_length (_tmp1_);
	_parts_size_ = parts_length1;
	_tmp3_ = parts;
	_tmp3__length1 = parts_length1;
	if (_tmp3__length1 < 1) {
		result = NULL;
		parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
		if (command_name) {
			*command_name = _vala_command_name;
		} else {
			_g_free0 (_vala_command_name);
		}
		if (subcommand) {
			*subcommand = _vala_subcommand;
		} else {
			_g_free0 (_vala_subcommand);
		}
		return result;
	}
	_tmp4_ = parts;
	_tmp4__length1 = parts_length1;
	_tmp5_ = _tmp4_[0];
	_tmp6_ = g_strdup (_tmp5_);
	_g_free0 (_vala_command_name);
	_vala_command_name = _tmp6_;
	_tmp8_ = parts;
	_tmp8__length1 = parts_length1;
	if (_tmp8__length1 == 2) {
		gchar** _tmp9_;
		gint _tmp9__length1;
		const gchar* _tmp10_;
		_tmp9_ = parts;
		_tmp9__length1 = parts_length1;
		_tmp10_ = _tmp9_[1];
		_tmp7_ = g_strcmp0 (_tmp10_, "") != 0;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		gchar** _tmp11_;
		gint _tmp11__length1;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp11_ = parts;
		_tmp11__length1 = parts_length1;
		_tmp12_ = _tmp11_[1];
		_tmp13_ = g_strdup (_tmp12_);
		_g_free0 (_vala_subcommand);
		_vala_subcommand = _tmp13_;
	} else {
		_g_free0 (_vala_subcommand);
		_vala_subcommand = NULL;
	}
	_tmp14_ = main_client;
	_tmp15_ = _tmp14_->commands;
	_tmp16_ = parts;
	_tmp16__length1 = parts_length1;
	_tmp17_ = _tmp16_[0];
	_tmp18_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp15_, _tmp17_);
	result = (FolksInspectCommand*) _tmp18_;
	parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
	if (command_name) {
		*command_name = _vala_command_name;
	} else {
		_g_free0 (_vala_command_name);
	}
	if (subcommand) {
		*subcommand = _vala_subcommand;
	} else {
		_g_free0 (_vala_subcommand);
	}
	return result;
}

static gchar*
_folks_inspect_utils_command_name_completion_cb_rl_compentry_func_t (const gchar* str,
                                                                     gint a)
{
	gchar* result;
	result = folks_inspect_utils_command_name_completion_cb (str, a);
	return result;
}

static gchar**
_vala_array_dup15 (gchar** self,
                   gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
folks_inspect_client_completion_cb (const gchar* word,
                                    gint start,
                                    gint end)
{
	gchar* command_name = NULL;
	gchar* subcommand = NULL;
	FolksInspectCommand* command = NULL;
	const gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	FolksInspectCommand* _tmp6_;
	FolksInspectCommand* _tmp7_;
	gchar** result;
	g_return_val_if_fail (word != NULL, NULL);
	if (start == 0) {
		gchar** _tmp0_;
		gchar** _tmp1_;
		gchar** _tmp2_;
		gint _tmp2__length1;
		_tmp1_ = _tmp0_ = rl_completion_matches (word, _folks_inspect_utils_command_name_completion_cb_rl_compentry_func_t);
		_tmp2_ = (_tmp1_ != NULL) ? _vala_array_dup15 (_tmp1_, _vala_array_length (_tmp0_)) : _tmp1_;
		_tmp2__length1 = _vala_array_length (_tmp0_);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = rl_line_buffer;
	_tmp6_ = folks_inspect_client_parse_command_line (_tmp3_, &_tmp4_, &_tmp5_);
	_g_free0 (command_name);
	command_name = _tmp4_;
	_g_free0 (subcommand);
	subcommand = _tmp5_;
	command = _tmp6_;
	_tmp7_ = command;
	if (_tmp7_ != NULL) {
		const gchar* _tmp8_;
		FolksInspectCommand* _tmp10_;
		const gchar* _tmp11_;
		gint _tmp12_ = 0;
		gchar** _tmp13_;
		_tmp8_ = subcommand;
		if (_tmp8_ == NULL) {
			gchar* _tmp9_;
			_tmp9_ = g_strdup ("");
			_g_free0 (subcommand);
			subcommand = _tmp9_;
		}
		_tmp10_ = command;
		_tmp11_ = subcommand;
		_tmp13_ = folks_inspect_command_complete_subcommand (_tmp10_, _tmp11_, &_tmp12_);
		result = _tmp13_;
		_folks_inspect_command_unref0 (command);
		_g_free0 (subcommand);
		_g_free0 (command_name);
		return result;
	}
	result = NULL;
	_folks_inspect_command_unref0 (command);
	_g_free0 (subcommand);
	_g_free0 (command_name);
	return result;
}

FolksIndividualAggregator*
folks_inspect_client_get_aggregator (FolksInspectClient* self)
{
	FolksIndividualAggregator* result;
	FolksIndividualAggregator* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_aggregator;
	result = _tmp0_;
	return result;
}

static void
folks_inspect_client_set_aggregator (FolksInspectClient* self,
                                     FolksIndividualAggregator* value)
{
	FolksIndividualAggregator* old_value;
	g_return_if_fail (self != NULL);
	old_value = folks_inspect_client_get_aggregator (self);
	if (old_value != value) {
		FolksIndividualAggregator* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_aggregator);
		self->priv->_aggregator = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, folks_inspect_client_properties[FOLKS_INSPECT_CLIENT_AGGREGATOR_PROPERTY]);
	}
}

FolksBackendStore*
folks_inspect_client_get_backend_store (FolksInspectClient* self)
{
	FolksBackendStore* result;
	FolksBackendStore* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_backend_store;
	result = _tmp0_;
	return result;
}

static void
folks_inspect_client_set_backend_store (FolksInspectClient* self,
                                        FolksBackendStore* value)
{
	FolksBackendStore* old_value;
	g_return_if_fail (self != NULL);
	old_value = folks_inspect_client_get_backend_store (self);
	if (old_value != value) {
		FolksBackendStore* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_backend_store);
		self->priv->_backend_store = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, folks_inspect_client_properties[FOLKS_INSPECT_CLIENT_BACKEND_STORE_PROPERTY]);
	}
}

FolksInspectSignalManager*
folks_inspect_client_get_signal_manager (FolksInspectClient* self)
{
	FolksInspectSignalManager* result;
	FolksInspectSignalManager* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_signal_manager;
	result = _tmp0_;
	return result;
}

static void
folks_inspect_client_set_signal_manager (FolksInspectClient* self,
                                         FolksInspectSignalManager* value)
{
	FolksInspectSignalManager* old_value;
	g_return_if_fail (self != NULL);
	old_value = folks_inspect_client_get_signal_manager (self);
	if (old_value != value) {
		FolksInspectSignalManager* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_signal_manager);
		self->priv->_signal_manager = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, folks_inspect_client_properties[FOLKS_INSPECT_CLIENT_SIGNAL_MANAGER_PROPERTY]);
	}
}

static void
folks_inspect_client_class_init (FolksInspectClientClass * klass,
                                 gpointer klass_data)
{
	folks_inspect_client_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FolksInspectClient_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_folks_inspect_client_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_folks_inspect_client_set_property;
	G_OBJECT_CLASS (klass)->finalize = folks_inspect_client_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_INSPECT_CLIENT_AGGREGATOR_PROPERTY, folks_inspect_client_properties[FOLKS_INSPECT_CLIENT_AGGREGATOR_PROPERTY] = g_param_spec_object ("aggregator", "aggregator", "aggregator", FOLKS_TYPE_INDIVIDUAL_AGGREGATOR, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_INSPECT_CLIENT_BACKEND_STORE_PROPERTY, folks_inspect_client_properties[FOLKS_INSPECT_CLIENT_BACKEND_STORE_PROPERTY] = g_param_spec_object ("backend-store", "backend-store", "backend-store", FOLKS_TYPE_BACKEND_STORE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_INSPECT_CLIENT_SIGNAL_MANAGER_PROPERTY, folks_inspect_client_properties[FOLKS_INSPECT_CLIENT_SIGNAL_MANAGER_PROPERTY] = g_param_spec_object ("signal-manager", "signal-manager", "signal-manager", FOLKS_INSPECT_TYPE_SIGNAL_MANAGER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
folks_inspect_client_instance_init (FolksInspectClient * self,
                                    gpointer klass)
{
	self->priv = folks_inspect_client_get_instance_private (self);
	self->priv->_original_termios_p_valid = FALSE;
	self->priv->_quit_after_pager_dies = FALSE;
	self->priv->_stdin_channel = NULL;
	self->priv->_pager_channel = NULL;
	self->priv->_pager_child_watch_id = (guint) 0;
}

static void
folks_inspect_client_finalize (GObject * obj)
{
	FolksInspectClient * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_INSPECT_TYPE_CLIENT, FolksInspectClient);
	_g_object_unref0 (self->commands);
	_g_main_loop_unref0 (self->priv->main_loop);
	_g_object_unref0 (self->priv->_aggregator);
	_g_object_unref0 (self->priv->_backend_store);
	_g_object_unref0 (self->priv->_signal_manager);
	_g_io_channel_unref0 (self->priv->_stdin_channel);
	_fclose0 (self->priv->_pager_channel);
	G_OBJECT_CLASS (folks_inspect_client_parent_class)->finalize (obj);
}

static GType
folks_inspect_client_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FolksInspectClientClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_inspect_client_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksInspectClient), 0, (GInstanceInitFunc) folks_inspect_client_instance_init, NULL };
	GType folks_inspect_client_type_id;
	folks_inspect_client_type_id = g_type_register_static (G_TYPE_OBJECT, "FolksInspectClient", &g_define_type_info, 0);
	FolksInspectClient_private_offset = g_type_add_instance_private (folks_inspect_client_type_id, sizeof (FolksInspectClientPrivate));
	return folks_inspect_client_type_id;
}

GType
folks_inspect_client_get_type (void)
{
	static volatile gsize folks_inspect_client_type_id__once = 0;
	if (g_once_init_enter (&folks_inspect_client_type_id__once)) {
		GType folks_inspect_client_type_id;
		folks_inspect_client_type_id = folks_inspect_client_get_type_once ();
		g_once_init_leave (&folks_inspect_client_type_id__once, folks_inspect_client_type_id);
	}
	return folks_inspect_client_type_id__once;
}

static void
_vala_folks_inspect_client_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	FolksInspectClient * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_INSPECT_TYPE_CLIENT, FolksInspectClient);
	switch (property_id) {
		case FOLKS_INSPECT_CLIENT_AGGREGATOR_PROPERTY:
		g_value_set_object (value, folks_inspect_client_get_aggregator (self));
		break;
		case FOLKS_INSPECT_CLIENT_BACKEND_STORE_PROPERTY:
		g_value_set_object (value, folks_inspect_client_get_backend_store (self));
		break;
		case FOLKS_INSPECT_CLIENT_SIGNAL_MANAGER_PROPERTY:
		g_value_set_object (value, folks_inspect_client_get_signal_manager (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_folks_inspect_client_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec)
{
	FolksInspectClient * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_INSPECT_TYPE_CLIENT, FolksInspectClient);
	switch (property_id) {
		case FOLKS_INSPECT_CLIENT_AGGREGATOR_PROPERTY:
		folks_inspect_client_set_aggregator (self, g_value_get_object (value));
		break;
		case FOLKS_INSPECT_CLIENT_BACKEND_STORE_PROPERTY:
		folks_inspect_client_set_backend_store (self, g_value_get_object (value));
		break;
		case FOLKS_INSPECT_CLIENT_SIGNAL_MANAGER_PROPERTY:
		folks_inspect_client_set_signal_manager (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

FolksInspectCommand*
folks_inspect_command_construct (GType object_type,
                                 FolksInspectClient* client)
{
	FolksInspectCommand* self = NULL;
	FolksInspectClient* _tmp0_;
	g_return_val_if_fail (client != NULL, NULL);
	self = (FolksInspectCommand*) g_type_create_instance (object_type);
	_tmp0_ = _g_object_ref0 (client);
	_g_object_unref0 (self->client);
	self->client = _tmp0_;
	return self;
}

void
folks_inspect_command_run (FolksInspectCommand* self,
                           const gchar* command_string,
                           GAsyncReadyCallback _callback_,
                           gpointer _user_data_)
{
	FolksInspectCommandClass* _klass_;
	_klass_ = FOLKS_INSPECT_COMMAND_GET_CLASS (self);
	if (_klass_->run) {
		_klass_->run (self, command_string, _callback_, _user_data_);
	}
}

gint
folks_inspect_command_run_finish (FolksInspectCommand* self,
                                  GAsyncResult* _res_)
{
	FolksInspectCommandClass* _klass_;
	_klass_ = FOLKS_INSPECT_COMMAND_GET_CLASS (self);
	if (_klass_->run_finish) {
		return _klass_->run_finish (self, _res_);
	}
	return -1;
}

static gchar**
folks_inspect_command_real_complete_subcommand (FolksInspectCommand* self,
                                                const gchar* subcommand,
                                                gint* result_length1)
{
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** result;
	g_return_val_if_fail (subcommand != NULL, NULL);
	_tmp0_ = NULL;
	_tmp0__length1 = 0;
	if (result_length1) {
		*result_length1 = _tmp0__length1;
	}
	result = _tmp0_;
	return result;
}

gchar**
folks_inspect_command_complete_subcommand (FolksInspectCommand* self,
                                           const gchar* subcommand,
                                           gint* result_length1)
{
	FolksInspectCommandClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = FOLKS_INSPECT_COMMAND_GET_CLASS (self);
	if (_klass_->complete_subcommand) {
		return _klass_->complete_subcommand (self, subcommand, result_length1);
	}
	return NULL;
}

const gchar*
folks_inspect_command_get_name (FolksInspectCommand* self)
{
	FolksInspectCommandClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = FOLKS_INSPECT_COMMAND_GET_CLASS (self);
	if (_klass_->get_name) {
		return _klass_->get_name (self);
	}
	return NULL;
}

const gchar*
folks_inspect_command_get_description (FolksInspectCommand* self)
{
	FolksInspectCommandClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = FOLKS_INSPECT_COMMAND_GET_CLASS (self);
	if (_klass_->get_description) {
		return _klass_->get_description (self);
	}
	return NULL;
}

const gchar*
folks_inspect_command_get_help (FolksInspectCommand* self)
{
	FolksInspectCommandClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = FOLKS_INSPECT_COMMAND_GET_CLASS (self);
	if (_klass_->get_help) {
		return _klass_->get_help (self);
	}
	return NULL;
}

static void
folks_inspect_value_command_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
folks_inspect_value_command_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		folks_inspect_command_unref (value->data[0].v_pointer);
	}
}

static void
folks_inspect_value_command_copy_value (const GValue* src_value,
                                        GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = folks_inspect_command_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
folks_inspect_value_command_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
folks_inspect_value_command_collect_value (GValue* value,
                                           guint n_collect_values,
                                           GTypeCValue* collect_values,
                                           guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		FolksInspectCommand * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = folks_inspect_command_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
folks_inspect_value_command_lcopy_value (const GValue* value,
                                         guint n_collect_values,
                                         GTypeCValue* collect_values,
                                         guint collect_flags)
{
	FolksInspectCommand ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = folks_inspect_command_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
folks_inspect_param_spec_command (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags)
{
	FolksInspectParamSpecCommand* spec;
	g_return_val_if_fail (g_type_is_a (object_type, FOLKS_INSPECT_TYPE_COMMAND), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
folks_inspect_value_get_command (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FOLKS_INSPECT_TYPE_COMMAND), NULL);
	return value->data[0].v_pointer;
}

void
folks_inspect_value_set_command (GValue* value,
                                 gpointer v_object)
{
	FolksInspectCommand * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FOLKS_INSPECT_TYPE_COMMAND));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, FOLKS_INSPECT_TYPE_COMMAND));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		folks_inspect_command_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		folks_inspect_command_unref (old);
	}
}

void
folks_inspect_value_take_command (GValue* value,
                                  gpointer v_object)
{
	FolksInspectCommand * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FOLKS_INSPECT_TYPE_COMMAND));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, FOLKS_INSPECT_TYPE_COMMAND));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		folks_inspect_command_unref (old);
	}
}

static void
folks_inspect_command_class_init (FolksInspectCommandClass * klass,
                                  gpointer klass_data)
{
	folks_inspect_command_parent_class = g_type_class_peek_parent (klass);
	((FolksInspectCommandClass *) klass)->finalize = folks_inspect_command_finalize;
	((FolksInspectCommandClass *) klass)->complete_subcommand = (gchar** (*) (FolksInspectCommand*, const gchar*, gint*)) folks_inspect_command_real_complete_subcommand;
}

static void
folks_inspect_command_instance_init (FolksInspectCommand * self,
                                     gpointer klass)
{
	self->ref_count = 1;
}

static void
folks_inspect_command_finalize (FolksInspectCommand * obj)
{
	FolksInspectCommand * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_INSPECT_TYPE_COMMAND, FolksInspectCommand);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->client);
}

static GType
folks_inspect_command_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { folks_inspect_value_command_init, folks_inspect_value_command_free_value, folks_inspect_value_command_copy_value, folks_inspect_value_command_peek_pointer, "p", folks_inspect_value_command_collect_value, "p", folks_inspect_value_command_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (FolksInspectCommandClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_inspect_command_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksInspectCommand), 0, (GInstanceInitFunc) folks_inspect_command_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType folks_inspect_command_type_id;
	folks_inspect_command_type_id = g_type_register_fundamental (g_type_fundamental_next (), "FolksInspectCommand", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
	return folks_inspect_command_type_id;
}

GType
folks_inspect_command_get_type (void)
{
	static volatile gsize folks_inspect_command_type_id__once = 0;
	if (g_once_init_enter (&folks_inspect_command_type_id__once)) {
		GType folks_inspect_command_type_id;
		folks_inspect_command_type_id = folks_inspect_command_get_type_once ();
		g_once_init_leave (&folks_inspect_command_type_id__once, folks_inspect_command_type_id);
	}
	return folks_inspect_command_type_id__once;
}

gpointer
folks_inspect_command_ref (gpointer instance)
{
	FolksInspectCommand * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
folks_inspect_command_unref (gpointer instance)
{
	FolksInspectCommand * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		FOLKS_INSPECT_COMMAND_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

