/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Random;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.ObjectName;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Server;
import org.apache.catalina.Service;
import org.apache.catalina.core.NamingContextListener;
import org.apache.catalina.core.StandardService;
import org.apache.catalina.deploy.NamingResourcesImpl;
import org.apache.catalina.mbeans.MBeanFactory;
import org.apache.catalina.startup.Catalina;
import org.apache.catalina.util.ExtensionValidator;
import org.apache.catalina.util.LifecycleMBeanBase;
import org.apache.catalina.util.ServerInfo;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.buf.StringCache;
import org.apache.tomcat.util.res.StringManager;

public final class StandardServer
extends LifecycleMBeanBase
implements Server {
    private static final Log log = LogFactory.getLog(StandardServer.class);
    private static final StringManager sm = StringManager.getManager(StandardServer.class);
    private javax.naming.Context globalNamingContext = null;
    private NamingResourcesImpl globalNamingResources = null;
    private final NamingContextListener namingContextListener;
    private int port = 8005;
    private int portOffset = 0;
    private String address = "localhost";
    private Random random = null;
    private Service[] services = new Service[0];
    private final Object servicesLock = new Object();
    private String shutdown = "SHUTDOWN";
    final PropertyChangeSupport support = new PropertyChangeSupport(this);
    private volatile boolean stopAwait = false;
    private Catalina catalina = null;
    private ClassLoader parentClassLoader = null;
    private volatile Thread awaitThread = null;
    private volatile ServerSocket awaitSocket = null;
    private File catalinaHome = null;
    private File catalinaBase = null;
    private final Object namingToken = new Object();
    private ObjectName onameStringCache;
    private ObjectName onameMBeanFactory;

    public StandardServer() {
        this.globalNamingResources = new NamingResourcesImpl();
        this.globalNamingResources.setContainer(this);
        if (this.isUseNaming()) {
            this.namingContextListener = new NamingContextListener();
            this.addLifecycleListener(this.namingContextListener);
        } else {
            this.namingContextListener = null;
        }
    }

    @Override
    public Object getNamingToken() {
        return this.namingToken;
    }

    @Override
    public javax.naming.Context getGlobalNamingContext() {
        return this.globalNamingContext;
    }

    public void setGlobalNamingContext(javax.naming.Context context) {
        this.globalNamingContext = context;
    }

    @Override
    public NamingResourcesImpl getGlobalNamingResources() {
        return this.globalNamingResources;
    }

    @Override
    public void setGlobalNamingResources(NamingResourcesImpl namingResourcesImpl) {
        NamingResourcesImpl namingResourcesImpl2 = this.globalNamingResources;
        this.globalNamingResources = namingResourcesImpl;
        this.globalNamingResources.setContainer(this);
        this.support.firePropertyChange("globalNamingResources", namingResourcesImpl2, this.globalNamingResources);
    }

    public String getServerInfo() {
        return ServerInfo.getServerInfo();
    }

    public String getServerBuilt() {
        return ServerInfo.getServerBuilt();
    }

    public String getServerNumber() {
        return ServerInfo.getServerNumber();
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public void setPort(int n) {
        this.port = n;
    }

    @Override
    public int getPortOffset() {
        return this.portOffset;
    }

    @Override
    public void setPortOffset(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(sm.getString("standardServer.portOffset.invalid", new Object[]{n}));
        }
        this.portOffset = n;
    }

    @Override
    public int getPortWithOffset() {
        int n = this.getPort();
        if (n > 0) {
            return n + this.getPortOffset();
        }
        return n;
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    @Override
    public void setAddress(String string) {
        this.address = string;
    }

    @Override
    public String getShutdown() {
        return this.shutdown;
    }

    @Override
    public void setShutdown(String string) {
        this.shutdown = string;
    }

    @Override
    public Catalina getCatalina() {
        return this.catalina;
    }

    @Override
    public void setCatalina(Catalina catalina) {
        this.catalina = catalina;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addService(Service service) {
        service.setServer(this);
        Object object = this.servicesLock;
        synchronized (object) {
            Service[] serviceArray = new Service[this.services.length + 1];
            System.arraycopy(this.services, 0, serviceArray, 0, this.services.length);
            serviceArray[this.services.length] = service;
            this.services = serviceArray;
            if (this.getState().isAvailable()) {
                try {
                    service.start();
                }
                catch (LifecycleException lifecycleException) {
                    // empty catch block
                }
            }
            this.support.firePropertyChange("service", null, service);
        }
    }

    public void stopAwait() {
        this.stopAwait = true;
        Thread thread = this.awaitThread;
        if (thread != null) {
            ServerSocket serverSocket = this.awaitSocket;
            if (serverSocket != null) {
                this.awaitSocket = null;
                try {
                    serverSocket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            thread.interrupt();
            try {
                thread.join(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public void await() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Service findService(String string) {
        if (string == null) {
            return null;
        }
        Object object = this.servicesLock;
        synchronized (object) {
            for (Service service : this.services) {
                if (!string.equals(service.getName())) continue;
                return service;
            }
        }
        return null;
    }

    @Override
    public Service[] findServices() {
        return this.services;
    }

    public ObjectName[] getServiceNames() {
        ObjectName[] objectNameArray = new ObjectName[this.services.length];
        for (int i = 0; i < this.services.length; ++i) {
            objectNameArray[i] = ((StandardService)this.services[i]).getObjectName();
        }
        return objectNameArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeService(Service service) {
        Object object = this.servicesLock;
        synchronized (object) {
            int n = -1;
            for (int i = 0; i < this.services.length; ++i) {
                if (service != this.services[i]) continue;
                n = i;
                break;
            }
            if (n < 0) {
                return;
            }
            try {
                this.services[n].stop();
            }
            catch (LifecycleException lifecycleException) {
                // empty catch block
            }
            int n2 = 0;
            Service[] serviceArray = new Service[this.services.length - 1];
            for (int i = 0; i < this.services.length; ++i) {
                if (i == n) continue;
                serviceArray[n2++] = this.services[i];
            }
            this.services = serviceArray;
            this.support.firePropertyChange("service", service, null);
        }
    }

    @Override
    public File getCatalinaBase() {
        if (this.catalinaBase != null) {
            return this.catalinaBase;
        }
        this.catalinaBase = this.getCatalinaHome();
        return this.catalinaBase;
    }

    @Override
    public void setCatalinaBase(File file) {
        this.catalinaBase = file;
    }

    @Override
    public File getCatalinaHome() {
        return this.catalinaHome;
    }

    @Override
    public void setCatalinaHome(File file) {
        this.catalinaHome = file;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("StandardServer[");
        stringBuilder.append(this.getPort());
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public synchronized void storeConfig() throws InstanceNotFoundException, MBeanException {
        try {
            ObjectName objectName = new ObjectName("Catalina:type=StoreConfig");
            if (this.mserver.isRegistered(objectName)) {
                this.mserver.invoke(objectName, "storeConfig", null, null);
            } else {
                log.error((Object)sm.getString("standardServer.storeConfig.notAvailable", new Object[]{objectName}));
            }
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable((Throwable)throwable);
            log.error((Object)sm.getString("standardServer.storeConfig.error"), throwable);
        }
    }

    public synchronized void storeContext(Context context) throws InstanceNotFoundException, MBeanException {
        try {
            ObjectName objectName = new ObjectName("Catalina:type=StoreConfig");
            if (this.mserver.isRegistered(objectName)) {
                this.mserver.invoke(objectName, "store", new Object[]{context}, new String[]{"java.lang.String"});
            } else {
                log.error((Object)sm.getString("standardServer.storeConfig.notAvailable", new Object[]{objectName}));
            }
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable((Throwable)throwable);
            log.error((Object)sm.getString("standardServer.storeConfig.contextError", new Object[]{context.getName()}), throwable);
        }
    }

    private boolean isUseNaming() {
        boolean bl = true;
        String string = System.getProperty("catalina.useNaming");
        if (string != null && string.equals("false")) {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void startInternal() throws LifecycleException {
        this.fireLifecycleEvent("configure_start", null);
        this.setState(LifecycleState.STARTING);
        this.globalNamingResources.start();
        Object object = this.servicesLock;
        synchronized (object) {
            for (Service service : this.services) {
                service.start();
            }
        }
    }

    @Override
    protected void stopInternal() throws LifecycleException {
        this.setState(LifecycleState.STOPPING);
        this.fireLifecycleEvent("configure_stop", null);
        for (Service service : this.services) {
            service.stop();
        }
        this.globalNamingResources.stop();
        this.stopAwait();
    }

    @Override
    protected void initInternal() throws LifecycleException {
        super.initInternal();
        this.onameStringCache = this.register(new StringCache(), "type=StringCache");
        MBeanFactory mBeanFactory = new MBeanFactory();
        mBeanFactory.setContainer(this);
        this.onameMBeanFactory = this.register(mBeanFactory, "type=MBeanFactory");
        this.globalNamingResources.init();
        if (this.getCatalina() != null) {
            for (Object object = this.getCatalina().getParentClassLoader(); object != null && object != ClassLoader.getSystemClassLoader(); object = ((ClassLoader)object).getParent()) {
                URL[] uRLArray;
                if (!(object instanceof URLClassLoader)) continue;
                for (URL uRL : uRLArray = ((URLClassLoader)object).getURLs()) {
                    if (!uRL.getProtocol().equals("file")) continue;
                    try {
                        File file = new File(uRL.toURI());
                        if (!file.isFile() || !file.getName().endsWith(".jar")) continue;
                        ExtensionValidator.addSystemResource(file);
                    }
                    catch (IOException | URISyntaxException exception) {
                        // empty catch block
                    }
                }
            }
        }
        for (Service service : this.services) {
            service.init();
        }
    }

    @Override
    protected void destroyInternal() throws LifecycleException {
        for (Service service : this.services) {
            service.destroy();
        }
        this.globalNamingResources.destroy();
        this.unregister(this.onameMBeanFactory);
        this.unregister(this.onameStringCache);
        super.destroyInternal();
    }

    @Override
    public ClassLoader getParentClassLoader() {
        if (this.parentClassLoader != null) {
            return this.parentClassLoader;
        }
        if (this.catalina != null) {
            return this.catalina.getParentClassLoader();
        }
        return ClassLoader.getSystemClassLoader();
    }

    @Override
    public void setParentClassLoader(ClassLoader classLoader) {
        ClassLoader classLoader2 = this.parentClassLoader;
        this.parentClassLoader = classLoader;
        this.support.firePropertyChange("parentClassLoader", classLoader2, this.parentClassLoader);
    }

    @Override
    protected String getDomainInternal() {
        Service service;
        String string = null;
        Service[] serviceArray = this.findServices();
        if (serviceArray.length > 0 && (service = serviceArray[0]) != null) {
            string = service.getDomain();
        }
        return string;
    }

    @Override
    protected String getObjectNameKeyProperties() {
        return "type=Server";
    }
}

