
####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was Config.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

# Use original install prefix when loaded through a "/usr move"
# cross-prefix symbolic link such as /lib -> /usr/lib.
get_filename_component(_realCurr "${CMAKE_CURRENT_LIST_DIR}" REALPATH)
get_filename_component(_realOrig "/usr/lib/cmake/OpenColorIO" REALPATH)
if(_realCurr STREQUAL _realOrig)
  set(PACKAGE_PREFIX_DIR "/usr")
endif()
unset(_realOrig)
unset(_realCurr)

####################################################################################

include(CMakeFindDependencyMacro)

if (NOT ON) # NOT ON
    if (APPLE)
        # Store the previous value of CMAKE_FIND_FRAMEWORK and CMAKE_FIND_APPBUNDLE.
        set(_PREVIOUS_CMAKE_FIND_FRAMEWORK ${CMAKE_FIND_FRAMEWORK})
        set(_PREVIOUS_CMAKE_FIND_APPBUNDLE ${CMAKE_FIND_APPBUNDLE})

        # Prioritize other paths before Frameworks and Appbundle for find_path, find_library and 
        # find_package.
        set(CMAKE_FIND_FRAMEWORK LAST)
        set(CMAKE_FIND_APPBUNDLE LAST)
    endif()

    # Get the install directory.
    set(_IMPORT_PREFIX "${CMAKE_CURRENT_LIST_DIR}")
    # Get the install directory. Since the current file is under 
    # <install directory>/lib/cmake/OpenColorIO going back three directory.
    foreach(i RANGE 1 3)
        get_filename_component(_IMPORT_PREFIX "${_IMPORT_PREFIX}" PATH)
        if(_IMPORT_PREFIX STREQUAL "/")
        set(_IMPORT_PREFIX "")
        break()
        endif()
    endforeach()

    # Append OCIO custom find module path.
    list(APPEND CMAKE_MODULE_PATH "${_IMPORT_PREFIX}/share/OpenColorIO/cmake/modules")
    list(APPEND CMAKE_MODULE_PATH "${_IMPORT_PREFIX}/share/OpenColorIO/cmake/macros")

    ########################
    # Required dependencies 
    ########################

    if (NOT expat::expat)
        find_dependency(expat 2.5.0)
    endif()

    if (NOT Imath::Imath)
        find_dependency(Imath 3.1.7)
    endif()

    if (NOT pystring::pystring)
        find_dependency(pystring )
    endif()

    if (NOT yaml-cpp)
        find_dependency(yaml-cpp 0.7.0)
    endif()

    if (NOT ZLIB::ZLIB)
        # ZLIB_VERSION is available starting CMake 3.26+.
        # ZLIB_VERSION_STRING is still available for backward compatibility.
        # See https://cmake.org/cmake/help/git-stage/module/FindZLIB.html

        # ZLIB_USE_STATIC_LIBS is supported only from CMake 3.24+.
        if(${CMAKE_VERSION} VERSION_GREATER_EQUAL "3.24.0") 
            if (ZLIB_STATIC_LIBRARY)
                set(ZLIB_USE_STATIC_LIBS "${ZLIB_STATIC_LIBRARY}")
            endif()
        else() # For CMake < 3.24 since ZLIB_USE_STATIC_LIBS is not available.
            if(NOT ZLIB_LIBRARY)
                if(DEFINED CMAKE_FIND_LIBRARY_PREFIXES)
                    set(_ZLIB_ORIG_CMAKE_FIND_LIBRARY_PREFIXES "${CMAKE_FIND_LIBRARY_PREFIXES}")
                else()
                    set(_ZLIB_ORIG_CMAKE_FIND_LIBRARY_PREFIXES)
                endif()

                if(DEFINED CMAKE_FIND_LIBRARY_SUFFIXES)
                    set(_ZLIB_ORIG_CMAKE_FIND_LIBRARY_SUFFIXES "${CMAKE_FIND_LIBRARY_SUFFIXES}")
                else()
                    set(_ZLIB_ORIG_CMAKE_FIND_LIBRARY_SUFFIXES)
                endif()

                # Prefix/suffix for windows.
                if(WIN32)
                    list(APPEND CMAKE_FIND_LIBRARY_PREFIXES "" "lib")
                    list(APPEND CMAKE_FIND_LIBRARY_SUFFIXES ".dll.a")
                endif()

                # Check if static lib is preferred.
                if(ZLIB_STATIC_LIBRARY OR ZLIB_USE_STATIC_LIBS)
                    if(WIN32)
                        set(CMAKE_FIND_LIBRARY_SUFFIXES .lib .a ${CMAKE_FIND_LIBRARY_SUFFIXES})
                    else()
                        set(CMAKE_FIND_LIBRARY_SUFFIXES .a)
                    endif()
                endif()
            endif()
        endif()

        if () # 
            find_dependency(ZLIB )
        else()
            find_dependency(ZLIB 1.2.13)
        endif()

        # Restore the original find library ordering
        if(DEFINED _ZLIB_ORIG_CMAKE_FIND_LIBRARY_SUFFIXES)
            set(CMAKE_FIND_LIBRARY_SUFFIXES "${_ZLIB_ORIG_CMAKE_FIND_LIBRARY_SUFFIXES}")
        else()
            set(CMAKE_FIND_LIBRARY_SUFFIXES)
        endif()

        if(DEFINED _ZLIB_ORIG_CMAKE_FIND_LIBRARY_PREFIXES)
            set(CMAKE_FIND_LIBRARY_PREFIXES "${_ZLIB_ORIG_CMAKE_FIND_LIBRARY_PREFIXES}")
        else()
            set(CMAKE_FIND_LIBRARY_PREFIXES)
        endif()
    endif()

    if (NOT MINIZIP::minizip-ng)
        find_dependency(minizip-ng 3.0.8)
    endif()

    # Remove OCIO custom find module path.
    list(REMOVE_AT CMAKE_MODULE_PATH -1)

    if (APPLE)
        # Restore CMAKE_FIND_FRAMEWORK and CMAKE_FIND_APPBUNDLE values.
        set(CMAKE_FIND_FRAMEWORK ${_PREVIOUS_CMAKE_FIND_FRAMEWORK})
        set(CMAKE_FIND_APPBUNDLE ${_PREVIOUS_CMAKE_FIND_APPBUNDLE})
    endif()
endif()

include(${CMAKE_CURRENT_LIST_DIR}/OpenColorIOTargets.cmake)

include(FindPackageHandleStandardArgs)
set(OpenColorIO_CONFIG ${CMAKE_CURRENT_LIST_FILE})
find_package_handle_standard_args(OpenColorIO CONFIG_MODE)
